/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1992 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 source code is provided to you solely for       */
/*    the purpose of assisting you in your development of OS/2 device        */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Developer Connection Device Driver       */
/*    Source Kit for OS/2. This Copyright statement may not be removed.      */
/*                                                                           */
/*****************************************************************************/
/**************************************************************************
 *
 * SOURCE FILE NAME = DEVMODE.H
 *
 * DESCRIPTIVE NAME = plotter driver header
 *
 *
 * VERSION = V2.0
 *
 * DATE        12/12/88
 *
 * DESCRIPTION plotter driver header file
 *
 *
 * FUNCTIONS
 *
 *
 *
 * NOTES
 *
 *
 * STRUCTURES
 *
 * EXTERNAL REFERENCES
 *
 * EXTERNAL FUNCTIONS
 *
*/

#define  MSGBUFSIZE    80
#define  MAX_PENCOLORMENU 2            // # entries in pencolor menu

/*
**   The MENUSTAT structure is used to create status tables for popup menu.
** Each  popup menu item is associated with its menu ID in MenuItem and its
** display status in bStatus.  A true value will indicate the item is active,
** otherwise it is grayed.
*/

typedef struct
{
  SHORT MenuItem;
  BOOL bStatus;
} MENUSTAT;

typedef MENUSTAT *PMENUSTAT;

/*
**      The DEVMODE structure contains all the necessary information
**  required to process the dialog box.  Because multiple users may be
**  performing this function simultaneously,  storage for this structure
**  must be allocated PER INVOCATION,  otherwise confusion will result.
*/

typedef struct
{
  PPROFILEINFO  pSetup;
  USHORT        Plotter;
  USHORT        StringId;
  HAB           hAB;
  HWND          hWnd;
  HWND          hMenu;
  HMCB          hmcbHeap;
  LONG          lMaxDescender;
  SHORT         nPensSelected;
  SHORT         CurColor;
  SHORT         CurType;
  SHORT         PenOption;
  BOOL          bPenSelected[MAX_PENS];
  BOOL          bCancel;
  BOOL          bSelectAll;
  UCHAR         PenVariable;
  UCHAR         PenVarMax;
  UCHAR         PenVarMin;
  UCHAR         PenVarIncrement;
  UCHAR         PenValue[MAX_PENS];
  UCHAR         PenPriority[MAX_PENS];
//MENUSTAT      ColorMenu[MAX_COLORS+2];
  MENUSTAT      PenColorMenu[MAX_PENCOLORMENU];
  MENUSTAT      TypeMenu[MAX_PEN_TYPES+1];
  MENUSTAT      OptionsMenu[MAX_PEN_OPTIONS+1];
  PENOPTIONS    PenOptions;
  DEVICEINFO    DeviceInfo;
  CHAR          MessageBuffer[MSGBUFSIZE];
  // @MJH begin
  BOOL          bPrinterProperties;
  CHAR          achAppName[MAXAPPSIZE];
  PVOID         puflHead;
  HWND          hwndMainDlg;
  // @MJH end
} DEVMODE;
typedef DEVMODE *PDEVMODE;

extern ULONG main_dialog_proc ( HWND, USHORT, MPARAM, MPARAM );
extern ULONG options_dialog_proc ( HWND, USHORT, MPARAM, MPARAM );
extern ULONG priority_dialog_proc ( HWND, USHORT, MPARAM, MPARAM );
extern ULONG pencolor_dialog_proc ( HWND, USHORT, MPARAM, MPARAM );
extern ULONG OS2_DevPostDeviceModes ( PDRIVDATA, PSZ, PSZ, PSZ, ULONG );
extern VOID build_app_name (PSZ, PSZ, PSZ, PSZ );
extern VOID ReleaseHelpStubHook(VOID);
