/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1992 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 source code is provided to you solely for       */
/*    the purpose of assisting you in your development of OS/2 device        */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Developer Connection Device Driver       */
/*    Source Kit for OS/2. This Copyright statement may not be removed.      */
/*                                                                           */
/*****************************************************************************/
/**************************************************************************
 *
 * SOURCE FILE NAME = COLOR.H
 *
 * DESCRIPTIVE NAME = HEADER SOURCE FILE
 *
 *
 * VERSION = V2.0
 *
 * DATE        12/12/88
 *
 * DESCRIPTION PLOTTER DRIVER HEADER FILE
 *
 *
 * FUNCTIONS
 *
 *
 * NOTES
 *
 *
 * STRUCTURES
 *
 * EXTERNAL REFERENCES
 *
 * EXTERNAL FUNCTIONS
 *
*/
#define  USAGE_LINES             1
#define  USAGE_FILLS             2
#define  USAGE_TEXT              3
#define  USAGE_RFPEN             4     /* To return Pen for RF instruction  */

                                       /* 00RRGGBB - Red, Green, Blue       */
#define  COLOR_WHITE      0x00FFFFFFL  /* = CLR_BACKGROUND, 0x00FFFFFF      */
#define  COLOR_BLACK      0x00000000L  /* = CLR_NEUTRAL, 0x00000000         */
#define  COLOR_RED        0x00FF0000L  /* = CLR_RED, 0x00FF0000             */
#define  COLOR_GREEN      0x0000FF00L  /* = CLR_GREEN, 0x0000FF00           */
#define  COLOR_YELLOW     0x00FFFF00L  /* = CLR_YELLOW, 0x00FFFF00          */
#define  COLOR_BLUE       0x000000FFL  /* = CLR_BLUE, 0x000000FF            */
#define  COLOR_PINK       0x00FF00FFL  /* = CLR_PINK, 0x00FF00FF            */
#define  COLOR_CYAN       0x0000FFFFL  /* = CLR_CYAN, 0x0000FFFF            */
#define  COLOR_ORANGE     0x00FF8000L  /*                                   */
#define  COLOR_VIOLET     0x008000FFL  /*                                   */
#define  COLOR_BROWN      0x00808000L  /* = CLR_BROWN, 0x00808000           */
#define  COLOR_PALEGRAY   0x00CCCCCCL  /* = CLR_PALEGRAY, 0x00CCCCCC        */
#define  COLOR_DARKBLUE   0x00000080L  /* = CLR_DARKBLUE, 0x00000080        */
#define  COLOR_DARKRED    0x00800000L  /* = CLR_DARKRED, 0x00800000         */
#define  COLOR_DARKPINK   0x00800080L  /* = CLR_DARKPINK, 0x00800080        */
#define  COLOR_DARKGREEN  0x00008000L  /* = CLR_DARKGREEN, 0x00008000       */
#define  COLOR_DARKCYAN   0x00008080L  /* = CLR_DARKCYAN, 0x00008080        */
#define  COLOR_DARKGRAY   0x00808080L  /* = CLR_DARKGRAY, 0x00808080        */

#define  COLOR_LIGHTGRAY  0x00E1E1E1L  /* =                                 */
#define  COLOR_REDGRAY    0x00E29F9FL  /* =                                 */
#define  COLOR_GREENGRAY  0x009FFF9FL  /* =                                 */
#define  COLOR_BLUEGRAY   0x009F9FFFL  /* =                                 */

#define   COLOR_BLUSH                      0xFF80B5
#define   COLOR_LIGHTRED                   0xFF528F
#define   COLOR_CRIMSON                    0xBA000A
#define   COLOR_BRICKRED                   0x7D0000
#define   COLOR_BRICKGRAY                  0x553535

#define   COLOR_SAND                       0xFFD1BF
#define   COLOR_SALMON                     0xFFA385
#define   COLOR_PUMPKIN                    0xFF6929
#define   COLOR_CHESTNUT                   0xC22600
#define   COLOR_SIENNABROWN                0x910000

#define   COLOR_TAN                        0xB27252
#define   COLOR_DARKTAN                    0x714C31
#define   COLOR_BUFF                       0xFFED66
#define   COLOR_LIGHTPEACH                 0xFFC942
#define   COLOR_DARKPEACH                  0xFFA800

#define   COLOR_LIGHTBROWN                 0xDE8700
#define   COLOR_DARKBROWN                  0x804000
#define   COLOR_IVORY                      0x856A3A
#define   COLOR_DARKIVORY                  0x654025

#define   COLOR_PARCHMENT                  0xFFFFB0
#define   COLOR_PALEYELLOW                 0xFFFF80
#define   COLOR_GOLD                       0xCFCF00
#define   COLOR_DARKGOLD                   0xABAB00
#define   COLOR_UMBER                      0x8A8A00

#define   COLOR_STRAW                      0x8A8A60
#define   COLOR_DARKSTRAW                  0x555535
#define   COLOR_PALEGREEN                  0xB5FFAD
#define   COLOR_LIGHTGREEN                 0x80FF85
#define   COLOR_LEAFGREEN                  0x5CFF5C

#define   COLOR_DEEPGREEN                  0x007000
#define   COLOR_MOSS                       0x517135
#define   COLOR_DARKMOSS                   0x49692D
#define   COLOR_MINTGREEN                  0xC7FFD9
#define   COLOR_SEAGREEN                   0x99FFC2

#define   COLOR_LIGHTEMERALD               0x57FFA8
#define   COLOR_EMERALD                    0x17FF96
#define   COLOR_DARKEMERALD                0x00D463
#define   COLOR_EVERGREEN                  0x009E24
#define   COLOR_DARKGREENGRAY              0x355535

#define   COLOR_SEAFOAM                    0xB8FFE6
#define   COLOR_LIGHTAQUA                  0x91FFE3
#define   COLOR_AQUA                       0x5EFFDE
#define   COLOR_TURQUOISE                  0x009978
#define   COLOR_SPRUCE                     0x007D70

#define   COLOR_SEAGRAY                    0x608A70
#define   COLOR_SPRUCEGRAY                 0x355555
#define   COLOR_PASTELBLUE                 0x8FFFED
#define   COLOR_BABYBLUE                   0x5EFFF7
#define   COLOR_SKYBLUE                    0x33FFFF

#define   COLOR_CERULEAN                   0x00A1FF
#define   COLOR_TRUEBLUE                   0x0061BD
#define   COLOR_SLATEBLUE                  0x005954
#define   COLOR_COOLGRAY                   0x3D6377
#define   COLOR_COLDGRAY                   0x254565

#define   COLOR_ICEBLUE                    0xB8EBFF
#define   COLOR_CORNFLOWER                 0x9ED9FF
#define   COLOR_DUSTYBLUE                  0x5EA8FF
#define   COLOR_ROYALBLUE                  0x4982FF
#define   COLOR_FLAGBLUE                   0x080FFF

#define   COLOR_MIDNIGHTBLUE               0x000073
#define   COLOR_DARKBLUEGRAY               0x353555
#define   COLOR_LAVENDAR                   0xDECFFF
#define   COLOR_DARKLAVENDAR               0xB8A6FF
#define   COLOR_LILAC                      0x8069FF

#define   COLOR_DARKVIOLET                 0x4700FF
#define   COLOR_INDIGO                     0x00008C
#define   COLOR_LILACGRAY                  0x676796
#define   COLOR_VIOLETGRAY                 0x4C3370
#define   COLOR_PURPLEWASH                 0xF5BFFF

#define   COLOR_PALEPURPLE                 0xD68FFF
#define   COLOR_LIGHTPURPLE                0xBF66FF
#define   COLOR_PURPLE                     0x9930FF
#define   COLOR_GRAPE                      0x8200FF
#define   COLOR_DARKGRAPE                  0x1D00A8

#define   COLOR_LIGHTPURPLEGRAY            0x65408A
#define   COLOR_PURPLEGRAY                 0x452565
#define   COLOR_PALEPINK                   0xFF99FF
#define   COLOR_HOTPINK                    0xFF66FF
#define   COLOR_LIGHTMAGENTA               0xF242FF

#define   COLOR_MAGENTA                    0xF000FF
#define   COLOR_DARKMAGENTA                0xC900FF
#define   COLOR_PLUM                       0x870087
#define   COLOR_LIGHTPLUMGRAY              0x6B3C6B
#define   COLOR_PLUMGRAY                   0x45254D

#define   COLOR_PALEROSE                   0xFFB0FA
#define   COLOR_LIGHTROSE                  0xFF5EFF
#define   COLOR_ROSE                       0xFF30FF
#define   COLOR_DARKROSE                   0xFF00C9
#define   COLOR_BURGUNDY                   0xAB006B

#define   COLOR_DARKBURGUNDY               0x85004D
#define   COLOR_SANDSTONE                  0x8A6072
#define   COLOR_DARKSANDSTONE              0x552B40
#define   COLOR_D3PCTGRAY                  0xF7F7F7
#define   COLOR_D6PCTGRAY                  0xEFEFEF

#define   COLOR_D13PCTGRAY                 0xDFDFDF
#define   COLOR_D19PCTGRAY                 0xCFCFCF
#define   COLOR_D31PCTGRAY                 0xAFAFAF
#define   COLOR_D38PCTGRAY                 0x9F9F9F
#define   COLOR_D44PCTGRAY                 0x8F8F8F

#define   COLOR_D56PCTGRAY                 0x6F6F6F
#define   COLOR_D63PCTGRAY                 0x5F5F5F
#define   COLOR_D69PCTGRAY                 0x4F4F4F
#define   COLOR_D75PCTGRAY                 0x3F3F3F
#define   COLOR_D81PCTGRAY                 0x2F2F2F

#define   IDX_YELLOW                      1
#define   IDX_ORANGE                      2
#define   IDX_RED                         3
#define   IDX_GREEN                       4
#define   IDX_RED_VIOLET                  5
#define   IDX_CYAN                        6
#define   IDX_VIOLET                      7
#define   IDX_BLUE                        8
#define   IDX_BROWN                       9
#define   IDX_BLACK                      10
#define   IDX_WHITE                      11
#define   IDX_GRAY                       12
#define   IDX_DARKBLUE                   13
#define   IDX_DARKRED                    14
#define   IDX_DARKPINK                   15
#define   IDX_DARKGREEN                  16
#define   IDX_DARKCYAN                   17
#define   IDX_DARKGRAY                   18
#define   IDX_LIGHTGRAY                  19
#define   IDX_REDGRAY                    20
#define   IDX_GREENGRAY                  21
#define   IDX_BLUEGRAY                   22
#define   IDX_BLUSH                      23
#define   IDX_LIGHTRED                   24
#define   IDX_CRIMSON                    25
#define   IDX_BRICKRED                   26
#define   IDX_BRICKGRAY                  27
#define   IDX_SAND                       28
#define   IDX_SALMON                     29
#define   IDX_PUMPKIN                    30
#define   IDX_CHESTNUT                   31
#define   IDX_SIENNABROWN                32
#define   IDX_TAN                        33
#define   IDX_DARKTAN                    34
#define   IDX_BUFF                       35
#define   IDX_LIGHTPEACH                 36
#define   IDX_DARKPEACH                  37
#define   IDX_LIGHTBROWN                 38
#define   IDX_DARKBROWN                  39
#define   IDX_IVORY                      30
#define   IDX_DARKIVORY                  41
#define   IDX_PARCHMENT                  42
#define   IDX_PALEYELLOW                 43
#define   IDX_GOLD                       44
#define   IDX_DARKGOLD                   45
#define   IDX_UMBER                      46
#define   IDX_STRAW                      47
#define   IDX_DARKSTRAW                  48
#define   IDX_PALEGREEN                  49
#define   IDX_LIGHTGREEN                 40
#define   IDX_LEAFGREEN                  51
#define   IDX_DEEPGREEN                  52
#define   IDX_MOSS                       53
#define   IDX_DARKMOSS                   54
#define   IDX_MINTGREEN                  55
#define   IDX_SEAGREEN                   56
#define   IDX_LIGHTEMERALD               57
#define   IDX_EMERALD                    58
#define   IDX_DARKEMERALD                59
#define   IDX_EVERGREEN                  50
#define   IDX_DARKGREENGRAY              61
#define   IDX_SEAFOAM                    62
#define   IDX_LIGHTAQUA                  63
#define   IDX_AQUA                       64
#define   IDX_TURQUOISE                  65
#define   IDX_SPRUCE                     66
#define   IDX_SEAGRAY                    67
#define   IDX_SPRUCEGRAY                 68
#define   IDX_PASTELBLUE                 69
#define   IDX_BABYBLUE                   60
#define   IDX_SKYBLUE                    71
#define   IDX_CERULEAN                   72
#define   IDX_TRUEBLUE                   73
#define   IDX_SLATEBLUE                  74
#define   IDX_COOLGRAY                   75
#define   IDX_COLDGRAY                   76
#define   IDX_ICEBLUE                    77
#define   IDX_CORNFLOWER                 78
#define   IDX_DUSTYBLUE                  79
#define   IDX_ROYALBLUE                  70
#define   IDX_FLAGBLUE                   81
#define   IDX_MIDNIGHTBLUE               82
#define   IDX_DARKBLUEGRAY               83
#define   IDX_LAVENDAR                   84
#define   IDX_DARKLAVENDAR               85
#define   IDX_LILAC                      86
#define   IDX_DARKVIOLET                 87
#define   IDX_INDIGO                     88
#define   IDX_LILACGRAY                  89
#define   IDX_VIOLETGRAY                 80
#define   IDX_PURPLEWASH                 91
#define   IDX_PALEPURPLE                 92
#define   IDX_LIGHTPURPLE                93
#define   IDX_PURPLE                     94
#define   IDX_GRAPE                      95
#define   IDX_DARKGRAPE                  96
#define   IDX_LIGHTPURPLEGRAY            97
#define   IDX_PURPLEGRAY                 98
#define   IDX_PALEPINK                   99
#define   IDX_HOTPINK                    90
#define   IDX_LIGHTMAGENTA              101
#define   IDX_MAGENTA                   102
#define   IDX_DARKMAGENTA               103
#define   IDX_PLUM                      104
#define   IDX_LIGHTPLUMGRAY             105
#define   IDX_PLUMGRAY                  106
#define   IDX_PALEROSE                  107
#define   IDX_LIGHTROSE                 108
#define   IDX_ROSE                      109
#define   IDX_DARKROSE                  110
#define   IDX_BURGUNDY                  111
#define   IDX_DARKBURGUNDY              112
#define   IDX_SANDSTONE                 113
#define   IDX_DARKSANDSTONE             114
#define   IDX_D3PCTGRAY                 115
#define   IDX_D6PCTGRAY                 116
#define   IDX_D13PCTGRAY                117
#define   IDX_D19PCTGRAY                118
#define   IDX_D31PCTGRAY                119
#define   IDX_D38PCTGRAY                120
#define   IDX_D44PCTGRAY                121
#define   IDX_D56PCTGRAY                122
#define   IDX_D63PCTGRAY                123
#define   IDX_D69PCTGRAY                124
#define   IDX_D75PCTGRAY                125
#define   IDX_D81PCTGRAY                126

/*
** defines for set_mix_mode
*/
#define  MIX_NONE             0x00     /* do not set mix                    */
#define  MIX_FOREGROUND       0x01     /* use foreground mix                */
#define  MIX_BACKGROUND       0x02     /* use background mix                */
#define  MIX_ROP              0x04     /* use mix mode as the ROP           */
#define  MIX_NORESET          0x10     /* do not retset the rop back to 252 */

extern LONG ColorList[MAX_COLORS];
extern ULONG ulDefaultPalette256[256];
extern ULONG ulDefaultPalette16[16];

/*
**  A color in HLS form.
*/
typedef struct
{
  int Hue,        Lightness,      Saturation;
} HLSBLOCK;

typedef HLSBLOCK *PHLSBLOCK;

extern LONG CreateLogColorTable  (  HDC, ULONG, ULONG, LONG, LONG,
                                               PULONG, PDDC, ULONG );
extern LONG QueryColorData ( HDC, LONG, PLONG, PDDC, ULONG );
extern LONG QueryColorIndex ( HDC, ULONG, LONG, PDDC, ULONG );
extern LONG QueryLogColorTable  (  HDC,  ULONG,  LONG,  LONG,
                                   PLONG, PDDC,  ULONG  );
extern LONG QueryNearestColor ( HDC, ULONG, LONG, PDDC, ULONG );
extern LONG QueryRealColors ( HDC, ULONG, LONG, LONG, PLONG, PDDC,
                              ULONG );
extern LONG QueryRGBColor ( HDC, ULONG, LONG, PDDC, ULONG );
extern LONG RealizeColorTable ( HDC, PDDC, ULONG );
extern LONG UnrealizeColorTable ( HDC, PDDC, ULONG );
extern LONG DevicePalette( HDC, PHWPALETTEINFO, PDDC, ULONG );


extern BOOL check_area_color ( PDDC );
extern BOOL check_area_background_color ( PDDC );
extern BOOL check_char_color ( PDDC, LONG );
extern BOOL check_char_background_color ( PDDC, LONG, USHORT );
extern BOOL check_line_color ( PDDC );
extern BOOL check_marker_color ( PDDC );
extern LONG convert_color(PDDC,LONG);
extern BOOL create_default_color_table ( PDDC );
extern USHORT select_fill_pen ( PDDC, LONG );
extern USHORT select_text_pen ( PDDC, LONG );
extern USHORT select_line_pen ( PDDC, LONG );
extern VOID start_color_sorting ( PDDC, HDC );
extern VOID stop_color_sorting ( PDDC, HDC );
extern VOID set_HPGL2_color_palette ( PDDC );
extern BOOL set_transparency_mode(PDDC, SHORT);
extern BOOL set_pixel_placement(PDDC, SHORT);
extern BOOL set_mix_mode(PDDC, ULONG, USHORT, USHORT, USHORT);
extern VOID set_pen(PDDC,SHORT,LONG,ULONG);
extern BOOL setup_raster_fill_index(HDC,PDDC,PRGB2,PBMAPINFO);
extern BOOL check_color_sorting(PDDC,LONG,USHORT);


#if      FILLOPTBOX
extern VOID select_fill_type ( PDDC, USHORT, PPOINTL, PPOINTL );
#define  PATSYM_USERDEFINED     100    /* Needed to update the currentpattern
                                          symbol in pPDevice.  Kran         */
/* #else                              */
/*  #define  select_fill_type(a,b,c)  */
#endif
