/* REXX
*/
SIGNAL ON HALT NAME fHalt

parse arg szCountry szBuildRoot szZipRoot .

if szCountry = "" then
   szCountry = "en"

/* Grab the program's path */
parse source . . szSrc
szSrcPath = filespec( 'drive', szSrc )
szSrcPath = szSrcPath || filespec( 'path', szSrc )
szSrcPath = translate( szSrcPath )
if substr( szSrcPath, length( szSrcPath ), 1 ) = "\" then
   szSrcPath = substr( szSrcPath, 1, length( szSrcPath ) - 1 )

if szBuildRoot = "" then
   szRoot = filespec( 'drive', szSrcPath )
else
   szRoot = szBuildRoot
szRoot = szRoot'\'word( translate( filespec( 'path', szSrcPath ), ' ', '\' ), 1 )

if szZipRoot = "" then
   szZipRoot = "f:\"

szCurDir = directory( )
szNewDir = directory( szRoot )

szArgs =        "zip -r "szZipRoot"omni"
szArgs = szArgs "src/osdd/r206/*"
szArgs = szArgs "src/osdd/common/*"
szArgs = szArgs "src/osdd/omni/*"
szArgs = szArgs "src/osdd/genplib/*"
szArgs = szArgs "mri/en/osdd/drvmri/*"
szArgs = szArgs "mri/en/osdd/omni/*"

select
   when szCountry = "ar" then nop
   when szCountry = "bg" then nop
   when szCountry = "br" then nop
   when szCountry = "ca" then nop
   when szCountry = "cn" then nop
   when szCountry = "cz" then nop
   when szCountry = "de" then nop
   when szCountry = "dk" then nop
   when szCountry = "en" then nop
   when szCountry = "es" then nop
   when szCountry = "fi" then nop
   when szCountry = "fr" then nop
   when szCountry = "gk" then nop
   when szCountry = "he" then nop
   when szCountry = "hu" then nop
   when szCountry = "it" then nop
   when szCountry = "jp" then nop
   when szCountry = "ko" then nop
   when szCountry = "nl" then nop
   when szCountry = "no" then nop
   when szCountry = "pl" then nop
   when szCountry = "pt" then nop
   when szCountry = "ru" then nop
   when szCountry = "sl" then nop
   when szCountry = "sv" then nop
   when szCountry = "tr" then nop
   when szCountry = "tw" then nop
   otherwise
   do
      say "Unknown country code" szCountry
      exit
   end
end

if szCountry \= "en" then
do
   szArgs = szArgs "mri/"szCountry"/osdd/drvmri/*"
   szArgs = szArgs "mri/"szCountry"/osdd/omni/*"
end

'del 'szZipRoot'omni.zip > nul 2>&1'

szArgs

szArgs =        "zip -r "szZipRoot"omni"
szArgs = szArgs "rel/os2c/retail/en/os2/drivers/omni/*"

if szCountry \= "en" then
do
   szArgs = szArgs "rel/os2c/retail/"szCountry"/os2/drivers/omni/*"
end

szArgs

fHalt:

szNewDir = directory( szCurDir )

exit
