/* REXX
** Ex usage: zipddk f:\ f: z:\cosdd\ jp
**                  ^   ^  ^         ^
**                                 NLV version (optional)
**                        Network build tree (as backup for genplib)
**                      Local build tree
**                   Location of target zip file
**
** NOTE: the name of the zip file will be ddk.zip
*/
SIGNAL ON HALT NAME fHalt

call rxfuncadd 'sysloadfuncs', 'rexxutil', 'sysloadfuncs'
call sysloadfuncs

parse arg szZipRoot szSourceRoot szBuildRoot szCountry .

/* Grab the program's path */
parse source . . szSrc
szSrcPath = filespec( 'drive', szSrc )
szSrcPath = szSrcPath || filespec( 'path', szSrc )
szSrcPath = translate( szSrcPath )
if substr( szSrcPath, length( szSrcPath ), 1 ) = "\" then
   szSrcPath = substr( szSrcPath, 1, length( szSrcPath ) - 1 )

if szZipRoot = "" then
   szZipRoot = "f:\"

if szSourceRoot = "" then
   szRoot = filespec( 'drive', szSrcPath )
else
   szRoot = szSourceRoot
szRoot = szRoot'\'word( translate( filespec( 'path', szSrcPath ), ' ', '\' ), 1 )

if szBuildRoot = "" then
   szBuildRoot = "m:/cosdd/"

select
   when szCountry = "ar" then nop
   when szCountry = "bg" then nop
   when szCountry = "br" then nop
   when szCountry = "ca" then nop
   when szCountry = "cn" then nop
   when szCountry = "cz" then nop
   when szCountry = "de" then nop
   when szCountry = "dk" then nop
   when szCountry = "en" then nop
   when szCountry = "es" then nop
   when szCountry = "fi" then nop
   when szCountry = "fr" then nop
   when szCountry = "gk" then nop
   when szCountry = "he" then nop
   when szCountry = "hu" then nop
   when szCountry = "it" then nop
   when szCountry = "jp" then nop
   when szCountry = "ko" then nop
   when szCountry = "nl" then nop
   when szCountry = "no" then nop
   when szCountry = "pl" then nop
   when szCountry = "pt" then nop
   when szCountry = "ru" then nop
   when szCountry = "sl" then nop
   when szCountry = "sv" then nop
   when szCountry = "tr" then nop
   when szCountry = "tw" then nop
   otherwise
   do
      say "Unknown country code" szCountry
      exit
   end
end

szCurDir = directory( )
szNewDir = directory( szRoot )

'del 'szZipRoot'ddk.zip   > nul 2>&1'
'del 'szZipRoot'ddk'szCountry'.zip > nul 2>&1'

/* if test
signal test
*/

szArgs =        "zip "szZipRoot"ddk"
szArgs = szArgs "src/osdd/common/*"
szArgs = szArgs "src/osdd/common/include/*"
szArgs = szArgs "src/osdd/common/lib/*"
szArgs = szArgs "src/osdd/common/tools/*"

szArgs

szArgs =        "zip "szZipRoot"ddk"
szArgs = szArgs "src/osdd/omni/*"
szArgs = szArgs "src/osdd/omni/devices/tiff.c"
szArgs = szArgs "src/osdd/omni/devices/samp_pcl.c"
szArgs = szArgs "src/osdd/omni/devices/samp_eps.c"
szArgs = szArgs "src/osdd/omni/resource/color.ico"
szArgs = szArgs "src/osdd/omni/resource/dplxbook.ico"
szArgs = szArgs "src/osdd/omni/resource/dplxflip.ico"
szArgs = szArgs "src/osdd/omni/resource/dplxone.ico"
szArgs = szArgs "src/osdd/omni/resource/gamma.bmp"
szArgs = szArgs "src/osdd/omni/resource/landscap.ico"
szArgs = szArgs "src/osdd/omni/resource/portrait.ico"
szArgs = szArgs "src/osdd/omni/bandview/*"
szArgs = szArgs "src/osdd/omni/docs/*"

szArgs

szArgs =        "zip -d "szZipRoot"ddk"
szArgs = szArgs "src/osdd/omni/checkin.cmd/"
szArgs = szArgs "src/osdd/omni/color/"
szArgs = szArgs "src/osdd/omni/docs/*.pdf"
szArgs = szArgs "src/osdd/omni/errors"
szArgs = szArgs "src/osdd/omni/ko/"
szArgs = szArgs "src/osdd/omni/rone/"
szArgs = szArgs "src/osdd/omni/save/"
szArgs = szArgs "src/osdd/omni/simon"
szArgs = szArgs "src/osdd/omni/tags.slk"
szArgs = szArgs "src/osdd/omni/tags/tags.vtg"
szArgs = szArgs "src/osdd/omni/tags/"
szArgs = szArgs "src/osdd/omni/tmp/"

szArgs

szArgs =        "zip -r "szZipRoot"ddk"
szArgs = szArgs "src/osdd/genplib/*.h"
szArgs = szArgs "obj/os2c/r206/*"

szArgs

/* test: */
szArgs =        "zip -r "szZipRoot"ddk"

aFiles.0  = 12
aFiles.1  = "obj/os2c/debug/osdd/genplib/en/genplib.lib"
aFiles.2  = "obj/os2c/retail/osdd/genplib/en/genplib.lib"
aFiles.3  = "rel/os2c/debug/en/os2/drivers/genplib.dll"
aFiles.4  = "rel/os2c/debug/en/os2/drivers/genplib.sym"
aFiles.5  = "rel/os2c/retail/en/os2/drivers/genplib.dll"
aFiles.6  = "rel/os2c/retail/en/os2/drivers/genplib.sym"

aFiles.7  = "obj/os2c/debug/osdd/genplib/en/genplibv.lib"
aFiles.8  = "obj/os2c/retail/osdd/genplib/en/genplibv.lib"
aFiles.9  = "rel/os2c/debug/en/os2/drivers/genplibv.dll"
aFiles.10 = "rel/os2c/debug/en/os2/drivers/genplibv.sym"
aFiles.11 = "rel/os2c/retail/en/os2/drivers/genplibv.dll"
aFiles.12 = "rel/os2c/retail/en/os2/drivers/genplibv.sym"

/* if test
trace ?i
*/
do i = 1 to aFiles.0

   if fExists( szRoot'\'aFiles.i ) then
      /* Grab locally */
      szArgs = szArgs aFiles.i
   else if szBuildRoot \= ""                &,
           fExists( szBuildRoot||aFiles.i ) then
      /* Grab off of the build server */
      szArgs = szArgs szBuildRoot||aFiles.i
end

szArgs

if szCountry \= "en" then
do
   /* test: */
   szArgs =        "zip -r "szZipRoot"ddk"szCountry

   aFiles.0  = 12
   aFiles.1  = "obj/os2c/debug/osdd/genplib/"szCountry"/genplib.lib"
   aFiles.2  = "obj/os2c/retail/osdd/genplib/"szCountry"/genplib.lib"
   aFiles.3  = "rel/os2c/debug/"szCountry"/os2/drivers/genplib.dll"
   aFiles.4  = "rel/os2c/debug/"szCountry"/os2/drivers/genplib.sym"
   aFiles.5  = "rel/os2c/retail/"szCountry"/os2/drivers/genplib.dll"
   aFiles.6  = "rel/os2c/retail/"szCountry"/os2/drivers/genplib.sym"

   aFiles.7  = "obj/os2c/debug/osdd/genplib/"szCountry"/genplibv.lib"
   aFiles.8  = "obj/os2c/retail/osdd/genplib/"szCountry"/genplibv.lib"
   aFiles.9  = "rel/os2c/debug/"szCountry"/os2/drivers/genplibv.dll"
   aFiles.10 = "rel/os2c/debug/"szCountry"/os2/drivers/genplibv.sym"
   aFiles.11 = "rel/os2c/retail/"szCountry"/os2/drivers/genplibv.dll"
   aFiles.12 = "rel/os2c/retail/"szCountry"/os2/drivers/genplibv.sym"

   /* if test
   trace ?i
   */
   do i = 1 to aFiles.0

      if fExists( szRoot'\'aFiles.i ) then
         /* Grab locally */
         szArgs = szArgs aFiles.i
      else if szBuildRoot \= ""                &,
              fExists( szBuildRoot||aFiles.i ) then
         /* Grab off of the build server */
         szArgs = szArgs szBuildRoot||aFiles.i
   end

   szArgs
end

szArgs =        "zip -r "szZipRoot"ddk"
szArgs = szArgs "mri/en/osdd/drvmri/*"

szArgs

if szCountry \= "en" then
do
   szArgs =        "zip -r "szZipRoot"ddk"szCountry
   szArgs = szArgs "mri/"szCountry"/osdd/drvmri/*"

   szArgs
end

szArgs =        "zip "szZipRoot"ddk"
szArgs = szArgs "mri/en/osdd/omni/omni.*"

szArgs

if szCountry \= "en" then
do
   szArgs =        "zip "szZipRoot"ddk"szCountry
   szArgs = szArgs "mri/"szCountry"/osdd/omni/omni.*"

   szArgs
end

fHalt:

szNewDir = directory( szCurDir )

exit

/*********************************************************************************************************/
fExists: arg szFile

szFile = translate( szFile, '\', '/' )

rc = SysFileTree( szFile, 'aFile', 'F' )
if aFile.0 = 1 then
   return 1
else
   return 0
