/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1992 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 source code is provided to you solely for       */
/*    the purpose of assisting you in your development of OS/2 device        */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Developer Connection Device Driver       */
/*    Source Kit for OS/2. This Copyright statement may not be removed.      */
/*                                                                           */
/*****************************************************************************/
#pragma pack(1)

//-------------------------------------
// External Form Information Structures
//-------------------------------------
#define SIZEOF_EXTTRAYINFO_1_1             92  // can't switch sizeof

typedef struct _Extern_TrayInfo_1_1 {      // sizeof == 92
   ULONG         ulTrayID;                 //
   ULONG         ulTrayCap;                // Tray Capabilities (auto-sensing,
                                           //    optional) TRAY_CAP_XXX
   ULONG         ulNameID;                 //
   CHAR          szTrayName[32];           //
   ULONG         ulTrayType;               //
   ULONG         ulCmdSelectTray;          // Length of following
   CHAR          szCmdSelectTray[32];      // Printer tray command
   ULONG         ulCompatibleForms;        // # of forms tray supports
   PULONG        pulCompatibleForms;       // array of forms this tray can hold
} EXTTRAYINFO_1_1, *PEXTTRAYINFO_1_1, **PPEXTTRAYINFO_1_1;

#define SIZEOF_EXTTRAYINFO_1_5             96  // can't switch sizeof

typedef struct _Extern_TrayInfo_1_5 {      // sizeof == 96
   ULONG         ulTrayID;                 //
   ULONG         ulTrayCap;                // Tray Capabilities (auto-sensing,
                                           //    optional) TRAY_CAP_XXX
   BYTE          ulDJPid;                  // DJP_SJ_TRAYTYPE id
   BYTE          abPadding[3];             // ***PADDING***
   ULONG         ulNameID;                 //
   CHAR          szTrayName[32];           //
   ULONG         ulTrayType;               //
   ULONG         ulCmdSelectTray;          // Length of following
   CHAR          szCmdSelectTray[32];      // Printer tray command
   ULONG         ulCompatibleForms;        // # of forms tray supports
   PULONG        pulCompatibleForms;       // array of forms this tray can hold
} EXTTRAYINFO_1_5, *PEXTTRAYINFO_1_5, **PPEXTTRAYINFO_1_5;

#define SIZEOF_EXTTRAYINFO_1_21            108  // can't switch sizeof

typedef struct _Extern_TrayInfo_1_21 {     // sizeof == 108
   ULONG         ulTrayID;                 //
   ULONG         ulTrayCap;                // Tray Capabilities (auto-sensing,
                                           //    optional) TRAY_CAP_XXX
   BYTE          ulDJPid;                  // DJP_SJ_TRAYTYPE id
   BYTE          abPadding[3];             // ***PADDING***
   ULONG         ulNameID;                 //
   CHAR          szTrayName[32];           //
   ULONG         ulTrayType;               //
   ULONG         ulCmdSelectTray;          // Length of following
   CHAR          szCmdSelectTray[44];      // Printer tray command
   ULONG         ulCompatibleForms;        // # of forms tray supports
   PULONG        pulCompatibleForms;       // array of forms this tray can hold
} EXTTRAYINFO_1_21, *PEXTTRAYINFO_1_21, **PPEXTTRAYINFO_1_21;

// printer property app/keynames
#define KEYNAME_NUM_USER_TRAYS          "NumUserDefTrays"
#define KEYNAME_USER_TRAYS              "UserDefTrays"
#define KEYNAME_VERSION_KEY_USER_TRAYS  "VersionUserDefTrays"
#define KEYNAME_VERSION_DATA_USER_TRAYS "1.1"

/* this is the version that we save to the ini file! */
typedef struct _Extern_TrayInfo_1_1 EXTTRAYINFOSAVE, *PEXTTRAYINFOSAVE;
