/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1992 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 source code is provided to you solely for       */
/*    the purpose of assisting you in your development of OS/2 device        */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Developer Connection Device Driver       */
/*    Source Kit for OS/2. This Copyright statement may not be removed.      */
/*                                                                           */
/*****************************************************************************/
// surface.c

// contains the mandatory function QueryDeviceSurface() for the GRE to obtain default handling information

#define INCL_WINMENUS
#define INCL_DOS
#define INCL_GPI
#define INCL_DEV
#define INCL_SPL
#define INCL_SPLDOSPRINT
#include <os2.h>

#define INCL_VMANDDI
#include <ddi.h>

#define INCL_GREALL
#define INCL_DDIMISC
#define INCL_DDIPATHS
#define INCL_GRE_DEVMISC3
#include <pmddi.h>

#define INCL_GENPLIB_PATTERNS
#define INCL_GENPLIB_GPLGRE
#include <genplib.h>

// c includes
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <setjmp.h>

#include "def.h"
#include "driver.h"
#include "funcs.h"

// ---------------------------------------------------------------------------
LONG APIENTRY
QueryDeviceSurface (PDDC pddc, PVOID pv)
{
   PDEVICESURFACE     pds  = pv;
   PDEVICEBLOCK       pdb  = pddc->pdb;
   REGREC             regrec;
   ULONG              ulException;
   ULONG              lrc;
   int                i;

   assertF (pds);

   REGISTERHANDLER (regrec, globals.hModule);
   ulException = setjmp (regrec.jmp);
   if (ulException)
   {
      // clean up here as required
      CheckForTermination (&regrec, ulException, 0);
      // error result: any non-zero is error
      lrc = -1;
      goto depart;
   }

   DBPRINTF (("QueryDeviceSurface:>>>>>>>>>>>\n"));

   // memory holding device surface data structure was allocated by GRE
   // store this pointer in my ddc
   pdb->pDeviceSurface = pds;

   // needs work: I have to do this?
   pds->ulLength = sizeof (DEVICESURFACE);

   // DEVICE_SPECIFIC: depends on origin on hardcopy device
   pds->ulDSFlgs  = DS_BOTTOMTOP | DS_DWORDALIGN | DS_KEEP_EXTFORMAT;
   pds->ulStyleRatio = MAKEUSHORT (0x40, 0x40);

   // DEVICE_SPECIFIC: copy device capabilities from pddc to GRE's device surface structure
   for (i = 0; i < CAPS_MAX_CAPS; i++)
      InnerQueryCaps (i, (PLONG)&pds->DevCaps[i], NULL, pdb);
   pds->ulCapsCnt = CAPS_MAX_CAPS;

   // these are provided by new gre to lock and get attributes
   // pds->pfnDevLockDC
   // pds->pfnDevUnLockDC

   // put my lock/unlock pfn in here -- now NOP's
   pds->pfnLockPhysDev   = (PFN)LockDevice;
   pds->pfnUnLockPhysDev = (PFN)UnlockDevice;

   // NEEDS WORK!  ALWAYS FALSE! should have a hw palette by now
///assert (pds->pHWPalette);

   // set default surface bitmap info
   pds->SurfaceBmapInfo.ulLength       = sizeof (BMAPINFO);
   pds->SurfaceBmapInfo.ulType         = 0; // Coop says "don't set anything!"
   pds->SurfaceBmapInfo.ulWidth        = 0;
   pds->SurfaceBmapInfo.ulHeight       = 0;
   pds->SurfaceBmapInfo.ulBpp          = pdb->pPrintMode->usBitsPerPel;
   pds->SurfaceBmapInfo.ulBytesPerLine = 0;
   pds->SurfaceBmapInfo.pBits          = NULL;

   if (!pddc->pdb->bAllocatedPatterns)
   {
      ULONG ulFlip;

      // Need to invert pattern bitmaps if DS_BOTTOMTOP flag set
      // because GRE 2.3 will not flip them for us - MFR
      if( pds->ulDSFlgs & DS_BOTTOMTOP )
        ulFlip = GPLPAT_INVERT_BITS;
      else
        ulFlip = 0;

      if (ORIENTATION_PORTRAIT == pdb->pJobProperties->ulOrientation)
      {
         if (GplPatternCreateBitmaps (pddc->pdb->hmcbHeap,
                                      pddc->pdb->pResInfo->ulXRes,
                                      pddc->pdb->pResInfo->ulYRes,
                                      64L,
                                      64L,
                                      (PBMAPINFO)&pds->abmapinfoDefPattern,
                                      DEFAULT_PATTERNS_NUMBER,
                                      ulFlip ))
            pddc->pdb->bAllocatedPatterns = TRUE;
      }
      else
      {
         if (GplPatternCreateBitmaps (pddc->pdb->hmcbHeap,
                                      pddc->pdb->pResInfo->ulYRes,
                                      pddc->pdb->pResInfo->ulXRes,
                                      64L,
                                      64L,
                                      (PBMAPINFO)&pds->abmapinfoDefPattern,
                                      DEFAULT_PATTERNS_NUMBER,
                                      ulFlip ))
            pddc->pdb->bAllocatedPatterns = TRUE;
       }
   }

   // defer allocating surface bitmap memory until DEVESC_STARTDOC time
   // success result is zero
   lrc = 0;

   DBPRINTF (("QueryDeviceSurface:<<<<<<<<<<<\n"));

depart:
   UNREGISTERHANDLER (regrec);
   return lrc;

} /* end QueryDeviceSurface */

// ---------------------------------------------------------------------------
// mandatory in GRE22 model

LONG APIENTRY
DevicePalette (HDC hdc, PVOID pv, PDDC pddc, ULONG ulFunction)
{
#ifdef DEBUG
   PHWPALETTEINFO pHWPalette = (PHWPALETTEINFO)pv;
   PDEBUGINFO     pDbg       = &globals.DebugInfo;
   register INT   i;

   DBPRINTIF(( pDbg->bDEVICEPALETTE, "SetDevicePalette(): pHWPalette=%x\n", pHWPalette ));

   for (i = 0; i < pHWPalette->ulNumEntries; i++)
   {
       DBPRINTIF ((pDbg->bDEVICEPALETTE, "%d %02X:%02X:%02X",
                   i,
                   pHWPalette->pRGBs[i].bRed,
                   pHWPalette->pRGBs[i].bGreen,
                   pHWPalette->pRGBs[i].bBlue));
       if (!(i % 8))
          DBPRINTIF ((pDbg->bDEVICEPALETTE, "\n"));
   }
#endif

   return TRUE;
}

