/* REXX: ShowBmp [ON | OFF] */

call RxFuncAdd 'SysIni', 'RexxUtil', 'SysIni'

szApp = "OMNIDriver"
szKey = "ShowBitmap"

if length( arg( 1 ) ) = 0 then
   signal usage

parse arg szArg .

szArg = translate( szArg )

if szArg \= "ON"     & ,
   szArg \= "OFF"    & ,
   szArg \= "DELETE" then
do
   say "Usage: ShowBmp [ON | OFF]"
   exit
end

if szArg = "ON" then
   szVal = "1" || '00'x

if szArg = "OFF" then
   szVal = "0" || '00'x

if szArg = "DELETE" then
   szVal = "DELETE:"

call SysIni 'SYSTEM', szApp, szKey, szVal

say "Result = " '"'Result'"'

exit

usage:

say "Usage: ShowBmp [ON | OFF | DELETE]"
say

/* Query the current value */
szValue = SysIni( 'SYSTEM', szApp, szKey )

/* get rid of the terminating null character */
szValue = strip( translate( szValue, ' ', '0'x ) )

if      szValue = "0"      then szValue = "OFF"
else if szValue = "1"      then szValue = "ON"
else if szValue = ""       then szValue = "<does not exist>"
else if szValue = "ERROR:" then szValue = "<does not exist>"

say szKey "is currently" szValue

exit
