/* setea.cmd: sets extended attributes on the DRV file */

parse arg szBaseName szVersion szPath .

if length( szBaseName ) = 0 then do
  say 'Expected driver path and file name on command line but'
  say 'without the extension.'
  exit 3
end

szDriver = right( szBaseName, length( szBaseName ) - lastpos('\', szBaseName ))

if 0 < pos( '.', szDriver ) then do
  say 'Give driver path and name, but do not give extension.'
  exit 3
end

szDRVName = szBaseName'.drv'

/* Grab the program's path */
parse source . . szSrc
szSrcPath = filespec( 'drive', szSrc )
szSrcPath = szSrcPath || filespec( 'path', szSrc )
szSrcPath = translate( szSrcPath )
if substr( szSrcPath, length( szSrcPath ), 1 ) = "\" then
   szSrcPath = substr( szSrcPath, 1, length( szSrcPath ) - 1 )

szRoot = filespec( 'drive', szSrcPath )
szRoot = szRoot'\'word( translate( filespec( 'path', szSrcPath ), ' ', '\' ), 1 )

szDLLPath   = szRoot'\tools\os2.386\lx.386\bin\ibmcpp\csd11\dll;'
szDLLPath   = szDLLPath||szRoot'\tools\os2.386\bin;'

szOldPATH         = value( 'PATH',         szPath,    'OS2ENVIRONMENT' )
szOldBEGINLIBPATH = value( 'BEGINLIBPATH', szDLLPath, 'OS2ENVIRONMENT' )

'setlocal'
'set PATH='szPath
'set DPATH='szPath
'set BEGINLIBPATH='szDLLPath
'call rxea -e .version='szVersion szDRVName
'call rxea -e VENDORNAME='szDriver szDRVName
'call rxea -e REQUIREDDRIVERFILES='szDriver'.drv' szDRVName
'call rxea -e OPTIONALDRIVERFILES='szDriver'.SYM,'szDriver'.HLP,*.DLL,PRE32.SYM,*.FMF' szDRVName
/*
'ea -e .version='szVersion szDRVName
'ea -e VENDORNAME='szDriver szDRVName
'ea -e REQUIREDDRIVERFILES='szDriver'.drv' szDRVName
'ea -e OPTIONALDRIVERFILES='szDriver'.SYM,'szDriver'.HLP,*.DLL,PRE32.SYM' szDRVName
*/
/* <TWN> 'devnames -e'szDRVName */
'..\common\tools\devnames -e'szDRVName

'endlocal'
if rc > 0 then do
  say 'RC' rc 'from DEVNAMES utility.'
  exit 3
end

exit 0
