/* REXX: OUT
*/

TRACE OFF

arg szRest

/* The arguments are the following (in any order):
** [DEBUG | RETAIL | IPMD] [APPS | COOP | output_path] [PACK]
*/
szMachine    = "os2c"
szVersion    = "DEBUG"
fPackIt      = 0
fPackage     = 0
szTargetPath = 'A:'
szNLV        = 'en'

if szRest \= "" then
do while words( szRest ) > 0

   parse var szRest szParm szRest

   select
      when szParm = "PPC" then
         szMachine = "ppc"

      when szParm = "OS2" then
         szMachine = "os2c"

      when szParm = "DEBUG" then
         szVersion = szParm

      when szParm = "RETAIL" then
         szVersion = szParm

      when szParm = "IPMD" then
         szVersion = szParm

      when szParm = "COOP" then
      do
         say "COOP detected ..."
         szTargetPath = "i:\coop"
      end

      when szParm = "APPS" then
      do
         say "APPS detected ..."
         szTargetPath = "i:\srv_dir\printers"
      end

      when szParm = "PACK" then
      do
         say "PACK detected ..."
         fPackIt = 1
      end

      when szParm = "PACKAGE" then
      do
         say "PACKAGE detected ..."
         fPackIt  = 1
         fPackage = 1
      end

      when substr( szParm, 1, 4 ) = "NLV=" then
      do
         szNLV = substr( szParm, 5, 2 )
         say "NLV detected '"szNLV"'"
      end

      otherwise
         szTargetPath = szParm
   end
end

/* Get the current directory (in uppercase) */
szCurDirectory = translate( directory( '.' ) )

szSourcePath = '\COSDD\REL\'szMachine'\'szVersion'\'szNLV'\OS2\DRIVERS\OMNI'

say "szMachine =" szMachine
say "szVersion =" szVersion
say "szSourcePath =" szSourcePath
say "szTargetPath =" szTargetPath

call rxfuncadd 'sysloadfuncs', 'rexxutil', 'sysloadfuncs'
call sysloadfuncs

if (szVersion = "DEBUG" & szTargetPath = "A:") |,
   (fPackIt                                  ) then
do
   '@del 'szTargetPath'\omni.dr_ > nul 2>&1'
   '@del 'szTargetPath'\omni.ea_ > nul 2>&1'

   /* Create list file for pack
   */
   szTMPPath = value( 'TMP', , 'OS2ENVIRONMENT' )
   if szTMPPath = "" then
      szTMPPath = szSourcePath

   szFile = szTMPPath'\PACKING.LST'
   rc = SysFileDelete( szFile )

   result = stream( szFile,'c','open' )   /* open the file to read from ... */

   rc = lineout( szFile, szSourcePath'\OMNI.DRV' )
   rc = lineout( szFile, szSourcePath'\OMNI.SYM' )
   rc = lineout( szFile, szSourcePath'\OMNI.HLP' )

   rc = SysFileTree( szSourcePath'\*.FMF', aFMFList, 'FO' )
   do j = 1 to aFMFList.0
      rc = lineout( szFile, aFMFList.j )
   end

   result = stream( szFile,'c','close' )  /* close file */

   'pack 'szFile szTargetPath'\omni.dr_ /H:omni\ /L'

   rc = SysFileDelete( szFile )

   'copy 'szSourcePath'\OMNI.DRV 'szTMPPath
   'eatool /s /p 'szTMPPath'\OMNI.DRV 'szTargetPath'\omni.ea_'
   'del 'szTMPPath'\OMNI.DRV'
   exit 0
end
else
do
   szSourceFile = szSourcePath'\OMNI.DRV'
   szTargetFile = szTargetPath'\OMNI.DRV'

   call fCopyIfDifferent szSourceFile, szTargetFile

/* if szVersion = "DEBUG" then                                            */
   do
      szSourceFile = szSourcePath'\OMNI.SYM'
      szTargetFile = szTargetPath'\OMNI.SYM'

      call fCopyIfDifferent szSourceFile, szTargetFile
   end

   szSourceFile = szSourcePath'\OMNI.HLP'
   szTargetFile = szTargetPath'\OMNI.HLP'

   call fCopyIfDifferent szSourceFile, szTargetFile

   rc = SysFileTree( szSourcePath'\*.FMF', aFMFList, 'FO' )
   do j = 1 to aFMFList.0
      szSourceFile = szSourcePath'\'filespec( "name", aFMFList.j )
      szTargetFile = szTargetPath'\'filespec( "name", aFMFList.j )

      call fCopyIfDifferent szSourceFile, szTargetFile
   end
end

exit  0


/*********************************************************************************************************/
/* return 1 TRUE if files are different or either is not found */

fDifferent: arg szFile1, szFile2

aFile1. = ' '
rc = SysFileTree( szFile1, aFile1, 'F' )
if aFile1.0 = 0 then return 1

aFile2. = ' '
rc = SysFileTree( szFile2, aFile2, 'F' )
if aFile2.0 = 0 then return 1

parse var aFile1.1 szDate1 szTime1 szSize1 .
parse var aFile2.1 szDate2 szTime2 szSize2 .

if szDate1 <> szDate2  | szTime1 <> szTime2 | szSize1 <> szSize2 then return 1

return 0

/*********************************************************************************************************/
fCopyIfDifferent: arg szSourceFile, szTargetFile

if fDifferent( szSourceFile, szTargetFile ) then
do
   'copy 'szSourceFile szTargetFile
end

return
