/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1992 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 source code is provided to you solely for       */
/*    the purpose of assisting you in your development of OS/2 device        */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Developer Connection Device Driver       */
/*    Source Kit for OS/2. This Copyright statement may not be removed.      */
/*                                                                           */
/*****************************************************************************/
/****************************************************************************/
/* MODULE NAME    : Media types dialog control Functions                    */
/* SOURCE NAME    : MEDIAS.C                                                */
/* AUTHOR         : MFR                                                     */
/* DATE WRITTEN   : 6/11/94                                                 */
/* DESCRIPTION    : */
/*                                                                          */
/*                  Control Flow:                                           */
/*                                                                          */
/* PARAMETERS:      */
/*                                                                          */
/* RETURN VALUES:   */
/*                                                                          */
/*--------------------------------------------------------------------------*/
/* CHANGE/MODIFICATION LOG :                                                */
/*--------------------------------------------------------------------------*/
/*                                                                          */
/****************************************************************************/

// os2 includes
#define INCL_DOS
#define INCL_PM
#include <os2.h>

// @DBCS
#define INCL_VMANDDI
#include <ddi.h>
#include <pmddi.h>

// c includes
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <setjmp.h>


#include "def.h"
#include "driver.h"
#include "funcs.h"


/****************************************************************************/
/* PROCEDURE NAME : MediaNameFromID                                         */
/* AUTHOR         : MFR                                                     */
/* DATE WRITTEN   : 6/11/94                                                 */
/* DESCRIPTION    : */
/*                                                                          */
/*                  Control Flow:                                           */
/*                                                                          */
/* PARAMETERS:      */
/*                                                                          */
/* RETURN VALUES:   */
/*                                                                          */
/*--------------------------------------------------------------------------*/
/* CHANGE/MODIFICATION LOG :                                                */
/*--------------------------------------------------------------------------*/
/*                                                                          */
/****************************************************************************/
BOOL MediaNameFromID( PDRIVERINFO pDriver,
                      PDEVICEINFO pDevice,
                      PSZ pszMediaName,
                      ULONG ulMediaID )
{
  /*------------------------------------------------------------------------*/
  /* LOCAL VARIABLES                                                        */
  /*------------------------------------------------------------------------*/
  ULONG      ulDefType;
  BOOL       bMediaNameFound = FALSE;
  ULONG      i;
  ULONG      ulNumDefined;
  PMEDIAINFO pMedias;

#ifdef DEBUG
  PDEBUGINFO  pDbg = &globals.DebugInfo;
#endif

  /*------------------------------------------------------------------------*/
  /* BEGIN CODE                                                             */
  /*------------------------------------------------------------------------*/

  DBPRINTIF(( pDbg->bMEDIANAMEFROMID,"%s(): Enter\n", __FUNCTION__ ));

  // Find out how Media defined (in driver, in device, by user )
  ulDefType = MAKEULONG( 0, HIUSHORT(ulMediaID) );

  switch ( ulDefType )
  {
    case DEF_TYPE_DRIVER:
    {
      DBPRINTIF(( pDbg->bMEDIANAMEFROMID,"%s(): DEF_TYPE_DRIVER\n", __FUNCTION__ ));

      ulNumDefined = pDriver->ulNumMedias;
      pMedias      = pDriver->pMEDIAS;

      DBPRINTIF(( pDbg->bMEDIANAMEFROMID,"%s(): ulNumMedias=%lu; pMEDIAS=%x\n", __FUNCTION__, ulNumDefined, pMedias ));

      // For now only driver table definitions allowed
      // loop through table of Medias until matching Media ID
      // found
      for( i=0; i < ulNumDefined; i++ )
      {

         DBPRINTIF(( pDbg->bMEDIANAMEFROMID,"%s(): Compare: (%lu) ID In vs. (%lu) ID Table\n", __FUNCTION__, ulMediaID, pMedias[i].ulMediaID ));

         if( ulMediaID == pMedias[i].ulMediaID )
         {
            // Now we must determine if the string is in our stringtable
            // or a it is a string the user defined in hcInfo structure
            if( pMedias[i].ulNameID == MEDIA_STRING_UNLISTED )
            {
              strcpy( pszMediaName, pMedias[i].szMediaName );

            } /* end if */
            else
            {
              ULONG ulIdx;

              ulIdx = pMedias[i].ulNameID - STRING_TABLE_BASE;

              assert( globals.pbStringTable[ulIdx] );

              strcpy( pszMediaName, globals.pbStringTable[ulIdx] );

              DBPRINTIF(( pDbg->bMEDIANAMEFROMID,"%s(): Matched Media Name (%d)= '%s'!\n", __FUNCTION__, ulMediaID, pszMediaName ));

            } /* end logical block */

            bMediaNameFound = TRUE;

            break;

         } /* end if */

      } /* end for */

    } /* end case */
    break;

    case DEF_TYPE_DEVICE:
      DBPRINTIF(( pDbg->bMEDIANAMEFROMID,"%s(): DEF_TYPE_DEVICE!!! Currently Invalid!\n", __FUNCTION__ ));
    break;

    case DEF_TYPE_USER:
      DBPRINTIF(( pDbg->bMEDIANAMEFROMID,"%s(): DEF_TYPE_USER!!! Currently Invalid!\n", __FUNCTION__ ));
    break;

    default:
      DBPRINTIF(( pDbg->bMEDIANAMEFROMID,"%s(): Unrecognized Type = '%x'!\n", __FUNCTION__, ulDefType ));
      assertstring ("Should not be here!\n");
    break;

  } /* end switch */

  DBPRINTIF(( pDbg->bMEDIANAMEFROMID,"%s(): Exit; bMediaNameFound = %d\n", __FUNCTION__, bMediaNameFound ));
  assertF( bMediaNameFound );

  return( bMediaNameFound );

} /* end MediaNameFromID */


/****************************************************************************/
/* PROCEDURE NAME : MediaInfoFromID                                          */
/* AUTHOR         : MFR                                                     */
/* DATE WRITTEN   : 6/11/94                                                 */
/* DESCRIPTION    : */
/*                                                                          */
/*                  Control Flow:                                           */
/*                                                                          */
/* PARAMETERS:      */
/*                                                                          */
/* RETURN VALUES:   */
/*                                                                          */
/*--------------------------------------------------------------------------*/
/* CHANGE/MODIFICATION LOG :                                                */
/*--------------------------------------------------------------------------*/
/*                                                                          */
/****************************************************************************/
BOOL MediaInfoFromID( PDRIVERINFO pDriver,
                      PDEVICEINFO pDevice,
                      ULONG ulMediaID,
                      PPMEDIAINFO pMedia )
{
  ULONG      ulDefType;
  BOOL       bMediaInfoFound = FALSE;
  ULONG      i;
  ULONG      ulNumDefined;
  PMEDIAINFO pMedias;


  DBPRINTIF(( TRUE,"%s(): Enter\n", __FUNCTION__ ));

  // Find out how Media defined (in driver, in device, by user )
  ulDefType = MAKEULONG( 0, HIUSHORT(ulMediaID) );

  switch ( ulDefType )
  {

    case DEF_TYPE_DRIVER:  // No hi word value
    {
      DBPRINTIF(( TRUE,"%s(): DEF_TYPE_DRIVER\n", __FUNCTION__ ));

      ulNumDefined = pDriver->ulNumMedias;
      pMedias      = pDriver->pMEDIAS;

      // For now only driver table definitions allowed
      // loop through table of Medias until matching Media ID
      // found
      for( i=0; i < ulNumDefined; i++ )
      {
         if( ulMediaID == pMedias[i].ulMediaID )
         {

           *pMedia = &(pMedias[i]);

           DBPRINTIF(( TRUE,"%s(): pMedia = %x\n", __FUNCTION__, pMedia ));

           bMediaInfoFound = TRUE;

           break;

         } /* end if */

      } /* end for */

    } /* end case */
    break;

    case DEF_TYPE_DEVICE:
      DBPRINTIF(( TRUE,"%s(): DEF_TYPE_DEVICE!!! Currently Invalid!\n", __FUNCTION__ ));
    break;

    case DEF_TYPE_USER:
      DBPRINTIF(( TRUE,"%s(): DEF_TYPE_USER!!! Currently Invalid!\n", __FUNCTION__ ));
    break;

    default:
      DBPRINTIF(( TRUE,"%s(): Unrecognized Type = '%x'!\n", __FUNCTION__, ulDefType ));
      assertstring ("Should not be here!\n");
    break;

  } /* end switch */

  DBPRINTIF(( TRUE,"%s(): Exit\n", __FUNCTION__ ));
  assertF( bMediaInfoFound );

  return( bMediaInfoFound );

} /* end MediaInfoFromID */




/****************************************************************************/
/* PROCEDURE NAME : FillMediaList                                            */
/* AUTHOR         : MFR                                                     */
/* DATE WRITTEN   : 6/11/94                                                 */
/* DESCRIPTION    : */
/*                                                                          */
/*                  Control Flow:                                           */
/*                                                                          */
/* PARAMETERS:      */
/*                                                                          */
/* RETURN VALUES:   */
/*                                                                          */
/*--------------------------------------------------------------------------*/
/* CHANGE/MODIFICATION LOG :                                                */
/*--------------------------------------------------------------------------*/
/*                                                                          */
/****************************************************************************/
VOID FillMediaList( HWND hwndDlg, PDLGINSTANCE pdi, PDEVICEINFO pDevice,
                    ULONG ulListboxID )
{
  /*------------------------------------------------------------------------*/
  /* LOCAL VARIABLES                                                        */
  /*------------------------------------------------------------------------*/
  ULONG      ulNumMedias;
  USHORT     i;
  ULONG      ulMediaID;
  CHAR       szMediaName[LEN_STRING];
  USHORT     usMatchIdx = 0;

#ifdef DEBUG
  PDEBUGINFO  pDbg = &globals.DebugInfo;
#endif

  /*------------------------------------------------------------------------*/
  /* BEGIN CODE                                                             */
  /*------------------------------------------------------------------------*/

  DBPRINTIF(( pDbg->bFILLMEDIALIST, "%s(): Enter\n", __FUNCTION__ ));

  // initial pointer validation
  assert( pdi );
  assert( pDevice );

  // free existing list
  WinSendDlgItemMsg( hwndDlg,
                     ulListboxID,
                     LM_DELETEALL,
                     MPVOID,
                     MPVOID );

  /************************************/
  /* DRIVER MEDIAS                     */
  /************************************/

  // get # Medias defined
  ulNumMedias = pdi->pDevice->ulNumMedias;

  // add each Media defined into listbox
  for( i=0; i < ulNumMedias; i++ )
  {
    ulMediaID = pdi->pDevice->pulMEDIAS[i];

    // if Media ID found and string returned
    if( MediaNameFromID( pdi->pDriver, pDevice, szMediaName, ulMediaID ) )
    {
      SHORT sIdx;

      sIdx = (SHORT)WinSendDlgItemMsg( hwndDlg,
                                       ulListboxID,
                                       LM_INSERTITEM,
                                       MPFROM2SHORT( LIT_END, 0 ),
                                       MPFROMP( szMediaName ) );

      // Set Item Handle to be the Media ID
      WinSendDlgItemMsg( hwndDlg,
                         ulListboxID,
                         LM_SETITEMHANDLE,
                         MPFROMSHORT( sIdx ),
                         MPFROMLONG( ulMediaID ) );

      DBPRINTIF(( pDbg->bFILLMEDIALIST, "%s(): Adding Media: '%s'; ID=%lu Idx=%d\n", __FUNCTION__, szMediaName, ulMediaID, sIdx  ));

    } /* end if */

  } /* end for */

  /************************************/
  /* User Defined Medias (none now)   */
  /************************************/

  // highlite index of match or if no match found
  // (as default) highlite first in entry listbox
  WinSendDlgItemMsg( hwndDlg,
                     ulListboxID,
                     LM_SELECTITEM,
                     MPFROMLONG( usMatchIdx ),
                     MPFROMLONG( TRUE ) );

  DBPRINTIF(( pDbg->bFILLMEDIALIST, "%s(): Highliting Media index: (%d)\n", __FUNCTION__, usMatchIdx ));

  DBPRINTIF(( pDbg->bFILLMEDIALIST, "%s(): Exit\n", __FUNCTION__ ));

} /* end FillMediaList */


