/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1992 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 source code is provided to you solely for       */
/*    the purpose of assisting you in your development of OS/2 device        */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Developer Connection Device Driver       */
/*    Source Kit for OS/2. This Copyright statement may not be removed.      */
/*                                                                           */
/*****************************************************************************/
// handler.c

#define INCL_WINMENUS
#define INCL_DEV
#define INCL_DOS
#define INCL_SPL
#define INCL_GPIBITMAPS    // To pull in the proper include files...
#define INCL_GPIPRIMITIVES
#include <os2.h>

// @DBCS
#define INCL_VMANDDI
#include <ddi.h>
#include <pmddi.h>

// c includes
#include <setjmp.h>

#include "def.h"
#include "driver.h"
#include "funcs.h"





// --------------------------------------------------------------------------------------------------------------------
// Called when thread owning the DDC is getting killed.
// Free up the DDC so that some other thread in the process can continue to use it

LONG DRVENTRY CheckForTermination( PREGREC pregrec, ULONG ulException, PDDC pddc )
{
  ULONG   ulcRequests;
  APIRET  rc;
  TID     tid;
  PID     pid;
  PTIB    ptib;
  PPIB    ppib;



  DBPRINTF(( "%s(): Enter\n", __FUNCTION__ ));

  switch( ulException )
  {
    case XCPT_PROCESS_TERMINATE:
    case XCPT_ASYNC_PROCESS_TERMINATE:
    {
      DBPRINTF(( "%s(): XCPT_PROCESS_TERMINATE (%d)\n", __FUNCTION__, ulException ));

      // get current thread id
      rc = DosGetInfoBlocks( &ptib, &ppib );
      assert( 0 == rc );
      // get DDC semaphore data
      rc = DosQueryMutexSem( pddc->pdb->hmtxDCSem, &pid, &tid, &ulcRequests );
      assert( 0 == rc );
      DBPRINTF(( "%s(): ulcRequests = %d; tid = %x; ultid = %x\n", __FUNCTION__, ulcRequests, tid, ptib->tib_ptib2->tib2_ultid ));
      // see if current, dying thread owns the semaphore
      if( ulcRequests  && tid == ptib->tib_ptib2->tib2_ultid ) {
        // whoa! the thread that owns this ddc just got killed
        while( ulcRequests-- ) {
          DBPRINTF(( "CheckForTermination(): release DC Sem\n" ));
          rc = DosReleaseMutexSem( pddc->pdb->hmtxDCSem );
          assert( 0 == rc );
        }
      }
      // get the handler off the chain, or else it would just get called again
      rc = DosUnsetExceptionHandler( (PEXCEPTIONREGISTRATIONRECORD)pregrec );
      assert( 0 == rc );

      // exit the thread; let other handlers have a go at it
      DosExit( EXIT_THREAD, 0 );

    } /* end case */

  } /* end switch */

  DBPRINTF(( "%s(): Exit\n", __FUNCTION__ ));

#ifndef DEBUG
  rc++;             // Avoid compiler warnings
#endif

  return( 0 );

} /* end CheckForTermination */
