/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1992 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 source code is provided to you solely for       */
/*    the purpose of assisting you in your development of OS/2 device        */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Developer Connection Device Driver       */
/*    Source Kit for OS/2. This Copyright statement may not be removed.      */
/*                                                                           */
/*****************************************************************************/
/****************************************************************************/
/* MODULE NAME    : Omni Driver Function Headers                            */
/* SOURCE NAME    : FUNCS.H                                                 */
/* AUTHOR         : Matt Rutkowski & Mark Hamzy                             */
/* DESCRIPTION    : provides prototypes of all global Omni driver functions */
/*                                                                          */
/* NOTE:  Include this file in any new 'c' source file after "os2.h"        */
/*                                                                          */
/*--------------------------------------------------------------------------*/
/* CHANGE/MODIFICATION LOG :                                                */
/*--------------------------------------------------------------------------*/
/* @SCALABLEFONT 04/08/98   [IBMJ]  Device scalable font support.           */
/* @EXJOB  - 07/13/98 - UCC [IBMJ]- Expansible job data support             */
/* @JPN2H99- 08/01/99 - UCC [IBMJ]- 1999 2nd half Japanese new devices supp */
/*                                                                          */
/****************************************************************************/

#define INCL_GENPLIB_STRINGSORT
#define INCL_GENPLIB_DBCS
#include <genplib.h>

/*-------------------------------------------*/
/* COMMON.C prototypes                       */
/*-------------------------------------------*/
ULONG APIENTRY       Power                         (USHORT,
                                                    USHORT);
VOID APIENTRY        SetYPosition                  (PDDC          pddc,
                                                    INT           iWorldY);
BOOL APIENTRY        CompressRasterPlane           (PBYTE         pbBuffer,
                                                    INT           iPrinterBytesInArray,
                                                    BOOL          fLastPlane,
                                                    PBYTE         pbLastLine,
                                                    PBYTE         pbCompress,
                                                    PINT          pCurrentCompressMode,
                                                    ULONG         ulCompressModes,
                                                    PVOID         pvDDC,
                                                    PUSHORT       pusDelta);

INT APIENTRY         FindGamma                     (PGAMMA_STRUCT pGammaTable,
                                                    PULONG        pFamilyTable,
                                                    ULONG         ulFamilyId,
                                                    PULONG        pResTable,
                                                    ULONG         ulResId,
                                                    PULONG        pMediaTable,
                                                    ULONG         ulMediaId,
                                                    PULONG        pModeTable,
                                                    ULONG         ulModeId,
                                                    ULONG         ulDitherId);

#define LOCALBUFSIZE             513

VOID                 SetDevFntInfo                 (PDDC               pddc,
                                                    PSTRINOUT          pStrInOut,
                                                    LONG               lMatch);

LONG APIENTRY        DevfntTextBlt                 (PDDC               pddc,
                                                    PTEXTBLTINFO       ptbi,
                                                    PHSORTER           phSort,
                                                    PBYTE              pbStringBuf,
                                                    PSZ                pszGlyphs);
VOID                 DevfntSetDevFntInfo           (PDDC               pddc,
                                                    PSTRINOUT          pStrInOut,
                                                    FONTINFO2          pSelectedFont);
// begin @UCCTmp
PFONTINFO2           GetFontinfo                   (PDRIVERINFO        pDriver,
                                                    LONG               lMatch);
PFOCAFONT            GetFocafont                   (PDEVICEBLOCK       pdb,
                                                    LONG               lMatch);
// end @UCCTmp
LONG APIENTRY        CommonCompress                (INT                cbDataIn,
                                                    BYTE              *pbDataIn,
                                                    INT                cbDataOut,
                                                    BYTE              *pbDataOut);
VOID                 DeviceAddDialogPage           (PDLGINSTANCE       pdi,
                                                    ULONG              ulType,
                                                    ULONG              ulDlgID,
                                                    PFNWP              pfnDlg,
                                                    PSZ                pszTabText);
USHORT               UGLToUnicode                  (USHORT             usUGL);

LONG APIENTRY        DevfntTextBlt2                (PDDC               pddc,
                                                    PTEXTBLTINFO       ptbi,
                                                    PHSORTER           phSort,
                                                    PBYTE              pbStringBuf,
                                                    PDEVFONTCTLBLOCK   pDevFntCB,
                                                    PSZ                pszGlyphs);

PDEVFONTCTLBLOCK     AllocFontAttrsCB              (PDDC               pddc);

BOOL                 ExpandFontAttrs               (PDDC               pddc,
                                                    PDEVFONTCTLBLOCK   pDevFntCB);

BOOL                 FreeFontAttrsCB               (PDEVFONTCTLBLOCK   pDevFntCB);

PDEVFONTATTRIBUTES   InsertFontAttrs               (PDDC               pddc,
                                                    PDEVFONTCTLBLOCK   pDevFntCB,
                                                    PDEVFONTATTRIBUTES pAttrs);

PDEVFONTATTRIBUTES   FindSameFontAttrs             (PDEVFONTCTLBLOCK   pDevFntCB,
                                                    PDEVFONTATTRIBUTES pAttrs);

VOID                 DevFntSetFontAttrs            (PDDC               pddc,
                                                    PSTRINOUT          pStrInOut,
                                                    PDEVFONTATTRIBUTES pDevFntAttrs,
                                                    PDEVFONTATTRCMDS   pCmd,
                                                    ULONG              ulOption);

VOID                 DevFntUpdateAttrs             (PDDC               pddc,
                                                    PSTRINOUT          pStrInOut,
                                                    PDEVFONTATTRCMDS   pCmd,
                                                    PDEVFONTATTRIBUTES pCurrAttrs,
                                                    PDEVFONTATTRIBUTES pNextAttrs);

BOOL                 OmniBookletEnabled            (PDDC);

// @JPN2H99
VOID                 DrawIcon                      (HWND,
                                                    HPOINTER,
                                                    ULONG,
                                                    ULONG);


/*-------------------------------------------*/
/* CONNECT.C prototypes                      */
/*-------------------------------------------*/
BOOL                 AddConnectionEntry            (PDEVICEINFO,
                                                    PFORMCONNECTION);
BOOL                 DeleteConnectionEntry         (PDEVICEINFO,
                                                    ULONG);
BOOL                 GetIDsFromConnID              (PDRIVERINFO,
                                                    PDEVICEINFO,
                                                    ULONG,
                                                    PULONG,
                                                    PULONG,
                                                    PULONG);
BOOL                 IsConnectionUnique            (PDLGINSTANCE,
                                                    PFORMCONNECTION);
BOOL                 IsFormPartOfAConnection       (PDEVICEINFO,
                                                    ULONG);
BOOL                 IsTrayPartOfAConnection       (PDRIVERINFO,
                                                    PDEVICEINFO,
                                                    ULONG);
BOOL                 ReadUserDefinedConnectList    (PSZ,
                                                    PDEVICEINFO);
BOOL                 SaveUserDefinedConnectList    (PSZ,
                                                    PDEVICEINFO);
ULONG                CreateUniqueConnectID         (PDEVICEINFO);
VOID                 FillConnectionList            (HWND,
                                                    PDLGINSTANCE,
                                                    PDEVICEINFO,
                                                    ULONG,
                                                    ULONG);
VOID                 FreeConnectionList            (PDEVICEINFO);
VOID                 MarkIfSelectableCurrentForm   (PDRIVERINFO,
                                                    PDEVICEINFO,
                                                    ULONG,
                                                    PFORMINFO2);
BOOL                 Find1stConnFromFormID         (PDRIVERINFO,
                                                    PDEVICEINFO,
                                                    ULONG,
                                                    PULONG);

/*-------------------------------------------*/
/* DEBUG.C prototypes                        */
/*-------------------------------------------*/

// NOTE: Only included if debug version is being compiled
#ifdef DEBUG

FNWP                 DebugDlgProc;
BOOL                 DebugInterpretSplMsgRC        (ULONG,
                                                    PSZ);
VOID                 DebugOutputJobProperties      (BOOL,
                                                    PSZ,
                                                    PJOBPROPERTIES);
VOID                 DebugOutputFormInfo           (BOOL,
                                                    PSZ,
                                                    PFORMINFO);
VOID                 DebugBitmap                   (PBYTE,
                                                    INT,
                                                    INT,
                                                    INT,
                                                    BOOL,
                                                    INT,
                                                    INT);
BOOL                 FillDebugFunctionList         (HWND,
                                                    PDLGINSTANCE,
                                                    ULONG);
FNWP                 GammaDlgProc;
BOOL                 InitDebugInfo                 (PDEBUGINFO,
                                                    BOOL,
                                                    BOOL);
BOOL                 IsDebugOptionSelected         (PDEBUGINFO,
                                                    ULONG);
BOOL                 SaveDebugFunctionList         (HWND,
                                                    PDLGINSTANCE);
BOOL                 SelectDebugOption             (PDEBUGINFO,
                                                    ULONG,
                                                    BOOL);
VOID                 ShowBitmap                    (PDDC pddc,
                                                    PCHAR pchRet,
                                                    PBITMAPINFO2 pbmi);
BOOL                 ShowTrueGamma                 (HWND,
                                                    PDLGINSTANCE,
                                                    PJOBPROPERTIES,
                                                    BOOL);
VOID                 TestCompress                  (PBYTE,
                                                    PBYTE);
VOID                 DebugPrintDefine              (ULONG ulDefine);
VOID                 DebugPrintResIDDefine         (ULONG ulDefine);
VOID                 DebugPrintMediaIDDefine       (ULONG ulDefine);
VOID                 DebugPrintDitherIDDefine      (ULONG ulDefine);
VOID                 DebugPrintModeIDDefine        (ULONG ulDefine);

#endif


/*-------------------------------------------*/
/* DLG.C prototypes                          */
/*-------------------------------------------*/
LONG                 ConvertAsciiCmdToHex          (HWND,
                                                    PBYTE,
                                                    ULONG);
BOOL                 ConvertHexCmdToAscii          (USHORT,
                                                    PSZ,
                                                    PSZ);
VOID                 FillJobPropertiesNotebook     (HWND,
                                                    PDLGINSTANCE);
VOID                 FillPrinterPropertiesNotebook (HWND,
                                                    PDLGINSTANCE);
VOID                 FillPrintModeList             (HWND,
                                                    PDLGINSTANCE,
                                                    PDEVICEINFO,
                                                    ULONG);
VOID                 FillResolutionList            (HWND,
                                                    PDLGINSTANCE,
                                                    PDEVICEINFO,
                                                    ULONG);
VOID                 ReadGammaControls             (PJOBPROPERTIES pJobProps,
                                                    HWND           hwndColor);
BOOL                 InitColorJobProps             (HWND,
                                                    PDLGINSTANCE,
                                                    PJOBPROPERTIES);
BOOL                 InitCommonJobProps            (HWND,
                                                    PDLGINSTANCE,
                                                    PDEVICEINFO,
                                                    PJOBPROPERTIES,
                                                    BOOL);
BOOL                 InitGammaSliders              (HWND,
                                                    PDLGINSTANCE,
                                                    PJOBPROPERTIES);
BOOL                 InitHSVJobProps               (HWND,
                                                    PDLGINSTANCE,
                                                    PJOBPROPERTIES);
BOOL                 InitMonoJobProps              (HWND,
                                                    PDLGINSTANCE,
                                                    PJOBPROPERTIES);
VOID                 InsertNotebookPage            (HWND          hwnd,
                                                    PDLGINSTANCE  pdi,
                                                    PVOID         pvHandle,
                                                    HWND          hwndNB,
                                                    ULONG         ulNBID,
                                                    PNOTEBOOKINFO pNBI,
                                                    PNBPAGEINFO   pCurrentPage,
                                                    ULONG         ulDlgID,
                                                    PFNWP         pfnDlg,
                                                    PSZ           pszTabText,
                                                    ULONG         ulTabType);
VOID                 InsertListboxItem             (HWND,
                                                    ULONG,
                                                    PSZ,
                                                    ULONG);
VOID                 InsertRemoteControlFunction   (HWND,
                                                    PPRINTCTLFUNC);
BOOL                 CreateHelpInstance            (PDLGINSTANCE,
                                                    BOOL);
BOOL                 DestroyHelpInstance           (PDLGINSTANCE,
                                                    BOOL);
BOOL                 SaveJobProperties             (PDLGINSTANCE,
                                                    PJOBPROPERTIES);
BOOL                 DlgSavePrinterProperties      (PSZ,
                                                    PDLGINSTANCE);
BOOL                 SelectItemFromHandle          (PDLGINSTANCE,
                                                    HWND,
                                                    ULONG,
                                                    ULONG);
VOID                 SetIconInDialog               (HWND,
                                                    HPOINTER,
                                                    ULONG);
FNWP                 BmpWndProc;
FNWP                 ColorImageDlgProc;
FNWP                 CommonJobPropertiesDlgProc;
FNWP                 DefineFormDlgProc;
FNWP                 DefineTrayDlgProc;
FNWP                 DeskJetJobPropDlgProc;
FNWP                 EpsonJobPropDlgProc;
FNWP                 FontDlgProc;
FNWP                 FormConnectionDlgProc;
FNWP                 FormInfoWndProc;
FNWP                 HexEntryWndProc;
FNWP                 HSVDlgProc;
FNWP                 JobPropertiesDataDlgProc;
FNWP                 JobPropertiesDlgProc;
FNWP                 MenuSubclassProc;
FNWP                 MonoImageDlgProc;
FNWP                 PrinterPropertiesDlgProc;


/*-------------------------------------------*/
/* DRIVER.C prototypes                       */
/*-------------------------------------------*/
VOID                 SetNumberOfPrinters           (VOID);


/*-------------------------------------------*/
/* ENABLE.C prototypes                       */
/*-------------------------------------------*/
BOOL                 ValidatePointer               (PBYTE pbPointer,
                                                    INT   iType,
                                                    ULONG ulSize);
// ValidatePointer(): Pointer types
#define VALIDATE_TYPE_STRING 1
#define VALIDATE_TYPE_BLOCK  2

VOID                 InitStringTable               (ULONG);
// InitStringTable(): String types
#define STRINGS_BASE    0x0001
#define STRINGS_DIALOG  0x0002

VOID                 DestroyDeviceCookie           (PDDC,
                                                    PDEVICEBLOCK);
VOID                 DestroyDeviceBlock            (PDEVICEBLOCK);
VOID                 DestroyDrawingContext         (PDDC);
VOID                 DestroyShadowBitmap           (PDDC);
VOID                 SetupDeviceSurface            (PDDC);
VOID APIENTRY        DrvInstall                    (VOID);
BOOL                 InitDlgInstanceData           (PDLGINSTANCE,
                                                    PSZ,
                                                    PSZ,
                                                    PSZ,
                                                    PSZ);
BOOL                 InitUserDefinedData           (PUSERDEFDATA);
LONG APIENTRY        OS2_PM_DRV_DEVMODE            (PDRIVDATA pdriv,
                                                    PSZ       pszDrivername,
                                                    PSZ       pszDevicename,
                                                    PSZ       pszPrintername,
                                                    ULONG     ulOptions);
LONG APIENTRY        OS2_PM_DRV_DEVICENAMES        (PSZ       pszDriverName,
                                                    PLONG     pcNames,
                                                    PSZ       pstr32DeviceNames,
                                                    PSZ       pstr64DeviceDescriptions,
                                                    PLONG     pcDataTypes,
                                                    PSZ       pstr16DataTypes,
                                                    ULONG     ulReserved1,
                                                    ULONG     ulReserved2);
ULONG APIENTRY       OS2_PM_DRV_ENABLE             (ULONG     ulSubFunc,
                                                    ULONG     ulParam1,
                                                    ULONG     ulParam2);
ULONG APIENTRY       OS2_PM_DRV_POSTESCAPE         (PSZ       pszDriverName,
                                                    PSZ       pszDeviceName,
                                                    PSZ       pszQueueName,
                                                    PSZ       pszSplPrinterName,
                                                    ULONG     ulFuncNum,
                                                    ULONG     cbParm1,
                                                    PBYTE     pbParm1,
                                                    ULONG     cbParm2,
                                                    PBYTE     pbParm2);


/*-------------------------------------------*/
/* ESCAPE.C prototypes                       */
/*-------------------------------------------*/
DEVICEOPEN           OmniDeviceOpen;
DEVICECLOSE          OmniDeviceClose;
SPOOLEROPEN          OmniSpoolerOpen;
SPOOLERCLOSE         OmniSpoolerClose;
SPOOLERSTART         OmniSpoolerStartJob;
SPOOLEREND           OmniSpoolerEndJob;

BOOL                 StartTheThread                (PDDC        pddc,
                                                    LHANDLE     lHandle,
                                                    HFILE       hFile);
BOOL                 EndTheThread                  (PDDC        pddc);

/*-------------------------------------------*/
/* FONTS.C prototypes                        */
/*-------------------------------------------*/
LONG                 ReturnNumberOfDeviceFonts     (PDRIVERINFO pDriver,
                                                    PDEVICEINFO pDevice);
BOOL                 AddUserDefinedFontEntry       (PDEVICEINFO,
                                                    PFONTINFO2);
VOID                 CalculateFontMetrics          (PFONTINFO2  pFont,
                                                    ULONG       ulRes);
ULONG                CreateUniqueFontID            (PDEVICEINFO);
BOOL                 DeleteUserDefinedFontEntry    (PDEVICEINFO,
                                                    ULONG);
VOID                 FillFontList                  (HWND,
                                                    PDLGINSTANCE,
                                                    PDEVICEINFO,
                                                    ULONG);
BOOL                 FontNameFromID                (PDRIVERINFO,
                                                    PDEVICEINFO,
                                                    PSZ,
                                                    ULONG);
BOOL                 FontInfoFromID                (PDRIVERINFO,
                                                    PDEVICEINFO,
                                                    ULONG,
                                                    PPFONTINFO2);
VOID                 FreeUserDefinedFontList       (PDEVICEINFO);
BOOL                 GetDefaultFontInfo            (PDEVICEBLOCK,
                                                    ULONG,
                                                    PPFONTINFO2);
BOOL                 ReadUserDefinedFontList       (PSZ,
                                                    PDEVICEINFO);
BOOL                 SaveUserDefinedFontList       (PSZ,
                                                    PDEVICEINFO);

LONG                 ReadFocaMetricsFile           (HMCB        hmcb,
                                                    PFONTINFO2  pFontInfo,
                                                    PFOCAFONT  *ppFoca,
                                                    PRESINFO    pRes,
                                                    LONG        lPointSize);

VOID                 FillFocaMetricsListBox        (HWND         hwnd,
                                                    ULONG        ulLBoxID,
                                                    PDLGINSTANCE pdi,
                                                    PFOCAFONT    pFocaFont);

ULONG APIENTRY       QueryDevFntMetrics            (HDC          hdc,
                                                    PVOID       *pv,
                                                    ULONG        ulOptions,
                                                    PDDC         pddc,
                                                    ULONG        ulR2);

ULONG                FontIdFromLMatch              (PDRIVERINFO  pDriver,
                                                    PDEVICEINFO  pDevice,
                                                    LONG         lMatch,
                                                    PLONG        plPointSize);

/*-------------------------------------------*/
/* FORMS.C prototypes                        */
/*-------------------------------------------*/
BOOL                 AddUserDefinedFormEntry       (PDEVICEINFO,
                                                    PFORMINFO2);
ULONG                CreateUniqueFormID            (PDEVICEINFO);
BOOL                 DeleteUserDefinedFormEntry    (PDEVICEINFO,
                                                    ULONG);
BOOL                 FormNameFromID                (PDRIVERINFO,
                                                    PDEVICEINFO,
                                                    PSZ,
                                                    ULONG);
VOID                 FillFormList                  (HWND,
                                                    PDLGINSTANCE,
                                                    PDEVICEINFO,
                                                    ULONG);
VOID                 FreeUserDefinedFormList       (PDEVICEINFO);
BOOL                 FormInfoFromID                (PDRIVERINFO,
                                                    PDEVICEINFO,
                                                    ULONG,
                                                    PFORMINFO2);
BOOL                 FormInfoFromName              (PDRIVERINFO,
                                                    PDEVICEINFO,
                                                    PSZ,
                                                    PFORMINFO2);
BOOL                 GetDefaultFormInfo            (PDEVICEBLOCK,
                                                    ULONG,
                                                    ULONG,
                                                    PFORMINFO2);
BOOL                 ReadUserDefinedFormList       (PSZ,
                                                    PDEVICEINFO);
BOOL                 SaveUserDefinedFormList       (PSZ,
                                                    PDEVICEINFO);
VOID                 CalculateFormSize             (PDEVICEBLOCK   pdb,
                                                    PJOBPROPERTIES pJobProperties,
                                                    PFORMINFO2     pForm);
BOOL                 IsUserDefinedForm             (PFORMINFO2     pForm);


/*-------------------------------------------*/
/* HANDLER.C prototypes                      */
/*-------------------------------------------*/
LONG DRVENTRY        CheckForTermination           (PREGREC pregrec,
                                                    ULONG   ulException,
                                                    PDDC    pddc);


/*-------------------------------------------*/
/* HELPER.C prototypes                       */
/*-------------------------------------------*/
BOOL                 AllocateDeviceHandle          (PDDC           pddc,
                                                    BOOL           fReAlloc);
BOOL                 DRVENTRY BuildAppName         (PSZ,
                                                    ULONG,
                                                    PSZ,
                                                    PSZ,
                                                    PSZ);
BOOL                 GetDriverDriveAndPath         (PSZ);
SHORT                CheckLogicalAddress           (PSZ);
VOID                 ConvertHMMtoPels              (ULONG          ulMMValue,
                                                    ULONG          ulDpi,
                                                    PULONG         pulPelValue,
                                                    BOOL           bRoundUp);
ULONG                RoundDivide                   (ULONG,
                                                    ULONG);
ULONG                f_lsqrt                       (ULONG);
PRESINFO DRVENTRY    GetpResFromResID              (PDRIVERINFO    pDriver,
                                                    PDEVICEINFO    pDevice,
                                                    PJOBPROPERTIES pJobProperties);
PPRINTMODE DRVENTRY  GetpPrintModeFromID           (PDRIVERINFO    pDriver,
                                                    PDEVICEINFO    pDevice,
                                                    PJOBPROPERTIES pJobProperties);

#ifdef DLLBLD
PDEVICEINFO DRVENTRY PDeviceFromDeviceName         (PSZ            pszDeviceName,
                                                    PDRIVERINFO   *ppDriverInfo);
PDRIVERINFO DRVENTRY PDriverFromDeviceName         (PSZ            pszDeviceName);
HMODULE              OMNILoadDLL                   (PSZ            pszDeviceName,
                                                    PDEVICEINFO   *ppDeviceInfo,
                                                    PDRIVERINFO   *ppDriverInfo,
                                                    PDLLUSEAGE    *ppDLLuseage);
void                 OMNIFreeDLL                   (PDLLUSEAGE     pDLLuseage);
#else
PDEVICEINFO DRVENTRY PDeviceFromDeviceName         (PSZ            pszDeviceName);
PDRIVERINFO DRVENTRY PDriverFromDeviceName         (PSZ            pszDeviceName,
                                                    PDEVICEINFO   *ppDeviceInfo);
BOOL DRVENTRY        FindDeviceNameInDriver        (PSZ            pszDeviceName,
                                                    PDRIVERINFO   *ppDriverInfo,
                                                    PDEVICEINFO   *ppDeviceInfo);
#endif

// @100713 - added SHORT for sCountryCode for NLS code switches
BOOL  DRVENTRY       SetDriverDataDefaults         (PDEVICEINFO,
                                                    PJOBPROPERTIES,
                                                    PSZ,
                                                    ULONG);
BOOL  DRVENTRY       SetPrinterPropDefaults        (PDEVICEINFO,
                                                    PPRNPROPERTIES,
                                                    PSZ);
PSZ   DRVENTRY       Strip                         (PSZ psz,
                                                    PSZ pszOption,
                                                    PSZ pszStripSet);
BOOL                 StrToken                      (PSZ,
                                                    PSZ,
                                                    CHAR,
                                                    USHORT);
PDRIVDATA            ReturnDriverData              (PDEVICEBLOCK,
                                                    PDLGINSTANCE,
                                                    PVOID,
                                                    PDRIVDATA,
                                                    PSZ,
                                                    BOOL,
                                                    PDEVICEINFO,
                                                    PDRIVERINFO);
BOOL                 FindLogAddress                (HMCB,
                                                    PSZ,
                                                    PSZ *);
VOID                 FindDeviceName                (PVOID pvHeap,
                                                    PSZ   pszDeviceName,
                                                    PSZ   pszLogicalAddress,
                                                    BOOL  fDevPostDeviceModes);
PSZ                  FindPrinterName               (PVOID pvHeap,
                                                    PSZ   pszDeviceName,
                                                    PSZ   pszLogicalAddress,
                                                    BOOL fDevPostDeviceModes);
PSZ                  PrinterNameFromDeviceName     (HMCB,
                                                    PSZ,
                                                    PSZ *);
BOOL                 LogAddrFromOmniDefaultPrinter (HMCB,
                                                    PSZ,
                                                    ULONG);
BOOL                 LogAddrFromOmniDevice         (HMCB,
                                                    PSZ,
                                                    PSZ,
                                                    ULONG);
BOOL                 IsItADriverName               (PSZ);
ULONG                NumberOfDeviceNames           (VOID);
BOOL                 ValidateDriverData            (PJOBPROPERTIES,
                                                    PPRNPROPERTIES, // @JPN2H99
                                                    PDRIVERINFO,
                                                    PDEVICEINFO);
BOOL                 ValidatePrinterProperties     (PPRNPROPERTIES);
BOOL                 ReadDefaultJobProperties      (PSZ            pszAppName,
// begin @EXJOB
                                                    PVOID          pVoid,
                                                    PULONG         pulRead);
//                                                  PVOID          pVoid);
// end @EXJOB
BOOL                 SavePrinterProperties         (PSZ            pszAppName,
                                                    PPRNPROPERTIES pPrnProps);
BOOL                 ReadPrinterProperties         (PSZ            pszAppName,
                                                    PPRNPROPERTIES pPrnProps,
                                                    PDEVICEINFO    pDevice);

BOOL  DRVENTRY       GetCountryInfo                (PCOUNTRYCODE   pcc,
                                                    PCOUNTRYINFO   pci);
VOID                 GetEAVersion                  (PSZ            pszStrVersion,
                                                    ULONG          cbLength);

// begin @EXJOB
ULONG                GetJobpropertiesSize          (PDEVICEINFO    pDevice,
                                                    ULONG          fType);
BOOL                 HasDeviceJobProperties        (PDEVICEINFO    pDevice,
                                                    PJOBPROPERTIES pJobProperties);
PBYTE                GetDeviceJobProperties        (PDEVICEINFO    pDevice,
                                                    PJOBPROPERTIES pJobProperties);
ULONG                SafeCopyJobData               (PDEVICEINFO    pDevice,
                                                    PBYTE          pSource,
                                                    ULONG          ulTarget,
                                                    PBYTE          pTarget);
// end @EXJOB

PSZ                  SafeStrNCpy                   (PSZ            pszOut,
                                                    PSZ            pszIn,
                                                    ULONG          cbLength);

#define MAX_VERNAME_SIZE                128             // length of version name DCR1399

/*-------------------------------------------*/
/* MEDIAS.C prototypes                       */
/*-------------------------------------------*/
VOID                 FillMediaList                 (HWND,
                                                    PDLGINSTANCE,
                                                    PDEVICEINFO,
                                                    ULONG);
BOOL                 MediaNameFromID               (PDRIVERINFO,
                                                    PDEVICEINFO,
                                                    PSZ,
                                                    ULONG);
BOOL                 MediaInfoFromID               (PDRIVERINFO,
                                                    PDEVICEINFO,
                                                    ULONG,
                                                    PPMEDIAINFO);


/*-------------------------------------------*/
/* NEWFRAME.C prototypes                     */
/*-------------------------------------------*/
INT                  GrabPrintHeadBand             (PBYTE        pbBits,
                                                    PBYTE        pbBuffer,
                                                    INT          iMaxX,
                                                    INT          iCurrentY,
                                                    INT          iBytePerColumn,
                                                    INT          iBytesInArray,
                                                    BOOL         fInterleaved,
                                                    PINT         piMaxRight);
BYTE                 GrabColumnByte                (PBYTE        pbBits,
                                                    INT          x,
                                                    INT          y,
                                                    INT          iOffset,
                                                    INT          iMaxX,
                                                    INT          iBytesInArray);
#ifdef INCL_GRE_BITMAPS
PCHAR                ReturnPortraitBitmapBits      (PDDC         pddc,
                                                    PBITMAPINFO2 pbmihOUT);
#endif
BOOL _System         NewFrame                      (PDDC         pddc,
                                                    PRECTL       prectlBandLocation);


/*-------------------------------------------*/
/* SURFACE.C prototypes                      */
/*-------------------------------------------*/
LONG APIENTRY        DevicePalette                 (HDC   hdc,
                                                    PVOID pHWPalette,
                                                    PDDC  pddc,
                                                    ULONG ulFunction);
LONG APIENTRY        QueryDeviceSurface            (PDDC  pddc,
                                                    PVOID pds);


/*-------------------------------------------*/
/* TRAYS.C prototypes                        */
/*-------------------------------------------*/
BOOL                 AddUserDefinedTrayEntry       (PDEVICEINFO,
                                                    PTRAYINFO);
BOOL                 AddTrayNameToTrayInfo         (PTRAYINFO pTrayInfo);
ULONG                CreateUniqueTrayID            (PDEVICEINFO);
BOOL                 DeleteUserDefinedTrayEntry    (PDEVICEINFO,
                                                    ULONG);
VOID                 FillTrayList                  (HWND,
                                                    PDLGINSTANCE,
                                                    PDEVICEINFO,
                                                    ULONG);
VOID                 FreeUserDefinedTrayList       (PDEVICEINFO);
BOOL                 ReadUserDefinedTrayList       (PSZ,
                                                    PDEVICEINFO);
BOOL                 SaveUserDefinedTrayList       (PSZ,
                                                    PDEVICEINFO);
BOOL                 TrayInfoFromID                (PDRIVERINFO,
                                                    PDEVICEINFO,
                                                    ULONG,
                                                    PPTRAYINFO);
BOOL                 TrayNameFromID                (PDRIVERINFO,
                                                    PDEVICEINFO,
                                                    PSZ,
                                                    ULONG);


/*-------------------------------------------*/
/* UTIL.ASM prototypes                       */
/*-------------------------------------------*/
#ifdef DEBUG

// in debug version, int3 calls assembler code to execute int 3 (opcode 0xCC)

void                 int3                          (void);

// function to tell Periscope users address of globals and procdata
// _Optlink linkage puts argument 1 in EAX, argument 2 in EDX, and argument 3 in ECX

void _Optlink        Periscope                     (PVOID pv1,
                                                    PVOID pv2,
                                                    PVOID pv3);

// breakpoint() -- a call to an int3 used by _assert helper function

void                 breakpoint                    (void);

  // DebugPause() -- yet another int3
void                 DebugPause                    (void);

#else

  // in retail version, these functions become nop macros
  #define int3()
  #define Periscope( a,b,c )
  #define DebugPause()
  #define breakpoint()

#endif

ULONG _Optlink       EndianSwapULong               (ULONG ul);


/**********************************************************************/
/* NOTE: The following are used only for Graphics Engines v2.1 or 2.0 */
/**********************************************************************/

/*-------------------------------------------*/
/* ATTRIB.C prototypes                       */
/*-------------------------------------------*/
#ifdef INCL_GRE_DEVMISC1

LONG ENGENTRY        DeviceSetAttributes           (HDC            hdc,
                                                    ULONG          ulBType,
                                                    ULONG          ulDefsMask,
                                                    ULONG          flAttrsMask,
                                                    PBUNDLE        pAttrs,
                                                    PDDC           pddc,
                                                    ULONG          ulFunction);

LONG ENGENTRY        DeviceGetAttributes           (HDC            hdc,
                                                    LONG           lPrimType,
                                                    ULONG          ulAttrsMask,
                                                    PBUNDLE        pAttrs,
                                                    PDDC           pddc,
                                                    ULONG          ulFunction);

LONG ENGENTRY        DeviceSetGlobalAttribute      (HDC            hdc,
                                                    LONG           lAttrType,
                                                    LONG           lAttribute,
                                                    ULONG          flOptions,
                                                    PDDC           pddc,
                                                    ULONG          ulFunction);

LONG ENGENTRY        GetPairKerningTable           (HDC            hdc,
                                                    LONG           cKernPairs,
                                                    PKERNINGPAIRS  pKerningPairs,
                                                    PDDC           pddc,
                                                    ULONG          ulFunction);
#endif



/*-------------------------------------------*/
/* BITMAP.C prototypes                       */
/*-------------------------------------------*/
#ifdef INCL_GRE_BITMAPS

LONG ENGENTRY        Bitblt                        (HDC            hdc,
                                                    HDC            hdcSource,
                                                    LONG           cPoints,
                                                    PPOINTL        paPoints,
                                                    LONG           lRop,
                                                    ULONG          flOptions,
                                                    PBITBLTATTRS   pAttrs,
                                                    PDDC           pddc,
                                                    ULONG          ulFunction);

LONG ENGENTRY        DeviceCreateBitmap            (HDC            hdc,
                                                    PBITMAPINFOHEADER pInfoHeader,
                                                    ULONG          flUsage,
                                                    PBYTE          pBitmapBits,
                                                    PBITMAPINFO    pInfo,
                                                    PDDC           pddc,
                                                    ULONG          ulFunction);

LONG ENGENTRY        DeviceDeleteBitmap            (HDC            hdc,
                                                    ULONG          hbm,
                                                    PDELETERETURN  pdr,
                                                    ULONG          flOptions,
                                                    PDDC           pddc,
                                                    ULONG          ulFunction);



LONG ENGENTRY        DeviceSelectBitmap            (HDC            hdc,
                                                    ULONG          hbm,
                                                    PDDC           pddc,
                                                    ULONG          ulFunction);

LONG ENGENTRY        DrawBits                      (HDC            hdc,
                                                    PBYTE          pBitmapBits,
                                                    PBITMAPINFO    pInfo,
                                                    LONG           cPoints,
                                                    PPOINTL        paPoints,
                                                    LONG           lRop,
                                                    ULONG          flOptions,
                                                    PDDC           pddc,
                                                    ULONG          ulFunction);

LONG ENGENTRY        DrawBorder                    (HDC            hdc,
                                                    PRECTL         prectl,
                                                    ULONG          cxBorder,
                                                    ULONG          cyBorder,
                                                    LONG           clrBorder,
                                                    LONG           clrInterior,
                                                    ULONG          flCmd,
                                                    PDDC           pddc,
                                                    ULONG          ulFunction);

LONG ENGENTRY        GetBitmapBits                 (HDC            hdc,
                                                    ULONG          hbm,
                                                    LONG           lScanStart,
                                                    LONG           lScanCount,
                                                    PBYTE          pBitmapBits,
                                                    PBITMAPINFO    pInfo,
                                                    PDDC           pddc,
                                                    ULONG          ulFunction);

LONG ENGENTRY        GetPel                        (HDC            hdc,
                                                    PPOINTL        pPel,
                                                    PDDC           pddc,
                                                    ULONG          ulFunction);

LONG ENGENTRY        ImageData                     (HDC            hdc,
                                                    PBYTE          pData,
                                                    LONG           cBits,
                                                    ULONG          ulRowOffset,
                                                    PDDC           pddc,
                                                    ULONG          ulFunction);

LONG ENGENTRY        SetBitmapBits                 (HDC            hdc,
                                                    ULONG          hbm,
                                                    LONG           lScanStart,
                                                    LONG           lScanCount,
                                                    PBYTE          pBitmapBits,
                                                    PBITMAPINFO    pInfo,
                                                    PDDC           pddc,
                                                    ULONG          ulFunction);

LONG ENGENTRY        SetPel                        (HDC            hdc,
                                                    PPOINTL        pPel,
                                                    PDDC           pddc,
                                                    ULONG          ulFunction);
#endif


// -------------------------------------------------------------------------------------------------------------------------
// clrtable.c

#ifdef INCL_GRE_COLORTABLE

LONG ENGENTRY        CreateLogColorTable           (HDC            hdc,
                                                    ULONG          flOptions,
                                                    LONG           lFormat,
                                                    LONG           lStart,
                                                    LONG           cCount,
                                                    PLONG          pData,
                                                    PDDC           pddc,
                                                    ULONG          ulFunction);

LONG ENGENTRY        QueryColorData                (HDC            hdc,
                                                    LONG           cArray,
                                                    PLONG          pArray,
                                                    PDDC           pddc,
                                                    ULONG          ulFunction);

LONG ENGENTRY        QueryColorIndex               (HDC            hdc,
                                                    ULONG          flOptions,
                                                    LONG           rgbColor,
                                                    PDDC           pddc,
                                                    ULONG          ulFunction);


LONG ENGENTRY        QueryLogColorTable            (HDC            hdc,
                                                    ULONG          flOptions,
                                                    LONG           lStart,
                                                    LONG           cArray,
                                                    PLONG          pArray,
                                                    PDDC           pddc,
                                                    ULONG          ulFunction);

LONG ENGENTRY        QueryNearestColor             (HDC            hdc,
                                                    ULONG          flOptions,
                                                    LONG           rgbColorin,
                                                    PDDC           pddc,
                                                    ULONG          ulFunction);

LONG ENGENTRY        QueryRealColors               (HDC            hdc,
                                                    ULONG          flOptions,
                                                    LONG           lStart,
                                                    LONG           cArray,
                                                    PLONG          pArray,
                                                    PDDC           pddc,
                                                    ULONG          ulFunction);

LONG ENGENTRY        QueryRGBColor                 (HDC            hdc,
                                                    ULONG          flOptions,
                                                    LONG           lColor,
                                                    PDDC           pddc,
                                                    ULONG          ulFunction);

LONG ENGENTRY        RealizeColorTable             (HDC            hdc,
                                                    PDDC           pddc,
                                                    ULONG          ulFunction);

LONG ENGENTRY        UnrealizeColorTable           (HDC            hdc,
                                                    PDDC           pddc,
                                                    ULONG          ulFunction);

#endif



// -------------------------------------------------------------------------------------------------------------------------
// devfunc2.c

#ifdef INCL_GRE_DEVMISC2

LONG ENGENTRY        DeviceQueryFontAttributes     (HDC            hdc,
                                                    ULONG          cMetrics,
                                                    PFONTMETRICS   pfm,
                                                    PDDC           pddc,
                                                    ULONG          ulFunction);

LONG ENGENTRY        DeviceQueryFonts              (HDC            hdc,
                                                    ULONG          flOptions,
                                                    PSZ            pszFacename,
                                                    PFONTMETRICS   pfm,
                                                    ULONG          cMetrics,
                                                    PLONG          pcFonts,
                                                    PDDC           pddc,
                                                    ULONG          ulFunction);

LONG ENGENTRY        ErasePS                       (HDC            hdc,
                                                    PDDC           pddc,
                                                    ULONG          ulFunction);

LONG ENGENTRY        NotifyClipChange              (HDC            hdc,
                                                    PRECTL         prclBound,
                                                    ULONG          cRect,
                                                    ULONG          idClipPath,
                                                    PDDC           pddc,
                                                    ULONG          ulFunction);

LONG ENGENTRY        NotifyTransformChange         (HDC            hdc,
                                                    ULONG          flFlags,
                                                    PNOTIFYTRANSFORMDATA pXformdata,
                                                    PDDC           pddc,
                                                    ULONG          ulFunction);

LONG ENGENTRY        RealizeFont                   (HDC            hdc,
                                                    ULONG          cmdCommand,
                                                    PFATTRS        pLogFont,
                                                    PULONG         pFont,
                                                    PDDC           pddc,
                                                    ULONG          ulFunction);


LONG ENGENTRY        RealizeFont                   (HDC            hdc,
                                                    ULONG          cmdCommand,
                                                    PFATTRS        pLogFont,
                                                    PULONG         pFont,
                                                    PDDC           pddc,
                                                    ULONG          ulFunction);

LONG ENGENTRY        GetStyleRatio                 (HDC            hdc,
                                                    PBYTE          pRatio,
                                                    PDDC           pddc,
                                                    ULONG          ulFunction);

LONG ENGENTRY        SetStyleRatio                 (HDC            hdc,
                                                    PBYTE          pRatio,
                                                    PDDC           pddc,
                                                    ULONG          ulFunction);

#endif




// -------------------------------------------------------------------------------------------------------------------------
// devfunc3.c

#ifdef INCL_GRE_DEVMISC3

LONG ENGENTRY        AccumulateBounds              (HDC            hdc,
                                                    PRECTL         prclRect,
                                                    PDDC           pddc,
                                                    ULONG          ulFunction);

LONG ENGENTRY        DeviceSetDCOrigin             (HDC            hdc,
                                                    PPOINTL        pptlDC,
                                                    PDDC           pddc,
                                                    ULONG          ulFunction);

LONG ENGENTRY        GetBoundsData                 (HDC            hdc,
                                                    ULONG          flOptions,
                                                    PRECTL         pBoundsData,
                                                    PDDC           pddc,
                                                    ULONG          ulFunction);

LONG ENGENTRY        GetCodePage                   (HDC            hdc,
                                                    PDDC           pddc,
                                                    ULONG          ulFunction);


LONG ENGENTRY        GetDCOrigin                   (HDC            hdc,
                                                    PPOINTL        pptlOrigin,
                                                    PDDC           pddc,
                                                    ULONG          ulFunction);

LONG ENGENTRY        GetLineOrigin                 (HDC            hdc,
                                                    PPOINTL        pptlXY,
                                                    PDDC           pddc,
                                                    ULONG          ulFunction);

LONG ENGENTRY        LockDevice                    (HDC            hdc,
                                                    PDDC           pddc,
                                                    ULONG          ulFunction);

LONG ENGENTRY        ResetBounds                   (HDC            hdc,
                                                    ULONG          flOptions,
                                                    PDDC           pddc,
                                                    ULONG          ulFunction);

LONG ENGENTRY        SetCodePage                   (HDC            hdc,
                                                    LONG           lCodePage,
                                                    PDDC           pddc,
                                                    ULONG          ulFunction);

LONG ENGENTRY        SetLineOrigin                 (HDC            hdc,
                                                    PPOINTL        pptlXY,
                                                    ULONG          lStyle,
                                                    PDDC           pddc,
                                                    ULONG          ulFunction);

LONG ENGENTRY        UnlockDevice                  (HDC            hdc,
                                                    PDDC           pddc,
                                                    ULONG          ulFunction);

#endif


// -------------------------------------------------------------------------------------------------------------------------
// devmisc.c
#ifdef INCL_GRE_PICK

LONG ENGENTRY        GetPickWindow                 (HDC            hdc,
                                                    PRECTL         prectlPickWindow,
                                                    PDDC           pddc,
                                                    ULONG          ulFunction);

LONG ENGENTRY        SetPickWindow                 (HDC            hdc,
                                                    PRECTL         prectlPickWindow,
                                                    PDDC           pddc,
                                                    ULONG          ulFunction);

#endif


// -------------------------------------------------------------------------------------------------------------------------
// djp.c
APIRET               InnerDeviceQuery              (ULONG          ulFuncNum,
                                                    PDEVICEBLOCK   pdb,
                                                    PDRIVDATA      pGoodDrivData,
                                                    ULONG          cbParm1,
                                                    PBYTE          pbParm1,
                                                    ULONG          cbParm2,
                                                    PBYTE          pbParm2);


// -------------------------------------------------------------------------------------------------------------------------
// escape.c

#ifdef INCL_GRE_DEVICE


LONG ENGENTRY Escape                               (HDC            hdc,
                                                    LONG           lEscape,
                                                    LONG           cInCount,
                                                    PBYTE          pInData,
                                                    PLONG          pcOutCount,
                                                    PBYTE          pOutData,
                                                    PDDC           pddc,
                                                    ULONG          ulFunction);

#endif



// -------------------------------------------------------------------------------------------------------------------------
// line.c

#ifdef INCL_GRE_LINES


LONG ENGENTRY        DisjointLines                 (HDC            hdc,
                                                    PPOINTL        paptlPoint,
                                                    LONG           cPoints,
                                                    PDDC           pddc,
                                                    ULONG          ulFunction);

LONG ENGENTRY        DrawLinesInPath               (HDC            hdc,
                                                    PRECTL         prclBound,
                                                    PCURVE         pLine,
                                                    ULONG          cLines,
                                                    PDDC           pddc,
                                                    ULONG          ulFunction);

LONG ENGENTRY        GetCurrentPosition            (HDC            hdc,
                                                    PPOINTL        paptlPosition,
                                                    PDDC           pddc,
                                                    ULONG          ulFunction);

LONG ENGENTRY        PolyLine                      (HDC            hdc,
                                                    PPOINTL        paptlPoint,
                                                    LONG           cPoints,
                                                    PDDC           pddc,
                                                    ULONG          ulFunction);

LONG ENGENTRY        PolyScanline                  (HDC            hdc,
                                                    PSCANDATA      pScanData,
                                                    PDDC           pddc,
                                                    ULONG          ulFunction);

LONG ENGENTRY        PolyShortLine                 (HDC            hdc,
                                                    PSHORTLINE     pShortLine,
                                                    PDDC           pddc,
                                                    ULONG          ulFunction);

LONG ENGENTRY        SetCurrentPosition            (HDC            hdc,
                                                    PPOINTL        pptlPosition,
                                                    PDDC           pddc,
                                                    ULONG          ulFunction);


#endif

// -------------------------------------------------------------------------------------------------------------------------
// marker.c
#ifdef INCL_GRE_MARKERS


LONG ENGENTRY        PolyMarker                    (HDC            hdc,
                                                    PPOINTL        paptlPoint,
                                                    LONG           cPoints,
                                                    PDDC           pddc,
                                                    ULONG          ulFunction);

#endif

// -------------------------------------------------------------------------------------------------------------------------
// query.c
#ifdef INCL_GRE_DEVICE

LONG ENGENTRY        QueryDeviceBitmaps            (HDC            hdc,
                                                    PLONG          paOutData,
                                                    LONG           cOutData,
                                                    PDDC           pddc,
                                                    ULONG          ulFunction);

// NOTE: This entrypoint is used by all levels of GRE (v2.0 +++)
LONG ENGENTRY        QueryDeviceCaps               (HDC            hdc,
                                                    LONG           lIndex,
                                                    PLONG          paOutData,
                                                    LONG           cOutData,
                                                    PDDC           pddc,
                                                    ULONG          ulFunction);

LONG ENGENTRY        QueryDevResource2             (HDC            hdc,
                                                    ULONG          lType,
                                                    ULONG          id,
                                                    PDDC           pddc,
                                                    ULONG          ulFunction);

// NOTE: This entrypoint is used by all levels of GRE (v2.0 +++)
LONG ENGENTRY        QueryHardcopyCaps             (HDC            hdc,
                                                    LONG           lStart,
                                                    LONG           cCount,
                                                    PHCINFO        pInfo,
                                                    PDDC           pddc,
                                                    ULONG          ulFunction);
VOID ENGENTRY        InnerQueryCaps                (LONG           lCap,
                                                    PLONG          plCap,
                                                    PLONG          plShadowCaps,
                                                    PDEVICEBLOCK   pdb);

#endif



// -------------------------------------------------------------------------------------------------------------------------
// text.c
#ifdef INCL_GRE_STRINGS

LONG ENGENTRY        CharString                    (HDC            hdc,
                                                    LONG           cChars,
                                                    PCHAR          pchString,
                                                    PDDC           pddc,
                                                    ULONG          ulFunction);

LONG ENGENTRY        CharStringPos                 (HDC            hdc,
                                                    PPOINTL        pptlStart,
                                                    PRECTL         prclRect,
                                                    ULONG          flOptions,
                                                    LONG           cChars,
                                                    PCHAR          pchString,
                                                    PLONG          paDX,
                                                    PCSP_INFO      pAttrs,
                                                    PDDC           pddc,
                                                    ULONG          ulFunction);

LONG ENGENTRY        QueryCharPositions            (HDC            hdc,
                                                    PPOINTL        pptlStart,
                                                    ULONG          flOptions,
                                                    LONG           cChars,
                                                    PCHAR          pchString,
                                                    PLONG          paDX,
                                                    PPOINTL        paptlXY,
                                                    PDDC           pddc,
                                                    ULONG          ulFunction);

LONG ENGENTRY        QueryTextBox                  (HDC            hdc,
                                                    LONG           cChars,
                                                    PCHAR          pchString,
                                                    LONG           cptPosition,
                                                    PPOINTL        paptlPosition,
                                                    PDDC           pddc,
                                                    ULONG          ulFunction);

LONG ENGENTRY        QueryWidthTable               (HDC            hdc,
                                                    LONG           lFirstChar,
                                                    LONG           cWidthTable,
                                                    PLONG          paWidthTable,
                                                    PDDC           pddc,
                                                    ULONG          ulFunction);
#endif

// --------------------------------------------------------------------------------------------------------------------
// Inner GRE graphics engine calls
// Inner GRE entries let printer drivers enter the graphics engine without transform mod's that occur at normal GRE entry.

#ifdef INCL_INNER_GRE
#include "innergre.h"
#endif
