/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1992 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 source code is provided to you solely for       */
/*    the purpose of assisting you in your development of OS/2 device        */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Developer Connection Device Driver       */
/*    Source Kit for OS/2. This Copyright statement may not be removed.      */
/*                                                                           */
/*****************************************************************************/
/****************************************************************************/
/* MODULE NAME    : Omni Driver Main Header File                            */
/* SOURCE NAME    : DRIVER.H                                                */
/* AUTHOR         : Matt Rutkowski & Mark Hamzy                             */
/* DESCRIPTION    :                                                         */
/*                                                                          */
/*                                                                          */
/*--------------------------------------------------------------------------*/
/* CHANGE/MODIFICATION LOG :                                                */
/*--------------------------------------------------------------------------*/
/*                                                                          */
/* @100713 - 10/04/94 - MFR [IBM] - Need to default to A4 for most          */
/*                                  countries but USA, Canada, and Brazil.  */
/*                                  Also default to CM not inches.          */
/* @168907 - 09/16/96 - MFR [IBM] - Removed Device-Specific bit fields and  */
/*                                  moved them from "core" Omni Driver to   */
/*                                  the device files that actually use them */
/* @3632   - 04/08/98 - UCC [IBMJ]- Add 2 flag for DevFnt sup use.          */
/*                                  fRecoding is for HiRes devfnt print prob*/
/*                                  fOldDevfnt is for backward compatibility*/
/* @EXJOB  - 07/13/98 - UCC [IBMJ]- Expansible job data support             */
/* @JPN2H99- 08/01/99 - UCC [IBMJ]- Japanese driver enhancement 2h99        */
/****************************************************************************/

#define APP_NAME "OMNI"
// *** #define POWER_PC

#define INCL_GENPLIB_ASSERT
#define INCL_GENPLIB_THREAD
#define INCL_GENPLIB_MEMORY
#define INCL_GENPLIB_JOURNAL
#define INCL_GENPLIB_HANDLER
#define INCL_GENPLIB_ERROR
#define INCL_GENPLIB_UTIL
#define INCL_GENPLIB_DITHER
#define INCL_GENPLIB_THREAD_WRITE
#define INCL_GENPLIB_COMPRESS
#define INCL_GENPLIB_FAX
#define INCL_GENPLIB_STRINGSORT
#define INCL_GENPLIB_DBCS
#define INCL_GENPLIB_LAYOUT 

#include <genplib.h>

#ifdef SRCDEBUG
#include <builtin.h>
#endif

#include "help.h"
#include "debug.h"

// Define signatures used to validate global data memory
#define BEGIN_GLOBAL                         0x424f4c47
#define END_GLOBAL                           0x454f4c47

/* The following are defines for the ulDeviceBits */
// @168907 - MFR - Removed Device-Specific bit fields and moved them from
// "core" Omni Driver to the device files that actually use them
// #define DEV_MIRROR              0x00000001  // enable mirror check box
// #define DEV_FGCOLOR             0x00000002  // @PJ - enable fore/background color
// #define DEV_DEPLETION           0x00000004  // @DJ - Device supports ink depletion
// #define DEV_MAX_CLR_SUPP_CMY    0x00000008  // @DJ - Device supports CMY not K
// #define DEV_MAX_CLR_SUPP_CMYK   0x00000010  // @DJ - Device supports CMYK
// #define DEV_GRAY_BALANCE        0x00000020  // @DJ - Device supports gray balance
// #define DEV_DYNAMIC_PRINT_MODE  0x00000040  // @Ca - Device supports gray balance
// #define DEV_SHINGLE             0x00000080  // @DJ - Device supports dot spacing
// #define DEV_SUPPORT_DUPLEX      0x00000100  // Device supports Duplexing

// orientation settings
#define ORIENTATION_PORTRAIT                 1
#define ORIENTATION_LANDSCAPE                2

// Duplex options
#define DUPLEX_NONE                          0
#define DUPLEX_FLIP                          1
#define DUPLEX_BOOK                          2

// FF Control Options
#define FF_CTL_CONDITIONAL                   0
#define FF_CTL_NONE                          1
#define FF_CTL_COMPULSORY                    2

// ulJobPhaseControl options
#define JPC_OMNI_GENERATED_JOB               0x00000001L  // Spooled phase #1 by omni
#define JPC_FORM_FEED_SEEN                   0x00000002L  // Form feed seen at end of block
                                                          //    in datastream
#define JPC_OMNI_ALREADY_SPOOLED             0x00000004L  // Spooling phase #2 by omni
#define JPC_OMNI_GENERATED_RAW_JOB           0x00000008L  // Spooled PM_Q_RAW phase #1 by omni

// ----------------------------------------------------------------------------
// DRIVERDATA structure
//-----------------------------------------------------------------------------
//
// The DRIVERDATA structure is driver-specific data.  The driver uses its
// contents to control the printing of a job.  The items contained are often
// called job properties.  This driver calls the structure DRIVERDATA.  It is
// extended from the structure DRIVDATA in OS2DEF.H.
//
// PM application programmers know this structure as DRIVDATA, and they are
// required to handle it.  Application programmers should make no assumptions
// about the contents of DRIVDATA other than what is defined in OS2DEF.H.  Only
// the device drivers know the extended format and content.
//
// Applications get copies of DRIVDATA from calling SplEnumQueue().
// The DRIVDATA returned is used in calls to DevPostDeviceModes() and
// DevOpenDC().  Applications rely on the device driver to massage the data in
// DRIVDATA.  DevPostDeviceModes() is the best way to massage job properties
// whose settings are contained in DRIVDATA.
//
// Print driver code modifications over time will affect the data structure
// DRIVERDATA.  As the DRIVERDATA structure morphs, then a new version number
// for the DRIVERDATA structure must be assigned so the driver can distinguish
// different versions of DRIVERDATA.  Versioning is of little concern on a
// single, standalone OS/2 system because there is only one driver, and it is
// not required to interact with other versions.  However, in the LAN
// environment, versioning is an important concern.  In the field, expect your
// customers to install different versions of your printer driver on LAN
// requestors and servers.
//
// A copy of DRIVERDATA travels over the LAN when an OS/2 LAN requestor prints
// PM_Q_STD jobs to an OS/2 LAN server.  A printer server should be able to
// understand DRIVERDATA structures submitted from any requestor -- even from
// requestors that have a newer version of the driver than the server!
//
// This version number should not be confused with the version number reported
// at QueryDeviceCaps() time.  That version number is examined by the graphics
// engine.  The version number in DRIVERDATA is meant to be interpreted by the
// printer driver only.
//
// Rules of thumb:
//
//  . when assigning a new version number, raise the old version number by one
//  . when morphing the DRIVERDATA structure, never collapse it, just grow it
//
//-----------------------------------------------------------------------------

// version number(s) for DRIVERDATA structure
#define DRIVERDATA_VERSION                   0x0100
// begin @EXJOB
// @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
// @@@@@ Update DRIVERDATA_VERSION procedure...         @@@@@
// @@@@@ 1.Increment version number                     @@@@@
// @@@@@ 2.Update DRIVERDATA_VERSION_CURRENT            @@@@@
// @@@@@ 3 ???                                          @@@@@
// @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
#define DRIVERDATA_VERSION_101               0x0101
#define DRIVERDATA_VERSION_CURRENT           DRIVERDATA_VERSION_101

#define JP_SIZE_CORE        0x0001
#define JP_SIZE_PLUGIN      0x0002
#define JP_SIZE_ALL         0x0003
// end @EXJOB

/*************** I M P O R T A N T pragma follows ! ! ! ***************/
#pragma pack(1)

#define JOBPROP_SIG                          0x00424F4A        // 'JOB'
typedef struct _JobProperties  {
/* WARNING: Changing the order, adding, or deleting any of the following
**          field has repercussions!
**          You must make the same changes in epson.c, deskjet.c, paintjet.c
**                                            laserjet.c, and postscript.c
*/
   LONG    cb;                           // length of the overall structure in bytes
   CHAR    achDriver[9];                 // Name of the driver (for verification)
   ULONG   ulSig;                        // Job properties signature
   ULONG   ulOrientation;                // orientation of form is a job property
   ULONG   ulCopies;                     // count of uncollated copies; see NEWFRAME.C
   ULONG   ulDefConnID;                  // Default Form Connection (Tray, Form & Media Type)
   ULONG   ulDefNonMetricConnID;         // @100713 - Default Form Conn. for non-metric countries
   ULONG   ulDefFontID;                  // Default Font
   ULONG   ulDefResID;                   // Default Resolution (print quality)
   ULONG   ulDefPrintModeID;             // Default Print Mode (mono/color etc.)
   ULONG   ulCompressModes;              // compress modes selected for the job
   USHORT  usForeground;                 // foreground color selected
   USHORT  usBackground;                 // background color selected
   ULONG   ulImageoption;                // Image options:  IMAGE_OPTION_MIRROR
                                         // uses bit 0, other bits are free to use
   ULONG   ulAlgorithm;                  // HalfToning Algorithms
   ULONG   ulLevel;                      // Level Number 1-254 for the Level HalfToning Algorithm
   LONG    lHue;                         // % deviation from current color along circle
                                         // (which is midpoint of C1 and C2 primaries)
   LONG    lSaturation;                  // % deviation from current color along radius
                                         // (which is 255==white center and 0==full color
                                         // along rim of circle)
   LONG    lValue;                       // % deviation from current color's darkness value
                                         // (which is 255==white base of cone to 0==black
                                         // at tip of cone)
   LONG    lDarkness;                    // % deviation from current color's darkness value
                                         // (which is 255==white to 0==black)
   BYTE    bFFControlType;               // Bit field for FF control desired
   ULONG   ulJobPhaseControl;            // Bit field for controling output b/w phase 1 and 2
   LONG    lRedAdjust;                   // Red Color Adjustment
   LONG    lGreenAdjust;                 // Green Color Adjustment
   LONG    lBlueAdjust;                  // Blue Color Adjustment
   LONG    lRedBias;                     // Bias of Red Gamma
   LONG    lGreenBias;                   // Bias of Green Gamma
   LONG    lBlueBias;                    // Bias of Blue Gamma
   ULONG   ulDuplexOptions;              // Duplex Options
   SHORT   sBlackAdjust;                 // Black Color Adjustment
   BYTE    bBlackBias;                   // Bias of Black Gamma
   BYTE    bUnused;                      // Black Reduction %
   ULONG   ulreserved[2];
   GLCB    LayoutCB;                     
} JOBPROPERTIES, *PJOBPROPERTIES;

// begin @EXJOB
//
// Device Specific JobProperties must have next footer
// Data must be growable from BOTTOM to TOP.
//
typedef struct _DeviceJobProperties  {
   ULONG   ulDeviceID;                   // Device ID
   ULONG   ulSig;                        // Device jobdata signature
   ULONG   ulVersion2;                   // Device jobdata version
   ULONG   cb2;                          // Device specific jobdata size
} DEVICEJOBPROPERTIESFOOTER, *PDEVICEJOBPROPERTIESFOOTER;
// end @EXJOB

#define PRINTPROP_SIG                        0x00545250       // 'PRT'
typedef struct _PrinterProperties  {
   LONG    cb;                           // length of the overall structure in bytes
   CHAR    achDriver[9];                 // Name of the driver (for verification)
   ULONG   ulSig;                        // Printer properties signature
   ULONG   ulInstalledMemory;            // Memory currently installed
// begin @JPN2H99
// ULONG   ulReserved[10];               // Reserved for future growth
   ULONG   fOmniOptions;                 // Option flags for core control
                                         // This field is reserved for option
                                         // equipment control by OMNI core
   ULONG   fDeviceOptions;               // Option flags for device control
                                         // This field is reserved for option
                                         // equipment control by plug-ins.
                                         // OMNI core code should not refer to
                                         // this flag.
   ULONG   ulReserved[8];                // Reserved for future growth
// end @JPN2H99
} PRNPROPERTIES, *PPRNPROPERTIES;

// begin @JPN2H99
#define OMNI_OPTION_DUPLEX_BOOK         0x00000010
#define OMNI_OPTION_DUPLEX_FLIP         0x00000020
#define OMNI_OPTION_DUPLEX_BOTH         (OMNI_OPTION_DUPLEX_BOOK | OMNI_OPTION_DUPLEX_FLIP)
#define OMNI_OPTION_DEVICEFONT_OFF      0x10000000
// end @JPN2H99

/*************** I M P O R T A N T pragma follows ! ! ! ! ***************/
#pragma pack()

/*
**  The DRIVDATA structure defines one byte for driver profile information.
**  So the total size of data is sizeof(DRIVDATA) - sizeof(the one byte) +
**  sizeof(the actual driver profile info).
**  However, beware double word aligned structures.  If DRIVDATA is DWORD
**  aligned then you cannot subtract sizeof (CHAR) to get the correct
**  size since it has padding.  Therefore, it is safer to just add up
**  each element than to subtract off the last element.
*/
#define DRIVDATA_HEADER ( sizeof (((PDRIVDATA)NULL)->cb)           \
                        + sizeof (((PDRIVDATA)NULL)->lVersion)     \
                        + sizeof (((PDRIVDATA)NULL)->szDeviceName) \
                        )
#define DRIVERDATA_SIZE (DRIVDATA_HEADER + sizeof (JOBPROPERTIES))

#define PRINTERPROP_SIZE (sizeof (PRNPROPERTIES))

#include "device.h"
#include "forms.h"

// conversion constants
#define INCHES_PER_METER                     39.37
#define HMM_PER_INCH                         2540.0
#define POINTS_IN_AN_INCH                    72

// *NOTE - copied from pmspl.h as max field lengths
//         for strings we commonly used

/* length for character arrays in structs (excluding zero terminator) */
#define CNLEN                                15     /* Computer name length      */
#define UNLEN                                20     /* Maximum user name length  */
#define QNLEN                                12     /* Queue name maximum length */
#define PDLEN                                8      /* Print destination length  */
#define DTLEN                                9      /* Spool file data type      */

/* e.g. PM_Q_STD,PM_Q_RAW    */
#define QP_DATATYPE_SIZE                     15     /* returned by SplQpQueryDt  */
#define DRIV_DEVICENAME_SIZE                 31     /* see DRIVDATA struc        */
#define DRIV_NAME_SIZE                       8      /* name of device driver     */
#define PRINTERNAME_SIZE                     32     /* max printer name length   */
#define RESNAME_SIZE                         31     /* max form name length      */
#define FORMNAME_SIZE                        31     /* max form name length      */
#define TRAYNAME_SIZE                        31     /* max form name length      */
#define MAXCOMMENTSZ                         48     /* document comment length   */


// maximums
#define MAX_DATATYPES                        2      // PM_Q_STD and PM_Q_RAW
#define MAX_UNCOLLATEDCOPIES                 10     // referenced in DLG.C

// lengths
#define LEN_DEVICENAME                       32     // same len as szDeviceName in DRIVDATA in OS2DEF.H
#define LEN_DESCRIPTION                      64
#define LEN_SHAREDHEAP                       256920 // 20 4K pages
#define LEN_DCHEAP                           81920 + 10240 

#define LEN_APPNAME                          100
#define LEN_STRING                           256

#define LEN_PATH                             512

// magic numbers
#define HMTX_CLOSED                          (HMTX)0x0DEAD1
#define PM_Q_STD                             1              // any magic number not zero
#define PM_Q_RAW                             2              // any magic number not zero

// OS2SYS.INI app/key names
#define KEYNAME_DRIVERDATA                   "DefaultJobProperties"

// printer property app/keynames
#define KEYNAME_NUM_USER_FONTS               "NumUserDefFonts"
#define KEYNAME_USER_FONTS                   "UserDefFonts"

#define KEYNAME_NUM_USER_CONNECTS            "NumUserDefConnects"
#define KEYNAME_USER_CONNECTS                "UserDefConnects"

#define KEYNAME_PRN_PROPS                    "Printer Properties"

// app/keynames
#define APPNAME_DEBUGINFO                    APP_NAME##"Driver"
#define KEYNAME_DEBUGINFO                    "DebugInfo"
#define KEYNAME_ASSERTINFO                   "Assert"
#define KEYNAME_HOOKTYPE                     "HookType"
#define KEYNAME_SHOWBITMAP                   "ShowBitmap"
#define KEYNAME_BANDSIZE                     "BandSize"

// @NLS - used to retrieve OS/2 system's country code
#define APPNAME_COUNTRYCODE                  "PM_National"
#define KEYNAME_COUNTRYCODE                  "iCountry"

// @NLS - country codes (countries that use "Letter" paper)
#define COUNTRYCODE_USA                      1
#define COUNTRYCODE_CANADA                   2

// @178797 - uses A4 now (but still leave it #defined)
#define COUNTRYCODE_BRAZIL                   55

// default font size is 12 point (10 pitch) and 6 lines per inch
#define DEFAULT_POINTSIZE                    12
#define DEFAULT_PITCH                        10

// CALLING CONVENTIONS

// calling style of driver calling internal driver helper functions
#ifdef DEBUG
  // debug version: pass args via stack, easier to kernel debug
  #define DRVENTRY                           _System
#else
  // retail version: pass args via regs, faster
  #define DRVENTRY                          _Optlink
#endif

// calling style of graphics engine and OS/2 when calling into driver
#define ENGENTRY                            _System

// macros to "enter" and "exit" a DDC
// they ensure that only one thread is using the DDC at any one time
// a thread can successfully request the same sem over and over without error
// a thread has to release it the same number of times it requested it
// the system keeps track of the use count
// error 640 is ERROR_TIMEOUT from bseerr.h

#define ENTERDDC(pddc) {\
  APIRET                rcRequestSem;\
  EXCEPTIONREPORTRECORD err;\
  memset (&err, 0, sizeof (err));\
  rcRequestSem = DosRequestMutexSem (pddc->pdb->hmtxDCSem, SEM_IMMEDIATE_RETURN);\
  assert (0 == rcRequestSem || 640 == rcRequestSem);\
  if (640 == rcRequestSem)\
  {\
     GplErrSetError (PMERR_HDC_BUSY);\
     err.ExceptionNum = XCPT_USER;\
     DosRaiseException (&err);\
  }\
}

#ifdef DEBUG

#define EXITDDC(pddc)  {                                   \
  APIRET rcReleaseSem;                                     \
  rcReleaseSem = DosReleaseMutexSem (pddc->pdb->hmtxDCSem);\
  assertT (rcReleaseSem);                                  \
}

#else

#define EXITDDC(pddc)  {                                   \
  DosReleaseMutexSem (pddc->pdb->hmtxDCSem);               \
}

#endif

// STRUCTS

//---------------------------------------------------------------------------------------------------------------------
// per process data; there is one of these structures allocated in private process memory
// for each process that loads this DLL.  It has the NONSHARED segment attribute defined
// in the DEF file because it is declared after a #pragma data_seg ( PerProcess ) in driver.c

typedef struct _dlluseage {
   HMODULE      hModuleDLL;                   // Module handle of device dll
   ULONG        ulDLLuseagecount;
   PDRIVERINFO  pDriverInfo;
   PDEVICEINFO  pDeviceInfo;
} DLLUSEAGE, *PDLLUSEAGE;

typedef struct _procdata {
   CHAR         szAssert[64];                 // expression asserted
   CHAR         szFilename[64];               // filename where assertion failed
   ULONG        ulLine;                       // line number where assertion failed
   ULONG        ulLastError;                  // error id from WinGetLastError
   PID          pid;                          // process id
   HMTX         hmtxGlobalSem;                // handle to shared, global, named, system-wide mutex sem
   HMTX         hmtxProcessSem;               // handle to private, process sem for serialization
   HDC          hdcDirectShadow;              // /*@PRE32*/
   DLLUSEAGE    aDLLuseage[40];               // Device Dll useage
} PROCDATA, *PPROCDATA;

// ----------------------------------------------------------------------------------------------
// dialog instance data; allocated in OS2_PM_DRV_DEVMODE when presenting a dialog to the user

typedef struct _NBPageInfo {
   PFNWP               pfnDlg;
   ULONG               ulDlgID;
   ULONG               ulPageID;
   HWND                hwndPage;
   ULONG               ulTabID;
   PSZ                 pszTabText;
   ULONG               cxTabText;
   ULONG               cyTabText;
   USHORT              usOrder;     // @TBD - allow user to modify notebbok page order

   struct _NBPageInfo *pNext;
} NBPAGEINFO, *PNBPAGEINFO, **PPNBPAGEINFO;

typedef struct _NoteBookInfo {
   ULONG         ulNBID;                 //
   HWND          hwndNB;                 //
   ULONG         ulJobPropNBID;          //
   HWND          hwndJobPropNB;          //
   ULONG         cxMajor;                //
   ULONG         cyMajor;                //
   ULONG         cxMinor;                //
   ULONG         cyMinor;                //
   PNBPAGEINFO   pNotebookPages;         //
   NBPAGEINFO    PageInfoFormConnect;    //
   NBPAGEINFO    PageInfoTray;           //
   NBPAGEINFO    PageInfoPaperSize;      //
   NBPAGEINFO    PageInfoFont;           //
   NBPAGEINFO    PageInfoJobProps;       //
   NBPAGEINFO    PageInfoImageClr;       //
   NBPAGEINFO    PageInfoHSV;            //
   NBPAGEINFO    PageInfoImageMono;      //

   PNBPAGEINFO   pPageInfoJobDevice;     // Start of device specific pages for job properties
   PNBPAGEINFO   pPageInfoPrinterDevice; // Start of device specific pages for printer properties

#ifdef DEBUG
   NBPAGEINFO    PageInfoDebug;          //
#endif
} NOTEBOOKINFO, *PNOTEBOOKINFO;

typedef struct _OmniDitherInfo {
   ULONG ulDitherID;
   ULONG ulDitherNameID;
   ULONG ulDitherType;
   ULONG ulDitherSupport;
} OMNIDITHERINFO, *POMNIDITHERINFO;

typedef struct _StateData {
   BOOL   fCalledDeviceInitJob;       // Called device to Init Print Job?
   BOOL   ulCalledDeviceQueryDialogs; // Called device to supply its dialogs?
   BOOL   fFoundLogAddress;           // Found valid logical address
   BOOL   fUseBitmap;                 // Is a Bitmap surface needed for this DC?
   BOOL   fUseJournaling;             // Is a Journal file needed for this DC?
   BOOL   fBanding;                   // Is Banding required for this Print Job?
} STATEDATA, *PSTATEDATA;

typedef struct _dlginstance {
   HMCB                hmcbHeap;
   PSZ                 pszDriverName;               // DRV module name supplied on the call
   PSZ                 pszDeviceName;               // supported device name supplied on the call
                                                    // @TBD     not use pDevice->pszDeviceName ???
   PSZ                 pszPrinterName;              // logical printer name per printer object
   PSZ                 pszLogAddr;
   PDRIVDATA           pDrivData;
   ULONG               ulJobProperties;             // @EXJOB
   PJOBPROPERTIES      pJobProperties;              // @EXJOB
   PJOBPROPERTIES      pJobProperties2;             // @EXJOB Backup jobproperties
   PRNPROPERTIES       PrnProperties;
   PHELPCTX            pHelpJobProp;
   PHELPCTX            pHelpPrnProp;
   CHAR                szAppName[LEN_APPNAME];      // Appname to be used for printer properties in OS2SYS.INI
   STATEDATA           StateData;
   BOOL                bDeviceDefaults;             // Flag indicating Job Properties or Default Job Properties
   HWND                hwndPrnProp;                 // Printer Property hwnd
   HWND                hwndJobProp;                 // Job Property hwnd
   HWND                hwndConnectDlg;              // Add/Delete/Modify Form Dialog hwnd
   HWND                hwndFontDlg;                 // Add/Delete/Modify Font Dialog hwnd
   HWND                hwndSpecialDlg;              // Special Job Options Dialog hwnd
   HWND                hwndHelp;                    // WinCreateHelpInstance
   HWND                hwndJobPropTxtHelp;
   HWND                hwndPrnPropTxtHelp;
   HMODULE             hmodHelp;
   HPOINTER            hptrPortrait;
   HPOINTER            hptrLandscape;
   HPOINTER            hptrDuplexOne;
   HPOINTER            hptrDuplexBook;
   HPOINTER            hptrDuplexFlip;
   ULONG               ulLastCtlID;
   PDEVICEINFO         pDevice;                     // pointer to the device
   PDRIVERINFO         pDriver;                     // pointer to the driver
   PFORMINFO           pFI;                         // for the form window
   PRESINFO            pRes;
   PNOTEBOOKINFO       pNBI;
   BOOL                bHelpHookSet;
   COUNTRYCODE         ctryCode;
   COUNTRYINFO         ctryInfo;
   BOOL                bUseInches;
   PVOID               pvDeviceCookie;              // Returned from DEVICE_ALLOC_HANDLE (pfnDeviceQuery)
   BOOL                fAfterInitialization;
#ifdef DEBUG
   PVOID               pv1;
   GRAPHINFO           gi;
   HWND                hwndDebugDlg;                // Hwnd for Debug Dialog
   DEBUGINFO           DebugInfo;                   // Debug Function Flags
#endif

   HGJNI               hNotebookInst;               // Notebook instance
   HGJNI               hLayoutPgInst;               // Layout page instance
   
   HGJNI               hPPNotebookInst;             
   HGJNI               hWebPagePgInst;              

} DLGINSTANCE, *PDLGINSTANCE;

typedef struct _dlldevnames {
   CHAR                 DLLname[13];     // dll name
   CHAR               **pdevicename;     // pointer to array of devicename
   ULONG                ulDevices;       // Number of devices in device DLL
   struct _dlldevnames *nextdlldevnames; // Pointer to next in a linked list
} DLLDEVNAMES, *PDLLDEVNAMES;

typedef struct _devicename {
   CHAR                *pdevicename;     // device name
} DEVICENAMES, *PDEVICENAMES;

// ----------------------------------------------------------------------------------------------
// global data; there is only one copy of this structure in memory and every process that uses the
// driver will have this global data mapped into their virtual process' address space
// It has the SHARED attribute in the def file.  Pragma'd and declared in DRIVER.C.

typedef struct _globals {
   ULONG                 ulSig;
   HMODULE               hModule;                      // supplied on first load in INITTERM.C
   HMODULE               hModuleGre;                   // PMGRE module handle
   HMODULE               hModulePre;                   // PRE32.DLL module handle (OS/2 2.11 compat.)
   HMODULE               hModulePMSPL;                 // PMSPL module handle
   ULONG                 ulGreVersion;                 // on fill logical, graphics engine version
   ULONG                 cDispatchEntries;             // on fill logical, count of entries in the dispatch table
   PFN*                  ppfnDispatchTableCopy;        // points to a copy of the original, unmodified dispatch table
   PSZ                   pszSemName;                   // pointer to string containing the name of the global sem
   PVOID                 pvSharedHeap;                 // pointer to base of shared heap
   PFN                   pfnSetDeviceSurface;          // Set device surface function call
   PFN                   pfnSplQmGetJobID;             // SplQmGetJobID
   PFN                   pfnPrtNewPage;                // PrtNewPage
   ULONG                 cInstances;                   // count of times this driver is instantiated
   PPDRIVERINFO          ppDrivers;                    // DLLwork - mjones
   ULONG                 ulTotalDrivers;               // DLLwork - mjones
   PDLLDEVNAMES          pDLLDevNames;                 // all Device Names from Omni DLLs
   CHAR                  szDLLPathName[LEN_PATH];      // Pathname for finding dlls to load
   BOOL                  bBaseStringTableInitialized;  // Base string table filled in
   BOOL                  bDlgStringTableInitialized;   // Dialog string table filled in
   CHAR                  szModule[LEN_PATH];           // module name as supplied on DLL_initterm() call
   CHAR                  achPrePath[LEN_PATH];         // PRE32 path
   PBYTE                 pbStringTable[STRING_TABLE_END - STRING_TABLE_BASE]; // String table
   ULONG                 ulEndSig;
#ifdef DEBUG
   BOOL                  bShowBitmap;                  // bitblt band bitmap to HWND_DESKTOP
   BOOL                  bDebugInfoInitialized;        // DebugInfo read in from INI
   DEBUGINFO             DebugInfo;                    // Debuginfo from INI
#endif
} GLOBALS, *PGLOBALS;

// -----------------------------------------------------------------------------------------------
// device block filled in at FILL_PHYSICAL time

#define DB_SIG        0x42766544                      // 'DevB'
typedef struct _deviceblock {
   ULONG              ulSig;                          // Character signature
   CHAR               szLogAddress[ CCHMAXPATH ];     // holds a copy of DEVOPENSTRUC contents passed into FILL_PHYSICAL
   CHAR               szDriverName[ CCHMAXPATH ];     // more DEVOPENSTRUC fields ...
   PDRIVDATA          pDrivData;                      // more DEVOPENSTRUC fields ...
   CHAR               szDataType[QP_DATATYPE_SIZE+1]; // more DEVOPENSTRUC fields ...
   CHAR               szComment[MAXCOMMENTSZ+1];      // more DEVOPENSTRUC fields ...
   CHAR               szQueueProcName[QNLEN+1];       // more DEVOPENSTRUC fields ...
   CHAR               szQueueProcParams[ 64 ];        // more DEVOPENSTRUC fields ...
   CHAR               szSpoolerParams[ 64 ];          // more DEVOPENSTRUC fields ...
   DEVOPENSTRUC       dop;                            // dop whose pointers point to above items; used on SplQmOpen
   PJOBPROPERTIES     pJobProperties;
   PPRNPROPERTIES     pPrnProperties;                 // @JPN2H99
   PFNSUBCLASS        pDevFuncs;                      // pointer to device-supplied functions
   ULONG              ulStateInfo;                    // assigned at FILL_PHYSICAL time, but otherwise unused
   ULONG              ulType;                         // OD_ type DIRECT/QUEUE/INFO/META
   HDC                hdc;                            // current DC handle
   HMCB               hmcbHeap;                       // base of DC heap; see also #define LEN_DCHEAP
   HMTX               hmtxDCSem;                      // sem to serialize access to the ddc
   ULONG              ulDataType;                     // integer value for PM_Q_STD or PM_Q_RAW
   BOOL               fStartDocCalled;                // application sent a DEVESC_STARTDOC
   BOOL               bNewJobProp;                    // @JPN2H99
   BOOL               fRecording;                     
   BOOL               fOldDevfnt;                     
   BOOL               fAbortDocCalled;                // application sent a DEVESC_ABORTDOC
   BOOL               fRawDataOnPage;                 // Indicates sending of Raw data escapes
   BOOL               fRawOnly;                       // pmprint.qpr option -- only DevEscape RawData calls!
   BOOL               fCalledGplThreadStart;          // have we started the thread?
   HSPL               hspl;                           // result of SplQmOpen; only need one of these for life of DC
   CHAR               szDocumentName[ 36 ];           // document name supplied on DEVESC_STARTDOC
   ULONG              ulPage;                         // page number; first page is page number zero
   PTRAYINFO          pTrayInfo;                      // points to the local copy of the form information for this job's tray
   PFORMINFO2         pFormInfo;                      // points to the local copy of the form information for this job's form
   PMEDIAINFO         pMediaInfo;                     // points to the local copy of the form information for this job's media
   PFONTINFO2         pFontInfo;                      // points to global data.  the focametrics are local
   PRESINFO           pResInfo;                       // pointer to the current resolution
   PPRINTMODE         pPrintMode;                     // pointer to the current print mode
   PDEVICEINFO        pDevice;                        // pointer to the current device
   PDRIVERINFO        pDriver;                        // pointer to the current driver
   PSZ                pszPrinterName;                 // OS/2 Printer Name
   CHAR               szAppName[LEN_APPNAME];         // Calling application name
   HTHREAD            hThread;                        // Second thread handle
   BOOL               bRasterPortrait;                // Rasterizing in "portrait" mode/not
   PVOID              pDeviceSurface;                 // pointer to our device surface
   BOOL               bAllocatedPatterns;             // Dynamic patterns
   PFN                pfnBitBlt;                      // Saved for TBD usage from PDS
   PFN                pfnLine;                        // Saved for TBD usage from PDS
   PFN                pfnTextBlt;                     // Saved for TBD usage from PDS
   PDEVFONTMETRICS    pdfm;                           //
   ULONG              ulNumDevFonts;                  //
   PVOID              pvDeviceCookie;                 // Returned from DEVICE_ALLOC_HANDLE (pfnDeviceQuery)
   COUNTRYCODE        ctryCode;                       // OS/2 country code
   COUNTRYINFO        ctryInfo;                       // OS/2 country info (separators etc)
   PDLLUSEAGE         pDLLuseage;                     // used by DLLBLD only
   SETABORTPROC       SetAbortProc;                   // Place to keep SetAbortProc info  //@SAP

   HMODULE            hModBandPlugIn;
   ULONG              ulBandHandle;
   PFN                pfnBandPlugInCreate;
   PFN                pfnBandPlugInSendBand;
   PFN                pfnBandPlugInDelete;

#define   OMNI_BOOKLET_ENABLED     0x01
#define   OMNI_BOOKLET_UPPERTRAY   0x02
   BYTE               bFlags;                         // Flags
   ULONG              ulNupPages;                     // Logical pages
   PSZ                pszRangeOfPages;                // Printed pages range
   PFORMINFO2         pLargeFormInfo;
   ULONG              ulTopMove;                      // Top shift

} DEVICEBLOCK, *PDEVICEBLOCK;

// Number of RGB values recognized for maximum color output
#define NUM_RGB_VALUES          256

/*--------------------------------------------------------------------------*/
/* LOG COLOR TABLE FORMAT equates for bLCTFormat in the DDC                 */
/*--------------------------------------------------------------------------*/

#define LCTF_INDRGB             0x00
#define LCTF_CONSECRGB          0x01
#define LCTF_RGB                0x02

/*--------------------------------------------------------------------------*/
/* LOG COLOR TABLE OPTIONS equates for bLCTOptions in the DDC               */
/*--------------------------------------------------------------------------*/

#define LCTO_REALIZABLE         0x01
#define LCTO_PURECOLOR          0x02

// -----------------------------------------------------------------------------------------------
// DDC: device drawing context

#define DDC_SIG                 0x43444450         // 'PDDC'
typedef struct _ddc {
   ULONG            ulSig;                // Character signature
   PDEVICEBLOCK     pdb;                  // pointer to physical device block
   HDC              hdcShadow;            // display OD_MEMORY DC created at printer DC enable time
   HRGN             hrgnShadow;           // rectangular clipping region for shadow DC
   HBITMAP          hbmShadow;            // bitmap for shadow DC
   POINTL           ptlDCOrigin;          // initialized to 0, 0 at enable time; will be used for banding in future version
   POINTL           ptlPrintHead;         // Printer's physical print head position
   POINTL           ptlPrintHead2;        // Printer's physical print head position
   HJOURNAL         hJournal;             // handle to journal instance
   IJOURNAL         IJournal;             // Input structure for journaling
   BOOL             bLCTFormat;           // Current color table format
   ULONG            ulLCTOptions;         // Current color table options
   BITMAPINFOHEADER bmp;
   PVOID            pmdi;                 // dither matrix info
   STATEDATA        StateData;

   BOOL             bBlankPageRasterized; // Flags
   LONG             lHeaderY;             // Current header position for blank page
   INT              iShift;               // Y moving pels
   ULONG            ulBookletPage;        // Current printed page
} DDC, *PDDC;

// externs for public, static structures
// they are pragma'd and declared in driver.c
extern GLOBALS      globals;
extern PROCDATA     procdata;

#define SWAP(a,b)  {ULONG tmp; tmp = (a); (a) = (b); (b) = tmp;}
#define SWAPP(a,b) {PVOID tmp; tmp = (PVOID)(a); (a) = (PVOID)(b); (b) = tmp;}

/* The following is a Binary Coded Digit (BCD).  Each hexadecimal digit
** is interpreted as a decimal number.  The decimal point is between the second
** and third digits.
*/
#define GRE_22                               0x00000220  // 2.2
#define GRE_23                               0x00000230  // 2.3
#define GRE_234                              0x00000234  // INTEL (even) : DAXPAK LEVEL
#define GRE_236                              0x00000236L // INTEL (even) : DAXPAK2 LEVEL
#define GRE_238                              0x00000238L // INTEL (even) : MERLIN FIXPAK LEVEL
#define GRE_23A                              0x0000023AL // INTEL (even) : JAVA/SS FIXPAK 5 LEVEL
#define GRE_23B                              0x0000023BL // INTEL        : FP6 and FP35
#define GRE_23C                              0x0000023CL // *BROKEN* new device font struct
#define GRE_23D                              0x0000023DL // new device font struct

// PAGE_TUNE
#include "ptune.h"

#define DEBUG_FUNCTION_ENTER                 DBPRINTF (("%s(): Enter\n", __FUNCTION__));
#define DEBUG_FUNCTION_EXIT                  DBPRINTF (("%s(): Exit\n", __FUNCTION__));

#define dimof(a)                             (sizeof (a)/sizeof (a[0]))
