/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1992 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 source code is provided to you solely for       */
/*    the purpose of assisting you in your development of OS/2 device        */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Developer Connection Device Driver       */
/*    Source Kit for OS/2. This Copyright statement may not be removed.      */
/*                                                                           */
/*****************************************************************************/
/****************************************************************************/
/* SOURCE NAME    : DRIVER.C                                                */
/* AUTHOR         : Matt Rutkowski & Mark Hamzy                             */
/* DESCRIPTION    : Initializes "driver-wide" structures such as            */
/*                  Global and per-process data structures                  */
/*                                                                          */
/*                  Also, includes all "device-specific" files              */
/*                  like "epson.c" for epson printers etc.                  */
/*                                                                          */
/*                                                                          */
/*--------------------------------------------------------------------------*/
/* CHANGE/MODIFICATION LOG :                                                */
/*--------------------------------------------------------------------------*/
/*                                                                          */
/****************************************************************************/

#define INCL_DOS
#define INCL_DOSDEVIOCTL
#define INCL_DEV
#define INCL_DEVDJP
#define INCL_PM
#define INCL_SPL
#define INCL_SPLFSE
#define INCL_ERRORS
#include <os2.h>

#define INCL_VMANDDI
#include <ddi.h>

#define DEV_FNT_SUP
#define INCL_GRE_COLORTABLE
#define INCL_GRE_BITMAPS
#define INCL_GRE_DEVMISC3
#define INCL_GRE_DEVSUPPORT
#define INCL_DDIMISC
#define INCL_GRE_FONTS
#include <pmddi.h>

// c includes
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <setjmp.h>
#include <stdarg.h>

#include "def.h"
#include "driver.h"
#include "funcs.h"

// only one copy of these data items in a running system
#pragma data_seg( Global )

#ifndef DDKBLD

   #include "devices\passthru.c"
   #include "devices\canon.c"
   #include "devices\deskjet.c"
#ifdef HPBUILD
   #include "devices\hpdeskjt.c"
#endif
   #include "devices\epson.c"
   #include "devices\ibmxx.c"
   #include "devices\laserjet.c"
   #include "devices\lexmark.c"         // @WIN150
   #include "devices\olivetti.c"
   #include "devices\paintjet.c"
   #include "devices\seiko.c"
///#include "devices\alps.c"
   #ifdef KORBLD
   #include "devices\ks.c"
   #include "devices\kssm.c"
   #endif
   #ifdef JPNBLD
   #include "devices\deskjetj.c"        
   #include "devices\escpage.c"         
   #include "devices\lips.c"            
   #include "devices\pages.c"           
   #include "devices\rpdl.c"            //0j-MO971119
   #endif
   #ifdef TWNBLD                        // <TWN>
   #include "devices\pages.c"           // <TWN>
   #endif                               // <TWN>
   #include "devices\tiff.c"            // TIFFDEVICE

#else  // this is a DDKBLD

   #include "devices\samp_pcl.c"
   #include "devices\samp_eps.c"
   #include "devices\tiff.c"          // TIFFDEVICE

#endif

#ifndef DDKBLD

PDRIVERINFO Drivers[]  = {

   pPASSTHRUDriver      ,
   pCANONDriver         ,
   pDESKJETDriver       ,
#ifdef HPBUILD
   pHPDriver            ,
#endif
   pEPSONDriver         ,
   pIBMDriver           ,
   pLASERJETDriver      ,
   pLEXMARKDriver       ,
   pOLIVETTIDriver      ,
   pPAINTJETDriver      ,
   pSEIKODriver         ,
///pALPSDriver          ,
#ifdef KORBLD
   pKSDriver            ,               
   pKSSMDriver          ,               
#endif
#ifdef JPNBLD
   pDESKJETJDriver      ,               
   pESCPAGEDriver       ,               
   pLIPSDriver          ,               
   pPAGESDriver         ,               
   pRPDLDriver          ,               //0j-MO971119
#endif
#ifdef TWNBLD                           // <TWN>
   pPAGESDriver         ,               // <TWN>
#endif                                  // <TWN>
   pTIFFDriver                          // TIFFDEVICE

};

#else // this is a DDKBLD

PDRIVERINFO Drivers[]  = {

   pSAMPPCLDriver     ,
   pSAMPEPSONDriver   ,
   pTIFFDriver                        // TIFFDEVICE

};

#endif

#define TOTAL_DRIVERS         (sizeof (Drivers)/sizeof (Drivers[0]))

// global information; need one copy only
// null and zero values are assigned at run time

GLOBALS  globals =
{
   0L,
   (HMODULE) 0,                    // supplied on first load in INITTERM.C
   (HMODULE) 0,                    // PMGRE module handle
   (HMODULE) 0,                    // PRE32.DLL module handle (OS/2 2.11 compat.)
   (HMODULE) 0,                    // PMSPL module handle
   0,                              // on fill logical, graphics engine version
   0,                              // on fill logical, count of entries in the dispatch table
   NULL,                           // points to a copy of the original, unmodified dispatch tablered space
   "\\SEM32\\"APP_NAME"\\GLOBAL\\SEM",// pointer to string containing the name of the global sem
   NULL,                           // pointer to base of shared heap
   (PFN)NULL,                      // Set device surface function call
   (PFN)NULL,                      // SplQmGetJobID
   (PFN)NULL,                      // PrtNewPage
   0,                              // count of times this driver is instantiated
   Drivers,                        // (PPDRIVERINFO) pDriverInfo
   0,                              // Total number of drivers (i.e. DLLs)
   NULL,                           // (Device Names from all DLLs in linked list)
   "",                             // Pathname for finding dlls to load
   FALSE,                          // bBaseStringTableInitialized;
   FALSE,                          // bDlgStringTableInitialized;
   "",                             // module path/name
   "",                             // PRE32 path
   NULL,                           // pbStringTable;
   0L,                             // Global structure end signature
#ifdef DEBUG
   FALSE,                          // bShowBitmap;
   FALSE                           // bDebugInfoInitialized;
   // @TBD - DEBUGINFO structure should be explicitely initialized here
#endif
};

// these data items private to any given process
#pragma data_seg( PerProcess )

PROCDATA         procdata =
{
   "\0",    //    szAssert[ 64 ];
   "\0",    //    szFilename[ 64 ];
   0,       //    ulLine;
   0,       //    ulLastError;
   0,       //    pid;
   (HMTX)0, //    hmtxGlobalSem;
   (HMTX)0, //    hmtxProcessSem;
   0,       //    hdcDirectShadow    /*@PRE32*/
   {
      { 0,   0,   NULL,  NULL},        // used by the DLLBLD version of the driver
      { 0,   0,   NULL,  NULL},        // not used by the flat version of omni.drv
      { 0,   0,   NULL,  NULL},
      { 0,   0,   NULL,  NULL},
      { 0,   0,   NULL,  NULL},
      { 0,   0,   NULL,  NULL},
      { 0,   0,   NULL,  NULL},
      { 0,   0,   NULL,  NULL},
      { 0,   0,   NULL,  NULL},
      { 0,   0,   NULL,  NULL},
      { 0,   0,   NULL,  NULL},
      { 0,   0,   NULL,  NULL},
      { 0,   0,   NULL,  NULL},
      { 0,   0,   NULL,  NULL},
      { 0,   0,   NULL,  NULL},
      { 0,   0,   NULL,  NULL},
      { 0,   0,   NULL,  NULL},
      { 0,   0,   NULL,  NULL},
      { 0,   0,   NULL,  NULL},
      { 0,   0,   NULL,  NULL},
      { 0,   0,   NULL,  NULL},
      { 0,   0,   NULL,  NULL},
      { 0,   0,   NULL,  NULL},
      { 0,   0,   NULL,  NULL},
      { 0,   0,   NULL,  NULL},
      { 0,   0,   NULL,  NULL},
      { 0,   0,   NULL,  NULL},
      { 0,   0,   NULL,  NULL},
      { 0,   0,   NULL,  NULL},
      { 0,   0,   NULL,  NULL},
      { 0,   0,   NULL,  NULL},
      { 0,   0,   NULL,  NULL},
      { 0,   0,   NULL,  NULL},
      { 0,   0,   NULL,  NULL},
      { 0,   0,   NULL,  NULL},
      { 0,   0,   NULL,  NULL},
      { 0,   0,   NULL,  NULL},
      { 0,   0,   NULL,  NULL},
      { 0,   0,   NULL,  NULL},
      { 0,   0,   NULL,  NULL}
   }
};

// PAGE_TUNE
// For page-tuning define one global, per-process TUNERPROCDATA structure.
#ifdef PAGE_TUNE
TUNERPROCDATA TunerProcData;
#endif

// only one copy of these data items in a running system
#pragma data_seg( Global )

VOID
SetNumberOfPrinters (VOID)
{
   globals.ulTotalDrivers = TOTAL_DRIVERS;
}

ULONG _default_heap = 32 * 1024;
