/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1992 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 source code is provided to you solely for       */
/*    the purpose of assisting you in your development of OS/2 device        */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Developer Connection Device Driver       */
/*    Source Kit for OS/2. This Copyright statement may not be removed.      */
/*                                                                           */
/*****************************************************************************/
/****************************************************************************/
/* MODULE NAME    : Dialog Functions                                        */
/* SOURCE NAME    : DLG.C                                                   */
/* AUTHOR         : MFR                                                     */
/* DATE WRITTEN   : 9/22/92                                                 */
/* DESCRIPTION    : All Dialog functions and dialog helper functions        */
/*                                                                          */
/*                  Control Flow:                                           */
/*                                                                          */
/* PARAMETERS:                                                              */
/*                                                                          */
/* RETURN VALUES:                                                           */
/*                                                                          */
/*--------------------------------------------------------------------------*/
/* CHANGE/MODIFICATION LOG :                                                */
/*--------------------------------------------------------------------------*/
/* IBMJPN768    Yu-Chih,Shih Printer Properties Dlg not displayed     fix.  */
/* @178797 - 05/22/97 - MJH [IBM] - Need to default to A4 for Brazil        */
/* @EXJOB  - 07/13/98 - UCC [IBMJ]- Expansible job data support             */
/* jk0998  - 09/15/98 - Janis Kisis - New dithering methods                 */
/* jk1115  - 11/15/98 - Janis Kisis - New dithering methods                 */
/*                                          support                         */
/* @HWCOLLATE    07/27/99 - UCC [IBMJ] - H/W collate support                */
/*                                                                          */
/* @CONSTRAINTS  07/01/00  Add Constraints for Print Qualities, Print Modes */
/*                         and Dither Methods                               */
/****************************************************************************/

// os2 includes
#define INCL_WINHELP        // HelpMgr
#define INCL_WINHOOKS       // HelpMgr
#define INCL_WINWINDOWMGR   // WinFillRect etc.
#define INCL_GPIBITMAPS
#define INCL_DOS
#define INCL_PM
#include <os2.h>

// @DBCS
#define INCL_VMANDDI
#include <ddi.h>
#include <pmddi.h>

// c includes
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <setjmp.h>

#define INCL_GENPLIB_GPLUTIL
#define INCL_GENPLIB_WEBPAGE                                        
#include "def.h"
#include "driver.h"
#include "funcs.h"

//#define USE_LEXMARK_STYLE        1  // Mutually exclusive... one is defined or the
//#define DONT_USE_LEXMARK_STYLE   1  // other one is defined (or none are :)

#define isdigit(c)          ('0' <= c && c <= '9')

/****************************************************************************/
/* Private Functions                                                        */
/****************************************************************************/
BOOL DlgSavePrinterProperties (PSZ           pszAppName,
                               PDLGINSTANCE  pdi);
VOID InitializeDialogDevice   (PDLGINSTANCE  pdi,
                               HWND          hwnd,
                               ULONG         ulType);
VOID FreeDialogDevice         (PDLGINSTANCE  pdi,
                               ULONG         ulType);
BOOL InitHalftoneAlgorithmsList (HWND           hwnd,
                                 PDLGINSTANCE   pdi,
                                 PDEVICEINFO    pDevice,
                                 PJOBPROPERTIES pJobProps);

// @CONSTRAINTS
VOID OmniUpdateConstraints (HWND, 
                            PDLGINSTANCE, 
                            LONG);

#define LOADHELPMGR 1

#if LOADHELPMGR
typedef BOOL (APIENTRY ApientryDestroyHelp)( HWND );
typedef HWND (APIENTRY ApientryCreateHelp)( HAB, PHELPINIT );
typedef HWND (APIENTRY ApientryAssocHelp)( HWND, HWND );

ApientryDestroyHelp *pfnWinDestroyHelpInstance   = NULL;
ApientryCreateHelp  *pfnWinCreateHelpInstance    = NULL;
ApientryAssocHelp   *pfnWinAssociateHelpInstance = NULL;
#endif

#define MAX_CTX_HELP_STRING          128

#define DITHER_TYPE_UNLISTED         0x0000
#define DITHER_TYPE_LEVEL            0x0001
#define DITHER_TYPE_DIFFUSION        0x0002
#define DITHER_TYPE_MATRIX           0x0004

#define MONO_SUPPORT_NONE            0x0000
#define MONO_SUPPORT_FOREGROUND      0x0001
#define MONO_SUPPORT_BACKGROUND      0x0002
#define MONO_SUPPORT_MIRROR_IMAGE    0x0004

#define CLR_SUPPORT_NONE             0x0000
#define CLR_SUPPORT_HSV              0x0001
#define CLR_SUPPORT_GAMMA            0x0002


OMNIDITHERINFO OMNI_DITHERS[] =
{
  { HT_MAGIC_SQUARES,                       // ulDitherID;
    HALFTONE_STRING_MAGIC_SQUARES,          // ulDitherNameID;
    DITHER_TYPE_MATRIX,                     // ulDitherType;
    CLR_SUPPORT_HSV,                        // ulDitherSupport;
  }
//,
//  { HT_LEVEL,                               // ulDitherID;
//    HALFTONE_STRING_LEVEL,                  // ulDitherNameID;
//    DITHER_TYPE_LEVEL,                      // ulDitherType;
//    0,                                      // ulDitherSupport;
//  }
,
  { HT_DITHER_4x4,                          // ulDitherID;
    HALFTONE_STRING_DITHER_4x4,             // ulDitherNameID;
    DITHER_TYPE_MATRIX,                     // ulDitherType;
    0,                                      // ulDitherSupport;
  }
,
  { HT_DITHER_8x8,                          // ulDitherID;
    HALFTONE_STRING_DITHER_8x8,             // ulDitherNameID;
    DITHER_TYPE_MATRIX,                     // ulDitherType;
    0,                                      // ulDitherSupport;
  }
,
  { HT_ERR_DIFFUSION,                       // ulDitherID;
    HALFTONE_STRING_ERR_DIFFUSE,            // ulDitherNameID;
    DITHER_TYPE_DIFFUSION,                  // ulDitherType;
    0,                                      // ulDitherSupport;
  }
,
  { HT_STEINBERG_DIFFUSION,                 // ulDitherID;
    HALFTONE_STRING_STEINBERG_DIFFUSE,      // ulDitherNameID;
    DITHER_TYPE_DIFFUSION,                  // ulDitherType;
    0,                                      // ulDitherSupport;
  }
,
  { HT_ORDERED_SQUARES,                     // ulDitherID;
    HALFTONE_STRING_ORDERED_SQUARES,        // ulDitherNameID;
    DITHER_TYPE_MATRIX,                     // ulDitherType;
    CLR_SUPPORT_HSV,                        // ulDitherSupport;
  }
,
//  { HT_FAST_DIFFUSION,                      // ulDitherID;
//    HALFTONE_STRING_FAST_DIFFUSE,           // ulDitherNameID;
//    DITHER_TYPE_DIFFUSION,                  // ulDitherType;
//    0,                                      // ulDitherSupport;
//  }
//,
//  { HT_HSV_DIFFUSION,                       // ulDitherID;
//    HALFTONE_STRING_HSV_DIFFUSION,          // ulDitherNameID;
//    DITHER_TYPE_DIFFUSION,                  // ulDitherType;
//    0,                                      // ulDitherSupport;
//  }
//,
//  { HT_HSV_BIDIFFUSION,                     // ulDitherID;
//    HALFTONE_STRING_HSV_BIDIFFUSION,        // ulDitherNameID;
//    DITHER_TYPE_DIFFUSION,                  // ulDitherType;
//    0,                                      // ulDitherSupport;
//  }
//,
//  { HT_CMYK_DIFFUSION,                      // ulDitherID;
//    HALFTONE_STRING_CMYK_DIFFUSION,         // ulDitherNameID;
//    DITHER_TYPE_DIFFUSION,                  // ulDitherType;
//    0,                                      // ulDitherSupport;
//  }
//  ,
  { HT_VOID_CLUSTER,                        // ulDitherID;       //jk0998
    HALFTONE_STRING_VOID_CLUSTER_DIFFUSION, // ulDitherNameID;   //jk0998
    DITHER_TYPE_MATRIX,                     // ulDitherType;     //jk0998
    0,                                      // ulDitherSupport;  //jk0998
  }
//,                                           // Stucki-2
//  { HT_JANIS_STUCKI,                        // ulDitherID;       //jk0998
//    HALFTONE_STRING_VC_LEVEL_DIFFUSION,     // ulDitherNameID;   //jk0998
//    DITHER_TYPE_DIFFUSION,                  // ulDitherType;     //jk0998
//    0,                                      // ulDitherSupport;  //jk0998
//  }
,
  { HT_ERR_DIFFUSION6,                      // ulDitherID;
    HALFTONE_STRING_ERR_DIFFUSE6,           // ulDitherNameID;
    DITHER_TYPE_DIFFUSION,                  // ulDitherType;
    0,                                      // ulDitherSupport;
  }
,
  { HT_ERR_DIFFUSION5,                      // ulDitherID;
    HALFTONE_STRING_ERR_DIFFUSE5,           // ulDitherNameID;
    DITHER_TYPE_DIFFUSION,                  // ulDitherType;
    0,                                      // ulDitherSupport;
  }
};
#define OMNI_DEFINED_DITHERS (sizeof (OMNI_DITHERS)/sizeof(OMNI_DITHERS[0]))


CLASSINFO   HexClassInfo; // Data about the *public* entry field control
                          // Note, we don't change it. So it should be safe as
                          // global data

/****************************************************************************/
/*==========================================================================*/
/* New PM Control Classes                                                   */
/*==========================================================================*/
/*                                                                          */
/* The functions in this section of DLG.C manage controls created           */
/* specifically for use within the Omni driver's notebook pages.            */
/*                                                                          */
/****************************************************************************/
/****************************************************************************/

/****************************************************************************/
/* PROCEDURE NAME : ConvertHexCmdToAscii                                    */
/* AUTHOR         : MFR                                                     */
/* DATE WRITTEN   : 12/12/95                                                */
/* DESCRIPTION    : Used to convert Hex commands into their equivalent      */
/*                  ASCII values after being read from the new Hex          */
/*                  Entryfield window control.                              */
/* PARAMETERS:                                                              */
/*                                                                          */
/*                                                                          */
/* RETURN VALUES:                                                           */
/*                                                                          */
/*                                                                          */
/*--------------------------------------------------------------------------*/
/* CHANGE/MODIFICATION LOG :                                                */
/*--------------------------------------------------------------------------*/
/*                                                                          */
/****************************************************************************/
BOOL
ConvertHexCmdToAscii (USHORT usCmdLen, PSZ pszCmd, PSZ pszHexCmd)
{
   /*------------------------------------------------------------------------*/
   /* LOCAL VARIABLES                                                        */
   /*------------------------------------------------------------------------*/
   USHORT i;
   BYTE   bHi, bLo;

   /*------------------------------------------------------------------------*/
   /* BEGIN CODE                                                             */
   /*------------------------------------------------------------------------*/
   for (i = 0; i < usCmdLen; i++)
   {
      bLo = *pszCmd & 0x0F;

      bHi = *pszCmd & 0xF0;
      bHi /= 0x10;

      switch (bHi)
      {
      case 0:  *pszHexCmd = '0'; break;
      case 1:  *pszHexCmd = '1'; break;
      case 2:  *pszHexCmd = '2'; break;
      case 3:  *pszHexCmd = '3'; break;
      case 4:  *pszHexCmd = '4'; break;
      case 5:  *pszHexCmd = '5'; break;
      case 6:  *pszHexCmd = '6'; break;
      case 7:  *pszHexCmd = '7'; break;
      case 8:  *pszHexCmd = '8'; break;
      case 9:  *pszHexCmd = '9'; break;
      case 10: *pszHexCmd = 'A'; break;
      case 11: *pszHexCmd = 'B'; break;
      case 12: *pszHexCmd = 'C'; break;
      case 13: *pszHexCmd = 'D'; break;
      case 14: *pszHexCmd = 'E'; break;
      case 15: *pszHexCmd = 'F'; break;
      }

      pszHexCmd++;

      switch (bLo)
      {
      case 0:  *pszHexCmd = '0'; break;
      case 1:  *pszHexCmd = '1'; break;
      case 2:  *pszHexCmd = '2'; break;
      case 3:  *pszHexCmd = '3'; break;
      case 4:  *pszHexCmd = '4'; break;
      case 5:  *pszHexCmd = '5'; break;
      case 6:  *pszHexCmd = '6'; break;
      case 7:  *pszHexCmd = '7'; break;
      case 8:  *pszHexCmd = '8'; break;
      case 9:  *pszHexCmd = '9'; break;
      case 10: *pszHexCmd = 'A'; break;
      case 11: *pszHexCmd = 'B'; break;
      case 12: *pszHexCmd = 'C'; break;
      case 13: *pszHexCmd = 'D'; break;
      case 14: *pszHexCmd = 'E'; break;
      case 15: *pszHexCmd = 'F'; break;
      }

      pszHexCmd++;
      pszCmd++;
   }

   *pszHexCmd = '\0';

   return TRUE;

} /* end ConvertHexCmdToAscii */

/****************************************************************************/
/* PROCEDURE NAME : ConvertAsciiCmdToHex                                    */
/* AUTHOR         : MFR                                                     */
/* DATE WRITTEN   : 12/12/95                                                */
/* DESCRIPTION    : Used to convert ASCII commands into their equivalent    */
/*                  hex values for display in the new Hex Entryfield        */
/*                  window control.                                         */
/* PARAMETERS:                                                              */
/*                                                                          */
/*                                                                          */
/* RETURN VALUES:                                                           */
/*                                                                          */
/*                                                                          */
/*--------------------------------------------------------------------------*/
/* CHANGE/MODIFICATION LOG :                                                */
/*--------------------------------------------------------------------------*/
/*                                                                          */
/****************************************************************************/
LONG
ConvertAsciiCmdToHex (HWND hwnd, PBYTE pbOutCmd, ULONG ulLimit)
{
   /*------------------------------------------------------------------------*/
   /* LOCAL VARIABLES                                                        */
   /*------------------------------------------------------------------------*/
   USHORT i;
   BYTE   bTemp;
   LONG   lInLen,
          lOutLen               = 0;
   CHAR   achInCmd[LEN_STRING];
   CHAR   ch;
   PSZ    pszInCmd              = achInCmd;
   BOOL   bHiByte               = TRUE;

   /*------------------------------------------------------------------------*/
   /* BEGIN CODE                                                             */
   /*------------------------------------------------------------------------*/
   lInLen = WinQueryWindowText (hwnd, LEN_STRING-1, achInCmd);

   if (lInLen < ulLimit)
   {
      for (i = 0; i < lInLen; i++)
      {
         ch = *pszInCmd;

         if (ch != ' ')
         {
            switch (ch)
            {
            case '0':  bTemp = 0;  break;
            case '1':  bTemp = 1;  break;
            case '2':  bTemp = 2;  break;
            case '3':  bTemp = 3;  break;
            case '4':  bTemp = 4;  break;
            case '5':  bTemp = 5;  break;
            case '6':  bTemp = 6;  break;
            case '7':  bTemp = 7;  break;
            case '8':  bTemp = 8;  break;
            case '9':  bTemp = 9;  break;
            case 'A':  bTemp =10;  break;
            case 'B':  bTemp =11;  break;
            case 'C':  bTemp =12;  break;
            case 'D':  bTemp =13;  break;
            case 'E':  bTemp =14;  break;
            case 'F':  bTemp =15;  break;
            }

            if (bHiByte)
            {
               bTemp *= 0x10;
               *pbOutCmd = bTemp;
            }
            else
            {
               *pbOutCmd |= bTemp;
               lOutLen++;
               pbOutCmd++;
            }

            bHiByte = !bHiByte;
         }

         pszInCmd++;
      }

      // Ascii representation of hex cmd is not complete
      // pad end with zeros
      if ((lInLen%2) != 0)
      {
         lOutLen++;
      }
   }

   return lOutLen;

} /* end ConvertAsciiCmdToHex */

/****************************************************************************/
/* PROCEDURE NAME : InsertListboxItem                                       */
/* AUTHOR         : MFR                                                     */
/* DATE WRITTEN   : 09/06/96 !!!!                                           */
/* DESCRIPTION    :                                                         */
/*                                                                          */
/*                  Control Flow:                                           */
/*                                                                          */
/* PARAMETERS:                                                              */
/*                                                                          */
/* RETURN VALUES:                                                           */
/*                                                                          */
/*--------------------------------------------------------------------------*/
/* CHANGE/MODIFICATION LOG :                                                */
/*--------------------------------------------------------------------------*/
/*                                                                          */
/****************************************************************************/
VOID
InsertListboxItem (HWND hwnd, ULONG ulLBID, PSZ pszName, ULONG ulHandle)
{
   /*------------------------------------------------------------------------*/
   /* LOCAL VARIABLES                                                        */
   /*------------------------------------------------------------------------*/
   SHORT sIdx;

   /*------------------------------------------------------------------------*/
   /* BEGIN CODE                                                             */
   /*------------------------------------------------------------------------*/
   DBPRINTF (("%s(): Enter\n", __FUNCTION__));

   // add res name string to res listbox
   sIdx = (SHORT)WinSendDlgItemMsg (hwnd,
                                    ulLBID,
                                    LM_INSERTITEM,
                                    MPFROM2SHORT (LIT_END, 0),
                                    MPFROMP (pszName));

   // Set Item Handle to be the Res ID
   WinSendDlgItemMsg (hwnd,
                      ulLBID,
                      LM_SETITEMHANDLE,
                      MPFROMSHORT (sIdx),
                      MPFROMLONG (ulHandle));

   DBPRINTF (("%s(): Exit\n", __FUNCTION__));

} /* end InsertListboxItem */

/****************************************************************************/
/* PROCEDURE NAME : InsertRemoteControlFunction                             */
/* AUTHOR         : MFR                                                     */
/* DATE WRITTEN   : 09/06/96 !!!!                                           */
/* DESCRIPTION    :                                                         */
/*                                                                          */
/*                  Control Flow:                                           */
/*                                                                          */
/* PARAMETERS:                                                              */
/*                                                                          */
/* RETURN VALUES:                                                           */
/*                                                                          */
/*--------------------------------------------------------------------------*/
/* CHANGE/MODIFICATION LOG :                                                */
/*--------------------------------------------------------------------------*/
/*                                                                          */
/****************************************************************************/
VOID
InsertRemoteControlFunction (HWND hwnd, PPRINTCTLFUNC pCtlFunc)
{
   /*------------------------------------------------------------------------*/
   /* BEGIN CODE                                                             */
   /*------------------------------------------------------------------------*/
   DBPRINTF (("%s(): Enter\n", __FUNCTION__));

   InsertListboxItem (hwnd, IDD_REMOTE_CMD, (PSZ)(pCtlFunc->pszName), (ULONG)pCtlFunc);

   DBPRINTF (("%s(): Exit\n", __FUNCTION__));

} /* end InsertRemoteControlFunction */

/****************************************************************************/
/* PROCEDURE NAME : HexEntryWndProc                                         */
/* AUTHOR         : MFR                                                     */
/* DATE WRITTEN   : 12/12/95                                                */
/* DESCRIPTION    : Handles window processing for the new Hex Entryfield    */
/*                  class.  This class allows entry of only hex chars       */
/*                  into an entryfield control.                             */
/* PARAMETERS:                                                              */
/*                                                                          */
/*                                                                          */
/* RETURN VALUES:                                                           */
/*                                                                          */
/*                                                                          */
/*--------------------------------------------------------------------------*/
/* CHANGE/MODIFICATION LOG :                                                */
/*--------------------------------------------------------------------------*/
/*                                                                          */
/****************************************************************************/
MRESULT EXPENTRY
HexEntryWndProc (HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
{
   /*------------------------------------------------------------------------*/
   /* LOCAL VARIABLES                                                        */
   /*------------------------------------------------------------------------*/
   PCHRMSG  p;
   BOOL     bValidHexChar = FALSE;

   /*------------------------------------------------------------------------*/
   /* BEGIN CODE                                                             */
   /*------------------------------------------------------------------------*/

   switch (msg)
   {
   case WM_CHAR:
   {
      if (SHORT1FROMMP (mp1) & KC_VIRTUALKEY)
      {
         switch (SHORT2FROMMP (mp2))
         {
         case VK_ESC:
         case VK_TAB:
         case VK_BACKTAB:
         case VK_INSERT:
         case VK_DELETE:
         case VK_BACKSPACE:
         case VK_NEWLINE:
         case VK_ENTER:
         case VK_END:
         case VK_HOME:
         case VK_UP:
         case VK_DOWN:
         case VK_LEFT:
         case VK_RIGHT:
         case VK_F1:
            // Allow these keys through to the entry field
            return (*HexClassInfo.pfnWindowProc) (hwnd, msg, mp1, mp2);
         }
      }

      // address char structure
      p = CHARMSG (&msg);

      // ONLY key up in transit
      if ((p->fs & (KC_KEYUP|KC_CHAR))==KC_CHAR)
      {
         // If character is a digit (0-9)
         if (isdigit (p->chr))
         {
            bValidHexChar = TRUE;
         }
         else
         {
            switch (p->chr)
            {
            case 'a':
            {
               p->chr = 'A';
               bValidHexChar = TRUE;
               break;
            }

            case 'b':
            {
               p->chr = 'B';
               bValidHexChar = TRUE;
               break;
            }

            case 'c':
            {
               p->chr = 'C';
               bValidHexChar = TRUE;
               break;
            }

            case 'd':
            {
               p->chr = 'D';
               bValidHexChar = TRUE;
               break;
            }

            case 'e':
            {
               p->chr = 'E';
               bValidHexChar = TRUE;
               break;
            }

            case 'f':
            {
               p->chr = 'F';
               bValidHexChar = TRUE;
               break;
            }

            case 'A':
            case 'B':
            case 'C':
            case 'D':
            case 'E':
            case 'F':
            {
               bValidHexChar = TRUE;
               break;
            }
            }
         }

         // If we do not have a valid char fail it
         if (!bValidHexChar)
         {
            WinAlarm (HWND_DESKTOP,WA_WARNING);    /* beep */
            return (MRESULT)TRUE;                  /* fail it */
         }
      }
   }
   }

   return (*HexClassInfo.pfnWindowProc) (hwnd, msg, mp1, mp2);

} /* HexEntryWndProc */

/****************************************************************************/
/* PROCEDURE NAME : BmpWndProc                                              */
/* AUTHOR         : MFR                                                     */
/* DATE WRITTEN   : 3/6/96                                                  */
/* DESCRIPTION    : Handles all window messages that affect the             */
/*                  "Bitmap Class" created to show dynamic color            */
/*                  adjustments in the "Color" Job Properties               */
/*                  notebook page.                                          */
/*                                                                          */
/* PARAMETERS:      (HWND)   hwnd                                           */
/*                  (ULONG)  msg                                            */
/*                  (MPARAM) mp1                                            */
/*                  (MPARAM) mp2                                            */
/*                                                                          */
/* RETURN VALUES:   (MRESULT)                                               */
/*                                                                          */
/*--------------------------------------------------------------------------*/
/* CHANGE/MODIFICATION LOG :                                                */
/*--------------------------------------------------------------------------*/
/*                                                                          */
/*                                                                          */
/****************************************************************************/
MRESULT EXPENTRY
BmpWndProc (HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
{
   /*------------------------------------------------------------------------*/
   /* LOCAL VARIABLES                                                        */
   /*------------------------------------------------------------------------*/
   HPS              hps;
   DEVOPENSTRUC     dop        = {0L, "DISPLAY", NULL, 0L, 0L, 0L, 0L, 0L, 0L};                   // Device Data for DevOpenDC
   RECTL            rclInvalid = {0, 0, 0, 0};
   SIZEL            szl        = {0, 0};

   static HBITMAP   hbm        = NULLHANDLE;
   static HAB       hab;
   static HPS       hpsBmp;
   static HDC       hdcBmp;

   /*------------------------------------------------------------------------*/
   /* BEGIN CODE                                                             */
   /*------------------------------------------------------------------------*/
   switch (msg)
   {
   case WM_CLOSE:
   {
//////GpiDeleteBitmap (hbm);
//////GpiAssociate (hpsBmp, NULLHANDLE);
//////GpiDestroyPS (hpsBmp);
//////DevCloseDC (hdcBmp);
      break;
   }

   case WM_CREATE:
   {
      hab = WinQueryAnchorBlock (hwnd);

      hdcBmp = DevOpenDC (hab, OD_MEMORY, "*", 5L, (PDEVOPENDATA)&dop, NULLHANDLE);

      hpsBmp = GpiCreatePS (hab, hdcBmp, &szl, PU_PELS | GPIT_NORMAL | GPIA_ASSOC);

      hbm = GpiLoadBitmap (hpsBmp,
                           globals.hModule, // Resource module
                           BITMAP_GAMMA,    // Bitmap ID
                           120L,            // lwidth
                           225L);           // lHeight
      break;
   }

   case WM_DESTROY:
   {
      GpiDeleteBitmap (hbm);
      GpiAssociate (hpsBmp, NULLHANDLE);
      GpiDestroyPS (hpsBmp);
      DevCloseDC (hdcBmp);

      // We handled the message so return zero
      return 0;
   }

   case WM_PAINT:
   {
      // request a cache PS to draw to
      hps = WinBeginPaint (hwnd, NULLHANDLE, &rclInvalid);

      if (hbm != GPI_ERROR)
      {
         WinDrawBitmap (hps, hbm, NULL, (PPOINTL)&rclInvalid,
                        CLR_NEUTRAL, CLR_BACKGROUND, DBM_STRETCH);
      }

      WinEndPaint (hps);

      return 0;
   }
   }

   return WinDefWindowProc (hwnd, msg, mp1, mp2);

} /* end BmpWndProc */

#ifdef DEBUG
/****************************************************************************/
/* PROCEDURE NAME : GraphWndProc                                            */
/* AUTHOR         : MFR                                                     */
/*                                                                          */
/*--------------------------------------------------------------------------*/
/* CHANGE/MODIFICATION LOG :                                                */
/*--------------------------------------------------------------------------*/
/*                                                                          */
/****************************************************************************/
MRESULT EXPENTRY
GraphWndProc (HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
{
   PGRAPHINFO   pgi;
   PFONTMETRICS pfm;
   HPS          hpsGraph;
   RECTL        rclInvalid;
   RECTL        rclText;
   CHAR         szText[24];
   APIRET       rc;
   register int i;
   static LONG  lCharHeight;
   static LONG  lCharWidth;

   switch(msg)
   {
   case WM_CREATE:
   {
      break;
   }

   case WM_CLOSE:
   case WM_DESTROY:
   {
      pgi = (PGRAPHINFO)WinQueryWindowULong (hwnd, QWL_USER);

      DBPRINTF (("GraphWndProc: WM_CLOSE/WM_DESTROY pgi = %08X\n", pgi));

      if (pgi)
      {
         // Allocate storage for X,Y axis labels and default
         if (pgi->pszTextX)
         {
            rc = GplMemoryFree (pgi->pszTextX);
            assertT (rc);
            pgi->pszTextX = NULL;
         }

         if (pgi->pszTextY)
         {
            rc = GplMemoryFree (pgi->pszTextY);
            assertT (rc);
            pgi->pszTextY = NULL;
         }
      }

      // We handled the message so return zero
      return 0;
   }

   case WM_USER_INFO:
   {
      DBPRINTF (("GraphWndProc: WM_USER_INFO mp1 = %08X\n", mp1));

      pgi = (PGRAPHINFO)mp1;

      // Setup first time stuff, if we can here
      if (pgi)
      {
         DBPRINTF (("GraphWndProc: WM_USER_INFO pgi->bInitialized = %d\n", pgi->bInitialized));

         if (!pgi->bInitialized)
         {
            // Get rectangle we'll draw graph in
            WinQueryWindowRect (hwnd, &(pgi->rclGraph));

            // request a cache PS to query info for
            hpsGraph = WinBeginPaint (hwnd, NULLHANDLE, &rclInvalid);

            // Query font height/width we'll be using
            GpiQueryFontMetrics (hpsGraph,
                                 sizeof (FONTMETRICS),
                                 &(pgi->fm));

            WinEndPaint (hpsGraph);

            pfm         = &(pgi->fm);
            lCharHeight = pfm->lEmInc;
            lCharWidth  = pfm->lMaxCharInc;

            // Setup origin point (fixed point) on graph
            pgi->ptlOrigin.x = lCharWidth * 4;
            pgi->ptlOrigin.y = lCharHeight * 4;

            // Allocate storage for X,Y axis labels and default
            if (!pgi->pszTextX)
            {
               pgi->pszTextX = GplMemoryAlloc (pgi->hmcb, 128);
               sprintf (pgi->pszTextX, "Input CMYK");
               pgi->ulTextX = strlen (pgi->pszTextX);
            }

            if (!pgi->pszTextY)
            {
               pgi->pszTextY = GplMemoryAlloc (pgi->hmcb, 128);
               sprintf (pgi->pszTextY, "Output CMYK");
               pgi->ulTextY = strlen (pgi->pszTextY);
            }

            //-------------------------
            // X axis label Rectangle
            //-------------------------
            pgi->rclTextX         = pgi->rclGraph;
            pgi->rclTextX.yTop    = lCharHeight + (lCharHeight / 2);
            pgi->rclTextX.yBottom = (lCharHeight / 2);

            //-------------------------
            // Y axis label rectangle
            //-------------------------
            pgi->rclTextY         = pgi->rclGraph;
            pgi->rclTextY.yBottom = strlen (pgi->pszTextY) * 8;
            pgi->rclTextY.xLeft   = (lCharWidth / 2);
            pgi->rclTextY.xRight  = lCharWidth + (lCharWidth / 2);

            // we only want to initialize this stuff once
            pgi->bInitialized = TRUE;
         }

         // save GRAPHINFO struct for WM_PAINT messages
         WinSetWindowULong (hwnd, QWL_USER, (ULONG)pgi);   // Store the handle
      }
      break;
   }

   case WM_PAINT:
   {
      pgi = (PGRAPHINFO)WinQueryWindowULong (hwnd, QWL_USER);

      if (pgi)
      {
         POINTL ptlTemp;

         // request a cache PS to draw to
         hpsGraph = WinBeginPaint (hwnd, NULLHANDLE, &rclInvalid);

         WinFillRect (hpsGraph, &(pgi->rclGraph), CLR_WHITE);

         GpiSetColor (hpsGraph, CLR_BLACK);

         ptlTemp.x = pgi->rclGraph.xRight - 1;
         ptlTemp.y = pgi->rclGraph.yTop - 1;

         GpiMove (hpsGraph, &ptlTemp);

         ptlTemp.x = 0;
         ptlTemp.y = 0;

         GpiBox (hpsGraph, DRO_OUTLINE, &ptlTemp, 0L, 0L);

         GpiMove (hpsGraph, &(pgi->ptlOrigin));

         // Setup graph current position
         pgi->ptlGraph    = pgi->ptlOrigin;
         pgi->ptlGraph.x += MAX_RGB_VALUE;

         GpiLine (hpsGraph, &(pgi->ptlGraph));

         GpiMove (hpsGraph, &(pgi->ptlOrigin));

         // Setup graph current position
         pgi->ptlGraph    = pgi->ptlOrigin;
         pgi->ptlGraph.y += MAX_RGB_VALUE;

         GpiLine (hpsGraph, &(pgi->ptlGraph));

         //-----------------
         // X Graph Ticks
         //-----------------
         pgi->ptlGraph.y = pgi->ptlOrigin.y - 2;

         rclText.xLeft   = pgi->ptlOrigin.x - 15;
         rclText.xRight  = pgi->ptlOrigin.x + 15;
         rclText.yTop    = pgi->ptlOrigin.y - 3;
         rclText.yBottom = 1;

         for (i = 0; i < NUM_RGB_VALUES; i += 10)
         {
            GpiMove (hpsGraph, &(pgi->ptlGraph));
            pgi->ptlGraph.y = pgi->ptlOrigin.y + 2;
            GpiLine (hpsGraph, &(pgi->ptlGraph));

            if (i % 20 == 0)
            {
               sprintf (szText, "%d", i);

               WinDrawText (hpsGraph,
                            strlen (szText),
                            szText,
                            &rclText,
                            0L, // clrFore
                            0L, // clrBack
                            DT_CENTER | DT_TOP | DT_TEXTATTRS);
            }

            rclText.xLeft  += 10;
            rclText.xRight += 10;

            pgi->ptlGraph.y  = pgi->ptlOrigin.y - 4;
            pgi->ptlGraph.x += 10;
         }

         //-----------------
         // Y Graph Ticks
         //-----------------
         pgi->ptlGraph    = pgi->ptlOrigin;
         pgi->ptlGraph.x -= 2;

         rclText.xLeft   = 1;
         rclText.xRight  = pgi->ptlOrigin.x - 3;
         rclText.yTop    = pgi->ptlOrigin.y + 15;
         rclText.yBottom = pgi->ptlOrigin.y - 15;

         for (i = 0; i < NUM_RGB_VALUES; i += 10)
         {
            GpiMove (hpsGraph, &(pgi->ptlGraph));
            pgi->ptlGraph.x = pgi->ptlOrigin.x + 2;
            GpiLine (hpsGraph, &(pgi->ptlGraph));

            if (i % 20 == 0 || i == (NUM_RGB_VALUES - 1))
            {
               sprintf (szText, "%d", i);

               WinDrawText (hpsGraph,
                            strlen (szText),
                            szText,
                            &rclText,
                            0L, // clrFore
                            0L, // clrBack
                            DT_RIGHT | DT_VCENTER | DT_TEXTATTRS);
            }

            rclText.yTop    += 10;
            rclText.yBottom += 10;

            pgi->ptlGraph.x  = pgi->ptlOrigin.x - 2;
            pgi->ptlGraph.y += 10;
         }

         pgi->ptlGraph.y = pgi->ptlOrigin.y + NUM_RGB_VALUES - 1;
         rclText.yTop    = pgi->ptlGraph.y + 10;
         rclText.yBottom = pgi->ptlGraph.y - 10;
         GpiMove (hpsGraph, &(pgi->ptlGraph));

         pgi->ptlGraph.x = pgi->ptlOrigin.x + 2;
         GpiLine (hpsGraph, &(pgi->ptlGraph));

         sprintf (szText, "%d", NUM_RGB_VALUES-1);

         WinDrawText (hpsGraph,
                      strlen (szText),
                      szText,
                      &rclText,
                      0L, // clrFore
                      0L, // clrBack
                      DT_RIGHT | DT_VCENTER | DT_TEXTATTRS);

         //----------------------
         // X Origin Text
         //----------------------
         WinDrawText (hpsGraph,
                      strlen (pgi->pszTextX),
                      pgi->pszTextX,
                      &(pgi->rclTextX),
                      0L, // clrFore
                      0L, // clrBack
                      DT_CENTER | DT_VCENTER | DT_TEXTATTRS);

         //----------------------
         // Y Origin Text
         //----------------------
         GpiSetCharDirection (hpsGraph, CHDIRN_TOPBOTTOM);

         WinDrawText (hpsGraph,
                      strlen (pgi->pszTextY),
                      pgi->pszTextY,
                      &(pgi->rclTextY),
                      0L, // clrFore
                      0L, // clrBack
                      DT_CENTER | DT_VCENTER | DT_TEXTATTRS);

         GpiSetCharDirection (hpsGraph, CHDIRN_DEFAULT);

         //--------------------
         // Cyan
         //--------------------
         GpiMove (hpsGraph, &(pgi->ptlOrigin));

         for (i = 0; i < NUM_RGB_VALUES; i++)
         {
            pgi->aptlGamma[i].x = i+ pgi->ptlOrigin.x;
            pgi->aptlGamma[i].y = pgi->pbRGamma[i] + pgi->ptlOrigin.y;
         }

         GpiSetColor (hpsGraph, CLR_CYAN);

         GpiSetLineType (hpsGraph, LINETYPE_SOLID);

         GpiPolyLine (hpsGraph, NUM_RGB_VALUES, pgi->aptlGamma);

         //--------------------
         // Magenta
         //--------------------
         GpiMove (hpsGraph, &(pgi->ptlOrigin));

         for (i = 0; i < NUM_RGB_VALUES; i++)
         {
            pgi->aptlGamma[i].x = i+ pgi->ptlOrigin.x;
            pgi->aptlGamma[i].y = pgi->pbGGamma[i] + pgi->ptlOrigin.y;
         }

         GpiSetColor (hpsGraph, CLR_PINK);

         GpiSetLineType (hpsGraph, LINETYPE_LONGDASH);

         GpiPolyLine (hpsGraph, NUM_RGB_VALUES, pgi->aptlGamma);

         //--------------------
         // Yellow
         //--------------------
         GpiMove (hpsGraph, &(pgi->ptlOrigin));

         for (i = 0; i < NUM_RGB_VALUES; i++)
         {
            pgi->aptlGamma[i].x = i+ pgi->ptlOrigin.x;
            pgi->aptlGamma[i].y = pgi->pbBGamma[i] + pgi->ptlOrigin.y;
         }

         GpiSetColor (hpsGraph, CLR_YELLOW);

         GpiSetLineType (hpsGraph, LINETYPE_DASHDOT);

         GpiPolyLine (hpsGraph, NUM_RGB_VALUES, pgi->aptlGamma);

         //--------------------
         // Black
         //--------------------
         GpiMove (hpsGraph, &(pgi->ptlOrigin));

         for (i = 0; i < NUM_RGB_VALUES; i++)
         {
            pgi->aptlGamma[i].x = i+ pgi->ptlOrigin.x;
            pgi->aptlGamma[i].y = pgi->pbKGamma[i] + pgi->ptlOrigin.y;
         }

         GpiSetColor (hpsGraph, CLR_BLACK);

         GpiSetLineType (hpsGraph, LINETYPE_DOT);

         GpiPolyLine (hpsGraph, NUM_RGB_VALUES, pgi->aptlGamma);

         WinEndPaint (hpsGraph);
      }

      return 0;
   }
   }

   return WinDefWindowProc (hwnd, msg, mp1, mp2);

} /* end GraphWndProc */
#endif

/*==========================================================================*/
/* Functions to assist in managing dialog controls                          */
/*==========================================================================*/
/*                                                                          */
/* The functions in this section of DLG.C are used to help initialize,      */
/* send or receive data from certain controls that are in the Omni          */
/* driver's notebook pages.                                                 */
/*                                                                          */
/****************************************************************************/


/****************************************************************************/
/* PROCEDURE NAME : InsertNotebookPage                                      */
/* AUTHOR         : MFR                                                     */
/* DATE WRITTEN   : 05/25/94 !!!!                                           */
/* DESCRIPTION    :                                                         */
/*                                                                          */
/*                  Control Flow:                                           */
/*                                                                          */
/* PARAMETERS:                                                              */
/*                                                                          */
/* RETURN VALUES:                                                           */
/*                                                                          */
/*--------------------------------------------------------------------------*/
/* CHANGE/MODIFICATION LOG :                                                */
/*--------------------------------------------------------------------------*/
/*                                                                          */
/****************************************************************************/
VOID
InsertNotebookPage (HWND          hwnd,
                    PDLGINSTANCE  pdi,
                    PVOID         pvHandle,
                    HWND          hwndNB,
                    ULONG         ulNBID,
                    PNOTEBOOKINFO pNBI,
                    PNBPAGEINFO   pCurrentPage,
                    ULONG         ulDlgID,
                    PFNWP         pfnDlg,
                    PSZ           pszTabText,
                    ULONG         ulTabType)
{
   /*------------------------------------------------------------------------*/
   /* LOCAL VARIABLES                                                        */
   /*------------------------------------------------------------------------*/

   POINTL aptl[TXTBOX_COUNT];
   HPS    hps;
#ifdef DEBUG
   BOOL   bShow     = TRUE;
#endif

   /*------------------------------------------------------------------------*/
   /* BEGIN CODE                                                             */
   /*------------------------------------------------------------------------*/
   DBPRINTIF ((bShow, "%s(): Enter\n", __FUNCTION__));

   pCurrentPage->ulDlgID = ulDlgID;
   pCurrentPage->pfnDlg  = pfnDlg;

   hps = WinGetPS (hwnd);

   GpiQueryTextBox (hps, strlen (pszTabText), pszTabText,
                    TXTBOX_COUNT, (PPOINTL)aptl);

   WinReleasePS (hps);

   pCurrentPage->cyTabText = max (aptl[TXTBOX_TOPRIGHT].y,
                                  aptl[TXTBOX_TOPLEFT].y) -
                             min (aptl[TXTBOX_BOTTOMRIGHT].y,
                                  aptl[TXTBOX_BOTTOMLEFT].y);

   pCurrentPage->cxTabText = max (aptl[TXTBOX_TOPRIGHT].x,
                                  aptl[TXTBOX_BOTTOMRIGHT].x) -
                             min (aptl[TXTBOX_TOPLEFT].x,
                                  aptl[TXTBOX_BOTTOMLEFT].x);

   if (ulTabType == BKA_MAJOR)
   {
      // We need to accumulate Major tab data
      if (pNBI->cxMajor < pCurrentPage->cxTabText)
         pNBI->cxMajor = pCurrentPage->cxTabText;

      if (pNBI->cyMajor < pCurrentPage->cyTabText)
         pNBI->cyMajor = pCurrentPage->cyTabText;
   }
   else
   {
      // We need to accumulate Minor tab data
      if (pNBI->cxMinor < pCurrentPage->cxTabText)
         pNBI->cxMinor = pCurrentPage->cxTabText;

      if (pNBI->cyMinor < pCurrentPage->cyTabText)
         pNBI->cyMinor = pCurrentPage->cyTabText;
   }

   pCurrentPage->hwndPage = WinLoadDlg (hwnd,
                                        hwnd,
                                        (PFNWP)pfnDlg,
                                        globals.hModule,
                                        ulDlgID,
                                        pvHandle);

   assertT (pCurrentPage->hwndPage == NULLHANDLE);

   // Insert notebook page into the notebook
   pCurrentPage->ulPageID = LONGFROMMR (WinSendDlgItemMsg (hwnd,
                                             ulNBID,
                                             BKM_INSERTPAGE,
                                             MPFROMLONG (ulDlgID),
                                             MPFROM2SHORT (ulTabType |
                                                           BKA_AUTOPAGESIZE,
                                                           BKA_FIRST)));

   DBPRINTIF ((bShow,"%s(): ulPageID = '%lu'\n", __FUNCTION__, pCurrentPage->ulPageID));

   // Set tab text
   WinSendDlgItemMsg (hwnd, ulNBID, BKM_SETTABTEXT,
                      MPFROMLONG (pCurrentPage->ulPageID),
                      MPFROMP (pszTabText));

   // Set Page Data for this notebook page
   WinSendDlgItemMsg (hwnd, ulNBID, BKM_SETPAGEDATA,
                      MPFROMLONG (pCurrentPage->ulPageID),
                      MPFROMP (pCurrentPage));

   WinSendMsg (hwndNB,
               BKM_SETPAGEWINDOWHWND,
               MPFROMLONG (pCurrentPage->ulPageID),
               MPFROMHWND (pCurrentPage->hwndPage));

   DBPRINTIF ((bShow, "%s(): Exit\n", __FUNCTION__));

} /* end InsertNotebookPage */



/****************************************************************************/
/* PROCEDURE NAME : InitWebDownloadPage                                     */
/* AUTHOR         : Valters Vingolds                                        */
/* DATE WRITTEN   : 04/14/00                                                */
/* DESCRIPTION    : Add Web Download notebook page to printer properties    */
/*                  dialog box.                                             */
/*                                                                          */
/* PARAMETERS:                                                              */
/*                                                                          */
/* RETURN VALUES:                                                           */
/*                                                                          */
/*--------------------------------------------------------------------------*/
/* CHANGE/MODIFICATION LOG :                                                */
/*--------------------------------------------------------------------------*/
/*                                                                          */
/*                                                                          */
/****************************************************************************/

BOOL InitWebDownloadPage(
   PDLGINSTANCE pdi
   )
{
// driver-global default URL's. Can be overriden by using device-specific
// urls, if we have device-specific structure (like ExtraDV in PSCRIPT)
#define DEFAULT_HOME_URL "http://service.software.ibm.com/os2ddpak/html/printers/index.htm"
#define DEFAULT_DRIVER_URL "ftp://service.boulder.ibm.com/ps/products/os2/printpak/"

   PVOID   pWebPageCB;                     
   WEBPAGE_DRIVERINFO sWebPageDriverInfo;  

   //
   // Web notebook page initialization
   //                                                                  
   pWebPageCB = NULL;

   // There is no device-specific URL support in driver
   // at this time
   sWebPageDriverInfo.pszHomeURL = DEFAULT_HOME_URL;
   sWebPageDriverInfo.pszDriverURL = DEFAULT_DRIVER_URL;

   // give webpage printer's INI key to read data from
   sWebPageDriverInfo.pszKeyApp = pdi->szAppName;

   pdi->hWebPagePgInst = GplWebCreatePage(                          
                                             pdi->hPPNotebookInst,   
                                             pWebPageCB,
                                             NULL,                  
                                             NULL,
                                             &sWebPageDriverInfo
                                          );

   return (BOOL) pdi->hWebPagePgInst;
}

/****************************************************************************/
/* PROCEDURE NAME : FillPrinterPropertiesNotebook                           */
/* AUTHOR         : MFR                                                     */
/* DATE WRITTEN   : 05/25/94 !!!!                                           */
/* DESCRIPTION    :                                                         */
/*                                                                          */
/*                  Control Flow:                                           */
/*                                                                          */
/* PARAMETERS:                                                              */
/*                                                                          */
/* RETURN VALUES:                                                           */
/*                                                                          */
/*--------------------------------------------------------------------------*/
/* CHANGE/MODIFICATION LOG :                                                */
/*--------------------------------------------------------------------------*/
/* @EXJOB  - 07/13/98 - UCC [IBMJ]- Expansible job data support             */
/*                                                                          */
/****************************************************************************/
VOID
FillPrinterPropertiesNotebook (HWND hwnd, PDLGINSTANCE pdi)
{
   /*------------------------------------------------------------------------*/
   /* LOCAL VARIABLES                                                        */
   /*------------------------------------------------------------------------*/
   PNBPAGEINFO   pCurrentPage;
   PNOTEBOOKINFO pNBI;
   ULONG         ulIdx;
   BOOL          bRC;
#ifdef DEBUG
   BOOL          bShow  = FALSE;
#endif

   /*------------------------------------------------------------------------*/
   /* BEGIN CODE                                                             */
   /*------------------------------------------------------------------------*/
   DBPRINTIF ((bShow, "%s(): Enter\n", __FUNCTION__));

   // easier pointers to dereference
   pNBI = pdi->pNBI;
   assertF (pNBI);

   pNBI->cxMajor = 0;
   pNBI->cyMajor = 0;

   // We are going to fill in a lot of strings from a similar location
   // in stringtable so lets get a base index to reference from
   ulIdx = STRING_TABLE_DLG_BASE - STRING_TABLE_BASE;

   // Find out info about the system's entryfield class
   bRC = WinQueryClassInfo (WinQueryAnchorBlock (hwnd),
                            WC_ENTRYFIELD,
                            &HexClassInfo);
   assertF (bRC);

   // NEW!!! register new class for Hex Entry
   bRC = WinRegisterClass (WinQueryAnchorBlock (hwnd),
                           HEX_ENTRY_CLASS,
                           HexEntryWndProc,
                           HexClassInfo.flClassStyle & ~CS_PUBLIC,
                           HexClassInfo.cbWindowData);

#ifdef DEBUG
   //--------------------//
   // DEBUG PAGE         //
   //--------------------//
   DBPRINTF (("%s(): Adding Debug Option Page\n", __FUNCTION__));

   InsertNotebookPage (hwnd,
                       pdi,
                       pdi,
                       pdi->pNBI->hwndNB,
                       pdi->pNBI->ulNBID,
                       pdi->pNBI,
                       &(pNBI->PageInfoDebug),
                       IDD_OPTIONS_DEBUG, DebugDlgProc,
                       globals.pbStringTable[ulIdx + DIALOG_DEBUG],
                       BKA_MAJOR);
#endif

   //---------------------------
   // Device-Supplied Dialogs
   //---------------------------
   if (!pdi->StateData.ulCalledDeviceQueryDialogs)
   {
      InitializeDialogDevice (pdi, hwnd, DEVICE_QUERY_PRN_DIALOGS);
   }

   //--------------------//
   // FONT PAGE          //
   //--------------------//
   if (pdi->pDevice->usNumFonts > 0)
   {
      DBPRINTIF ((bShow, "%s(): Adding Font Page\n", __FUNCTION__));
      InsertNotebookPage (hwnd,
                          pdi,
                          pdi,
                          pdi->pNBI->hwndNB,
                          pdi->pNBI->ulNBID,
                          pdi->pNBI,
                          &(pNBI->PageInfoFont),
                          IDD_FONT_DLG, FontDlgProc,
                          globals.pbStringTable[ulIdx + DIALOG_FONTS],
                          BKA_MAJOR);
   }

   //----------------------//
   // Paper Size Page      //
   //----------------------//
   DBPRINTIF ((bShow, "%s(): Adding Define Paper Size Sub-Page\n", __FUNCTION__));

   // The dialog box about to be displayed has a client window in it.  It
   // uses the FORMINFOCLASS class, so we need to register it!
   WinRegisterClass (WinQueryAnchorBlock (hwnd),
                     (PSZ)FORM_INFO_CLASS,
                     (PFNWP)FormInfoWndProc,
                     CS_SAVEBITS,
                     4);

   // Find out info about the system's entryfield class
   bRC = WinQueryClassInfo (WinQueryAnchorBlock (hwnd),
                            WC_ENTRYFIELD,
                            &eci);
   assertF (bRC);

   // Register our own private entry field class
   bRC = WinRegisterClass (WinQueryAnchorBlock (hwnd),
                           ENTRYFIELD_SUBCLASS,
                           SubClassedEntryWndProc,
                           eci.flClassStyle & ~CS_PUBLIC,
                           eci.cbWindowData);
   assertF (bRC);

   pCurrentPage = &(pNBI->PageInfoPaperSize);

   pCurrentPage->ulDlgID = IDD_DEFINE_FORM;
   pCurrentPage->pfnDlg  = DefineFormDlgProc;

   pdi->pFI = GplMemoryAlloc (pdi->hmcbHeap, sizeof (FORMINFO));
   assertF (pdi->pFI);

   if (pdi->pFI)
   {
      ULONG ulDefFormID;

      pdi->pFI->ulSize   = sizeof (FORMINFO);
      pdi->pFI->bNoEdit  = TRUE;

      GetIDsFromConnID (pdi->pDriver,
                        pdi->pDevice,
                        pdi->pJobProperties->ulDefConnID, // @EXJOB
                        NULL,
                        &ulDefFormID,
                        NULL);

      bRC = FormInfoFromID (pdi->pDriver,
                            pdi->pDevice,
                            ulDefFormID,
                            &(pdi->pFI->Form));
      assert (bRC);

      if (bRC)
      {
         FormNameFromID (pdi->pDriver,
                         pdi->pDevice,
                         pdi->pFI->Form.hcInfo.szFormname,
                         pdi->pFI->Form.ulFormID);

         pdi->pFI->cx       = pdi->pFI->Form.hcInfo.cx;
         pdi->pFI->cy       = pdi->pFI->Form.hcInfo.cy;
         pdi->pFI->ulLeft   = pdi->pFI->Form.hcInfo.xLeftClip;
         pdi->pFI->ulBottom = pdi->pFI->Form.hcInfo.yBottomClip;
         pdi->pFI->ulRight  = pdi->pFI->cx - pdi->pFI->Form.hcInfo.xRightClip;
         pdi->pFI->ulTop    = pdi->pFI->cy - pdi->pFI->Form.hcInfo.yTopClip;

#ifdef DEBUG
         DebugOutputJobProperties (FALSE, NULL, pdi->pJobProperties); // @EXJOB
         DebugOutputFormInfo (FALSE, "Form Info", pdi->pFI);
#endif
      }
   }

   InsertNotebookPage (hwnd,
                       pdi,
                       pdi,
                       pdi->pNBI->hwndNB,
                       pdi->pNBI->ulNBID,
                       pdi->pNBI,
                       &(pNBI->PageInfoPaperSize),
                       IDD_DEFINE_FORM, DefineFormDlgProc,
                       globals.pbStringTable[ulIdx + DIALOG_PAPER],
                       BKA_MAJOR);

   //--------------------//
   // Tray Sub-Page      //
   //--------------------//
   DBPRINTIF ((bShow, "%s(): Adding Define Tray Sub-Page\n", __FUNCTION__));

   InsertNotebookPage (hwnd,
                       pdi,
                       pdi,
                       pdi->pNBI->hwndNB,
                       pdi->pNBI->ulNBID,
                       pdi->pNBI,
                       &(pNBI->PageInfoTray),
                       IDD_DEFINE_TRAY, DefineTrayDlgProc,
                       globals.pbStringTable[ulIdx + DIALOG_TRAYS],
                       BKA_MAJOR);

   //--------------------//
   // Connection Page    //
   //--------------------//
   DBPRINTIF ((bShow, "%s(): Adding Form Connection Page\n", __FUNCTION__));

   InsertNotebookPage (hwnd,
                       pdi,
                       pdi,
                       pdi->pNBI->hwndNB,
                       pdi->pNBI->ulNBID,
                       pdi->pNBI,
                       &(pNBI->PageInfoFormConnect),
                       IDD_FORM_CONNECTIONS, FormConnectionDlgProc,
                       globals.pbStringTable[ulIdx + DIALOG_FORMS],
                       BKA_MAJOR);

   DBPRINTIF ((bShow, "%s(): Exit\n", __FUNCTION__));

} /* end FillPrinterPropertiesNotebook */

/****************************************************************************/
/* PROCEDURE NAME : FillJobPropertiesNotebook                               */
/* AUTHOR         : MFR                                                     */
/* DATE WRITTEN   : 08/05/94 !!!!                                           */
/* DESCRIPTION    :                                                         */
/*                                                                          */
/*                  Control Flow:                                           */
/*                                                                          */
/* PARAMETERS:                                                              */
/*                                                                          */
/* RETURN VALUES:                                                           */
/*                                                                          */
/*--------------------------------------------------------------------------*/
/* CHANGE/MODIFICATION LOG :                                                */
/*--------------------------------------------------------------------------*/
/*                                                                          */
/****************************************************************************/
VOID
FillJobPropertiesNotebook (HWND hwnd, PDLGINSTANCE pdi)
{
   PNOTEBOOKINFO pNBI;
   ULONG         ulIdx;
#ifdef DEBUG
   BOOL          bShow    = TRUE;
#endif

   DBPRINTIF ((bShow, "%s(): Enter\n", __FUNCTION__));

   // easier pointers to dereference
   pNBI = pdi->pNBI;
   assertF (pNBI);

   pNBI->cxMajor = 0;
   pNBI->cyMajor = 0;

   // We are going to fill in a lot of strings from a similar location
   // in stringtable so lets get a base index to reference from
   ulIdx = STRING_TABLE_DLG_BASE - STRING_TABLE_BASE;

   //---------------------------
   // Device-Supplied Dialogs
   //---------------------------
   if (!pdi->StateData.ulCalledDeviceQueryDialogs)
   {
      InitializeDialogDevice (pdi, hwnd, DEVICE_QUERY_JOB_DIALOGS);
   }

   //--------------------//
   // HSV Page           //
   //--------------------//

   // Has color capability but in monochrome mode - allow foreground
   // background colors
   if (pdi->pDevice->ulOmniDeviceTechnology & OMNI_CAP_COLOR)
   {
      DBPRINTF (("%s(): Adding HSV Color Page\n", __FUNCTION__));

      InsertNotebookPage (hwnd,
                          pdi,
                          pdi,
                          pdi->pNBI->hwndJobPropNB,
                          pdi->pNBI->ulJobPropNBID,
                          pdi->pNBI,
                          &(pNBI->PageInfoHSV),
                          IDD_HSV,
                          HSVDlgProc,
                          globals.pbStringTable[ulIdx + DIALOG_HSV],
                          BKA_MAJOR);
   }

   //--------------------//
   // Color Image Page   //
   //--------------------//
   DBPRINTIF ((TRUE, "%s(): Omni Device Tech = %x\n", __FUNCTION__,
               pdi->pDevice->ulOmniDeviceTechnology));

   if (pdi->pDevice->ulOmniDeviceTechnology & OMNI_CAP_COLOR)
   {
      DBPRINTF (("%s(): Adding Color Image Page\n", __FUNCTION__));

      WinRegisterClass (WinQueryAnchorBlock (hwnd),
                        BITMAP_CLASS,
                        (PFNWP)BmpWndProc,
                        WS_VISIBLE  |
                        CS_SAVEBITS |
                        CS_SYNCPAINT,
                        sizeof (ULONG));  // bytes to reserve

#ifdef DEBUG
      WinRegisterClass (WinQueryAnchorBlock (hwnd),
                        GRAPH_CLASS,
                        (PFNWP)GraphWndProc,
                        WS_VISIBLE  |
                        CS_SAVEBITS |
                        CS_SYNCPAINT,
                        sizeof (ULONG) );  // bytes to reserve
#endif

      InsertNotebookPage (hwnd,
                          pdi,
                          pdi,
                          pdi->pNBI->hwndJobPropNB,
                          pdi->pNBI->ulJobPropNBID,
                          pdi->pNBI,
                          &(pNBI->PageInfoImageClr),
                          IDD_IMAGE_OPTIONS_COLOR,
                          ColorImageDlgProc,
                          globals.pbStringTable[ulIdx + DIALOG_COLOR],
                          BKA_MAJOR);
   }

   //--------------------//
   // Mono Image Page    //
   //--------------------//
   DBPRINTF (("%s(): Adding Mono Image Page\n", __FUNCTION__));

   InsertNotebookPage (hwnd,
                       pdi,
                       pdi,
                       pdi->pNBI->hwndJobPropNB,
                       pdi->pNBI->ulJobPropNBID,
                       pdi->pNBI,
                       &(pNBI->PageInfoImageMono),
                       IDD_IMAGE_OPTIONS_MONO,
                       MonoImageDlgProc,
                       globals.pbStringTable[ulIdx + DIALOG_MONOCHROME],
                       BKA_MAJOR);

   //--------------------//
   // JOB PROPS PAGE     //
   //--------------------//
   DBPRINTF (("%s(): Adding Job Property Page\n", __FUNCTION__));

   InsertNotebookPage (hwnd,
                       pdi,
                       pdi,
                       pdi->pNBI->hwndJobPropNB,
                       pdi->pNBI->ulJobPropNBID,
                       pdi->pNBI,
                       &(pNBI->PageInfoJobProps),
                       IDD_COMMON_JOB_PROPERTIES,
                       CommonJobPropertiesDlgProc,
                       globals.pbStringTable[ulIdx + DIALOG_COMMON],
                       BKA_MAJOR);

   DBPRINTIF ((bShow, "%s(): Exit\n", __FUNCTION__));

} /* end FillJobPropertiesNotebook */

/****************************************************************************/
/* PROCEDURE NAME : SaveJobProperties                                       */
/* AUTHOR         : MFR                                                     */
/* DATE WRITTEN   : 08/08/94                                                */
/* DESCRIPTION    :                                                         */
/*                                                                          */
/* PARAMETERS:                                                              */
/*                                                                          */
/*                                                                          */
/* RETURN VALUES:                                                           */
/*                                                                          */
/*                                                                          */
/*--------------------------------------------------------------------------*/
/* CHANGE/MODIFICATION LOG :                                                */
/*--------------------------------------------------------------------------*/
/* jk1115  November 1998 For new dithering methods make more sensitive      */
/*                         gamma sliders                                    */
/*                                                                          */
/****************************************************************************/
BOOL
SaveJobProperties (PDLGINSTANCE pdi, PJOBPROPERTIES pJobProps)
{
   /*------------------------------------------------------------------------*/
   /* LOCAL VARIABLES                                                        */
   /*------------------------------------------------------------------------*/
   BOOL bSuccess   = TRUE;
   HWND hwndCommon = pdi->pNBI->PageInfoJobProps.hwndPage;
   HWND hwndColor  = pdi->pNBI->PageInfoImageClr.hwndPage;
   HWND hwndMono   = pdi->pNBI->PageInfoImageMono.hwndPage;
   HWND hwndHSV    = pdi->pNBI->PageInfoHSV.hwndPage;
   SHORT sIdx;
   ULONG ulOption;

   /*------------------------------------------------------------------------*/
   /* BEGIN CODE                                                             */
   /*------------------------------------------------------------------------*/
   DBPRINTIF ((TRUE,"%s(): Enter\n", __FUNCTION__));

   /*-------------------------*/
   /* ORIENTATION             */
   /*-------------------------*/
   if (WinSendDlgItemMsg (hwndCommon, IDC_PORTRAIT, BM_QUERYCHECK, 0, 0))
   {
      pJobProps->ulOrientation = ORIENTATION_PORTRAIT;
   }
   else
   {
      if (WinSendDlgItemMsg (hwndCommon, IDC_LANDSCAPE, BM_QUERYCHECK, 0, 0))
      {
         pJobProps->ulOrientation = ORIENTATION_LANDSCAPE;
      }
   }

   /*-------------------------*/
   /* DUPLEX                  */
   /*-------------------------*/
   if (WinSendDlgItemMsg (hwndCommon, IDR_DUPLEX_FLIP, BM_QUERYCHECK, 0, 0))
   {
      pJobProps->ulDuplexOptions = DUPLEX_FLIP;
   }
   else
   {
      if (WinSendDlgItemMsg (hwndCommon, IDR_DUPLEX_BOOK, BM_QUERYCHECK, 0, 0))
         pJobProps->ulDuplexOptions = DUPLEX_BOOK;
      else
         pJobProps->ulDuplexOptions = DUPLEX_NONE;
   }

   /*-------------------------*/
   /* FF Control              */
   /*-------------------------*/
   if (WinSendDlgItemMsg (hwndCommon, IDR_FF_CONDITIONAL,  BM_QUERYCHECK, 0, 0))
   {
      pJobProps->bFFControlType = FF_CTL_CONDITIONAL;
   }
   else
   {
      if (WinSendDlgItemMsg (hwndCommon, IDR_FF_NONE, BM_QUERYCHECK, 0, 0))
      {
         pJobProps->bFFControlType = FF_CTL_NONE;
      }
      else
      {
         if (WinSendDlgItemMsg (hwndCommon, IDR_FF_COMPULSORY, BM_QUERYCHECK, 0, 0))
         {
            pJobProps->bFFControlType = FF_CTL_COMPULSORY;
         }
      }
   }

   /*-------------------------*/
   /* RESOLUTION              */
   /*-------------------------*/
   sIdx = SHORT1FROMMR (WinSendDlgItemMsg (hwndCommon,
                                           IDD_RESOLUTIONS,
                                           LM_QUERYSELECTION,
                                           0L,
                                           0L));

   // verify user selected listbox field
   if (sIdx != LIT_NONE)
   {
      // Get Item Handle (Res ID)
      pJobProps->ulDefResID = (ULONG)WinSendDlgItemMsg (hwndCommon,
                                           IDD_RESOLUTIONS,
                                           LM_QUERYITEMHANDLE,
                                           MPFROMSHORT (sIdx),
                                           MPVOID);
   }

   /*------------------------------*/
   /* DEFAULT FORM CONNECTION      */
   /*------------------------------*/
   sIdx = SHORT1FROMMR (WinSendDlgItemMsg (hwndCommon,
                                           IDD_DEFAULT_FORM,
                                           LM_QUERYSELECTION,
                                           0L,
                                           0L));

   // verify user selected listbox field
   if (sIdx != LIT_NONE)
   {
      // Get Item Handle (Conn ID)
      pJobProps->ulDefConnID = (ULONG)WinSendDlgItemMsg (hwndCommon,
                                           IDD_DEFAULT_FORM,
                                           LM_QUERYITEMHANDLE,
                                           MPFROMSHORT (sIdx),
                                           MPVOID);
   }

   /*-------------------------*/
   /* FONT NAME               */
   /*-------------------------*/
   sIdx = SHORT1FROMMR (WinSendDlgItemMsg (hwndCommon,
                                           IDD_DEFAULT_FONT,
                                           LM_QUERYSELECTION,
                                           0L,
                                           0L));

   // verify user selected listbox field
   if (sIdx != LIT_NONE)
   {
      // Get Item Handle (Font ID)
      pJobProps->ulDefFontID = (ULONG)WinSendDlgItemMsg (hwndCommon,
                                           IDD_DEFAULT_FONT,
                                           LM_QUERYITEMHANDLE,
                                           MPFROMSHORT (sIdx),
                                           MPVOID);
   }

   /*-------------------------*/
   /* PRINT MODE              */
   /*-------------------------*/
   sIdx = SHORT1FROMMR (WinSendDlgItemMsg (hwndCommon,
                                           IDD_DEFAULT_PRINT_MODE,
                                           LM_QUERYSELECTION,
                                           0L,
                                           0L));

   // verify user selected listbox field
   if (sIdx != LIT_NONE)
   {
      // Get Item Handle (Print Mode ID)
      pJobProps->ulDefPrintModeID = (ULONG)WinSendDlgItemMsg (hwndCommon,
                                                   IDD_DEFAULT_PRINT_MODE,
                                                   LM_QUERYITEMHANDLE,
                                                   MPFROMSHORT (sIdx),
                                                   MPVOID);
   }

   /*-------------------------*/
   /* Mirror Image            */
   /*-------------------------*/
   ulOption = (ULONG)WinQueryButtonCheckstate (hwndCommon, IDD_MIRROR);

   if (ulOption && pJobProps->ulOrientation == ORIENTATION_PORTRAIT)
      pJobProps->ulImageoption |= IMAGE_OPTION_MIRROR;      // set bit
   else
      pJobProps->ulImageoption &= IMAGE_OPTION_MIRROR_MASK; // unset bit

   /*-------------------------*/
   /* Dither Algorithm        */
   /*-------------------------*/
   sIdx = SHORT1FROMMR (WinSendDlgItemMsg (hwndCommon,
                                           IDD_ALGORITHMS,
                                           LM_QUERYSELECTION,
                                           0L,
                                           0L));

   // verify user selected Halftone Algorithm
   if (sIdx != LIT_NONE)
   {
      // Get Item Handle (Func ID)
      pJobProps->ulAlgorithm = (ULONG)WinSendDlgItemMsg (hwndCommon,
                                  IDD_ALGORITHMS,
                                  LM_QUERYITEMHANDLE,
                                  MPFROMSHORT (sIdx),
                                  MPVOID);
   }

   // @MAGIC
   if (pJobProps->ulAlgorithm == HT_LEVEL)
   {
      pJobProps->ulAlgorithm = HT_MAGIC_SQUARES;
   }

   /*-------------------------*/
   /* Mono Foreground Color   */
   /*-------------------------*/
   sIdx = SHORT1FROMMR (WinSendDlgItemMsg (hwndMono,
                                           IDD_FOREGROUND,
                                           LM_QUERYSELECTION,
                                           0L,
                                           0L));

   // verify user selected Foreground color list
   if (sIdx != LIT_NONE)
   {
      // Get Item Handle (Func ID)
      pJobProps->usForeground = (ULONG)WinSendDlgItemMsg (hwndMono,
                                  IDD_FOREGROUND,
                                  LM_QUERYITEMHANDLE,
                                  MPFROMSHORT (sIdx),
                                  MPVOID);
   }

   /*-------------------------*/
   /* Mono Background Color   */
   /*-------------------------*/
   sIdx = SHORT1FROMMR (WinSendDlgItemMsg (hwndMono,
                                           IDD_BACKGROUND,
                                           LM_QUERYSELECTION,
                                           0L,
                                           0L));

   // verify user selected Background color list
   if (sIdx != LIT_NONE)
   {
      // Get Item Handle (Func ID)
      pJobProps->usBackground = (ULONG)WinSendDlgItemMsg (hwndMono,
                                  IDD_BACKGROUND,
                                  LM_QUERYITEMHANDLE,
                                  MPFROMSHORT (sIdx),
                                  MPVOID);
   }

   /*-------------------------*/
   /* Monochrome Darkness     */
   /*-------------------------*/
   ulOption = (ULONG)WinSendDlgItemMsg (hwndMono, IDD_DARKNESS,
                                        SLM_QUERYSLIDERINFO,
                                        MPFROM2SHORT (SMA_SLIDERARMPOSITION,
                                                      SMA_INCREMENTVALUE),
                                        MPVOID);

   pJobProps->lDarkness = ulOption - MAX_DEVIATION;

   /*-------------------------*/
   /* Gamma                   */
   /*-------------------------*/
   ReadGammaControls (pJobProps, hwndColor);

   /*-------------------------*/
   /* Bias                    */
   /*-------------------------*/
   WinSendDlgItemMsg (hwndColor,
                      IDD_CLR_BIAS_RED,
                      SPBM_QUERYVALUE,
                      &pJobProps->lRedBias,
                      MPVOID);

   WinSendDlgItemMsg (hwndColor,
                      IDD_CLR_BIAS_GREEN,
                      SPBM_QUERYVALUE,
                      &pJobProps->lGreenBias,
                      MPVOID );

   WinSendDlgItemMsg (hwndColor,
                      IDD_CLR_BIAS_BLUE,
                      SPBM_QUERYVALUE,
                      &pJobProps->lBlueBias,
                      MPVOID);

   WinSendDlgItemMsg (hwndColor,
                      IDD_CLR_BIAS_BLACK,
                      SPBM_QUERYVALUE,
                      &pJobProps->bBlackBias,
                      MPVOID);

   /*-------------------------*/
   /* Color Hue               */
   /*-------------------------*/
   ulOption = (ULONG)WinSendDlgItemMsg (hwndHSV, IDD_HUE,
                                        SLM_QUERYSLIDERINFO,
                                        MPFROM2SHORT (SMA_SLIDERARMPOSITION,
                                                      SMA_INCREMENTVALUE),
                                        MPVOID);

   // Each tick represents 4 degrees of color hue
   ulOption *= 4;

   pJobProps->lHue = ulOption - MAX_DEGREE;

   /*-------------------------*/
   /* Color Saturation        */
   /*-------------------------*/
   ulOption = (ULONG)WinSendDlgItemMsg (hwndHSV, IDD_SATURATION,
                                        SLM_QUERYSLIDERINFO,
                                        MPFROM2SHORT (SMA_SLIDERARMPOSITION,
                                                      SMA_INCREMENTVALUE),
                                        MPVOID);

   pJobProps->lSaturation = ulOption - MAX_DEVIATION;

   /*-------------------------*/
   /* Color Darkness (Value)  */
   /*-------------------------*/
   ulOption = (ULONG)WinSendDlgItemMsg (hwndHSV, IDD_CLR_DARKNESS,
                                        SLM_QUERYSLIDERINFO,
                                        MPFROM2SHORT (SMA_SLIDERARMPOSITION,
                                                      SMA_INCREMENTVALUE),
                                        MPVOID);

   pJobProps->lValue = ulOption - MAX_DEVIATION;

   /*-------------------------*/
   
   /*-------------------------*/
   WinSendMsg(WinWindowFromID(hwndCommon, IDD_COPIES_NUMBER), SPBM_QUERYVALUE, (MPARAM)&(pJobProps->ulCopies), MPVOID);


   /*-------------------------*/
   
   /*-------------------------*/
   if (WinSendDlgItemMsg(hwndCommon, IDD_COLLATE, BM_QUERYCHECK, 0, 0))
      pJobProps->ulImageoption |= IMAGE_OPTION_COLLATE;
   else
      pJobProps->ulImageoption &= ~IMAGE_OPTION_COLLATE;


   DBPRINTIF ((TRUE,"%s(): Exit\n", __FUNCTION__));

   return bSuccess;

} /* end SaveJobProperties */

/****************************************************************************/
/* PROCEDURE NAME : DlgSavePrinterProperties                                */
/* AUTHOR         : MFR                                                     */
/* DATE WRITTEN   : 07/11/94 !!!!                                           */
/* DESCRIPTION    :                                                         */
/*                                                                          */
/*                  Control Flow:                                           */
/*                                                                          */
/* PARAMETERS:                                                              */
/*                                                                          */
/* RETURN VALUES:                                                           */
/*                                                                          */
/*--------------------------------------------------------------------------*/
/* CHANGE/MODIFICATION LOG :                                                */
/*--------------------------------------------------------------------------*/
/*                                                                          */
/****************************************************************************/
BOOL
DlgSavePrinterProperties (PSZ pszAppName, PDLGINSTANCE pdi)
{
#if 0
   BOOL           bSuccess = TRUE;

   // Read in new memory value
   if (pdi->pDevice->pMemory->ulMemFlags & MEMORY_INSTALLABLE)
   {
      bSuccess = (BOOL)WinSendDlgItemMsg (pdi->pNBI->PageInfoDeviceInfo.hwndPage,
                                          IDD_INSTALLED_MEMORY,
                                          SPBM_QUERYVALUE,
                                          MPFROMP (&(pPrnProps->ulInstalledMemory)),
                                          MPFROM2SHORT (0, SPBQ_UPDATEIFVALID));

      DBPRINTIF ((TRUE,"%s(): SPBM_QUERYVALUE rc = %d\n", __FUNCTION__, bSuccess));
   }

   DBPRINTIF ((TRUE,"%s(): ulInstalled Memory = %lu\n", __FUNCTION__, pPrnProps->ulInstalledMemory));
#endif

   return SavePrinterProperties (pszAppName, &pdi->PrnProperties);
}

/****************************************************************************/
/* PROCEDURE NAME : CreateHelpInstance                                      */
/* AUTHOR         : MFR                                                     */
/* DATE WRITTEN   : 07/11/94 !!!!                                           */
/* DESCRIPTION    :                                                         */
/*                                                                          */
/*                  Control Flow:                                           */
/*                                                                          */
/* PARAMETERS:                                                              */
/*                                                                          */
/* RETURN VALUES:                                                           */
/*                                                                          */
/*--------------------------------------------------------------------------*/
/* CHANGE/MODIFICATION LOG :                                                */
/*--------------------------------------------------------------------------*/
/*                                                                          */
/****************************************************************************/
BOOL
CreateHelpInstance (PDLGINSTANCE pdi, BOOL bPrnProps)
{
   HELPINIT    helpinit;
   BOOL        bSuccess                = TRUE;
   HAB         habCurrent;
   HWND        hwndCurrent;
   CHAR        szHelpFile[LEN_STRING];
   APIRET      rc;
#ifdef DEBUG
   PDEBUGINFO  pDbg                    = &globals.DebugInfo;
#endif

   DBPRINTIF ((pDbg->bOMNICREATEHELPINSTANCE, "%s(): Enter\n", __FUNCTION__));

#if LOADHELPMGR
{
   CHAR achPath[CCHMAXPATH];

   if (!DosLoadModule (achPath,
                       sizeof (achPath),
                       "HELPMGR",
                       &pdi->hmodHelp)) //No Help Manager
   {
      if (!DosQueryProcAddr (pdi->hmodHelp,
                             51L,
                             "WINCREATEHELPINSTANCE",
                             (PFN *)&pfnWinCreateHelpInstance))   // No API
      {
         if (!DosQueryProcAddr (pdi->hmodHelp,
                                52L,
                                "WINDESTROYHELPINSTANCE",
                                (PFN *)&pfnWinDestroyHelpInstance)) // No API
         {
            DosQueryProcAddr (pdi->hmodHelp,
                              54L,
                              "WINASSOCIATEHELPINSTANCE",
                              (PFN *)&pfnWinAssociateHelpInstance); // No API
         }
      }
   }
}
#endif

   /*--------------------------------------------*/
   /* Setup IPF help instance                    */
   /*--------------------------------------------*/
   helpinit.cb                       = sizeof (HELPINIT);
   helpinit.ulReturnCode             = 0L;
   helpinit.pszTutorialName          = (PSZ)NULL;
   helpinit.phtHelpTable             = (PHELPTABLE)MAKEULONG (PRINTER_PROPERTIES_HELPTABLE, 0xffff);
   helpinit.hmodHelpTableModule      = globals.hModule;
   helpinit.hmodAccelActionBarModule = NULLHANDLE;
   helpinit.idAccelTable             = 0L;
   helpinit.idActionBar              = 0L;
   helpinit.pszHelpWindowTitle       = globals.pbStringTable[STRING_TABLE_DLG_BASE - STRING_TABLE_BASE + DIALOG_PRINTER_PROPS];
#ifdef DEBUG
   helpinit.fShowPanelId             = CMIC_SHOW_PANEL_ID;
#else
   helpinit.fShowPanelId             = CMIC_HIDE_PANEL_ID;
#endif

   if (bPrnProps)
   {
      hwndCurrent = pdi->hwndPrnProp;
   }
   else
   {
      hwndCurrent = pdi->hwndJobProp;
   }

   // derive name from achDriver in globals
   GetDriverDriveAndPath (szHelpFile);

   helpinit.pszHelpLibraryName = szHelpFile;

   DBPRINTIF ((pDbg->bOMNICREATEHELPINSTANCE, "%s(): HelpLibraryName = '%s'\n", __FUNCTION__, helpinit.pszHelpLibraryName));

   habCurrent = WinQueryAnchorBlock (hwndCurrent);

   assertT (pdi->hwndHelp);
   pdi->hwndHelp = pfnWinCreateHelpInstance (habCurrent, &helpinit);
   assertF (pdi->hwndHelp);

   if (pdi->hwndHelp)
   {
      DBPRINTIF ((pDbg->bOMNICREATEHELPINSTANCE, "%s(): WinCreateHelpInstance success: hwndHelp = '%x'\n", __FUNCTION__, pdi->hwndHelp));

      rc = pfnWinAssociateHelpInstance (pdi->hwndHelp, hwndCurrent);
      assertF (rc);

      if (!rc)
      {
         DBPRINTF (( "%s(): WinAssociateHelpInstance failed!\n", __FUNCTION__));

         rc = pfnWinDestroyHelpInstance (pdi->hwndHelp);
         assertF (rc);

         pdi->hwndHelp = (HWND)NULL;

         bSuccess = FALSE;
      }
   }
   else
   {
      DBPRINTF (("%s(): WinCreateHelpInstance failed; ulReturnCode = 0x%x\n", __FUNCTION__, helpinit.ulReturnCode));
      bSuccess = FALSE;
   }

#ifndef DEBUG
   rc++;          // Avoid compiler warnings
#endif

   DBPRINTIF ((pDbg->bOMNICREATEHELPINSTANCE, "%s(): Exit\n", __FUNCTION__));

   return bSuccess;

} /* end CreateHelpInstance */

/****************************************************************************/
/* PROCEDURE NAME : DestroyHelpInstance                                     */
/* AUTHOR         : MFR                                                     */
/* DATE WRITTEN   : 07/11/94 !!!!                                           */
/* DESCRIPTION    :                                                         */
/*                                                                          */
/*                  Control Flow:                                           */
/*                                                                          */
/* PARAMETERS:                                                              */
/*                                                                          */
/* RETURN VALUES:                                                           */
/*                                                                          */
/*--------------------------------------------------------------------------*/
/* CHANGE/MODIFICATION LOG :                                                */
/*--------------------------------------------------------------------------*/
/*                                                                          */
/****************************************************************************/
BOOL
DestroyHelpInstance (PDLGINSTANCE pdi, BOOL bPrnProps)
{
   BOOL        bSuccess      = TRUE;
   HWND        hwndCurrent;
#ifdef DEBUG
   PDEBUGINFO  pDbg          = &globals.DebugInfo;
#endif

   DBPRINTIF ((pDbg->bOMNIDESTROYHELPINSTANCE, "%s(): Enter\n", __FUNCTION__));

   if (pdi->hwndHelp)
   {
      if (bPrnProps)
      {
         hwndCurrent = pdi->hwndPrnProp;
      }
      else
      {
         hwndCurrent = pdi->hwndJobProp;
      }

      /*--------------------------------------------*/
      /* Disassociate the Help Instance             */
      /*--------------------------------------------*/
      // @TBD fix disassociate for Job Props
      bSuccess = pfnWinAssociateHelpInstance (NULLHANDLE, hwndCurrent);
      assertF (bSuccess);

      DBPRINTIF ((pDbg->bOMNIDESTROYHELPINSTANCE, "%s(): WinAssociateHelpInstance (NULLHANDLE, %x); rc = %d\n", __FUNCTION__, WinQueryActiveWindow (HWND_DESKTOP), bSuccess));
      DBPRINTIF ((!bSuccess, "%s(): WinAssociateHelpInstance (NULLHANDLE, %x) FAILED!\n", __FUNCTION__, WinQueryActiveWindow (HWND_DESKTOP)));

      /*--------------------------------------------*/
      /* Destroy the Help Instance                  */
      /*--------------------------------------------*/
      bSuccess = pfnWinDestroyHelpInstance (pdi->hwndHelp);
      assertF (bSuccess);

      DBPRINTIF ((pDbg->bOMNIDESTROYHELPINSTANCE, "%s(): WinDestroyHelpInstance (hwndHelp = '%x'); rc=%d: \n", __FUNCTION__, pdi->hwndHelp, bSuccess));

      if (bSuccess)
      {
         // reset hwnd
         pdi->hwndHelp = NULLHANDLE;
      }
   }
   else
   {
      assertstring ("pdi->hwndHelp == NULL\n");
      DBPRINTIF ((pDbg->bOMNIDESTROYHELPINSTANCE, "%s(): pdi->hwndHelp == NULL\n", __FUNCTION__));
   }

#if LOADHELPMGR
   if (pdi->hmodHelp)
   {
      APIRET    rc;

      rc = DosFreeModule (pdi->hmodHelp);
      assertT (rc);

#ifndef DEBUG
      rc++;          // Avoid compiler warnings
#endif

      pdi->hmodHelp = (HMODULE)NULL;
   }
#endif

   DBPRINTIF ((pDbg->bOMNIDESTROYHELPINSTANCE, "%s(): Exit\n", __FUNCTION__));

   return bSuccess;

} /* end DestroyHelpInstance */

/****************************************************************************/
/* PROCEDURE NAME : SelectItemFromHandle                                    */
/* AUTHOR         : MFR                                                     */
/* DATE WRITTEN   : 6/29/95                                                 */
/* DESCRIPTION    :                                                         */
/*                                                                          */
/*                  Control Flow:                                           */
/*                                                                          */
/* PARAMETERS:                                                              */
/*                                                                          */
/* RETURN VALUES:                                                           */
/*                                                                          */
/*--------------------------------------------------------------------------*/
/* CHANGE/MODIFICATION LOG :                                                */
/*--------------------------------------------------------------------------*/
/*                                                                          */
/****************************************************************************/
BOOL
SelectItemFromHandle (PDLGINSTANCE pdi, HWND hwnd, ULONG ulLBID, ULONG ulSelID)
{
   /*------------------------------------------------------------------------*/
   /* LOCAL VARIABLES                                                        */
   /*------------------------------------------------------------------------*/
   ULONG ulCurrent;
   SHORT sValue;
   SHORT i;

   /*------------------------------------------------------------------------*/
   /* BEGIN CODE                                                             */
   /*------------------------------------------------------------------------*/
   // initial pointer validation
   assertF (pdi);

   // get currently selected listbox entry's index
   sValue = SHORT1FROMMR (WinSendDlgItemMsg (hwnd, ulLBID, LM_QUERYSELECTION,
                                             0L,
                                             0L));

   // verify user selected listbox some value in the listbox
   if (sValue != LIT_NONE)
   {
      // Get Item Handle (currently selected ID for Tray, Form etc. )
      ulCurrent = (ULONG)WinSendDlgItemMsg (hwnd,
                                            ulLBID,
                                            LM_QUERYITEMHANDLE,
                                            MPFROMSHORT (sValue),
                                            MPVOID);

      // if current ID matches one passed-in we don't change listbox
      if (ulCurrent == ulSelID)
         return TRUE;
   }

   // Find out how many trays in the list
   sValue = (SHORT)WinSendDlgItemMsg (hwnd,
                                      ulLBID,
                                      LM_QUERYITEMCOUNT,
                                      MPVOID,
                                      MPVOID);

   for (i = 0; i < sValue; i++)
   {
      // Get Item Handle for 'i'th entry in listbox
      ulCurrent = (ULONG)WinSendDlgItemMsg (hwnd,
                                            ulLBID,
                                            LM_QUERYITEMHANDLE,
                                            MPFROMSHORT (i),
                                            MPVOID);

      // if current ID matches one passed-in we don't change listbox
      if (ulCurrent == ulSelID)
        break;  // exit loop, we found a match
   }

   // validate that we found a match
   if (i < sValue)
   {
      // match found, select it in the list provided
      WinSendDlgItemMsg (hwnd,
                         ulLBID,
                         LM_SELECTITEM,
                         MPFROMSHORT (i),
                         MPFROMLONG (TRUE));

      return TRUE;
   }

   // No match found in list provided
   return FALSE;

} /* end SelectItemFromHandle */

/****************************************************************************/
/* PROCEDURE NAME : FillResolutionList                                      */
/* AUTHOR         : MFR                                                     */
/* DATE WRITTEN   : 11/10/93 !!!!                                           */
/* DESCRIPTION    :                                                         */
/*                                                                          */
/*                  Control Flow:                                           */
/*                                                                          */
/* PARAMETERS:                                                              */
/*                                                                          */
/* RETURN VALUES:                                                           */
/*                                                                          */
/*--------------------------------------------------------------------------*/
/* CHANGE/MODIFICATION LOG :                                                */
/*--------------------------------------------------------------------------*/
/*                                                                          */
/****************************************************************************/
VOID
FillResolutionList (HWND         hwndDlg,
                    PDLGINSTANCE pdi,
                    PDEVICEINFO  pDevice,
                    ULONG        ulCurrentResID)
{
   /*------------------------------------------------------------------------*/
   /* LOCAL VARIABLES                                                        */
   /*------------------------------------------------------------------------*/
   USHORT       usNumRes;
   ULONG        ulResID;
   USHORT       us;
   SHORT        sIdx;
   USHORT       usSelectIdx = 0;
   USHORT       us2;
   USHORT       usNumDefined;
   PRESINFO     pRes;
   PSZ          pszResName  = (PSZ)NULL;
   BOOL         bMatchFound = FALSE;
#ifdef DEBUG
   PDEBUGINFO   pDbg        = &globals.DebugInfo;
#endif

   /*------------------------------------------------------------------------*/
   /* BEGIN CODE                                                             */
   /*------------------------------------------------------------------------*/
   DBPRINTIF ((pDbg->bFILLRESOLUTIONLIST, "%s(): Enter\n", __FUNCTION__));

   // initial pointer validation
   assertF (pDevice);
   assertF (pDevice->pulRES);

   // free existing list
   WinSendDlgItemMsg (hwndDlg,
                      IDD_RESOLUTIONS,
                      LM_DELETEALL,
                      MPVOID,
                      MPVOID);

   /************************************/
   /* Driver Defined Resolution        */
   /************************************/

   // get # resolutions defined for this device
   usNumRes = pDevice->usNumRes;

   // get pointer to driver's global res table
   usNumDefined = (USHORT)pdi->pDriver->ulNumRes;
   pRes         = pdi->pDriver->pRES;

   // add each resolution defined into listbox
   for (us = 0; us < usNumRes; us++)
   {
      ulResID = pDevice->pulRES[us];

      // @TBD - loop thru driver table for res ID and get name string
      // For now only driver table definitions allowed
      // loop through table of forms until matching form ID found
      for (us2 = 0; us2 < usNumDefined;  us2++)
      {
         // we found a match so set up pointers to it
         if (ulResID == pRes[us2].ulResID)
         {
            // Now we must determine if the string is in our stringtable
            // or a it is a string the user defined in res structure
            if (pRes[us2].ulNameID == RES_STRING_UNLISTED)
            {
               pszResName = pRes[us2].szResName;
            }
            else
            {
               ULONG ulIdx;

               ulIdx = pRes[us2].ulNameID - STRING_TABLE_BASE;

               assertF (globals.pbStringTable[ulIdx]);

               pszResName = globals.pbStringTable[ulIdx];
            }

            DBPRINTIF ((pDbg->bFILLRESOLUTIONLIST, "%s(): Adding Res = '%s'; ulResID = %d\n", __FUNCTION__, pszResName, ulResID));

            bMatchFound = TRUE;
            break;  // get out of loop
         }
      }

      // if we found a matching res id in driver's table
      if (bMatchFound)
      {
         // add res name string to res listbox
         sIdx = (SHORT)WinSendDlgItemMsg (hwndDlg,
                                          IDD_RESOLUTIONS,
                                          LM_INSERTITEM,
                                          MPFROM2SHORT (LIT_END, 0),
                                          MPFROMP (pszResName));

         // Set Item Handle to be the Res ID
         WinSendDlgItemMsg (hwndDlg,
                            IDD_RESOLUTIONS,
                            LM_SETITEMHANDLE,
                            MPFROMSHORT (sIdx),
                            MPFROMLONG (ulResID));

         // if current ulResID == to one stored in printer props
         // save usSelectIdx = sIdx for item selection below
         if (ulCurrentResID == ulResID)
         {
            usSelectIdx = sIdx;
         }
      }
      else
      {
         assertstring ("no res id match\n");
         DBPRINTIF ((pDbg->bFILLRESOLUTIONLIST, "FillResolutionList(): ulResID = %d has no match in table\n", ulResID));
      }

      bMatchFound = FALSE;
   }

   // @TBD - highlite index may need to check if no match found
   // what to do as default then
   WinSendDlgItemMsg (hwndDlg,
                      IDD_RESOLUTIONS,
                      LM_SELECTITEM,
                      MPFROMLONG (usSelectIdx),
                      MPFROMLONG (TRUE));

   DBPRINTIF ((pDbg->bFILLRESOLUTIONLIST, "%s(): Exit; Highlite Index = %d\n", __FUNCTION__, usSelectIdx));

   // @CONSTRAINTS
   // After filling of Resolution's combobox, we should
   // remove from it constrained items
   //
   OmniUpdateConstraints(hwndDlg, pdi, IDD_RESOLUTIONS);

} /* end FillResolutionList */

/****************************************************************************/
/* PROCEDURE NAME : FillPrintModeList                                       */
/* AUTHOR         : MFR                                                     */
/* DATE WRITTEN   : 02/22/94 !!!!                                           */
/* DESCRIPTION    :                                                         */
/*                                                                          */
/*                  Control Flow:                                           */
/*                                                                          */
/* PARAMETERS:                                                              */
/*                                                                          */
/* RETURN VALUES:                                                           */
/*                                                                          */
/*--------------------------------------------------------------------------*/
/* CHANGE/MODIFICATION LOG :                                                */
/*--------------------------------------------------------------------------*/
/*                                                                          */
/****************************************************************************/
VOID
FillPrintModeList (HWND         hwndDlg,
                   PDLGINSTANCE pdi,
                   PDEVICEINFO  pDevice,
                   ULONG        ulCurID)
{
   /*------------------------------------------------------------------------*/
   /* LOCAL VARIABLES                                                        */
   /*------------------------------------------------------------------------*/
   USHORT       usNumPrintModes;
   ULONG        ulPrintModeID;
   USHORT       us;
   SHORT        sIdx;
   USHORT       usSelectIdx         = 0;
   USHORT       us2;
   USHORT       usNumDefined;
   PPRINTMODE   pPrintModes;
   CHAR         szPrintModeName[32 + 1];
   BOOL         bMatchFound         = FALSE;
#ifdef DEBUG
   PDEBUGINFO   pDbg                = &globals.DebugInfo;
#endif

   /*------------------------------------------------------------------------*/
   /* BEGIN CODE                                                             */
   /*------------------------------------------------------------------------*/
   DBPRINTIF ((pDbg->bFILLPRINTMODELIST, "%s(): Enter\n", __FUNCTION__));

   // initial pointer validation
   assertF (pDevice);
   assertF (pDevice->pulPrintModes);

   // free existing list
   WinSendDlgItemMsg (hwndDlg,
                      IDD_DEFAULT_PRINT_MODE,
                      LM_DELETEALL,
                      MPVOID,
                      MPVOID);

   /************************************/
   /* Driver Defined Print Mode        */
   /************************************/

   // get # Print Modes defined for this device
   usNumPrintModes = pDevice->usNumPrintModes;

   // get pointer to driver's global Print Mode table
   usNumDefined = (USHORT)pdi->pDriver->ulNumPrintModes;
   pPrintModes  = pdi->pDriver->pPrintModes;

   // add each PrintMode defined into listbox
   for (us = 0; us < usNumPrintModes; us++)
   {
      ulPrintModeID = pDevice->pulPrintModes[us];

      // @TBD - loop thru driver table for PrintMode ID and get name string
      // For now only driver table definitions allowed
      // loop through table of forms until matching form ID
      // found
      for (us2 = 0; us2 < usNumDefined;  us2++)
      {
         // we found a match so set up pointers to it
         if (ulPrintModeID == pPrintModes[us2].ulPrintModeID)
         {
            // Now we must determine if the string is in our stringtable
            // or a it is a string the user defined in hcInfo structure
            if (pPrintModes[us2].ulNameID == PRINT_MODE_STRING_UNLISTED)
            {
               SafeStrNCpy (szPrintModeName,
                            pPrintModes[us2].szPrintMode,
                            sizeof (szPrintModeName));
            }
            else
            {
               ULONG ulIdx;

               ulIdx = pPrintModes[us2].ulNameID - STRING_TABLE_BASE;

               assertF (globals.pbStringTable[ulIdx]);

               SafeStrNCpy (szPrintModeName,
                            globals.pbStringTable[ulIdx],
                            sizeof (szPrintModeName));
            }

            DBPRINTIF ((pDbg->bFILLPRINTMODELIST, "%s(): Adding Print Mode = '%s'; ID = %lu\n", __FUNCTION__, szPrintModeName, ulPrintModeID));
            DBPRINTIF ((pDbg->bFILLPRINTMODELIST, "%s(): Adding Print Mode = '%s'; ID = %lu\n", __FUNCTION__, szPrintModeName, ulPrintModeID));

            bMatchFound = TRUE;
            break;  // get out of loop
         }
      }

      // if we found a matching PrintMode id in driver's table
      if (bMatchFound)
      {
         // add PrintMode name string to PrintMode listbox
         sIdx = (SHORT)WinSendDlgItemMsg (hwndDlg,
                                          IDD_DEFAULT_PRINT_MODE,
                                          LM_INSERTITEM,
                                          MPFROM2SHORT (LIT_END, 0),
                                          MPFROMP (szPrintModeName));

         // Set Item Handle to be the PrintMode ID
         WinSendDlgItemMsg (hwndDlg,
                            IDD_DEFAULT_PRINT_MODE,
                            LM_SETITEMHANDLE,
                            MPFROMSHORT (sIdx),
                            MPFROMLONG (ulPrintModeID));

         // if current ulPrintModeID == to one stored in printer props
         // save usSelectIdx = sIdx for item selection below
         if (ulCurID == ulPrintModeID)
         {
            usSelectIdx = sIdx;
         }
      }
      else
      {
         assertstring ("no print mode match\n");
         DBPRINTIF ((pDbg->bFILLPRINTMODELIST, "%s(): ulPrintModeID = %d has no match in table\n", __FUNCTION__, ulPrintModeID));
      }

      bMatchFound = FALSE;
   }

   // @TBD - highlite index may need to check if no match found
   // what to do as default then
   WinSendDlgItemMsg (hwndDlg,
                      IDD_DEFAULT_PRINT_MODE,
                      LM_SELECTITEM,
                      MPFROMLONG (usSelectIdx),
                      MPFROMLONG (TRUE));

   DBPRINTIF ((pDbg->bFILLPRINTMODELIST, "%s(): Exit; Highlite Index = %d\n", __FUNCTION__, usSelectIdx));

} /* end FillPrintModeList */

/****************************************************************************/
/* PROCEDURE NAME : SetIconInDialog                                         */
/* AUTHOR         : MFR                                                     */
/* DATE WRITTEN   : 7/28/94                                                 */
/* DESCRIPTION    :                                                         */
/*                                                                          */
/*                  Control Flow:                                           */
/*                                                                          */
/* PARAMETERS:                                                              */
/*                                                                          */
/* RETURN VALUES:                                                           */
/*                                                                          */
/*--------------------------------------------------------------------------*/
/* CHANGE/MODIFICATION LOG :                                                */
/*--------------------------------------------------------------------------*/
/*                                                                          */
/****************************************************************************/
VOID
SetIconInDialog (HWND hwndDlg, HPOINTER hptrIcon, ULONG ulIconID)
{
   /*------------------------------------------------------------------------*/
   /* LOCAL VARIABLES                                                        */
   /*------------------------------------------------------------------------*/
   HWND          hwndIcon;        // handle to Icon control
   HPS           hpsIcon;         // handle to PS for Icon
   RECTL         rclIcon;

   /*------------------------------------------------------------------------*/
   /* BEGIN CODE                                                             */
   /*------------------------------------------------------------------------*/
   // Retrieve window handle of icon to be (re)set
   hwndIcon = WinWindowFromID (hwndDlg, ulIconID);

   // Query rectangle that contains the icon to be (re)set
   WinQueryWindowRect (hwndIcon, &rclIcon);

   // Retrieve the Presentation Space for static icon window
   hpsIcon  = WinGetPS (hwndIcon);

   // Erase any previous icon's image from window as our
   // new icon may not completely cover previous one
   WinFillRect (hpsIcon, &rclIcon, SYSCLR_DIALOGBACKGROUND);

   WinSendDlgItemMsg (hwndDlg,
                      ulIconID,
                      SM_SETHANDLE,
                      MPFROMLONG (hptrIcon),
                      MPVOID);

   // release pres. space for icon since we are finished drawing
   WinReleasePS (hpsIcon);

} /* end SetIconInDialog */

VOID
ReadGammaControls (PJOBPROPERTIES pJobProps, HWND hwndColor)
{
   LONG  lOption;
   INT   iScale = 200;   // jk1115  make it more sensitive

   if (  pJobProps->ulAlgorithm == HT_VOID_CLUSTER
      || pJobProps->ulAlgorithm == HT_JANIS_STUCKI
      )  // jk1115
      iScale = 100;   // jk1115

   lOption = (LONG)WinSendDlgItemMsg (hwndColor, IDD_RED_GAMMA,
                                      SLM_QUERYSLIDERINFO,
                                      MPFROM2SHORT (SMA_SLIDERARMPOSITION,
                                                    SMA_INCREMENTVALUE),
                                      MPVOID);

   //pJobProps->lRedAdjust = -((lOption-MAX_DEVIATION)*200/100);  // jk1115
   pJobProps->lRedAdjust = -((lOption-MAX_DEVIATION)*iScale/100); // jk1115

   lOption = (LONG)WinSendDlgItemMsg (hwndColor, IDD_GREEN_GAMMA,
                                      SLM_QUERYSLIDERINFO,
                                      MPFROM2SHORT (SMA_SLIDERARMPOSITION,
                                                    SMA_INCREMENTVALUE),
                                      MPVOID);

   //pJobProps->lGreenAdjust = -((lOption-MAX_DEVIATION)*200/100);   // jk1115
   pJobProps->lGreenAdjust = -((lOption-MAX_DEVIATION)*iScale/100);  // jk1115

   lOption = (LONG)WinSendDlgItemMsg (hwndColor, IDD_BLUE_GAMMA,
                                      SLM_QUERYSLIDERINFO,
                                      MPFROM2SHORT (SMA_SLIDERARMPOSITION,
                                                    SMA_INCREMENTVALUE),
                                      MPVOID);

   //pJobProps->lBlueAdjust =  -((lOption-MAX_DEVIATION)*200/100);   // jk1115
   pJobProps->lBlueAdjust =  -((lOption-MAX_DEVIATION)*iScale/100);  // jk1115

   lOption = (LONG)WinSendDlgItemMsg (hwndColor, IDD_BLACK_GAMMA,
                                     SLM_QUERYSLIDERINFO,
                                     MPFROM2SHORT (SMA_SLIDERARMPOSITION,
                                                   SMA_INCREMENTVALUE),
                                     MPVOID);

   //pJobProps->sBlackAdjust = -((lOption-MAX_DEVIATION)*200/100);  // jk1115
   pJobProps->sBlackAdjust = -((lOption-MAX_DEVIATION)*iScale/100); // jk1115
}

/****************************************************************************/
/* PROCEDURE NAME : InitHalftoneAlgorithmsList                              */
/* AUTHOR         :                                                         */
/* DATE WRITTEN   : 11/19/99                                                */
/* DESCRIPTION    : Code for this function was extracted from               */
/*                  InitCommonJobProps() function by Georgs Popelis         */
/*                  to add 5(or 6) color-components support by devices.     */
/*                  Control Flow:                                           */
/*                                                                          */
/* PARAMETERS:                                                              */
/*                                                                          */
/* RETURN VALUES:                                                           */
/*                                                                          */
/*--------------------------------------------------------------------------*/
/* CHANGE/MODIFICATION LOG :                                                */
/*--------------------------------------------------------------------------*/
/*                  5(or 6) color-components support by devices:            */
/*                  If device supports 5(or 6) color-components it has one  */
/*                  of following Print Modes:                               */
/*                  24-Bit Black and 6-Colors Print Mode (ID #63)           */
/*                  24-Bit and 6-Colors Print Mode (ID #64)                 */
/*                  24-Bit Black and 5-Colors Print Mode (ID #53)           */
/*                  24-Bit and 5-Colors Print Mode (ID #54)                 */
/*                  (IDs for Print Modes usually are defined in codes       */
/*                   for devices, so they are hardcoded here)               */
/*                  According to user selected Print Mode, Color Dither list*/
/*                  is reinitialised to corresponding Color Dither method:  */
/*                  -Stucki Diffusion 5 Color, (last but one)               */
/*                  -Stucki Diffusion 6 Color  (last from available list).  */
/*                  For devices that don't support 5/6 color-components two */
/*                  last Color Dithers are not added to Colors Dither list. */
/****************************************************************************/
BOOL
InitHalftoneAlgorithmsList (HWND           hwnd,
                           PDLGINSTANCE   pdi,
                           PDEVICEINFO    pDevice,
                           PJOBPROPERTIES pJobProps)
{
   /*------------------------------------------------------------------------*/
   /* LOCAL VARIABLES                                                        */
   /*------------------------------------------------------------------------*/
   ULONG     ul, ulFirst, ulLast;
   ULONG     ulIdx;
   ULONG     ulDitherID;
   SHORT     sIdx;
   SHORT     sMatchIdx   = 0;
   
   /*------------------------------------------------------------------------*/
   /* BEGIN CODE                                                             */
   /*------------------------------------------------------------------------*/

   // in stringtable lets get a base index to reference from
   ulIdx = STRING_TABLE_DLG_BASE - STRING_TABLE_BASE;

   //-------------------------------------
   // Init HALFTONE ALGORITHMS
   //-------------------------------------

   // free Halftone Algorithm list
   WinSendDlgItemMsg (hwnd, IDD_ALGORITHMS,
                      LM_DELETEALL, MPVOID, MPVOID);

   if (pDevice->ulOmniDeviceTechnology & OMNI_CAP_COLOR)
   {
      ulDitherID = pJobProps->ulAlgorithm;

      // @MAGIC
      if (ulDitherID == HT_LEVEL)
      {
         ulDitherID = HT_MAGIC_SQUARES;
      }

      DBPRINTIF ((TRUE, "%s(): usDitherID = %lu\n", __FUNCTION__, ulDitherID));

      ulFirst = 0;
      
      if (pDevice->ulOmniDeviceTechnology & OMNI_CAP_ADDITIONAL_DITHER)
         ulLast = OMNI_DEFINED_DITHERS-1;
      else
         ulLast = OMNI_DEFINED_DITHERS-3;
      
      // insert Halftone Algorithm list and hilight selected algorithm
      for (ul = ulFirst; ul <= ulLast; ul++)
      {
         ulIdx = OMNI_DITHERS[ul].ulDitherNameID - STRING_TABLE_BASE;
         assertF (globals.pbStringTable[ulIdx]);


         sIdx = (SHORT)WinSendDlgItemMsg (hwnd,
                                          IDD_ALGORITHMS,
                                          LM_INSERTITEM,
                                          MPFROM2SHORT (LIT_END, 0),
                                          MPFROMP (globals.pbStringTable[ulIdx]));

         WinSendDlgItemMsg (hwnd,
                            IDD_ALGORITHMS,
                            LM_SETITEMHANDLE,
                            MPFROMSHORT (sIdx),
                            MPFROMLONG (OMNI_DITHERS[ul].ulDitherID));

         if (ulDitherID == OMNI_DITHERS[ul].ulDitherID)         // hilight selected option
         {
            sMatchIdx = sIdx;
         }
      }

      WinSendDlgItemMsg (hwnd,
                         IDD_ALGORITHMS,
                         LM_SELECTITEM,
                         MPFROMSHORT (sMatchIdx),
                         MPFROMLONG (TRUE));

      // @CONSTRAINTS
      // After filling of Dither's combobox, we should
      // remove from it constrained items
      OmniUpdateConstraints(hwnd, pdi, IDD_ALGORITHMS);

   }
   else
   {
      sIdx = (SHORT)WinSendDlgItemMsg (hwnd,
                                       IDD_ALGORITHMS,
                                       LM_INSERTITEM,
                                       MPFROM2SHORT (LIT_END, 0),
                                       MPFROMP (globals.pbStringTable[ulIdx + DIALOG_NONE_AVAILABLE]));

      WinSendDlgItemMsg (hwnd,
                         IDD_ALGORITHMS,
                         LM_SELECTITEM,
                         MPFROMLONG (sIdx),
                         MPFROMLONG (TRUE));


      WinEnableWindow (WinWindowFromID (hwnd, IDD_ALGORITHMS), FALSE);
      WinEnableWindow (WinWindowFromID (hwnd, IDT_ALGORITHMS), FALSE);
   }
   return TRUE;
}

/****************************************************************************/
/*==========================================================================*/
/* WM_INITDLG functions                                                     */
/*==========================================================================*/
/*                                                                          */
/* The functions in this section of DLG.C are used to initialize            */
/* the dialog controls on a specific Job or Printer Properties Notebook     */
/* page.  They are called again when the user selects "Undo" or the         */
/* "Defaults" button for that page to reset the controls to new values.     */
/*                                                                          */
/* The functions appear in the order they appear in their respective        */
/* notebooks.                                                               */
/*                                                                          */
/****************************************************************************/


/****************************************************************************/
/* PROCEDURE NAME : InitCommonJobProps                                      */
/* AUTHOR         : MFR                                                     */
/* DATE WRITTEN   : 12/26/95                                                */
/* DESCRIPTION    : Initialize all dialog controls on the "Common"          */
/*                  page in the Job Properties Notebook based to values     */
/*                  that reflect the JOBPROPERTIES data passed in.          */
/*                                                                          */
/* PARAMETERS:                                                              */
/*                                                                          */
/* RETURN VALUES:                                                           */
/*                                                                          */
/*--------------------------------------------------------------------------*/
/* CHANGE/MODIFICATION LOG :                                                */
/*--------------------------------------------------------------------------*/
/* @EXJOB  - 07/13/98 - UCC [IBMJ]- Expansible job data support             */
/* @JPN2H99- 09/01/99 - UCC [IBMJ]- Duplex option control by prn properties */
/*                                                                          */
/****************************************************************************/
BOOL
InitCommonJobProps (HWND           hwnd,
                    PDLGINSTANCE   pdi,
                    PDEVICEINFO    pDevice,
                    PJOBPROPERTIES pJobProps,
                    BOOL           bUseNonMetric)
{
   /*------------------------------------------------------------------------*/
   /* LOCAL VARIABLES                                                        */
   /*------------------------------------------------------------------------*/
   ULONG     ul;
   ULONG     ulIdx;
   HPOINTER  hptrOrient;
   HPOINTER  hptrDuplex;
   SHORT     sIdx;
   HWND      hwndSpin;                
   PPRNPROPERTIES pPrnProp = &pdi->PrnProperties; //@JPN2H99


   /*------------------------------------------------------------------------*/
   /* BEGIN CODE                                                             */
   /*------------------------------------------------------------------------*/
   // We are going to fill in a lot of strings from a similar location
   // in stringtable so lets get a base index to reference from
   ulIdx = STRING_TABLE_DLG_BASE - STRING_TABLE_BASE;

   // Fill all Listboxes on this notebook page
   
   FillPrintModeList (hwnd, pdi, pDevice, pJobProps->ulDefPrintModeID);

   FillResolutionList (hwnd, pdi, pDevice, pJobProps->ulDefResID);

   if (bUseNonMetric)
      FillConnectionList (hwnd, pdi, pDevice, IDD_DEFAULT_FORM,
                          pJobProps->ulDefNonMetricConnID);
   else
      FillConnectionList (hwnd, pdi, pDevice, IDD_DEFAULT_FORM,
                          pJobProps->ulDefConnID );

   if ( (pDevice->usNumFonts > 0)
      &&!(pPrnProp->fOmniOptions & OMNI_OPTION_DEVICEFONT_OFF)  //@JPN2H99
      )
   {
      FillFontList (hwnd, pdi, pDevice, IDD_DEFAULT_FONT);
   }
   else
   {
      sIdx = (SHORT)WinSendDlgItemMsg (hwnd,
                                       IDD_DEFAULT_FONT,
                                       LM_INSERTITEM,
                                       MPFROM2SHORT (LIT_END, 0),
                                       MPFROMP (globals.pbStringTable[ulIdx + DIALOG_NONE_AVAILABLE]));

      WinSendDlgItemMsg (hwnd,
                         IDD_DEFAULT_FONT,
                         LM_SELECTITEM,
                         MPFROMLONG (sIdx),
                         MPFROMLONG (TRUE));

      WinEnableControl (hwnd, IDD_DEFAULT_FONT, FALSE);
      WinEnableControl (hwnd, IDT_DEFAULT_FONT, FALSE);
   }

   // Assume portrait (since is most common selection, also error case)
   // will change to landscape below if selected:
   ul = IDC_PORTRAIT;
   hptrOrient = pdi->hptrPortrait;    // @94817

   // Set orientation (portrait or landscape)
   if (pJobProps->ulOrientation == ORIENTATION_LANDSCAPE)
   {
      ul = IDC_LANDSCAPE;
      hptrOrient = pdi->hptrLandscape;   // @94817
   }

   // @EXJOB
   DBPRINTIF ((FALSE, "%s(): INIT_DLG; Orientation = %lu", __FUNCTION__, pdi->pJobProperties->ulOrientation));

   // @94817 - change handle of orientation icon from default
   SetIconInDialog (hwnd, hptrOrient, IDI_ORIENTATION);

   WinSendDlgItemMsg (hwnd,
                      IDI_ORIENTATION,
                      SM_SETHANDLE,
                      MPFROMLONG (hptrOrient),
                      MPVOID);

   WinCheckButton (hwnd, ul, TRUE);

   // @JPN2H99
   // Check to see if current device has Duplex support
   if ( (pDevice->ulOmniDeviceTechnology & OMNI_CAP_DUPLEX)
      ||(pPrnProp->fOmniOptions & OMNI_OPTION_DUPLEX_BOTH)
      )
   {
      if ( (pDevice->ulOmniDeviceTechnology & OMNI_CAP_DUPLEX_BOOK)
         ||(pPrnProp->fOmniOptions & OMNI_OPTION_DUPLEX_BOOK)
         )
         WinEnableControl (hwnd, IDR_DUPLEX_BOOK, TRUE);
      else
         WinEnableControl (hwnd, IDR_DUPLEX_BOOK, FALSE);

      if ( (pDevice->ulOmniDeviceTechnology & OMNI_CAP_DUPLEX_FLIP)
         ||(pPrnProp->fOmniOptions & OMNI_OPTION_DUPLEX_FLIP)
         )
         WinEnableControl (hwnd, IDR_DUPLEX_FLIP, TRUE);
      else
         WinEnableControl (hwnd, IDR_DUPLEX_FLIP, FALSE);

      // Set Duplex state based upon job properties
      if (pJobProps->ulDuplexOptions == DUPLEX_NONE)
      {
         ul = IDR_DUPLEX_ONE;
         hptrDuplex = pdi->hptrDuplexOne;
      }
      else
      {
         if (pJobProps->ulDuplexOptions == DUPLEX_BOOK)
         {
            ul = IDR_DUPLEX_BOOK;
            hptrDuplex = pdi->hptrDuplexBook;
         }
         else
         {
           if (pJobProps->ulDuplexOptions == DUPLEX_FLIP)
           {
              ul = IDR_DUPLEX_FLIP;
              hptrDuplex = pdi->hptrDuplexFlip;
           }
           else
           {
              ul = IDR_DUPLEX_ONE;
              hptrDuplex = pdi->hptrDuplexOne;
           }
         }
      }
   }
   else
   {
      // default to single-sided
      ul = IDR_DUPLEX_ONE;
      hptrDuplex = pdi->hptrDuplexOne;

      // disable duplexing radio buttons
      WinEnableControl (hwnd, IDR_DUPLEX_BOOK, FALSE);
      WinEnableControl (hwnd, IDR_DUPLEX_FLIP, FALSE);
   }

   // Change handle of duplex icon from default
   SetIconInDialog (hwnd, hptrDuplex, IDI_DUPLEX);

   WinSendDlgItemMsg (hwnd,
                      IDI_DUPLEX,
                      SM_SETHANDLE,
                      MPFROMLONG (hptrDuplex),
                      MPVOID);

   WinCheckButton (hwnd, ul, TRUE);

   /*-------------------------*/
   /* FF Control              */
   /*-------------------------*/
   if (pJobProps->bFFControlType == FF_CTL_CONDITIONAL)
   {
      ul = IDR_FF_CONDITIONAL;
   }
   else
   {
      if (pJobProps->bFFControlType == FF_CTL_NONE)
      {
         ul = IDR_FF_NONE;
      }
      else
      {
         if (pJobProps->bFFControlType == FF_CTL_COMPULSORY)
         {
            ul = IDR_FF_COMPULSORY;
         }
         else
         {
            DBPRINTF (("Invalid FF Control: defaulting to Conditional!!!\n"));
            ul = IDR_FF_CONDITIONAL;
         }
      }
   }

   WinCheckButton (hwnd, ul, TRUE);

   /*-------------------------*/
   /* Mirror Image            */
   /*-------------------------*/
   if (pDevice->ulOmniDeviceTechnology & OMNI_CAP_MIRROR)
   {
      // Enable "Mirror Image" until we set checkstate
      WinEnableControl (hwnd, IDD_MIRROR, TRUE);

      // set "Mirror Image" option checkstate
      if (pJobProps->ulImageoption & IMAGE_OPTION_MIRROR)
         WinCheckButton (hwnd, IDD_MIRROR, 1);
      else
         WinCheckButton (hwnd, IDD_MIRROR, 0);

      // "Mirror Image" does not work in landscape so disable control
      if (pJobProps->ulOrientation == ORIENTATION_LANDSCAPE)
      {
         WinEnableControl (hwnd, IDD_MIRROR, FALSE);
      }
   }
   else
   {
      WinEnableControl (hwnd, IDD_MIRROR, FALSE);
   }

   //-------------------------------------
   // Init HALFTONE ALGORITHMS
   //-------------------------------------
   InitHalftoneAlgorithmsList (hwnd, pdi, pDevice, pJobProps);

   //***************************
   
   //***************************
   hwndSpin = WinWindowFromID( hwnd, IDD_COPIES_NUMBER );

   WinSendMsg( hwndSpin, SPBM_SETLIMITS, (MPARAM)MAX_UNCOLLATEDCOPIES, (MPARAM)1 );

   WinSendMsg( hwndSpin, SPBM_SETCURRENTVALUE, (MPARAM)pJobProps->ulCopies, 0 );

   WinSetFocus( hwnd, hwndSpin );

   //********************************************
   
   //********************************************
   if (pDevice->ulOmniDeviceTechnology & OMNI_CAP_COLLATE_PLUGIN_UI) //@HWCOLLATE
      WinEnableControl (hwnd, IDD_COLLATE, FALSE);                   //@HWCOLLATE
   else                                                              //@HWCOLLATE
      WinSendDlgItemMsg( hwnd, IDD_COLLATE, BM_SETCHECK,
         (MPARAM)(pJobProps->ulImageoption & IMAGE_OPTION_COLLATE), NULL );
   
   return TRUE;

} /* end InitCommonJobProps */

/****************************************************************************/
/* PROCEDURE NAME : InitMonoJobProps                                        */
/* AUTHOR         : Matt Rutkowski                                          */
/* DATE WRITTEN   : 12/26/95                                                */
/* DESCRIPTION    : Initialize all dialog controls on the "Monochrome"      */
/*                  page in the Job Properties Notebook based to values     */
/*                  that reflect the JOBPROPERTIES data passed in.          */
/*                                                                          */
/* PARAMETERS:                                                              */
/*                                                                          */
/* RETURN VALUES:                                                           */
/*                                                                          */
/*--------------------------------------------------------------------------*/
/* CHANGE/MODIFICATION LOG :                                                */
/*--------------------------------------------------------------------------*/
/*                                                                          */
/****************************************************************************/
BOOL
InitMonoJobProps (HWND hwnd, PDLGINSTANCE pdi, PJOBPROPERTIES pJobProps)
{
   /*------------------------------------------------------------------------*/
   /* LOCAL VARIABLES                                                        */
   /*------------------------------------------------------------------------*/
   ULONG  ulIdx;
   SHORT  sIdx;
   SHORT  sTick;
   CHAR   szSlider[128];

   /*------------------------------------------------------------------------*/
   /* BEGIN CODE                                                             */
   /*------------------------------------------------------------------------*/
   // Set all Ticks to a small size
   WinSendDlgItemMsg (hwnd, IDD_DARKNESS, SLM_SETTICKSIZE,
                      MPFROM2SHORT (SMA_SETALLTICKS, SMALL_TICKSIZE),
                      MPVOID);

   // Set Slider Initial Position to Job Property setting
   WinSendDlgItemMsg (hwnd, IDD_DARKNESS, SLM_SETSLIDERINFO,
                      MPFROM2SHORT (SMA_SLIDERARMPOSITION, SMA_INCREMENTVALUE),
                      MPFROMSHORT (MAX_DEVIATION+(pJobProps->lDarkness)));

   //-------------------------------------
   // LARGE TICKS
   //-------------------------------------
   for (sTick = MIN_DEVIATION; sTick <= MAX_DEVIATION; sTick += LARGE_TICKSPACE)
   {
      WinSendDlgItemMsg (hwnd, IDD_DARKNESS, SLM_SETTICKSIZE,
                         MPFROM2SHORT (sTick+MAX_DEVIATION, LARGE_TICKSIZE),
                         MPVOID);
   }

   // Set Tick Text (e.g. -50, 0, +50)
   for (sTick = MIN_DEVIATION; sTick <= MAX_DEVIATION; sTick += MAX_DEVIATION)
   {
      sprintf (szSlider, "%+d", sTick);  // @97254 - changed from _itoa - mfr

      WinSendDlgItemMsg (hwnd,
                         IDD_DARKNESS,
                         SLM_SETSCALETEXT,
                         MPFROMSHORT (sTick+MAX_DEVIATION),
                         MPFROMP (szSlider));
   }

   WinEnableControl (hwnd, IDD_DARKNESS, TRUE);

   DBPRINTIF ((TRUE, "%s(): Omni Device Tech = %x\n", __FUNCTION__, pdi->pDevice->ulOmniDeviceTechnology));

   // Has color capability but in monochrome mode,
   // therefore, allow foreground and background colors

   if (pdi->pDevice->ulOmniDeviceTechnology & OMNI_CAP_COLOR    &&
       (pdi->pDevice->ulOmniDeviceTechnology & OMNI_CAP_FGCOLOR) )
   {
      ULONG ul;

      // free Foreground Color list
      WinSendDlgItemMsg (hwnd,
                         IDD_FOREGROUND,
                         LM_DELETEALL,
                         MPVOID,
                         MPVOID);

      // insert Foregound list and hilight selected foregound color
      for (ul = STRING_TABLE_CLR_BASE; ul <= STRING_TABLE_CLR_BASE + 7; ul++)
      {
         ulIdx = ul - (LONG)STRING_TABLE_BASE;
         assertF (globals.pbStringTable[ulIdx]);

         sIdx = (SHORT)WinSendDlgItemMsg (hwnd,
                                          IDD_FOREGROUND,
                                          LM_INSERTITEM,
                                          MPFROM2SHORT (LIT_END, 0),
                                          MPFROMP (globals.pbStringTable[ulIdx]));

         ulIdx = ul - (ULONG)(STRING_TABLE_CLR_BASE);

         WinSendDlgItemMsg (hwnd,
                            IDD_FOREGROUND,
                            LM_SETITEMHANDLE,
                            MPFROMSHORT (sIdx),
                            MPFROMLONG (ulIdx));

         if (pJobProps->usForeground == ulIdx)
         {
            WinSendDlgItemMsg (hwnd,
                               IDD_FOREGROUND,
                               LM_SELECTITEM,
                               MPFROMSHORT (sIdx),
                               MPFROMLONG (TRUE));
         }
      }

      // free existing Background Color list
      WinSendDlgItemMsg (hwnd,
                         IDD_BACKGROUND,
                         LM_DELETEALL,
                         MPVOID,
                         MPVOID);

      for (ul = STRING_TABLE_CLR_BASE; ul <= STRING_TABLE_CLR_BASE + COLOR_WHITE; ul++)
      {
         ulIdx = ul - (LONG)STRING_TABLE_BASE;
         assertF (globals.pbStringTable[ulIdx]);

         sIdx = (SHORT)WinSendDlgItemMsg (hwnd,
                                          IDD_BACKGROUND,
                                          LM_INSERTITEM,
                                          MPFROM2SHORT (LIT_END, 0),
                                          MPFROMP (globals.pbStringTable[ulIdx]));

         ulIdx = ul - (ULONG)(STRING_TABLE_CLR_BASE);

         WinSendDlgItemMsg (hwnd,
                            IDD_BACKGROUND,
                            LM_SETITEMHANDLE,
                            MPFROMSHORT (sIdx),
                            MPFROMLONG (ulIdx));

         if (pJobProps->usBackground == ulIdx)
         {
            WinSendDlgItemMsg (hwnd,
                               IDD_BACKGROUND,
                               LM_SELECTITEM,
                               MPFROMSHORT (sIdx),
                               MPFROMLONG (TRUE));
         }
      }
   }
   else
   {
      ulIdx = STRING_TABLE_CLR_BASE - STRING_TABLE_BASE;

      sIdx = (SHORT)WinSendDlgItemMsg (hwnd,
                                IDD_FOREGROUND,
                                LM_INSERTITEM,
                                MPFROM2SHORT (LIT_END, 0),
                                MPFROMP (globals.pbStringTable[ulIdx + COLOR_BLACK]));

      WinSendDlgItemMsg (hwnd,
                         IDD_FOREGROUND,
                         LM_SELECTITEM,
                         MPFROMLONG (sIdx),
                         MPFROMLONG (TRUE));

      sIdx = (SHORT)WinSendDlgItemMsg (hwnd,
                                IDD_BACKGROUND,
                                LM_INSERTITEM,
                                MPFROM2SHORT (LIT_END, 0),
                                MPFROMP (globals.pbStringTable[ulIdx + COLOR_WHITE]));

      WinSendDlgItemMsg (hwnd,
                         IDD_BACKGROUND,
                         LM_SELECTITEM,
                         MPFROMLONG (sIdx),
                         MPFROMLONG (TRUE));

      WinEnableControl (hwnd, IDD_FOREGROUND, FALSE);
      WinEnableControl (hwnd, IDD_BACKGROUND, FALSE);
   }

   return TRUE;

} /* end InitMonoJobProps */

/****************************************************************************/
/* PROCEDURE NAME : InitColorJobProps                                       */
/* AUTHOR         : Matt Rutkowski                                          */
/* DATE WRITTEN   : 12/26/95                                                */
/* DESCRIPTION    : Initialize all dialog controls on the "Color"           */
/*                  page in the Job Properties Notebook based to values     */
/*                  that reflect the JOBPROPERTIES data passed in.          */
/*                                                                          */
/* PARAMETERS:                                                              */
/*                                                                          */
/* RETURN VALUES:                                                           */
/*                                                                          */
/*--------------------------------------------------------------------------*/
/* CHANGE/MODIFICATION LOG :                                                */
/*--------------------------------------------------------------------------*/
/*                                                                          */
/****************************************************************************/
BOOL
InitColorJobProps (HWND hwnd, PDLGINSTANCE pdi, PJOBPROPERTIES pJobProps)
{
   /*------------------------------------------------------------------------*/
   /* LOCAL VARIABLES                                                        */
   /*------------------------------------------------------------------------*/

   /*------------------------------------------------------------------------*/
   /* BEGIN CODE                                                             */
   /*------------------------------------------------------------------------*/

   //-------------------------------------
   // Initialize Bias Spin Buttons
   //-------------------------------------
   WinSendDlgItemMsg (hwnd, IDD_CLR_BIAS_RED,
                      SPBM_SETTEXTLIMIT,
                      (MPARAM) 3, MPVOID);

   WinSendDlgItemMsg (hwnd, IDD_CLR_BIAS_RED,
                      SPBM_SETLIMITS,
                      (MPARAM) (MAX_RGB_VALUE) ,
                      (MPARAM) (LONG)(-MAX_RGB_VALUE));

   WinSendDlgItemMsg (hwnd, IDD_CLR_BIAS_GREEN,
                      SPBM_SETTEXTLIMIT,
                      (MPARAM) 3, MPVOID);

   WinSendDlgItemMsg (hwnd, IDD_CLR_BIAS_GREEN,
                      SPBM_SETLIMITS,
                      (MPARAM) (MAX_RGB_VALUE),
                      (MPARAM) (LONG)(-MAX_RGB_VALUE));

   WinSendDlgItemMsg (hwnd, IDD_CLR_BIAS_BLUE,
                      SPBM_SETTEXTLIMIT,
                      (MPARAM) 3, MPVOID);

   WinSendDlgItemMsg (hwnd, IDD_CLR_BIAS_BLUE,
                      SPBM_SETLIMITS,
                      (MPARAM) (MAX_RGB_VALUE),
                      (MPARAM) (LONG)(-MAX_RGB_VALUE));

   WinSendDlgItemMsg (hwnd, IDD_CLR_BIAS_BLACK,
                      SPBM_SETTEXTLIMIT,
                      (MPARAM) 3, MPVOID);

   WinSendDlgItemMsg (hwnd, IDD_CLR_BIAS_BLACK,
                      SPBM_SETLIMITS,
                      (MPARAM) (MAX_RGB_VALUE),
                      (MPARAM) (LONG)(-MAX_RGB_VALUE));

   // It is only partially valid to replace ulBias when it is
   // zero since it would be zero the first time through.  Otherwise
   // zero could not be reached if pRes->ulBias was not zero;
   // Therefore to provide a  workaround, such as an entry of
   // 255 will set ulBias to zero for the one pass could be implemented.
   // For now, if pRes ulBias is not zero then then JobProps cannot be either.

   WinSendDlgItemMsg (hwnd, IDD_CLR_BIAS_RED,
                      SPBM_SETCURRENTVALUE,
                      MPFROMLONG (pJobProps->lRedBias),
                      MPVOID);

   WinSendDlgItemMsg (hwnd, IDD_CLR_BIAS_GREEN,
                      SPBM_SETCURRENTVALUE,
                      MPFROMLONG (pJobProps->lGreenBias),
                      MPVOID);

   WinSendDlgItemMsg (hwnd, IDD_CLR_BIAS_BLUE,
                      SPBM_SETCURRENTVALUE,
                      MPFROMLONG (pJobProps->lBlueBias),
                      MPVOID);

   WinSendDlgItemMsg (hwnd, IDD_CLR_BIAS_BLACK,
                      SPBM_SETCURRENTVALUE,
                      MPFROMLONG (pJobProps->bBlackBias),
                      MPVOID);

   return TRUE;

} /* end InitColorJobProps */

/****************************************************************************/
/* PROCEDURE NAME : InitGammaSliders                                        */
/* AUTHOR         : Matt Rutkowski                                          */
/* DATE WRITTEN   : 12/26/95                                                */
/* DESCRIPTION    : Initialize all dialog controls on the "Color"           */
/*                  page in the Job Properties Notebook based to values     */
/*                  that reflect the JOBPROPERTIES data passed in.          */
/*                                                                          */
/*                  NOTE: This procedure affects on the "Gamma" dialog      */
/*                        controls on the "Color" notebook page.            */
/*                                                                          */
/* PARAMETERS:                                                              */
/*                                                                          */
/* RETURN VALUES:                                                           */
/*                                                                          */
/*--------------------------------------------------------------------------*/
/* CHANGE/MODIFICATION LOG :                                                */
/*--------------------------------------------------------------------------*/
/* jk1115  November 1998 For new dithering methods set more sensitive       */
/* gamma sliders                                                            */
/*                                                                          */
/****************************************************************************/
BOOL
InitGammaSliders (HWND hwnd, PDLGINSTANCE pdi, PJOBPROPERTIES pJobProps)
{
   /*------------------------------------------------------------------------*/
   /* LOCAL VARIABLES                                                        */
   /*------------------------------------------------------------------------*/
   SHORT sTick;
   CHAR  szSlider[10];
   LONG  lPerc;

   /*------------------------------------------------------------------------*/
   /* BEGIN CODE                                                             */
   /*------------------------------------------------------------------------*/

   //-------------------------------------
   // SMALL TICKS
   //-------------------------------------
   WinSendDlgItemMsg (hwnd, IDD_RED_GAMMA,    SLM_SETTICKSIZE, MPFROM2SHORT(SMA_SETALLTICKS, SMALL_TICKSIZE), MPVOID);
   WinSendDlgItemMsg (hwnd, IDD_GREEN_GAMMA,  SLM_SETTICKSIZE, MPFROM2SHORT(SMA_SETALLTICKS, SMALL_TICKSIZE), MPVOID);
   WinSendDlgItemMsg (hwnd, IDD_BLUE_GAMMA,   SLM_SETTICKSIZE, MPFROM2SHORT(SMA_SETALLTICKS, SMALL_TICKSIZE), MPVOID);
   WinSendDlgItemMsg (hwnd, IDD_BLACK_GAMMA,  SLM_SETTICKSIZE, MPFROM2SHORT(SMA_SETALLTICKS, SMALL_TICKSIZE), MPVOID);

   //-------------------------------------
   // LARGE TICKS
   //-------------------------------------
   for (sTick = MIN_DEVIATION; sTick <= MAX_DEVIATION; sTick += LARGE_TICKSPACE)
   {
      WinSendDlgItemMsg (hwnd, IDD_RED_GAMMA,   SLM_SETTICKSIZE, MPFROM2SHORT((sTick+MAX_DEVIATION), LARGE_TICKSIZE), MPVOID);
      WinSendDlgItemMsg (hwnd, IDD_GREEN_GAMMA, SLM_SETTICKSIZE, MPFROM2SHORT((sTick+MAX_DEVIATION), LARGE_TICKSIZE), MPVOID);
      WinSendDlgItemMsg (hwnd, IDD_BLUE_GAMMA,  SLM_SETTICKSIZE, MPFROM2SHORT((sTick+MAX_DEVIATION), LARGE_TICKSIZE), MPVOID);
      WinSendDlgItemMsg (hwnd, IDD_BLACK_GAMMA, SLM_SETTICKSIZE, MPFROM2SHORT((sTick+MAX_DEVIATION), LARGE_TICKSIZE), MPVOID);
   }

   //-------------------------------------
   // INITIAL SLIDER POSITION
   //-------------------------------------
   {
    INT iScale = 200;   // jk1115  make it more sensitive
    if (  pJobProps->ulAlgorithm == HT_VOID_CLUSTER
       || pJobProps->ulAlgorithm == HT_JANIS_STUCKI
       )  // jk1115
       iScale = 100;   // jk1115

    //lPerc = (100*pJobProps->lRedAdjust) / 200;    // jk1115
    lPerc = (100*pJobProps->lRedAdjust) / iScale;   // jk1115
    WinSendDlgItemMsg (hwnd, IDD_RED_GAMMA,   SLM_SETSLIDERINFO, MPFROM2SHORT(SMA_SLIDERARMPOSITION, SMA_INCREMENTVALUE), MPFROMSHORT ((-lPerc)+MAX_DEVIATION));

    //lPerc = (100*pJobProps->lGreenAdjust) / 200;  // jk1115
    lPerc = (100*pJobProps->lGreenAdjust) / iScale; // jk1115
    WinSendDlgItemMsg (hwnd, IDD_GREEN_GAMMA, SLM_SETSLIDERINFO, MPFROM2SHORT(SMA_SLIDERARMPOSITION, SMA_INCREMENTVALUE), MPFROMSHORT ((-lPerc)+MAX_DEVIATION));

    //lPerc = (100*pJobProps->lBlueAdjust) / 200;   // jk1115
    lPerc = (100*pJobProps->lBlueAdjust) / iScale;  // jk1115
    WinSendDlgItemMsg (hwnd, IDD_BLUE_GAMMA,  SLM_SETSLIDERINFO, MPFROM2SHORT(SMA_SLIDERARMPOSITION, SMA_INCREMENTVALUE), MPFROMSHORT ((-lPerc)+MAX_DEVIATION));

    //lPerc = (100*pJobProps->sBlackAdjust) / 200;  // jk1115
    lPerc = (100*pJobProps->sBlackAdjust) / iScale; // jk1115
    WinSendDlgItemMsg (hwnd, IDD_BLACK_GAMMA, SLM_SETSLIDERINFO, MPFROM2SHORT(SMA_SLIDERARMPOSITION, SMA_INCREMENTVALUE), MPFROMSHORT ((-lPerc)+MAX_DEVIATION));
   }

   //-------------------------------------
   // TICK TEXT
   //-------------------------------------

   // Set Tick Text (e.g. -200, 0, +200)
   for (sTick = MIN_DEVIATION ; sTick <= MAX_DEVIATION; sTick += MAX_DEVIATION)
   {
      sprintf (szSlider, "%+d%%", sTick);

      WinSendDlgItemMsg (hwnd,
                         IDD_RED_GAMMA,
                         SLM_SETSCALETEXT,
                         MPFROMSHORT(sTick+MAX_DEVIATION),
                         MPFROMP (szSlider));

      WinSendDlgItemMsg (hwnd,
                         IDD_GREEN_GAMMA,
                         SLM_SETSCALETEXT,
                         MPFROMSHORT(sTick+MAX_DEVIATION),
                         MPFROMP (szSlider));

      WinSendDlgItemMsg (hwnd,
                         IDD_BLUE_GAMMA,
                         SLM_SETSCALETEXT,
                         MPFROMSHORT (sTick+MAX_DEVIATION),
                         MPFROMP (szSlider));

      WinSendDlgItemMsg (hwnd,
                         IDD_BLACK_GAMMA,
                         SLM_SETSCALETEXT,
                         MPFROMSHORT (sTick+MAX_DEVIATION),
                         MPFROMP (szSlider));
   }

   return TRUE;

} /* end InitGammaSliders */

/****************************************************************************/
/* PROCEDURE NAME : InitHSVJobProps                                         */
/* AUTHOR         : Matt Rutkowski                                          */
/* DATE WRITTEN   : 12/26/95                                                */
/* DESCRIPTION    : Initialize all dialog controls on the "HSV"             */
/*                  page in the Job Properties Notebook based to values     */
/*                  that reflect the JOBPROPERTIES data passed in.          */
/*                                                                          */
/* PARAMETERS:                                                              */
/*                                                                          */
/* RETURN VALUES:                                                           */
/*                                                                          */
/*--------------------------------------------------------------------------*/
/* CHANGE/MODIFICATION LOG :                                                */
/*--------------------------------------------------------------------------*/
/*                                                                          */
/****************************************************************************/
BOOL
InitHSVJobProps (HWND hwnd, PDLGINSTANCE pdi, PJOBPROPERTIES pJobProps)
{
   /*------------------------------------------------------------------------*/
   /* Local Variables                                                        */
   /*------------------------------------------------------------------------*/
   SHORT sTick;
   CHAR  szSlider[10];

   /*------------------------------------------------------------------------*/
   /* BEGIN CODE                                                             */
   /*------------------------------------------------------------------------*/

   //-------------------------------------
   // SMALL TICKS
   //-------------------------------------
   WinSendDlgItemMsg (hwnd, IDD_HUE,          SLM_SETTICKSIZE, MPFROM2SHORT (SMA_SETALLTICKS, SMALL_TICKSIZE), MPVOID);
   WinSendDlgItemMsg (hwnd, IDD_SATURATION,   SLM_SETTICKSIZE, MPFROM2SHORT (SMA_SETALLTICKS, SMALL_TICKSIZE), MPVOID);
   WinSendDlgItemMsg (hwnd, IDD_CLR_DARKNESS, SLM_SETTICKSIZE, MPFROM2SHORT (SMA_SETALLTICKS, SMALL_TICKSIZE), MPVOID);

   //-------------------------------------
   // INITIAL SLIDER POSITION
   //-------------------------------------
   WinSendDlgItemMsg (hwnd, IDD_HUE,          SLM_SETSLIDERINFO, MPFROM2SHORT (SMA_SLIDERARMPOSITION, SMA_INCREMENTVALUE), MPFROMSHORT(HALF_PERC_TICKS+pJobProps->lHue / ((MAX_DEGREE - MIN_DEGREE)/(NUM_PERC_TICKS-1))));
   WinSendDlgItemMsg (hwnd, IDD_SATURATION,   SLM_SETSLIDERINFO, MPFROM2SHORT (SMA_SLIDERARMPOSITION, SMA_INCREMENTVALUE), MPFROMSHORT(MAX_DEVIATION+pJobProps->lSaturation));
   WinSendDlgItemMsg (hwnd, IDD_CLR_DARKNESS, SLM_SETSLIDERINFO, MPFROM2SHORT (SMA_SLIDERARMPOSITION, SMA_INCREMENTVALUE), MPFROMSHORT(MAX_DEVIATION+pJobProps->lValue));

   //-------------------------------------
   // LARGE TICKS
   //-------------------------------------
   for (sTick = MIN_DEVIATION ; sTick <= MAX_DEVIATION; sTick += LARGE_TICKSPACE)
   {
      WinSendDlgItemMsg (hwnd, IDD_CLR_DARKNESS, SLM_SETTICKSIZE, MPFROM2SHORT (sTick+MAX_DEVIATION, LARGE_TICKSIZE), MPVOID);
      WinSendDlgItemMsg (hwnd, IDD_SATURATION, SLM_SETTICKSIZE, MPFROM2SHORT (sTick+MAX_DEVIATION, LARGE_TICKSIZE), MPVOID);
   }

   for (sTick = MIN_DEGREE; sTick <= MAX_DEGREE; sTick += LARGE_PERC_TICKSPACE)
   {
      WinSendDlgItemMsg (hwnd, IDD_HUE, SLM_SETTICKSIZE, MPFROM2SHORT (sTick+MAX_DEGREE, LARGE_TICKSIZE), MPVOID);
   }

   //-------------------------------------
   // TICK TEXT
   //-------------------------------------

   // Set Tick Text (e.g. -50, 0, +50)
   for (sTick = MIN_DEVIATION; sTick <= MAX_DEVIATION; sTick += MAX_DEVIATION)
   {
      sprintf (szSlider, "%+d", sTick);  // @97254 - changed from _itoa - mfr

      WinSendDlgItemMsg (hwnd,
                         IDD_SATURATION,
                         SLM_SETSCALETEXT,
                         MPFROMSHORT (sTick+MAX_DEVIATION),
                         MPFROMP (szSlider));

      WinSendDlgItemMsg (hwnd,
                         IDD_CLR_DARKNESS,
                         SLM_SETSCALETEXT,
                         MPFROMSHORT (sTick+MAX_DEVIATION),
                         MPFROMP (szSlider));
   }

   // Set Tick Text (e.g. -180, 0, +180)
   for (sTick = MIN_DEGREE; sTick <= MAX_DEGREE; sTick += MAX_DEGREE)
   {
      _itoa (sTick, szSlider, 10);

      WinSendDlgItemMsg (hwnd,
                         IDD_HUE,
                         SLM_SETSCALETEXT,
                         MPFROMSHORT ((sTick+MAX_DEGREE)/4),
                         MPFROMP (szSlider));
   }

   return TRUE;

} /* end InitHSVJobProps */

/****************************************************************************/
/* PROCEDURE NAME : InitializeDialogDevice                                  */
/* AUTHOR         : Mark H.                                                 */
/* DATE WRITTEN   : 12/26/95                                                */
/* DESCRIPTION    :                                                         */
/*                                                                          */
/* PARAMETERS:                                                              */
/*                                                                          */
/* RETURN VALUES:                                                           */
/*                                                                          */
/*--------------------------------------------------------------------------*/
/* CHANGE/MODIFICATION LOG :                                                */
/*--------------------------------------------------------------------------*/
/* @EXJOB  - 07/13/98 - UCC [IBMJ]- Expansible job data support             */
/*                                                                          */
/****************************************************************************/
VOID
InitializeDialogDevice (PDLGINSTANCE pdi, HWND hwnd, ULONG ulType)
{
   PNOTEBOOKINFO  pNBI;
   PFNSUBCLASS    pSubFx = NULL;

   DBPRINTF (("%s:Enter ulType = %d\n", __FUNCTION__, ulType));

   pNBI   = pdi->pNBI;
   pSubFx = pdi->pDevice->pSubclassedFunctions;

   if (!pdi->pvDeviceCookie)
   {
      if (pSubFx && pSubFx->pfnDeviceQuery)
      {
         PVOID     pvHandle;

         pvHandle = (PVOID)pSubFx->pfnDeviceQuery (NULL,
                                                   DEVICE_ALLOC_HANDLE,
                                                   pdi->hmcbHeap,
                                                   (PVOID)NULL);
         pdi->pvDeviceCookie = pvHandle;
         assertF (pdi->pvDeviceCookie);

         DBPRINTF (("%s: pvHandle = %08X\n", __FUNCTION__, pvHandle));
      }
   }

   if (pSubFx && pSubFx->pfnDeviceQuery)
   {
      PNBPAGEINFO pPIRoot = NULL;

      if (pSubFx->pfnDeviceQuery (pdi, ulType, pdi->pvDeviceCookie, TRUE))
         pdi->StateData.ulCalledDeviceQueryDialogs = ulType;

      if (DEVICE_QUERY_PRN_DIALOGS == ulType)
         pPIRoot = pNBI->pPageInfoPrinterDevice;
      else if (DEVICE_QUERY_JOB_DIALOGS == pdi->StateData.ulCalledDeviceQueryDialogs)
         pPIRoot = pNBI->pPageInfoJobDevice;
      else
         pPIRoot = NULL;

      while (pPIRoot)
      {
         if (pPIRoot->pfnDlg)
         {
            DBPRINTF (("%s: InsertNotebookPage (%08X)\n", __FUNCTION__, pPIRoot->pfnDlg));

            InsertNotebookPage (hwnd,
                                pdi,
                                pdi->pvDeviceCookie,
// begin @EXJOB
                                (DEVICE_QUERY_PRN_DIALOGS == ulType) ?
                                pdi->pNBI->hwndNB : pdi->pNBI->hwndJobPropNB,
                                (DEVICE_QUERY_PRN_DIALOGS == ulType) ?
                                pdi->pNBI->ulNBID : pdi->pNBI->ulJobPropNBID,
//                              pdi->pNBI->hwndNB,
//                              pdi->pNBI->ulNBID,
// end @EXJOB
                                pdi->pNBI,
                                pPIRoot,
                                pPIRoot->ulDlgID,
                                pPIRoot->pfnDlg,
                                pPIRoot->pszTabText,
                                BKA_MAJOR);
         }

         pPIRoot = pPIRoot->pNext;
      }
   }

   DBPRINTF (("%s:Exit\n", __FUNCTION__));
}

/****************************************************************************/
/* PROCEDURE NAME : FreeDialogDevice                                        */
/* AUTHOR         : Mark H.                                                 */
/* DATE WRITTEN   : 12/26/95                                                */
/* DESCRIPTION    :                                                         */
/*                                                                          */
/* PARAMETERS:                                                              */
/*                                                                          */
/* RETURN VALUES:                                                           */
/*                                                                          */
/*--------------------------------------------------------------------------*/
/* CHANGE/MODIFICATION LOG :                                                */
/*--------------------------------------------------------------------------*/
/*                                                                          */
/****************************************************************************/
VOID
FreeDialogDevice (PDLGINSTANCE pdi, ULONG ulType)
{
   PNOTEBOOKINFO  pNBI;
   PFNSUBCLASS    pSubFx = NULL;
   PNBPAGEINFO    pRoot,
                  pTmp;
   APIRET         rc;

   DBPRINTF (("%s:Enter ulType = %d\n", __FUNCTION__, ulType));

   pSubFx = pdi->pDevice->pSubclassedFunctions;

   if (pdi->StateData.ulCalledDeviceQueryDialogs)
   {
      if (pSubFx && pSubFx->pfnDeviceQuery)
      {
         pSubFx->pfnDeviceQuery (pdi,
                                 ulType,
                                 pdi->pvDeviceCookie,
                                 (PVOID)FALSE);
      }
   }

   pNBI = pdi->pNBI;
   if (pNBI)
   {
      // Clean up linked list of driver dialog pages
      if (DEVICE_QUERY_PRN_DIALOGS == ulType)
         pRoot = pNBI->pPageInfoPrinterDevice;
      else if (DEVICE_QUERY_JOB_DIALOGS == ulType)
         pRoot = pNBI->pPageInfoJobDevice;
      else
         pRoot = NULL;

      while (pRoot)
      {
         pTmp  = pRoot;        // Save pointer
         pRoot = pRoot->pNext; // Move to next

         if (pTmp->pfnDlg)
         {
            DBPRINTF (("%s: Sending close message for pfn %08X hwnd %08X\n",
                       __FUNCTION__,
                       pTmp->pfnDlg,
                       pTmp->hwndPage));

            WinSendMsg (pTmp->hwndPage,
                        WM_COMMAND,
                        MPFROM2SHORT (DID_OK, 0),
                        MPVOID);
         }

         rc = GplMemoryFree (pTmp);
         assertT (rc);
      }

      // @240752 Trap in the omni driver: There is not need to do 
      // GplMemoryFree(pNBI). pNBI is need for Printer Properties.
      // Called from printer properties?
      if (!pdi->bDeviceDefaults)
      {
         // Free up notebook information structure
         rc = GplMemoryFree (pNBI);
         assertT (rc);
         pdi->pNBI = NULL;
      }    
   }

   if (pdi->pvDeviceCookie &&
       !pdi->bDeviceDefaults)  // Called from printer properties? @240752:
   {                           // don't do DEVICE_FREE_HANDLE !!!
      if (pSubFx && pSubFx->pfnDeviceQuery)
      {
         pSubFx->pfnDeviceQuery (NULL,
                                 DEVICE_FREE_HANDLE,
                                 pdi->pvDeviceCookie,
                                 (BOOL)FALSE);
      }
   }

#ifndef DEBUG
   rc++;          // Avoid compiler warnings
#endif

   DBPRINTF (("%s:Exit\n", __FUNCTION__));
}

/****************************************************************************/
/* PROCEDURE NAME : OmniUpdateConstraints                                   */
/* DATE WRITTEN   : 05/25/2000                                              */
/* DESCRIPTION    : This function removes constrained items from            */
/*                  lSlaveControl                                           */
/*                                                                          */
/*                                                                          */
/* PARAMETERS:                                                              */
/*                                                                          */
/* RETURN VALUES:                                                           */
/*                                                                          */
/*--------------------------------------------------------------------------*/
/* CHANGE/MODIFICATION LOG :                                                */
/*--------------------------------------------------------------------------*/
/*                                                                          */
/****************************************************************************/
VOID
OmniUpdateConstraints (HWND         hwndDlg,
                       PDLGINSTANCE pdi, 
                       LONG         lSlaveControl)
{
   if (pdi->pDriver->pDrvConstr)
   {
      PDRVCONSTRAINTS  pDrvConstr = pdi->pDriver->pDrvConstr;
      
      // We try to find constraints for current device
      while (pDrvConstr->lDeviceID != CONSTR_END)
      {
        if (pDrvConstr->lDeviceID == pdi->pDevice->usDeviceID)
           break;
           
        pDrvConstr++;
      }

      // We have constraints for this device
      if (pDrvConstr->lDeviceID != CONSTR_END)
      {
        PDEVCONSTRAINTS pDevConstr = pDrvConstr->pConstraints;
        SHORT           sItemIndex;
        SHORT           sItemCount;
        LONG            lCurrent;
        LONG            lHandle;
        
        // Which item is selected in the slave control
        sItemIndex = SHORT1FROMMR (WinSendDlgItemMsg (hwndDlg,
                                   lSlaveControl,
                                   LM_QUERYSELECTION,
                                   MPVOID, MPVOID));

        // Get handle of the focused item in the slave control
        lCurrent = (LONG)WinSendDlgItemMsg (hwndDlg,
                                             lSlaveControl,
                                             LM_QUERYITEMHANDLE,
                                             MPFROMSHORT(sItemIndex), 
                                             MPVOID);
        
        while (pDevConstr->lMasterControl != CONSTR_END)
        {
          // Process constraints only for slave control
          if (pDevConstr->lSlaveControl == lSlaveControl)
          {
             // Which item is selected in the master control
             sItemIndex = SHORT1FROMMR (WinSendDlgItemMsg (hwndDlg,
                                        pDevConstr->lMasterControl,
                                        LM_QUERYSELECTION,
                                        MPVOID, MPVOID));

             // Which handle it has
             lHandle = (LONG)WinSendDlgItemMsg (hwndDlg,
                                          pDevConstr->lMasterControl,
                                          LM_QUERYITEMHANDLE,
                                          MPFROMSHORT(sItemIndex), 
                                          MPVOID);
             
             //Item currently selected in our master control is constraining us
             if (pDevConstr->lMasterItem == lHandle)
             {
                if (lCurrent == pDevConstr->lSlaveItem)
                   lCurrent = 0;
                
                sItemCount = SHORT1FROMMR(WinSendDlgItemMsg (hwndDlg,
                                          lSlaveControl,
                                          LM_QUERYITEMCOUNT,
                                          MPVOID, MPVOID));

                // Search constrained item in combobox
                for (sItemIndex = 0; sItemIndex < sItemCount; sItemIndex++)
                {
                   lHandle = (LONG)WinSendDlgItemMsg (hwndDlg,
                                          lSlaveControl,
                                          LM_QUERYITEMHANDLE,
                                          MPFROMSHORT(sItemIndex), 
                                          MPVOID);

                   // Delete constrained item from combobox
                   if (pDevConstr->lSlaveItem == lHandle)
                   {
                      WinSendDlgItemMsg (hwndDlg,
                                         lSlaveControl,
                                         LM_DELETEITEM,
                                         MPFROMSHORT(sItemIndex), 
                                         MPVOID);

                      break;
                   }
                }
             }
          }
          
          pDevConstr++;
        }
        
        //
        // if we deleted item which had focus
        // we set focus to item with index 0
        //
        if (!lCurrent)
           WinSendDlgItemMsg (hwndDlg,
                              lSlaveControl,
                              LM_SELECTITEM,
                              MPFROMLONG (0),
                              MPFROMLONG (TRUE));
      }
   }
}  /* end OmniUpdateConstraints */



/****************************************************************************/
/*==========================================================================*/
/* Window and Dialog Procedures                                             */
/*==========================================================================*/
/****************************************************************************/

/****************************************************************************/
/* PROCEDURE NAME : JobPropertiesDlgProc                                    */
/* AUTHOR         : MFR                                                     */
/* DATE WRITTEN   : 8/04/94                                                 */
/* DESCRIPTION    :                                                         */
/*                                                                          */
/*                  Control Flow:                                           */
/*                                                                          */
/* PARAMETERS:                                                              */
/*                                                                          */
/* RETURN VALUES:                                                           */
/*                                                                          */
/*--------------------------------------------------------------------------*/
/* CHANGE/MODIFICATION LOG :                                                */
/*--------------------------------------------------------------------------*/
/* @EXJOB  - 07/13/98 - UCC [IBMJ]- Expansible job data support             */
/*                                                                          */
/****************************************************************************/
MRESULT EXPENTRY
JobPropertiesDlgProc (HWND hwnd, ULONG  msg, MPARAM mp1, MPARAM mp2)
{
   PDLGINSTANCE      pdi;
   PNOTEBOOKINFO     pNBI;
   PDEVICEINFO       pDevice;
   BOOL              bRC;
#ifdef DEBUG
   static BOOL       bShow    = TRUE;
#endif

   switch (msg)
   {
   case WM_CONTROLPOINTER:
   {
      ULONG ulCtlID = LONGFROMMP (mp1);

      pdi = (PDLGINSTANCE)WinQueryWindowULong (hwnd, QWL_USER);

      if (ulCtlID != pdi->ulLastCtlID)
      {
         pdi->ulLastCtlID = ulCtlID;

         DisplayContextHelp (pdi->pHelpJobProp, pdi->hwndJobPropTxtHelp, ulCtlID);
      }
      break;
   }

   case WM_HITTEST:
   {
      // Simulate WM_CONTROLPOINTER for controls such as spinbutton, combo box
      GplHitTestHandler (hwnd, mp1, mp2);
      break;
   }
   case WM_INITDLG:
   {
      ULONG    ulDlgIdx;
      LONG     lClr;
      CHAR     szTitle[2*MAX_VERNAME_SIZE];
      CHAR     szVersion[MAX_VERNAME_SIZE];
      HWND     hwndTitlebar;
      ULONG    cxDesktop, cyDesktop;
      RECTL    rctl;

      pdi = (PDLGINSTANCE)mp2;

      // initial pointer validation
      assertF (pdi);

      // initial pointer validation
      assertF (pdi->pDevice);
      pDevice = pdi->pDevice;

      // store the pointer to instance data
      WinSetWindowULong (hwnd, QWL_USER, (ULONG)pdi);

      DBPRINTIF ((bShow, "%s(): INIT_DLG pdi='%p'\n", __FUNCTION__, pdi));

      // To center Job Properties dialog we need the dialog's dimensions
      WinQueryWindowRect (hwnd, &rctl);

      // Next we need desktop dimensions
      cxDesktop = WinQuerySysValue (HWND_DESKTOP, SV_CXSCREEN);
      cyDesktop = WinQuerySysValue (HWND_DESKTOP, SV_CYSCREEN);

      // Center Job Properties on the screen
      WinSetWindowPos (hwnd, NULLHANDLE,
                       (cxDesktop-rctl.xRight)/2,
                       (cyDesktop-rctl.yTop)/2,
                       0L,
                       0L,
                       SWP_MOVE);

      // Retrieve version of driver from Extended Attributes
      szVersion[0] = '\0';  // For some reason static mem not always NULLed
      GetEAVersion (szVersion, sizeof (szVersion));

      // We are going to fill in a lot of strings from a similar location
      // in stringtable so lets get a base index to reference from
      ulDlgIdx  = STRING_TABLE_DLG_BASE - STRING_TABLE_BASE;

      // Build string to display in titlebar window
      if (!pdi->bDeviceDefaults)
      {
         sprintf (szTitle, "%s: %s: %s %s",
                  globals.pbStringTable[ulDlgIdx + DIALOG_JOB_PROPS],
                  pdi->pDevice->pszDeviceName,
                  globals.pbStringTable[ulDlgIdx + DIALOG_DEV_VERSION],
                  szVersion);
      }
      else
      {
         sprintf (szTitle, "%s: %s: %s %s",
                  globals.pbStringTable[ulDlgIdx + DIALOG_DEV_DEFAULTS],
                  pdi->pDevice->pszDeviceName,
                  globals.pbStringTable[ulDlgIdx + DIALOG_DEV_VERSION],
                  szVersion);
      }

      // Set Titlebar text (e.g. "Job Propeties: HP DeskJet 660c: Driver Version 5.67")
      WinSetWindowText (hwnd, szTitle);

      // Get non-dithered RGB value for system defined CLR_DARKRED
      lClr = GpiQueryRGBColor (WinGetPS (hwnd), 0L, CLR_DARKRED);   // CLR_DARKRED's RGB equivalent

      // Set dialog border color to better indicate "Job Properties"
      // WinSetSysColors (HWND_DESKTOP, LCOL_PURECOLOR, LCOLF_CONSECRGB,
      //                  SYSCLR_ACTIVETITLE, 1L, &lClr);

      // Set backround of titlebar text to same color as SYSCLR_ACTIVETITLE
      hwndTitlebar = WinWindowFromID (hwnd, FID_TITLEBAR);
      WinSetPresParam (hwndTitlebar, PP_ACTIVECOLOR, 4L, &lClr);
      WinSetPresParam (hwndTitlebar, PP_ACTIVETEXTBGNDCOLOR, 4L, &lClr);

      // Fill in push buttons' text in Job Properties dialog from driver's stringtable
      WinSetDlgItemText (hwnd, DID_OK,     globals.pbStringTable[ulDlgIdx + DIALOG_TEXT_SAVE]   );
      WinSetDlgItemText (hwnd, DID_CANCEL, globals.pbStringTable[ulDlgIdx + DIALOG_TEXT_CANCEL] );
      WinSetDlgItemText (hwnd, DID_HELP,   globals.pbStringTable[ulDlgIdx + DIALOG_TEXT_HELP]   );

      // Get window handle of "context sensitive help" entryfield
      pdi->hwndJobPropTxtHelp = WinWindowFromID (hwnd, IDD_CONTEXT_HELP);

      //----------------------------------------------------------------------
      // Initialize things outside Notebook itself
      //----------------------------------------------------------------------
      if (!pdi->bDeviceDefaults)
      {
         bRC = ReadUserDefinedTrayList (pdi->szAppName, pDevice);
         assertF (bRC);

         bRC = ReadUserDefinedFormList (pdi->szAppName, pDevice);
         assertF (bRC);

         bRC = ReadUserDefinedConnectList (pdi->szAppName, pDevice);
         assertF (bRC);

         bRC = ReadUserDefinedFontList (pdi->szAppName, pDevice);
         assertF (bRC);

         // Allocate a Notebook Information Structure in dialog instance data
         pdi->pNBI = (PNOTEBOOKINFO)GplMemoryAlloc (pdi->hmcbHeap, sizeof(NOTEBOOKINFO));
         memset (pdi->pNBI, 0, sizeof (*pdi->pNBI));
      }

      assertF (pdi->pNBI);
      pNBI = pdi->pNBI;

      pdi->pNBI->ulJobPropNBID = IDD_JOB_PROPERTIES_NB;
      pdi->pNBI->hwndJobPropNB = WinWindowFromID (hwnd, IDD_JOB_PROPERTIES_NB);

      // This sets color around outside of notebook  (we want gray)
      lClr = SYSCLR_DIALOGBACKGROUND;
      WinSetPresParam (pdi->pNBI->hwndJobPropNB,
                       PP_BACKGROUNDCOLORINDEX, 4L, &lClr);

      // Set Color for "Foreground" page and it's Major Tab
      WinSendMsg (pdi->pNBI->hwndJobPropNB, BKM_SETNOTEBOOKCOLORS,
                  MPFROMLONG (lClr),
                  MPFROMLONG (BKA_BACKGROUNDPAGECOLORINDEX));

      // Set Color for "Background" pages and their tabs
      WinSendMsg (pdi->pNBI->hwndJobPropNB, BKM_SETNOTEBOOKCOLORS,
                  MPFROMLONG (SYSCLR_PAGEBACKGROUND),
                  MPFROMLONG (BKA_BACKGROUNDMAJORCOLORINDEX));

      // Create a linked list for holding context help messages
      CreateContextHelp (&(pdi->pHelpJobProp));

      // Set Index into string table relative to context help msgs
      ulDlgIdx = STRING_TABLE_MSG_BASE - STRING_TABLE_BASE;

      // add context help for "Common" Job Properties notebook page

      // Initialize current Control ID to invalid value
      pdi->ulLastCtlID = 0;

      // Add help messages specific to Job Property buttons
      AddContextHelp (pdi->pHelpJobProp, DID_OK, globals.pbStringTable[ulDlgIdx + MSG_JOB_OK]);
      AddContextHelp (pdi->pHelpJobProp, DID_CANCEL, globals.pbStringTable[ulDlgIdx + MSG_JOB_CANCEL]);
      AddContextHelp (pdi->pHelpJobProp, DID_HELP, globals.pbStringTable[ulDlgIdx + MSG_JOB_HELP]);
      AddContextHelp (pdi->pHelpJobProp, DID_UNDO, globals.pbStringTable[ulDlgIdx + MSG_JOB_UNDO]);
      AddContextHelp (pdi->pHelpJobProp, DID_DEFAULTS, globals.pbStringTable[ulDlgIdx + MSG_JOB_DEFAULTS]);

      // Add context help messages for "Job Properties" dialog items
      AddContextHelp (pdi->pHelpJobProp, IDD_JOB_PROPERTIES_NB, globals.pbStringTable[ulDlgIdx + MSG_JOB_NOTEBOOK]);
      AddContextHelp (pdi->pHelpJobProp, IDD_CONTEXT_HELP, globals.pbStringTable[ulDlgIdx + MSG_CTX_HELP]);

      // Add all pages to the Job Property notebook
      FillJobPropertiesNotebook (hwnd, pdi);

      
      if (!(pdi->pDevice->ulOmniDeviceTechnology & OMNI_CAP_BOOKLET))
      {
          pdi->hNotebookInst = GplJFCreateNotebookInstance (hwnd,
                                                            IDD_JOB_PROPERTIES_NB,
                                                            WinWindowFromID (hwnd, IDD_CONTEXT_HELP),
                                                            pdi->hwndHelp,
                                                            globals.hModule,
                                                            pdi->szAppName,
                                                            globals.pvSharedHeap);

          pdi->hLayoutPgInst = GplLayoutCreatePage (pdi->hNotebookInst,
                                                    &(pdi->pJobProperties->LayoutCB),
                                                    NULL,
                                                    NULL,
                                                    NULL,
                                                    0,
                                                    GNDF_NOFTP | GNDF_NOSCALING | GNDF_BOOKLETOMNI);
      }
      

      // Set Tab dimensions based upon maximum Tab Text of all pages inserted
      WinSendDlgItemMsg (hwnd, pdi->pNBI->ulJobPropNBID,
                         BKM_SETDIMENSIONS,
                         MPFROM2SHORT ((SHORT)(pdi->pNBI->cxMajor+WIDTH_SPACE),
                         (SHORT)(2*pdi->pNBI->cyMajor)),
                         MPFROMSHORT (BKA_MAJORTAB));

      // Select "Common Job Properties" to be topmost page
      WinSendMsg (pdi->pNBI->hwndJobPropNB,
                  BKM_TURNTOPAGE,
                  MPFROMLONG (pNBI->PageInfoJobProps.ulPageID),
                  MPVOID);

      // Set text limit of entry field to a much larger value
      WinSendDlgItemMsg (hwnd, IDD_CONTEXT_HELP,
                         EM_SETTEXTLIMIT,
                         MPFROMLONG (MAX_CTX_HELP_STRING),
                         MPVOID);

      // done initializing dlg box
      return 0L;
   }

   case HM_QUERY_KEYS_HELP:
      return (MRESULT)PANEL_JOB_PROPERTIES;

   case WM_HELP:
   {
#ifdef DEBUG
      USHORT usCmd    = SHORT1FROMMP (mp1);
      USHORT usSource = SHORT1FROMMP (mp2);
#endif

      pdi = (PDLGINSTANCE) WinQueryWindowULong (hwnd, QWL_USER);

      DBPRINTIF ((FALSE, "%s(); WM_HELP: usCmd=%d, usSource=%d\n", __FUNCTION__, usCmd, usSource));

      // send help along if we have a valid help instance
      if (pdi->hwndHelp)
      {
         WinSendMsg (pdi->hwndHelp, HM_DISPLAY_HELP,
                     MPFROMSHORT (PANEL_JOB_PROPERTIES),
                     MPFROMSHORT (HM_RESOURCEID));
      }

      return 0L;
   }

   // @RME01 begin
   case WM_CLOSE:
   {
#if defined (USE_LEXMARK_STYLE) || defined (DONT_USE_LEXMARK_STYLE)
      ULONG      ulResponse;      /* return code from WinMessageBox */
#endif

      pdi = (PDLGINSTANCE)WinQueryWindowULong (hwnd, QWL_USER);

#ifdef DEBUG
      // @EXJOB
      DebugOutputJobProperties (FALSE, "DRIVDATA saved from DPDM_CHANGEPROP", pdi->pJobProperties);
#endif

#if defined (USE_LEXMARK_STYLE) || defined (DONT_USE_LEXMARK_STYLE)
      ulResponse = WinMessageBox (HWND_DESKTOP,
                                  NULLHANDLE,
                                  globals.pbStringTable[STRING_TABLE_WARN_BASE - STRING_TABLE_BASE + WARNING_STRING_CHANGES_LOST],
                                  pdi->pszDeviceName,
                                  0,
                                  MB_ICONQUESTION | MB_YESNO);

#ifdef USE_LEXMARK_STYLE
      if (ulResponse == MBID_YES)
         WinPostMsg (hwnd, WM_QUIT, (MPARAM)0, (MPARAM)0);
      else if (ulResponse == MBID_NO)
         return FALSE;
#else
      if (ulResponse == MBID_NO)
      {
         SaveJobProperties (pdi, pdi->pJobProperties); // @EXJOB
      }

      WinPostMsg (hwnd, WM_QUIT, (MPARAM)0, (MPARAM)0);
#endif
#endif
      // Free help manager here because it fails at WM_DESTROY
      DestroyHelpInstance (pdi, FALSE);
      
      break;
   }
   // @RME01 end

   case WM_DESTROY:
   {
      pdi = (PDLGINSTANCE)WinQueryWindowULong (hwnd, QWL_USER);
      DBPRINTIF ((FALSE, "%s(); WM_DESTROY\n", __FUNCTION__));

      // Check for valid pointers
      assertF (pdi);
      assertF (pdi->pDevice);

      // assign local copy of current device information
      pDevice = pdi->pDevice;

      // Reset OS/2 system SYSCLR_ACTIVETITLE back to defaults
      // WinSetSysColors (HWND_DESKTOP, LCOL_RESET, LCOLF_CONSECRGB,
      //                  SYSCLR_ACTIVETITLE, 0L, NULL);

      // free up context help linked list
      DestroyContextHelp (pdi->pHelpJobProp);

      // Delete all pages in the Job Properties notebook
      WinSendDlgItemMsg (hwnd,
                         IDD_JOB_PROPERTIES_NB,
                         BKM_DELETEPAGE,
                         0L, (MPARAM)BKA_ALL);

      // if user is displaying job props and this is not from
      // a "Device Defaults" call from printer props then we
      // have to free up user defined lists (Trays, Paper sizes etc.)
      if (!pdi->bDeviceDefaults)
      {
         // Free up linked list of user-defined resources
         FreeUserDefinedTrayList (pDevice);
         FreeUserDefinedFormList (pDevice);
         FreeUserDefinedFontList (pDevice);
         FreeConnectionList (pDevice);

         
         GplLayoutDestroyPage(0, pdi->hLayoutPgInst);
         GplJFDestroyNotebookInstance(pdi->hNotebookInst);
         

//        FreeDialogDevice (pdi, DEVICE_QUERY_JOB_DIALOGS); //@JPN2H99
      }
      break;
   }

   case WM_COMMAND:
   {
      // get instance data
      pdi = (PDLGINSTANCE)WinQueryWindowULong (hwnd, QWL_USER);

      DBPRINTIF ((TRUE, "%s(); WM_COMMAND\n", __FUNCTION__)); //@RE
      switch (SHORT1FROMMP (mp1))
      {
      case DID_OK:
      {
#ifdef DEBUG
         // @EXJOB
         DebugOutputJobProperties (FALSE, "DRIVDATA saved from DPDM_CHANGEPROP", pdi->pJobProperties);
#endif

         GplLayoutSaveSettings(pdi->hLayoutPgInst); 

         SaveJobProperties (pdi, pdi->pJobProperties); // @EXJOB

         // Called from printer properties?
         if (!pdi->bDeviceDefaults)
         {
            // Free help manager here because it fails at WM_DESTROY
            DestroyHelpInstance (pdi, FALSE);
         }

         WinDismissDlg (hwnd, DID_OK);
         break;
      }

      case DID_CANCEL:
      {
#if defined (USE_LEXMARK_STYLE) || defined (DONT_USE_LEXMARK_STYLE)

#ifdef USE_LEXMARK_STYLE
         // @RME01 begin

         ULONG      ulResponse;      /* return code from WinMessageBox */

         ulResponse = WinMessageBox (HWND_DESKTOP,
                                    NULLHANDLE,
                                    globals.pbStringTable[STRING_TABLE_WARN_BASE - STRING_TABLE_BASE + WARNING_STRING_CHANGES_LOST],
                                    pdi->pszDeviceName,
                                    0,
                                    MB_ICONQUESTION | MB_YESNO);

         if (ulResponse == MBID_NO)
            break;

         // @RME01 end
#endif
#endif

         // Called from printer properties?
         if (!pdi->bDeviceDefaults)
         {
            // Free help manager here because it fails at WM_DESTROY
            DestroyHelpInstance (pdi, FALSE);
         }

         WinDismissDlg (hwnd, DID_CANCEL);
         break;
      }
      }

      return 0L;
   }
   }

#ifndef DEBUG
   bRC++;          // Avoid compiler warnings
#endif

   // default for most cases
   return WinDefDlgProc (hwnd, msg, mp1, mp2);

} /* end JobPropertiesDlgProc */

/****************************************************************************/
/* PROCEDURE NAME : CommonJobPropertiesDlgProc                              */
/* AUTHOR         : MFR                                                     */
/* DATE WRITTEN   : 9/22/92                                                 */
/* DESCRIPTION    :                                                         */
/*                                                                          */
/*                  Control Flow:                                           */
/*                                                                          */
/* PARAMETERS:                                                              */
/*                                                                          */
/* RETURN VALUES:                                                           */
/*                                                                          */
/*--------------------------------------------------------------------------*/
/* CHANGE/MODIFICATION LOG :                                                */
/*--------------------------------------------------------------------------*/
/* @EXJOB  - 07/13/98 - UCC [IBMJ]- Expansible job data support             */
/*                                                                          */
/****************************************************************************/
MRESULT EXPENTRY
CommonJobPropertiesDlgProc (HWND hwnd, ULONG  msg, MPARAM mp1, MPARAM mp2)
{
   PDLGINSTANCE  pdi;
   PDEVICEINFO   pDevice;
   MPARAM        mpValues[2];  

   switch (msg)
   {
   case WM_COMMAND:
   {
      pdi = (PDLGINSTANCE)WinQueryWindowULong (hwnd, QWL_USER);

      switch (SHORT1FROMMP(mp1))
      {
      case DID_UNDO:
      {
         pdi = (PDLGINSTANCE)WinQueryWindowULong (hwnd, QWL_USER);
         pDevice = pdi->pDevice;

         // @EXJOB
         InitCommonJobProps (hwnd, pdi, pDevice, pdi->pJobProperties, FALSE);
         break;
      }

      case DID_DEFAULTS:
      {
         pdi = (PDLGINSTANCE) WinQueryWindowULong( hwnd, QWL_USER );
         pDevice = pdi->pDevice;

         // Change default form connection if country code
         // indicates a "non-metric" country (i.e. "Letter" paper
         // not "A4" paper size)
         if (pdi->ctryInfo.country == COUNTRYCODE_USA    ||
             pdi->ctryInfo.country == COUNTRYCODE_CANADA  )
            InitCommonJobProps (hwnd, pdi, pDevice, &(pDevice->DeviceDefaults), TRUE);
         else
            InitCommonJobProps (hwnd, pdi, pDevice, &(pDevice->DeviceDefaults), FALSE);
         break;
      }
      }

      return FALSE;
   }

   case WM_CONTROLPOINTER:
   {
      ULONG ulCtlID = LONGFROMMP (mp1);

      pdi = (PDLGINSTANCE)WinQueryWindowULong (hwnd, QWL_USER);

      if (ulCtlID != pdi->ulLastCtlID)
      {
         pdi->ulLastCtlID = ulCtlID;

         DisplayContextHelp (pdi->pHelpJobProp, pdi->hwndJobPropTxtHelp, ulCtlID);
      }
      break;
   }

   case WM_INITDLG:
   {
      ULONG     ulIdx;

      pdi = (PDLGINSTANCE)mp2;

      // store the pointer to instance data
      WinSetWindowULong (hwnd, QWL_USER, (ULONG)pdi);

      // initial pointer validation
      assertF (pdi);

      assertF (pdi->pDevice);
      pDevice = pdi->pDevice;

      pdi->hptrPortrait   = WinLoadPointer (HWND_DESKTOP, globals.hModule, ICON_PORTRAIT);
      pdi->hptrLandscape  = WinLoadPointer (HWND_DESKTOP, globals.hModule, ICON_LANDSCAPE);
      pdi->hptrDuplexOne  = WinLoadPointer (HWND_DESKTOP, globals.hModule, ICON_DUPLEX_ONE);
      pdi->hptrDuplexBook = WinLoadPointer (HWND_DESKTOP, globals.hModule, ICON_DUPLEX_BOOK);
      pdi->hptrDuplexFlip = WinLoadPointer (HWND_DESKTOP, globals.hModule, ICON_DUPLEX_FLIP);

      DBPRINTF (("%s(): INIT_DLG; hptrPortrait  = '%x'\n", __FUNCTION__, pdi->hptrPortrait));
      DBPRINTF (("%s(): INIT_DLG; hptrLandscape = '%x'\n", __FUNCTION__, pdi->hptrLandscape));

// begin @JPN2H99
      // Read in printer properties from INI file
      ReadPrinterProperties (pdi->szAppName, &pdi->PrnProperties, pDevice);
// end @JPN2H99

      // @EXJOB
      InitCommonJobProps (hwnd, pdi, pDevice, pdi->pJobProperties, FALSE);

      // Set up easy index into stringtable's context help msgs
      ulIdx = STRING_TABLE_MSG_BASE - STRING_TABLE_BASE;

      // add context help for '"Common" Job Properties notebook page
      AddContextHelp (pdi->pHelpJobProp, IDD_COMMON_JOB_PROPERTIES, globals.pbStringTable[ulIdx + MSG_COMMON_PAGE]);

      AddContextHelp (pdi->pHelpJobProp, IDD_DEFAULT_FORM, globals.pbStringTable[ulIdx + MSG_COMMON_FORM]);
      AddContextHelp (pdi->pHelpJobProp, IDD_RESOLUTIONS, globals.pbStringTable[ulIdx + MSG_COMMON_RESOLUTIONS]);
      AddContextHelp (pdi->pHelpJobProp, IDD_DEFAULT_PRINT_MODE, globals.pbStringTable[ulIdx + MSG_COMMON_PRINT_MODE]);

      AddContextHelp (pdi->pHelpJobProp, IDR_FF_CONDITIONAL, globals.pbStringTable[ulIdx + MSG_COMMON_CONDITIONAL]);
      AddContextHelp (pdi->pHelpJobProp, IDR_FF_NONE, globals.pbStringTable[ulIdx + MSG_COMMON_NONE]);
      AddContextHelp (pdi->pHelpJobProp, IDR_FF_COMPULSORY, globals.pbStringTable[ulIdx + MSG_COMMON_COMPULSORY]);

      AddContextHelp (pdi->pHelpJobProp, IDI_ORIENTATION, globals.pbStringTable[ulIdx + MSG_COMMON_ORIENTATION]);
      AddContextHelp (pdi->pHelpJobProp, IDC_PORTRAIT, globals.pbStringTable[ulIdx + MSG_COMMON_PORTRAIT]);
      AddContextHelp (pdi->pHelpJobProp, IDC_LANDSCAPE, globals.pbStringTable[ulIdx + MSG_COMMON_LANDSCAPE]);

      AddContextHelp (pdi->pHelpJobProp, IDI_DUPLEX, globals.pbStringTable[ulIdx + MSG_COMMON_DUPLEX]);
      AddContextHelp (pdi->pHelpJobProp, IDR_DUPLEX_ONE, globals.pbStringTable[ulIdx + MSG_COMMON_ONE]);
      AddContextHelp (pdi->pHelpJobProp, IDR_DUPLEX_FLIP, globals.pbStringTable[ulIdx + MSG_COMMON_FLIP]);
      AddContextHelp (pdi->pHelpJobProp, IDR_DUPLEX_BOOK, globals.pbStringTable[ulIdx + MSG_COMMON_BOOK]);

      AddContextHelp (pdi->pHelpJobProp, IDD_MIRROR, globals.pbStringTable[ulIdx + MSG_COMMON_MIRROR]);
      AddContextHelp (pdi->pHelpJobProp, IDD_ALGORITHMS, globals.pbStringTable[ulIdx + MSG_CLR_DITHER_ALGO]);
      AddContextHelp (pdi->pHelpJobProp, IDD_COPIES_NUMBER_TEXT, globals.pbStringTable[ulIdx + MSG_COPIES_NUMBER]);  
      AddContextHelp (pdi->pHelpJobProp, IDD_COLLATE, globals.pbStringTable[ulIdx + MSG_COLLATE]);                   

      // Handle and default focus
      return FALSE;
   }

   case WM_CONTROL:
   {
      // get instance data
      pdi = (PDLGINSTANCE)WinQueryWindowULong (hwnd, QWL_USER);

      switch (SHORT1FROMMP (mp1))
      {
// begin @EXJOB
      case IDD_DEFAULT_FORM:
      {
         SHORT  sIdx;
         /*------------------------------*/
         /* FORM CONNECTION OPERATION    */
         /*------------------------------*/
         sIdx = SHORT1FROMMR (WinSendDlgItemMsg (hwnd,
                                                 IDD_DEFAULT_FORM,
                                                 LM_QUERYSELECTION,
                                                 0L,
                                                 0L));

         // verify user selected listbox field
         if (sIdx != LIT_NONE)
         {
            // Get Item Handle (Conn ID)
            pdi->pJobProperties2->ulDefConnID =
               (ULONG)WinSendDlgItemMsg (hwnd,
                                         IDD_DEFAULT_FORM,
                                         LM_QUERYITEMHANDLE,
                                         MPFROMSHORT (sIdx),
                                         MPVOID);
         }
         break;
      }
// end @EXJOB
      case IDC_PORTRAIT:
      {
         // Erase old landscape icon
         SetIconInDialog (hwnd, pdi->hptrPortrait, IDI_ORIENTATION);

         // Enable Mirror control only if device supports mirroring
         if (pdi->pDevice->ulOmniDeviceTechnology & OMNI_CAP_MIRROR)
         {
            WinEnableControl (hwnd, IDD_MIRROR, TRUE);
         }
// begin @EXJOB
         pdi->pJobProperties2->ulOrientation = ORIENTATION_PORTRAIT;
// end @EXJOB

         
         // Update GENPLIB dialog pages with current orientation.
         mpValues[ 0 ] = (MPARAM) GJT_PORTRAIT;
         GplJFUpdateFormSettings(pdi->hNotebookInst, mpValues,
                                 GJMF_ORIENTATION, 1);
         

         break;
      }

      case IDC_LANDSCAPE:
      {
         // Erase old portrait icon
         SetIconInDialog (hwnd, pdi->hptrLandscape, IDI_ORIENTATION);

         // Disable Mirror control if device has capability
         if (pdi->pDevice->ulOmniDeviceTechnology & OMNI_CAP_MIRROR)
         {
            WinEnableControl (hwnd, IDD_MIRROR, FALSE);
         }
// begin @EXJOB
         pdi->pJobProperties2->ulOrientation = ORIENTATION_LANDSCAPE;
// end @EXJOB

         
         // Update GENPLIB dialog pages with current orientation.
         mpValues[0] = (MPARAM) GJT_LANDSCAPE;
         GplJFUpdateFormSettings(pdi->hNotebookInst, mpValues,
                                 GJMF_ORIENTATION, 1);
         

         break;
      }

      case IDR_DUPLEX_ONE:
      {
         SetIconInDialog (hwnd, pdi->hptrDuplexOne, IDI_DUPLEX);
         break;
      }

      case IDR_DUPLEX_BOOK:
      {
         SetIconInDialog (hwnd, pdi->hptrDuplexBook, IDI_DUPLEX);
         break;
      }

      case IDR_DUPLEX_FLIP:
      {
         SetIconInDialog (hwnd, pdi->hptrDuplexFlip, IDI_DUPLEX);
         break;
      }

      case IDD_ALGORITHMS:
      {
         SHORT          sIdx;
         PJOBPROPERTIES pJobProps = pdi->pJobProperties2;

         if (LN_SELECT != HIUSHORT (mp1))
            break;

         // List box selection code follows...

         sIdx = SHORT1FROMMR (WinSendDlgItemMsg (hwnd,
                                           IDD_ALGORITHMS,
                                           LM_QUERYSELECTION,
                                           MPVOID, MPVOID));

         // verify user selected Hafttone Algorithm
         if (sIdx != LIT_NONE)
         {
            ULONG ulDitherID;
            BOOL  bEnableHSV;

            // Get Item Handle (Dither ID)
            ulDitherID = (ULONG)WinSendDlgItemMsg (hwnd,
                                  IDD_ALGORITHMS,
                                  LM_QUERYITEMHANDLE,
                                  MPFROMSHORT (sIdx),
                                  MPVOID);

            pJobProps->ulAlgorithm = ulDitherID;

            if (ulDitherID == HT_MAGIC_SQUARES ||
                ulDitherID == HT_ORDERED_SQUARES)
               bEnableHSV = TRUE;
            else
               bEnableHSV = FALSE;

            WinEnableControl (pdi->pNBI->PageInfoHSV.hwndPage,
                              IDD_HUE, bEnableHSV);
            WinEnableControl (pdi->pNBI->PageInfoHSV.hwndPage,
                              IDD_SATURATION, bEnableHSV);
            WinEnableControl (pdi->pNBI->PageInfoHSV.hwndPage,
                              IDD_CLR_DARKNESS, bEnableHSV);

#ifdef DEBUG
            ShowTrueGamma (pdi->pNBI->PageInfoImageClr.hwndPage,
                           pdi,
                           pJobProps,
                           FALSE);
#endif
            return 0;
         }

         break;
      }

      case IDD_DEFAULT_PRINT_MODE:
      {
         SHORT          sIdx;
         PJOBPROPERTIES pJobProps = pdi->pJobProperties2;

         if (LN_SELECT != HIUSHORT (mp1))
            break;

         // List box selection code follows...
         sIdx = SHORT1FROMMR (WinSendDlgItemMsg (hwnd,
                                           IDD_DEFAULT_PRINT_MODE,
                                           LM_QUERYSELECTION,
                                           MPVOID, MPVOID));

         // verify user selected a print mode
         if (sIdx != LIT_NONE)
         {
            // Get Item Handle (Print Mode ID)
            pJobProps->ulDefPrintModeID = (ULONG)WinSendDlgItemMsg (hwnd,
                                                         IDD_DEFAULT_PRINT_MODE,
                                                         LM_QUERYITEMHANDLE,
                                                         MPFROMSHORT (sIdx),
                                                         MPVOID);

            InitHalftoneAlgorithmsList (hwnd, pdi, pdi->pDevice, pJobProps);
             
            FillResolutionList (hwnd, pdi, pdi->pDevice, pJobProps->ulDefResID);
            
#ifdef DEBUG
            ShowTrueGamma (pdi->pNBI->PageInfoImageClr.hwndPage,
                           pdi,
                           pJobProps,
                           FALSE);
#endif
            return 0;
         }
         break;
      }

      case IDD_RESOLUTIONS:
      {
         SHORT          sIdx;
         PJOBPROPERTIES pJobProps = pdi->pJobProperties2;

         if (LN_SELECT != HIUSHORT (mp1))
            break;

         // List box selection code follows...
         sIdx = SHORT1FROMMR (WinSendDlgItemMsg (hwnd,
                                           IDD_RESOLUTIONS,
                                           LM_QUERYSELECTION,
                                           MPVOID, MPVOID));

         // verify user selected a resolution
         if (sIdx != LIT_NONE)
         {
            // Get Item Handle (Res ID)
            pJobProps->ulDefResID = (ULONG)WinSendDlgItemMsg (hwnd,
                                                 IDD_RESOLUTIONS,
                                                 LM_QUERYITEMHANDLE,
                                                 MPFROMSHORT (sIdx),
                                                 MPVOID);

#ifdef DEBUG
            ShowTrueGamma (pdi->pNBI->PageInfoImageClr.hwndPage,
                           pdi,
                           pJobProps,
                           FALSE);
#endif
            return 0;
         }
         break;
      }
      }

      return 0;
   }

   case WM_DESTROY:
   {
      pdi = (PDLGINSTANCE)WinQueryWindowULong (hwnd, QWL_USER);

      DBPRINTIF ((TRUE, "%s(); WM_DESTROY: hptrPortrait = %ul\n", __FUNCTION__, pdi->hptrPortrait));
      WinDestroyPointer (pdi->hptrPortrait);
      DBPRINTIF ((TRUE, "%s(); WM_DESTROY: hptrLandscape = %ul\n", __FUNCTION__, pdi->hptrLandscape));
      WinDestroyPointer (pdi->hptrLandscape);
      DBPRINTIF ((TRUE, "%s(); WM_DESTROY: hptrDuplexOne = %ul\n", __FUNCTION__, pdi->hptrDuplexOne));
      WinDestroyPointer (pdi->hptrDuplexOne);
      DBPRINTIF ((TRUE, "%s(); WM_DESTROY: hptrDuplexBook = %ul\n", __FUNCTION__, pdi->hptrDuplexBook));
      WinDestroyPointer (pdi->hptrDuplexBook);
      DBPRINTIF ((TRUE, "%s(); WM_DESTROY: hptrDuplexFlip = %ul\n", __FUNCTION__, pdi->hptrDuplexFlip));
      WinDestroyPointer (pdi->hptrDuplexFlip);

      return 0;
   }
   }

   // default for most cases
   return WinDefDlgProc (hwnd, msg, mp1, mp2);

} /* end CommonJobPropertiesDlgProc */

/****************************************************************************/
/* PROCEDURE NAME : MonoImageDlgProc                                        */
/* AUTHOR         : WMJ & Matt Rutkowski                                    */
/* DATE WRITTEN   : 11/06/93                                                */
/* DESCRIPTION    :                                                         */
/*                                                                          */
/*                  Control Flow:                                           */
/*                                                                          */
/* PARAMETERS:                                                              */
/*                                                                          */
/* RETURN VALUES:                                                           */
/*                                                                          */
/*--------------------------------------------------------------------------*/
/* CHANGE/MODIFICATION LOG :                                                */
/*--------------------------------------------------------------------------*/
/* @EXJOB  - 07/13/98 - UCC [IBMJ]- Expansible job data support             */
/*                                                                          */
/****************************************************************************/
MRESULT EXPENTRY
MonoImageDlgProc (HWND hwnd, ULONG  msg, MPARAM mp1, MPARAM mp2)
{
   /*------------------------------------------------------------------------*/
   /* LOCAL VARIABLES                                                        */
   /*------------------------------------------------------------------------*/
   PDLGINSTANCE  pdi;
   CHAR          szSlider[128];
   ULONG         ulIncrement;

   /*------------------------------------------------------------------------*/
   /* BEGIN CODE                                                             */
   /*------------------------------------------------------------------------*/
   switch (msg)
   {
   case WM_CONTROLPOINTER:
   {
      ULONG ulCtlID = LONGFROMMP (mp1);

      pdi = (PDLGINSTANCE)WinQueryWindowULong (hwnd, QWL_USER);

      if (ulCtlID != pdi->ulLastCtlID)
      {
         pdi->ulLastCtlID = ulCtlID;

         DisplayContextHelp (pdi->pHelpJobProp, pdi->hwndJobPropTxtHelp, ulCtlID);
      }
      break;
   }

   case WM_INITDLG:
   {
      ULONG  ulIdx;

      pdi = (PDLGINSTANCE)mp2;
      assertF (pdi);

      // store the pointer to instance data
      WinSetWindowULong (hwnd, QWL_USER, (ULONG)pdi);

      // Set up easy index into stringtable's context help msgs
      ulIdx = STRING_TABLE_MSG_BASE - STRING_TABLE_BASE;

      // add context help for "Monochrome" Job Properties notebook page
      AddContextHelp (pdi->pHelpJobProp, IDD_IMAGE_OPTIONS_MONO, globals.pbStringTable[ulIdx + MSG_MONO_PAGE]);
      AddContextHelp (pdi->pHelpJobProp, IDT_DARKNESS, globals.pbStringTable[ulIdx + MSG_MONO_DARKNESS]);
      AddContextHelp (pdi->pHelpJobProp, IDD_DARKNESS, globals.pbStringTable[ulIdx + MSG_MONO_DARKNESS]);
      AddContextHelp (pdi->pHelpJobProp, IDD_FOREGROUND, globals.pbStringTable[ulIdx + MSG_MONO_FG_CLR]);
      AddContextHelp (pdi->pHelpJobProp, IDD_BACKGROUND, globals.pbStringTable[ulIdx + MSG_MONO_BG_CLR]);

      InitMonoJobProps (hwnd, pdi, pdi->pJobProperties); // @EXJOB

      // set default focus
      return 0;
   }

   case WM_CONTROL:
   {
      // get instance data
      pdi = (PDLGINSTANCE)WinQueryWindowULong (hwnd, QWL_USER);
      assertF (pdi);

      if (SHORT1FROMMP(mp1) == IDD_DARKNESS)
      {
         if (SHORT2FROMMP(mp1) == SLN_CHANGE)
         {
            ulIncrement = (ULONG)WinSendDlgItemMsg (hwnd, IDD_DARKNESS,
                                              SLM_QUERYSLIDERINFO,
                                              MPFROM2SHORT (SMA_SLIDERARMPOSITION,
                                                            SMA_INCREMENTVALUE),
                                              MPVOID);

            ulIncrement -= MAX_DEVIATION;

            sprintf (szSlider, "%s = %+d%%",
                     globals.pbStringTable[STRING_TABLE_DLG_BASE - STRING_TABLE_BASE + DIALOG_DARKNESS],
                     ulIncrement);

            WinSetDlgItemText (hwnd, IDT_DARKNESS, szSlider);
         }
      }
      break;
   }

   case WM_COMMAND:
   {
      pdi = (PDLGINSTANCE)WinQueryWindowULong (hwnd, QWL_USER);

      switch (SHORT1FROMMP (mp1))
      {
      case DID_UNDO:
      {
         pdi = (PDLGINSTANCE)WinQueryWindowULong (hwnd, QWL_USER);

         InitMonoJobProps (hwnd, pdi, pdi->pJobProperties); // @EXJOB
         break;
      }

      case DID_DEFAULTS:
      {
         pdi = (PDLGINSTANCE)WinQueryWindowULong (hwnd, QWL_USER);

         InitMonoJobProps (hwnd, pdi, &(pdi->pDevice->DeviceDefaults));
         break;
      }
      }

      return 0;
   }
   }

   // default for most cases
   return WinDefDlgProc (hwnd, msg, mp1, mp2);

} /* end MonoImageDlgProc */

/****************************************************************************/
/* PROCEDURE NAME : ColorImageDlgProc                                       */
/* AUTHOR         : Matt Rutkowski                                          */
/* DATE WRITTEN   : 11/06/93                                                */
/* DESCRIPTION    :                                                         */
/*                                                                          */
/*                  Control Flow:                                           */
/*                                                                          */
/* PARAMETERS:                                                              */
/*                                                                          */
/* RETURN VALUES:                                                           */
/*                                                                          */
/*--------------------------------------------------------------------------*/
/* CHANGE/MODIFICATION LOG :                                                */
/*--------------------------------------------------------------------------*/
/*                                                                          */
/* 03/4/96  - MFR - rewrote to include new Gamma color controls             */
/* @EXJOB  - 07/13/98 - UCC [IBMJ]- Expansible job data support             */
/*                                                                          */
/****************************************************************************/
MRESULT EXPENTRY
ColorImageDlgProc (HWND hwnd, ULONG  msg, MPARAM mp1, MPARAM mp2)
{
   /*------------------------------------------------------------------------*/
   /* LOCAL VARIABLES                                                        */
   /*------------------------------------------------------------------------*/
   PDLGINSTANCE    pdi;
   CHAR            szSlider[128];
   LONG            lIncrement;
   ULONG           ulID;     // Current slider ID
   POWNERITEM      poi;      // Current slider owner-draw info
   LONG            lClr;     // Current slider bar color
   ULONG           ulText;

   /*------------------------------------------------------------------------*/
   /* BEGIN CODE                                                             */
   /*------------------------------------------------------------------------*/
   switch (msg)
   {
   case WM_CONTROLPOINTER:
   {
      ULONG ulCtlID = LONGFROMMP (mp1);

      pdi = (PDLGINSTANCE)WinQueryWindowULong (hwnd, QWL_USER);

      if (ulCtlID != pdi->ulLastCtlID)
      {
         pdi->ulLastCtlID = ulCtlID;

         DisplayContextHelp (pdi->pHelpJobProp, pdi->hwndJobPropTxtHelp, ulCtlID);
      }
      break;
   }

   case WM_INITDLG:
   {
      ULONG ul;

      pdi = (PDLGINSTANCE)mp2;
      assertF (pdi);

      // store the pointer to instance data
      WinSetWindowULong (hwnd, QWL_USER, (ULONG)pdi);

      // Set up easy index into stringtable's context help msgs
      ul = STRING_TABLE_MSG_BASE - STRING_TABLE_BASE;

      // add context help for "Color" Job Properties notebook page
      AddContextHelp (pdi->pHelpJobProp, IDD_IMAGE_OPTIONS_COLOR,
                      globals.pbStringTable[ul + MSG_COLOR_PAGE]);
 //   AddContextHelp (pdi->pHelpJobProp, IDD_LEVEL,
 //                   globals.pbStringTable[ul + MSG_CLR_DITHER_LVL]);
      AddContextHelp (pdi->pHelpJobProp, IDT_CLR_BIAS_RED,
                      globals.pbStringTable[ul + MSG_CLR_BIAS_RED]);
      AddContextHelp (pdi->pHelpJobProp, IDT_CLR_BIAS_GREEN,
                      globals.pbStringTable[ul + MSG_CLR_BIAS_GREEN]);
      AddContextHelp (pdi->pHelpJobProp, IDT_CLR_BIAS_BLUE,
                      globals.pbStringTable[ul + MSG_CLR_BIAS_BLUE]);
      AddContextHelp (pdi->pHelpJobProp, IDT_CLR_BIAS_BLACK,                 //jk1115
                      globals.pbStringTable[ul + MSG_CLR_BIAS_BLACK]);       //jk1115

      // Add gamma correction context help messages here
      AddContextHelp (pdi->pHelpJobProp, IDD_RED_GAMMA,
                      globals.pbStringTable[ul+MSG_CLR_GAMMA_RED]);
      AddContextHelp (pdi->pHelpJobProp, IDD_GREEN_GAMMA,
                      globals.pbStringTable[ul+MSG_CLR_GAMMA_GREEN]);
      AddContextHelp (pdi->pHelpJobProp, IDD_BLUE_GAMMA,
                      globals.pbStringTable[ul+MSG_CLR_GAMMA_BLUE]);
      AddContextHelp (pdi->pHelpJobProp, IDD_BLACK_GAMMA,
                      globals.pbStringTable[ul+MSG_CLR_GAMMA_BLACK]);
      AddContextHelp (pdi->pHelpJobProp, IDT_RED_GAMMA,
                      globals.pbStringTable[ul+MSG_CLR_GAMMA_RED]);
      AddContextHelp (pdi->pHelpJobProp, IDT_GREEN_GAMMA,
                      globals.pbStringTable[ul+MSG_CLR_GAMMA_GREEN]);
      AddContextHelp (pdi->pHelpJobProp, IDT_BLUE_GAMMA,
                      globals.pbStringTable[ul+MSG_CLR_GAMMA_BLUE]);
      AddContextHelp (pdi->pHelpJobProp, IDT_BLACK_GAMMA,
                      globals.pbStringTable[ul+MSG_CLR_GAMMA_BLACK]);

      InitColorJobProps (hwnd, pdi, pdi->pJobProperties); // @EXJOB

      // Initialize the gamma slider controls to values passed in
      // through caller-supplied job properties
      InitGammaSliders (hwnd, pdi, pdi->pJobProperties); // @EXJOB

      pdi->fAfterInitialization = TRUE;

#ifdef DEBUG
      AddContextHelp (pdi->pHelpJobProp, DID_ADD,
                      "Displays dialog with current RGB and K gamma tables");

      ShowTrueGamma (hwnd, pdi, pdi->pJobProperties, TRUE); // @EXJOB
#endif

      return 0;
   }

   case WM_CONTROL:
   {
      // get instance data
      pdi = (PDLGINSTANCE)WinQueryWindowULong (hwnd, QWL_USER);
      assertF (pdi);

      ulID = SHORT1FROMMP (mp1);

      switch (ulID)
      {
      case IDD_RED_GAMMA:    ulText = IDT_RED_GAMMA;   break;
      case IDD_GREEN_GAMMA:  ulText = IDT_GREEN_GAMMA; break;
      case IDD_BLUE_GAMMA:   ulText = IDT_BLUE_GAMMA;  break;
      case IDD_BLACK_GAMMA:  ulText = IDT_BLACK_GAMMA; break;
      default:               ulID = 0;                 break;
      }

      if (ulID !=0)
      {
         if (SHORT2FROMMP (mp1) == SLN_CHANGE)
         {
            lIncrement = (LONG)WinSendDlgItemMsg (hwnd, ulID,
                                                  SLM_QUERYSLIDERINFO,
                                                  MPFROM2SHORT (SMA_SLIDERARMPOSITION,
                                                                SMA_INCREMENTVALUE),
                                                  MPVOID);

            lIncrement -= MAX_DEVIATION;

            sprintf (szSlider, "%+d%%", lIncrement);

#ifdef DEBUG
            ShowTrueGamma (hwnd, pdi, pdi->pJobProperties, FALSE);
#else
            WinSetDlgItemText (hwnd, ulText, szSlider);
#endif
         }
      }
      break;
   }

   case WM_DRAWITEM:
   {
      // get instance data
      pdi = (PDLGINSTANCE)WinQueryWindowULong (hwnd, QWL_USER);

      if (pdi)
      {
         ulID = SHORT1FROMMP(mp1);

         switch (ulID)
         {
         case IDD_RED_GAMMA:
         case IDD_GREEN_GAMMA:
         case IDD_BLUE_GAMMA:
         case IDD_BLACK_GAMMA:
         {
            // retrieve owneritem structure
            poi = (POWNERITEM)PVOIDFROMMP (mp2);

            if (poi)
            {
               switch (poi->idItem)
               {
               case SDA_RIBBONSTRIP:         // 0x0001
               {
                  switch (ulID)
                  {
                  case IDD_RED_GAMMA:   lClr = CLR_RED;       break;
                  case IDD_GREEN_GAMMA: lClr = CLR_DARKGREEN; break;
                  case IDD_BLUE_GAMMA:  lClr = CLR_BLUE;      break;
                  case IDD_BLACK_GAMMA: lClr = CLR_BLACK;     break;
                  }

                  WinFillRect (poi->hps, &(poi->rclItem), lClr);

                  return (MRESULT)TRUE;
               }

               //case SDA_SLIDERSHAFT:         // 0x0002
               //case SDA_BACKGROUND:          // 0x0003
               //case SDA_SLIDERARM:           // 0x0004
               }
            }
            break;
         }
         }
      }
      break;
   }

   case WM_COMMAND:
   {
      pdi = (PDLGINSTANCE)WinQueryWindowULong (hwnd, QWL_USER);

      switch (SHORT1FROMMP (mp1))
      {
      case DID_UNDO:
      {
         pdi = (PDLGINSTANCE)WinQueryWindowULong (hwnd, QWL_USER);

         InitGammaSliders (hwnd, pdi, pdi->pJobProperties); // @EXJOB

         InitColorJobProps (hwnd, pdi, pdi->pJobProperties); // @EXJOB
         break;
      }

      case DID_DEFAULTS:
      {
         pdi = (PDLGINSTANCE)WinQueryWindowULong (hwnd, QWL_USER);

         InitGammaSliders (hwnd, pdi, &(pdi->pDevice->DeviceDefaults));

         InitColorJobProps (hwnd, pdi, &(pdi->pDevice->DeviceDefaults));
         break;
      }

#ifdef DEBUG
      case DID_ADD:
      {
         WinDlgBox (HWND_DESKTOP,
                    WinQueryActiveWindow (HWND_DESKTOP),
                    (PFNWP)GammaDlgProc,
                    globals.hModule,
                    (ULONG)IDD_GAMMA,
                    (PVOID)pdi);
         break;
      }
#endif
      }
      return 0;
   }
   }

   // default for most cases
   return WinDefDlgProc (hwnd, msg, mp1, mp2);

} /* end ColorImageDlgProc */

/****************************************************************************/
/* PROCEDURE NAME : HSVDlgProc                                              */
/* AUTHOR         : Matt Rutkowski                                          */
/* DATE WRITTEN   : 06/09/95                                                */
/* DESCRIPTION    :                                                         */
/*                                                                          */
/*                  Control Flow:                                           */
/*                                                                          */
/* PARAMETERS:                                                              */
/*                                                                          */
/* RETURN VALUES:                                                           */
/*                                                                          */
/*--------------------------------------------------------------------------*/
/* CHANGE/MODIFICATION LOG :                                                */
/*--------------------------------------------------------------------------*/
/* @EXJOB  - 07/13/98 - UCC [IBMJ]- Expansible job data support             */
/*                                                                          */
/****************************************************************************/
MRESULT EXPENTRY
HSVDlgProc (HWND hwnd, ULONG  msg, MPARAM mp1, MPARAM mp2)
{
   /*------------------------------------------------------------------------*/
   /* LOCAL VARIABLES                                                        */
   /*------------------------------------------------------------------------*/
   PDLGINSTANCE    pdi;
   CHAR            szSlider[128];
   ULONG           ulIncrement;

   /*------------------------------------------------------------------------*/
   /* BEGIN CODE                                                             */
   /*------------------------------------------------------------------------*/
   switch (msg)
   {
   case WM_CONTROLPOINTER:
   {
      ULONG ulCtlID = LONGFROMMP (mp1);

      pdi = (PDLGINSTANCE)WinQueryWindowULong (hwnd, QWL_USER);

      if (ulCtlID != pdi->ulLastCtlID)
      {
         pdi->ulLastCtlID = ulCtlID;

         DisplayContextHelp (pdi->pHelpJobProp, pdi->hwndJobPropTxtHelp, ulCtlID);
      }
      break;
   }

   case WM_INITDLG:
   {
      ULONG ulIdx;

      pdi = (PDLGINSTANCE)mp2;
      assertF (pdi);

      // store the pointer to instance data
      WinSetWindowULong (hwnd, QWL_USER, (ULONG)pdi);

      // Set up easy index into stringtable's context help msgs
      ulIdx = STRING_TABLE_MSG_BASE - STRING_TABLE_BASE;

      // add context help for "HSV" Job Properties notebook page
      AddContextHelp (pdi->pHelpJobProp, IDD_HSV, globals.pbStringTable[ulIdx + MSG_HSV_PAGE]);
      AddContextHelp (pdi->pHelpJobProp, IDT_HUE, globals.pbStringTable[ulIdx + MSG_HSV_HUE]);
      AddContextHelp (pdi->pHelpJobProp, IDD_HUE, globals.pbStringTable[ulIdx + MSG_HSV_HUE]);
      AddContextHelp (pdi->pHelpJobProp, IDT_SATURATION,  globals.pbStringTable[ulIdx + MSG_HSV_SATURATION]);
      AddContextHelp (pdi->pHelpJobProp, IDD_SATURATION,  globals.pbStringTable[ulIdx + MSG_HSV_SATURATION]);
      AddContextHelp (pdi->pHelpJobProp, IDT_CLR_DARKNESS, globals.pbStringTable[ulIdx + MSG_HSV_DARKNESS]);
      AddContextHelp (pdi->pHelpJobProp, IDD_CLR_DARKNESS, globals.pbStringTable[ulIdx + MSG_HSV_DARKNESS]);

      InitHSVJobProps (hwnd, pdi, pdi->pJobProperties); // @EXJOB

      return 0;
   }

   case WM_CONTROL:
   {
      // get instance data
      pdi = (PDLGINSTANCE)WinQueryWindowULong (hwnd, QWL_USER);
      assertF (pdi);

      if (SHORT1FROMMP (mp1) == IDD_HUE)
      {
         if (SHORT2FROMMP (mp1) == SLN_CHANGE)
         {
            ulIncrement = (ULONG)WinSendDlgItemMsg (hwnd, IDD_HUE,
                                         SLM_QUERYSLIDERINFO,
                                         MPFROM2SHORT (SMA_SLIDERARMPOSITION,
                                                       SMA_INCREMENTVALUE),
                                         MPVOID );

            // Each tick increment represents 4 degrees of color hue
            ulIncrement *= 4;
            ulIncrement -= MAX_DEGREE;

            sprintf (szSlider, "%s = %+d %s",
                     globals.pbStringTable[STRING_TABLE_DLG_BASE - STRING_TABLE_BASE + DIALOG_HUE],
                     ulIncrement,
                     globals.pbStringTable[STRING_TABLE_DLG_BASE - STRING_TABLE_BASE + DIALOG_DEGREES]);

            WinSetDlgItemText (hwnd, IDT_HUE, szSlider);
         }
      }

      if (SHORT1FROMMP(mp1) == IDD_SATURATION )
      {
         if (SHORT2FROMMP(mp1) == SLN_CHANGE)
         {
            ulIncrement = (ULONG)WinSendDlgItemMsg (hwnd, IDD_SATURATION,
                               SLM_QUERYSLIDERINFO,
                               MPFROM2SHORT (SMA_SLIDERARMPOSITION,
                                             SMA_INCREMENTVALUE),
                               MPVOID);

            ulIncrement -= MAX_DEVIATION;

            sprintf (szSlider, "%s = %+d%%",
                     globals.pbStringTable[STRING_TABLE_DLG_BASE - STRING_TABLE_BASE + DIALOG_SATURATION],
                     ulIncrement);

            WinSetDlgItemText (hwnd, IDT_SATURATION, szSlider);
         }
      }

      if (SHORT1FROMMP (mp1) == IDD_CLR_DARKNESS)
      {
         if (SHORT2FROMMP (mp1) == SLN_CHANGE)
         {
            ulIncrement= (ULONG)WinSendDlgItemMsg (hwnd, IDD_CLR_DARKNESS,
                               SLM_QUERYSLIDERINFO,
                               MPFROM2SHORT (SMA_SLIDERARMPOSITION,
                                             SMA_INCREMENTVALUE),
                               MPVOID);

            ulIncrement -= MAX_DEVIATION;

            sprintf (szSlider, "%s = %+d%%",
                     globals.pbStringTable[STRING_TABLE_DLG_BASE - STRING_TABLE_BASE + DIALOG_DARKNESS],
                     ulIncrement);

            WinSetDlgItemText (hwnd, IDT_CLR_DARKNESS, szSlider);
         }
      }
      break;
   }

   case WM_COMMAND:
   {
      pdi = (PDLGINSTANCE)WinQueryWindowULong (hwnd, QWL_USER);

      switch (SHORT1FROMMP (mp1))
      {
      case DID_UNDO:
      {
         pdi = (PDLGINSTANCE)WinQueryWindowULong (hwnd, QWL_USER);

         InitHSVJobProps (hwnd, pdi, pdi->pJobProperties); // @EXJOB
         break;
      }

      case DID_DEFAULTS:
      {
         pdi = (PDLGINSTANCE)WinQueryWindowULong (hwnd, QWL_USER);

         InitHSVJobProps (hwnd, pdi, &(pdi->pDevice->DeviceDefaults));
         break;
      }
      }

      return 0;
   }
   }

   // default for most cases
   return WinDefDlgProc (hwnd, msg, mp1, mp2);

} /* end HSVDlgProc */

/****************************************************************************/
/* PROCEDURE NAME : PrinterPropertiesDlgProc                                */
/* AUTHOR         : MFR                                                     */
/* DATE WRITTEN   : 5/26/94                                                 */
/* DESCRIPTION    :                                                         */
/*                                                                          */
/*                  Control Flow:                                           */
/*                                                                          */
/* PARAMETERS:                                                              */
/*                                                                          */
/* RETURN VALUES:                                                           */
/*                                                                          */
/*--------------------------------------------------------------------------*/
/* CHANGE/MODIFICATION LOG :                                                */
/*--------------------------------------------------------------------------*/
/* @EXJOB  - 07/13/98 - UCC [IBMJ]- Expansible job data support             */
/*                                                                          */
/****************************************************************************/
MRESULT EXPENTRY
PrinterPropertiesDlgProc (HWND hwnd, ULONG  msg, MPARAM mp1, MPARAM mp2)
{
   PDLGINSTANCE      pdi;
   PNOTEBOOKINFO     pNBI;
   PDEVICEINFO       pDevice;
   BOOL              bRC;
   APIRET            rc;

   switch (msg)
   {
   case WM_CONTROLPOINTER:
   {
      ULONG ulCtlID = LONGFROMMP (mp1);

      pdi = (PDLGINSTANCE)WinQueryWindowULong (hwnd, QWL_USER);

      if (ulCtlID != pdi->ulLastCtlID)
      {
         pdi->ulLastCtlID = ulCtlID;

         DisplayContextHelp (pdi->pHelpPrnProp, pdi->hwndPrnPropTxtHelp, ulCtlID);
      }
      break;
   }

   case WM_HITTEST:
   {
      // Simulate WM_CONTROLPOINTER for controls such as spinbutton, combo box
      GplHitTestHandler (hwnd, mp1, mp2);
      break;
   }
   case WM_INITDLG:
   {
      ULONG   ulDlgIdx;
      HWND    hwndTitlebar;
      CHAR    szTitle[2*MAX_VERNAME_SIZE];
      CHAR    szTemp[MAX_VERNAME_SIZE];
      LONG    lClr;
      RECTL   rctl;
      ULONG   cxDesktop, cyDesktop;

      pdi = (PDLGINSTANCE)mp2;

      // initial pointer validation
      assertF (pdi);

      // store the pointer to instance data
      WinSetWindowULong (hwnd, QWL_USER, (ULONG)pdi);

      DBPRINTIF ((FALSE, "%s(): INIT_DLG pdi='%p'\n", __FUNCTION__, pdi));

      // Center Printer Properties dialog on the screen
      WinQueryWindowRect (hwnd, &rctl);

      cxDesktop = WinQuerySysValue (HWND_DESKTOP, SV_CXSCREEN);
      cyDesktop = WinQuerySysValue (HWND_DESKTOP, SV_CYSCREEN);

      WinSetWindowPos (hwnd, NULLHANDLE,
                       (cxDesktop-rctl.xRight)/2,
                       (cyDesktop-rctl.yTop)/2,
                       0L,
                       0L,
                       SWP_MOVE);

      // initial pointer validation
      assertF (pdi->pDevice);
      pDevice = pdi->pDevice;

      // Get non-dithered RGB value for system defined CLR_DARKBLUE
      lClr = GpiQueryRGBColor (WinGetPS(hwnd), 0L, CLR_DARKBLUE);   // CLR_DARKRED's RGB equivalent

      // Set dialog border color to better indicate "Job Properties"
      // WinSetSysColors (HWND_DESKTOP, LCOL_PURECOLOR, LCOLF_CONSECRGB,
      //                  SYSCLR_ACTIVETITLE, 1L, &lClr);

      // Set backround of titlebar text to same color as SYSCLR_ACTIVETITLE
      hwndTitlebar = WinWindowFromID (hwnd, FID_TITLEBAR);
      WinSetPresParam (hwndTitlebar, PP_ACTIVECOLOR, 4L, &lClr);
      WinSetPresParam (hwndTitlebar, PP_ACTIVETEXTBGNDCOLOR, 4L, &lClr);

      // We are going to fill in a lot of strings from a similar location
      // in stringtable so lets get a base index to reference from
      ulDlgIdx = STRING_TABLE_DLG_BASE - STRING_TABLE_BASE;

      // Fill pushbutton text in printer Property dialog from driver's stringtable
      WinSetDlgItemText (hwnd, DID_OK,           globals.pbStringTable[ulDlgIdx + DIALOG_TEXT_SAVE]   );
      WinSetDlgItemText (hwnd, DID_CANCEL,       globals.pbStringTable[ulDlgIdx + DIALOG_TEXT_CANCEL] );
      WinSetDlgItemText (hwnd, DID_HELP,         globals.pbStringTable[ulDlgIdx + DIALOG_TEXT_HELP]   );
      WinSetDlgItemText (hwnd, DID_DEV_DEFAULTS, globals.pbStringTable[ulDlgIdx + DIALOG_DEV_DEFAULTS]);

      // Retrieve Driver Version from driver's extended attributes
      GetEAVersion (szTemp, sizeof (szTemp));

      // Build string to show in Printer Property dialog's titlebar
      sprintf (szTitle, "%s: %s: %s %s",
               globals.pbStringTable[ulDlgIdx + DIALOG_PRINTER_PROPS],
               pdi->pDevice->pszDeviceName,
               globals.pbStringTable[ulDlgIdx + DIALOG_DEV_VERSION],
               szTemp);

      // Display titlebar string (e.g. "Printer Properties: Canon BJC-600: Driver Version 7.9" )
      WinSetWindowText (hwnd, szTitle);

      // Get window handle of "context sensitive help" entryfield
      pdi->hwndPrnPropTxtHelp = WinWindowFromID (hwnd, IDD_CONTEXT_HELP);

      // Allocate a Notebook Information Structure in dialog instance data
      pdi->pNBI = (PNOTEBOOKINFO)GplMemoryAlloc (pdi->hmcbHeap, sizeof (NOTEBOOKINFO));

      // Validate notebook inforamtion structure pointer and create local copy
      assertF (pdi->pNBI);
      pNBI = pdi->pNBI;

      //----------------------------------------------------------------------
      // Initialize things outside Notebook itself
      //----------------------------------------------------------------------

      // Create a linked list for holding context help messages
      CreateContextHelp (&(pdi->pHelpPrnProp));

      // Set up easy index into stringtable's context help msgs
      ulDlgIdx = STRING_TABLE_MSG_BASE - STRING_TABLE_BASE;

      // Initialize current Control ID to invalid value
      pdi->ulLastCtlID = 0;

      // Add help messages for Printer Properties buttons
      AddContextHelp (pdi->pHelpPrnProp, DID_OK,      globals.pbStringTable[ulDlgIdx + MSG_PRN_OK]);
      AddContextHelp (pdi->pHelpPrnProp, DID_CANCEL,  globals.pbStringTable[ulDlgIdx + MSG_PRN_CANCEL]);
      AddContextHelp (pdi->pHelpPrnProp, DID_HELP,    globals.pbStringTable[ulDlgIdx + MSG_PRN_HELP]);
      AddContextHelp (pdi->pHelpPrnProp, DID_DEV_DEFAULTS, globals.pbStringTable[ulDlgIdx + MSG_PRN_DEV_DEFS]);
      AddContextHelp (pdi->pHelpPrnProp, DID_UNDO,    globals.pbStringTable[ulDlgIdx + MSG_PRN_UNDO]);
      AddContextHelp (pdi->pHelpPrnProp, DID_DEFAULTS,globals.pbStringTable[ulDlgIdx + MSG_PRN_DEFAULTS]);

      // Add context help messages for "Printer Properties" dialog items
      AddContextHelp (pdi->pHelpPrnProp, IDD_PRINTER_PROPERTIES_NB, globals.pbStringTable[ulDlgIdx + MSG_PRN_NOTEBOOK]);
      AddContextHelp (pdi->pHelpPrnProp, IDD_CONTEXT_HELP, globals.pbStringTable[ulDlgIdx + MSG_CTX_HELP]);

      // Read in printer properties from INI file
      bRC = ReadPrinterProperties (pdi->szAppName, &pdi->PrnProperties, pdi->pDevice);
      assertF (bRC);

      // read in user defined values from INI file to linked list
      bRC = ReadUserDefinedTrayList (pdi->szAppName, pDevice);
      assertF (bRC);

      // read in user defined values from INI file to linked list
      bRC = ReadUserDefinedFormList (pdi->szAppName, pDevice);
      assertF (bRC);

      // read in user defined values from INI file to linked list
      bRC = ReadUserDefinedConnectList (pdi->szAppName, pDevice);
      assertF (bRC);

      // read in user defined values from INI file to linked list
      bRC = ReadUserDefinedFontList (pdi->szAppName, pDevice);
      assertF (bRC);

      pdi->pNBI->ulNBID = IDD_PRINTER_PROPERTIES_NB;
      pdi->pNBI->hwndNB = WinWindowFromID (hwnd, IDD_PRINTER_PROPERTIES_NB);

      // This sets color around outside of notebook  (we want gray)
      lClr = SYSCLR_DIALOGBACKGROUND;
      WinSetPresParam (pdi->pNBI->hwndNB,
                       PP_BACKGROUNDCOLORINDEX, sizeof (lClr), &lClr);

      // Set Color for "Foreground" page and it's Major Tab
      WinSendMsg (pdi->pNBI->hwndNB, BKM_SETNOTEBOOKCOLORS,
                  MPFROMLONG (lClr),
                  MPFROMLONG (BKA_BACKGROUNDPAGECOLORINDEX));

      // Set Color for "Background" pages and their tabs
      WinSendMsg (pdi->pNBI->hwndNB, BKM_SETNOTEBOOKCOLORS,
                  MPFROMLONG (SYSCLR_PAGEBACKGROUND),
                  MPFROMLONG (BKA_BACKGROUNDMAJORCOLORINDEX));

      // Add all Built and user-defined Printer Property Notebook Pages
      FillPrinterPropertiesNotebook (hwnd, pdi);

      
      // printer properties
      pdi->hPPNotebookInst = GplJFCreateNotebookInstance (hwnd,
                                                          IDD_PRINTER_PROPERTIES_NB,
                                                          WinWindowFromID (hwnd, IDD_CONTEXT_HELP),
                                                          pdi->hwndHelp,
                                                          globals.hModule,
                                                          pdi->szAppName,
                                                          globals.pvSharedHeap);
      InitWebDownloadPage(pdi);
      

      // Set Tab dimensions for Major tabs
      // based upon maximum Tab Text of all pages inserted into notebook
      WinSendDlgItemMsg (hwnd, pdi->pNBI->ulNBID,
                         BKM_SETDIMENSIONS,
                         MPFROM2SHORT ((SHORT)(pdi->pNBI->cxMajor+WIDTH_SPACE),
                         (SHORT)(2*pdi->pNBI->cyMajor)),
                         MPFROMSHORT (BKA_MAJORTAB));

      // Select "Form Connection" to be topmost page
      WinSendMsg (pdi->pNBI->hwndNB,
                  BKM_TURNTOPAGE,
                  MPFROMLONG (pNBI->PageInfoFormConnect.ulPageID),
                  MPVOID);

      // Set text limit of entry field to a much larger value
      WinSendDlgItemMsg (hwnd, IDD_CONTEXT_HELP,
                         EM_SETTEXTLIMIT,
                         MPFROMLONG (MAX_CTX_HELP_STRING),
                         MPVOID);

      // done initializing dlg box
      return 0L;
   }

   case HM_QUERY_KEYS_HELP:
      return (MRESULT)PANEL_PRINTER_PROPERTIES;

   case WM_HELP:
   {
#ifdef DEBUG
      USHORT usCmd    = SHORT1FROMMP (mp1);
      USHORT usSource = SHORT1FROMMP (mp2);
#endif

      pdi = (PDLGINSTANCE)WinQueryWindowULong (hwnd, QWL_USER);

      DBPRINTIF ((FALSE, "%s(); WM_HELP: usCmd=%d, usSource=%d\n", __FUNCTION__, usCmd, usSource));

      // send help along if we have a valid help instance
      if (pdi->hwndHelp)
      {
         WinSendMsg (pdi->hwndHelp, HM_DISPLAY_HELP,
                     MPFROMSHORT (PANEL_PRINTER_PROPERTIES),
                     MPFROMSHORT (HM_RESOURCEID));
      }

      return 0L;
   }

   // @RME01 begin
   case WM_CLOSE:
   {
#if defined (USE_LEXMARK_STYLE) || defined (DONT_USE_LEXMARK_STYLE)
      ULONG      ulResponse;      /* return code from WinMessageBox */
#endif

      pdi = (PDLGINSTANCE) WinQueryWindowULong (hwnd, QWL_USER);

#if defined (USE_LEXMARK_STYLE) || defined (DONT_USE_LEXMARK_STYLE)
      ulResponse = WinMessageBox (HWND_DESKTOP,
                                  NULLHANDLE,
                                  globals.pbStringTable[STRING_TABLE_WARN_BASE - STRING_TABLE_BASE + WARNING_STRING_CHANGES_LOST],
                                  pdi->pszDeviceName,
                                  0,
                                  MB_ICONQUESTION | MB_YESNO);

#ifdef USE_LEXMARK_STYLE
      if (ulResponse == MBID_YES)
         WinPostMsg (hwnd, WM_QUIT, (MPARAM)0, (MPARAM)0);
      else if (ulResponse == MBID_NO)
         return FALSE;
#else
      if (ulResponse == MBID_NO)
      {
         bRC = DlgSavePrinterProperties (pdi->szAppName, pdi);
         assertF (bRC);

         // save current user tray list to INI
         bRC = SaveUserDefinedTrayList (pdi->szAppName, pDevice);
         assertF (bRC);

         // save current user form list to INI
         bRC = SaveUserDefinedFormList (pdi->szAppName, pDevice);
         assertF (bRC);

         // save current user font list to INI
         bRC = SaveUserDefinedFontList (pdi->szAppName, pDevice);
         assertF (bRC);

#ifdef DEBUG
         SaveDebugFunctionList (pdi->hwndDebugDlg, pdi);
         // @EXJOB
         DebugOutputJobProperties (TRUE, "DRIVDATA saved from DPDM_CHANGEPROP", pdi->pJobProperties);
#endif

         //save a copy of "Device Default" DRIVDATA to OS2SYS.INI
// begin @EXJOB
         bRC = PrfWriteProfileData (HINI_SYSTEMPROFILE,
                                    pdi->szAppName,
                                    KEYNAME_DRIVERDATA,
                                    pdi->pJobProperties,
                                    pdi->ulJobProperties);

//       bRC = PrfWriteProfileData (HINI_SYSTEMPROFILE,
//                                  pdi->szAppName,
//                                  KEYNAME_DRIVERDATA,
//                                  pdi->JobProperties,
//                                  sizeof (pdi->JobProperties));
// end @EXJOB
         assertF (bRC);
      }
#endif
#endif
      // Free help manager here because it fails at WM_DESTROY
      DestroyHelpInstance (pdi, TRUE);

      break;
   }
   // @RME01 end

   case WM_DESTROY:
   {
      pdi = (PDLGINSTANCE)WinQueryWindowULong (hwnd, QWL_USER);

      DBPRINTIF ((FALSE, "%s(); WM_DESTROY\n", __FUNCTION__));

      // initial pointer validation
      assertF (pdi->pDevice);
      pDevice = pdi->pDevice;

      // Reset OS/2 system SYSCLR_ACTIVETITLE back to defaults
      // WinSetSysColors (HWND_DESKTOP, LCOL_RESET, LCOLF_CONSECRGB,
      //                  SYSCLR_ACTIVETITLE, 0L, NULL);

      WinSendDlgItemMsg (hwnd,
                         IDD_PRINTER_PROPERTIES_NB,
                         BKM_DELETEPAGE,
                         0L, (MPARAM)BKA_ALL);

      // free up context help linked list
      DestroyContextHelp (pdi->pHelpPrnProp);

      // free user-defined resource lists after saved to INI file
      FreeUserDefinedTrayList (pDevice);
      FreeUserDefinedFormList (pDevice);
      FreeConnectionList (pDevice);
      FreeUserDefinedFontList (pDevice);

      rc = GplMemoryFree (pdi->pFI);
      assertT (rc);

      FreeDialogDevice (pdi, DEVICE_QUERY_PRN_DIALOGS);

      GplWebDestroyPage(0, pdi->hWebPagePgInst);               
      GplJFDestroyNotebookInstance(pdi->hPPNotebookInst);      

      break;
   }

   case WM_COMMAND:
   {
      // get instance data
      pdi = (PDLGINSTANCE)WinQueryWindowULong (hwnd, QWL_USER);

      // initial pointer validation
      assertF (pdi->pDevice);
      pDevice = pdi->pDevice;
      pNBI = pdi->pNBI;

      switch (SHORT1FROMMP (mp1))
      {
      case DID_OK:
      {
         // Save out Main Printer Properties data structure to INI
         bRC = DlgSavePrinterProperties (pdi->szAppName, pdi);
         assertF (bRC);

         // save current user tray list to INI
         bRC = SaveUserDefinedTrayList (pdi->szAppName, pDevice);
         assertF (bRC);

         // save current user form list to INI
         bRC = SaveUserDefinedFormList (pdi->szAppName, pDevice);
         assertF (bRC);

         // save current user form connection list to INI
         bRC = SaveUserDefinedConnectList (pdi->szAppName, pDevice);
         assertF (bRC);

         // save current user font list to INI
         bRC = SaveUserDefinedFontList (pdi->szAppName, pDevice);
         assertF (bRC);

         
         GplWebSaveSettings (pdi->hWebPagePgInst);                        

#ifdef DEBUG
         SaveDebugFunctionList (pdi->hwndDebugDlg, pdi);
         // @EXJOB
         DebugOutputJobProperties (FALSE, "DRIVDATA saved from DPDM_CHANGEPROP", pdi->pJobProperties);
#endif

         // Free help manager here because it fails at WM_DESTROY
         DestroyHelpInstance (pdi, TRUE);

         // save a copy of "Device Default" DRIVDATA to OS2SYS.INI
// begin @EXJOB
         bRC = PrfWriteProfileData (HINI_SYSTEMPROFILE,
                                    pdi->szAppName,
                                    KEYNAME_DRIVERDATA,
                                    pdi->pJobProperties,
                                    pdi->ulJobProperties);

//       bRC = PrfWriteProfileData (HINI_SYSTEMPROFILE,
//                                  pdi->szAppName,
//                                  KEYNAME_DRIVERDATA,
//                                  pdi->JobProperties,
//                                  sizeof (pdi->JobProperties));
// end @EXJOB
         assertF (bRC);

         WinDismissDlg (hwnd, DID_OK);
         break;
      }

      case DID_CANCEL:
      {
#if defined (USE_LEXMARK_STYLE) || defined (DONT_USE_LEXMARK_STYLE)

#ifdef USE_LEXMARK_STYLE
         // @RME01 begin

         ULONG      ulResponse;      /* return code from WinMessageBox */

         ulResponse = WinMessageBox (HWND_DESKTOP,
                                     NULLHANDLE,
                                     globals.pbStringTable[STRING_TABLE_WARN_BASE - STRING_TABLE_BASE + WARNING_STRING_CHANGES_LOST],
                                     pdi->pszDeviceName,
                                     0,
                                     MB_ICONQUESTION | MB_YESNO);

         if (ulResponse == MBID_NO)
            break;

         // @RME01 end
#endif
#endif

         // Free help manager here because it fails at WM_DESTROY
         DestroyHelpInstance (pdi, TRUE);

         WinDismissDlg (hwnd, DID_CANCEL);
         break;
      }

      case DID_DEV_DEFAULTS:
      {
         ULONG  ulDlgOK;

         // Indicate that we are calling job properties dialog
         // from printer props as a result of user selecting
         // "Device Defaults"
         pdi->bDeviceDefaults = TRUE;

         pdi->hwndJobProp = WinLoadDlg (HWND_DESKTOP,
                                        hwnd,
                                        (PFNWP)JobPropertiesDlgProc,
                                        globals.hModule,
                                        IDD_JOB_PROPERTIES,
                                        (PVOID)pdi);

/////////CreateHelpInstance (pdi, FALSE);

         ulDlgOK = WinProcessDlg (pdi->hwndJobProp);
         FreeDialogDevice (pdi, DEVICE_QUERY_JOB_DIALOGS);  //@JPN2H99

         // We must call WinDestroyWindow() ourselves for WinProcessDlg()
         // does not send it on exit as WinDlgBox() does
         WinDestroyWindow (pdi->hwndJobProp);

#ifdef DEBUG
         // @EXJOB
         DebugOutputJobProperties (FALSE, "Default Job Properties returns:", pdi->pJobProperties);
#endif

// begin @EXJOB
         pdi->StateData.ulCalledDeviceQueryDialogs = 0;
// end @EXJOB
         pdi->bDeviceDefaults = FALSE;  // just to be safe

         if (ulDlgOK == DID_ERROR)
         {
            DBPRINTF (("%s(); Unable to load Job Properties Dialog\n", __FUNCTION__));
            assertT (ulDlgOK == DID_ERROR);
         }
         break;
      }
      }

      return 0L;
   }
   }

#ifndef DEBUG
   rc++;          // Avoid compiler warnings
   bRC++;         // Avoid compiler warnings
#endif

   // default for most cases
   return WinDefDlgProc (hwnd, msg, mp1, mp2);

} /* end PrinterPropertiesDlgProc */

/****************************************************************************/
/* PROCEDURE NAME : FormConnectionDlgProc                                   */
/* AUTHOR         : MFR                                                     */
/* DATE WRITTEN   : 9/22/92                                                 */
/* DESCRIPTION    :                                                         */
/*                                                                          */
/*                  Control Flow:                                           */
/*                                                                          */
/* PARAMETERS:                                                              */
/*                                                                          */
/* RETURN VALUES:                                                           */
/*                                                                          */
/*--------------------------------------------------------------------------*/
/* CHANGE/MODIFICATION LOG :                                                */
/*--------------------------------------------------------------------------*/
/* @EXJOB  - 07/13/98 - UCC [IBMJ]- Expansible job data support             */
/*                                                                          */
/****************************************************************************/
MRESULT EXPENTRY
FormConnectionDlgProc (HWND hwnd, ULONG  msg, MPARAM mp1, MPARAM mp2)
{
   PDLGINSTANCE  pdi;
   SHORT         sIdx;
   BOOL          bRC;
   PDEVICEINFO   pDevice;

   switch (msg)
   {
   case WM_CONTROLPOINTER:
   {
      ULONG ulCtlID = LONGFROMMP (mp1);

      pdi = (PDLGINSTANCE)WinQueryWindowULong (hwnd, QWL_USER);

      if (ulCtlID != pdi->ulLastCtlID)
      {
         pdi->ulLastCtlID = ulCtlID;

         DisplayContextHelp (pdi->pHelpPrnProp, pdi->hwndPrnPropTxtHelp, ulCtlID);
      }

      break;
   }

   case WM_INITDLG:
   {
      ULONG ulIdx;

      pdi = (PDLGINSTANCE)mp2;

      pdi->hwndConnectDlg = hwnd;
      pDevice = pdi->pDevice;

      // store the pointer to instance data
      WinSetWindowULong (hwnd, QWL_USER, (ULONG)pdi);

      // Set up easy index into stringtable's context help msgs
      ulIdx = STRING_TABLE_MSG_BASE - STRING_TABLE_BASE;

      // add context help for "Form" Printer Properties notebook page
      AddContextHelp (pdi->pHelpPrnProp, IDD_FORM_CONNECTIONS, globals.pbStringTable[ulIdx + MSG_CONNECT_PAGE]);
      AddContextHelp (pdi->pHelpPrnProp, IDL_FORM_SOURCE, globals.pbStringTable[ulIdx + MSG_CONNECT_TRAY]);
      AddContextHelp (pdi->pHelpPrnProp, IDL_FORMS,       globals.pbStringTable[ulIdx + MSG_CONNECT_SIZE]);
      AddContextHelp (pdi->pHelpPrnProp, IDL_FORM_MEDIAS, globals.pbStringTable[ulIdx + MSG_CONNECT_MEDIA]);
      AddContextHelp (pdi->pHelpPrnProp, IDL_FORM_CONN,   globals.pbStringTable[ulIdx + MSG_CONNECT_CONNECT]);
      AddContextHelp (pdi->pHelpPrnProp, IDP_ADD_CONN,    globals.pbStringTable[ulIdx + MSG_CONNECT_ADD]);
      AddContextHelp (pdi->pHelpPrnProp, IDP_REMOVE_CONN, globals.pbStringTable[ulIdx + MSG_CONNECT_REMOVE]);

      // Fill in all known forms
      FillFormList (hwnd, pdi, pDevice, IDL_FORMS);

      // Fill in all known Trays
      FillTrayList (hwnd, pdi, pDevice, IDL_FORM_SOURCE);

      // Fill in all known Trays
      FillMediaList (hwnd, pdi, pDevice, IDL_FORM_MEDIAS);

      // Fill in all known connects
      FillConnectionList (hwnd, pdi, pDevice, IDL_FORM_CONN,
                          pdi->pJobProperties->ulDefConnID); // @EXJOB

      // return since we handled init
      return 0;
   }

   case WM_CONTROL:
   {
      ULONG ulConnID, ulTrayID, ulFormID, ulMediaID;

      // get instance data
      pdi = (PDLGINSTANCE)WinQueryWindowULong (hwnd, QWL_USER);

      switch (SHORT1FROMMP (mp1))
      {
      case IDL_FORM_CONN:
      {
         // get currently selected Form Connection
         sIdx = SHORT1FROMMR (WinSendDlgItemMsg (hwnd,
                                                 IDL_FORM_CONN,
                                                 LM_QUERYSELECTION,
                                                 0L, 0L));

         // verify user selected listbox field
         if (sIdx != LIT_NONE)
         {
            ULONG ulIdx;

            // Get Item Handle (Connection ID)
            ulConnID = (ULONG)WinSendDlgItemMsg (hwnd,
                                                 IDL_FORM_CONN,
                                                 LM_QUERYITEMHANDLE,
                                                 MPFROMSHORT (sIdx),
                                                 MPVOID);

            GetIDsFromConnID (pdi->pDriver, pdi->pDevice, ulConnID,
                              &ulTrayID, &ulFormID, &ulMediaID);

            SelectItemFromHandle (pdi, hwnd, IDL_FORM_SOURCE, ulTrayID);
            SelectItemFromHandle (pdi, hwnd, IDL_FORMS,       ulFormID);
            SelectItemFromHandle (pdi, hwnd, IDL_FORM_MEDIAS, ulMediaID);

            // Indicate if the form is "built-in" or "user-defined"
            if (HIUSHORT (ulConnID))
               ulIdx = DIALOG_STRING_CONN_USERID - STRING_TABLE_BASE;
            else
               ulIdx = DIALOG_STRING_CONN_ID - STRING_TABLE_BASE;

            // Display "Built-in" or "user-defined" on dialog
            WinSetWindowText (WinWindowFromID (hwnd, IDD_CONN_TYPE),
                              globals.pbStringTable[ulIdx]);
         }
      }
      }

      break;
   }

   case WM_COMMAND:
   {
      // get instance data
      pdi = (PDLGINSTANCE)WinQueryWindowULong (hwnd, QWL_USER);

      switch (SHORT1FROMMP (mp1))
      {
      case DID_UNDO:
      {
         pDevice = pdi->pDevice;

         FreeConnectionList (pDevice);

         bRC = ReadUserDefinedConnectList (pdi->szAppName, pDevice);
         assertF (bRC);

         // Fill in all known connects
         FillConnectionList (hwnd, pdi, pDevice, IDL_FORM_CONN,
                             pdi->pJobProperties->ulDefConnID); // @EXJOB
         break;
      }

      case DID_DEFAULTS:
      {
         pDevice = pdi->pDevice;

         FreeConnectionList (pDevice);

         // Fill in all known connects
         if (pdi->ctryInfo.country == COUNTRYCODE_USA    ||
             pdi->ctryInfo.country == COUNTRYCODE_CANADA  )
            FillConnectionList (hwnd, pdi, pDevice, IDL_FORM_CONN,
                                pdi->pJobProperties->ulDefNonMetricConnID); // @EXJOB
         else
            FillConnectionList (hwnd, pdi, pDevice, IDL_FORM_CONN,
                                pdi->pJobProperties->ulDefConnID); // @EXJOB
           break;
      }

      case IDP_ADD_CONN:
      {
         CHAR  szFormName[LEN_STRING],
               szTrayName[LEN_STRING],
               szMediaName[LEN_STRING];
         CHAR  szConnect[LEN_STRING+LEN_STRING];  // @TBD - dynamically alloc - MFR
         ULONG ulUserTrayID, ulUserFormID, ulUserMediaID;

         // get currently selected Tray
         sIdx = SHORT1FROMMR (WinSendDlgItemMsg (hwnd,
                                                 IDL_FORM_SOURCE,
                                                 LM_QUERYSELECTION,
                                                 0L,
                                                 0L));

         // verify user selected a source tray
         if (sIdx != LIT_NONE)
         {
            // Get Item Handle (Tray ID)
            ulUserTrayID = (ULONG)WinSendDlgItemMsg (hwnd,
                                                     IDL_FORM_SOURCE,
                                                     LM_QUERYITEMHANDLE,
                                                     MPFROMSHORT (sIdx),
                                                     MPVOID);

            // get currently selected Form
            sIdx = SHORT1FROMMR (WinSendDlgItemMsg (hwnd,
                                                    IDL_FORMS,
                                                    LM_QUERYSELECTION,
                                                    0L,
                                                    0L));

            // verify Form Name selected
            if (sIdx != LIT_NONE)
            {
               FORMCONNECTION FormConn;

               // Get Item Handle (Tray ID)
               ulUserFormID = (ULONG)WinSendDlgItemMsg (hwnd,
                                                        IDL_FORMS,
                                                        LM_QUERYITEMHANDLE,
                                                        MPFROMSHORT (sIdx),
                                                        MPVOID);

               // get currently selected Media Type
               sIdx = SHORT1FROMMR (WinSendDlgItemMsg (hwnd,
                                                       IDL_FORM_MEDIAS,
                                                       LM_QUERYSELECTION,
                                                       0L,
                                                       0L));

               // verify Media Type selected
               if (sIdx != LIT_NONE)
               {
                  // Get Item Handle (Tray ID)
                  ulUserMediaID = (ULONG)WinSendDlgItemMsg (hwnd,
                                                            IDL_FORM_MEDIAS,
                                                            LM_QUERYITEMHANDLE,
                                                            MPFROMSHORT (sIdx),
                                                            MPVOID);

                  // create a connection ID
                  FormConn.ulConnID  = CreateUniqueConnectID (pdi->pDevice);
                  FormConn.ulTrayID  = ulUserTrayID;
                  FormConn.ulFormID  = ulUserFormID;
                  FormConn.ulMediaID = ulUserMediaID;

                  if (IsConnectionUnique (pdi, &FormConn))
                  {
                     // Add the new connection to linked list
                     if (AddConnectionEntry (pdi->pDevice, &FormConn) == TRUE)
                     {
                        bRC = TrayNameFromID (pdi->pDriver, pdi->pDevice, szTrayName, ulUserTrayID);
                        assertF (bRC);

                        bRC = FormNameFromID (pdi->pDriver, pdi->pDevice, szFormName, ulUserFormID);
                        assertF (bRC);

                        bRC = MediaNameFromID (pdi->pDriver, pdi->pDevice, szMediaName, ulUserMediaID);
                        assertF (bRC);

                        // Build connect string to place in list box
                        sprintf (szConnect, "%s : %s : %s",
                                 szTrayName,
                                 szFormName,
                                 szMediaName);

                        // Temp add new form to "Form Connection" list box
                        sIdx = (SHORT)WinSendDlgItemMsg (hwnd,
                                                         IDL_FORM_CONN,
                                                         LM_INSERTITEM,
                                                         MPFROM2SHORT (LIT_END, 0),
                                                         MPFROMP (szConnect));

                        // Set Item Handle to be the Connect ID
                        WinSendDlgItemMsg (hwnd,
                                           IDL_FORM_CONN,
                                           LM_SETITEMHANDLE,
                                           MPFROMSHORT (sIdx),
                                           MPFROMLONG (FormConn.ulConnID));

                        // Show the newly created Form Connection in list
                        WinSendDlgItemMsg (hwnd,
                                           IDL_FORM_CONN,
                                           LM_SELECTITEM,
                                           MPFROMSHORT (sIdx),
                                           MPFROMLONG (TRUE));
                     }
                  }
                  else
                  {
                     // WARNING: A connection w/ Tray, Size, and Media already exists
                     WinMessageBox (HWND_DESKTOP,
                                    NULLHANDLE,
                                    globals.pbStringTable[STRING_TABLE_WARN_BASE - STRING_TABLE_BASE + WARNING_ADD_MSG_CONNECT],
                                    globals.pbStringTable[STRING_TABLE_WARN_BASE - STRING_TABLE_BASE + WARNING_ADD_CONNECT],
                                    1L,
                                    MB_OK | MB_INFORMATION);
                  }
               }
               else
               {
                  // @TBD - add media warnings to stringtable - MFR
                  // Inform user how to create a form connection
                  // a form needs to be selected in this case
                  WinMessageBox (HWND_DESKTOP,
                                 NULLHANDLE,
                                 globals.pbStringTable[STRING_TABLE_WARN_BASE - STRING_TABLE_BASE + WARNING_SELECT_MSG_FORM],
                                 globals.pbStringTable[STRING_TABLE_WARN_BASE - STRING_TABLE_BASE + WARNING_ADD_CONNECT],
                                 1L,
                                 MB_OK | MB_INFORMATION);
               }
            }
            else
            {
               // Inform user how to create a form connection
               // a form needs to be selected in this case
               WinMessageBox (HWND_DESKTOP,
                              NULLHANDLE,
                              globals.pbStringTable[STRING_TABLE_WARN_BASE - STRING_TABLE_BASE + WARNING_SELECT_MSG_FORM],
                              globals.pbStringTable[STRING_TABLE_WARN_BASE - STRING_TABLE_BASE + WARNING_ADD_CONNECT],
                              1L,
                              MB_OK | MB_INFORMATION);
            }
         }
         else
         {
            // Inform user how to create a form connection
            // a tray needs to be selected in this case
            WinMessageBox (HWND_DESKTOP,
                           NULLHANDLE,
                           globals.pbStringTable[STRING_TABLE_WARN_BASE - STRING_TABLE_BASE + WARNING_SELECT_MSG_TRAY],
                           globals.pbStringTable[STRING_TABLE_WARN_BASE - STRING_TABLE_BASE + WARNING_ADD_CONNECT],
                           1L,
                           MB_OK | MB_INFORMATION);
         }

         break;
      }

      case IDP_REMOVE_CONN:
      {
         ULONG        ulConnID;

         // get currently selected Connection to be deleted
         sIdx = SHORT1FROMMR (WinSendDlgItemMsg (hwnd,
                                                 IDL_FORM_CONN,
                                                 LM_QUERYSELECTION,
                                                 0L,
                                                 0L));

         // verify user selected a connection to delete
         if (sIdx != LIT_NONE)
         {
            // Get Item Handle (Conn ID)
            ulConnID = (ULONG)WinSendDlgItemMsg (hwnd,
                                                 IDL_FORM_CONN,
                                                 LM_QUERYITEMHANDLE,
                                                 MPFROMSHORT (sIdx),
                                                 MPVOID);

            if (ulConnID & DEF_TYPE_USER)
            {
               // Find Connection entry in linked list or in INI
               DeleteConnectionEntry (pdi->pDevice, ulConnID);

               // remove listbox entry
               WinSendDlgItemMsg (hwnd,
                                  IDL_FORM_CONN,
                                  LM_DELETEITEM,
                                  MPFROMSHORT (sIdx),
                                  MPVOID);

               // @TBD - highlite index may need to check if no match found
               // what to do as default then
               WinSendDlgItemMsg (hwnd,
                                  IDL_FORM_CONN,
                                  LM_SELECTITEM,
                                  MPFROMLONG (0),
                                  MPFROMLONG (TRUE));
            }
            else
            {
               // Inform user that only user defined conns are deletable
               WinMessageBox (HWND_DESKTOP,
                              NULLHANDLE,
                              globals.pbStringTable[STRING_TABLE_WARN_BASE - STRING_TABLE_BASE + WARNING_DELETE_MSG_CONNECT],
                              globals.pbStringTable[STRING_TABLE_WARN_BASE - STRING_TABLE_BASE + WARNING_DELETE_CONNECT],
                              1L,
                              MB_OK | MB_INFORMATION);
            }
         }
         else
         {
            // Inform user how to create a form connection
            // a tray needs to be selected in this case
            WinMessageBox (HWND_DESKTOP,
                           NULLHANDLE,
                           globals.pbStringTable[STRING_TABLE_WARN_BASE - STRING_TABLE_BASE + WARNING_DELETE_MSG_CONNECT],
                           globals.pbStringTable[STRING_TABLE_WARN_BASE - STRING_TABLE_BASE + WARNING_DELETE_CONNECT],
                           1L,
                           MB_OK | MB_INFORMATION);
         }

         break;
      }
      }

      return 0;
   }
   }

#ifndef DEBUG
   bRC++;          // Avoid compiler warnings
#endif

   // default for most cases
   return WinDefDlgProc (hwnd, msg, mp1, mp2);

} /* end FormConnectionDlgProc */

/****************************************************************************/
/* PROCEDURE NAME : FontDlgProc                                             */
/* AUTHOR         : MFR                                                     */
/* DATE WRITTEN   : 9/22/92                                                 */
/* DESCRIPTION    :                                                         */
/*                                                                          */
/*                  Control Flow:                                           */
/*                                                                          */
/* PARAMETERS:                                                              */
/*                                                                          */
/* RETURN VALUES:                                                           */
/*                                                                          */
/*--------------------------------------------------------------------------*/
/* CHANGE/MODIFICATION LOG :                                                */
/*--------------------------------------------------------------------------*/
/*                                                                          */
/****************************************************************************/
MRESULT EXPENTRY
FontDlgProc (HWND hwnd, ULONG  msg, MPARAM mp1, MPARAM mp2)
{
   /*------------------------------------------------------------------------*/
   /* LOCAL VARIABLES                                                        */
   /*------------------------------------------------------------------------*/
   PDLGINSTANCE  pdi;

   /*------------------------------------------------------------------------*/
   /* BEGIN CODE                                                             */
   /*------------------------------------------------------------------------*/
   switch (msg)
   {
   case WM_INITDLG:
   {
      pdi = (PDLGINSTANCE)mp2;

      pdi->hwndFontDlg = hwnd;

      // store the pointer to instance data
      WinSetWindowULong (hwnd, QWL_USER, (ULONG)pdi);

      WinEnableControl (hwnd, DID_DEFAULTS, FALSE);
      WinEnableControl (hwnd, DID_UNDO, FALSE);

      // Fill in all known fonts/metrics into Printer Properties NB page
      FillFontList (hwnd, pdi, pdi->pDevice, IDD_FONT_LIST);

      // return since we handled init
      return 0;
   }

   case WM_COMMAND:
   {
      return 0;
   }

   case WM_CONTROL:
   {
      SHORT         sIdx;

      // get instance data
      pdi = (PDLGINSTANCE)WinQueryWindowULong (hwnd, QWL_USER);

      switch (SHORT1FROMMP (mp1))
      {
      case IDD_FONT_LIST:
      {
         if (SHORT2FROMMP (mp1) == LN_SELECT)
         {
            // get currently selected Form Connection
            sIdx = SHORT1FROMMR (WinSendDlgItemMsg (hwnd,
                                                    IDD_FONT_LIST,
                                                    LM_QUERYSELECTION,
                                                    0L,
                                                    0L));

            // verify user selected listbox field
            if (sIdx != LIT_NONE)
            {
               ULONG         ulFontID;
               PFONTINFO2    pFontInfo      = NULL;
               PFOCAFONT     pFocaFont      = NULL;
               LONG          lPointSize     = 0;

               // Get Item Handle (Connection ID)
               ulFontID = (ULONG)WinSendDlgItemMsg (hwnd,
                                                    IDD_FONT_LIST,
                                                    LM_QUERYITEMHANDLE,
                                                    MPFROMSHORT (sIdx),
                                                    MPVOID);

               if (!ulFontID)
                  break;

               DBPRINTF (("%s: handle = %08X\n", __FUNCTION__, ulFontID));

               DBPRINTF (("%s: FontIdFromLMatch returns %d, lPointSize = %d\n",
                          __FUNCTION__,
                          FontIdFromLMatch (pdi->pDriver,
                                            pdi->pDevice,
                                            ulFontID,
                                            &lPointSize),
                          lPointSize));

               FontInfoFromID (pdi->pDriver,
                               pdi->pDevice,
                               FontIdFromLMatch (pdi->pDriver,
                                                 pdi->pDevice,
                                                 ulFontID,
                                                 &lPointSize),
                               &pFontInfo);

               DBPRINTF (("%s: pFontInfo = %08X\n", __FUNCTION__, pFontInfo));

               if (!pFontInfo)
                  break;

               DBPRINTF (("%s: resolution is at (%d, %d)\n",
                          __FUNCTION__,
                          pdi->pRes->ulXRes,
                          pdi->pRes->ulYRes));
               if (!ReadFocaMetricsFile (pdi->hmcbHeap,
                                         pFontInfo,
                                         &pFocaFont,
                                         pdi->pRes,
                                         lPointSize))
                  break;

               if (!pFocaFont)
                  break;

               FillFocaMetricsListBox (hwnd,
                                       IDD_FOCAMETRICS,
                                       pdi,
                                       pFocaFont);

               GplMemoryFree (pFocaFont);
            }
         }
      }
      }

      break;
   }
   }

   // default for most cases
   return WinDefDlgProc (hwnd, msg, mp1, mp2);

} /* end FontDlgProc */

// Failed attempts at better avoiding the Help manager uload problems
#if 0

//VOID EXPENTRY
//OmniReleaseHelpHook (VOID)
//{
//   BOOL bRC;
//
//   bRC = WinReleaseHook ((HAB)NULL, HMQ_CURRENT, HK_HELP, (PFN)OmniHelpHook, (HMODULE)NULL);
//   assertF (bRC);
//}
//
//
///*-------------------------------------------------------------------------*/
///* This hook is placed in the HK_HELP hook chain so that we can catch      */
///* the first time that the user presses PF1 or clicks on a "Help" button.  */
///* We then initialize our help instance and get the user's help request    */
///* passed back into the HK_HELP chain again by making a call to the        */
///* private function WinCallHelpHook()...                                   */
///*-------------------------------------------------------------------------*/
//BOOL
//OmniHelpHook (HAB hab, SHORT sMode, SHORT sTopic, SHORT sSubTopic, PRECTL prclPos)
//{
//   /*------------------------------------------------------------------------*/
//   /* LOCAL VARIABLES                                                        */
//   /*------------------------------------------------------------------------*/
//   BOOL         bDoNotCallNextHookInChain = TRUE;
//   PDLGINSTANCE pdi;
//   HWND         hwnd;
//
//   /*---------------------------------------------------------------------*/
//   /* Initialize the help manager, so that it will be added to            */
//   /* the HELP hook chain.                                                */
//   /*---------------------------------------------------------------------*/
//   CreateHelpInstance (pdi, TRUE);
//
//   ReleaseHelpHook ();
//
//   // @57002 - This call was in old shell but removed from WPS
//   // since there is no 32-bit equivalent.  So as a work around
//   // and we are still 16 bit we will call this private entry point
////  if (hwndHelp != NULL)
////  {
////     WinCallHelpHook (sMode, IdTopic, IdSubTopic, RectLPtr);
////  }
//
//   return bDoNotCallNextHookInChain;
//
//} /* end HelpStubHook */
//
//BOOL
//OmniSetHelpHook (PDLGINSTANCE pdi)
//{
//   BOOL   bSuccess = TRUE;
//
//   DBPRINTF (("%s(): Enter; pdi = %x\n", __FUNCTION__, pdi));
//
//   assertF (pdi);
//
//   // If we have not yet set the help hook for this DC do it now
//   if (!pdi->bHelpHookSet)
//   {
//      if (WinSetHook (NULL, HMQ_CURRENT, HK_HELP, (PFN)OmniHelpHook, globals.hModule))
//      {
//         pdi->bHelpHookSet = TRUE;
//
///////////DosExitList (EXLST_ADD, (PFNEXITLIST)OmniReleaseHelpHook);
//      }
//      else
//      {
//         DBPRINTF (( "%s(): WinSetHook(); failed\n", __FUNCTION__));
//         bSuccess = FALSE;
//      }
//   }
//   else
//   {
//      DBPRINTF (("%s(): Help Hook already Set!!!\n", __FUNCTION__));
//   }
//
//   DBPRINTF (("%s(): Exit\n", __FUNCTION__));
//
//   return bSuccess;
//
//} /* end OmniSetHelpHook */

#endif

#if 0   // no longer used to select compression algorithms
///****************************************************************************/
///* PROCEDURE NAME : JobPropertiesDataDlgProc                                */
///* AUTHOR         : WMJ & MFR                                               */
///* DATE WRITTEN   : 11/06/93                                                */
///* DESCRIPTION    :                                                         */
///*                                                                          */
///*                  Control Flow:                                           */
///*                                                                          */
///* PARAMETERS:                                                              */
///*                                                                          */
///* RETURN VALUES:                                                           */
///*                                                                          */
///*--------------------------------------------------------------------------*/
///* CHANGE/MODIFICATION LOG :                                                */
///*--------------------------------------------------------------------------*/
///*                                                                          */
///****************************************************************************/
//MRESULT EXPENTRY
//JobPropertiesDataDlgProc (HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
//{
//   /*------------------------------------------------------------------------*/
//   /* Local Variables                                                        */
//   /*------------------------------------------------------------------------*/
//   PDLGINSTANCE  pdi;
//   ULONG         ulCompressModeSupported;
//   ULONG         ulCompressModeSelected;
//   ULONG         ul, ulIndex;
//   SHORT         sIdx;
//
//   /*------------------------------------------------------------------------*/
//   /* BEGIN CODE                                                             */
//   /*------------------------------------------------------------------------*/
//   switch (msg)
//   {
//   case WM_INITDLG:
//   {
//      ULONG ulIdx;
//
//      pdi = (PDLGINSTANCE)mp2;
//
//      // store the pointer to instance data
//      WinSetWindowULong (hwnd, QWL_USER, (ULONG)pdi);
//
//      WinEnableControl (hwnd, DID_DEFAULTS, FALSE);
//      WinEnableControl (hwnd, DID_UNDO, FALSE);
//
//      // We are going to fill in a lot of strings from a similar location
//      // in stringtable so lets get a base index to reference from
//      ulIdx = STRING_TABLE_DLG_BASE - STRING_TABLE_BASE;
//
//      WinSetDlgItemText (hwnd, DID_CANCEL, globals.pbStringTable[ulIdx + DIALOG_TEXT_CANCEL]);
//      WinSetDlgItemText (hwnd, IDT_DATA_COMPRESS, globals.pbStringTable[ulIdx + DIALOG_COMPRESSION]);
//
//      // free existing list
//      WinSendDlgItemMsg (hwnd,
//                         IDL_DATA_COMPRESS,
//                         LM_DELETEALL,
//                         MPVOID,
//                         MPVOID);
//
//      ulCompressModeSupported = pdi->pDevice->ulCompressModes;
//      ulCompressModeSelected  = pdi->JobProperties.ulCompressModes;
//
//      for (ul = STRING_TABLE_COMPRESS_BASE; ul < STRING_TABLE_COMPRESS_END; ul++)
//      {
//         ulIndex = 1 << (ul - (STRING_TABLE_COMPRESS_BASE));
//
//         if (ulCompressModeSupported & ulIndex)
//         {
//            ulIdx = ul - (LONG) STRING_TABLE_BASE;
//            assertF (globals.pbStringTable[ulIdx]);
//
//            sIdx = (SHORT)WinSendDlgItemMsg (hwnd,
//                                             IDL_DATA_COMPRESS,
//                                             LM_INSERTITEM,
//                                             MPFROM2SHORT (LIT_END, 0),
//                                             MPFROMP (globals.pbStringTable[ulIdx]));
//
//            ulIdx = ul - (ULONG)(STRING_TABLE_COMPRESS_BASE);
//
//            WinSendDlgItemMsg (hwnd,
//                               IDL_DATA_COMPRESS,
//                               LM_SETITEMHANDLE,
//                               MPFROMSHORT (sIdx),
//                               MPFROMLONG (ulIdx));
//
//            if (ulCompressModeSelected & ulIndex)
//               WinSendDlgItemMsg (hwnd,
//                                  IDL_DATA_COMPRESS,
//                                  LM_SELECTITEM,
//                                  MPFROMSHORT (sIdx),
//                                  MPFROMLONG (TRUE));
//         }
//      }
//
//      // return since we handled init
//      return 0;
//   }
//
//   case WM_COMMAND:
//   {
//      // get instance data
//      pdi = (PDLGINSTANCE)WinQueryWindowULong (hwnd, QWL_USER);
//
//      switch (SHORT1FROMMP (mp1))
//      {
//      case DID_OK:     // save selections in pdi->JobProperties.ulCompressModes
//      {
//         if (pdi->pDevice->ulCompressModes != 0)  // Device has compress modes
//         {
//            ulCompressModeSelected = 0;
//
//            sIdx = SHORT1FROMMR (WinSendDlgItemMsg (hwnd,
//                                                    IDL_DATA_COMPRESS,
//                                                    LM_QUERYSELECTION,
//                                                    MPFROMSHORT (LIT_FIRST),
//                                                    MPVOID));
//
//            // while items are still selected in listbox
//            while (sIdx != LIT_NONE)
//            {
//               // Get Item Handle (Func ID)
//               ul = (ULONG)WinSendDlgItemMsg (hwnd,
//                                              IDL_DATA_COMPRESS,
//                                              LM_QUERYITEMHANDLE,
//                                              MPFROMSHORT (sIdx),
//                                              MPVOID );
//
//               ulCompressModeSelected |= (1 << ul);
//
//               // Query listbox for next highlighted item
//               sIdx = SHORT1FROMMR (WinSendDlgItemMsg (hwnd,
//                                                       IDL_DATA_COMPRESS,
//                                                       LM_QUERYSELECTION,
//                                                       MPFROMSHORT(sIdx),
//                                                       MPVOID));
//            }
//         }
//
//         pdi->JobProperties.ulCompressModes = ulCompressModeSelected;
//
//         WinDismissDlg (hwnd, DID_OK);
//         break;
//      }
//
//      case DID_CANCEL:
//      {
//         WinDismissDlg (hwnd, DID_CANCEL);
//         break;
//      }
//      }
//
//      return 0;
//   }
//   }
//
//   // default for most cases
//   return WinDefDlgProc (hwnd, msg, mp1, mp2);
//
//} /* end JobPropertiesDataDlgProc */

#endif


#if 0   // this printer properties dialog page is no longer used
///****************************************************************************/
///* PROCEDURE NAME : DeviceInformationDlgProc                                */
///* AUTHOR         : MFR                                                     */
///* DATE WRITTEN   : 9/22/92                                                 */
///* DESCRIPTION    :                                                         */
///*                                                                          */
///*                  Control Flow:                                           */
///*                                                                          */
///* PARAMETERS:                                                              */
///*                                                                          */
///* RETURN VALUES:                                                           */
///*                                                                          */
///*--------------------------------------------------------------------------*/
///* CHANGE/MODIFICATION LOG :                                                */
///*--------------------------------------------------------------------------*/
///*                                                                          */
///****************************************************************************/
//MRESULT EXPENTRY
//DeviceInformationDlgProc (HWND hwnd, ULONG  msg, MPARAM mp1, MPARAM mp2)
//{
//   /*------------------------------------------------------------------------*/
//   /* LOCAL VARIABLES                                                        */
//   /*------------------------------------------------------------------------*/
//   PDLGINSTANCE  pdi;
//   PDEVICEINFO   pDevice;
//   CHAR          szTemp[LEN_STRING];
//   ULONG         ulIdx;
//   ULONG         ulCapNameID;
//   ULONG         id;
//
//   /*------------------------------------------------------------------------*/
//   /* BEGIN CODE                                                             */
//   /*------------------------------------------------------------------------*/
//   switch (msg)
//   {
//   case WM_INITDLG:
//   {
//      PNOTEBOOKINFO pNBI;
//      BOOL          bInstallableMem;
//      BOOL          bNonZeroMem;
//
//      pdi = (PDLGINSTANCE)mp2;
//
//      // store the pointer to instance data
//      WinSetWindowULong (hwnd, QWL_USER, (ULONG)pdi);
//
//      DBPRINTIF ((FALSE, "%s(): INIT_DLG: pdi='%p'\n", __FUNCTION__, pdi));
//
//      // initial pointer validation
//      assertF (pdi);
//      assertF (pdi->pDevice);
//
//      pDevice = pdi->pDevice;
//
//      assertF (pdi->pNBI);
//      pNBI = pdi->pNBI;
//
//      // We are going to fill in a lot of strings from a similar location
//      // in stringtable so lets get a base index to reference from
//      ulIdx = STRING_TABLE_DLG_BASE - STRING_TABLE_BASE;
//
//      // Fill in text fields in dialogs from stringtable
//      WinSetDlgItemText (hwnd, IDT_DEVICE_MEMORY, globals.pbStringTable[ulIdx + DIALOG_DEV_MEMORY]);
//
//      // fill in entryfields in dialogs with current device/driver info
//      WinSetDlgItemText (hwnd, IDE_DEVICE_NAME,   pDevice->pszDeviceName);
//      WinSetDlgItemText (hwnd, IDE_DEVICE_VENDOR, pDevice->pszDeviceVendor);
//
//      // Display technology of device
//      switch (pDevice->ulOS2DeviceTechnology)
//      {
//      case CAPS_TECH_UNKNOWN:        ulCapNameID = CAPS_UNKNOWN;    break;
//      case CAPS_TECH_VECTOR_PLOTTER: ulCapNameID = CAPS_PLOTTER;    break;
//      case CAPS_TECH_RASTER_DISPLAY: ulCapNameID = CAPS_DISPLAY;    break;
//      case CAPS_TECH_RASTER_CAMERA:  ulCapNameID = CAPS_CAMARA;     break;
//      case CAPS_TECH_RASTER_PRINTER: ulCapNameID = CAPS_PRINTER;    break;
//      case CAPS_TECH_POSTSCRIPT:     ulCapNameID = CAPS_POSTSCRIPT; break;
//      }
//
//      ulIdx = STRING_TABLE_CAPS_BASE - STRING_TABLE_BASE + ulCapNameID;
//
//      assertF (globals.pbStringTable[ulIdx]);
//
//      WinSetDlgItemText (hwnd, IDE_DEVICE_CLASS, globals.pbStringTable[ulIdx]);
//
//      // Display version of driver
//      sprintf (szTemp, "%d.%d",
//               pDevice->usDeviceMajorVersion,
//               pDevice->usDeviceMinorVersion);
//
//      WinSetDlgItemText (hwnd, IDE_DEVICE_VERSION, szTemp);
//
//      GetEAVersion (szTemp, sizeof (szTemp));
//      WinSetDlgItemText (hwnd, IDE_OMNI_VERSION, szTemp);
//
//      // Show and enable memory spin button if device supports
//      // installable memory
//      bInstallableMem = pDevice->pMemory->ulMemFlags & MEMORY_INSTALLABLE;
//      bNonZeroMem     = (BOOL)(pdi->PrnProperties.ulInstalledMemory > 0);
//
//      WinShowWindow   (WinWindowFromID (hwnd, IDD_INSTALLED_MEMORY),
//                       bInstallableMem && bNonZeroMem);
//      WinEnableWindow (WinWindowFromID (hwnd, IDD_INSTALLED_MEMORY),
//                       bInstallableMem && bNonZeroMem);
//
//      WinShowWindow   (WinWindowFromID (hwnd, IDT_FIXED_MEMORY),
//                       !bInstallableMem && bNonZeroMem);
//
//      if (bNonZeroMem)
//      {
//         if (bInstallableMem)
//         {
//            // set memory limits for current device based on device descriptions
//            WinSendDlgItemMsg (hwnd,
//                               IDD_INSTALLED_MEMORY,
//                               SPBM_SETLIMITS,
//                               MPFROMLONG(pDevice->pMemory->ulMaximum),
//                               MPFROMLONG(pDevice->pMemory->ulBase));
//
//            // set current installed memory size based on Printer Properties
//            WinSendDlgItemMsg (hwnd,
//                               IDD_INSTALLED_MEMORY,
//                               SPBM_SETCURRENTVALUE,
//                               MPFROMLONG( pdi->PrnProperties.ulInstalledMemory ),
//                               NULL);
//         }
//         else
//         {
//            // Display fixed memory in dialog
//            sprintf (szTemp, ": %lu Kb", pDevice->pMemory->ulBase);
//
//            WinSetDlgItemText (hwnd, IDT_FIXED_MEMORY, szTemp);
//         }
//      }
//      else
//      {
//         WinShowWindow (WinWindowFromID (hwnd, IDT_DEVICE_MEMORY),
//                        FALSE);
//
//      }
//
//      // done initializing dlg box
//      return 0;
//   }
//
//   case WM_COMMAND:
//   {
//      return 0;
//   }
//   }
//
//   // default for most cases
//   return WinDefDlgProc (hwnd, msg, mp1, mp2);
//
//} /* end DeviceInformationDlgProc */
#endif
