/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1992 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 source code is provided to you solely for       */
/*    the purpose of assisting you in your development of OS/2 device        */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Developer Connection Device Driver       */
/*    Source Kit for OS/2. This Copyright statement may not be removed.      */
/*                                                                           */
/*****************************************************************************/
#define INCL_DOS
#define INCL_SPL
#define INCL_SPLFSE
#define INCL_DEV
#define INCL_DEVDJP
#define INCL_GPIBITMAPS    // To pull in the proper include files...
#define INCL_GPIPRIMITIVES
#define INCL_WINMENUS
#define INCL_ERRORS
#include <os2.h>

#ifndef SPLDATA_NOAUTORETRY
#define SPLDATA_NOAUTORETRY 0x4000
#endif

#define INCL_DDIDEFS
#define INCL_DDIPATHS
#define INCL_GRE_LINES
#define INCL_GRE_DEVICE
#define INCL_GRE_DEVMISC2
#define INCL_DDIMISC
#define INCL_VMANDDI            // 2.2 Engine stuff
#define INCL_GRE_DCS
#include <ddi.h>                // 2.2 Engine stuff
#include <pmddi.h>

// c includes
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <setjmp.h>

#include "def.h"
#include "driver.h"
#include "funcs.h"

/* Defines...
*/
//#define SUPPORTS_COPIES                  1
//#define DISABLE_DJP_SUPPORT              1

/* Function prototypes...
*/
VOID            FillFormInfo              (PDJPT_FORM          pDJPForm,
                                           ULONG               ulTrayID,
                                           ULONG               ulFormID,
                                           ULONG               ulMediaID,
                                           PDEVICEBLOCK        pdb,
                                           ULONG               ulResID);
BOOL            ValidDJPPQLValue          (DJPT_PRINTQUALITY   djppqlCurrent);
INT             NumPrintQualityIDs        (PDRIVERINFO         pDriver,
                                           PDEVICEINFO         pDevice,
                                           PDJPT_PRINTQUALITY *apqlQualities);
LONG            ToPrintQualityID          (PDRIVERINFO         pDriver,
                                           PDEVICEINFO         pDevice,
                                           PRESINFO            pResInfo);
PRESINFO        FromPrintQualityID        (PDRIVERINFO         pDriver,
                                           PDEVICEINFO         pDevice,
                                           DJPT_PRINTQUALITY   djpQuality);
#ifdef DEBUG
PSZ             pszProperty               (ULONG               ulProperty);
PSZ             pszType                   (LONG                lType);
PSZ             pszMXF                    (LONG                lMXFValue,
                                           PSZ                 pszMXF);
VOID            PrintDJPItem              (PDJP_ITEM           pDJP);
VOID            PrintForm                 (PDJPT_FORM          pForm);
VOID            PrintPaperSizeName        (DJPT_PAPERSIZE      djppsElm);
VOID            PrintTrayName             (DJPT_TRAYTYPE       djpttTrayID);
VOID            PrintMediaName            (DJPT_MEDIA          djpmdMediaID);
VOID            PrintMediaColor           (DJPT_MEDIA_COLOR    djpmdMediaColorID);
#endif
BOOL            NewConnection             (PDEVICEBLOCK        pdb,
                                           PSZ                 pszDeviceName,
                                           PULONG              pulDefConnID,
                                           ULONG               ulDefaultFormID,
                                           ULONG               ulDefaultTrayID,
                                           ULONG               ulDefaultMediaID,
                                           PUSERCONNECT        pUserConnect,
                                           BOOL                fCreateNewConnection);

/****************************************************************************/
/* PROCEDURE NAME : OS2_PM_DRV_QUERY                                        */
/* AUTHOR         : Mark Hamzy                                              */
/* DATE WRITTEN   : 8/30/95                                                 */
/* DESCRIPTION    :                                                         */
/*                                                                          */
/*                  Control Flow:                                           */
/*                                                                          */
/* PARAMETERS:                                                              */
/*                                                                          */
/* RETURN VALUES:                                                           */
/*                                                                          */
/*--------------------------------------------------------------------------*/
/* CHANGE/MODIFICATION LOG :                                                */
/*--------------------------------------------------------------------------*/
/* @EXJOB  - 07/13/98 - UCC [IBMJ]- Expansible job data support             */
/*                                                                          */
/****************************************************************************/
ULONG APIENTRY
OS2_PM_DRV_POSTESCAPE (PSZ       pszDriverName,
                       PSZ       pszDeviceName,
                       PSZ       pszQueueName,
                       PSZ       pszSplPrinterName,
                       ULONG     ulFuncNum,
                       ULONG     cbParm1,
                       PBYTE     pbParm1,
                       ULONG     cbParm2,
                       PBYTE     pbParm2)
{
   ULONG              pcbNeeded;
   PDEVICEINFO        pDevice        = (PDEVICEINFO)NULL;
   PDRIVERINFO        pDriver        = (PDRIVERINFO)NULL;
   PDRIVDATA          pGoodDrivData  = (PDRIVDATA)NULL;
   PJOBPROPERTIES     pJobProp;
   PDRIVDATA          pDrivData;
   DEVICEBLOCK        db;
   PDEVICEBLOCK       pdb            = &db;
   DLGINSTANCE        di;
   PDLGINSTANCE       pdi            = &di;
   BOOL               fCalledPDBInit = FALSE;
   REGREC             regrec;
   ULONG              ulException;
   APIRET             rc;
   ULONG              ulrc;

   // Assume an error condition
   ulrc = DEV_ERROR;

   REGISTERHANDLER (regrec, globals.hModule);
   ulException = setjmp (regrec.jmp);

   if (ulException)
   {
      // check for the killed-thread case
      switch (ulException)
      {
      case XCPT_PROCESS_TERMINATE:
      case XCPT_ASYNC_PROCESS_TERMINATE:
         DosUnsetExceptionHandler ((PEXCEPTIONREGISTRATIONRECORD)&regrec);
         DosExit (EXIT_THREAD, 0);
      }
      // error result
      ulrc = DEV_ERROR;
      goto depart;
   }

   ulrc = DEV_ERROR;

   // Clear out 'dem blocks
   memset (pdb, 0, sizeof (*pdb));
   memset (pdi, 0, sizeof (*pdi));

   // Check engine version level first!
   if (!globals.ulGreVersion)
   {
      globals.ulGreVersion = GreQueryEngineVersion ();
      assertF (globals.ulGreVersion);
   }

   // This api is not supported on pre-DAX engines
#ifndef DISABLE_DJP_SUPPORT
   if (GRE_234 > globals.ulGreVersion)
#endif
      goto depart;

   // Assume an bad parameter condition
   ulrc = DEV_BAD_PARAMETERS;

#if 0
   // Parameter validation
   if (!pszDriverName                                                ||
       !pszDeviceName                                                ||
       !pszQueueName                                                 ||
       !pszSplPrinterName                                            ||
       !ValidatePointer (pszDriverName,     VALIDATE_TYPE_STRING, 0) ||
       !ValidatePointer (pszDeviceName,     VALIDATE_TYPE_STRING, 0) ||
       !ValidatePointer (pszQueueName,      VALIDATE_TYPE_STRING, 0) ||
       !ValidatePointer (pszSplPrinterName, VALIDATE_TYPE_STRING, 0)  )
      goto depart;
#endif

   // Validate driver name
   if (0 != strcmp (pszDriverName, APP_NAME))
      goto depart;

#if 0
   // I have no clue     this was taken out!!!!!!!!!!!!!!!
   // Validate device name
   rc = IsItADeviceName (pszDeviceName);
   assertF (rc);
   if (!rc)
      goto depart;
#endif

   // Validate queue name
   rc = SplQueryQueue ((PSZ)NULL,
                       pszQueueName,
                       3,
                       (PVOID)NULL,
                       0,
                       &pcbNeeded);
   assertT (NERR_BufTooSmall != rc);
   if (NERR_BufTooSmall != rc)
      goto depart;

   // Validate spooler printer name
   rc = SplQueryDevice ((PSZ)NULL,
                        pszSplPrinterName,
                        3,
                        (PVOID)NULL,
                        0,
                        &pcbNeeded);
   assertT (NERR_BufTooSmall != rc);
   if (NERR_BufTooSmall != rc)
      goto depart;

   // Load the string table if necessary
   InitStringTable (STRINGS_BASE);

   ulrc = DEV_OK;

   // Need good job properties?
   switch (ulFuncNum)
   {
     case DEVPE_QUERYSIZE:
     case DEVPE_QUERYJOBPROPERTIES:
     case DEVPE_SETJOBPROPERTIES:
     case DEVESC_DEFAULTJOBPROPERTIES:
     {
        /* Take the input job properties and make sure the size is set
        ** correctly.
        */
// begin @EXJOB
        pDriver = PDriverFromDeviceName (pszDeviceName, &pDevice);
        pdi->pDevice = pDevice;
// end @EXJOB
        pDrivData  = (PDRIVDATA)pbParm2;
        pDrivData->cb = min (cbParm2, pDrivData->cb);

        GetCountryInfo (&pdi->ctryCode, &pdi->ctryInfo);

        pGoodDrivData = ReturnDriverData (pdb,
                                          pdi,
                                          globals.pvSharedHeap,
                                          pDrivData,
                                          pszSplPrinterName,
                                          TRUE,
                                          pDevice,
                                          pDriver);
        assertF (pGoodDrivData);
        pJobProp = (PJOBPROPERTIES)(&pGoodDrivData->abGeneralData);

        /* Is the size of the input driver data is not the same as
        ** the size of our good data?
        */
        if (pDrivData->cb != pGoodDrivData->cb)
           ulrc = DEV_PROP_BUF_TOO_SMALL;

        /* Or, if the two don't compare, then fail the call.
        */
        if (0 != memcmp (pDrivData, pGoodDrivData, pGoodDrivData->cb))
           ulrc = DEV_INV_INP_JOBPROPERTIES;

     }
     break;

   } /* end switch */

   if (DEV_OK != ulrc)
      goto depart;

   // Need a pdb (driver and device name)?
   switch (ulFuncNum)
   {
   case DEVPE_QUERYSIZE:
   case DEVPE_QUERYJOBPROPERTIES:
   case DEVPE_SETJOBPROPERTIES:
   case DEVESC_DEFAULTJOBPROPERTIES:
   {
      BOOL bRC;

      fCalledPDBInit = TRUE;

      strcpy (pdb->szDriverName, pszDriverName);

      pDriver = PDriverFromDeviceName (pszDeviceName, &pDevice);
      assertF (pDriver);
      assertF (pDevice);

      pdb->pDriver = pDriver;
      pdb->pDevice = pDevice;

//      pdb->pResInfo   = GetpResFromResID (pDriver, pDevice, pJobProp);
//      pdb->pPrintMode = GetpPrintModeFromID (pDriver, pDevice, pJobProp);

      pdb->pJobProperties = pJobProp;

      bRC = BuildAppName (pdb->szAppName,
                          LEN_APPNAME,
                          pdb->pszPrinterName,
                          pdb->szDriverName,
                          pszDeviceName);
      assertF (bRC);

      // initialize User defined data pointers to NULLs etc.
      InitUserDefinedData (pdb->pDevice->pUserDefData);

      // read in user defined values from INI file to linked list
      // to reset to original state after cancel
      bRC = ReadUserDefinedTrayList (pdb->szAppName, pdb->pDevice);
      assertF (bRC);

      bRC = ReadUserDefinedFormList (pdb->szAppName, pdb->pDevice);
      assertF (bRC);

      bRC = ReadUserDefinedConnectList (pdb->szAppName, pdb->pDevice);
      assertF (bRC);

      bRC = ReadUserDefinedFontList (pdb->szAppName, pdb->pDevice);
      assertF (bRC);

      pdb->pResInfo   = GetpResFromResID (pDriver, pDevice, pJobProp);
      pdb->pPrintMode = GetpPrintModeFromID (pDriver, pDevice, pJobProp);

#ifndef DEBUG
   bRC++;          // Avoid compiler warnings
#endif
      break;
   }
   }

   ulrc = InnerDeviceQuery (ulFuncNum,
                            pdb,
                            pGoodDrivData,
                            cbParm1,
                            pbParm1,
                            cbParm2,
                            pbParm2);

depart:
   if (fCalledPDBInit)
      switch (ulFuncNum)
      {
      case DEVPE_QUERYSIZE:
      case DEVPE_QUERYJOBPROPERTIES:
      case DEVPE_SETJOBPROPERTIES:
      case DEVESC_DEFAULTJOBPROPERTIES:
      {
         // free lists since user cancelled
         FreeUserDefinedFontList (pdb->pDevice);
         FreeUserDefinedTrayList (pdb->pDevice);
         FreeUserDefinedFormList (pdb->pDevice);
         FreeConnectionList (pdb->pDevice);
         break;
      }
      }

   if (pdb->pszPrinterName)
      GplMemoryFree (pdb->pszPrinterName);

   if (pGoodDrivData)
      GplMemoryFree (pGoodDrivData);

   UNREGISTERHANDLER (regrec);
   return ulrc;
}

/****************************************************************************/
/* PROCEDURE NAME : InnerDeviceQuery                                        */
/* AUTHOR         : Mark Hamzy                                              */
/* DATE WRITTEN   : 8/30/95                                                 */
/* DESCRIPTION    :                                                         */
/*                                                                          */
/*                  Control Flow:                                           */
/*                                                                          */
/* PARAMETERS:                                                              */
/*                                                                          */
/* RETURN VALUES:                                                           */
/*                                                                          */
/*--------------------------------------------------------------------------*/
/* CHANGE/MODIFICATION LOG :                                                */
/*--------------------------------------------------------------------------*/
/*                                                                          */
/****************************************************************************/
APIRET
InnerDeviceQuery (ULONG          ulFuncNum,
                  PDEVICEBLOCK   pdb,
                  PDRIVDATA      pGoodDrivData,
                  ULONG          cbParm1,
                  PBYTE          pbParm1,
                  ULONG          cbParm2,
                  PBYTE          pbParm2)
{
   ULONG              ulrc          = DEV_OK;
   PDEVICEINFO        pDevice       = (PDEVICEINFO)NULL;
   PDRIVERINFO        pDriver       = (PDRIVERINFO)NULL;
   PJOBPROPERTIES     pJobProp      = (PJOBPROPERTIES)pGoodDrivData->abGeneralData;
   ULONG              cbDrivData;
   PDRIVDATA          pDrivData;
   REGREC             regrec;
   ULONG              ulException;
   BOOL               bShow = FALSE;

#ifdef DEBUG
   bShow = TRUE;
#endif


   REGISTERHANDLER (regrec, globals.hModule);
   ulException = setjmp (regrec.jmp);

   if (ulException)
   {
      // check for the killed-thread case
      switch (ulException)
      {
      case XCPT_PROCESS_TERMINATE:
      case XCPT_ASYNC_PROCESS_TERMINATE:
         DosUnsetExceptionHandler ((PEXCEPTIONREGISTRATIONRECORD)&regrec);
         DosExit (EXIT_THREAD, 0);
      }
      // error result
      ulrc = DEV_ERROR;
      goto depart;
   }

   // Grab the pointers
   pDriver = pdb->pDriver;
   pDevice = pdb->pDevice;

   switch (ulFuncNum)
   {
   case DEVPE_QUERYSUPPORT:
   {
      ULONG    ulCheck;

      // Validate we have enough mem to reply Not big enough!
      if (sizeof (ULONG) > cbParm1)
      {
         DBPRINTIF ((bShow, "DEVPE_QUERYSUPPORT: Buffer Too Small!!! Needed=%d, Actual=%d\n",
                     sizeof (ULONG),
                     cbParm1));

         // Not big enough! Must exit query
         break;
      }

      ulCheck = *(PULONG)pbParm1;

      switch (ulCheck)
      {
         case DEVPE_QUERYSUPPORT:
         case DEVPE_QUERYSIZE:
         case DEVPE_QUERYJOBPROPERTIES:
         case DEVPE_SETJOBPROPERTIES:
         case DEVESC_DEFAULTJOBPROPERTIES:
         {
            // good result - we support this query type
            ulrc = DEV_OK;

            DBPRINTIF ((bShow, "DEVPE_QUERYSUPPORT: Type=%d, Supported.\n",
                        ulCheck));
            break;
         }

         default:
         {
            // We don't support these
            ulrc = DEVPE_NOTSUPPORTED;

            DBPRINTIF ((bShow, "DEVPE_QUERYSUPPORT: Type=%d, UNSUPPORTED!\n",
                        ulCheck));

            break;
         }
      }
      break;
   }

   case DEVPE_QUERYSIZE:
   {
      INT         cbQueries  = cbParm1;
      PQUERYSIZE  pQuerySize = (PQUERYSIZE)pbParm1;
      PQUERYTUPLE pTuple     = pQuerySize->aTuples;
      INT         cbElmSize  = sizeof (QUERYTUPLE);
      INT         iCount;
      INT         iMaxCount;
      INT         iSingleCount;
      INT         iSize;
      BOOL        fPrinted;

      // Take off the header
      cbQueries -= QUERYSIZE_HEADER_SIZE;

      // Must be an even multiple
      assertT (cbQueries % cbElmSize);
      if (cbQueries % cbElmSize)
      {
         DBPRINTF (("Must be an even multiple (%d, %d)!\n", cbQueries, cbElmSize));
         GplErrSetError (PMERR_INVALID_PARAMETER);

         ulrc = DEV_BAD_PARAMETERS;
         assertT (ulrc);
         break;
      }

      // Initialize the returned size
      pQuerySize->ulSizeNeeded = 0;

      while (cbQueries)
      {
         fPrinted = FALSE;

         switch (pTuple->ulProperty)
         {
         case DJP_NONE:
         {
            iSize        = sizeof (((PDJP_ITEM)NULL)->ulValue);
            iMaxCount    = 1;
            iSingleCount = 1;
            break;
         }

         case DJP_SJ_ORIENTATION:
         {
            iSize        = sizeof (DJPT_ORIENTATION);
            iMaxCount    = 2;
            iSingleCount = 1;
            break;
         }

         case DJP_CJ_RESOLUTION:
         {
            iSize        = sizeof (DJPT_RESOLUTION);
            iMaxCount    = pDevice->usNumRes;
            iSingleCount = 1;
            break;
         }

         case DJP_SJ_BITSPERPEL:
         {
            iSize        = sizeof (DJPT_BITSPERPEL);
            iMaxCount    = pDevice->usNumPrintModes;
            iSingleCount = 1;
            break;
         }

         case DJP_SJ_COLOR:
         {
            PPRINTMODE       pPrintMode    = pDriver->pPrintModes;
            ULONG            ulNumDefined  = pDriver->ulNumPrintModes;
            PULONG           pulPrintModes = pDevice->pulPrintModes;
            ULONG            ulNumDevice   = pDevice->usNumPrintModes;
            BOOL             fFoundMono    = FALSE,
                             fFoundColor   = FALSE;
            register INT     i, j;

            for (i = 0; i < ulNumDevice; i++)
            {
               for (j = 0; j < ulNumDefined; j++)
               {
                  if (pPrintMode[j].ulPrintModeID == pulPrintModes[i])
                  {
                     if (1 == pPrintMode[j].usBitsPerPel)
                        fFoundMono = TRUE;
                     else
                        fFoundColor = TRUE;
                  }
               }
            }

            iSize        = sizeof (DJPT_COLOR);
            iMaxCount    = 0;
            iSingleCount = 1;

            if (fFoundMono)
               iMaxCount++;
            if (fFoundColor)
               iMaxCount++;
            if (!fFoundMono && !fFoundColor)
               iMaxCount = 1;
            break;
         }

         case DJP_SJ_PRINTQUALITY:
         {
            iSize        = sizeof (DJPT_PRINTQUALITY);
            iMaxCount    = NumPrintQualityIDs (pDriver, pDevice, NULL);
            iSingleCount = 1;

            if (-1 == iMaxCount)
            {
               // size of 1 for an error
               iMaxCount = 1;

               DBPRINTIF ((bShow, "QSIZE: Error: %s(%d): SPECIAL: NumPrintQualityIDs == -1\n",
                           pszProperty (pTuple->ulProperty),
                           pTuple->ulProperty));
            }
            break;
         }

         case DJP_CJ_FORM:
         case DJP_SJ_PAPERSIZE:
         case DJP_SJ_TRAYTYPE:
         case DJP_SJ_MEDIA:
         {
            PUSERCONNECT pUserConn;
            ULONG        ulFormID,
                         ulTrayID,
                         ulMediaID;
            FORMINFO2    FormInfo;
            PTRAYINFO    pTrayInfo      = NULL;
            PMEDIAINFO   pMediaInfo     = NULL;
            LONG         lRet;
            register INT i;

            iMaxCount    = 0;
            iSingleCount = 1;

            switch (pTuple->ulProperty)
            {
            case DJP_CJ_FORM:
            {
               iSize = sizeof (DJPT_FORM);
               break;
            }

            case DJP_SJ_PAPERSIZE:
            {
               iSize = sizeof (DJPT_PAPERSIZE);
               break;
            }

            case DJP_SJ_TRAYTYPE:
            {
               iSize = sizeof (DJPT_TRAYTYPE);
               break;
            }

            case DJP_SJ_MEDIA:
            {
               iSize = sizeof (DJPT_MEDIA);
               break;
            }
            }

            //------------------------------------------
            // DRIVER-DEFINED CONNECTIONS: Add to size
            //------------------------------------------
            for (i = 0; i < pDevice->usNumConnects; i++)
            {
               GetIDsFromConnID (pDriver,
                                 pDevice,
                                 pDevice->pulCONNECTS[i],
                                 &ulTrayID,
                                 &ulFormID,
                                 &ulMediaID);

               DBPRINTIF ((bShow, "QSIZE: Error: %s (%d): FormID=%d, TrayID=%d, MediaID=%d\n",
                           pszProperty (pTuple->ulProperty),
                           pTuple->ulProperty,
                           ulFormID,
                           ulTrayID,
                           ulMediaID));

               if (DJP_CJ_FORM == pTuple->ulProperty)
               {
                  iMaxCount++;
               }
               else if (DJP_SJ_PAPERSIZE == pTuple->ulProperty)
               {
                  lRet = GetDefaultFormInfo (pdb,
                                             ulFormID,
                                             pJobProp->ulDefResID,
                                             &FormInfo);

                  if (lRet)
                     lRet = FormInfo.ulDJPid;
                  else
                     lRet = DJP_PSI_NONE;

                  if (DJP_PSI_NONE != lRet)
                     iMaxCount++;
               }
               else if (DJP_SJ_TRAYTYPE == pTuple->ulProperty)
               {
                  lRet = TrayInfoFromID (pDriver,
                                         pDevice,
                                         ulTrayID,
                                         &pTrayInfo);

                  if (lRet)
                     lRet = pTrayInfo->ulDJPid;
                  else
                     lRet = DJP_TRY_NONE;

                  if (DJP_TRY_NONE != lRet)
                     iMaxCount++;
               }
               else if (DJP_SJ_MEDIA == pTuple->ulProperty)
               {
                  lRet = MediaInfoFromID (pDriver,
                                          pDevice,
                                          ulMediaID,
                                          &pMediaInfo);

                  if (lRet)
                     lRet = pMediaInfo->ulDJPid;
                  else
                     lRet = DJP_MED_NONE;

                  if (DJP_MED_NONE != lRet)
                     iMaxCount++;
               }
            }

            //------------------------------------------
            // USER-DEFINED CONNECTIONS: Add to size
            //------------------------------------------

            // get pointer to first user-defined form connection
            pUserConn = pDevice->pUserDefData->pUserCONNECTS;

            // as long as we have user-defined form connections
            while (pUserConn)
            {
               if (DJP_CJ_FORM == pTuple->ulProperty)
               {
                  iMaxCount++;
               }
               else if (DJP_SJ_PAPERSIZE == pTuple->ulProperty)
               {
                  lRet = GetDefaultFormInfo (pdb,
                                             ulFormID,
                                             pJobProp->ulDefResID,
                                             &FormInfo);

                  if (lRet)
                     lRet = FormInfo.ulDJPid;
                  else
                     lRet = DJP_PSI_NONE;

                  if (DJP_PSI_NONE != lRet)
                     iMaxCount++;
               }
               else if (DJP_SJ_TRAYTYPE == pTuple->ulProperty)
               {
                  lRet = TrayInfoFromID (pDriver,
                                         pDevice,
                                         ulTrayID,
                                         &pTrayInfo);

                  if (lRet)
                     lRet = pTrayInfo->ulDJPid;
                  else
                     lRet = DJP_TRY_NONE;

                  if (DJP_TRY_NONE != lRet)
                     iMaxCount++;
               }
               else if (DJP_SJ_MEDIA == pTuple->ulProperty)
               {
                  lRet = MediaInfoFromID (pDriver,
                                          pDevice,
                                          ulMediaID,
                                          &pMediaInfo);

                  if (lRet)
                     lRet = pMediaInfo->ulDJPid;
                  else
                     lRet = DJP_MED_NONE;

                  if (DJP_MED_NONE == lRet)
                     iMaxCount++;
               }

               // Move to the next connection
               pUserConn = pUserConn->pNextConnect;
            }

            if (0 == iMaxCount)
               // Make sure its at least 1
               iMaxCount = 1;
            break;
         }

         case DJP_CJ_TRAYNAME:
         {
            iSize        = sizeof (DJPT_TRAYNAME);
            iMaxCount    = pDevice->usNumTrays;
            iSingleCount = 1;
            break;
         }

         case DJP_CJ_MIXEDFORMS:
         {
            iSize        = sizeof (DJPT_MIXEDFORMS);
            iMaxCount    = 1;
            iSingleCount = 1;
            break;
         }

#ifdef SUPPORTS_COPIES
         case DJP_SJ_COPIES:
         {
            iSize        = sizeof (DJPT_COPIES);
            iMaxCount    = 1;
            iSingleCount = 1;
            break;
         }
#endif

         case DJP_SJ_FORMFEEDCONTROL:
         {
            iSize        = sizeof (DJPT_FORMFEEDCONTROL);
            iMaxCount    = 3;
            iSingleCount = 1;
            break;
         }

         /* Things we don't support
         */
#ifndef SUPPORTS_COPIES
         case DJP_SJ_COPIES:
#endif
         case DJP_SJ_FONTDOWNLOADING:
         case DJP_SJ_DUPLEX:
         case DJP_SJ_COLLATE:
         case DJP_SJ_FEED:
         case DJP_SJ_SCALING:
         case DJP_SJ_MEDIA_COLOR:
         {
            iSize        = sizeof (((PDJP_ITEM)NULL)->ulValue);
            iMaxCount    = 1;
            iSingleCount = 1;
            DBPRINTF (("QSIZE:      Unknown query '%30s'/%5d!\n",
                        pszProperty (pTuple->ulProperty),
                        pTuple->ulProperty));
            fPrinted     = TRUE;
            break;
         }

         /* Everything else we don't understand
         */
         default:
         {
            iSize        = sizeof (((PDJP_ITEM)NULL)->ulValue);
            iMaxCount    = 1;
            iSingleCount = 1;
            DBPRINTF (("QSIZE:      Unknown query '%30s'/%5d!\n",
                        pszProperty (pTuple->ulProperty),
                        pTuple->ulProperty));
            fPrinted     = TRUE;
            break;
         }
         }

         if (!fPrinted)
         {
            DBPRINTF (("QSIZE:         Query size '%30s'/%5d  = %5d.  Max count = %5d\n",
                       pszProperty (pTuple->ulProperty),
                       pTuple->ulProperty,
                       iSize,
                       iMaxCount));
         }

         if (DJP_NONE    == pTuple->ulProperty ||
             DJP_CURRENT == pTuple->lType       )
         {
            iCount = iSingleCount;
         }
         else if (DJP_ALL == pTuple->lType)
         {
            iCount = iMaxCount;
         }
         else
         {
            iCount = iSingleCount;

            DBPRINTF (("QSIZE: Unknown tuple type '%30s'/%5d  = %5d. Type = %5d\n",
                        pszProperty (pTuple->ulProperty),
                        pTuple->ulProperty,
                        pTuple->lType));

            assertstring ("QSIZE: Error!\n");
         }

         // Bump up the returned size
         pQuerySize->ulSizeNeeded += DJP_HEADER_SIZE + iCount * iSize;

         cbQueries -= cbElmSize;
         pTuple++;

         assertF (pTuple);
      }

      // good result
      ulrc = DEV_OK;
      break;
   } /* end case DEVPE_QUERYSIZE */

   case DEVPE_QUERYJOBPROPERTIES:
   {
      INT            cbQueries    = cbParm1;
      PBYTE          pbQueries    = pbParm1;
      PDJP_ITEM      pIQuery      = (PDJP_ITEM)pbQueries;
      BOOL           fError       = FALSE;
      BOOL           fPrinted;
      PBYTE          pbNext;
      INT            iNumQueries;
      PQUERYTUPLE    pTuples      = NULL,
                     pTupleCur;

      // Output buffer must be at least one item in size
      if (sizeof (DJP_ITEM) > cbQueries)
      {
         DBPRINTF (("Buffer must be at least one item in size!\n"));
         ulrc = DEV_BAD_PARAMETERS;
         assertT (ulrc);
         break;
      }

      // Step 1.  Count the number of queries
      iNumQueries = 0;
      pIQuery     = (PDJP_ITEM)pbQueries;
      while (pIQuery->ulProperty != DJP_NONE)
      {
         iNumQueries++;
         pIQuery = DJP_NEXT_STRUCTP (pIQuery);
      }
      iNumQueries++;   // Add an EOL marker

      // Step 2.  Allocate and copy the query types
      pTuples = (PQUERYTUPLE)GplMemoryAlloc (globals.pvSharedHeap,
                                             iNumQueries * sizeof (QUERYTUPLE));
      assertF (pTuples);
      if (!pTuples)
      {
         ulrc = DEV_ERROR;
         DBPRINTF (("Failed to allocate tuples\n"));
         GplErrSetError (PMERR_INSUFFICIENT_MEMORY);
         break;
      }

      /* Since we will be overwriting the input list to the output list, we
      ** need to copy the original input list into an array of tuples
      ** (the only thing that matters)
      */
      pIQuery   = (PDJP_ITEM)pbQueries;
      pTupleCur = pTuples;
      while (pIQuery->ulProperty != DJP_NONE)
      {
         pTupleCur->ulProperty = pIQuery->ulProperty;
         pTupleCur->lType      = pIQuery->lType;

         pIQuery = DJP_NEXT_STRUCTP (pIQuery);
         pTupleCur++;
      }
      // And copy the EOL
      pTupleCur->ulProperty = DJP_NONE;
      pTupleCur->lType      = DJP_NONE;

      // Step 3.  Fill in the output list
      pIQuery   = (PDJP_ITEM)pbQueries;
      pTupleCur = pTuples;
      while (0 < iNumQueries)
      {
         BOOL  fCurError = FALSE;

         pIQuery->ulProperty    = pTupleCur->ulProperty;
         pIQuery->lType         = pTupleCur->lType;
         pIQuery->ulNumReturned = 0;

         if (sizeof (DJP_ITEM) > cbQueries)
         {
            fError = DEV_PROP_BUF_TOO_SMALL;
            assertstring ("Not enough space left!\n");
            break;
         }

#ifdef DEBUG
         if ((DJP_CURRENT != pTupleCur->lType) &&
             (DJP_ALL     != pTupleCur->lType) &&
             (DJP_NONE    != pTupleCur->lType)  )
         {
            DBPRINTF (("QJPRO: Unknown type Query '%30s'/  %5d.  Query type '%20s'/%5d\n",
                       pszProperty (pTupleCur->ulProperty),
                       pTupleCur->ulProperty,
                       pszType (pTupleCur->lType),
                       pTupleCur->lType));
         }
#endif

         if (pTupleCur->lType == DJP_CURRENT)
         {
            pIQuery->ulNumReturned = 1;

            // Assume a simple type... complex types will override it
            pbNext = (PBYTE)(pIQuery + 1);

            fPrinted = FALSE;
            switch (pTupleCur->ulProperty)
            {
            case DJP_SJ_ORIENTATION:
            {
               if (ORIENTATION_PORTRAIT == pJobProp->ulOrientation)
                  pIQuery->ulValue = DJP_ORI_PORTRAIT;
               else
                  pIQuery->ulValue = DJP_ORI_LANDSCAPE;
               break;
            }

            case DJP_CJ_RESOLUTION:
            case DJP_SJ_PRINTQUALITY:
            {
               PDJPT_RESOLUTION   pRes   = DJP_ELEMENTP (*pIQuery, DJPT_RESOLUTION);
               PDJPT_PRINTQUALITY pQual  = DJP_ELEMENTP (*pIQuery, DJPT_PRINTQUALITY);
               PRESINFO           pResInfo;
               DJPT_RESOLUTION    Res;
               LONG               lRet;

               pResInfo = GetpResFromResID (pDriver, pDevice, pJobProp);

               if (pResInfo)
               {
                  if (DJP_CJ_RESOLUTION == pTupleCur->ulProperty)
                  {
                     Res.usXResolution = pResInfo->ulXRes;
                     Res.usYResolution = pResInfo->ulYRes;
                     *pRes++ = Res;

                     pbNext = (PBYTE)pRes;
                  }
                  else
                  {
                     lRet = ToPrintQualityID (pDriver, pDevice, pResInfo);
                     if (-1 == lRet)
                     {
                        fCurError = TRUE;
                        *pQual++ = DJP_NONE;
                        DBPRINTF (("QJPRO: Error: Print quality not translatable %d\n", pResInfo->ulResID));
                     }
                     else
                     {
                        *pQual++ = lRet;
                     }

                     pbNext = (PBYTE)pQual;
                  }
               }
               else
               {
                  DBPRINTF (("QJPRO: Error: Cannot find resinfo for %d\n", pJobProp->ulDefResID));
                  fCurError = TRUE;
               }
               break;
            }

            case DJP_SJ_BITSPERPEL:
            case DJP_SJ_COLOR:
            {
               PPRINTMODE pPrintMode;

               pPrintMode = GetpPrintModeFromID (pDriver,
                                                 pDevice,
                                                 pJobProp);

               if (pPrintMode)
               {
                  if (DJP_SJ_BITSPERPEL == pTupleCur->ulProperty)
                  {
                     pIQuery->ulValue = pPrintMode->usLogBitCount;
                  }
                  else
                  {
                     if (1 == pPrintMode->usBitsPerPel)
                        pIQuery->ulValue = DJP_CLR_MONOCHROME;
                     else
                        pIQuery->ulValue = DJP_CLR_COLOR;
                  }
               }
               else
               {
                  fCurError = TRUE;
                  DBPRINTF (("QJPRO: Error: Cannot find print mode for %d\n", pJobProp->ulDefPrintModeID));
               }
               break;
            }

            case DJP_CJ_FORM:
            case DJP_CJ_MIXEDFORMS:
            case DJP_SJ_TRAYTYPE:
            case DJP_CJ_TRAYNAME:
            case DJP_SJ_MEDIA:
            case DJP_SJ_PAPERSIZE:
            {
               PDJPT_FORM       pDJPForm       = DJP_ELEMENTP (*pIQuery, DJPT_FORM);
               PDJPT_MIXEDFORMS pDJPMXForm     = DJP_ELEMENTP (*pIQuery, DJPT_MIXEDFORMS);
               PDJPT_TRAYNAME   pDJPTrayName   = DJP_ELEMENTP (*pIQuery, DJPT_TRAYNAME);
               PTRAYINFO        pTrayInfo      = NULL;
               PMEDIAINFO       pMediaInfo     = NULL;
               FORMINFO2        FormInfo;
               ULONG            ulDefaultFormID,
                                ulDefaultTrayID,
                                ulDefaultMediaID;
               LONG             lRet;

               GetIDsFromConnID (pDriver,
                                 pDevice,
                                 pJobProp->ulDefConnID,
                                 &ulDefaultTrayID,
                                 &ulDefaultFormID,
                                 &ulDefaultMediaID);

               if (DJP_CJ_FORM == pTupleCur->ulProperty)
               {
                  FillFormInfo (pDJPForm,
                                ulDefaultTrayID,
                                ulDefaultFormID,
                                ulDefaultMediaID,
                                pdb,
                                pJobProp->ulDefResID);

                  pDJPForm++;
                  pbNext = (PBYTE)pDJPForm;
               }
               else if (DJP_CJ_MIXEDFORMS == pTupleCur->ulProperty)
               {
                  pDJPMXForm->lStartRange = DJP_MXF_INFINITY;
                  pDJPMXForm->lEndRange   = DJP_MXF_INFINITY;

                  FillFormInfo (&pDJPMXForm->djpfmForm,
                                ulDefaultTrayID,
                                ulDefaultFormID,
                                ulDefaultMediaID,
                                pdb,
                                pJobProp->ulDefResID);

                  pDJPMXForm++;
                  pbNext = (PBYTE)pDJPMXForm;
               }
               else if (DJP_SJ_TRAYTYPE == pTupleCur->ulProperty)
               {
                  lRet = TrayInfoFromID (pDriver,
                                         pDevice,
                                         ulDefaultTrayID,
                                         &pTrayInfo);

                  if (lRet)
                     lRet = pTrayInfo->ulDJPid;
                  else
                     lRet = DJP_TRY_NONE;

                  if (DJP_TRY_NONE == lRet)
                  {
                     fCurError = TRUE;
                     DBPRINTF (("QJPRO: Error: Tray id not translatable %d\n", ulDefaultTrayID));
                  }
                  else
                     pIQuery->ulValue = lRet;
               }
               else if (DJP_CJ_TRAYNAME == pTupleCur->ulProperty)
               {
                  lRet = TrayInfoFromID (pDriver,
                                         pDevice,
                                         ulDefaultTrayID,
                                         &pTrayInfo);

                  if (lRet)
                  {
                     CHAR  szTrayName[LEN_STRING];

                     TrayNameFromID (pDriver,
                                     pDevice,
                                     szTrayName,
                                     ulDefaultTrayID);

                     SafeStrNCpy (pDJPTrayName->szTrayname,
                                  szTrayName,
                                  sizeof (pDJPTrayName->szTrayname));
                     SafeStrNCpy (pDJPTrayName->szDisplayTrayname,
                                  szTrayName,
                                  sizeof (pDJPTrayName->szDisplayTrayname));

                     pDJPTrayName->djpttTrayID = pTrayInfo->ulDJPid;

                     pDJPTrayName++;
                     pbNext = (PBYTE)pDJPTrayName;
                  }
                  else
                  {
                     fCurError = TRUE;
                     DBPRINTF (("QJPRO: Error: TrayInfoFromID failed for %d\n", ulDefaultTrayID));
                  }
               }
               else if (DJP_SJ_MEDIA == pTupleCur->ulProperty)
               {
                  lRet = MediaInfoFromID (pDriver,
                                          pDevice,
                                          ulDefaultMediaID,
                                          &pMediaInfo);

                  if (lRet)
                     lRet = pMediaInfo->ulDJPid;
                  else
                     lRet = DJP_MED_NONE;

                  if (DJP_MED_NONE == lRet)
                  {
                     fCurError = TRUE;
                     DBPRINTF (("QJPRO: Error: Media not translatable %d\n", ulDefaultMediaID));
                  }
                  else
                     pIQuery->ulValue = lRet;
               }
               else /* (DJP_SJ_PAPERSIZE == pTupleCur->ulProperty) */
               {
                  lRet = GetDefaultFormInfo (pdb,
                                             ulDefaultFormID,
                                             pJobProp->ulDefResID,
                                             &FormInfo);

                  if (lRet)
                     lRet = FormInfo.ulDJPid;
                  else
                     lRet = DJP_PSI_NONE;

                  if (DJP_PSI_NONE == lRet)
                  {
                     fCurError = TRUE;
                     DBPRINTF (("QJPRO: Error: Form id not translatable %d\n", ulDefaultFormID));
                  }
                  else
                     pIQuery->ulValue = lRet;
               }
               break;
            }

#ifdef SUPPORTS_COPIES
            case DJP_SJ_COPIES:
            {
               pIQuery->ulValue = pJobProp->ulCopies;
               break;
            }
#endif

            case DJP_SJ_FORMFEEDCONTROL:
            {
               if (FF_CTL_CONDITIONAL == pJobProp->bFFControlType)
                  pIQuery->ulValue = DJP_FFC_CONDITIONAL;
               else if (FF_CTL_NONE == pJobProp->bFFControlType)
                  pIQuery->ulValue = DJP_FFC_NONE;
               else if (FF_CTL_COMPULSORY == pJobProp->bFFControlType)
                  pIQuery->ulValue = DJP_FFC_COMPULSORY;
               break;
            }

            case DJP_NONE:
            {
               // Nothing to do!
               pIQuery->ulValue = DJP_NONE;
               break;
            }

            /* Things we don't support
            */
#ifndef SUPPORTS_COPIES
            case DJP_SJ_COPIES:
#endif
            case DJP_SJ_FONTDOWNLOADING:
            case DJP_SJ_DUPLEX:
            case DJP_SJ_COLLATE:
            case DJP_SJ_FEED:
            case DJP_SJ_SCALING:
            case DJP_SJ_MEDIA_COLOR:
            {
               fCurError = TRUE;
               fPrinted  = TRUE;
               DBPRINTF (("QJPROc: Error: Unsupported query '%30s'/%5d!\n",
                           pszProperty (pTupleCur->ulProperty),
                           pTupleCur->ulProperty));
               break;
            }

            /* Everything else we don't understand
            */
            default:
            {
               fCurError = TRUE;
               fPrinted  = TRUE;
               DBPRINTF (("QJPROc: Error:     Unknown query '%30s'/%5d!\n",
                           pszProperty (pTupleCur->ulProperty),
                           pTupleCur->ulProperty));
               break;
            }
            }

            if (!fPrinted)
            {
               DBPRINTF (("QJPROc:                    Query '%30s'/%5d!\n",
                           pszProperty (pTupleCur->ulProperty),
                           pTupleCur->ulProperty));
            }
         }
         else if (pTupleCur->lType == DJP_ALL)
         {
            /* No assumptions are made here.  pbNext must be set up by each
            ** case statement
            */
            fPrinted = FALSE;
            switch (pTupleCur->ulProperty)
            {
            case DJP_SJ_ORIENTATION:
            {
               PDJPT_ORIENTATION pTmp = DJP_ELEMENTP (*pIQuery, DJPT_ORIENTATION);

               *pTmp++ = DJP_ORI_PORTRAIT;
               *pTmp++ = DJP_ORI_LANDSCAPE;

               pIQuery->ulNumReturned = 2;
               pbNext = (PBYTE)pTmp;
               break;
            }

            case DJP_CJ_RESOLUTION:
            {
               PDJPT_RESOLUTION   pRes         = DJP_ELEMENTP (*pIQuery, DJPT_RESOLUTION);
               PRESINFO           pResInfo     = pDriver->pRES;
               ULONG              ulNumDefined = pDriver->ulNumRes;
               PULONG             pulResDevice = pDevice->pulRES;
               ULONG              ulNumDevice  = pDevice->usNumRes;
               DJPT_RESOLUTION    Res;
               INT                iNumReturned = 0;
               BOOL               fFound;
               register INT       i, j;

               for (i = 0; i < ulNumDevice; i++)
               {
                  fFound = FALSE;

                  for (j = 0; j < ulNumDefined; j++)
                  {
                     if (pResInfo[j].ulResID == *pulResDevice)
                     {
                        fFound = TRUE;

                        Res.usXResolution = pResInfo[j].ulXRes;
                        Res.usYResolution = pResInfo[j].ulYRes;
                        *pRes++ = Res;

                        pbNext = (PBYTE)pRes;
                     }
                  }

                  if (!fFound)
                  {
                     DBPRINTF (("QJPROa: Error: ResInfo not found %d\n", *pulResDevice));
                  }
                  else
                  {
                     iNumReturned++;
                  }

                  pulResDevice++;
               }

               pIQuery->ulNumReturned = iNumReturned;

               if (0 == iNumReturned)
               {
                  DBPRINTF (("QJPROa: Error: nothing returned\n"));

                  pbNext = (PBYTE)(pIQuery + 1);
                  fCurError = TRUE;
               }
               break;
            }

            case DJP_SJ_PRINTQUALITY:
            {
               PDJPT_PRINTQUALITY pQual         = DJP_ELEMENTP (*pIQuery, DJPT_PRINTQUALITY);
               PDJPT_PRINTQUALITY apqlQualities = NULL;
               INT                iNumIDs;

               iNumIDs = NumPrintQualityIDs (pDriver,
                                             pDevice,
                                             &apqlQualities);
               assertT (0 >= iNumIDs);
               assertF (apqlQualities);

               if (0 < iNumIDs && apqlQualities)
               {
                  pIQuery->ulNumReturned = iNumIDs;

                  memcpy (pQual,
                          apqlQualities,
                          iNumIDs * sizeof (DJPT_PRINTQUALITY));
                  pbNext = (PBYTE)pQual
                                + iNumIDs * sizeof (DJPT_PRINTQUALITY);

                  GplMemoryFree (apqlQualities);
               }
               else
               {
                  DBPRINTF (("QJPROa: Error: nothing returned\n"));
                  pIQuery->ulNumReturned = 0;
                  pbNext = (PBYTE)(pIQuery + 1);
                  fCurError = TRUE;
               }
               break;
            }

            case DJP_SJ_BITSPERPEL:
            case DJP_SJ_COLOR:
            {
               PPRINTMODE       pPrintMode    = pDriver->pPrintModes;
               ULONG            ulNumDefined  = pDriver->ulNumPrintModes;
               PULONG           pulPrintModes = pDevice->pulPrintModes;
               ULONG            ulNumDevice   = pDevice->usNumPrintModes;
               PDJPT_BITSPERPEL pTmp          = DJP_ELEMENTP (*pIQuery, DJPT_BITSPERPEL);
               INT              iNumReturned  = 0;
               BOOL             fFoundMono    = FALSE,
                                fFoundColor   = FALSE;
               register INT     i, j;

               for (i = 0; i < ulNumDevice; i++)
               {
                  for (j = 0; j < ulNumDefined; j++)
                  {
                     if (pPrintMode[j].ulPrintModeID == pulPrintModes[i])
                     {
                        if (DJP_SJ_BITSPERPEL == pTupleCur->ulProperty)
                        {
                           *pTmp++ = pPrintMode[j].usLogBitCount;
                           iNumReturned++;
                        }
                        else
                        {
                           /* Only return 1 instance for each no matter how
                           ** many print modes there are.
                           */
                           if (1 == pPrintMode[j].usBitsPerPel &&
                               !fFoundMono                      )
                           {
                              fFoundMono = TRUE;
                              *pTmp++ = DJP_CLR_MONOCHROME;
                              iNumReturned++;
                           }
                           else if (!fFoundColor)
                           {
                              fFoundColor = TRUE;
                              *pTmp++ = DJP_CLR_COLOR;
                              iNumReturned++;
                           }
                        }
                     }
                  }

                  pulPrintModes++;
               }

               pIQuery->ulNumReturned = iNumReturned;

               if (0 == iNumReturned)
               {
                  DBPRINTF (("QJPROa: Error: nothing returned\n"));
                  pbNext = (PBYTE)(pIQuery + 1);
                  fCurError = TRUE;
               }
               else
                  pbNext = (PBYTE)pTmp;
               break;
            }

            case DJP_SJ_PAPERSIZE:
            {
               ULONG           ulNumDefined = pDevice->ulNumForms;
               PFORMINFO2      pFormInfo    = pDevice->pFORMS;
               PDJPT_PAPERSIZE pSize        = DJP_ELEMENTP (*pIQuery, DJPT_PAPERSIZE);
               INT             iNumReturned = 0;
               register INT    i;

               for (i = 0; i < ulNumDefined; i++)
               {
                  LONG  lRet;

                  lRet = pFormInfo[i].ulDJPid;

                  if (DJP_PSI_NONE == lRet)
                  {
                     fCurError = TRUE;
                     DBPRINTF (("QJPROa: Error: Form id not translatable %d\n", pFormInfo[i].ulFormID));
                  }
                  else
                  {
                     iNumReturned++;
                     *pSize++ = lRet;

                     pbNext = (PBYTE)pSize;
                  }
               }

               pIQuery->ulNumReturned = iNumReturned;

               if (0 == iNumReturned)
               {
                  pbNext = (PBYTE)(pIQuery + 1);
                  fCurError = TRUE;
                  DBPRINTF (("QJPROa: Error: nothing returned\n"));
               }
               break;
            }

            case DJP_CJ_FORM:
            {
               PDJPT_FORM   pDJPForm    = DJP_ELEMENTP (*pIQuery, DJPT_FORM);
               PUSERCONNECT pUserConn;
               ULONG        ulFormID,
                            ulTrayID,
                            ulMediaID;
               INT          iNumReturned = 0;
               register INT i;

               iNumReturned = 0;

               for (i = 0; i < pDevice->usNumConnects; i++)
               {
                  GetIDsFromConnID (pDriver,
                                    pDevice,
                                    pDevice->pulCONNECTS[i],
                                    &ulTrayID,
                                    &ulFormID,
                                    &ulMediaID);

                  FillFormInfo (pDJPForm,
                                ulTrayID,
                                ulFormID,
                                ulMediaID,
                                pdb,
                                pJobProp->ulDefResID);

                  pDJPForm++;
                  pbNext = (PBYTE)pDJPForm;
                  iNumReturned++;
               }

               // get pointer to first user-defined form connection
               pUserConn = pDevice->pUserDefData->pUserCONNECTS;

               // as long as we have user-defined form connections
               while (pUserConn)
               {
                  FillFormInfo (pDJPForm,
                                pUserConn->fcUser.ulTrayID,
                                pUserConn->fcUser.ulFormID,
                                pUserConn->fcUser.ulMediaID,
                                pdb,
                                pJobProp->ulDefResID);

                  pDJPForm++;
                  pbNext = (PBYTE)pDJPForm;
                  iNumReturned++;

                  // Move to the next connection
                  pUserConn = pUserConn->pNextConnect;
               }

               pIQuery->ulNumReturned = iNumReturned;

               if (0 == iNumReturned)
               {
                  pbNext = (PBYTE)(pIQuery + 1);
                  fCurError = TRUE;
                  DBPRINTF (("QJPROa: Error: nothing returned\n"));
               }
               break;
            }

            case DJP_CJ_MIXEDFORMS:
            {
               PDJPT_MIXEDFORMS pDJPMXForm     = DJP_ELEMENTP (*pIQuery, DJPT_MIXEDFORMS);
               ULONG            ulDefaultFormID,
                                ulDefaultTrayID,
                                ulDefaultMediaID;

               GetIDsFromConnID (pDriver,
                                 pDevice,
                                 pJobProp->ulDefConnID,
                                 &ulDefaultTrayID,
                                 &ulDefaultFormID,
                                 &ulDefaultMediaID);

               pDJPMXForm->lStartRange = DJP_MXF_INFINITY;
               pDJPMXForm->lEndRange   = DJP_MXF_INFINITY;

               FillFormInfo (&pDJPMXForm->djpfmForm,
                             ulDefaultTrayID,
                             ulDefaultFormID,
                             ulDefaultMediaID,
                             pdb,
                             pJobProp->ulDefResID);

               pDJPMXForm++;
               pbNext = (PBYTE)pDJPMXForm;

               pIQuery->ulNumReturned = 1;
               break;
            }

            case DJP_SJ_TRAYTYPE:
            case DJP_CJ_TRAYNAME:
            {
               ULONG           ulNumDevice  = pDevice->usNumTrays;
               PULONG          pulTrays     = pDevice->pulTRAYS;
               ULONG           ulNumDefined = pDriver->ulNumTrays;
               PTRAYINFO       pTrayInfo    = pDriver->pTRAYS;
               PDJPT_TRAYTYPE  pDJPTrayType = DJP_ELEMENTP (*pIQuery, DJPT_TRAYTYPE);
               PDJPT_TRAYNAME  pDJPTrayName = DJP_ELEMENTP (*pIQuery, DJPT_TRAYNAME);
               PTRAYINFO       pTrayRet     = NULL;
               INT             iNumReturned = 0;
               LONG            lRet;
               BOOL            fFound;
               register INT    i, j;

               for (i = 0; i < ulNumDevice; i++)
               {
                  fFound = FALSE;

                  for (j = 0; j < ulNumDefined; j++)
                  {
                     if (pTrayInfo[j].ulTrayID == *pulTrays)
                     {
                        if (DJP_SJ_TRAYTYPE == pTupleCur->ulProperty)
                        {
                           lRet = pTrayInfo[j].ulDJPid;

                           if (DJP_TRY_NONE != lRet)
                           {
                              fFound = TRUE;

                              *pDJPTrayType++ = lRet;

                              pbNext = (PBYTE)pDJPTrayType;
                           }
                        }
                        else if (DJP_CJ_TRAYNAME == pTupleCur->ulProperty)
                        {
                           lRet = TrayInfoFromID (pDriver,
                                                  pDevice,
                                                  pTrayInfo[j].ulTrayID,
                                                  &pTrayRet);

                           if (lRet)
                           {
                              CHAR  szTrayName[LEN_STRING];

                              fFound = TRUE;

                              TrayNameFromID (pDriver,
                                              pDevice,
                                              szTrayName,
                                              pTrayRet->ulTrayID);

                              SafeStrNCpy (pDJPTrayName->szTrayname,
                                           szTrayName,
                                           sizeof (pDJPTrayName->szTrayname));
                              SafeStrNCpy (pDJPTrayName->szDisplayTrayname,
                                           szTrayName,
                                           sizeof (pDJPTrayName->szDisplayTrayname));

                              pDJPTrayName->djpttTrayID = pTrayRet->ulDJPid;

                              pDJPTrayName++;
                              pbNext = (PBYTE)pDJPTrayName;
                           }
                        }
                     }
                  }

                  if (!fFound)
                  {
                     DBPRINTF (("QJPROa: Error: Tray not found %d\n", *pulTrays));
                  }
                  else
                  {
                     iNumReturned++;
                  }

                  pulTrays++;
               }

               pIQuery->ulNumReturned = iNumReturned;

               if (0 == iNumReturned)
               {
                  pbNext = (PBYTE)(pIQuery + 1);
                  fCurError = TRUE;
                  DBPRINTF (("QJPROa: Error: nothing returned\n"));
               }
               break;
            }

            case DJP_SJ_MEDIA:
            {
               ULONG           ulNumDevice  = pDevice->ulNumMedias;
               PULONG          pulMedias    = pDevice->pulMEDIAS;
               ULONG           ulNumDefined = pDriver->ulNumMedias;
               PMEDIAINFO      pMediaInfo   = pDriver->pMEDIAS;
               PDJPT_MEDIA     pMedia       = DJP_ELEMENTP (*pIQuery, DJPT_MEDIA);
               INT             iNumReturned = 0;
               LONG            lRet;
               BOOL            fFound;
               register INT    i, j;

               for (i = 0; i < ulNumDevice; i++, pulMedias++)
               {
                  fFound = FALSE;

                  for (j = 0; j < ulNumDefined; j++)
                  {
                     if (pMediaInfo[j].ulMediaID == *pulMedias)
                     {
                        lRet = pMediaInfo[j].ulDJPid;

                        if (DJP_MED_NONE != lRet)
                        {
                           fFound = TRUE;

                           *pMedia++ = lRet;
                        }
                     }
                  }

                  if (!fFound)
                  {
                     DBPRINTF (("QJPROa: Error: media not found %d\n", *pulMedias));
                  }
                  else
                  {
                     iNumReturned++;
                  }
               }

               pIQuery->ulNumReturned = iNumReturned;

               if (0 == iNumReturned)
               {
                  pbNext = (PBYTE)(pIQuery + 1);
                  fCurError = TRUE;
                  DBPRINTF (("QJPROa: Error: nothing returned\n"));
               }
               else
                  pbNext = (PBYTE)pMedia;
               break;
            }

            case DJP_SJ_FORMFEEDCONTROL:
            {
               PDJPT_FORMFEEDCONTROL pTmp = DJP_ELEMENTP (*pIQuery, DJPT_FORMFEEDCONTROL);

               *pTmp++ = DJP_FFC_NONE;
               *pTmp++ = DJP_FFC_CONDITIONAL;
               *pTmp++ = DJP_FFC_COMPULSORY;

               pIQuery->ulNumReturned = 3;
               pbNext = (PBYTE)pTmp;
               break;
            }

#ifdef SUPPORTS_COPIES
            case DJP_SJ_COPIES:
            {
               pIQuery->lType         = DJP_ERROR_NOT_ENUM;
               pIQuery->ulNumReturned = 0;
               pIQuery->ulValue       = DJP_NONE;

               pbNext = (PBYTE)(pIQuery + 1);

               fError = TRUE;
               DBPRINTF (("QJPROa: Error: Copies not enumerable\n"));
               break;
            }
#endif

            case DJP_NONE:
            {
               // Nothing to do!
               pIQuery->ulNumReturned = 0;
               pIQuery->ulValue       = DJP_NONE;

               pbNext = (PBYTE)(pIQuery + 1);
               break;
            }

            /* Things we don't support
            */
#ifndef SUPPORTS_COPIES
            case DJP_SJ_COPIES:
#endif
            case DJP_SJ_FONTDOWNLOADING:
            case DJP_SJ_DUPLEX:
            case DJP_SJ_COLLATE:
            case DJP_SJ_FEED:
            case DJP_SJ_SCALING:
            case DJP_SJ_MEDIA_COLOR:
            {
               fPrinted  = TRUE;
               fCurError = TRUE;

               pbNext = (PBYTE)(pIQuery + 1);

               DBPRINTF (("QJPROa: Error: Unsupported query '%30s'/%5d!\n",
                           pszProperty (pTupleCur->ulProperty),
                           pTupleCur->ulProperty));
               break;
            }

            /* Everything else we don't understand
            */
            default:
            {
               DBPRINTF (("QJPROa: Error:     Unknown query '%30s'/%5d!\n",
                           pszProperty (pTupleCur->ulProperty),
                           pTupleCur->ulProperty));

               fPrinted  = TRUE;
               fCurError = TRUE;

               pbNext = (PBYTE)(pIQuery + 1);
               break;
            }
            }

            if (!fPrinted)
            {
               DBPRINTF (("QJPROa:                    Query '%30s'/%5d!\n",
                           pszProperty (pTupleCur->ulProperty),
                           pTupleCur->ulProperty));
            }
         }
         else if (DJP_NONE != pTupleCur->lType)
         {
            fCurError = TRUE;

            assertstring ("Unknown query type!\n");
         }

         // We now know the final size
         pIQuery->cb = pbNext - (PBYTE)pIQuery;

         /* @TBD We need some way to stop overwriting memory
         */
         assertT (cbQueries < pIQuery->cb);

         cbQueries -= pIQuery->cb;

         if (fCurError)
         {
            pIQuery->ulNumReturned = 0;
            pIQuery->ulValue       = DJP_NONE;
            pIQuery->lType         = DJP_ERROR_NOT_SUPPORTED;
            fError                 = TRUE;
         }

         // Move to the next query item
         pIQuery = DJP_NEXT_STRUCTP (pIQuery);

         iNumQueries--;
         pTupleCur++;
      }

      // Clean up
      if (pTuples)
         GplMemoryFree (pTuples);

      if (fError)
      {
         GplErrSetWarning (PMERR_DATATYPE_ENTRY_INVALID);
         ulrc = DEV_WARNING;
      }
      else
      {
         // good result
         ulrc = DEV_OK;
      }
      break;
   } /* end case DEVPE_QUERYJOBPROPERTIES*/

   case DEVPE_SETJOBPROPERTIES:
   {
      INT            cbSets      = cbParm1;
      PBYTE          pbQueries   = pbParm1;
      PDJP_ITEM      pISet       = (PDJP_ITEM)pbQueries;
      BOOL           fError      = FALSE;
      BOOL           fDJPWarning = FALSE;
      BOOL           fPrinted;
      ULONG          ulMaxSize;

      // Output buffer must be at least one item in size
      if (sizeof (DJP_ITEM) > cbSets)
      {
         DBPRINTF (("Buffer must be at least one item in size!\n"));
         ulrc = DEV_BAD_PARAMETERS;
         assertT (ulrc);
         break;
      }

      assertT (0 >= cbSets);

      // Update the job properties with the input set list
      do
      {
         if (sizeof (DJP_ITEM) > cbSets)
         {
            fError = DEV_PROP_BUF_TOO_SMALL;
            assertstring ("Not enough space left!\n");
            break;
         }

         fPrinted = FALSE;
         switch (pISet->ulProperty)
         {
         case DJP_SJ_ORIENTATION:
         {
            if (pISet->ulValue == DJP_ORI_PORTRAIT)
            {
               pJobProp->ulOrientation = ORIENTATION_PORTRAIT;
            }
            else if (pISet->ulValue == DJP_ORI_LANDSCAPE)
            {
               pJobProp->ulOrientation = ORIENTATION_LANDSCAPE;
            }
            else
            {
               pISet->lType = DJP_ERROR_OUT_OF_RANGE;
               fDJPWarning  = TRUE;
               DBPRINTF (("SJPRO: Error: Orientation not in range %d\n", pISet->ulValue));
            }
            break;
         }

         case DJP_CJ_RESOLUTION:
         case DJP_SJ_PRINTQUALITY:
         {
            PDJPT_RESOLUTION   pRes         = DJP_ELEMENTP (*pISet, DJPT_RESOLUTION);
            PDJPT_PRINTQUALITY pQual        = DJP_ELEMENTP (*pISet, DJPT_PRINTQUALITY);
            PRESINFO           pResInfo     = pDriver->pRES;
            PRESINFO           pResQual     = NULL;
            ULONG              ulNumDefined = pDriver->ulNumRes;
            PULONG             pulResDevice = pDevice->pulRES;
            ULONG              ulNumDevice  = pDevice->usNumRes;
            BOOL               fFound       = FALSE;
            register INT       i, j;

            /* Since DJP_CJ_RESOLUTION or DJP_SJ_PRINTQUALITY is an imprecise 
            /* selection, if the current job properties are in the correct 
            /* input format then continue to use the current job properties.
            */

            for (i = 0; i < ulNumDefined; i++)
            {
               if (pJobProp->ulDefResID == pResInfo[i].ulResID)
               {
                  if (DJP_CJ_RESOLUTION == pISet->ulProperty)
                  {
                     if (pRes->usXResolution == pResInfo[i].ulXRes &&
                         pRes->usYResolution == pResInfo[i].ulYRes  )
                     {
                        fFound = TRUE;
                        break;
                     }
                  }
                  else
                  {
                     if (ValidDJPPQLValue (pResInfo[i].ulDJPInfo) &&  // valid
                         pResInfo[i].ulDJPInfo == *pQual)             // same
                     {
                        fFound = TRUE;
                        break;
                     }
                  }
               }
            }

            if (fFound)
            {
               // Finished!
               DBPRINTF (("SJPRO: Using current job properties\n"));
               break;
            }

            if (DJP_SJ_PRINTQUALITY == pISet->ulProperty)
               pResQual = FromPrintQualityID (pDriver, pDevice, *pQual);

            for (i = 0; !fFound && i < ulNumDevice; i++, pulResDevice++)
            {
               for (j = 0; j < ulNumDefined; j++)
               {
                  if (pResInfo[j].ulResID == *pulResDevice)
                  {
                     if (DJP_CJ_RESOLUTION == pISet->ulProperty)
                     {
                        if (pRes->usXResolution == pResInfo[j].ulXRes &&
                            pRes->usYResolution == pResInfo[j].ulYRes  )
                        {
                           fFound = TRUE;
                           pJobProp->ulDefResID = *pulResDevice;
                           break;
                        }
                     }
                     else
                     {
                        if (pResInfo + j == pResQual)
                        {
                           fFound = TRUE;
                           pJobProp->ulDefResID = *pulResDevice;
                           break;
                        }
                     }
                  }
               }
            }

            if (!fFound)
            {
               DBPRINTF (("SJPRO: Error: resolution not found\n"));
               pISet->lType = DJP_ERROR_OUT_OF_RANGE;
               fDJPWarning  = TRUE;
            }
            break;
         }

         case DJP_SJ_BITSPERPEL:
         {
            PPRINTMODE       pPrintMode    = pDriver->pPrintModes;
            ULONG            ulNumDefined  = pDriver->ulNumPrintModes;
            PULONG           pulPrintModes = pDevice->pulPrintModes;
            ULONG            ulNumDevice   = pDevice->usNumPrintModes;
            PDJPT_BITSPERPEL pTmp          = DJP_ELEMENTP (*pISet, DJPT_BITSPERPEL);
            BOOL             fFound        = FALSE;
            register INT     i, j;

            /* Since DJP_SJ_BITSPERPEL is an imprecise selection, if the current
            ** job properties are in the correct input format then continue
            ** to use the current job properties.
            */
            for (i = 0; !fFound && i < ulNumDefined;i++)
            {
               if (pJobProp->ulDefPrintModeID == pPrintMode[i].ulPrintModeID)
               {
                  if (*pTmp == pPrintMode[i].usLogBitCount)
                  {
                     fFound = TRUE;
                     break;
                  }
               }
            }

            if (fFound)
            {
               // Finished!
               DBPRINTF (("SJPRO: Using current job properties\n"));
               break;
            }

            /* Otherwise, use the first match.
            */
            for (i = 0; !fFound && i < ulNumDevice; i++, pulPrintModes++)
            {
               fFound = FALSE;

               for (j = 0; j < ulNumDefined; j++)
               {
                  if (pPrintMode[j].ulPrintModeID == *pulPrintModes)
                  {
                     if (*pTmp == pPrintMode[j].usLogBitCount)
                     {
                        pJobProp->ulDefPrintModeID = *pulPrintModes;
                        fFound = TRUE;
                        break;
                     }
                  }
               }
            }

            if (!fFound)
            {
               DBPRINTF (("SJPRO: Error: print mode not found\n"));
               pISet->lType = DJP_ERROR_OUT_OF_RANGE;
               fDJPWarning  = TRUE;
            }
            break;
         }

         case DJP_SJ_COLOR:
         {
            PPRINTMODE       pPrintMode      = pDriver->pPrintModes;
            PPRINTMODE       pMonoPrintMode  = (PPRINTMODE)NULL;
            PPRINTMODE       pColorPrintMode = (PPRINTMODE)NULL;
            ULONG            ulNumDefined    = pDriver->ulNumPrintModes;
            PULONG           pulPrintModes   = pDevice->pulPrintModes;
            ULONG            ulNumDevice     = pDevice->usNumPrintModes;
            PDJPT_COLOR      pTmp            = DJP_ELEMENTP (*pISet, DJPT_COLOR);
            BOOL             fFound          = FALSE;
            register INT     i, j;

            /* Since DJP_SJ_COLOR is an imprecise selection, if the current
            ** job properties are in the correct format (1bpp for monochrome
            ** or < 1 for color), then continue to use the current job
            ** properties.
            */
            for (i = 0; !fFound && i < ulNumDefined;i++)
            {
               if (pJobProp->ulDefPrintModeID == pPrintMode[i].ulPrintModeID)
               {
                  if (  (  (DJP_CLR_MONOCHROME == *pTmp)
                        && (1 == pPrintMode[i].usBitsPerPel)
                        )
                     || (  (DJP_CLR_COLOR == *pTmp)
                        && (1 < pPrintMode[i].usBitsPerPel)
                        )
                     )
                  {
                      fFound = TRUE;
                      break;
                  }
               }
            }

            if (fFound)
            {
               // Finished!
               DBPRINTF (("SJPRO: Using current job properties\n"));
               break;
            }

            /* Otherwise, try to find the first monochrome or the best
            ** color selection.
            */
            for (i = 0; !fFound && i < ulNumDevice; i++, pulPrintModes++)
            {
               for (j = 0; j < ulNumDefined; j++)
               {
                  if (pPrintMode[j].ulPrintModeID == *pulPrintModes)
                  {
                     // Find the first available monochrome print mode
                     if (  (NULL == pMonoPrintMode)
                        && (1 == pPrintMode[j].usBitsPerPel)
                        )
                     {
                        pMonoPrintMode = pPrintMode + j;
                     }

                     // Find the best available color print mode
                     if (  (  (NULL == pColorPrintMode)
                           && (1 <  pPrintMode[j].usBitsPerPel)
                           )  // First color mode found
                        || (  (NULL != pColorPrintMode)
                           && (pPrintMode[j].usBitsPerPel > pColorPrintMode->usBitsPerPel)
                           )  // A better one is found
                        )
                     {
                        pColorPrintMode = pPrintMode + j;
                     }
                  }
               }
            }

            if (  DJP_CLR_MONOCHROME == *pTmp
               && pMonoPrintMode
               )
            {
               fFound = TRUE;
               pJobProp->ulDefPrintModeID = pMonoPrintMode->ulPrintModeID;
            }
            else if (  DJP_CLR_COLOR == *pTmp
                    && pColorPrintMode
                    )
            {
               fFound = TRUE;
               pJobProp->ulDefPrintModeID = pColorPrintMode->ulPrintModeID;
            }

            if (!fFound)
            {
               DBPRINTF (("SJPRO: Error: print mode not found\n"));
               pISet->lType = DJP_ERROR_OUT_OF_RANGE;
               fDJPWarning  = TRUE;
            }
#ifdef DEBUG
            else
            {
               DBPRINTF (("SJPRO: The best print mode found is id %d\n", pJobProp->ulDefPrintModeID));
            }
#endif
            break;
         }

         case DJP_SJ_PAPERSIZE:
         {
            ULONG           ulNumDefined = pDevice->ulNumForms;
            PFORMINFO2      pFormInfo    = pDevice->pFORMS;
            PDJPT_PAPERSIZE pSize        = DJP_ELEMENTP (*pISet, DJPT_PAPERSIZE);
            BOOL            fFound       = FALSE;
            LONG            lRet;
            register INT i;

            for (i = 0; i < ulNumDefined; i++)
            {
               lRet = pFormInfo[i].ulDJPid;

               if (DJP_PSI_NONE != lRet && *pSize == lRet)
               {
                  fFound = TRUE;
                  break;
               }
            }

            if (fFound)
            {
               ULONG  ulDefaultConnID  = pJobProp->ulDefConnID,
                      ulDefaultFormID  = 0,
                      ulDefaultTrayID  = 0,
                      ulDefaultMediaID = 0;
               BOOL   bOK;

               // Ask for the current connection id
               bOK = GetIDsFromConnID (pDriver,
                                       pDevice,
                                       ulDefaultConnID,
                                       &ulDefaultTrayID,
                                       &ulDefaultFormID,
                                       &ulDefaultMediaID);

               if (bOK)
                  // Get a new connection id
                  bOK = NewConnection (pdb,
                                       pGoodDrivData->szDeviceName,
                                       &ulDefaultConnID,
                                       pFormInfo[i].ulFormID, // Override form
                                       ulDefaultTrayID,
                                       ulDefaultMediaID,
                                       pDevice->pUserDefData->pUserCONNECTS,
                                       FALSE);                // Dont create a new one!

               // Set it!
               if (bOK)
               {
                  pJobProp->ulDefConnID = ulDefaultConnID;
               }
               else
               {
                  DBPRINTF (("SJPRO: Error: connection with paper size not found\n"));
                  pISet->lType = DJP_ERROR_OUT_OF_RANGE;
                  fDJPWarning  = TRUE;
               }
            }
            else
            {
               DBPRINTF (("SJPRO: Error: paper size not found\n"));
               pISet->lType = DJP_ERROR_OUT_OF_RANGE;
               fDJPWarning  = TRUE;
            }
            break;
         }

         case DJP_CJ_FORM:
         {
            ULONG           ulNumDefined;
            ULONG           ulNumDevice;
            PDJPT_FORM      pDJPForm         = DJP_ELEMENTP (*pISet, DJPT_FORM);
            PFORMINFO2      pFormInfo        = (PFORMINFO2)NULL;
            PTRAYINFO       pTrayInfo        = (PTRAYINFO)NULL;
            PMEDIAINFO      pMediaInfo       = (PMEDIAINFO)NULL;
            CHAR            szTempName[32];
            ULONG           ulDefaultConnID  = pJobProp->ulDefConnID;
            PUSERCONNECT    pUserConn;
            FORMINFO2       UserForm;
            BOOL            bOK;
            register INT    i, j;

            ulNumDevice = pDevice->ulNumForms;
            for (i = 0; i < ulNumDevice; i++)
            {
               FormNameFromID (pDriver,
                               pDevice,
                               szTempName,
                               pDevice->pFORMS[i].ulFormID);

               if (0 == strcmp (pDJPForm->szFormname, szTempName))
               {
                  pFormInfo = (PFORMINFO2) &pDevice->pFORMS[i];
                  break;
               }
            }

            if (!pFormInfo)
            {
               //------------------------------------------
               // USER-DEFINED CONNECTIONS: Add to size
               //------------------------------------------

               // get pointer to first user-defined form connection
               pUserConn = pDevice->pUserDefData->pUserCONNECTS;

               // as long as we have user-defined form connections
               while (pUserConn)
               {
                  bOK = FormInfoFromID (pDriver,
                                        pDevice,
                                        pUserConn->fcUser.ulFormID,
                                        &UserForm);

                  if (bOK                                     &&
                      0 == strcmp (pDJPForm->szFormname,
                                   UserForm.hcInfo.szFormname) )
                  {
                     pFormInfo = &UserForm;
                     break;
                  }

                  // Move to the next connection
                  pUserConn = pUserConn->pNextConnect;
               }
            }

            if (pDJPForm->szTrayname[0])
            {
               ulNumDevice  = pDevice->usNumTrays;
               ulNumDefined = pDriver->ulNumTrays;

               for (i = 0; i < ulNumDefined && !pTrayInfo; i++)
               {
                  for (j = 0; j < ulNumDevice; j++)
                  {
                     if (pDriver->pTRAYS[i].ulTrayID == pDevice->pulTRAYS[j])
                     {
                        TrayNameFromID (pDriver,
                                        pDevice,
                                        szTempName,
                                        pDriver->pTRAYS[i].ulTrayID);

                        if (0 == strcmp (pDJPForm->szTrayname, szTempName))
                        {
                           pTrayInfo = (PTRAYINFO) &pDriver->pTRAYS[i];
                           break;
                        }
                     }
                  }
               }
            }

            if (pDJPForm->szMedianame[0])
            {
               ulNumDevice  = pDevice->ulNumMedias;
               ulNumDefined = pDriver->ulNumMedias;

               for (i = 0; i < ulNumDefined && !pMediaInfo; i++)
               {
                  for (j = 0; j < ulNumDevice; j++)
                  {
                     if (pDriver->pMEDIAS[i].ulMediaID == pDevice->pulMEDIAS[j])
                     {
                        MediaNameFromID (pDriver,
                                         pDevice,
                                         szTempName,
                                         pDriver->pMEDIAS[i].ulMediaID);

                        if (0 == strcmp (pDJPForm->szMedianame, szTempName))
                        {
                           pMediaInfo = (PMEDIAINFO) &pDriver->pMEDIAS[i];
                           break;
                        }
                     }
                  }
               }
            }

            if (pFormInfo)
            {
               ULONG  ulDefaultFormID  = 0,
                      ulDefaultTrayID  = 0,
                      ulDefaultMediaID = 0;

               // Ask for the current connection id
               bOK = GetIDsFromConnID (pDriver,
                                       pDevice,
                                       ulDefaultConnID,
                                       &ulDefaultTrayID,
                                       &ulDefaultFormID,
                                       &ulDefaultMediaID);

               ulDefaultFormID = pFormInfo->ulFormID;
               if (pTrayInfo)
                  ulDefaultTrayID = pTrayInfo->ulTrayID;
               if (pMediaInfo)
                  ulDefaultMediaID = pMediaInfo->ulMediaID;

               bOK = NewConnection (pdb,
                                    pGoodDrivData->szDeviceName,
                                    &ulDefaultConnID,
                                    ulDefaultFormID,
                                    ulDefaultTrayID,
                                    ulDefaultMediaID,
                                    pDevice->pUserDefData->pUserCONNECTS,
                                    FALSE);           // Dont create a new one!
               if (!bOK)
               {
                  DBPRINTF (("SJPRO: Error: No connection found\n"));
               }
            }
            else
            {
               bOK = FALSE;
               DBPRINTF (("SJPRO: Error: No form info found\n"));
            }

            if (bOK)
            {
               pJobProp->ulDefConnID = ulDefaultConnID;
            }
            else
            {
               pISet->lType = DJP_ERROR_OUT_OF_RANGE;
               fDJPWarning  = TRUE;
            }
         }
         break;

         case DJP_CJ_MIXEDFORMS:
         {
            pISet->lType = DJP_ERROR_NOT_SUPPORTED;
            fDJPWarning  = TRUE;
            break;
         }

         case DJP_SJ_TRAYTYPE:
         case DJP_CJ_TRAYNAME:
         {
            PDJPT_TRAYTYPE  pDJPTrayType = DJP_ELEMENTP (*pISet, DJPT_TRAYTYPE);
            PDJPT_TRAYNAME  pDJPTrayName = DJP_ELEMENTP (*pISet, DJPT_TRAYNAME);
            ULONG           ulNumDevice  = pDevice->usNumTrays;
            PULONG          pulTrays     = pDevice->pulTRAYS;
            ULONG           ulNumDefined = pDriver->ulNumTrays;
            PTRAYINFO       pTrayInfo    = pDriver->pTRAYS;
            BOOL            bFound       = FALSE;
            LONG            lRet;
            register INT    i, j;

            for (i = 0; !bFound && i < ulNumDevice; i++, pulTrays++)
            {
               for (j = 0; j < ulNumDefined; j++)
               {
                  if (pTrayInfo[j].ulTrayID == *pulTrays)
                  {
                     lRet = pTrayInfo[j].ulDJPid;

                     if (DJP_SJ_TRAYTYPE == pISet->ulProperty)
                     {
                        if (DJP_TRY_NONE != lRet && *pDJPTrayType == lRet)
                        {
                           bFound = TRUE;
                           break;
                        }
                     }
                     else if (DJP_CJ_TRAYNAME == pISet->ulProperty)
                     {
                        CHAR  szTrayName[LEN_STRING];

                        TrayNameFromID (pDriver,
                                        pDevice,
                                        szTrayName,
                                        pTrayInfo[j].ulTrayID);

                        if (0 == strcmp (szTrayName, pDJPTrayName->szTrayname))
                        {
                           bFound = TRUE;
                           break;
                        }
                     }
                  }
               }
            }

            if (bFound)
            {
               ULONG  ulDefaultConnID  = pJobProp->ulDefConnID,
                      ulDefaultFormID  = 0,
                      ulDefaultTrayID  = 0,
                      ulDefaultMediaID = 0;
               BOOL   bOK;

               // Ask for the current connection id
               bOK = GetIDsFromConnID (pDriver,
                                       pDevice,
                                       ulDefaultConnID,
                                       &ulDefaultTrayID,
                                       &ulDefaultFormID,
                                       &ulDefaultMediaID);

               if (bOK)
                  // Get a new connection id
                  bOK = NewConnection (pdb,
                                       pGoodDrivData->szDeviceName,
                                       &ulDefaultConnID,
                                       ulDefaultFormID,
                                       pTrayInfo[j].ulTrayID, // Override tray
                                       ulDefaultMediaID,
                                       pDevice->pUserDefData->pUserCONNECTS,
                                       FALSE);           // Dont create a new one!

               // Set it!
               if (bOK)
                  pJobProp->ulDefConnID = ulDefaultConnID;
               else
               {
                  DBPRINTF (("SJPRO: Error: No connection found\n"));
                  pISet->lType = DJP_ERROR_OUT_OF_RANGE;
                  fDJPWarning  = TRUE;
               }
            }
            else
            {
               DBPRINTF (("SJPRO: Error: Tray not found\n"));
               pISet->lType = DJP_ERROR_OUT_OF_RANGE;
               fDJPWarning  = TRUE;
            }
            break;
         }

         case DJP_SJ_MEDIA:
         {
            PDJPT_MEDIA     pMedia       = DJP_ELEMENTP (*pISet, DJPT_MEDIA);
            ULONG           ulNumDevice  = pDevice->ulNumMedias;
            PULONG          pulMedias    = pDevice->pulMEDIAS;
            ULONG           ulNumDefined = pDriver->ulNumMedias;
            PMEDIAINFO      pMediaInfo   = pDriver->pMEDIAS;
            BOOL            bFound       = FALSE;
            LONG            lRet;
            register INT    i, j;

            for (i = 0; !bFound && i < ulNumDevice; i++, pulMedias++)
            {
               for (j = 0; j < ulNumDefined; j++)
               {
                  if (pMediaInfo[j].ulMediaID == *pulMedias)
                  {
                     lRet = pMediaInfo[j].ulDJPid;

                     if (DJP_MED_NONE != lRet && *pMedia == lRet)
                     {
                        bFound = TRUE;
                        break;
                     }
                  }
               }
            }

            if (bFound)
            {
               ULONG  ulDefaultConnID = pJobProp->ulDefConnID,
                      ulDefaultFormID,
                      ulDefaultTrayID,
                      ulDefaultMediaID;
               BOOL   bOK;

               // Ask for the current connection id
               bOK = GetIDsFromConnID (pDriver,
                                       pDevice,
                                       ulDefaultConnID,
                                       &ulDefaultTrayID,
                                       &ulDefaultFormID,
                                       &ulDefaultMediaID);

               if (bOK)
                  // Get a new connection id
                  bOK = NewConnection (pdb,
                                       pGoodDrivData->szDeviceName,
                                       &ulDefaultConnID,
                                       ulDefaultFormID,
                                       ulDefaultTrayID,
                                       pMediaInfo[j].ulMediaID,
                                       pDevice->pUserDefData->pUserCONNECTS,
                                       FALSE);           // Dont create a new one!

               // Set it!
               if (bOK)
               {
                  pJobProp->ulDefConnID = ulDefaultConnID;
               }
               else
               {
                  DBPRINTF (("SJPRO: Error: No connection found\n"));
                  pISet->lType = DJP_ERROR_OUT_OF_RANGE;
                  fDJPWarning  = TRUE;
               }
            }
            else
            {
               DBPRINTF (("SJPRO: Error: Media not found\n"));
               pISet->lType = DJP_ERROR_OUT_OF_RANGE;
               fDJPWarning  = TRUE;
            }
            break;
         }

#ifdef SUPPORTS_COPIES
         case DJP_SJ_COPIES:
         {
            // @TBD what is a valid range of copies
            if (0 < pISet->ulValue && pISet->ulValue < 100)
            {
               pJobProp->ulCopies = pISet->ulValue;
            }
            else
            {
               pISet->lType = DJP_ERROR_OUT_OF_RANGE;
               fDJPWarning  = TRUE;
               DBPRINTF (("SJPRO: Error: copies value %d is bad\n", pISet->ulValue));
            }
            break;
         }
#endif

         case DJP_SJ_FORMFEEDCONTROL:
         {
            if (DJP_FFC_NONE == pISet->ulValue)
            {
               pJobProp->bFFControlType = FF_CTL_NONE;
            }
            else if (DJP_FFC_CONDITIONAL == pISet->ulValue)
            {
               pJobProp->bFFControlType = FF_CTL_CONDITIONAL;
            }
            else if (DJP_FFC_COMPULSORY == pISet->ulValue)
            {
               pJobProp->bFFControlType = FF_CTL_COMPULSORY;
            }
            else
            {
               pISet->lType = DJP_ERROR_OUT_OF_RANGE;
               fDJPWarning  = TRUE;
               DBPRINTF (("SJPRO: Error: form feed control value %d is bad\n", pISet->ulValue));
            }
            break;
         }

         case DJP_NONE:
         {
            // Nothing to do!
            DBPRINTF (("SJPRO: *** EOL ***\n"));
            break;
         }

         /* Things we don't support
         */
#ifndef SUPPORTS_COPIES
         case DJP_SJ_COPIES:
#endif
         case DJP_SJ_FONTDOWNLOADING:
         case DJP_SJ_DUPLEX:
         case DJP_SJ_COLLATE:
         case DJP_SJ_FEED:
         case DJP_SJ_SCALING:
         case DJP_SJ_MEDIA_COLOR:
         {
            DBPRINTF (("SJPRO: Error:  Unsupported query '%30s'/%5d!\n",
                        pszProperty (pISet->ulProperty),
                        pISet->ulProperty));

            fPrinted     = TRUE;
            pISet->lType = DJP_ERROR_NOT_SUPPORTED;
            fDJPWarning  = TRUE;
            break;
         }

         /* Everything else we don't understand
         */
         default:
         {
            DBPRINTF (("SJPRO: Error:       Unknow query '%30s'/%5d!\n",
                        pszProperty (pISet->ulProperty),
                        pISet->ulProperty));

            fPrinted     = TRUE;
            pISet->lType = DJP_ERROR_NOT_SUPPORTED;
            fDJPWarning  = TRUE;
            break;
         }
         }

         if (!fPrinted)
         {
            DBPRINTF (("SJPRO:               Set current '%30s'/%5d.\n",
                        pszProperty (pISet->ulProperty),
                        pISet->ulProperty));
         }
#ifdef DEBUG
         PrintDJPItem (pISet);
#endif

         cbSets -= pISet->cb;

         // Move to the set item
         pISet = DJP_NEXT_STRUCTP (pISet);
         assertF (pISet);

      } while (DJP_NONE != pISet->ulProperty);

      cbDrivData = cbParm2;
      pDrivData  = (PDRIVDATA)pbParm2;

      /* Copy the updated job properties onto the user's job properties
      */
      ulMaxSize = min (pGoodDrivData->cb, cbDrivData);
      memcpy (pDrivData, pGoodDrivData, ulMaxSize);
      pDrivData->cb = ulMaxSize;

      if (fError)
      {
         GplErrSetWarning (PMERR_DATATYPE_ENTRY_INVALID);
         ulrc = DEV_ERROR;
      }
      else if (fDJPWarning)
      {
         GplErrSetWarning (PMERR_DATATYPE_ENTRY_INVALID);
         ulrc = DEV_WARNING;
      }
      else
      {
         ulrc = DEV_OK;
      }
      break;
   } /* end case DEVPE_SETJOBPROPERTIES */

   case DEVESC_DEFAULTJOBPROPERTIES:
   {
      INT            cbSets      = cbParm1;
      PBYTE          pbQueries   = pbParm1;
      PDJP_ITEM      pISet       = (PDJP_ITEM)pbQueries;
      BOOL           fError      = FALSE;
      BOOL           fDJPWarning = FALSE;
      BOOL           fPrinted;
      ULONG          ulMaxSize;

      // Output buffer must be at least one item in size
      if (sizeof (DJP_ITEM) > cbSets)
      {
         DBPRINTF (("Buffer must be at least one item in size!\n"));
         ulrc = DEV_BAD_PARAMETERS;
         assertT (ulrc);
         break;
      }

      assertT (0 >= cbSets);

      // Update the job properties with the input set list
      do
      {
         if (sizeof (DJP_ITEM) > cbSets)
         {
            fError = DEV_PROP_BUF_TOO_SMALL;
            assertstring ("Not enough space left!\n");
            break;
         }

         fPrinted = FALSE;
         switch (pISet->ulProperty)
         {
         case DJP_SJ_ORIENTATION:
         {
            pJobProp->ulOrientation = pDevice->DeviceDefaults.ulOrientation;
            break;
         }

         case DJP_CJ_RESOLUTION:
         case DJP_SJ_PRINTQUALITY:
         {
            pJobProp->ulDefResID = pDevice->DeviceDefaults.ulDefResID;
            break;
         }

         case DJP_SJ_BITSPERPEL:
         case DJP_SJ_COLOR:
         {
            pJobProp->ulDefPrintModeID = pDevice->DeviceDefaults.ulDefPrintModeID;
            break;
         }

         case DJP_SJ_PAPERSIZE:
         case DJP_SJ_TRAYTYPE:
         case DJP_CJ_TRAYNAME:
         case DJP_SJ_MEDIA:
         case DJP_CJ_FORM:
         {
            pJobProp->ulDefConnID = pDevice->DeviceDefaults.ulDefConnID;
            break;
         }

         case DJP_CJ_MIXEDFORMS:
         {
            pISet->lType = DJP_ERROR_NOT_SUPPORTED;
            fDJPWarning  = TRUE;
            break;
         }

#ifdef SUPPORTS_COPIES
         case DJP_SJ_COPIES:
         {
            pJobProp->ulCopies = pDevice->DeviceDefaults.ulCopies;
            break;
         }
#endif

         case DJP_SJ_FORMFEEDCONTROL:
         {
            pJobProp->bFFControlType = pDevice->DeviceDefaults.bFFControlType;
            break;
         }

#ifndef SUPPORTS_COPIES
         case DJP_SJ_COPIES:
#endif
         case DJP_SJ_FONTDOWNLOADING:
         case DJP_SJ_DUPLEX:
         case DJP_SJ_COLLATE:
         case DJP_SJ_FEED:
         case DJP_SJ_SCALING:
         case DJP_SJ_MEDIA_COLOR:
         {
            DBPRINTF (("DJPRO: Error:  Unsupported query '%30s'/%5d!\n",
                        pszProperty (pISet->ulProperty),
                        pISet->ulProperty));

            fPrinted     = TRUE;
            fDJPWarning  = TRUE;
            pISet->lType = DJP_ERROR_NOT_SUPPORTED;
            break;
         }

         /* Everything else we don't understand
         */
         default:
         {
            DBPRINTF (("DJPRO: Error:      Unknown query '%30s'/%5d!\n",
                        pszProperty (pISet->ulProperty),
                        pISet->ulProperty));

            fPrinted     = TRUE;
            fDJPWarning  = TRUE;
            pISet->lType = DJP_ERROR_NOT_SUPPORTED;
            break;
         }
         }

         if (!fPrinted)
         {
            DBPRINTF (("DJPRO:                 Supported '%30s'/%5d!\n",
                        pszProperty (pISet->ulProperty),
                        pISet->ulProperty));
         }

         // Move to the set item
         pISet = DJP_NEXT_STRUCTP (pISet);

      } while (pISet->ulProperty != DJP_NONE);

      cbDrivData = cbParm2;
      pDrivData  = (PDRIVDATA)pbParm2;

      /* Copy the updated job properties onto the user's job properties
      */
      ulMaxSize = min (pGoodDrivData->cb, cbDrivData);
      memcpy (pDrivData, pGoodDrivData, ulMaxSize);
      pDrivData->cb = ulMaxSize;

      if (fError)
      {
         GplErrSetWarning (PMERR_DATATYPE_ENTRY_INVALID);
         ulrc = DEV_ERROR;
      }
      else if (fDJPWarning)
      {
         GplErrSetWarning (PMERR_DATATYPE_ENTRY_INVALID);
         ulrc = DEV_WARNING;
      }
      else
      {
         ulrc = DEV_OK;
      }
      break;
   } /* end case DEVESC_DEFAULTJOBPROPERTIES */

   default:
   {
      ulrc = DEVPE_NOTIMPLEMENTED;
      break;
   }
   } /* end switch */

depart:

   DBPRINTIF ((bShow, "%s(): Exit, ulrc = %d\n", __FUNCTION__, ulrc));

#ifndef DEBUG
   bShow++;          // Avoid compiler warnings
#endif

   UNREGISTERHANDLER (regrec);
   return ulrc;

} /* InnerDeviceQuery */

/****************************************************************************/
/*                                                                          */
/****************************************************************************/
VOID
FillFormInfo (PDJPT_FORM   pDJPForm,
              ULONG        ulTrayID,
              ULONG        ulFormID,
              ULONG        ulMediaID,
              PDEVICEBLOCK pdb,
              ULONG        ulResID)
{
   PDRIVERINFO pDriver         = pdb->pDriver;
   PDEVICEINFO pDevice         = pdb->pDevice;
   FORMINFO2   FormInfo;
   PTRAYINFO   pTrayInfo       = NULL;
   PMEDIAINFO  pMediaInfo      = NULL;
   CHAR        szTrayName[LEN_STRING];
   CHAR        szMediaName[LEN_STRING];

   /* Form info
   */
   GetDefaultFormInfo (pdb,
                       ulFormID,
                       ulResID,
                       &FormInfo);

   pDJPForm->djppsFormID = FormInfo.ulDJPid;

   SafeStrNCpy (pDJPForm->szFormname,
                FormInfo.hcInfo.szFormname,
                sizeof (pDJPForm->szFormname));
   SafeStrNCpy (pDJPForm->szDisplayFormname,
                FormInfo.hcInfo.szFormname,
                sizeof (pDJPForm->szDisplayFormname));

   memcpy ((PBYTE)&pDJPForm->hcInfo,
           (PBYTE)&FormInfo.hcInfo,
           sizeof (FormInfo.hcInfo));

   /* Tray info
   */
   TrayInfoFromID (pDriver,
                   pDevice,
                   ulTrayID,
                   &pTrayInfo);
   TrayNameFromID (pDriver,
                   pDevice,
                   szTrayName,
                   ulTrayID);

   SafeStrNCpy (pDJPForm->szTrayname,
                szTrayName,
                sizeof (pDJPForm->szTrayname));
   SafeStrNCpy (pDJPForm->szDisplayTrayname,
                szTrayName,
                sizeof (pDJPForm->szDisplayTrayname));

   pDJPForm->djpttTrayID = pTrayInfo->ulDJPid;

   /* Media Info
   */
   MediaInfoFromID (pDriver,
                    pDevice,
                    ulMediaID,
                    &pMediaInfo);
   MediaNameFromID (pDriver,
                    pDevice,
                    szMediaName,
                    ulMediaID);

   SafeStrNCpy (pDJPForm->szMedianame,
                szMediaName,
                sizeof (pDJPForm->szMedianame));
   SafeStrNCpy (pDJPForm->szDisplayMedianame,
                szMediaName,
                sizeof (pDJPForm->szDisplayMedianame));

   pDJPForm->djpmdMediaID = pMediaInfo->ulDJPid;
}

/****************************************************************************/
/*                                                                          */
/****************************************************************************/
BOOL
ValidDJPPQLValue (DJPT_PRINTQUALITY djppqlCurrent)
{
   /* Valid DJP value?
   ** NOTE: assumes that DJP_PQL_DRAFT through DJP_PQL_LAST have no
   **       integer gaps.  Ex:  1, 2, 3, 4
   */
   if (DJP_PQL_DRAFT <= djppqlCurrent && djppqlCurrent <= DJP_PQL_LAST)
      return TRUE;
   else
      return FALSE;
}

/****************************************************************************/
/*                                                                          */
/****************************************************************************/
INT
NumPrintQualityIDs (PDRIVERINFO         pDriver,
                    PDEVICEINFO         pDevice,
                    PDJPT_PRINTQUALITY *papqlQualities)
{
   // Note: relies on draft being numerically first!
   BOOL               fSeenQuality[DJP_PQL_LAST];
   INT                iNumSeen;
   PDJPT_PRINTQUALITY apqlQualities;
   PULONG             pulDeviceReses   = pDevice->pulRES;
   ULONG              ulNumDeviceReses = pDevice->usNumRes;
   PRESINFO           pDriverResses    = pDriver->pRES;
   ULONG              ulNumDriverReses = pDriver->ulNumRes;
   PRESINFO           presCurrent;
   register INT       i, j;

   // Clear what was seen
   for (i = 0; i < DJP_PQL_LAST; i++)
      fSeenQuality[i] = FALSE;

   // See them all
   for (i = 0; i < ulNumDeviceReses; i++)
   {
      // Find the driver res for the given device res
      presCurrent = (PRESINFO)NULL;
      for (j = 0; j < ulNumDriverReses; j++)
      {
         if (pulDeviceReses[i] == pDriverResses[j].ulResID)
         {
            presCurrent = &pDriverResses[j];
            break;
         }
      }

      if (presCurrent                              &&
          ValidDJPPQLValue (presCurrent->ulDJPInfo) )
      {
         fSeenQuality[presCurrent->ulDJPInfo - DJP_PQL_DRAFT] = TRUE;
      }
   }

   // Count them
   iNumSeen = 0;
   for (i = 0; i < DJP_PQL_LAST; i++)
      if (fSeenQuality[i])
         iNumSeen++;

   if (0 == iNumSeen)
      // Error
      return -1;

   // Fill in resolutions?
   if (papqlQualities)
   {
      // Allocate them
      apqlQualities = GplMemoryAlloc (globals.pvSharedHeap,
                                      iNumSeen * sizeof (DJPT_PRINTQUALITY));
      assertF (apqlQualities);

      *papqlQualities = apqlQualities;

      // Fill them in
      if (apqlQualities)
      {
         for (i = 0; i < DJP_PQL_LAST; i++)
            if (fSeenQuality[i])
            {
               *apqlQualities = DJP_PQL_DRAFT + i;
               apqlQualities++;
            }
      }
   }

   return iNumSeen;
}

/****************************************************************************/
/*                                                                          */
/****************************************************************************/
LONG
ToPrintQualityID (PDRIVERINFO pDriver,
                  PDEVICEINFO pDevice,
                  PRESINFO    pResInfo)

{
   /* NOTE: assumes that DJP_PQL_DRAFT through DJP_PQL_LAST have no
   **       integer gaps.  Ex:  1, 2, 3, 4
   */
   if (DJP_PQL_DRAFT > pResInfo->ulDJPInfo ||
       DJP_PQL_LAST < pResInfo->ulDJPInfo   )
      // Error!
      return -1;

   return pResInfo->ulDJPInfo;
}

/****************************************************************************/
/*                                                                          */
/****************************************************************************/
PRESINFO
FromPrintQualityID (PDRIVERINFO       pDriver,
                    PDEVICEINFO       pDevice,
                    DJPT_PRINTQUALITY djpQuality)
{
   PULONG             pulDeviceReses   = pDevice->pulRES;
   ULONG              ulNumDeviceReses = pDevice->usNumRes;
   PRESINFO           pDriverResses    = pDriver->pRES;
   ULONG              ulNumDriverReses = pDriver->ulNumRes;
   PRESINFO           presRet          = (PRESINFO)NULL;
   PRESINFO           presCurrent;
   register INT       i, j;

   for (i = 0; i < ulNumDeviceReses; i++)
   {
      // Find the driver res for the given device res
      presCurrent = (PRESINFO)NULL;
      for (j = 0; j < ulNumDriverReses; j++)
      {
         if (pulDeviceReses[i] == pDriverResses[j].ulResID)
         {
            presCurrent = &pDriverResses[j];
            break;
         }
      }

      if (presCurrent                               &&  // found
          ValidDJPPQLValue (presCurrent->ulDJPInfo) &&  // valid
          presCurrent->ulDJPInfo == djpQuality       )  // same
      {
         // Is this the best seen so far?
         if (presRet)
         {
#if 1
            if (presCurrent->ulXRes * presCurrent->ulYRes > // new dpi^2 > old dpi^2
                   presRet->ulXRes * presRet->ulYRes      )
            {
               if (presCurrent->ulYRes > presRet->ulYRes)   // new y-dpi > old y-dpi
                  presRet = presCurrent;
            }
#else
            if (presCurrent->ulXRes > presRet->ulXRes &&
                presCurrent->ulYRes > presRet->ulYRes  )
            {
               presRet = presCurrent;
            }
#endif
         }
         else
            presRet = presCurrent;
      }
   }

   return presRet;
}

#ifdef DEBUG

/****************************************************************************/
/*                                                                          */
/****************************************************************************/
PSZ
pszProperty (ULONG ulProperty)
{
   switch (ulProperty)
   {
   case DJP_NONE:               return "DJP_NONE";
   case DJP_SJ_ORIENTATION:     return "DJP_SJ_ORIENTATION";
   case DJP_CJ_RESOLUTION:      return "DJP_CJ_RESOLUTION";
   case DJP_SJ_BITSPERPEL:      return "DJP_SJ_BITSPERPEL";
   case DJP_SJ_COLOR:           return "DJP_SJ_COLOR";
   case DJP_SJ_PRINTQUALITY:    return "DJP_SJ_PRINTQUALITY";
   case DJP_CJ_FORM:            return "DJP_CJ_FORM";
   case DJP_SJ_PAPERSIZE:       return "DJP_SJ_PAPERSIZE";
   case DJP_SJ_TRAYTYPE:        return "DJP_SJ_TRAYTYPE";
   case DJP_SJ_MEDIA:           return "DJP_SJ_MEDIA";
   case DJP_SJ_MEDIA_COLOR:     return "DJP_SJ_MEDIA_COLOR";
   case DJP_CJ_MIXEDFORMS:      return "DJP_CJ_MIXEDFORMS";
   case DJP_SJ_FONTDOWNLOADING: return "DJP_SJ_FONTDOWNLOADING";
   case DJP_SJ_DUPLEX:          return "DJP_SJ_DUPLEX";
   case DJP_SJ_COLLATE:         return "DJP_SJ_COLLATE";
   case DJP_SJ_FEED:            return "DJP_SJ_FEED";
   case DJP_SJ_COPIES:          return "DJP_SJ_COPIES";
   case DJP_SJ_SCALING:         return "DJP_SJ_SCALING";
   case DJP_SJ_FORMFEEDCONTROL: return "DJP_SJ_FORMFEEDCONTROL";
   case DJP_SJ_N_UP:            return "DJP_SJ_N_UP";
   case DJP_CJ_OUTPUTBIN:       return "DJP_CJ_OUTPUTBIN";
   case DJP_CJ_TRAYNAME:        return "DJP_CJ_TRAYNAME";
   default:                     return "Error: *** unknown ***";
   }
}

/****************************************************************************/
/*                                                                          */
/****************************************************************************/
PSZ
pszType (LONG lType)
{
   switch (lType)
   {
   case DJP_NONE:                return "DJP_NONE";
   case DJP_ALL:                 return "DJP_ALL";
   case DJP_CURRENT:             return "DJP_CURRENT";
   case DJP_ERROR_NOT_SUPPORTED: return "DJP_ERROR_NOT_SUPPORTED";
   case DJP_ERROR_OUT_OF_RANGE:  return "DJP_ERROR_OUT_OF_RANGE";
   case DJP_ERROR_NOT_ENUM:      return "DJP_ERROR_NOT_ENUM";
   case DJP_ERROR_INV_PARMS:     return "DJP_ERROR_INV_PARMS";
   default:                      return "Error: *** unknown ***";
   }
}

/****************************************************************************/
/*                                                                          */
/****************************************************************************/
PSZ
pszMXF (LONG lMXFValue, PSZ pszMXFIn)
{
   switch (lMXFValue)
   {
   case DJP_MXF_INFINITY:       return "DJP_MXF_INFINITY";
   case DJP_MXF_ODD:            return "DJP_MXF_ODD";
   case DJP_MXF_EVEN:           return "DJP_MXF_EVEN";
   default:                     sprintf (pszMXFIn, "%ld", lMXFValue);
                                return pszMXFIn;
   }
}

/****************************************************************************/
/*                                                                          */
/****************************************************************************/
VOID
PrintDJPItem (PDJP_ITEM pDJP)
{
   PBYTE pbEnd;

   switch (pDJP->ulProperty)
   {
   case DJP_SJ_ORIENTATION:
   {
      PDJPT_ORIENTATION pElm = DJP_ELEMENTP (*pDJP, DJPT_ORIENTATION);

      if (DJP_ORI_PORTRAIT == *pElm)
         DBPRINTF (("Portrait\n"));
      else if (DJP_ORI_LANDSCAPE == *pElm)
         DBPRINTF (("Landscape\n"));
      else if (DJP_ORI_REV_PORTRAIT == *pElm)
         DBPRINTF (("Reverse Portrait\n"));
      else if (DJP_ORI_REV_LANDSCAPE == *pElm)
         DBPRINTF (("Reverse Landscape\n"));
      else
         DBPRINTF (("UNKNOWN %d! Error!!!\n", *pElm));

      pbEnd = (PBYTE)(pElm + 1);
      break;
   }

   case DJP_CJ_RESOLUTION:
   {
      PDJPT_RESOLUTION pElm = DJP_ELEMENTP (*pDJP, DJPT_RESOLUTION);

      DBPRINTF (("Resolution is %d x %d\n",
                 pElm->usXResolution,
                 pElm->usYResolution));

      pbEnd = (PBYTE)(pElm + 1);
      break;
   }

   case DJP_SJ_BITSPERPEL:
   {
      PDJPT_BITSPERPEL pElm = DJP_ELEMENTP (*pDJP, DJPT_BITSPERPEL);

      DBPRINTF (("Bits per pel is %d\n", *pElm));

      pbEnd = (PBYTE)(pElm + 1);
      break;
   }

   case DJP_SJ_COLOR:
   {
      PDJPT_COLOR pElm = DJP_ELEMENTP (*pDJP, DJPT_COLOR);

      if (DJP_CLR_MONOCHROME == *pElm)
         DBPRINTF (("Monochrome\n"));
      else if (DJP_CLR_COLOR == *pElm)
         DBPRINTF (("Color\n"));
      else
         DBPRINTF (("UNKNOWN %d! Error!!!\n", *pElm));

      pbEnd = (PBYTE)(pElm + 1);
      break;
   }

   case DJP_SJ_PRINTQUALITY:
   {
      PDJPT_PRINTQUALITY pElm = DJP_ELEMENTP (*pDJP, DJPT_PRINTQUALITY);

      if (DJP_PQL_HIGH == *pElm)
         DBPRINTF (("High\n"));
      else if (DJP_PQL_MEDIUM == *pElm)
         DBPRINTF (("Medium\n"));
      else if (DJP_PQL_LOW == *pElm)
         DBPRINTF (("Low\n"));
      else if (DJP_PQL_DRAFT == *pElm)
         DBPRINTF (("Draft\n"));
      else
         DBPRINTF (("UNKNOWN %d! Error!!!\n", *pElm));

      pbEnd = (PBYTE)(pElm + 1);
      break;
   }

   case DJP_SJ_PAPERSIZE:
   {
      PDJPT_PAPERSIZE pElm = DJP_ELEMENTP (*pDJP, DJPT_PAPERSIZE);

      PrintPaperSizeName (*pElm);

      pbEnd = (PBYTE)(pElm + 1);
      break;
   }

   case DJP_SJ_TRAYTYPE:
   {
      PDJPT_TRAYTYPE pElm = DJP_ELEMENTP (*pDJP, DJPT_TRAYTYPE);

      PrintTrayName (*pElm);

      pbEnd = (PBYTE)(pElm + 1);
      break;
   }

   case DJP_SJ_MEDIA:
   {
      PDJPT_MEDIA pElm = DJP_ELEMENTP (*pDJP, DJPT_MEDIA);

      PrintMediaName (*pElm);

      pbEnd = (PBYTE)(pElm + 1);
      break;
   }

   case DJP_SJ_MEDIA_COLOR:
   {
      PDJPT_MEDIA_COLOR pElm = DJP_ELEMENTP (*pDJP, DJPT_MEDIA_COLOR);

      PrintMediaColor (*pElm);

      pbEnd = (PBYTE)(pElm + 1);
      break;
   }

   case DJP_CJ_FORM:
   {
      PDJPT_FORM       pForm = DJP_ELEMENTP (*pDJP, DJPT_FORM);

      PrintForm (pForm);

      pbEnd = (PBYTE)pForm;
      break;
   }

   case DJP_CJ_MIXEDFORMS:
   {
      CHAR             achMXF[25];
      PDJPT_MIXEDFORMS pElm      = DJP_ELEMENTP (*pDJP, DJPT_MIXEDFORMS);
      PDJPT_FORM       pForm     = (PDJPT_FORM)NULL;
      BOOL             fContinue = FALSE;

      if (DJP_MXF_INFINITY != pElm->lStartRange)
      {
         DBPRINTF (("Error: Start range is not DJP_MXF_INFINITY!\n"));
      }

      do
      {
         DBPRINTF (("Start range        is %s\n", pszMXF (pElm->lStartRange,
                                                  achMXF)));
         DBPRINTF (("End range          is %s\n", pszMXF (pElm->lEndRange,
                                                  achMXF)));

         pForm = &pElm->djpfmForm;

         PrintForm (pForm);

         if (DJP_MXF_INFINITY != pElm->lEndRange)
         {
            fContinue = TRUE;
            pElm++;

            if ((PBYTE)pElm > ((PBYTE)pDJP + pDJP->cb))
            {
               fContinue = FALSE;
            }
         }
         else
         {
            fContinue = FALSE;
         }

         if (fContinue)
         {
            DBPRINTF (("\n"));
         }

      } while (fContinue);

      pElm++;

      pbEnd = (PBYTE)pElm;
      break;
   }

   case DJP_SJ_FONTDOWNLOADING:
   {
      PDJPT_FONTDOWNLOADING pElm = DJP_ELEMENTP (*pDJP, DJPT_FONTDOWNLOADING);

      if (DJP_FDL_NONE == *pElm)
         DBPRINTF (("Device does not support downloading\n"));
      else if (DJP_FDL_DOWNLOAD == *pElm)
         DBPRINTF (("Download fonts to printer\n"));
      else if (DJP_FDL_BITMAP == *pElm)
         DBPRINTF (("Fonts print as bitmaps\n"));
      else if (DJP_FDL_SUBSTITUTE == *pElm)
         DBPRINTF (("Substitue device fonts for system\n"));
      else
         DBPRINTF (("UNKNOWN %d! Error!!!\n", *pElm));

      pbEnd = (PBYTE)(pElm + 1);
      break;
   }

   case DJP_SJ_DUPLEX:
   {
      PDJPT_DUPLEX pElm = DJP_ELEMENTP (*pDJP, DJPT_DUPLEX);

      if (DJP_DUP_NONE == *pElm)
         DBPRINTF (("None\n"));
      else if (DJP_DUP_OFF == *pElm)
         DBPRINTF (("Off\n"));
      else if (DJP_DUP_BOOK == *pElm)
         DBPRINTF (("Book\n"));
      else if (DJP_DUP_FLIP == *pElm)
         DBPRINTF (("Flip\n"));
      else
         DBPRINTF (("UNKNOWN %d! Error!!!\n", *pElm));

      pbEnd = (PBYTE)(pElm + 1);
      break;
   }

   case DJP_SJ_COLLATE:
   {
      PDJPT_COLLATE pElm = DJP_ELEMENTP (*pDJP, DJPT_COLLATE);

      if (DJP_COL_NONE == *pElm)
         DBPRINTF (("Collating none\n"));
      else if (DJP_COL_ON == *pElm)
         DBPRINTF (("Collating on\n"));
      else if (DJP_COL_OFF == *pElm)
         DBPRINTF (("Collating off\n"));
      else if (DJP_COL_PRINTER_SETTING == *pElm)
         DBPRINTF (("Collating uses printer panel setting\n"));
      else
         DBPRINTF (("UNKNOWN %d! Error!!!\n", *pElm));

      pbEnd = (PBYTE)(pElm + 1);
      break;
   }

   case DJP_SJ_FEED:
   {
      PDJPT_FEED pElm = DJP_ELEMENTP (*pDJP, DJPT_FEED);

      if (DJP_FED_MANUAL == *pElm)
         DBPRINTF (("Manual\n"));
      else if (DJP_FED_AUTOMATIC == *pElm)
         DBPRINTF (("Automatic\n"));
      else
         DBPRINTF (("UNKNOWN %d! Error!!!\n", *pElm));

      pbEnd = (PBYTE)(pElm + 1);
      break;
   }

   case DJP_SJ_COPIES:
   {
      PDJPT_COPIES pElm = DJP_ELEMENTP (*pDJP, DJPT_COPIES);

      DBPRINTF (("# copies = %d\n", *pElm));

      pbEnd = (PBYTE)(pElm + 1);
      break;
   }

   case DJP_SJ_SCALING:
   {
      PDJPT_SCALING pElm = DJP_ELEMENTP (*pDJP, DJPT_SCALING);

      DBPRINTF (("%% scaling is %d\n", *pElm));

      pbEnd = (PBYTE)(pElm + 1);
      break;
   }

   case DJP_SJ_FORMFEEDCONTROL:
   {
      PDJPT_FORMFEEDCONTROL pElm = DJP_ELEMENTP (*pDJP, DJPT_FORMFEEDCONTROL);

      if (DJP_FFC_NONE == *pElm)
         DBPRINTF (("Form feed control: None\n"));
      else if (DJP_FFC_CONDITIONAL == *pElm)
         DBPRINTF (("Form feed control: Conditional\n"));
      else if (DJP_FFC_COMPULSORY == *pElm)
         DBPRINTF (("Form feed control: Compulsory\n"));
      else
         DBPRINTF (("UNKNOWN %d! Error!!!\n", *pElm));

      pbEnd = (PBYTE)(pElm + 1);
      break;
   }

   case DJP_SJ_N_UP:
   {
      PDJPT_NUP pElm = DJP_ELEMENTP (*pDJP, DJPT_NUP);

      DBPRINTF (("N-up is %d\n", *pElm));

      pbEnd = (PBYTE)(pElm + 1);
      break;
   }

   case DJP_CJ_OUTPUTBIN:
   {
      PDJPT_OUTPUTBIN pElm = DJP_ELEMENTP (*pDJP, DJPT_OUTPUTBIN);

      DBPRINTF (("Bin Name is         %s\n", pElm->szBinname));
      DBPRINTF (("Display Bin Name is %s\n", pElm->szDisplayBinname));
      DBPRINTF (("Bin Id is           %d\n", pElm->lBinId));

      pbEnd = (PBYTE)(pElm + 1);
      break;
   }

   case DJP_CJ_TRAYNAME:
   {
      PDJPT_TRAYNAME pElm = DJP_ELEMENTP (*pDJP, DJPT_TRAYNAME);

      DBPRINTF (("Tray Name is         %s\n",  pElm->szTrayname));
      DBPRINTF (("Display Tray Name is %s\n",  pElm->szDisplayTrayname));
      DBPRINTF (("Tray Type is         %d / ", pElm->djpttTrayID));
      PrintTrayName (pElm->djpttTrayID);

      pbEnd = (PBYTE)(pElm + 1);
      break;
   }

   case DJP_NONE:
   {
      DBPRINTF (("*** End of list ***\n"));

      pbEnd = (PBYTE)(pDJP + 1);
      break;
   }

   default:
   {
      DBPRINTF (("Error: *** Property type of %s = %d is not understood!\n",
                  pszProperty (pDJP->ulProperty),
                  pDJP->ulProperty));

      pbEnd = (PBYTE)(pDJP + 1);
      break;
   }
   }

   if (((PBYTE)pDJP + pDJP->cb) < (PBYTE)pbEnd)
   {
      DBPRINTF (("Error!!! Item's cb (%d) is less than what it should be (%d)\n",
                 pDJP->cb,
                 (pbEnd - (PBYTE)pDJP)));
   }
}

/****************************************************************************/
/*                                                                          */
/****************************************************************************/
VOID
PrintForm (PDJPT_FORM pForm)
{
   DBPRINTF (("Form name          is %s\n", pForm->szFormname));
   DBPRINTF (("Tray name          is %s\n", pForm->szTrayname));
   DBPRINTF (("Media name         is %s\n", pForm->szMedianame));

   DBPRINTF (("hcInfo:\n"));
   DBPRINTF (("     szFormname   = %s\n", pForm->hcInfo.szFormname));
   DBPRINTF (("     cx           = %d\n", pForm->hcInfo.cx));
   DBPRINTF (("     cy           = %d\n", pForm->hcInfo.cy));
   DBPRINTF (("     xLeftClip    = %d\n", pForm->hcInfo.xLeftClip));
   DBPRINTF (("     yBottomClip  = %d\n", pForm->hcInfo.yBottomClip));
   DBPRINTF (("     xRightClip   = %ld (%ld)\n",
              pForm->hcInfo.xRightClip,
              (pForm->hcInfo.cx - pForm->hcInfo.xRightClip)));
   DBPRINTF (("     yTopClip     = %ld (%ld)\n",
              pForm->hcInfo.yTopClip,
              (pForm->hcInfo.cy - pForm->hcInfo.yTopClip)));
   DBPRINTF (("     xPels        = %d\n", pForm->hcInfo.xPels));
   DBPRINTF (("     yPels        = %d\n", pForm->hcInfo.yPels));
   DBPRINTF (("     flAttributes = %04X\n", pForm->hcInfo.flAttributes));
   if (pForm->hcInfo.flAttributes & HCAPS_CURRENT)
      DBPRINTF (("        HCAPS_CURRENT\n"));
   if (pForm->hcInfo.flAttributes & HCAPS_SELECTABLE)
      DBPRINTF (("        HCAPS_SELECTABLE\n"));

   DBPRINTF (("Form display name  is %s\n", pForm->szDisplayFormname));
   DBPRINTF (("Tray display name  is %s\n", pForm->szDisplayTrayname));
   DBPRINTF (("Media display name is %s\n", pForm->szDisplayMedianame));
   if (0 < pForm->djppsFormID)
   {
      DBPRINTF (("Form type = %d / ", pForm->djppsFormID));
      PrintPaperSizeName (pForm->djppsFormID);
   }
   if (0 < pForm->djpttTrayID)
   {
      DBPRINTF (("Tray type = %d / ", pForm->djpttTrayID));
      PrintTrayName (pForm->djpttTrayID);
   }
   if (0 < pForm->djpmdMediaID)
   {
      DBPRINTF (("Media type = %d / ", pForm->djpmdMediaID));
      PrintMediaName (pForm->djpmdMediaID);
   }
}

/****************************************************************************/
/*                                                                          */
/****************************************************************************/
VOID
PrintPaperSizeName (DJPT_PAPERSIZE djppsElm)
{
   if (DJP_PSI_NONE == djppsElm)
      DBPRINTF (("Form - NONE!\n"));
   else if (DJP_PSI_LETTER == djppsElm)
      DBPRINTF (("Form - Letter\n"));
   else if (DJP_PSI_LEGAL == djppsElm)
      DBPRINTF (("Form - Legal\n"));
   else if (DJP_PSI_WIDE == djppsElm)
      DBPRINTF (("Form - Wide\n"));
   else if (DJP_PSI_CSHEET == djppsElm)
      DBPRINTF (("Form - C sheet\n"));
   else if (DJP_PSI_DSHEET == djppsElm)
      DBPRINTF (("Form - D sheet\n"));
   else if (DJP_PSI_ESHEET == djppsElm)
      DBPRINTF (("Form - E sheet\n"));
   else if (DJP_PSI_LETTERSMALL == djppsElm)
      DBPRINTF (("Form - LetterSmall\n"));
   else if (DJP_PSI_TABLOID == djppsElm)
      DBPRINTF (("Form - Tabloid\n"));
   else if (DJP_PSI_LEDGER == djppsElm)
      DBPRINTF (("Form - Ledger\n"));
   else if (DJP_PSI_STATEMENT == djppsElm)
      DBPRINTF (("Form - Statement\n"));
   else if (DJP_PSI_EXECUTIVE == djppsElm)
      DBPRINTF (("Form - Executive\n"));
   else if (DJP_PSI_A0 == djppsElm)
      DBPRINTF (("Form - A0\n"));
   else if (DJP_PSI_A1 == djppsElm)
      DBPRINTF (("Form - A1\n"));
   else if (DJP_PSI_A2 == djppsElm)
      DBPRINTF (("Form - A2\n"));
   else if (DJP_PSI_A3 == djppsElm)
      DBPRINTF (("Form - A3\n"));
   else if (DJP_PSI_A4 == djppsElm)
      DBPRINTF (("Form - A4\n"));
   else if (DJP_PSI_A4_SMALL == djppsElm)
      DBPRINTF (("Form - A4 Small\n"));
   else if (DJP_PSI_A5 == djppsElm)
      DBPRINTF (("Form - A5\n"));
   else if (DJP_PSI_B4 == djppsElm)
      DBPRINTF (("Form - B4\n"));
   else if (DJP_PSI_B5 == djppsElm)
      DBPRINTF (("Form - B5\n"));
   else if (DJP_PSI_FOLIO == djppsElm)
      DBPRINTF (("Form - Folio\nc"));
   else if (DJP_PSI_QUATRO == djppsElm)
      DBPRINTF (("Form - Quatro\n"));
   else if (DJP_PSI_10X14 == djppsElm)
      DBPRINTF (("Form - 10 x 14\n"));
   else if (DJP_PSI_11X17 == djppsElm)
      DBPRINTF (("Form - 11 x 17\n"));
   else if (DJP_PSI_NOTE == djppsElm)
      DBPRINTF (("Form - Note\n"));
   else if (DJP_PSI_ENV_9 == djppsElm)
      DBPRINTF (("Form - Envelope 9\n"));
   else if (DJP_PSI_ENV_10 == djppsElm)
      DBPRINTF (("Form - Envelope 10\n"));
   else if (DJP_PSI_ENV_11 == djppsElm)
      DBPRINTF (("Form - Envelope 11\n"));
   else if (DJP_PSI_ENV_12 == djppsElm)
      DBPRINTF (("Form - Envelope 12\n"));
   else if (DJP_PSI_ENV_14 == djppsElm)
      DBPRINTF (("Form - Envelope 14\n"));
   else if (DJP_PSI_ENV_DL == djppsElm)
      DBPRINTF (("Form - Envelope DL\n"));
   else if (DJP_PSI_ENV_A2 == djppsElm)
      DBPRINTF (("Form - Envelope A2\n"));
   else if (DJP_PSI_ENV_C3 == djppsElm)
      DBPRINTF (("Form - Envelope C3\n"));
   else if (DJP_PSI_ENV_C4 == djppsElm)
      DBPRINTF (("Form - Envelope C4\n"));
   else if (DJP_PSI_ENV_C5 == djppsElm)
      DBPRINTF (("Form - Envelope C5\n"));
   else if (DJP_PSI_ENV_C6 == djppsElm)
      DBPRINTF (("Form - Envelope C6\n"));
   else if (DJP_PSI_ENV_C65 == djppsElm)
      DBPRINTF (("Form - Envelope c65\n"));
   else if (DJP_PSI_ENV_C9 == djppsElm)
      DBPRINTF (("Form - Envelope C9\n"));
   else if (DJP_PSI_ENV_C10 == djppsElm)
      DBPRINTF (("Form - Envelope C10\n"));
   else if (DJP_PSI_ENV_B4 == djppsElm)
      DBPRINTF (("Form - Envelope B4\n"));
   else if (DJP_PSI_ENV_B5 == djppsElm)
      DBPRINTF (("Form - Envelope B5\n"));
   else if (DJP_PSI_ENV_B6 == djppsElm)
      DBPRINTF (("Form - Envelope B6\n"));
   else if (DJP_PSI_ENV_ITALY == djppsElm)
      DBPRINTF (("Form - Envelope Italy\n"));
   else if (DJP_PSI_ENV_MONARCH == djppsElm)
      DBPRINTF (("Form - Envelope Monarch\n"));
   else if (DJP_PSI_ENV_PERSONAL == djppsElm)
      DBPRINTF (("Form - Envelope Personal\n"));
   else if (DJP_PSI_FANFOLD_US == djppsElm)
      DBPRINTF (("Form - Fanfold US\n"));
   else if (DJP_PSI_FANFOLD_STD_GERMAN == djppsElm)
      DBPRINTF (("Form - Fanfold Standard German\n"));
   else if (DJP_PSI_FANFOLD_LGL_GERMAN == djppsElm)
      DBPRINTF (("Form - Fanfold Legal German\n"));
   else if (DJP_PSI_ARCHITECT_BSHEET == djppsElm)
      DBPRINTF (("Form - Architect B Sheet\n"));
   else if (DJP_PSI_ARCHITECT_CSHEET == djppsElm)
      DBPRINTF (("Form - Architect C Sheet\n"));
   else if (DJP_PSI_ARCHITECT_DSHEET == djppsElm)
      DBPRINTF (("Form - Architect D Sheet\n"));
   else if (DJP_PSI_ARCHITECT_ESHEET == djppsElm)
      DBPRINTF (("Form - Architect E Sheet\n"));
   else if (DJP_PSI_CARD_A6 == djppsElm)
      DBPRINTF (("Form - CARD_A6\n"));
   else if (DJP_PSI_CARD_4X6 == djppsElm)
      DBPRINTF (("Form - CARD_4X6\n"));
   else if (DJP_PSI_CARD_5X8 == djppsElm)
      DBPRINTF (("Form - CARD_5X8\n"));
   else if (DJP_PSI_CARD_HAGAKI == djppsElm)
      DBPRINTF (("Form - CARD_HAGAKI\n"));
   else if (DJP_PSI_LABEL_STANDARD == djppsElm)
      DBPRINTF (("Form - LABEL_STANDARD\n"));
   else if (DJP_PSI_LABEL_SHIPPING == djppsElm)
      DBPRINTF (("Form - LABEL_SHIPPING\n"));
   else if (DJP_PSI_LABEL_DISK == djppsElm)
      DBPRINTF (("Form - LABEL_DISK\n"));
   else if (DJP_PSI_LABEL_EURO == djppsElm)
      DBPRINTF (("Form - LABEL_EURO\n"));
   else if (DJP_PSI_CARD_OUFUKU_HAGAKI == djppsElm)
      DBPRINTF (("Form - CARD_OUFUKU_HAGAKI\n"));
   else if (DJP_PSI_B0 == djppsElm)
      DBPRINTF (("Form - B0\n"));
   else if (DJP_PSI_B1 == djppsElm)
      DBPRINTF (("Form - B1\n"));
   else if (DJP_PSI_B2 == djppsElm)
      DBPRINTF (("Form - B2\n"));
   else if (DJP_PSI_B3 == djppsElm)
      DBPRINTF (("Form - B3\n"));
   else if (DJP_PSI_B6 == djppsElm)
      DBPRINTF (("Form - B6\n"));
   else if (DJP_PSI_B7 == djppsElm)
      DBPRINTF (("Form - B7\n"));
   else if (DJP_PSI_B8 == djppsElm)
      DBPRINTF (("Form - B8\n"));
   else if (DJP_PSI_B9 == djppsElm)
      DBPRINTF (("Form - B9\n"));
   else if (DJP_PSI_B10 == djppsElm)
      DBPRINTF (("Form - B10\n"));
   else if (DJP_PSI_B0_JIS == djppsElm)
      DBPRINTF (("Form - B0_JIS\n"));
   else if (DJP_PSI_B1_JIS == djppsElm)
      DBPRINTF (("Form - B1_JIS\n"));
   else if (DJP_PSI_B2_JIS == djppsElm)
      DBPRINTF (("Form - B2_JIS\n"));
   else if (DJP_PSI_B3_JIS == djppsElm)
      DBPRINTF (("Form - B3_JIS\n"));
   else if (DJP_PSI_B4_JIS == djppsElm)
      DBPRINTF (("Form - B4_JIS\n"));
   else if (DJP_PSI_B5_JIS == djppsElm)
      DBPRINTF (("Form - B5_JIS\n"));
   else if (DJP_PSI_B6_JIS == djppsElm)
      DBPRINTF (("Form - B6_JIS\n"));
   else if (DJP_PSI_B7_JIS == djppsElm)
      DBPRINTF (("Form - B7_JIS\n"));
   else if (DJP_PSI_B8_JIS == djppsElm)
      DBPRINTF (("Form - B8_JIS\n"));
   else if (DJP_PSI_B9_JIS == djppsElm)
      DBPRINTF (("Form - B9_JIS\n"));
   else if (DJP_PSI_B10_JIS == djppsElm)
      DBPRINTF (("Form - B10_JIS\n"));
   else
      DBPRINTF (("UNKNOWN form Error!!!\n"));
}

/****************************************************************************/
/*                                                                          */
/****************************************************************************/
VOID
PrintTrayName (DJPT_TRAYTYPE djpttTrayID)
{
   if (DJP_TRY_NONE == djpttTrayID)
      DBPRINTF (("Tray - none\n"));
   else if (DJP_TRY_UPPER == djpttTrayID)
      DBPRINTF (("Tray - upper\n"));
   else if (DJP_TRY_LOWER == djpttTrayID)
      DBPRINTF (("Tray - lower tray\n"));
   else if (DJP_TRY_MIDDLE == djpttTrayID)
      DBPRINTF (("Tray - midle tray\n"));
   else if (DJP_TRY_MANUAL == djpttTrayID)
      DBPRINTF (("Tray - manual\n"));
   else if (DJP_TRY_ENVELOPE == djpttTrayID)
      DBPRINTF (("Tray - envelope\n"));
   else if (DJP_TRY_ENVMANUAL == djpttTrayID)
      DBPRINTF (("Tray - manual envelope\n"));
   else if (DJP_TRY_AUTO == djpttTrayID)
      DBPRINTF (("Tray - auto\n"));
   else if (DJP_TRY_TRACTOR == djpttTrayID)
      DBPRINTF (("Tray - tractor\n"));
   else if (DJP_TRY_SMALLFMT == djpttTrayID)
      DBPRINTF (("Tray - small format\n"));
   else if (DJP_TRY_LARGEFMT == djpttTrayID)
      DBPRINTF (("Tray - large format\n"));
   else if (DJP_TRY_LARGECAPACITY == djpttTrayID)
      DBPRINTF (("Tray - large capacity\n"));
   else if (DJP_TRY_CASSETTE == djpttTrayID)
      DBPRINTF (("Tray - cassette\n"));
   else
      DBPRINTF (("Unknown tray! Error!!!\n"));
}

/****************************************************************************/
/*                                                                          */
/****************************************************************************/
VOID
PrintMediaName (DJPT_MEDIA djpmdMediaID)
{
   if (DJP_MED_PLAIN == djpmdMediaID)
      DBPRINTF (("Media - plain\n"));
   else if (DJP_MED_TRANSPARENCY == djpmdMediaID)
      DBPRINTF (("Media - transparency\n"));
   else if (DJP_MED_GLOSSY == djpmdMediaID)
      DBPRINTF (("Media - glossy\n"));
   else if (DJP_MED_SPECIAL == djpmdMediaID)
      DBPRINTF (("Media - special\n"));
   else if (DJP_MED_COATED == djpmdMediaID)
      DBPRINTF (("Media - coated\n"));
   else if (DJP_MED_BACKPRINT == djpmdMediaID)
      DBPRINTF (("Media - backprint\n"));
   else if (DJP_MED_CLOTH == djpmdMediaID)
      DBPRINTF (("Media - cloth\n"));
   else if (DJP_MED_THICK == djpmdMediaID)
      DBPRINTF (("Media - thick\n"));
   else
      DBPRINTF (("Unknown media! Error!!!"));
}

/****************************************************************************/
/*                                                                          */
/****************************************************************************/
VOID
PrintMediaColor (DJPT_MEDIA_COLOR djpmdMediaColorID)
{
   if (DJP_MDC_BLUE == djpmdMediaColorID)
      DBPRINTF (("Media Color - Blue\n"));
   else if (DJP_MDC_BLUFF == djpmdMediaColorID)
      DBPRINTF (("Media Color - Bluff\n"));
   else if (DJP_MDC_GOLDENROD == djpmdMediaColorID)
      DBPRINTF (("Media Color - Goldenrod\n"));
   else if (DJP_MDC_GREEN == djpmdMediaColorID)
      DBPRINTF (("Media Color - Green\n"));
   else if (DJP_MDC_PINK == djpmdMediaColorID)
      DBPRINTF (("Media Color - Pink\n"));
   else if (DJP_MDC_TRANSPARENT == djpmdMediaColorID)
      DBPRINTF (("Media Color - Transparent\n"));
   else if (DJP_MDC_WHITE == djpmdMediaColorID)
      DBPRINTF (("Media Color - White\n"));
   else if (DJP_MDC_YELLOW == djpmdMediaColorID)
      DBPRINTF (("Media Color - Yellow\n"));
   else
      DBPRINTF (("Unknown media! Error!!!"));
}

#endif

/****************************************************************************/
/*                                                                          */
/****************************************************************************/
BOOL
NewConnection (PDEVICEBLOCK pdb,
               PSZ          pszDeviceName,
               PULONG       pulDefConnID,
               ULONG        ulDefaultFormID,
               ULONG        ulDefaultTrayID,
               ULONG        ulDefaultMediaID,
               PUSERCONNECT pUserConnect,
               BOOL         fCreateNewConnection)
{
   PDRIVERINFO     pDriver      = pdb->pDriver;
   PDEVICEINFO     pDevice      = pdb->pDevice;
   PFORMCONNECTION pConnection  = pDriver->pCONNECTS;
   ULONG           ulNumDefined = pDriver->ulNumConnects;
   PULONG          pulConnects  = pDevice->pulCONNECTS;
   ULONG           ulNumDevice  = pDevice->usNumConnects;
   BOOL            bFound       = FALSE;
   register INT    i, j;

   // Now find a new connection id
   for (i = 0; !bFound && i < ulNumDevice; i++, pulConnects++)
   {
      for (j = 0; j < ulNumDefined; j++)
      {
         if (pConnection[j].ulConnID == *pulConnects)
         {
            if (pConnection[j].ulTrayID  == ulDefaultTrayID &&
                pConnection[j].ulFormID  == ulDefaultFormID &&
                pConnection[j].ulMediaID == ulDefaultMediaID )
            {
               // Return the new connection id
               *pulDefConnID = pConnection[j].ulConnID;

               bFound = TRUE;
               break;
            }
         }
      }
   }

   if (!bFound)
   {
      PUSERCONNECT pUser;

      pUser = pUserConnect;

      while (pUser)
      {
         if (pUser->fcUser.ulTrayID  == ulDefaultTrayID &&
             pUser->fcUser.ulFormID  == ulDefaultFormID &&
             pUser->fcUser.ulMediaID == ulDefaultMediaID )
         {
            // Return the new connection id
            *pulDefConnID = pUser->fcUser.ulConnID;

            bFound = TRUE;
            break;
         }

         pUser = pUser->pNextConnect;
      }
   }

   /* If there is no new connection found, and we are told to create
   ** new connections and the device explictly allows new form
   ** connections to be made, then create a new connection and return it.
   */
   if (!bFound                                &&
       fCreateNewConnection                   &&
       pDevice->pFeatures->bSupUserDefConnects )
   {
      FORMCONNECTION NewFormConnection;

      // Make a new connection id!
      NewFormConnection.ulConnID  = CreateUniqueConnectID (pDevice);
      NewFormConnection.ulTrayID  = ulDefaultTrayID;
      NewFormConnection.ulFormID  = ulDefaultFormID;
      NewFormConnection.ulMediaID = ulDefaultMediaID;

      bFound = AddConnectionEntry (pDevice, &NewFormConnection);
      assertF (bFound);

      if (bFound)
      {

         if (bFound)
         {
            bFound = SaveUserDefinedConnectList (pdb->szAppName, pDevice);
            assertF (bFound);

            // return the new connection id
            *pulDefConnID = NewFormConnection.ulConnID;
         }
      }
   }

   return bFound;
}
