/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1992 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 source code is provided to you solely for       */
/*    the purpose of assisting you in your development of OS/2 device        */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Developer Connection Device Driver       */
/*    Source Kit for OS/2. This Copyright statement may not be removed.      */
/*                                                                           */
/*****************************************************************************/
// devfunc3.c

// need to hook getstyleratio in order to get dashed line properly


#define INCL_DOS
#define INCL_PM
#include <os2.h>

#define INCL_DDICOMFLAGS
#define INCL_INNER_GRE
#define INCL_DDIMISC
#define INCL_GRE_DEVMISC3
// @DBCS
#define INCL_VMANDDI
#include <ddi.h>
#include <pmddi.h>

// c includes
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <setjmp.h>

#include "def.h"
#include "driver.h"
#include "funcs.h"


// --------------------------------------------------------------------------------------------------------------------
LONG ENGENTRY AccumulateBounds(         HDC            hdc,
                                        PRECTL         prclRect,
                                        PDDC           pddc,
                                        ULONG          ulFunction )
{
  REGREC      regrec;
  ULONG       ulException;
  LONG        lrc;


  REGISTERHANDLER (regrec, globals.hModule);
  ulException = setjmp( regrec.jmp );
  if( ulException ) {
    // clean up here
    assertstring ("Exception occured!\n");
    CheckForTermination( &regrec, ulException, pddc );
    // error result
    lrc = FALSE;
    goto depart;
  }
  ENTERDDC( pddc  );


  DBPRINTF (("AccumulateBounds called with (%d,%d)-(%d,%d)\n",
             prclRect->xLeft, prclRect->yBottom,
             prclRect->xRight, prclRect->yTop));

  lrc = InnerGreAccumulateBounds( pddc->hdcShadow, prclRect, ulFunction );
// Should not call through, engine already transformed
//lrc = GreAccumulateBounds( pddc->hdcShadow, prclRect );
  assert( lrc );

depart:
  EXITDDC( pddc  );
  UNREGISTERHANDLER( regrec );
  return lrc;
}


// --------------------------------------------------------------------------------------------------------------------
LONG ENGENTRY DeviceSetDCOrigin(        HDC            hdc,
                                        PPOINTL        pptlDC,
                                        PDDC           pddc,
                                        ULONG          ulFunction )
{
  REGREC      regrec;
  ULONG       ulException;
  ULONG       ulrc;


  REGISTERHANDLER (regrec, globals.hModule);
  ulException = setjmp( regrec.jmp );
  if( ulException ) {
    // clean up here
    assertstring ("Exception occured!\n");
    CheckForTermination( &regrec, ulException, pddc );
    // error result
    ulrc = FALSE;
    goto depart;
  }
  ENTERDDC( pddc );


  pddc->ptlDCOrigin = *pptlDC;

  // @MARK - Sync. up the shadow DC!
  ulrc = GreDeviceSetDCOrigin (pddc->hdcShadow, pptlDC);
  assert (ulrc);

depart:
  EXITDDC( pddc );
  UNREGISTERHANDLER( regrec );
  return ulrc;
}


// --------------------------------------------------------------------------------------------------------------------
LONG ENGENTRY GetBoundsData(            HDC            hdc,
                                        ULONG          flOptions,
                                        PRECTL         pBoundsData,
                                        PDDC           pddc,
                                        ULONG          ulFunction )
{
  REGREC      regrec;
  ULONG       ulException;
  LONG        lrc;


  REGISTERHANDLER (regrec, globals.hModule);
  ulException = setjmp( regrec.jmp );
  if( ulException ) {
    CheckForTermination( &regrec, ulException, pddc );
    // error result
    lrc = FALSE;
    goto depart;
  }
  ENTERDDC( pddc );


//lrc = InnerGreGetBoundsData( pddc->hdcShadow, flOptions, pBoundsData, ulFunction );
  lrc = GreGetBoundsData( pddc->hdcShadow, flOptions, pBoundsData );
  assert( lrc );

  DBPRINTF (("GetBoundsData returns (%d,%d)-(%d,%d)\n",
             pBoundsData->xLeft, pBoundsData->yBottom,
             pBoundsData->xRight, pBoundsData->yTop));

depart:
  EXITDDC( pddc );
  UNREGISTERHANDLER( regrec );
  return lrc;
}


// --------------------------------------------------------------------------------------------------------------------
LONG ENGENTRY GetCodePage(              HDC            hdc,
                                        PDDC           pddc,
                                        ULONG          ulFunction )
{
  REGREC      regrec;
  ULONG       ulException;
  ULONG       ulrc;


  REGISTERHANDLER (regrec, globals.hModule);
  ulException = setjmp( regrec.jmp );
  if( ulException ) {
    // clean up here
    assertstring ("Exception occured!\n");
    CheckForTermination( &regrec, ulException, pddc );
    // error result
    ulrc = GPI_ERROR;
    goto depart;
  }
  ENTERDDC( pddc );


  ulrc = GreGetCodePage( pddc->hdcShadow );
  assert( ulrc != GPI_ERROR );


depart:
  EXITDDC( pddc );
  UNREGISTERHANDLER( regrec );
  return ulrc;
}


// --------------------------------------------------------------------------------------------------------------------
LONG ENGENTRY GetDCOrigin(              HDC            hdc,
                                        PPOINTL        pptlOrigin,
                                        PDDC           pddc,
                                        ULONG          ulFunction )
{
  REGREC      regrec;
  ULONG       ulException;
  ULONG       ulrc;


  REGISTERHANDLER (regrec, globals.hModule);
  ulException = setjmp( regrec.jmp );
  if( ulException ) {
    // clean up here
    assertstring ("Exception occured!\n");
    CheckForTermination( &regrec, ulException, pddc );
    // error result
    ulrc = FALSE;
    goto depart;
  }
  ENTERDDC( pddc );


  *pptlOrigin = pddc->ptlDCOrigin;
  ulrc = TRUE;


depart:
  EXITDDC( pddc );
  UNREGISTERHANDLER( regrec );
  return ulrc;
}


// --------------------------------------------------------------------------------------------------------------------
LONG ENGENTRY GetLineOrigin(            HDC            hdc,
                                        PPOINTL        pptlXY,
                                        PDDC           pddc,
                                        ULONG          ulFunction )

{
  REGREC      regrec;
  ULONG       ulException;
  LONG        lrc;


  REGISTERHANDLER (regrec, globals.hModule);
  ulException = setjmp( regrec.jmp );
  if( ulException ) {
    CheckForTermination( &regrec, ulException, pddc );
    // error result
    lrc = FALSE;
    goto depart;
  }
  ENTERDDC( pddc );


  //lrc = InnerGreGetLineOrigin( pddc->hdcShadow, pptlXY, ulFunction );
  lrc = GreGetLineOrigin( pddc->hdcShadow, pptlXY);
  assert( lrc != GPI_ALTERROR );

depart:
  EXITDDC( pddc );
  UNREGISTERHANDLER( regrec );
  return lrc;
}


// --------------------------------------------------------------------------------------------------------------------
// hardcopy drivers need only to return TRUE

LONG ENGENTRY LockDevice(               HDC            hdc,
                                        PDDC           pddc,
                                        ULONG          ulFunction )
{
  return TRUE;
}


// --------------------------------------------------------------------------------------------------------------------
LONG ENGENTRY ResetBounds(              HDC            hdc,
                                        ULONG          flOptions,
                                        PDDC           pddc,
                                        ULONG          ulFunction )
{
  REGREC      regrec;
  ULONG       ulException;
  LONG        lrc;


  REGISTERHANDLER (regrec, globals.hModule);
  ulException = setjmp( regrec.jmp );
  if( ulException ) {
    // clean up here
    assertstring ("Exception occured!\n");
    CheckForTermination( &regrec, ulException, pddc );
    // error result
    lrc = FALSE;
    goto depart;
  }
  ENTERDDC( pddc );


//lrc = InnerGreResetBounds( pddc->hdcShadow, flOptions, ulFunction );
  lrc = GreResetBounds( pddc->hdcShadow, flOptions );
  assert( lrc );

depart:
  EXITDDC( pddc );
  UNREGISTERHANDLER( regrec );
  return lrc;
}


// --------------------------------------------------------------------------------------------------------------------
LONG ENGENTRY SetCodePage(              HDC            hdc,
                                        LONG           lCodePage,
                                        PDDC           pddc,
                                        ULONG          ulFunction )
{
  REGREC      regrec;
  ULONG       ulException;

  ULONG       ulrc;


  REGISTERHANDLER (regrec, globals.hModule);
  ulException = setjmp( regrec.jmp );
  if( ulException ) {
    // clean up here
    assertstring ("Exception occured!\n");
    CheckForTermination( &regrec, ulException, pddc );
    // error result
    ulrc = FALSE;
    goto depart;
  }

  ENTERDDC( pddc );


  ulrc = InnerGreSetCodePage( pddc->hdcShadow, lCodePage, ulFunction );
  assert( ulrc );

  ulrc = TRUE;
depart:
  EXITDDC( pddc );
  UNREGISTERHANDLER( regrec );
  return ulrc;
}


// --------------------------------------------------------------------------------------------------------------------
LONG ENGENTRY SetLineOrigin(            HDC            hdc,
                                        PPOINTL        pptlXY,
                                        ULONG          lStyle,
                                        PDDC           pddc,
                                        ULONG          ulFunction )
{
  REGREC      regrec;
  ULONG       ulException;
  LONG        lrc;


  REGISTERHANDLER (regrec, globals.hModule);
  ulException = setjmp( regrec.jmp );
  if( ulException ) {
    // clean up here
    assertstring ("Exception occured!\n");
    CheckForTermination( &regrec, ulException, pddc );
    // error result
    lrc = FALSE;
    goto depart;
  }
  ENTERDDC( pddc );

  lrc = GreSetLineOrigin( pddc->hdcShadow, pptlXY, lStyle );
  assert( lrc );


depart:
  EXITDDC( pddc );
  UNREGISTERHANDLER( regrec );
  return lrc;
}


// --------------------------------------------------------------------------------------------------------------------
// hardcopy drivers need only to return TRUE
LONG ENGENTRY UnlockDevice(             HDC            hdc,
                                        PDDC           pddc,
                                        ULONG          ulFunction )
{
  return TRUE;
}


