/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1992 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 source code is provided to you solely for       */
/*    the purpose of assisting you in your development of OS/2 device        */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Developer Connection Device Driver       */
/*    Source Kit for OS/2. This Copyright statement may not be removed.      */
/*                                                                           */
/*****************************************************************************/
// devfunc2.c

//  DeviceQueryFontAttributes
//  DeviceQueryFonts
//  ErasePS
//  NotifyClipChange
//  NotifyTransformChange
//  RealizeFont
//  GetStyleRatio
//  SetStyleRatio


#define INCL_DOS
#define INCL_PM
#define INCL_GPI
#include <os2.h>

#define INCL_DDIMISC
#define INCL_DDIMISC2
#define INCL_DDICOMFLAGS
#define INCL_GRE_DEVMISC2
#define INCL_GRE_REGIONS
#define INCL_GRE_CLIP
#define INCL_INNER_GRE
#define INCL_GRE_XFORMS
// @DBCS
#define INCL_VMANDDI
#include <ddi.h>
#include <pmddi.h>

// c includes
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <setjmp.h>

#include "def.h"
#include "driver.h"
#include "funcs.h"

// ------------------------------------------------------------------------

LONG ENGENTRY DeviceQueryFontAttributes(HDC            hdc,
                                        ULONG          cMetrics,
                                        PFONTMETRICS   pfm,
                                        PDDC           pddc,
                                        ULONG          ulFunction )
{
  /*------------------------------------------------------------------------*/
  /* LOCAL VARIABLES                                                        */
  /*------------------------------------------------------------------------*/
  REGREC      regrec;
  ULONG       ulException;
  ULONG       ulrc;

#ifdef DEBUG
  PDEBUGINFO  pDbg = &globals.DebugInfo;
#endif

  /*------------------------------------------------------------------------*/
  /* EXCEPTION MANAGEMENT                                                   */
  /*------------------------------------------------------------------------*/

  REGISTERHANDLER (regrec, globals.hModule);
  ulException = setjmp( regrec.jmp );
  if( ulException )
  {
    // clean up here
    assertstring ("Exception occured!\n");
    CheckForTermination( &regrec, ulException, pddc );
    // error result
    ulrc = FALSE;
    goto depart;

  } /* end if */

  /*------------------------------------------------------------------------*/
  /* BEGIN CODE                                                             */
  /*------------------------------------------------------------------------*/

  DBPRINTIF(( pDbg->bDEVICEQUERYFONTATTRIBUTES, "%s(): Enter\n", __FUNCTION__ ));

  ENTERDDC( pddc );

  // @TBD - get font attributes for device fonts
  assertstring ("To Be Done!\n");

  ulrc = TRUE;

depart:

  EXITDDC( pddc );

  UNREGISTERHANDLER( regrec );

  DBPRINTIF(( pDbg->bDEVICEQUERYFONTATTRIBUTES, "%s(): Enter; ulrc=%lu\n", __FUNCTION__, ulrc ));

  return( ulrc );

} /* end DeviceQueryFontAttributes */



/****************************************************************************/
/* PROCEDURE NAME : QueryDeviceCaps                                         */
/*                                                                          */
/* AUTHOR         : Matt Rutkowski [IBM]                                    */
/* DATE WRITTEN   : 11/22/93                                                */
/* DESCRIPTION    : Returns either # of fonts supported by the device or    */
/*                  FONTMETRIC for a # of device fonts requested.           */
/*                                                                          */
/*                  This function is invoked by the GpiQueryFonts() API     */
/*                  from OS/2 PM applications.  The GRE calls us first      */
/*                  to get our fonts then tacks on any (public)system       */
/*                  fonts                                                   */
/*                                                                          */
/* PARAMETERS:      HDC          hdc                                        */
/*                  ULONG        flOptions                                  */
/*                  PSZ          pszFacename                                */
/*                  PFONTMETRICS pfm                                        */
/*                  ULONG        cMetrics                                   */
/*                  PLONG        pcFonts                                    */
/*                  PDDC         pddc                                       */
/*                  ULONG        ulFunction                                 */
/*                                                                          */
/* RETURN VALUES:   LONG    lrc                                             */
/*                                                                          */
/*--------------------------------------------------------------------------*/
/* CHANGE/MODIFICATION LOG :                                                */
/*--------------------------------------------------------------------------*/
/* TAG - DATE - [COMPANY] - AUTHOR - DESCRIPTION                            */
/*--------------------------------------------------------------------------*/
/*                                                                          */
/*                                                                          */
/****************************************************************************/
LONG ENGENTRY DeviceQueryFonts( HDC            hdc,
                                ULONG          flOptions,
                                PSZ            pszFacename,
                                PFONTMETRICS   pfm,
                                ULONG          cMetrics,
                                PLONG          pcFonts,
                                PDDC           pddc,
                                ULONG          ulFunction )
{

  /*------------------------------------------------------------------------*/
  /* LOCAL VARIABLES                                                        */
  /*------------------------------------------------------------------------*/
  REGREC      regrec;
  ULONG       ulException;
  LONG        lrc = 0;
  LONG        lNumFontReturned;
  PDEVICEINFO pDeviceLcl;
  USHORT      usDriverFonts;
  LONG        l;
  PFONTINFO2  pfi;  // @TTY
  PULONG      pulFonts;

#ifdef DEBUG
  PDEBUGINFO  pDbg = &globals.DebugInfo;
#endif

  /*------------------------------------------------------------------------*/
  /* EXCEPTION MANAGEMENT                                                   */
  /*------------------------------------------------------------------------*/
  REGISTERHANDLER (regrec, globals.hModule);
  ulException = setjmp( regrec.jmp );
  if( ulException ) {
    // clean up here
    assertstring ("Exception occured!\n");
    CheckForTermination( &regrec, ulException, pddc );
    // error result
    lrc = GPI_ALTERROR;
    goto depart;
  }

  /*------------------------------------------------------------------------*/
  /* BEGIN CODE                                                             */
  /*------------------------------------------------------------------------*/

  assert( pcFonts );
  assert( pddc );
  assert( pddc->pdb );
  assert( pddc->pdb->pDevice );

  DBPRINTIF(( pDbg->bDEVICEQUERYFONTS, "%s(): Enter; pcFonts = %d\n", __FUNCTION__, *pcFonts ));

  // Only return our device fonts when QF_PUBLIC is set
  // as per Presentation Driver Reference
  if( flOptions & QF_PUBLIC )
  {
      // @TBD - validate cMetrics for sizeof( FONTMETRICS )


      // @TBD - turn QF_PUBLIC off to not get system fonts ???

      // get pDevice from pdb for easier dereference
      pDeviceLcl = pddc->pdb->pDevice;

      // add device defined fonts
      usDriverFonts = pDeviceLcl->usNumFonts;

      // @TBD - add user defined later on
      lNumFontReturned = min( *pcFonts, usDriverFonts );

      if( lNumFontReturned > 0 )
      {
        assert( pfm );

        pulFonts = pDeviceLcl->pulFONTS;

        for( l=0; l < lNumFontReturned; l++ )
        {
          FontInfoFromID (pddc->pdb->pDriver,
                          pddc->pdb->pDevice,
                          *pulFonts,
                          &pfi);

// @DBCS - need to map DEVFONTMETRICS to FONTMETRICS for back compat.
//          *pfm = pfi->fm;

          DBPRINTF(( "DeviceQueryFonts(): returning font: %s\n", pfm->szFacename ));

          // @TBD match facename to limit fonts as well decrementing count

          pfm++;
          pulFonts++;

        } /* end for */

      } /* end if */

      // return to user # device fonts we have or # metric returned
      *pcFonts = lNumFontReturned;

      // if we returned less fonts then this device has
      if( lNumFontReturned < usDriverFonts )
      {
        // return number remaining to be queried
        lrc = usDriverFonts - lNumFontReturned;

      } /* end if */

  } /* end if */
  else
  {
    // return that no device fonts supported since QF_PUBLIC not set
    *pcFonts = 0;

  } /* end else */

depart:
  UNREGISTERHANDLER( regrec );

  DBPRINTIF(( pDbg->bDEVICEQUERYFONTS, "%s(): Exit; pcFonts = %d\n", __FUNCTION__, *pcFonts ));

  return(lrc);

} /* end DeviceQueryFonts */



// --------------------------------------------------------------------------------------------------------------------

LONG ENGENTRY ErasePS(                  HDC            hdc,
                                        PDDC           pddc,
                                        ULONG          ulFunction )
{
  REGREC      regrec;
  ULONG       ulException;
  LONG        lrc;


  REGISTERHANDLER (regrec, globals.hModule);
  ulException = setjmp( regrec.jmp );
  if( ulException ) {
    // clean up here
    assertstring ("Exception occured!\n");
    CheckForTermination( &regrec, ulException, pddc );
    // error result
    lrc = FALSE;
    goto depart;
  }

  ENTERDDC( pddc );


  lrc = GreErasePS( pddc->hdcShadow );
  assert( lrc != GPI_ERROR );


  lrc = TRUE;

depart:
  EXITDDC( pddc );
  UNREGISTERHANDLER( regrec );
  return lrc;
}



// --------------------------------------------------------------------------------------------------------------------

LONG ENGENTRY NotifyClipChange(         HDC            hdc,
                                        PRECTL         prclBound,
                                        ULONG          cRect,
                                        ULONG          idClipPath,
                                        PDDC           pddc,
                                        ULONG          ulFunction )
{
typedef LONG (* _System PFNNOTIFYCLIPCHANGE) (HDC,PRECTL,LONG,ULONG,ULONG,ULONG);
  REGREC              regrec;
  RECTL               rclBounds;
  ULONG               ulException;
  LONG                lrc;
  HRGN                hrgnOld = (HRGN)0;
  ULONG               ul;
  PFNNOTIFYCLIPCHANGE pfnNotifyClipChange;


  REGISTERHANDLER (regrec, globals.hModule);
  ulException = setjmp( regrec.jmp );
  if( ulException ) {
    // clean up here
    assertstring ("Exception occured!\n");
    CheckForTermination( &regrec, ulException, pddc );
    // error result
    lrc = FALSE;
    goto depart;
  }

  ENTERDDC( pddc );

  DBPRINTF(( "NotifyClipChange(): hrgnShadow = %x, hdcShadow = %x\n", pddc->hrgnShadow, pddc->hdcShadow ));
  DBPRINTF (("Notify clip change. pddc = %lx\r\nBounding rectangle is:\r\n", pddc));
  DBPRINTF (("            /(%4ld,%4ld)\r\n", prclBound->xRight, prclBound->yTop));
  DBPRINTF (("(%4ld,%4ld)/\r\n", prclBound->xLeft, prclBound->yBottom));

  // de-select any current clip region from the shadow DC by setting a null one
  lrc = GreSelectClipRegion( pddc->hdcShadow, (HRGN)0, &hrgnOld );
  assert( lrc != RGN_ERROR );
  assert( hrgnOld ? hrgnOld == pddc->hrgnShadow : TRUE );

  // Copy this DC's clip region into the region I created at enable time
  // The COPYCRGN_ALLINTERSECT option will return the value in SCREEN coords!
  // as opposed to COPYCRGN_CLPRGN which returns it in device coords...
  // so the shadow dc will be a happy camper...
  lrc = GreCopyClipRegion( hdc, pddc->hrgnShadow, &rclBounds, COPYCRGN_ALLINTERSECT );
  assert( lrc != RGN_ERROR );

  // set it to shadow dc.
  // The coordinates are in device coordinates...
  ul = GreSelectClipRegion( pddc->hdcShadow, pddc->hrgnShadow, &hrgnOld );
  assert( ul != RGN_ERROR );
  assert( hrgnOld == (HRGN) 0  );

  // call back the simulation function for NotifyClipChange
  pfnNotifyClipChange = (PFNNOTIFYCLIPCHANGE)globals.ppfnDispatchTableCopy[ NGreNotifyClipChange & 0x00FF ];
  assert( pfnNotifyClipChange );
  lrc = (LONG) ( *pfnNotifyClipChange ) ( hdc, prclBound, cRect, idClipPath, (ULONG)pddc, ulFunction );
  assert( lrc );

  // successful result
  lrc = TRUE;

depart:
  EXITDDC( pddc );
  UNREGISTERHANDLER( regrec );

#ifndef DEBUG
  ul++;       // Get rid of warning
#endif

  return lrc;
}



// --------------------------------------------------------------------------------------------------------------------

LONG ENGENTRY NotifyTransformChange(    HDC            hdc,
                                        ULONG          flFlags,
                                        PNOTIFYTRANSFORMDATA pXformdata,
                                        PDDC           pddc,
                                        ULONG          ulFunction )
{
typedef LONG (* _System PFNNOTIFYTRANSFORMCHANGE) (HDC,ULONG,PNOTIFYTRANSFORMDATA,ULONG,ULONG);
  REGREC                   regrec;
  ULONG                    ulException;
  ULONG                    lrc;
  PFNNOTIFYTRANSFORMCHANGE pfnNotifyTransformChange;

  REGISTERHANDLER (regrec, globals.hModule);
  ulException = setjmp( regrec.jmp );
  if( ulException ) {
    // clean up here
    assertstring ("Exception occured!\n");
    CheckForTermination( &regrec, ulException, pddc );
    // error result
    lrc = FALSE;
    goto depart;
  }

  ENTERDDC( pddc );

  // set this transform at the shadow DC device level
  lrc = InnerGreSetModelXform( pddc->hdcShadow, &pXformdata->xform, SX_OVERWRITE,
                                (ulFunction & 0xFFFF0000)|NGreSetModelXform );

  // if setting xform is successful at device level, set also at engine level
  if( lrc ) {
    pfnNotifyTransformChange = (PFNNOTIFYTRANSFORMCHANGE)globals.ppfnDispatchTableCopy[ NGreNotifyTransformChange & 0x00FF ];
    assert( pfnNotifyTransformChange );
    lrc = (LONG) ( *pfnNotifyTransformChange ) ( hdc, flFlags, pXformdata, (ULONG)pddc, ulFunction );
    assert( lrc );
  }


depart:
  EXITDDC( pddc );
  UNREGISTERHANDLER( regrec );
  return lrc;
}


/****************************************************************************/
/* PROCEDURE NAME : RealizeFont                                             */
/*                                                                          */
/* AUTHOR         : Matt Rutkowski [IBM]                                    */
/* DATE WRITTEN   : 11/30/93                                                */
/* DESCRIPTION    : Returns either # of fonts supported by the device or    */
/*                  FONTMETRIC for a # of device fonts requested.           */
/*                                                                          */
/*                  This function is invoked by the GpiCreateLogFont() API  */
/*                  from OS/2 PM applications                               */
/*                                                                          */
/*                  If we are unable to realize the font ourselves we allow */
/*                  the GRE to match it with one of the system fonts.       */
/*                                                                          */
/*                                                                          */
/* PARAMETERS:      HDC          hdc                                        */
/*                  ULONG        cmdCommand : RF_ flags                     */
/*                  PFATTRS      pLogFont                                   */
/*                  PULONG       pFont                                      */
/*                  PVOID        pddc                                       */
/*                  ULONG        ulFunction                                 */
/*                                                                          */
/* RETURN VALUES:   ULONG        ulrc == 0      : fail and allow GRE to     */
/*                                                select/realize a font     */
/*                                    == handle : we realized a font and    */
/*                                                this is its handle        */
/*                                                                          */
/*--------------------------------------------------------------------------*/
/* CHANGE/MODIFICATION LOG :                                                */
/*--------------------------------------------------------------------------*/
/* TAG - DATE - [COMPANY] - AUTHOR - DESCRIPTION                            */
/*--------------------------------------------------------------------------*/
/*                                                                          */
/*                                                                          */
/****************************************************************************/
LONG ENGENTRY RealizeFont( HDC            hdc,
                           ULONG          cmdCommand,
                           PFATTRS        pLogFont,
                           PULONG         pFont,
                           PDDC           pddc,
                           ULONG          ulFunction )
{
  REGREC      regrec;
  ULONG       ulException;
  ULONG       ulrc = 0;
#ifdef DEBUG
  PDEBUGINFO  pDbg = &globals.DebugInfo;
#endif


  REGISTERHANDLER (regrec, globals.hModule);
  ulException = setjmp( regrec.jmp );
  if( ulException ) {
    // clean up here
    assertstring ("Exception occured!\n");
    CheckForTermination( &regrec, ulException, pddc );
    // error result
    ulrc = FALSE;
    goto depart;
  }

  DBPRINTIF(( pDbg->bREALIZEFONT, "RealizeFont(): Enter\n" ));

  ENTERDDC( pddc );

  switch( cmdCommand )
  {
    case RF_DEVICE_FONT:
    {
      DBPRINTIF(( pDbg->bREALIZEFONT, "     ------------------------\n" ));
      DBPRINTIF(( pDbg->bREALIZEFONT, "     RealizeFont(); FATTRS:\n" ));
      DBPRINTIF(( pDbg->bREALIZEFONT, "     ------------------------\n" ));
      DBPRINTIF(( pDbg->bREALIZEFONT, "     usRecordLength  = %d\n", pLogFont->usRecordLength  ));

      if( pLogFont->fsSelection & FATTR_SEL_OUTLINE )
      {
        DBPRINTIF(( pDbg->bREALIZEFONT, "     fsSelection = FATTR_SEL_OUTLINE\n" ));
      } /* end if */

      if( pLogFont->fsSelection & FATTR_SEL_ITALIC )
      {
        DBPRINTIF(( pDbg->bREALIZEFONT, "     fsSelection = FATTR_SEL_ITALIC\n" ));
      } /* end if */

      if( pLogFont->fsSelection & FATTR_SEL_BOLD )
      {
        DBPRINTIF(( pDbg->bREALIZEFONT, "     fsSelection = FATTR_SEL_BOLD\n" ));
      } /* end if */

      if( pLogFont->fsSelection & FATTR_SEL_UNDERSCORE )
      {
        DBPRINTIF(( pDbg->bREALIZEFONT, "     fsSelection = FATTR_SEL_UNDERSCORE\n" ));
      } /* end if */

      if( pLogFont->fsSelection & FATTR_SEL_STRIKEOUT )
      {
        DBPRINTIF(( pDbg->bREALIZEFONT, "     fsSelection = FATTR_SEL_STRIKEOUT\n" ));
      } /* end if */


      DBPRINTIF(( pDbg->bREALIZEFONT, "     lMatch          = %d\n", pLogFont->lMatch          ));
      DBPRINTIF(( pDbg->bREALIZEFONT, "     szFacename      = %s\n", pLogFont->szFacename      ));
      DBPRINTIF(( pDbg->bREALIZEFONT, "     idRegistry      = %d\n", pLogFont->idRegistry      ));
      DBPRINTIF(( pDbg->bREALIZEFONT, "     usCodePage      = %d\n", pLogFont->usCodePage      ));
      DBPRINTIF(( pDbg->bREALIZEFONT, "     lMaxBaselineExt = %d\n", pLogFont->lMaxBaselineExt ));
      DBPRINTIF(( pDbg->bREALIZEFONT, "     lAveCharWidth   = %d\n", pLogFont->lAveCharWidth   ));

      if( pLogFont->fsType & FATTR_TYPE_KERNING )
      {
        DBPRINTIF(( pDbg->bREALIZEFONT, "     fsType    = FATTR_TYPE_KERNING\n" ));
      } /* end if */

      if( pLogFont->fsType & FATTR_TYPE_MBCS )
      {
        DBPRINTIF(( pDbg->bREALIZEFONT, "     fsType    = FATTR_TYPE_MBCS\n" ));
      } /* end if */

      if( pLogFont->fsType & FATTR_TYPE_DBCS )
      {
        DBPRINTIF(( pDbg->bREALIZEFONT, "     fsType    = FATTR_TYPE_DBCS\n" ));
      } /* end if */

      if( pLogFont->fsType & FATTR_TYPE_ANTIALIASED )
      {
        DBPRINTIF(( pDbg->bREALIZEFONT, "     fsType    = FATTR_TYPE_ANTIALIASED\n" ));
      } /* end if */

      if( pLogFont->fsFontUse & FATTR_FONTUSE_NOMIX )
      {
        DBPRINTIF(( pDbg->bREALIZEFONT, "     fsFontUse = FATTR_FONTUSE_NOMIX\n" ));
      } /* end if */

      if( pLogFont->fsFontUse & FATTR_FONTUSE_OUTLINE )
      {
        DBPRINTIF(( pDbg->bREALIZEFONT, "     fsFontUse = FATTR_FONTUSE_OUTLINE\n" ));
      } /* end if */

      if( pLogFont->fsFontUse & FATTR_FONTUSE_TRANSFORMABLE )
      {
        DBPRINTIF(( pDbg->bREALIZEFONT, "     fsFontUse = FATTR_FONTUSE_TRANSFORMABLE\n" ));
      } /* end if */

      DBPRINTIF(( pDbg->bREALIZEFONT, "     ------------------------\n" ));

      // See what type of font match is supposed to be
      if( pLogFont->lMatch > 0 )
      {

        // @TBD - add font synonyming in printer props
        // to allow device font replacement of system
        // fonts.  basically we realize our device font
        // and allow engine to continue using it's system font
        // to respond to queries from the app

        // System font requested; return 0 meaning no match found
        ulrc = 0;

      } /* end if */
      else
      {
        // If font lMatch is 0 this means we must use FATTRS info
        // to match the font
        if( pLogFont->lMatch == 0 )
        {
          // @TBD - need matching algorithm
          //        FindFontMatch( pLogFont );
          ulrc = 0; // @TBD - for now fail to GRE's choice

        } /* end if */
        else
        {
          // @TBD
          // really wants a device font, check this devices
          // supported fonts for a matching "lmatch" and
          // retrieve font info (FONTMETRICS) for other validation.

          // @TBD
          // if match found check FATTRS fsSelection, fsType, etc.
          // to verify our font can really simulate BOLD etc.
          // if so return handle
          ulrc = 0; // @TBD - could return lmatch or pointer to
                    // a font struct

        } /* end else */

      } /* end else */

    } /* end case */
    break;

    case RF_LOAD_ENGINE_FONT:
      // engine asking driver to convert an engine font into a device font;
      // return 0 meaning we do not support this currently

      // NOTE: at this point pLogFont and pFont point to engine font info
      // and glyphs are available for IFI fonts
      DBPRINTIF(( pDbg->bREALIZEFONT, "RealizeFont(): RF_LOAD_ENGINE_FONT\n" ));
      ulrc = 0;
    break;

    case RF_DELETE_FONT:
      DBPRINTIF(( pDbg->bREALIZEFONT, "RealizeFont(): RF_DELETE_FONT\n" ));
      ulrc = GPI_ERROR;
    break;

    case RF_DELETE_ENGINE_FONT:
      DBPRINTIF(( pDbg->bREALIZEFONT, "RealizeFont(): RF_DELETE_ENGINE_FONT\n" ));
      ulrc = GPI_ERROR;
    break;

    default:
      DBPRINTIF(( pDbg->bREALIZEFONT, "!!!RealizeFont(): Unrecognized RF_ Command = %d!!!\n", cmdCommand ));
      assertstring ("Should not be here!\n");
    break;

  } /* end switch */

depart:
  EXITDDC( pddc );
  UNREGISTERHANDLER( regrec );

  DBPRINTIF(( pDbg->bREALIZEFONT, "RealizeFont(): Exit; ulrc = %d\n", ulrc ));

  return( ulrc );

} /* end RealizeFont */


// @MARK---------------------------------------------------------------------------------------------------------------
LONG ENGENTRY GetStyleRatio(            HDC            hdc,
                                        PBYTE          pRatio,
                                        PDDC           pddc,
                                        ULONG          ulFunction )
{
  REGREC      regrec;
  ULONG       ulException;
  ULONG       ulrc;


  REGISTERHANDLER (regrec, globals.hModule);
  ulException = setjmp( regrec.jmp );
  if( ulException ) {
    // clean up here
    assertstring ("Exception occured!\n");
    CheckForTermination( &regrec, ulException, pddc );
    // error result
    ulrc = FALSE;
    goto depart;
  }
  ENTERDDC( pddc );


  ulrc = GreGetStyleRatio (pddc->hdcShadow, pRatio);
  assert (ulrc);

depart:
  EXITDDC( pddc );
  UNREGISTERHANDLER( regrec );
  return ulrc;
}


// @MARK---------------------------------------------------------------------------------------------------------------
LONG ENGENTRY SetStyleRatio(            HDC            hdc,
                                        PBYTE          pRatio,
                                        PDDC           pddc,
                                        ULONG          ulFunction )
{
  REGREC      regrec;
  ULONG       ulException;
  ULONG       ulrc;


  REGISTERHANDLER (regrec, globals.hModule);
  ulException = setjmp( regrec.jmp );
  if( ulException ) {
    // clean up here
    assertstring ("Exception occured!\n");
    CheckForTermination( &regrec, ulException, pddc );
    // error result
    ulrc = FALSE;
    goto depart;
  }
  ENTERDDC( pddc );


  ulrc = GreSetStyleRatio (pddc->hdcShadow, pRatio);
  assert (ulrc);

depart:
  EXITDDC( pddc );
  UNREGISTERHANDLER( regrec );
  return ulrc;
}
