#ifndef _server_h
#define _server_h

#define SIG                 0x506F6F43    // 'CooP'

#define COMMAND_OPEN_REQ    0x00000001
#define COMMAND_OPEN_ACK    0x00000002
#define COMMAND_OPEN_NACK   0x00000003
#define COMMAND_BMAP_HEADER 0x00000004
#define COMMAND_SCANLINE    0x00000005
#define COMMAND_CLOSE       0x00000006

#define HEADER_SIZE  (3 * sizeof (ULONG))

/*************** I M P O R T A N T pragma follows ! ! ! ***************/
#pragma pack(1)

/*---------------------------------------------------------------------------*/

typedef struct _OpenRequest {
   ULONG     cb;                        // sizeof this structure
   ULONG     ulSig;                     // signature
   ULONG     ulCommand;                 // command
} OPENREQUEST, *POPENREQUEST;

/*---------------------------------------------------------------------------*/

typedef struct _OpenAck {
   ULONG     cb;                        // sizeof this structure
   ULONG     ulSig;                     // signature
   ULONG     ulCommand;                 // command
} OPENACK, *POPENACK;

/*---------------------------------------------------------------------------*/

typedef struct _OpenNack {
   ULONG     cb;                        // sizeof this structure
   ULONG     ulSig;                     // signature
   ULONG     ulCommand;                 // command
} OPENNACK, *POPENNACK;

/*---------------------------------------------------------------------------*/

typedef struct _BitmapHeader {
   ULONG        cb;                     // sizeof this structure
   ULONG        ulSig;                  // signature
   ULONG        ulCommand;              // command
   BITMAPINFO2  bmi2;                   // Bitmap info header
                                        // color table follows
} BMAPMESSAGE, *PBMAPMESSAGE;
#define SIZEOF_BMAPMESSAGE ((sizeof ((PBMAPMESSAGE)NULL)->cb)        + \
                            (sizeof ((PBMAPMESSAGE)NULL)->ulSig)     + \
                            (sizeof ((PBMAPMESSAGE)NULL)->ulCommand)   )

/*---------------------------------------------------------------------------*/

typedef struct _ScanLine {
   ULONG        cb;                     // sizeof this structure
   ULONG        ulSig;                  // signature
   ULONG        ulCommand;              // command
   BYTE         abData[1];              // Variably lengthed array
} SCANMESSAGE, *PSCANMESSAGE;
#define SIZEOF_SCANMESSAGE ((sizeof ((PSCANMESSAGE)NULL)->cb)      + \
                            (sizeof ((PSCANMESSAGE)NULL)->ulSig)   + \
                            (sizeof ((PSCANMESSAGE)NULL)->ulCommand) )

/*---------------------------------------------------------------------------*/

typedef struct _CloseMessage {
   ULONG        cb;                     // sizeof this structure
   ULONG        ulSig;                  // signature
   ULONG        ulCommand;              // command
} CLOSEMESSAGE, *PCLOSEMESSAGE;

/*---------------------------------------------------------------------------*/

/*************** I M P O R T A N T pragma follows ! ! ! ! ***************/
#pragma pack()

#endif
