/* REXX: BandSize <number of bytes> */

szApp = "OMNIDriver"
szKey = "BandSize"

call RxFuncAdd 'SysIni', 'RexxUtil', 'SysIni'

if length( arg( 1 ) ) = 0 then
   signal usage;

parse arg szArg .

if right( szArg, 1 ) = 'k' |,
   right( szArg, 1 ) = 'K'    then
do
   szArg = left( szArg, length( szArg ) - 1 ) * 1024
end

if right( szArg, 1 ) = 'm' |,
   right( szArg, 1 ) = 'M'    then
do
   szArg = left( szArg, length( szArg ) - 1 ) * 1000 * 1024
end

if datatype( szArg, 'N' ) \= 1 then
   signal usage;

if szArg > 0 then
   szVal = szArg || '00'x
else
   szVal = 'DELETE:'

call SysIni 'SYSTEM', szApp, szKey, szVal

say "Result = " '"'Result'"'

exit

usage:

say "Usage: BandSize <number of bytes>       Ex: BandSize 524288"
say "          or"
say "       BandSize <number of kilobytes>k  Ex: BandSize 512K"
say "          or"
say "       BandSize <number of megabytes>m  Ex: BandSize 64M"
say ""
say "       A value of 0 will delete the ini file entry."

/* Query the current value */
szValue =  SysIni( 'SYSTEM', szApp, szKey )

/* get rid of the terminating null character */
szValue = strip( translate( szValue, ' ', '0'x ) )

if szValue \= '' & datatype( szValue ) = 'NUM' then
   szResult = format( szValue / 1024.000, , 3 ) || 'K'
else
   szResult = "nothing!"

say
say "The current band size is set to" szResult
exit
