/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1992 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 source code is provided to you solely for       */
/*    the purpose of assisting you in your development of OS/2 device        */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Developer Connection Device Driver       */
/*    Source Kit for OS/2. This Copyright statement may not be removed.      */
/*                                                                           */
/*****************************************************************************/
// attrib.c

#define INCL_DOS
#define INCL_PM
#include <os2.h>

#define INCL_DDICOMFLAGS
#define INCL_GRE_DEVMISC1
#define INCL_GRE_DEVSUPPORT
#define INCL_DDIMISC
#define INCL_DDIBUNDLES
// @DBCS
#define INCL_VMANDDI
#include <ddi.h>
#include <pmddi.h>

// c includes
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <setjmp.h>

// driver includes
#define INCL_INNER_GRE
#include "def.h"
#include "driver.h"
#include "funcs.h"

#ifdef DEBUG
VOID PrintLineBundle   (PDEBUGINFO pDbg, PDLINEBUNDLE   pdlinebundle,   ULONG flAttrsMask);
VOID PrintAreaBundle   (PDEBUGINFO pDbg, PDAREABUNDLE   pdareabundle,   ULONG flAttrsMask);
VOID PrintCharBundle   (PDEBUGINFO pDbg, PDCHARBUNDLE   pdcharbundle,   ULONG flAttrsMask);
VOID PrintImageBundle  (PDEBUGINFO pDbg, PDIMAGEBUNDLE  pdimagebundle,  ULONG flAttrsMask);
VOID PrintMarkerBundle (PDEBUGINFO pDbg, PDMARKERBUNDLE pdmarkerbundle, ULONG flAttrsMask);
#endif


// --------------------------------------------------------------------------------------------------------------------
// only need one copy in memory of the attribute bundles that contain the default settings
// so pragma this static declaration onto a global data page in memory

#pragma data_seg( Global )

CHARBUNDLE DefaultCharBundle = {
        CLR_BLACK,                     // lColor
        CLR_WHITE,                     // lBackColor
        FM_OVERPAINT,                  // usMixMode
        BM_LEAVEALONE,                 // usBackMixMode
        0,                             // usSet
        CM_MODE3,                      // usPrecision
        {0x320000L,0x320000L},         // sizfxCell
        { 1, 0 },                      // ptlAngle
        { 0, 1 },                      // ptlShear
        CHDIRN_LEFTRIGHT,              // usDirection
        TA_NORMAL_HORIZ | TA_NORMAL_VERT,   // usTextAlign  @TTY
        0,                             // fxExtra
        0                              // fxBreakExtra
};



//----------------------------------------------------------------------------------------

LONG ENGENTRY DeviceSetAttributes( HDC       hdc,
                                   ULONG     ulBType,
                                   ULONG     ulDefsMask,
                                   ULONG     flAttrsMask,
                                   PBUNDLE   pAttrs,
                                   PDDC      pddc,
                                   ULONG     ulFunction )
{
  REGREC          regrec;
  ULONG           ulException;
  LONG            lrc;
  PDCHARBUNDLE    pdcharbundle;
  PDLINEBUNDLE    pdlinebundle;
  PDAREABUNDLE    pdareabundle;
  PDMARKERBUNDLE  pdmarkerbundle;
  PDIMAGEBUNDLE   pdimagebundle;
  ULONG           ulDeviceSetAttr;
  ULONG           ulDefSet;
  ULONG           ulStatus;
  ULONG           ulDeviceBitmapHandle;
#ifdef DEBUG
  PDEBUGINFO      pDbg = &globals.DebugInfo;
#endif


  REGISTERHANDLER (regrec, globals.hModule);
  ulException = setjmp( regrec.jmp );
  if( ulException ) {
    // clean up here
    CheckForTermination( &regrec, ulException, pddc );
    // error result
    lrc = FALSE;
    goto depart;
  }

  ENTERDDC( pddc );

  if( ! flAttrsMask ) {
    // nothing to do
    lrc = TRUE;
    goto depart;
  }


  switch( ulBType ) {
  case PRIM_AREA:
  {
    pdareabundle = (PDAREABUNDLE)pAttrs;
    ulDeviceSetAttr = 0;

#ifdef DEBUG
    PrintAreaBundle (pDbg, pdareabundle, flAttrsMask);
#endif

    // assume that the fill pattern is not a bitmap used for filling
    // assume a normal, standard area fill pattern
    ulDefSet = 0;


    if( ABB_SET & flAttrsMask ) {

      // save a copy of the supplied area fill handle
      ulDefSet = pdareabundle->adef.defSet;

      // Check if the defSet is a bitmap handle.
      // The GRE identifies bitmap handles with a 0x0400 in the high-order word of the handle.
      // If it's a bitmap handle, then this bitmap will be used as the area fill pattern.

      if( 0x0400 == HIUSHORT( ulDefSet )) {
        // ulDefSet is a bitmap handle
        // GetDriverInfo is GRE-exported function that can
        // get the device-specified handle for this bitmap from the shadow DC
        ulDeviceBitmapHandle = GetDriverInfo( (HBITMAP) ulDefSet, 1L, pddc->hdcShadow );
        assert( (LONG)ulDeviceBitmapHandle != GPI_ALTERROR );

        // use the device bitmap handle on the call to shadow DC device set attributes because it is the
        // handle shadow DC device understands
        // be sure to set it back after the call
        pdareabundle->adef.defSet = ulDeviceBitmapHandle;

        flAttrsMask &= ~ABB_SET;
        ulDeviceSetAttr = ABB_SET;
      }
    }

    // device-level area fill set numbers are meaningless at this entry point, thus ABB_SET bit was masked off
    ulStatus = InnerGreSetAttributes( pddc->hdcShadow, ulBType, ulDefsMask, flAttrsMask, &pdareabundle->abnd, ulFunction );
    assertF( ulStatus );

    // if there's a device-level bitmap fill pattern, then set it on the shadow dc with this call
    if( ulDeviceSetAttr )
    {
      ulStatus = InnerGreDeviceSetAttributes( pddc->hdcShadow, ulBType, ulDefsMask, ulDeviceSetAttr, pAttrs, ulFunction );
      assertF( ulStatus );
    }

    // clean up the dareabundle if it was modified above
    if( ulDefSet ) {
      pdareabundle->adef.defSet = ulDefSet;
    }
    lrc = TRUE;
    break;
  }



  case PRIM_CHAR:
  {
    pdcharbundle = (PDCHARBUNDLE)pAttrs;
    ulDeviceSetAttr = 0;

#ifdef DEBUG
    PrintCharBundle (pDbg, pdcharbundle, flAttrsMask);
#endif

    // If we are dealing with an engine font
    if( (pdcharbundle->cbnd.usSet != 0) &&
        (pdcharbundle->cdef.fFlags & CDEF_GENERIC ) )
    {
      if( CBB_SET & flAttrsMask )
      {
        // device-level set numbers are meaningless at this entry point, thus CBB_SET bit was masked off
        flAttrsMask &= ~CBB_SET;

        // but I need to set this attribute at the device level
        ulDeviceSetAttr = CBB_SET;
      }

      // device-level set numbers are meaningless at this entry point, thus CBB_SET bit was masked off
      assert( !(flAttrsMask & CBB_SET) );

      DBPRINTIF((pDbg->bATTRIBUTEBUNDLESCHAR, "    PRIM_CHAR: engine font: usSet = %d; fFlags = CDEF_GENERIC\n", pdcharbundle->cbnd.usSet ));

      ulStatus = InnerGreSetAttributes( pddc->hdcShadow, ulBType, ulDefsMask, flAttrsMask, &pdcharbundle->cbnd, ulFunction );
      assert( ulStatus );

      // however, if device-level attributes are spec'd, then set them on the shadow dc with this call
      if(ulDeviceSetAttr)
      {
        ulStatus = InnerGreDeviceSetAttributes( pddc->hdcShadow, ulBType, ulDefsMask, ulDeviceSetAttr, pAttrs, ulFunction );
        assert( ulStatus );
      }
      lrc = TRUE;

    } /* end if */
    else
    {
      // user wants device default font
      if(pdcharbundle->cbnd.usSet == 0)
      {
        // @TBD - get default font stuff
        DBPRINTIF((pDbg->bATTRIBUTEBUNDLESCHAR, "    PRIM_CHAR: default font: usSet = 0; still use shadow DC\n" ));
        if( CBB_SET & flAttrsMask )
        {
          // device-level set numbers are meaningless at this entry point, thus CBB_SET bit was masked off
          flAttrsMask &= ~CBB_SET;

          // but I need to set this attribute at the device level
          ulDeviceSetAttr = CBB_SET;
        }

        // device-level set numbers are meaningless at this entry point, thus CBB_SET bit was masked off
        assert( !(flAttrsMask & CBB_SET) );

        DBPRINTIF((pDbg->bATTRIBUTEBUNDLESCHAR, "    PRIM_CHAR: engine font: usSet = %d; fFlags = CDEF_GENERIC\n", pdcharbundle->cbnd.usSet ));

        ulStatus = InnerGreSetAttributes( pddc->hdcShadow, ulBType, ulDefsMask, flAttrsMask, &pdcharbundle->cbnd, ulFunction );
        assert( ulStatus );

        // however, if device-level attributes are spec'd, then set them on the shadow dc with this call
        if(ulDeviceSetAttr)
        {
          ulStatus = InnerGreDeviceSetAttributes( pddc->hdcShadow, ulBType, ulDefsMask, ulDeviceSetAttr, pAttrs, ulFunction );
          assert( ulStatus );
        }
        lrc = TRUE;

      } /* end if */
      else
      {
        // user wants device font identifier
        DBPRINTIF((pDbg->bATTRIBUTEBUNDLESCHAR, "    PRIM_CHAR: device font: usSet = %d; defset = %d\n", pdcharbundle->cbnd.usSet, pdcharbundle->cdef.defSet ));
        assertstring ("Should not be here!\n");

      } /* end else */

    } /* end else */

    break;
  }

  case PRIM_IMAGE:
  {
    // image and line have no device-level handles; can just relay the call into the shadow dc set attributes
    pdimagebundle = (PDIMAGEBUNDLE)pAttrs;

#ifdef DEBUG
    PrintImageBundle (pDbg, pdimagebundle, flAttrsMask);
#endif
    ulStatus = InnerGreSetAttributes( pddc->hdcShadow, ulBType, ulDefsMask, flAttrsMask, &pdimagebundle->ibnd, ulFunction );
    assert( ulStatus );
    lrc = TRUE;
    break;
  }

  case PRIM_LINE:
  {
    // image and line have no device-level handles; can just relay the call into the shadow dc set attributes
    pdlinebundle = (PDLINEBUNDLE)pAttrs;

#ifdef DEBUG
    PrintLineBundle (pDbg, pdlinebundle, flAttrsMask);
#endif

    ulStatus = InnerGreSetAttributes( pddc->hdcShadow, ulBType, ulDefsMask, flAttrsMask, &pdlinebundle->lbnd, ulFunction );
    assert( ulStatus );
    lrc = TRUE;
    break;
  }


  case PRIM_MARKER:
  {
    pdmarkerbundle = (PDMARKERBUNDLE)pAttrs;
    ulDeviceSetAttr = 0;

#ifdef DEBUG
    PrintMarkerBundle (pDbg, pdmarkerbundle, flAttrsMask);
#endif

    if( MBB_SET & flAttrsMask ) {
      // device-level set numbers are meaningless at this entry point, thus CBB_SET bit is masked off
      flAttrsMask &= ~MBB_SET;
      // but I need to set this attribute at the device level
      ulDeviceSetAttr = MBB_SET;
    }

    // device-level set numbers are meaningless at this entry point, thus CBB_SET bit was masked off
    assert( !(flAttrsMask & MBB_SET ));
    ulStatus = InnerGreSetAttributes( pddc->hdcShadow, ulBType, ulDefsMask, flAttrsMask, &pdmarkerbundle->mbnd, ulFunction );
    assert( ulStatus );

    // however, if device-level attributes are spec'd, then set them on the shadow dc with this call
    if(  ulDeviceSetAttr) {
      ulStatus = InnerGreDeviceSetAttributes( pddc->hdcShadow, ulBType, ulDefsMask, ulDeviceSetAttr, pAttrs, ulFunction );
      assert( ulStatus );
    }
    lrc = TRUE;
    break;
  }

  default:
  {
    assertstring ("Should not be here!\n");
    break;
  }
  }

#ifndef DEBUG
  ulStatus++; // Get rid of warning
#endif

depart:
  EXITDDC( pddc );
  UNREGISTERHANDLER( regrec );
  return lrc;
}



//----------------------------------------------------------------------------------------

LONG ENGENTRY DeviceGetAttributes( HDC       hdc,
                                   LONG      lPrimType,
                                   ULONG     ulAttrsMask,
                                   PBUNDLE   pAttrs,
                                   PDDC      pddc,
                                   ULONG     ulFunction )
{
  REGREC      regrec;
  ULONG       ulException;
  LONG        lrc;


  REGISTERHANDLER (regrec, globals.hModule);
  ulException = setjmp( regrec.jmp );
  if( ulException ) {
    // clean up here
    assertstring ("Exception occured!\n");
    CheckForTermination( &regrec, ulException, pddc );
    // error result
    lrc = FALSE;
    goto depart;
  }
  ENTERDDC( pddc );


  lrc = GreDeviceGetAttributes( pddc->hdcShadow, lPrimType, ulAttrsMask, pAttrs );
  assert( lrc );

depart:
  EXITDDC( pddc );
  UNREGISTERHANDLER( regrec );
  return lrc;
}

//----------------------------------------------------------------------------------------

LONG ENGENTRY DeviceSetGlobalAttribute( HDC       hdc,
                                        LONG      lAttrType,
                                        LONG      lAttribute,
                                        ULONG     flOptions,
                                        PDDC      pddc,
                                        ULONG     ulFunction )
{
  REGREC      regrec;
  ULONG       ulException;
  ULONG       lrc;


  REGISTERHANDLER (regrec, globals.hModule);
  ulException = setjmp( regrec.jmp );
  if( ulException ) {
    // clean up here
    CheckForTermination( &regrec, ulException, pddc );
    // error result
    lrc = FALSE;
    goto depart;
  }
  ENTERDDC( pddc );


  lrc = GreSetGlobalAttribute( pddc->hdcShadow, lAttrType, lAttribute, flOptions );
  assert( lrc );


depart:
  EXITDDC( pddc );
  UNREGISTERHANDLER( regrec );
  return lrc;
}



//----------------------------------------------------------------------------------------

LONG ENGENTRY GetPairKerningTable     ( HDC            hdc,
                                        LONG           cKernPairs,
                                        PKERNINGPAIRS  pKerningPairs,
                                        PDDC           pddc,
                                        ULONG          ulFunction )
{
  REGREC      regrec;
  ULONG       ulException;
  LONG        lrc;


  REGISTERHANDLER (regrec, globals.hModule);
  ulException = setjmp( regrec.jmp );
  if( ulException ) {
    // clean up here
    assertstring ("Exception occured!\n");
    CheckForTermination( &regrec, ulException, pddc );
    // error result
    lrc = FALSE;
    goto depart;
  }
  ENTERDDC( pddc );


  lrc = GreGetPairKerningTable( pddc->hdcShadow, cKernPairs, pKerningPairs );
  assert( lrc );

depart:
  EXITDDC( pddc );
  UNREGISTERHANDLER( regrec );
  return lrc;
}

#ifdef DEBUG
VOID
PrintCharBundle (PDEBUGINFO pDbg, PDCHARBUNDLE pdcharbundle, ULONG flAttrsMask)
{
if (pDbg->bATTRIBUTEBUNDLESCHAR)
{
  CHAR szMsg[256];


  DBPRINTF(( "    -----------------------\n" ));
  DBPRINTF(( "    PRIM_CHAR: DCHARBUNDLE:\n" ));
  DBPRINTF(( "    -----------------------\n" ));

  if( CBB_COLOR & flAttrsMask )
    DBPRINTF(( "    CBB_COLOR = %d\n", pdcharbundle->cbnd.lColor ));
  if( CBB_BACK_COLOR & flAttrsMask )
    DBPRINTF(( "    CBB_BACK_COLOR = %d\n", pdcharbundle->cbnd.lBackColor ));
  if( CBB_MIX_MODE & flAttrsMask )
    DBPRINTF(( "    CBB_MIX_MODE = %d\n", pdcharbundle->cbnd.usMixMode ));
  if( CBB_BACK_MIX_MODE & flAttrsMask )
    DBPRINTF(( "    CBB_BACK_MIX_MODE = %d\n", pdcharbundle->cbnd.usBackMixMode ));

  if( CBB_MODE & flAttrsMask )
  {
    switch( pdcharbundle->cbnd.usPrecision )
    {
      case CM_MODE1:
        sprintf( szMsg, "CM_MODE1\0" );
      break;
      case CM_MODE2:
        sprintf( szMsg, "CM_MODE1\0" );
      break;
      case CM_MODE3:
        sprintf( szMsg, "CM_MODE1\0" );
      break;

      default:
      {
        assertstring ("!!!ERROR: Unknown CharMode!!!\n");
      } /* end case */
      break;
    } /* end switch */

    DBPRINTF(( "    CBB_MODE = %s\n", szMsg ));
  } /* end if */

  if( CBB_BOX & flAttrsMask )
  {
    USHORT usInt, usFract;

    usInt   = FIXEDINT ( pdcharbundle->cbnd.sizfxCell.cx );
    usFract = FIXEDFRAC( pdcharbundle->cbnd.sizfxCell.cx );

    DBPRINTF(( "    CBB_BOX (cx) = %d.%d\n", usInt, usFract ));

    usInt   = FIXEDINT ( pdcharbundle->cbnd.sizfxCell.cy );
    usFract = FIXEDFRAC( pdcharbundle->cbnd.sizfxCell.cy );

    DBPRINTF(( "    CBB_BOX (cy) = %d.%d\n", usInt, usFract ));
  } /* end if */

  if( CBB_ANGLE & flAttrsMask )
    DBPRINTF(( "    CBB_ANGLE : x = %d; y = %d\n", pdcharbundle->cbnd.ptlAngle.x, pdcharbundle->cbnd.ptlAngle.y ));

  if( CBB_SHEAR & flAttrsMask )
    DBPRINTF(( "    CBB_SHEAR : x = %d; y = %d\n", pdcharbundle->cbnd.ptlShear.x, pdcharbundle->cbnd.ptlShear.y ));

  if( CBB_DIRECTION & flAttrsMask )
  {
    switch( pdcharbundle->cbnd.usDirection )
    {
      case CHDIRN_LEFTRIGHT:
        sprintf( szMsg, "CHDIRN_LEFTRIGHT\0" );
      break;
      case CHDIRN_TOPBOTTOM:
        sprintf( szMsg, "CHDIRN_TOPBOTTOM\0" );
      break;
      case CHDIRN_RIGHTLEFT:
        sprintf( szMsg, "CHDIRN_RIGHTLEFT\0" );
      break;
      case CHDIRN_BOTTOMTOP:
        sprintf( szMsg, "CHDIRN_BOTTOMTOP\0" );
      break;

      default:
      {
        assertstring ("!!!ERROR: Unknown Char Direction!!!\n");
      } /* end case */
      break;
    } /* end switch */

    DBPRINTF(( "    CBB_DIRECTION = %s\n", szMsg ));
  } /* end if */

  if( CBB_TEXT_ALIGN & flAttrsMask )
  {
    // all known flags
    ULONG ulAll = TA_NORMAL_HORIZ | TA_LEFT | TA_CENTER | TA_RIGHT |
                  TA_STANDARD_HORIZ | TA_NORMAL_VERT | TA_TOP | TA_HALF |
                  TA_BASE | TA_BOTTOM | TA_STANDARD_VERT;

    if( pdcharbundle->cbnd.usTextAlign & TA_NORMAL_HORIZ )
      DBPRINTF(( "    CBB_TEXT_ALIGN = TA_NORMAL_HORIZ\n" ));
    if( pdcharbundle->cbnd.usTextAlign & TA_LEFT )
      DBPRINTF(( "    CBB_TEXT_ALIGN = TA_LEFT\n" ));
    if( pdcharbundle->cbnd.usTextAlign & TA_CENTER )
      DBPRINTF(( "    CBB_TEXT_ALIGN = TA_CENTER\n" ));
    if( pdcharbundle->cbnd.usTextAlign & TA_RIGHT )
      DBPRINTF(( "    CBB_TEXT_ALIGN = TA_RIGHT\n" ));
    if( pdcharbundle->cbnd.usTextAlign & TA_STANDARD_HORIZ )
      DBPRINTF(( "    CBB_TEXT_ALIGN = TA_STANDARD_HORIZ\n" ));
    if( pdcharbundle->cbnd.usTextAlign & TA_NORMAL_VERT )
      DBPRINTF(( "    CBB_TEXT_ALIGN = TA_NORMAL_VERT\n" ));
    if( pdcharbundle->cbnd.usTextAlign & TA_TOP )
      DBPRINTF(( "    CBB_TEXT_ALIGN = TA_TOP\n" ));
    if( pdcharbundle->cbnd.usTextAlign & TA_HALF )
      DBPRINTF(( "    CBB_TEXT_ALIGN = TA_HALF\n" ));
    if( pdcharbundle->cbnd.usTextAlign & TA_BASE )
      DBPRINTF(( "    CBB_TEXT_ALIGN = TA_BASE\n" ));
    if( pdcharbundle->cbnd.usTextAlign & TA_BOTTOM )
      DBPRINTF(( "    CBB_TEXT_ALIGN = TA_BOTTOM\n" ));
    if( pdcharbundle->cbnd.usTextAlign & TA_STANDARD_VERT )
      DBPRINTF(( "    CBB_TEXT_ALIGN = TA_STANDARD_VERT\n" ));
    if( pdcharbundle->cbnd.usTextAlign & ~ulAll )
    {
      DBPRINTF(( "    CBB_TEXT_ALIGN = !!!ERROR: Unknown Text Alignment = %d!!!\n", pdcharbundle->cbnd.usTextAlign ));
      assertstring ("Should not be here!\n");
    } /* end case */
  } /* end if */

  if( CBB_EXTRA & flAttrsMask )
  {
    USHORT usInt, usFract;

    usInt   = FIXEDINT ( pdcharbundle->cbnd.fxExtra );
    usFract = FIXEDFRAC( pdcharbundle->cbnd.fxExtra );

    DBPRINTF(( "    CBB_EXTRA = %d.%d\n", usInt, usFract ));
  } /* end if */

  if( CBB_BREAK_EXTRA & flAttrsMask )
  {
    USHORT usInt, usFract;

    usInt   = FIXEDINT ( pdcharbundle->cbnd.fxBreakExtra );
    usFract = FIXEDFRAC( pdcharbundle->cbnd.fxBreakExtra );

    DBPRINTF(( "    CBB_BREAK_EXTRA = %d.%d\n", usInt, usFract ));
  } /* end if */

  if( CBB_SET & flAttrsMask )
  {
    DBPRINTF(( "    CBB_SET (Lcid) = %d\n", pdcharbundle->cbnd.usSet ));

    if( (pdcharbundle->cbnd.usSet != 0) &&
        (pdcharbundle->cdef.fFlags & CDEF_GENERIC ) )
      DBPRINTF(( "    CDEF_GENERIC: cdef.defset = %d (engine font)\n", pdcharbundle->cdef.defSet ));
    else
      DBPRINTF(( "    Not CDEF_GENERIC: cdef.defset = %d (device font)\n", pdcharbundle->cdef.defSet ));
  } /* end if */

  DBPRINTF(( "    -----------------------\n" ));
} /* end logical block */

}

VOID
PrintLineBundle (PDEBUGINFO pDbg, PDLINEBUNDLE pdlinebundle, ULONG flAttrsMask)
{
if (pDbg->bATTRIBUTEBUNDLESLINE)
{
  DBPRINTF(( "    -----------------------\n" ));
  DBPRINTF(( "    PRIM_LINE: DLINEBUNDLE:\n" ));
  DBPRINTF(( "    -----------------------\n" ));

  if( LBB_COLOR & flAttrsMask )
    DBPRINTF(( "    LBB_COLOR = %d\n", pdlinebundle->lbnd.lColor ));
  if( LBB_BACK_COLOR & flAttrsMask )
    DBPRINTF(( "    LBB_BACK_COLOR = %d\n", pdlinebundle->lbnd.lBackColor ));
  if( LBB_MIX_MODE & flAttrsMask )
    DBPRINTF(( "    LBB_MIX_MODE = %d\n", pdlinebundle->lbnd.usMixMode ));
  if( LBB_BACK_MIX_MODE & flAttrsMask )
    DBPRINTF(( "    LBB_BACK_MIX_MODE = %d\n", pdlinebundle->lbnd.usBackMixMode ));

  if( LBB_WIDTH & flAttrsMask )
  {
    USHORT usInt, usFract;

    usInt   = FIXEDINT ( pdlinebundle->lbnd.fxWidth );
    usFract = FIXEDFRAC( pdlinebundle->lbnd.fxWidth );

    DBPRINTF(( "    LBB_WIDTH  = %d.%d\n", usInt, usFract ));
  } /* end if */

  if (LBB_GEOM_WIDTH & flAttrsMask)
     DBPRINTF(( "    LBB_GEOM_WIDTH = %d\n", pdlinebundle->lbnd.lGeomWidth ));
  if (LBB_TYPE & flAttrsMask)
     DBPRINTF(( "    LBB_TYPE = %d\n", pdlinebundle->lbnd.usType ));
  if (LBB_END & flAttrsMask)
     DBPRINTF(( "    LBB_END = %d\n", pdlinebundle->lbnd.usEnd ));
  if (LBB_JOIN & flAttrsMask)
     DBPRINTF(( "    LBB_JOIN = %d\n", pdlinebundle->lbnd.usJoin ));

  DBPRINTF(( "    -----------------------\n" ));
} /* end logical block */

}

VOID
PrintAreaBundle (PDEBUGINFO pDbg, PDAREABUNDLE pdareabundle, ULONG flAttrsMask)
{
if (pDbg->bATTRIBUTEBUNDLESAREA)
{
  DBPRINTF(( "    -----------------------\n" ));
  DBPRINTF(( "    PRIM_AREA: DAREABUNDLE:\n" ));
  DBPRINTF(( "    -----------------------\n" ));

  if( ABB_COLOR & flAttrsMask )
    DBPRINTF(( "    ABB_COLOR = %d\n", pdareabundle->abnd.lColor ));
  if( ABB_BACK_COLOR & flAttrsMask )
    DBPRINTF(( "    ABB_BACK_COLOR = %d\n", pdareabundle->abnd.lBackColor ));
  if( ABB_MIX_MODE & flAttrsMask )
    DBPRINTF(( "    ABB_MIX_MODE = %d\n", pdareabundle->abnd.usMixMode ));
  if( ABB_BACK_MIX_MODE & flAttrsMask )
    DBPRINTF(( "    ABB_BACK_MIX_MODE = %d\n", pdareabundle->abnd.usBackMixMode ));
  if (ABB_SET & flAttrsMask)
    DBPRINTF(( "    ABB_SET = %d\n", pdareabundle->abnd.usSet ));
  if (ABB_SYMBOL & flAttrsMask)
    DBPRINTF(( "    ABB_SYMBOL = %d\n", pdareabundle->abnd.usSymbol ));
  if (ABB_REF_POINT & flAttrsMask)
    DBPRINTF(( "    ABB_REF_POINT = (%d, %d)\n",
              pdareabundle->abnd.ptlRefPoint.x,
              pdareabundle->abnd.ptlRefPoint.y ));

  DBPRINTF(( "    -----------------------\n" ));
} /* end logical block */
}

VOID
PrintImageBundle (PDEBUGINFO pDbg, PDIMAGEBUNDLE pdimagebundle, ULONG flAttrsMask)
{
if (pDbg->bATTRIBUTEBUNDLESIMAGE)
{
  DBPRINTF(( "    -----------------------\n" ));
  DBPRINTF(( "    PRIM_IMAGE: DIMAGEBUNDLE:\n" ));
  DBPRINTF(( "    -----------------------\n" ));

  if( IBB_COLOR & flAttrsMask )
    DBPRINTF(( "    IBB_COLOR = %d\n", pdimagebundle->ibnd.lColor ));
  if( IBB_BACK_COLOR & flAttrsMask )
    DBPRINTF(( "    IBB_BACK_COLOR = %d\n", pdimagebundle->ibnd.lBackColor ));
  if( IBB_MIX_MODE & flAttrsMask )
    DBPRINTF(( "    IBB_MIX_MODE = %d\n", pdimagebundle->ibnd.usMixMode ));
  if( IBB_BACK_MIX_MODE & flAttrsMask )
    DBPRINTF(( "    IBB_BACK_MIX_MODE = %d\n", pdimagebundle->ibnd.usBackMixMode ));

  DBPRINTF(( "    -----------------------\n" ));
} /* end logical block */
}

VOID
PrintMarkerBundle (PDEBUGINFO pDbg, PDMARKERBUNDLE pdmarkerbundle, ULONG flAttrsMask)
{
if (pDbg->bATTRIBUTEBUNDLESMARKER)
{
  DBPRINTF(( "    ---------------------------\n" ));
  DBPRINTF(( "    PRIM_MARKER: DMARKERBUNDLE:\n" ));
  DBPRINTF(( "    ---------------------------\n" ));

  if( MBB_COLOR & flAttrsMask )
    DBPRINTF(( "    MBB_COLOR = %d\n", pdmarkerbundle->mbnd.lColor ));
  if( MBB_BACK_COLOR & flAttrsMask )
    DBPRINTF(( "    MBB_BACK_COLOR = %d\n", pdmarkerbundle->mbnd.lBackColor ));
  if( MBB_MIX_MODE & flAttrsMask )
    DBPRINTF(( "    MBB_MIX_MODE = %d\n", pdmarkerbundle->mbnd.usMixMode ));
  if( MBB_BACK_MIX_MODE & flAttrsMask )
    DBPRINTF(( "    MBB_BACK_MIX_MODE = %d\n", pdmarkerbundle->mbnd.usBackMixMode ));
  if (MBB_SET & flAttrsMask)
    DBPRINTF(( "    MBB_SET = %d\n", pdmarkerbundle->mbnd.usSet ));
  if (MBB_SYMBOL & flAttrsMask)
    DBPRINTF(( "    MBB_SYMBOL = %d\n", pdmarkerbundle->mbnd.usSymbol ));
  if( MBB_BOX & flAttrsMask )
  {
    USHORT usInt, usFract;

    usInt   = FIXEDINT ( pdmarkerbundle->mbnd.sizfxCell.cx );
    usFract = FIXEDFRAC( pdmarkerbundle->mbnd.sizfxCell.cx );

    DBPRINTF(( "    MBB_BOX (cx) = %d.%d\n", usInt, usFract ));

    usInt   = FIXEDINT ( pdmarkerbundle->mbnd.sizfxCell.cy );
    usFract = FIXEDFRAC( pdmarkerbundle->mbnd.sizfxCell.cy );

    DBPRINTF(( "    MBB_BOX (cy) = %d.%d\n", usInt, usFract ));
  } /* end if */

  DBPRINTF(( "    -----------------------\n" ));
} /* end logical block */
}

#endif

