/* REXX: Assert [ON | OFF]
*/

call RxFuncAdd 'SysIni', 'RexxUtil', 'SysIni'
call SysIni 'SYSTEM', szApp, szKey, szVal

if length( arg( 1 ) ) = 0 then
   signal usage

parse arg szParm1 .

szParm1 = translate( szParm1 )

if szParm1 \= "HOOKTYPE_DEBUGOUT" &  ,
   szParm1 \= "HOOKTYPE_PMPRINTF" &  ,
   szParm1 \= "DELETE"            then
   signal usage;

if szParm1 = "HOOKTYPE_DEBUGOUT" then
   szVal = "HOOKTYPE_DEBUGOUT" || '00'x

if szParm1 = "HOOKTYPE_PMPRINTF" then
   szVal = "HOOKTYPE_PMPRINTF" || '00'x

if szParm1 = "DELETE" then
   szVal = "DELETE:"

szApp = "OMNIDriver"
szKey = "HookType"

szValue =  SysIni( 'SYSTEM', szApp, szKey, szVal )
say "Result = " '"'Result'"'

results:

/* Query the current value */
szApp   = "OMNIDriver"
szKey   = "HookType"
szValue = SysIni( 'SYSTEM', szApp, szKey )

/* get rid of the terminating null character */
szValue = strip( translate( szValue, ' ', '0'x ) )

if      szValue = "HOOKTYPE_DEBUGOUT" then szValue = "HOOKTYPE_DEBUGOUT"
else if szValue = "HOOKTYPE_PMPRINTF" then szValue = "HOOKTYPE_PMPRINTF"
else if szValue = ""       |  ,
        szValue = "ERROR:" then
   szValue = "<does not exist>"

say "HookType is currently" szValue

exit

usage:

say "Usage: Assert2 [HOOKTYPE_DEBUGOUT | HOOKTYPE_PMPRINTF | DELETE]"
say

signal results
