/* ea.cmd */


parse arg  szArgs

call rxfuncadd 'sysloadfuncs', 'rexxutil', 'sysloadfuncs'
call sysloadfuncs

if length( szArgs ) = 0 then do
  signal usage
end

n = words( szArgs )
select
  when n = 0 then signal usage
  when n = 1 then do
    szFile = szArgs
    say 'needs work: show eas'
    signal done
  end
  otherwise do
    szFile = word( szArgs, n )
    szCommand = ''
    do i = 1 to n-1
      szCommand = szCommand word( szArgs, i )
    end
  end
end


/* parse szCommand */
parse var szCommand szSwitch szEAName'='szEAValue

/* work over the parameters */
szSwitch  = translate( szSwitch  )
szEAName  = strip( szEAName, 'Both', '"' )
szEAName  = strip( szEAName, 'Both', "'" )
szEAValue = strip( szEAValue, 'Both', '"' )
szEAValue = strip( szEAValue, 'Both', "'" )


select
  when translate( szSwitch  ) = '-E' then do
    /* add an EA */
    call SysPutEA szFile, szEAName, szEAValue
  end
  when translate( szSwitch ) = '-D' then do
    /* delete an EA */
    call SysPutEA szFile, szEAName, ""
  end
  otherwise do
    say 'Unknown switch'
    signal usage
  end
end




done:
return





usage:
say "usage:   [-e name=value | -d name | ] file"
say "        -e = Edit new/existing EA value."
say "        -d = Delete exiting EA."
say "        -? = Show this help information."
say " Otherwise = Display all EAs."
say ""
say " To include a blank in the name, value, or file parameter,"
say " surround the string with single or double quote marks."
say ""
say " Examples:"
say "   ea file.dat"
say "   ea -e 'my pie'='apple and cherry' file.dat"
say '   ea -e language="french german" file.dat'
say "   ea -e language=french file.dat"
say "   ea -d language file.dat"
exit
