/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1992 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 source code is provided to you solely for       */
/*    the purpose of assisting you in your development of OS/2 device        */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Developer Connection Device Driver       */
/*    Source Kit for OS/2. This Copyright statement may not be removed.      */
/*                                                                           */
/*****************************************************************************/
// driver.c
// the declaration of driver data


#define INCL_DOS
#define INCL_PM
#include <os2.h>


#define INCL_32
#define INCL_VMANDDI
#include <ddi.h>

#define INCL_GRE_DEVICESURFACE
#define INCL_GREALL
#include <pmddi.h>

// c includes
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <setjmp.h>


#define INCL_GENPLIB_JOURNAL
#define INCL_GENPLIB_MEMORY
#include <genplib.h>




#include "def.h"
#include "driver.h"
#include "funcs.h"



/* The following pragma is for the IBM C Set/2 compiler. For variable
declarations that follow this pragma, the compiler will place those
variables on a data segment named "global." See the mini-driver module
definitions (DEF) file, or see the makefile which writes the DEF file.
Under the SEGMENTS keyword, notice the segment named "global" is shared. */

#pragma data_seg( global )




// a set of forms supported by a printer
// DEVICE_SPECIFIC: the actual size of the form, and the forms supported
// DEVICE_SPECIFIC: the escape sequences to select a form

// 300 dpi forms
FORMINFO aforminfo100[] = {
 // formname       cx,  cy, xl, yb,   yr,   yt,  xpels  ypels flattributes         escape to select it
 {{ "Letter",     216, 279,  6,  5,  210,  274,  2400,  3180, HCAPS_SELECTABLE  }, "\033A"  },
 {{ "Legal",      216, 356,  6,  5,  210,  351,  2400,  4080, HCAPS_SELECTABLE  }, "\033B"  }
};


// 600 dpi forms
FORMINFO aforminfo200[] = {
 // formname       cx,  cy, xl, yb,   yr,   yt,  xpels  ypels flattributes         escape to select it
 {{ "Letter",     216, 279,  6,  5,  210,  274,  4800,  6360, HCAPS_SELECTABLE  }, "\033A"  },
 {{ "Legal",      216, 356,  6,  5,  210,  351,  4800,  8160, HCAPS_SELECTABLE  }, "\033B"  }
};



#define COUNT_FORMS100  sizeof(aforminfo100)/sizeof(FORMINFO)
#define COUNT_FORMS200  sizeof(aforminfo200)/sizeof(FORMINFO)





// DEVICE_SPECIFIC:  array of supported devices
// declare and initialize the array of SUPPORTEDDEVICE structs
// see driver.h for definition of this structure

SUPPORTEDDEVICE aDevice[] =
{

   // 8:1 means 8 bit-per-pel logical (simulated), 1 bit-per-pel physical

   // Via the capabilities array, the driver tells the GRE to emulate 8 bpp for the job.
   // When time to send raster to the printer, the actual printer only has 1 bpp.

   { "300 DPI 8:1 LaserJet",                                // szDeviceName
     COUNT_FORMS100,                                        // cForms
     aforminfo100,                                          // paFormInfo
     300,                                                   // ulXResolution
     300,                                                   // ulYResolution
     1,                                                     // count of color planes
     256,                                                   // count of simulated colors
     8,                                                     // bpp for  simulated colors
     2,                                                     // count of physical colors in device
     1                                                      // bpp for  physical colors in device
   },

   // 1:1 uses less memory than 8:1, but the output is not as nice

   { "300 DPI 1:1 LaserJet",                                // szDeviceName
     COUNT_FORMS100,                                        // cForms
     aforminfo100,                                          // paFormInfo
     300,                                                   // ulXResolution
     300,                                                   // ulYResolution
     1,                                                     // count of color planes
     2,                                                     // count of simulated colors
     1,                                                     // bpp for  simulated colors
     2,                                                     // count of physical colors in device
     1                                                      // bpp for  physical colors in device
   },

   { "600 DPI 8:1 LaserJet",                                // szDeviceName
     COUNT_FORMS200,                                        // cForms
     aforminfo200,                                          // paFormInfo
     600,                                                   // ulXResolution
     600,                                                   // ulYResolution
     1,                                                     // count of color planes
     256,                                                   // count of simulated colors
     8,                                                     // bpp for  simulated colors
     2,                                                     // count of physical colors in device
     1                                                      // bpp for  physical colors in device
   },

   { "600 DPI 1:1 LaserJet",                                // szDeviceName
     COUNT_FORMS200,                                        // cForms
     aforminfo200,                                          // paFormInfo
     600,                                                   // ulXResolution
     600,                                                   // ulYResolution
     1,                                                     // count of color planes
     2,                                                     // count of simulated colors
     1,                                                     // bpp for  simulated colors
     2,                                                     // count of physical colors in device
     1                                                      // bpp for  physical colors in device
   }
};


// compiler can compute the number of supported devices
#define SUPPORTEDDEVICECOUNT   sizeof( aDevice ) / sizeof( SUPPORTEDDEVICE )




// global data; additional values are assigned at run time

GLOBALS globals = {
  (HMODULE) 0,                       // module handle
  0,                                 // gre version
  0,                                 // count of entries in dispatch table
  NULL,                              // pointer to a copy of the dispatch table alloced from SS shared space
  SUPPORTEDDEVICECOUNT,              // count of supported devices
  aDevice,                           // array of information about the devices supported
  NULL,                              // pointer to shared heap
  "\\SEM32\\MDRIVER\\GLOBAL\\SEM",   // DEVICE_SPECIFIC: change the name of this semaphore for derivitive works
  0                                  // count of instances
};




/* Pragma per-process data onto a process-private segment named
"perprocess." Refer to the makefile which writes the module definitions
file for the minidriver. */

#pragma data_seg( perprocess )

PROCDATA         procdata;

