/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1992 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 source code is provided to you solely for       */
/*    the purpose of assisting you in your development of OS/2 device        */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Developer Connection Device Driver       */
/*    Source Kit for OS/2. This Copyright statement may not be removed.      */
/*                                                                           */
/*****************************************************************************/
// assert.c

#define INCL_DOS
#define INCL_PM
#include <os2.h>


#define INCL_32
#define INCL_VMANDDI
#include <ddi.h>

#define INCL_GRE_DEVICESURFACE
#define INCL_GREALL
#include <pmddi.h>

// c includes
#include <stdio.h>
#include <stdarg.h>
#include <stdlib.h>
#include <string.h>
#include <setjmp.h>


#define INCL_GENPLIB_MEMORY
#define INCL_GENPLIB_JOURNAL
#include <genplib.h>




#include "def.h"
#include "driver.h"
#include "funcs.h"



// --------------------------------------------------------------------------------------------------------------------
// called from assert macro

void APIENTRY _assert( BOOL bool, ULONG ulLine, PSZ pszFilename, PSZ pszExpression )
{
  int i;


  if( !bool ) {
    // assertion was not true

    // get last error from PMWIN
    procdata.ulLastError = (ULONG) WinGetLastError( (HAB)0 );

    // write failed assertion onto debug terminal
    DBPRINTF(( "Assertion failed on line %d of file %s\n",  ulLine, pszFilename ));
    DBPRINTF(( "Assertion: '%s'\n", pszExpression ));
    DBPRINTF(( "WinGetLastError: %X\n", procdata.ulLastError ));

    // record the info in the process data block
    strcpy( procdata.szAssert,   pszExpression );
    strcpy( procdata.szFilename, pszFilename   );
    procdata.ulLine = ulLine;

    // make a rude noise
    for( i=4; i; i-- ) {
      switch( i ) {
      case 4:
        DosBeep( 660, 120 );
        break;
      case 2:
        DosBeep( 467, 120 );
        break;
      default:
        DosSleep(  30 );
        break;
      }
    }

    // interrupt execution
    INT3;
  }
}



// --------------------------------------------------------------------------------------------------------------------
// This function sends strings to the debug terminal with printf() functionality.
// To turn on char writes to the debug terminal, add the /Cn to pmdd.sys in config.sys
// where n is the number of the com port to which the debug terminal is attached.
// Typically, DEVICE=C:\OS2\PMDD.SYS  /C1    for com1.

void _Optlink dbprintf (PSZ pszFormat, ...)
{
  CHAR     szTemp[250];
  CHAR     szOutput[250];
  PCHAR    pchSrc;
  PCHAR    pchDest;
  va_list  list;

  // use the va* functions to implement dbprintf with vsprintf
  // see va* function documentation in your ANSI C compiler reference
  va_start (list, pszFormat);
  vsprintf (szTemp, pszFormat, list);
  va_end (list);

  // change /n to /r/n
  memset( szOutput, 0, sizeof( szOutput ));
  pchSrc  = szTemp;
  pchDest = szOutput;

  while( *pchSrc ) {
    switch( *pchSrc ) {
    case '\n':
      *pchDest++ = '\r';
      *pchDest++ = '\n';
      break;
    case '\r':
      break;
    default:
      *pchDest++ = *pchSrc;
      break;
    }
    pchSrc++;
  }

  DebugOutput( szOutput );
}


// --------------------------------------------------------------------------------------------------------------------
// a function to call WinSetErrorInfo.  The advantage of having this wrapper is the ability to set a
// breakpoint on this function.
void APIENTRY SetErrorInfo( ULONG ulSeverity, ULONG ulErrorNumber )
{
  WinSetErrorInfo( MAKEULONG( (USHORT)ulErrorNumber, (USHORT)ulSeverity ), SEI_NOBEEP | SEI_NOPROMPT  );
}

