/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1992 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 source code is provided to you solely for       */
/*    the purpose of assisting you in your development of OS/2 device        */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Developer Connection Device Driver       */
/*    Source Kit for OS/2. This Copyright statement may not be removed.      */
/*                                                                           */
/*****************************************************************************/
/****************************************************************************/
/*                                                                          */
/*      DISCLAIMER OF WARRANTIES.  The following [enclosed] code is         */
/*      sample code created by IBM Corporation. This sample code is not     */
/*      part of any standard or IBM product and is provided to you solely   */
/*      for  the purpose of assisting you in the development of your        */
/*      presentation drivers.  The code is provided "AS IS", without        */
/*      warranty of any kind.  IBM shall not be liable for any damages      */
/*      arising out of your use of the sample code, even if they have been  */
/*      advised of the possibility of such damages.                         */
/*                                                                          */
/****************************************************************************/
/****************************************************************************/
/*                                                                          */
/* FILENAME       : MENU.H                                                  */
/* AUTHOR         : Matthew F. Rutkowski                                    */
/* DATE WRITTEN   : 04-04-94                                                */
/* DESCRIPTION    : This module contains all MACROS, IDs, constants and     */
/*                  data type definitions used by 3-D Menus/Buttons         */
/*                                                                          */
/*--------------------------------------------------------------------------*/
/* Modification/Change log                                                  */
/*--------------------------------------------------------------------------*/
/* TAG - DATE - [COMPANY] - AUTHOR - DESCRIPTION                            */
/*--------------------------------------------------------------------------*/
/*                                                                          */
/*                                                                          */
/****************************************************************************/

#define INCL_GENPLIB_MEMORY
#include <genplib.h>

// PMWIN private ways of drawing 3-D borders.  Does
// not do everything we want for DB_RAISED, but
// we'll use for static 3-D group boxes etc.
//
// NOTE: flags published in "OS/2 Real World Programming"
//
// The private option flags are:
// DB_RAISED       0x0400
// DB_DEPRESSED    0x0800
// DB_TROUGH       0x1000
// DB_FENCE        0x2000
// DB_FIELD        0x4000
// DB_CORNERBORDER 0x8000

// define the ones we use
#ifndef DB_RAISED
#define DB_RAISED       0x0400
#define DB_DEPRESSED    0x0800
#endif

#define MENU_3D_HEAP_LEN      32000

// 3-D Button Size default sizes
#define BUTTON_3D_BORDER           4    // pel size of 3-D border
#define BUTTON_3D_BORDER_2X        8    // 2x size of 3-D border
#define BUTTON_3D_TARGET_PTS       4    // # points for GpiBitBlt
#define BUTTON_TEXT_LEFT_MARGIN    4
#define BUTTON_TEXT_BOTTOM_MARGIN  2
#define BUTTON_GROUP_OFFSET        16

#define BUTTON_ACTION_MEASURE      1
#define BUTTON_ACTION_DRAW         2
#define BUTTON_ACTION_MNEMONIC     3

// 3-D Button Style Creation Flags
#define BS3D_TEXT_INSIDE           0x0001
#define BS3D_TEXT_RIGHT            0x0002
#define BS3D_TEXT_3D               0x0004
#define BS3D_BORDER_3D             0x0008
#define BS3D_BORDER_DEPRESSED      0x0010

// 3-D Button State Flags
#define BUTTON_REALIZED            0x0001

// Flags for use of calculate text functions
#define BUTTON_SIZE_TEXT      0
#define BUTTON_SIZE_CTLTEXT   1
#define BUTTON_SIZE_BITMAP    2

// Menu / Button Structures

typedef struct _TEXT3D{
  ULONG            ulLength;
  PSZ              pszText;
  ULONG            ulTextcx;
  ULONG            ulTextcy;
};

typedef struct _TEXT3D TEXT3D, *PTEXT3D;

typedef struct _BUTTON3D{
  struct _BUTTON3D *pNext;
  ULONG            ulState;
  ULONG            ulStyle;
  ULONG            ulControlID;
  ULONG            ulBitmapID;
  HBITMAP          hbm;
  BITMAPINFOHEADER bmi;
  TEXT3D           NameText;
  TEXT3D           CtrlText;
  CHAR             chMnemonic;
  USHORT           usLevel;
};

typedef struct _BUTTON3D BUTTON3D, *PBUTTON3D, **PPBUTTON3D;
typedef struct _BUTTON3D *HBUTTON3D, **PHBUTTON3D;

typedef struct _MENU3D{
  HMCB       hmcb;
  HAB        hab;
  HMODULE    hmod;
  HDC        hdcMem;
  HPS        hpsMem;
  HWND       hwnd;          // Mnemonic
  CHAR       ch;            // Mnemonic
  ULONG      ulNumEntries;
  PBUTTON3D  pFirstEntry;
  PBUTTON3D  pLastEntry;
  PBUTTON3D  pNextEntry;
};

typedef struct _MENU3D MENU3D, *PMENU3D, **PPMENU3D;
typedef struct _MENU3D *HMENU3D, **PHMENU3D;

BOOL   CalcMaxTextWidth ( HMENU3D, USHORT, PULONG, ULONG );
BOOL   CalcMaxTextHeight( HMENU3D, USHORT, PULONG, ULONG );

BOOL   Create3DMenu( HAB, PHMENU3D, HWND, HMODULE );
BOOL   Destroy3DMenu( HMENU3D );

BOOL   Create3DButton( HMENU3D, PHBUTTON3D, ULONG, ULONG, PSZ, ULONG, USHORT );
BOOL   Destroy3DButton( HMENU3D, HBUTTON3D );

BOOL   Add3DButton( HMENU3D, HBUTTON3D );
//BOOL   Draw3DButton( HMENU3D, POWNERITEM, ULONG, ULONG );

