.****************************************************************************/
.*  Copyright (C) 1993-1995 IBM Corporation                                 */
.*                                                                          */
.*      DISCLAIMER OF WARRANTIES.  The following [enclosed] code is         */
.*      sample code created by IBM Corporation. This sample code is not     */
.*      part of any standard or IBM product and is provided to you solely   */
.*      for  the purpose of assisting you in the development of your        */
.*      presentation drivers.  The code is provided "AS IS", without        */
.*      warranty of any kind.  IBM shall not be liable for any damages      */
.*      arising out of your use of the sample code, even if they have been  */
.*      advised of the possibility of such damages.                         */
.*                                                                          */
.****************************************************************************/
.****************************************************************************/
.* FILE         : FT32.IPF                                                  */
.* AUTHOR       : MFR                                                       */
.* DATE WRITTEN : 12/07/92                                                  */
.* DESCRIPTION  : Help panels for Font Test                                 */
.*                                                                          */
.*--------------------------------------------------------------------------*/
.* Modification/Change log                                                  */
.*--------------------------------------------------------------------------*/
.* TAG - DATE - [COMPANY] - AUTHOR - DESCRIPTION                            */
.*--------------------------------------------------------------------------*/
.*                                                                          */
.* @DBCS    -          - DBCS enabling Tag                                  */
.*                                                                          */
.*       04/02/93 - Matt Rutkowski [IBM] - added panels for Print Dual      */
.*                  Column, Print Character Boxes, and GpiQueryFontMetrics  */
.*                                                                          */
.*       05/17/93 - Matt Rutkowski [IBM] - a) rearranged panels for menus   */
.*                                            in main help                  */
.*                                         b) add help for select color dlg */
.*                                         c) add help for select text      */
.*                                            format dlg                    */
.*                                                                          */
.* @MAXLINE - 11/02/93 - Matt Rutkowski [IBM] - Allows browse and print of  */
.*                       huge files where previously files upto 6000 lines  */
.*                       were only allowed.                                 */
.*                                                                          */
.*                       Added 2 new special keys:                          */
.*                       CTRL-HOME     - Browse top of file                 */
.*                       CTRL-END      - Browse bottom of file              */
.*                                                                          */
.* @74644   - 11/03/93 - Matt Rutkowski [IBM] - New text format option      */
.*                       "Print Line Numbers" added as a suggestion that    */
.*                       was logged as a defect.                            */
.*                                                                          */
.* @TTTTT   - 05/12/94 - Matt Rutkowski [IBM] - Add "Title text" option     */
.*                                                                          */
.* @100698  - 09/28/94 - Matt Rutkowski [IBM] - recalculate char box size   */
.*                       when user selects a new printer resolution.        */
.*                                                                          */
.*            03/16/95 - Matt Rutkowski [IBM] - v1.4 release level          */
.*                                                                          */
.****************************************************************************/
:userdoc.
:title.Font Test 32-bit Printing Utility
.*==========================================================================*/
.* Fontest Main Help  (PANEL_FONTEST_HELP)                                  */
.*==========================================================================*/
:h1 res=2300 name=ID_FONTEST.Font Test Help Topics
:i1 id=mainhelp.Font Test Help Topics
:p.:hp7.Font Test:ehp7.

:p.is a 32-bit PM application that is used to browse and
print :link reftype=fn refid=text.text:elink. files
on local or remote print queues using many formatting options.

:p.Font Test also allows the user to view various
capabilities of the printer attached to a selected print queue
including font and hardcopy (form) information.
.*
:p.:hp7.Command Line Syntax:ehp7.
.*
:p. ft32 [:link reftype=fn refid=drive.drive&colon.:elink.]
[:link reftype=fn refid=directory.directory:elink.]
[:link reftype=fn refid=file.filename:elink.]
 :link reftype=fn refid=cmdh./?:elink. :link reftype=fn refid=cmdp./p:elink.
.*
:p.Click here for usage examples&colon. :link reftype=hd
res=2301.Examples:elink.
.*
:p.:hp7.Font Test Menu Options:ehp7.
:sl compact.
:li.:link reftype=hd res=2100.File Menu:elink.
:li.&sqbul. :link reftype=hd res=2101.Open File...:elink.
:li.&sqbul. :link reftype=hd res=2102.Program Settings... :elink.
:li.&sqbul. :link reftype=hd res=2103.Default Settings:elink.
:li.&sqbul. :link reftype=hd res=2104.Print File...:elink.
:li.
:li.:link reftype=hd res=2150.Query Menu:elink.
:li.&sqbul. :link reftype=hd res=2151.DevQueryCaps...:elink.
:li.&sqbul. :link reftype=hd res=2152.DevQueryHardcopyCaps...:elink.
:li.&sqbul. :link reftype=hd res=2153.GpiQueryFontMetrics...:elink.
:li.&sqbul. :link reftype=hd res=2154.GpiQueryWidthTable...:elink.
:li.&sqbul. :link reftype=hd res=2155.GpiQueryKerningPairs...:elink.
:li.
:li.:link reftype=hd res=2200.Search Menu:elink.
:li.&sqbul. :link reftype=hd res=2201.Search for Text...:elink.
:li.
:li.:link reftype=hd res=2250.Help Menu:elink.
:li.&sqbul. :link reftype=hd res=2251.Help for Help...:elink.
:li.&sqbul. :link reftype=hd res=2252.Help Index...:elink.
:li.&sqbul. :link reftype=hd res=2253.Extended Help...:elink.
:li.&sqbul. :link reftype=hd res=2254.Special Keys...:elink.
:li.&sqbul. :link reftype=hd res=2255.About...:elink.
:esl.
.*
:note.:hp2.Font Test:ehp2. is 32-bit code requiring
:color fc=red.OS/2 Version 2.0:color fc=default. or greater to run.
.*
:note.:link reftype=fn refid=wysiwig.WYSIWIG:elink. output is achieved
when system fonts (of matching resolution) are selected on the
"Font" page of the "Program Settings" notebook.
When device fonts are selected they will be simulated to the screen
using a system Courier font and scaled to the correct point size.
.*
:h1 res=2301 name=PANEL_FONTEST_EXAMPLES.Examples of Starting Font Test
:p.:hp2.1):ehp2. :hp7.File Browse Option:ehp7.
:lm margin=5.
:p.:hp5.Conditions&colon.:ehp5. Font Test is started from the command-line
with only a file name supplied.
.*
:p.:hp5.Results&colon.:ehp5. Font Test will start it's PM window and load
the file name specified and display it in its window.  The file will display
with all previously saved fonts, color, and format information.
.*
:p.:hp5.Examples&colon.:ehp5.
:lm margin=1.
:sl compact.
:li.&sqbul. :hp8.ft32 c&colon.\config.sys:ehp8.
:li.&sqbul. :hp8.ft32 f&colon.\os2\install\install.log:ehp8.
:esl.
.*
:p.:hp2.2):ehp2. :hp7.Command-Line Print Option:ehp7.
:lm margin=5.
:p.:hp5.Conditions&colon.:ehp5. A file name AND the command-line parameter
for printing (either /P,-P, /p or -p) are supplied on the command line.
.*
:p.:hp5.Results&colon.:ehp5. Font Test will NOT start it's PM window, but
will open the file name passed in and print it to the Print Queue last
saved within Font Test's PM window.
.*
:p.:hp5.Examples&colon.:ehp5.
:lm margin=1.
.*
:sl compact.
:li.&sqbul. :hp8.ft32 d&colon.\autoexec.bat /p:ehp8.
:li.&sqbul. :hp8.ft32 -p e&colon.\os2\install\install.log:ehp8.
:esl.
.*
:lm margin=5.
:note.This feature is very useful when FT32.EXE is in your defined
OS/2 path (config.sys) and can be used to print formatted text files
to your printer.
:lm margin=1.
.*
.*===========================================================================*/
.*                        MENU HELPS                                         */
.*---------------------------------------------------------------------------*/
.*  The following section provides help if F1 is pressed when                */
.* a Font Test Menu is highlited.                                            */
.*===========================================================================*/
.*
.*===========================================================================*/
.* "File"  Menu and Menuitems                                                */
.*---------------------------------------------------------------------------*/
.* "File" == PANEL_MENU_FILE                                                 */
.*     |                                                                     */
.*     |--> "Open File..."         == PANEL_MENU_FILE_OPEN                   */
.*     |--> "Program Settings..."  == PANEL_MENU_FILE_SETTINGS               */
.*     |--> "Default Settings"     == PANEL_MENU_FILE_DEFAULTS               */
.*     |--> "Print File..."        == PANEL_MENU_FILE_PRINT                  */
.*                                                                           */
.*===========================================================================*/
.*
:h1 res=2100 name=PANEL_MENU_FILE.File Menu
:i1 id=menufile.File Menu
:p.:hp2.File Menu:ehp2.
:p.Provides access to menu items which let you open a file for browsing,
choose Program Settings and Preferences, and Print the file being browsed.
.*
:p.Menu items for the :hp2.File:ehp2. menu and their actions&colon.
.*
:lm margin=3.
:p.:hp7.:link reftype=hd res=2101.Open File...:elink.:ehp7.
.br
Opens a file and displays it in Font Test's window.
.*
:p.:hp7.:link reftype=hd res=2102.Program Settings...:elink.:ehp7.
.br
Provides access to a notebook containing several pages
of Program Settings and preferences including color, font and
text format.
.*
:p.:hp7.:link reftype=hd res=2103.Default Settings:elink.:ehp7.
.br
Resets all Program Settings to their default values.
.*
:p.:hp7.:link reftype=hd res=2104.Print File...:elink.:ehp7.
.br
Prints the file currently displayed in Font Test's browse window.
:lm margin=1.
.*
.*--------------------------------------------------------------*/
.* Open File...  Menuitem                                       */
.*--------------------------------------------------------------*/
:h1 res=2101 name=PANEL_MENU_FILE_OPEN.MenuItem Open File...
:i1 id=Menuitem.Open File
:p.:hp2.Open File...:ehp2.
:p.Use the :hp2.Open File...:ehp2. menu item to bring up a dialog that
allows the user to navigate to any file accessible on the workstation
and select it so that it can be opened and browsed by Font Test.

.*--------------------------------------------------------------*/
.* Program Settings...  Menuitem                                */
.*--------------------------------------------------------------*/
:h1 res=2102 name=PANEL_MENU_FILE_SETTINGS.Program Settings
:i1 id=itempopt.Program Settings
:p.:hp2.Program Settings...:ehp2.
:p.Use the :hp2.Program Settings:ehp2. menu item to display a
spiral notebook of various program settings that affect the
way Font Test displays and prints text files.

.*--------------------------------------------------------------*/
.* Default Options  Menuitem                                    */
.*--------------------------------------------------------------*/
:h1 res=2103 name=PANEL_MENU_FILE_DEFAULTS.Default Settings
:p.:hp2.Default Settings:ehp2.
:p.Use the :hp2.Default Settings:ehp2. menu item to reset all
permanently saved Program Settings to their defaults.
:p.:hp2.Font Test Defaults:ehp2.&colon.
:dl break=all tsize=9.
.*
:dt.:hp7.Printer:ehp7.
:dd.Uses default print queue as checked in the "Set Default..." option
accessed from any OS/2 Print Queue's context menu.
.*
:dt.:hp7.Font:ehp7.
:dd.Defaults to a scalable "Courier" font at 8 points or closest match.
.*
:dt.:hp7.Colors:ehp7.
:dd.Defaults PM window to Black Text on a White Background.
Defaults Printing to use the color Black Foreground on White Background.
.*
:dt.:hp7.Format:ehp7.
:dd.Defaults all Page Format Options to disabled (off).
.*
:edl.
.*
:p.See the :link reftype=hd res=2500.Program Settings:elink. Notebook
for viewing and changing the options listed above.
.*
.*--------------------------------------------------------------*/
.* Print File... Menuitem                                       */
.*--------------------------------------------------------------*/
:h1 res=2104 name=PANEL_MENU_FILE_PRINT.Print File
:i1 id=itemprint.Print File
:p.:hp2.Print File...:ehp2.
:p.Use the :hp2.Print File...:ehp2. menu item to print your text file.
.**
:p.A dialog will appear to confirm your choice to print and allow you to
review and change the Programs Settings notebook.  The notebook
contains Font, Color and Format that will affect how a text file is
printed.
.*
:p.The printer's :link reftype=hd res=3803.Job Properties:elink. interface
can be accessed from this settings notebook as well.
.*
:p.See the :link reftype=hd res=2500.Program Settings:elink. Notebook
for details on program options.
.*
.*===========================================================================*/
.* "Query" Menu and Menuitems                                                */
.*---------------------------------------------------------------------------*/
.* "Query" == PANEL_MENU_QUERY                                               */
.*     |                                                                     */
.*     |--> "DevQueryCaps..."      == PANEL_MENU_QUERY_CAPS                  */
.*     |--> "DevQueryHardcopyCaps" == PANEL_MENU_QUERY_HCCAPS                */
.*     |--> "GpiQueryFontmetrics"  == PANEL_MENU_QUERY_METRICS               */
.*     |--> "GpiQueryWidthTable"   == PANEL_MENU_QUERY_FNTWDTH               */
.*     |--> "GpiQueryKerningPairs" == PANEL_MENU_QUERY_FNTKERN               */
.*                                                                           */
.*===========================================================================*/
.*
:h1 res=2150 name=PANEL_MENU_QUERY.Query Menu
:i1 id=menuqry.Query Menu
:p.:hp2.Query Menu:ehp2.
:p.Use the :hp2.Query:ehp2. menu to display the names of
OS/2 API calls that query the currently selected print queue for
information about the printer attached.
.*
:p.Selecting any of the APIs listed will cause Font Test to
execute the API call to the output device selected and display
the results in a dialog.
.*
:p.Menu items for the :hp2.Query:ehp2. menu and their actions&colon.
.*
:lm margin=3.
:p.:hp7.:link reftype=hd res=2151.DevQueryCaps...:elink.:ehp7.
.br
An OS/2 API call that queries many different capabilities of
an output device such as resolution and color capabilities.
.*
:p.:hp7.:link reftype=hd res=2152.DevQueryHardcopyCaps...:elink.:ehp7.
.br
An OS/2 API call that queries an output device for information on
what types of output media are available for hardcopy output.
.*
:p.:hp7.:link reftype=hd res=2153.GpiQueryFontMetrics...:elink.:ehp7.
.br
This OS/2 API call is used to query the current printer and display
drivers for the font metrics (meaurements) that would be used when
printing or displaying the current font.
.*
:p.:hp7.:link reftype=hd res=2154.GpiQueryWidthTable..:elink.:ehp7.
.br
An OS/2 API call that queries the current printer for the widths of
all characters that make up the current font. These widths reflect
units that would be used for printing these characters.
.*
:p.:hp7.:link reftype=hd res=2155.GpiQueryKerningPairs..:elink.:ehp7.
.br
An OS/2 API call that queries the current printer for any
kerning pairs defined for the current font. These kerning pairs
reflect adjustments to character widths that are made when certain
characters are printed next to each other.
:lm margin=1.
.*
.*--------------------------------------------------------------*/
.* DevQueryCaps... Menuitem                                     */
.*--------------------------------------------------------------*/
:h1 res=2151 name=PANEL_MENU_QUERY_CAPS.DevQueryCaps
:i1 id=qrycaps.DevQueryCaps
:p.:hp2.DevQueryCaps...:ehp2.
.*
:p.Use the :hp2.DevQueryCaps...:ehp2. menu item to query the
device connected to the selected output queue for it's capabilities.
.*
:p.Examples of some of the many capabilities that can be queried are&colon.
.*
:sl compact.
:li.:hp2.CAPS_DRIVER_VERSION:ehp2. - version of device driver
:li.:hp2.CAPS_TECHNOLOGY:ehp2. - raster, vector, or postscript device
:li.:hp2.CAPS_COLORS:ehp2. - number of colors supported by the device
:esl.
.*
.*--------------------------------------------------------------*/
.* DevQueryHardcopyCaps... Menuitem                             */
.*--------------------------------------------------------------*/
:h1 res=2152 name=PANEL_MENU_QUERY_HCCAPS.DevQueryHardcopyCaps
:i1 id=qryforms.DevQueryHardcopyCaps
:p.:hp2.DevQueryHardcopyCaps...:ehp2.
.*
:p.Use the :hp2.DevQueryHardcopyCaps...:ehp2. menu item to query the
device connected to the selected output queue for it's hardcopy
capabilities (i.e. output media like forms).
.*
:p.A dialog will appear that lists the forms available on your
output device and another listbox displays size information about
the currently selected form.
.*
.*--------------------------------------------------------------*/
.* GpiQueryFontmetrics...  Menuitem                             */
.*--------------------------------------------------------------*/
:h1 res=2153 name=PANEL_MENU_QUERY_METRICS.GpiQueryFontMetrics
:i1 id=qrymetrics.GpiQueryFontMetrics
:p.:hp2.GpiQueryFontMetrics...:ehp2.
.*
:p.Use the :hp2.GpiQueryFontMetrics...:ehp2. menu item to query the
currently realized Font Metrics information being applied to the
file being browsed.
.*
:p.These Font Metrics are the realized Fontmetrics
taking into account any changes made to the font from the Font page of the
Program Settings notebook (e.g. point size scaled, or italic option selected).
.*
:p.The Font Metrics displayed in the Font Page are
really displaying :link reftype=fn refid=designunits.design units:elink.
.*
.*--------------------------------------------------------------*/
.* GpiQueryWidthTable... MenuItem                               */
.*--------------------------------------------------------------*/
:h1 res=2154 name=PANEL_MENU_QUERY_FNTWDTH.GpiQueryWidthTable
:i1 id=qrywdth.GpiQueryWidthTable
:p.:hp2.GpiQueryWidthTable...:ehp2.
:p.Use the :hp2.GpiQueryWidthTable...:ehp2. menu item to query the
current font's character width table.  These widths reflect
the individual space each character in the font's character set
would occupy.
:p.These values reflect any changes to the font's point size or
font attributes.
.*
.*--------------------------------------------------------------*/
.* GpiQueryKerningPairs... Menuitem                             */
.*--------------------------------------------------------------*/
:h1 res=2155 name=PANEL_MENU_QUERY_FNTKERN.GpiQueryKerningPairs
:i1 id=qrykern.GpiQueryKerningPairs
:p.:hp2.GpiQueryKerningPairs...:ehp2.
:p.Use the :hp2.GpiQueryKerningPairs...:ehp2. menu item to query the
current font's kerning pair table.  This table shows adjustments
made to characters when they appear next to another character when
displayed or printed to make the combination more visually appealing.
.*
.*===========================================================================*/
.* "Search" Menu and Menuitems                                               */
.*---------------------------------------------------------------------------*/
.* "Search" == PANEL_MENU_SEARCH                                             */
.*     |                                                                     */
.*     |--> "Search for Text..."   == PANEL_MENU_SEARCH_TEXT                 */
.*                                                                           */
.*===========================================================================*/
.*
:h1 res=2200 name=PANEL_MENU_SEARCH.Search Menu
:i1 id=menusrch.Search Menu
:p.:hp2.Search Options Menu:ehp2.
:p.Use the :hp2.Search:ehp2. menu to display
a list of text search menuitems
.*
:p.Menu items for the :hp2.Search:ehp2. menu and their actions&colon.
.*
:lm margin=3.
:p.:hp7.:link reftype=hd res=2201.Search for Text...:elink.:ehp7.
.br
Search for a text string in the currently selected text file.
The default search is case-insensitive and changeable to case-sensitive.
:lm margin=1.
.*
.*------------------------------------*/
.* Search For Text... Menuitem        */
.*------------------------------------*/
:h1 res=2201 name=PANEL_MENU_SEARCH_TEXT.Search for Text
:i1 id=srchtxt.Search for text
:p.:hp2.Search for text...:ehp2.
:p.Use the :hp2.Search for Text...:ehp2. menu item to display a dialog
that allows the user to enter a search string to scan for
in the currently opened file.
.*
:p.If the search string is found, the text line it is found on will
be advanced to the top line in Font Test's window.
.*
:p.Check "Case Sensitive" to force search to match exactly upper
and lower-case letters, otherwise search will ignore case.
.*
:p.Use Ctrl-S "hot key" to bring up search dialog then use
Ctrl-F "hot key" to find next occurrence of same search string.
.*
.*===========================================================================*/
.* "Help"  Menu and Menuitems                                                */
.*---------------------------------------------------------------------------*/
.* "Help"  == PANEL_MENU_HELP                                                */
.*     |                                                                     */
.*     |--> "Using Help..."        == PANEL_MENU_USING_HELP                  */
.*     |--> "Help Index..."        == PANEL_MENU_HELP_INDEX                  */
.*     |--> "Extended Help..."     == PANEL_MENU_EXT_HELP                    */
.*     |--> "Keys Help..."         == PANEL_MENU_KEYS_HELP                   */
.*     |--> "About..."             == PANEL_MENU_HELP_ABOUT                  */
.*                                                                           */
.*===========================================================================*/
.*
:h1 res=2250 name=PANEL_MENU_HELP.Help Menu
:i1 id=menuhelp.Help Menu
:p.:hp2.Help Menu:ehp2.
:p.The following Menu Items are accessed from the :hp2.Help Menu:ehp2..
.*
:p.Menu items for the :hp2.Help:ehp2. menu and their actions&colon.
.*
:p.:hp7.:link reftype=hd res=2251.Using Help...:elink.:ehp7.
.br
Tells what to do to access help in this program.
.*
:p.:hp7.:link reftype=hd res=2252.Help Index...:elink.:ehp7.
.br
Provides an index of all available help topics in Font Test.
.*
:p.:hp7.:link reftype=hd res=2253.Extended Help...:elink.:ehp7.
.br
Provides step-by-step instructions on how to use Font Test.
.*
:p.:hp7.:link reftype=hd res=2254.Keys Help...:elink.:ehp7.
.br
Displays a list of special keys and key combinations in Font Test.
.*
:p.:hp7.:link reftype=hd res=2255.About...:elink.:ehp7.
.br
Displays program description, version, program icon, and author.
.*
.*------------------------------------*/
.* Using Help... Menuitem             */
.*------------------------------------*/
:h1 res=2251 name=PANEL_MENU_USING_HELP.Using Help
:p.:hp2.Using Help...:ehp2.
:p.Use the :hp2.Using Help...:ehp2. menu item to explain how to
obtain help while using Font Test.
.*
.*------------------------------------*/
.* Help Index... Menuitem             */
.*------------------------------------*/
:h1 res=2252 name=PANEL_MENU_HELP_INDEX.Help Index
:p.:hp2.Help Index...:ehp2.
:p.Use the :hp2.Help Index...:ehp2. menu item to show a list of all
available help topics.
.*
.*------------------------------------*/
.* Extended Help... Menuitem          */
.*------------------------------------*/
:h1 res=2253 name=PANEL_MENU_EXT_HELP.Extended Help
:p.:hp2.Extended Help...:ehp2.
:p.Use the :hp2.Extended Help...:ehp2. menu item to show the main
help panel for using Font Test.
.*
.*------------------------------------*/
.* Keys Help... Menuitem              */
.*------------------------------------*/
:h1 res=2254 name=PANEL_MENU_KEYS_HELP.Keys Help
:p.:hp2.Keys Help...:ehp2.
:p.Use the :hp2.Keys Help...:ehp2. menu item to show all keys
that have special functions under Font Test.
.*
.*------------------------------------*/
.* About... Menuitem                  */
.*------------------------------------*/
:h1 res=2255 name=PANEL_MENU_HELP_ABOUT.About Font Test
:p.:hp2.About...:ehp2.
:p.Use the :hp2.About...:ehp2. menu item to show information
about Font Test including author, icon, abstract, and copyright.
.*
.*===========================================================================*/
.* "Open File" dialog                                                        */
.*---------------------------------------------------------------------------*/
.*  "Help"             ==  PANEL_DLG_FILE                                    */
.*  "Open"             ==  PANEL_DLG_FILE_OPEN                               */
.*  "Cancel"           ==  PANEL_DLG_FILE_CANCEL                             */
.*  "Current Filename" ==  PANEL_DLG_FILE_NAME                               */
.*                                                                           */
.*===========================================================================*/
.*
.*------------------------------------*/
.* "Open File" Dialog                 */
.*------------------------------------*/
:h1 res=2400 name=PANEL_DLG_FILE.Open File Dialog
:i1 id=dlgfile.Open File Dialog
:p.:hp2.Open File Dialog:ehp2.
.*
:p.The Open File Dialog provides a standard way of opening any text file
that exists on or is accessible from your workstation.
.*
:p.Controls available on the :hp2.Open File:ehp2. dialog&colon.
:sl compact.
:li.&sqbul. :link reftype=hd res=2401.Open Filename:elink. entryfield
:li.&sqbul. :link reftype=hd res=2402.Open:elink. button
:li.&sqbul. :link reftype=hd res=2403.Cancel:elink. button
:esl.
.*
:p.:hp7.Step-by-step&colon.:ehp7. :hp3.Opening a file:ehp3.
.*
:ol compact.
:li.Select the drive containing the file you want to open from the
:hp2.:link reftype=fn refid=drive.Drive:elink.:ehp2. list.
:li.Select the directory containing the file you want to open from the
:hp2.:link reftype=fn refid=directory.Directory:elink.:ehp2. list.
:li.Select the file name of the file you want to open from the
:hp2.:link reftype=fn refid=file.File:elink.:ehp2. list.
:li.Select the :hp2.Open:ehp2. button to open the file.
:eol.
.*
:p.:hp8.<or>:ehp8.
.*
:ol compact.
:li.Enter the drive, path and filename of the file you want Font Test to open
into the :hp2.Open Filename:ehp2. entryfield.
:li.Select the :hp2.Open:ehp2. button to open the file.
:eol.
.*
.*------------------------------------*/
.* "Current Filename" entryfield      */
.*------------------------------------*/
:h1 res=2401 name=PANEL_DLG_FILE_NAME.Open Filename
:p.:hp2.Open Filename:ehp2.
:p.Entryfield containing the complete filename of a file that
has been or will be opened by Font Test.
.*
.*------------------------------------*/
.* "Open" button                      */
.*------------------------------------*/
:h1 res=2402 name=PANEL_DLG_FILE_OPEN.Open
:p.:hp2.Open:ehp2.
:p.Select the Open pushbutton to confirm the selection of a file
to be opened.
.*
.*------------------------------------*/
.* "Cancel" button                    */
.*------------------------------------*/
:h1 res=2403 name=PANEL_DLG_FILE_CANCEL.Cancel
:p.:hp2.Cancel:ehp2.
:p.Select the Cancel pushbutton to exit the Open File dialog
without selecting a file to load into Font Test.
.*
.*===========================================================================*/
.* "Program Settings" Notebook dialog                                        */
.*---------------------------------------------------------------------------*/
.*  "Help"             ==  PANEL_DLG_SETTINGS                                */
.*  "OK"               ==  PANEL_DLG_SETTINGS_OK                             */
.*  "Save"             ==  PANEL_DLG_SETTINGS_SAVE                           */
.*  "Cancel"           ==  PANEL_DLG_SETTINGS_CANCEL                         */
.*                                                                           */
.*===========================================================================*/
.*
.*------------------------------------*/
.* "Program Settings" dialog          */
.*------------------------------------*/
:h1 res=2500 name=PANEL_DLG_SETTINGS.Program Settings
:i1 id=dlgsettings.Program Settings
:p.:hp2.Program Settings:ehp2.
.*
:p.The Program Settings dialog contains a notebook whose pages
represent all changeable program settings and preferences.
.*
:p.Click on a notebook page name to find out about options on that page&colon.
:sl compact.
:li.&sqbul. :link reftype=hd res=2600.Printer:elink. page
:li.&sqbul. :link reftype=hd res=2700.Font:elink. page
:li.&sqbul. :link reftype=hd res=2800.Colors:elink. page
:li.&sqbul. :link reftype=hd res=2900.Page Format:elink. page
:esl.
.*
:p.Controls available on the :hp2.Program Settings:ehp2. dialog&colon.
:sl compact.
:li.&sqbul. :link reftype=hd res=2501.OK:elink.
:li.&sqbul. :link reftype=hd res=2502.Save:elink.
:li.&sqbul. :link reftype=hd res=2503.Cancel:elink.
:esl.
.*
.*------------------------------------*/
.* "OK" button                        */
.*------------------------------------*/
:h1 res=2501 name=PANEL_DLG_SETTING_OK.OK
:p.:hp2.OK:ehp2.
:p.Select the OK pushbutton to close the notebook and save
any changes made to any page in the notebook.  All changes
will be applied to the program after the notebook disappears.
:p.The :hp2.OK:ehp2. pushbutton differs from
the :hp2.Save:ehp2. pushbutton because changes made
are lost when the program is shut down.
.*
.*------------------------------------*/
.* "Save" button                      */
.*------------------------------------*/
:h1 res=2502 name=PANEL_DLG_SETTINGS_SAVE.Save
:p.:hp2.Save:ehp2.
:p.Select the Save pushbutton to close the notebook and save
all changes made to any page in the notebook.  All changes
will be applied to the program after the notebook disappears.
:p.The :hp2.Save:ehp2. pushbutton differs from
the :hp2.OK:ehp2. pushbutton because changes are saved and
remembered even after the program is shutdown.
.*
.*------------------------------------*/
.* "Cancel" button                    */
.*------------------------------------*/
:h1 res=2503 name=PANEL_DLG_SETTINGS_CANCEL.Cancel
:p.:hp2.Cancel:ehp2.
:p.Select the Cancel pushbutton to close the notebook and
discard any changes made to any of the notebook pages.
The program settings for all pages are restored to what they
were before the notebook was brought up.
.*
.*===========================================================================*/
.* "Printer" Notebook page dialog                                            */
.*---------------------------------------------------------------------------*/
.*  "Help"                     ==  PANEL_DLG_QUEUE                           */
.*  "Available Print Queues"   ==  PANEL_DLG_QUEUE_LIST                      */
.*  "Job Properties"           ==  PANEL_DLG_QUEUE_JOB_PROP                  */
.*  "Other Destination"        ==  PANEL_DLG_QUEUE_OTHER                     */
.*  "Printer Driver"           ==  PANEL_DLG_QUEUE_DRIVER                    */
.*  "Printer Device"           ==  PANEL_DLG_QUEUE_DEVICE                    */
.*                                                                           */
.*===========================================================================*/
.*
:h1 res=2600 name=PANEL_DLG_QUEUE.Printer Notebook Page
:i1 id=dlgqueue.Printer Notebook Page
:p.:hp2.Printer Notebook Page:ehp2.
:p.The Printer notebook page provides a list of all available Print
Queues on your workstation.  By selecting a Print Queue, you are
really choosing a printer driver and model represented by that queue.
This printer driver and model selected will be used as the destination
for printouts from the program.
.*
:p.Controls available on the :hp2.Printer:ehp2. page&colon.
:sl compact.
:li.&sqbul. :link reftype=hd res=2601.Available Print Queues:elink. list
:li.&sqbul. :link reftype=hd res=2602.Job Properties...:elink. button
:li.&sqbul. :link reftype=hd res=2603.Other Destination...:elink. button
:li.&sqbul. :link reftype=hd res=2604.Attached Printer Driver:elink. field
:li.&sqbul. :link reftype=hd res=2605.Attached Device Name:elink. field
:esl.
.*
:p.:hp7.Step-by-step&colon.:ehp7. :hp3.Choosing a Print Queue:ehp3.
:ol compact.
:li.Select a print queue name from the :hp2.Available Print Queues:ehp2. list.
:li.The printer (driver and model) for the queue will be shown on the page.
:li.Once the desired printer appears, press the OK button below the notebook.
:eol.
.*
.*------------------------------------*/
.* "Available Print Queues" list      */
.*------------------------------------*/
:h1 res=2601 name=PANEL_DLG_QUEUE_LIST.Available Print Queues
:p.:hp2.Available Print Queues:ehp2.
.*
:p.A list containing all Print Queues found on or attached
to your workstation (local or network accessible).
.*
:p.Print Queues are set up with a printer driver, printer model and
an output port (e.g. LPT1, COM2, or file).  The printer driver
(assigned to a print queue) can be queried for the printer model's
abilities (e.g. forms, fonts, or color) and used to format a program's
printouts for that model.
.*
:p.Print Queues are used as a "holding area" for printouts
from any OS/2, DOS, or Windows application running under OS/2.
Using OS/2's multitasking, these applications run and can print
at the same time.  The Print Queue's holding area ensures only
one printout at-a-time actually gets sent out the port to the
printer.  Otherwise, the printer could get confused and mix
printouts together or print garbage.
.*
:p.When a Print Queue is selected the :hp2.Attached Printer Driver:ehp2. and
:hp2.Attached Device Name:ehp2. are shown on the page representing the
printer driver and model for that queue.
.*
:note.Some queues available for output may not be listed here.
See :link reftype=hd res=2603.Other Destination:elink. button
on this dialog.
.*
.*------------------------------------*/
.* "Job Properties" button            */
.*------------------------------------*/
:h1 res=2602 name=PANEL_DLG_QUEUE_JOB_PROP.Job Properties
:p.:hp2.Job Properties...:ehp2.
.*
:p.This button causes the :hp2.Attached Printer Driver:ehp2. for the
currently selected Print Queue to display a dialog of
changeable job options for the :hp2.Attached Device Name:ehp2. (or
printer model).
.*
:p.Any changes made to a printer model's job property dialog will be
saved by Font Test along with other Program Settings in the
notebook and applied to any printouts from Font Test.
.*
:p.The OS/2 API for causing Job Properties to be displayed
is DevPostDeviceModes.
:p.For more information on Job Properties click
here&colon. :link reftype=hd res=3803.What are Job Properties:elink
.*
:note.Changing Job Properties in Font Test has no effect on
Job Properties used for any other program.
.*
.*------------------------------------*/
.* "Other Destination" button         */
.*------------------------------------*/
:h1 res=2603 name=PANEL_DLG_QUEUE_OTHER.Other Destination
:p.:hp2.Other Destination...:ehp2.
:p.Some network attached Print Queues available for output
are not always listed.  This is because some networks may
not have notified OS/2 that an attached resource (server)
has an output queue.
:p.To select such a queue, hit the :hp2.Other Destination...:ehp2.
pushbutton.
.*
:note.This option is typically used for Novell network output
queues.  (i.e. You have an OS/2 workstation on a Novell netork (LAN)
and the Novell network provides access to some
:link reftype=fn refid=outputdevice.output device:elink.
.*
.*------------------------------------*/
.* "Printer Driver" field             */
.*------------------------------------*/
:h1 res=2604 name=PANEL_DLG_QUEUE_DRIVER.Attached Printer Driver
:p.:hp2.Attached Printer Driver:ehp2.
:p.The Attached Printer Driver field shows the name of the printer driver
installed in the Print Queue selected from the :hp2.Available
Print Queues:ehp2. list.
.*
:note.The attached Printer Driver need not just drive a printer.
A printer driver can be used to format output for many types of
output devices (e.g. FAX, Plotter, Files etc.).
just a printer.
.*
.*------------------------------------*/
.* "Printer Device" field             */
.*------------------------------------*/
:h1 res=2605 name=PANEL_DLG_QUEUE_DEVICE.Attached Device Name
:p.:hp2.Attached Device Name:ehp2.
:p.The Attached Device Name field shows the name of the printer device
support is selected for the printer driver installed in the
Print Queue selected from the :hp2.Available Print Queues:ehp2. list.
.*
:note.The attached device can be any one of many output devices, not
just a printer.
.*
.*===========================================================================*/
.* "Other Destination" dialog                                                */
.*---------------------------------------------------------------------------*/
.*  "Help"             ==  PANEL_DLG_OTHER                                   */
.*  "Open"             ==  PANEL_DLG_OTHER_NAME                              */
.*  "OK"               ==  PANEL_DLG_OTHER_OK                                */
.*  "Cancel"           ==  PANEL_DLG_OTHER_CANCEL                            */
.*                                                                           */
.*===========================================================================*/
.*
.*------------------------------------*/
.* "Other Destination..." dialog      */
.*------------------------------------*/
:h1 res=2650 name=PANEL_DLG_OTHER.Other Print Destinations
:i1 id=dlgother.Other Print Destinations
:p.:hp2.Other Print Destinations:ehp2.
.*
:p.The Other Print Destinations dialog provides a way of typing in the
name of a print queue, print server, or print destination that may be
available via some network connection, but OS/2 is not aware of it's
presence since it did not properly notify this workstation.
.*
:note.This option is typically used for Novell network output
queues.  (i.e. You have an OS/2 workstation on a Novell netork (LAN)
and the Novell network provides access to some
:link reftype=fn refid=outputdevice.output device:elink.
.*
.*------------------------------------*/
.* "Unlisted Destination" field       */
.*------------------------------------*/
:h1 res=2651 name=PANEL_DLG_OTHER_NAME.Unlisted Destination
:i1 id=othername.Unlisted Destination
:p.:hp2.Unlisted Destination:ehp2.
:p.Enter the name of the device that can be opened by the OS/2
Print Spooler for sending a printout.
.*
.*------------------------------------*/
* "OK" button                         */
.*------------------------------------*/
:h1 res=2652 name=PANEL_DLG_OTHER_OK.Other Destination OK
:i1 id=otherok.Other Destination OK
:p.:hp2.OK:ehp2.
:p.Press this button if satisfied with the "Unlisted Destination"
entered in the entryfield on this dialog.
.*
.*------------------------------------*/
.* "Cancel" button                    */
.*------------------------------------*/
:h1 res=2653 name=PANEL_DLG_OTHER_CANCEL.Other Destination Cancel
:i1 id=otherccl.Other Destination Cancel
:p.:hp2.Cancel:ehp2.
:p.Press this button if you do not wish to fill in or are not sure of
the name for an "Unlisted Destination" for printing.
.*
.*===========================================================================*/
.* "Font" Notebook page dialog                                               */
.*---------------------------------------------------------------------------*/
.*  "Help"                     ==  PANEL_DLG_FONT                            */
.*  "Available Fonts"          ==  PANEL_DLG_FONT_LIST                       */
.*  "Select Attributes"        ==  PANEL_DLG_FONT_ATTRIB                     */
.*   > "Italic"                ==  PANEL_DLG_FONT_ITALIC                     */
.*   > "Underline"             ==  PANEL_DLG_FONT_UNDERLINE                  */
.*   > "Strikeout"             ==  PANEL_DLG_FONT_STRIKEOUT                  */
.*   > "Bold"                  ==  PANEL_DLG_FONT_BOLD                       */
.*  "Designer Font Metrics"    ==  PANEL_DLG_FONT_METRICS                    */
.*  "Point Size"               ==  PANEL_DLG_FONT_POINTSIZE                  */
.*   > "Scalable Font"         ==  PANEL_DLG_FONT_SCALABLE                   */
.*   > "Fixed Font"            ==  PANEL_DLG_FONT_FIXED                      */
.*  "Font Type"                ==  PANEL_DLG_FONT_TYPE                       */
.*  "Font Sample Text"         ==  PANEL_DLG_FONT_SAMPLE                     */
.*===========================================================================*/
.*
.*------------------------------------*/
.* "Font" Notebook page               */
.*------------------------------------*/
:h1 res=2700 name=PANEL_DLG_FONT.Font Notebook Page
:i1 id=dlgfont.Font Notebook Page
:p.:hp2.Font Notebook Page:ehp2.
:p.The Font notebook page provides a list of all available fonts
on your workstation (System and Display Fonts) and any printer fonts
available for the currently selected print queue's printer.
.*
:p.Changing the font, attributes, or point size from this panel,
causes the :hp2.Font Sample:ehp2. window to update it's sample text to
reflect how the font will look if chosen.
.*
:warning text='Be Careful:'.Select fonts whose resolution matches your
printer's resolution or fonts will print out the incorrect size.
:ewarning.
.*
:p.Controls available on the :hp2.Font:ehp2. page&colon.
:sl compact.
:li.&sqbul. :link reftype=hd res=2701.Available Fonts:elink. list
:li.&sqbul. :link reftype=hd res=2702.Select Attributes:elink. checkboxes
:li.&sqbul. :link reftype=hd res=2707.Designer Font Metrics:elink. listbox
:li.&sqbul. :link reftype=hd res=2708.Point Size:elink. spinbutton
:li.&sqbul. :link reftype=hd res=2712.Font Sample Text:elink. window
:li.&sqbul. :link reftype=hd res=2711.Font Type:elink. window
:esl.
.*
:note.When a new font is selected it's
:link reftype=fn refid=nominal.nominal:elink. point
size is shown in the point size spin button.
.*
:note.If a device font is chosen a Courier (8 pt) font will be
used for simulating the font in Font Test's file display window.
.*
:p.:hp7.Step-by-step&colon.:ehp7. :hp3.Choosing a Font:ehp3.
:ol compact.
:li.Select a font name from the :hp2.Available Fonts:ehp2. list.
:li.The :hp2.Font Sample:ehp2. will display a sample of the font you chose.
:li.Once the desired font is found, press the OK button below the notebook.
:eol.
.*
.*------------------------------------*/
.* "Available Fonts" list             */
.*------------------------------------*/
:h1 res=2701 name=PANEL_DLG_FONT_LIST.Available Fonts
:p.:hp2.Available Fonts:ehp2.
:p.Lists all fonts available from OS/2 and on the intended printer
or output device.
:p.You may select one of the fonts displayed to use to format
a text file for output.
:p.Once a font is selected, it's font metrics are displayed and
:link reftype=fn refid=nominal.nominal:elink. point size, font
attributes, and other characteristics are updated.
.*
.*------------------------------------*/
.* "Select Attributes" group          */
.*------------------------------------*/
:h1 res=2702 name=PANEL_DLG_FONT_ATTRIB.Select Attributes
:p.:hp2.Select Attributes:ehp2.
:p.You may select any combination of attribute checkboxes to
apply to the currently selected font.
:p.The following attributes are available&colon.
:sl compact.
:li.&sqbul. :link reftype=hd res=2703.Italic:elink. checkbox
:li.&sqbul. :link reftype=hd res=2704.Underline:elink. checkbox
:li.&sqbul. :link reftype=hd res=2705.Strikeout:elink. checkbox
:li.&sqbul. :link reftype=hd res=2706.Bold:elink. checkbox
:esl.
.*
.*------------------------------------*/
.* "Italic" checkbox                  */
.*------------------------------------*/
:h1 res=2703 name=PANEL_DLG_FONT_ITALIC.Italic Option
:i1 id=italic.Italic Option
:p.:hp2.Italic Option:ehp2.
:p.Selecting this option causes the currently selected font to
become italicized. All characters drawn with this option will
appear slanted.
.*
.*------------------------------------*/
.* "Underline" checkbox               */
.*------------------------------------*/
:h1 res=2704 name=PANEL_DLG_FONT_UNDERLINE.Underline Option
:i1 id=under.Underline Option
:p.:hp2.Underline Option:ehp2.
:p.Selecting this option causes the currently selected font to
be underlined. A line will be drawn under all characters in the
font.
.*
.*------------------------------------*/
.* "Strikeout" checkbox               */
.*------------------------------------*/
:h1 res=2705 name=PANEL_DLG_FONT_STRIKEOUT.Strikeout Option
:i1 id=strike.Strikeout Option
:p.:hp2.Strikeout Option:ehp2.
:p.Selecting this option causes the currently selected font to
be struck out with a line. A line will be drawn through all characters
in the font.
.*
.*------------------------------------*/
.* "Bold" checkbox                    */
.*------------------------------------*/
:h1 res=2706 name=PANEL_DLG_FONT_BOLD.Bold Option
:i1 id=bold.Bold Option
:p.:hp2.Bold Option:ehp2.
:p.Selecting this option causes the currently selected font to
appear bold. All character printed with the font and the bold option
will appear thicker and darker.
.*
:p.NOTE: Bolding some fonts causes them to become wider.
.*
.*------------------------------------*/
.* "Designer Font Metrics" list       */
.*------------------------------------*/
:h1 res=2707 name=PANEL_DLG_FONT_METRICS.Designer Font Metrics
:p.:hp2.Designer Font Metrics:ehp2.
:p.Measures and attributes that describe the currently selected font.
:p.The font metrics displayed here on the "Font" page
are displaying all values
in :link reftype=fn refid=designunits.design units:elink. for the
selected font.
.*
.*------------------------------------*/
.* "Pointsize" spinbutton             */
.*------------------------------------*/
:h1 res=2708 name=PANEL_DLG_FONT_POINTSIZE.Point Size
:p.:hp2.Point Size:ehp2.
:p.Shows the current point size of the font which can be of two
type&colon.
:sl compact.
:li.&sqbul. :link reftype=hd res=2709.Scalable Point Size:elink.
:li.&sqbul. :link reftype=hd res=2710.Fixed Point Size:elink.
:esl.
:p.The spinbutton value can be changed for :hp1.scalable:ehp1. fonts,
but not for :hp1.fixed:ehp1. fonts.
.*
:note.If a :hp1.fixed:ehp1. point size (bitmap) font is used, the
resolution of the font must match the resolution of the intended
output device or the font will appear to come out the incorrect
size (i.e. display and printer resolution must match).
.*
.*------------------------------------*/
.* "Scalable" Point Size              */
.*------------------------------------*/
:h1 res=2709 name=PANEL_DLG_FONT_SCALABLE.Scalable Point Size
:p.:hp7.Scalable Point Size:ehp7.
:p.This message appears when the selected font that can be scaled (point
size can be changed) between an upper an lower limit determined by the
font's designer (often called an "outline font").
:p.The font can be scaled because the system knows every line and curve
needed to draw every character of the font and can easily scale these
lines and curves to make them larger or smaller.
:note.Scalable fonts can easily be resized for different resolution devices
so that they appear the same on the display and the printer.
.*
.*------------------------------------*/
.* "Fixed" Point Size                 */
.*------------------------------------*/
:h1 res=2710 name=PANEL_DLG_FONT_FIXED.Fixed Point Size
:p.:hp7.Fixed Point Size:ehp7.
:p.This message appears when the selected font can not be scaled since
it is made up of bitmaps of each character in the font and designed
for a specific resolution (often called a "bitmap font").
:note.Fixed point points are often designed for use with the current
display driver at a certain resolution.  When printed these fonts can
not be scaled to match the resolution of the printer and will appear
to be the incorrect size (often much smaller).
.*
.*------------------------------------*/
.* "Font Type" field                  */
.*------------------------------------*/
:h1 res=2711 name=PANEL_DLG_FONT_TYPE.Current Font Type
:p.:hp2.Current Font Type:ehp2.
:p.Describes where the font is being provided from.
.*
:p.:hp7.System Font (lMatch >= 0):ehp7.
:p.System Fonts are those installed under OS/2 and are available
to all applications in OS/2.  OS/2 ships with a set of fonts and
other system fonts can be installed using the Font Palette.
.*
:p.:hp7.Device Font (lMatch < 0):ehp7.
:p.Device fonts are those fonts that typically are built into the
hardware or software of an output device.  Device fonts are not as
readily available to applications; therefore, applications usually
attempt to approximate what the font will look like when it is
output to the device.
.*
:p.The benefit of device fonts is that the
device knows a lot about the font and can output device fonts
faster and with higher quality than system fonts.
.*
.*------------------------------------*/
.* "Font Sample Text" window          */
.*------------------------------------*/
:h1 res=2712 name=PANEL_DLG_FONT_SAMPLE.Font Sample Text
:p.:hp2.Font Sample Text:ehp2.
:p.The Font Sample Text window on the Font page shows a preview
of what the currently selected font will look like when used
to display a text file in Font Test.
:p.Options applied to the text will also be reflected in the
sample text window (i.e. Italic, Bold etc.).
.*
.*===========================================================================*/
.* "Colors" notebook page dialog                                             */
.*---------------------------------------------------------------------------*/
.*  "Help"                     ==  PANEL_DLG_COLORS                          */
.*  "Select Item"              ==  PANEL_DLG_COLORS_ITEMS                    */
.*  "Select Item's Color"      ==  PANEL_DLG_COLORS_PALETTE                  */
.*===========================================================================*/
:h1 res=2800 name=PANEL_DLG_COLORS.Colors Notebook Page
:i1 id=dlgcolor.Colors Notebook Page
:p.:hp2.Colors Notebook Page:ehp2.
:p.This page allows you to choose what colors you would
like to have Font Test use when printing and displaying text files.
.*
:p.Controls available on the :hp2.Colors:ehp2. page&colon.
:sl compact.
:li.&sqbul. :link reftype=hd res=2801.Select Item:elink. list
:li.&sqbul. :link reftype=hd res=2802.Select Item's Color:elink. color palette
:esl.
.*
:p.:hp7.Step-by-step&colon.:ehp7. :hp3.Changing an Items' Colors:ehp3.
:ol.
:li.Select the word "Window Text" from the :hp2.Select Item:ehp2. list.
:li.The :hp2.Select Item's Color:ehp2. color palette will show the current
color for "Window Text".
:li.Select the color :hp2.Yellow:ehp2. from
the :hp2.Select Item's Color:ehp2. color palette.
:li.Select the word "Window Background" from the :hp2.Select Item:ehp2. list.
:li.The :hp2.Select Item's Color:ehp2. color palette will show the current
color for "Window Background".
:li.Select the color :hp2.Blue:ehp2. from
the :hp2.Select Item's Color:ehp2. color palette.
:li.press the OK button below the notebook.
:eol.
.*
:p.:hp7.Example&colon.Changing Items' Colors:ehp7.
:sl compact.
:li.The default Window Text color was&colon.
:li.:color fc=black. Black text on a white background:color fc=default.
:li.
:li.We have now changed it to be&colon.
:li.:color fc=yellow bc=blue. Yellow text on a blue background:color fc=default bc=default.
:esl.
.*
.*------------------------------------*/
.* "Select Item"                      */
.*------------------------------------*/
:h1 res=2801 name=PANEL_DLG_COLORS_ITEMS.Select Item
:p.:hp2.Select Item:ehp2.
:p.This listbox presents all the items in Font Test whose colors
are changeable.
:p.These items include&colon.
:sl compact.
:li.:hp2.Window Text:ehp2. - color of browse window's text
:li.
:li.:hp2.Window Background:ehp2. - color of browse window's background
:li.
:li.:hp2.Printed Text:ehp2. - color of printed text output
:li.
:li.:hp2.Printed Background:ehp2. - color to fill background of paper
(currently not implemented)
:li.
:li.:hp2.Text Border:ehp2. - color of border that is drawn around each page
of text output
:li.
:li.:hp2.Trailer Information:ehp2. - color of filename, page numbers, date
and time
:li.
:li.:hp2.Title Text:ehp2. - color of printed page title
:esl.
.*
:p.An example of a color change&colon.
:sl compact.
:li.The default Window Text color is&colon.
:li.:color fc=black.   Black text on a white background:color fc=default.
:li.
:li.Another possible setting would be&colon.
:li.:color fc=yellow bc=blue.   Yellow text on a blue background:color fc=default bc=default.
:esl.
.*
.*------------------------------------*/
.* "Select Item's Color"              */
.*------------------------------------*/
:h1 res=2802 name=PANEL_DLG_COLORS_PALETTE.Select Item's Color
:p.:hp2.Select Item's Color:ehp2.
:p.Select the color form the color palette that you want the selected
item, in the :hp2.Select Item:ehp2. list to.
:p.The colors represented in this area represent the 16
predefined OS/2 colors that are standardly used by many applications.
.*
.*===========================================================================*/
.* "Page Format" notebook page dialog                                        */
.*---------------------------------------------------------------------------*/
.*  "Help"                     ==  PANEL_DLG_FORMAT                          */
.*  "Character Boxes"          ==  PANEL_DLG_FORMAT_CHARBOX                  */
.*  "Current Date"             ==  PANEL_DLG_FORMAT_DATE                     */
.*  "Current Time"             ==  PANEL_DLG_FORMAT_TIME                     */
.*  "Dual Column"              ==  PANEL_DLG_FORMAT_2UP                      */
.*  "File Name"                ==  PANEL_DLG_FORMAT_FILENAME                 */
.*  "Page Numbers"             ==  PANEL_DLG_FORMAT_PAGENUM                  */
.*  "Text Border"              ==  PANEL_DLG_FORMAT_BORDER                   */
.*  "Line Numbers"             ==  PANEL_DLG_FORMAT_LINE                     */
.*  "Title Text"               ==  PANEL_DLG_FORMAT_TITLE                    */
.*===========================================================================*/
:h1 res=2900 name=PANEL_DLG_FORMAT.Page Format Page
:i1 id=txtfmt.Page Format Page
:p.:hp2.Page Format Page:ehp2.
:p.This page allows you to select different text format options
that will be applied on a per-page basis to your text file when
it is printed.
:p.Available Format Options&colon.
:sl compact.
:li.&sqbul. :link reftype=hd res=2901.Text Format Options:elink. list
:li.&sqbul. :link reftype=hd res=2902.Character Boxes:elink. option
:li.&sqbul. :link reftype=hd res=2903.Current Date:elink. option
:li.&sqbul. :link reftype=hd res=2904.Current Time:elink. option
:li.&sqbul. :link reftype=hd res=2905.Dual Column:elink. option
:li.&sqbul. :link reftype=hd res=2906.File Name:elink. option
:li.&sqbul. :link reftype=hd res=2907.Page Numbers:elink. option
:li.&sqbul. :link reftype=hd res=2908.Text Border:elink. option
.* @74644 - new format option
:li.&sqbul. :link reftype=hd res=2909.Line Numbers:elink. option
:li.&sqbul. :link reftype=hd res=2910.Title Text:elink. option
:li.&sqbul. :link reftype=hd res=2911.Title Text:elink. entryfield
:li.&sqbul. :link reftype=hd res=2912.Title Alignment:elink. buttons
:esl.
.*
:p.:hp7.Step-by-step&colon.:ehp7. :hp3.Selecting Format Options:ehp3.
:ol.
:li.Select the word "Page Numbers" from the :hp2.Text Format Options:ehp2. list.
:li.press the OK button below the notebook.
:eol.
:p.Now, all printouts will automatically add the running page number
to the bottom of each printed page.
.*
:note.When "Dual Column" is selected, there are two logical pages printed
on one piece of paper, therefore many "Format Options" will be printed
on both of the logical pages.
.*
.*------------------------------------*/
.* "Text Format Options"              */
.*------------------------------------*/
:h1 res=2901 name=PANEL_DLG_FORMAT_LIST.Text Format Options
:i1 id=fmtlist.Text Format Options
:p.:hp2.Text Format Options:ehp2.
:p.The :hp2.Text Format Options:ehp2. window lists all the
text format options that are applied to printouts.  Multiple
items in the list can be selected.  If an entry is highlited it
is considered selected.
.*
.*------------------------------------*/
.* "Character Boxes" option           */
.*------------------------------------*/
:h1 res=2902 name=PANEL_DLG_FORMAT_CHARBOX.Print Character Boxes
:i1 id=itemchbox.Print Character Boxes
:p.:hp2.Print Character Boxes:ehp2.
:p.Select the :hp2.Character Boxes:ehp2. listbox entry to
cause character boxes for each character to be printed when
a text file is printed.
:note.:hp2.Printing Character Boxes:ehp2. causes printing time
to increase considerably and should only be used to test new
fonts to determine whether their characters will be printed
correctly when clipping is applied (since clipping text is
based on character boxes).
.*
.*------------------------------------*/
.* "Current Data" option              */
.*------------------------------------*/
:h1 res=2903 name=PANEL_DLG_FORMAT_DATE.Print Current Date
:i1 id=curdate.Print Current Date
:p.:hp2.Print Current Date:ehp2.
:p.Select the :hp2.Current Date:ehp2. listbox entry to
cause the current system date to be printed at the bottem of
each page of output.
.*
.*------------------------------------*/
.* "Current Time" option              */
.*------------------------------------*/
:h1 res=2904 name=PANEL_DLG_FORMAT_TIME.Print Current Time
:i1 id=curtime.Print Current Time
:p.:hp2.Print Current Time:ehp2.
:p.Select the :hp2.Current Time:ehp2. listbox entry to
cause the current system time to be printed at the bottem of
each page of output.
.*
.*------------------------------------*/
.* "Dual Column" option               */
.*------------------------------------*/
:h1 res=2905 name=PANEL_DLG_FORMAT_2UP.Print Dual Column
:i1 id=itemdual.Print Dual Column
:p.:hp2.Print Dual Column:ehp2.
:p.Select the :hp2.Print Dual Column:ehp2. listbox entry to
cause text output to be printed in 2 columns (side-by-side).
This is also called :hp2.2-up:ehp2. printing.
:note.:hp2.Recommendations&colon.:ehp2.
:p.It is recommended that the user select :color fc=red.Landscape
:color fc=default. paper orientation from
the :link reftype=hd res=3803.job properties:elink. for the printer
queue (object) being used.
:p.It is recommended that an :color fc=red.8 pt font:color fc=default.
(or less) is used so that 80 column text files will print in dual
column mode without truncation.
.*
.*------------------------------------*/
.* "File name" option                 */
.*------------------------------------*/
:h1 res=2906 name=PANEL_DLG_FORMAT_FILENAME.File Name
:i1 id=printname.File Name
:p.:hp2.Print File Name:ehp2.
:p.Select the :hp2.File Name:ehp2. listbox entry to
cause the name of the text file being printed to be
printed at the bottem of each page of output.
.*
:note.When "Dual Column" is selected, there are two logical pages printed
on one piece of paper, therefore the "File Name" will be printed
on both of the logical pages.
.*
.*------------------------------------*/
.* "Page Numbers" option              */
.*------------------------------------*/
:h1 res=2907 name=PANEL_DLG_FORMAT_PAGENUM.Page Numbers
:i1 id=printpage.Page Numbers
:p.:hp2.Page Numbers:ehp2.
:p.Select the :hp2.Page Numbers:ehp2. listbox entry to
cause the number of each page to be printed at the bottem
of each page of output.
:p.The page number is added to the bottom of each printed page
(e.g. the second page printed would cause "Page 2" to be printed
at the bottom of the page).
.*
:note.When "Dual Column" is selected, there are two logical pages printed
on one piece of paper, therefore a "Page Number" will be printed
on both of the logical pages.
.*
.*------------------------------------*/
.* "Text Border" option               */
.*------------------------------------*/
:h1 res=2908 name=PANEL_DLG_FORMAT_BORDER.Text Border
:i1 id=border.Text Border
:p.:hp2.Text Border:ehp2.
:p.Select the :hp2.Text Border:ehp2. listbox entry to
draw a box around each page of text output.
.*
:note.When "Dual Column" is selected, there are two logical pages printed
on one piece of paper, therefore a "Text Border" will be printed
on both of the logical pages.
.*
.*------------------------------------*/
.* "Line Number" option - @74644      */
.*------------------------------------*/
:h1 res=2909 name=PANEL_DLG_FORMAT_LINE.Line Number
:i1 id=linenum.Line Number
:p.:hp2.Line Number:ehp2.
:p.Select the :hp2.Line Numbers:ehp2. listbox entry to
cause line numbering to be done on each line of printed text output.
:p.Printing line numbers allows quick reference of a specific
line in a text file.
:p.:hp2.Example&colon.:ehp2. The direction "Look at Line Number 240"
provides faster reference to another person than saying "Look at
the line that says 'hello there'".
.*
.*------------------------------------*/
.* "Title Text" option                */
.*------------------------------------*/
:h1 res=2910 name=PANEL_DLG_FORMAT_TITLE.Title Text
:i1 id=titletxt.Title Text
:p.:hp2.Title Text:ehp2.
:p.Select the :hp2.Title Text:ehp2. listbox entry to
cause a Title to be printed at the top of each page.
:p.Enter the title in the entry field below the listbox
and select how you wish the title to be placed in relation
to the page (left, right, or center justified).
.*
:note.When "Dual Column" is selected, there are two logical pages printed
on one piece of paper, therefore titles will be printed
on both of the logical pages.
.*
.*------------------------------------*/
.* "Title Text" field                 */
.*------------------------------------*/
:h1 res=2911 name=PANEL_DLG_FORMAT_TTEXT.Title Text entryfield
:i1 id=fmttitle.Title Text entryfield
:p.:hp2.Title Text:ehp2.
:p.When the "Title Text" option is selected in the "Text Format Options"
list you may type a title in this entryfield.  The title you type will
be printed on the top of each logical page.
.*
:p.The can align where your title will be placed by checking one of
the :link reftype=hd res=2912.Title Alignment:elink. buttons.
.*
.*------------------------------------*/
.* "Title Alignment"                  */
.*------------------------------------*/
:h1 res=2912 name=PANEL_DLG_FORMAT_ALIGN.Title Alignment
:i1 id=fmtalign.Title Alignment
:p.:hp2.Title Alignment:ehp2.
:p.There are three buttons that can be selected :hp2.Left, Center,:ehp2. or
:hp2.Right:ehp2. that controls where the "Title Text" will be positioned at
the top of each logical page printed.
.*
.*===========================================================================*/
.* "DevQueryCaps" results dialog                                             */
.*---------------------------------------------------------------------------*/
.*  "Help"                     ==  PANEL_DLG_CAPS                            */
.*  "Done"                     ==  PANEL_DLG_CAPS_DONE                       */
.*===========================================================================*/
.*
:h1 res=3000 name=PANEL_CAPS_DLG.Device Capabilities
:i1 id=dlgcaps.Device Capabilities
:p.:hp2.Device Capabilities:ehp2.
:p.This dialog allows you to query the device attached to the queue
you have selected for it's capabilities.
:p.The capabilities are those returned from the OS/2 API call DevQueryCaps.
.*
:p.Related information&colon.
:sl compact.
:li.&sqbul. :link reftype=hd res=3001.Done:elink. Pushbutton
:esl.
.*
.*------------------------------------*/
.* "Done" button                      */
.*------------------------------------*/
:h1 res=3001 name=PANEL_DLG_CAPS_DONE.Done
:p.:hp2.Done:ehp2.
:p.Use this pushbutton when you are done viewing device capabilities.
.*
.*===========================================================================*/
.* "DevQueryHardcopyCaps" results dialog                                     */
.*---------------------------------------------------------------------------*/
.*  "Help"                     ==  PANEL_DLG_HARDCOPY                        */
.*  "Done"                     ==  PANEL_DLG_HARDCOPY_DONE                   */
.*===========================================================================*/
.*
:h1 res=3100 name=PANEL_HPCAPS_DLG.Query Hardcopy Capabilities
:i1 id=dlghccaps.Query Hardcopy Capabilities
:p.:hp2.Query Hardcopy Capabilities:ehp2.
:p.This dialog allows you to query the device attached to the queue
you have selected for it's hardcopy capabilities.
:p.The capabilities are those returned from the OS/2 API call
DevQueryHardcopyCaps.
:p.Examples of Hardcopy types include&colon.
:dl break=all tsize=4.
:dt.:hp7.Paper:ehp7.
:dd.Typical output for printer and plotters
:dt.:hp7.Transparencies:ehp7.
:dd.Supported on some printers and many plotters
:dt.:hp7.Image File:ehp7.
:dd.(e.g. bitmaps .BMP) Supported by some programs whose output device
is the screen.
:dt.:hp7.Film:ehp7.
:dd.Film recorders
:dt.:hp7.Circuit boards:ehp7.
:dd.Laser etching machines
:edl.
.*
:p.Related information&colon.
:sl compact.
:li.&sqbul. :link reftype=hd res=3101.Done:elink. Pushbutton
:esl.
.*
.*------------------------------------*/
.* "Done" button                      */
.*------------------------------------*/
:h1 res=3101 name=PANEL_DLG_HARDCOPY_DONE.Done
:p.:hp2.Done:ehp2.
:p.Use this pushbutton when you are done viewing device hardcopy capabilities.
.*
.*===========================================================================*/
.* "GpiQueryFontmetrics"  results dialog                                     */
.*---------------------------------------------------------------------------*/
.*  "Help"                     ==  PANEL_DLG_FNTMETRIC                       */
.*  "Done"                     ==  PANEL_DLG_FNTMETRIC_DONE                  */
.*===========================================================================*/
:h1 res=3200 name=PANEL_DLG_FNTMETRIC.Font Metrics Dialog
:i1 id=dlgmetrics.Font Metrics Dialog
:p.:hp2.Current Font Metrics:ehp2.
:p.This dialog displays the font metric information for the
currently realized font.
:p.The values displayed here reflect any changes made to the
font such as scaling the font's point size or applying an
option like 'italic' to the font.
:p.Realized font metrics are different from the font metrics
shown in the :link reftype=hd res=2700.Font:elink. page of the
"Program Settings" notebook which
display :link reftype=fn refid=designunits.Design Units:elink. for a font.
.*
.*------------------------------------*/
.* "Done" button                      */
.*------------------------------------*/
:h1 res=3201 name=PANEL_DLG_FNTMETRIC_DONE.Done
:p.:hp2.Done:ehp2.
:p.Use this pushbutton when you are done viewing a font's metric information
to close the dialog.
.*
.*===========================================================================*/
.* "GpiQueryWidthTable"  results dialog                                      */
.*---------------------------------------------------------------------------*/
.*  "Help"                     ==  PANEL_DLG_FNTWDTH                         */
.*  "Done"                     ==  PANEL_DLG_FNTWDTH_DONE                    */
.*===========================================================================*/
:h1 res=3300 name=PANEL_DLG_FNWDTH.GpiQueryWidthTable
:i1 id=dlgwidth.GpiQueryWidthTable
:p.:hp2.GpiQueryWidthTable:ehp2.
:p.This dialog displays the current font's character width tables.
.*
.*------------------------------------*/
.* "Done" button                      */
.*------------------------------------*/
:h1 res=3301 name=PANEL_DLG_FNTWDTH_DONE.Done
:p.:hp2.Done:ehp2.
:p.Use this pushbutton when you are done viewing a font's character width
information to close the dialog.
.*
.*===========================================================================*/
.* "GpiQueryKerningPairs" results dialog                                     */
.*---------------------------------------------------------------------------*/
.*  "Help"                     ==  PANEL_DLG_FNTKERN                         */
.*  "Done"                     ==  PANEL_DLG_FNTKERN_DONE                    */
.*===========================================================================*/
:h1 res=3400 name=PANEL_DLG_FNTKERN.GpiQueryKerningPairs
:i1 id=dlgkern.GpiQueryKerningPairs
:p.:hp2.GpiQueryKerningPairs:ehp2.
:p.This dialog displays the current font's kerning pair tables.
.*
.*------------------------------------*/
.* "Done" button                      */
.*------------------------------------*/
:h1 res=3401 name=PANEL_DLG_FNTKERN_DONE.Done
:p.:hp2.Done:ehp2.
:p.Use this pushbutton when you are done viewing a font's kerning pair
information to close the dialog.
.*
.*===========================================================================*/
.* "Search for Text" dialog                                                  */
.*---------------------------------------------------------------------------*/
.*  "Help"                     ==  PANEL_DLG_SEARCH                          */
.*  "Search String"            ==  PANEL_DLG_SEARCH_STRING                   */
.*  "Case Sensitive"           ==  PANEL_DLG_SEARCH_CASE                     */
.*  "OK"                       ==  PANEL_DLG_SEARCH_SEARCH                   */
.*  "Cancel"                   ==  PANEL_DLG_SEARCH_CANCEL                   */
.*===========================================================================*/
.*
:h1 res=3500 name=PANEL_DLG_SEARCH.Search For Text Dialog
:i1 id=dlgsearch.Search For Text Dialog
:p.:hp2.Search For Text Dialog:ehp2.
:p.This dialog allows you to enter a text string
to search for in the currently opened file.
:ol compact.
:li.Enter a search string into the entryfield.
:li.Hit the :hp2.Search:ehp2. button.
:eol.
.*
:p.Related information&colon.
:sl compact.
:li.&sqbul. :link reftype=hd res=3501.Search String:elink. entryfield
:li.&sqbul. :link reftype=hd res=3502.Case Sensitive:elink. checkbox
:li.&sqbul. :link reftype=hd res=3503.Cancel:elink. button
:li.&sqbul. :link reftype=hd res=3504.OK:elink. button
:esl.
.*
.*------------------------------------*/
.* "Search String" entryfield         */
.*------------------------------------*/
:h1 res=3501 name=PANEL_DLG_SEARCH_STRING.Search String
:p.:hp2.Search String:ehp2.
:p.Enter the string to be searched for in this entryfield.
.*
.*------------------------------------*/
.* "Case Sensitive" checkbox          */
.*------------------------------------*/
:h1 res=3502 name=PANEL_DLG_SEARCH_CASE.Case Sensitive
:p.:hp2.Case Sensitive:ehp2.
:p.This checkbox controls how comparisons are made when searching
for a text string in a text file.
:p.If the box is NOT checked (default), comparisons ignore upper and
lower-case letters when the search is being made.  Therefore, the
string "ABC" would match on a search of a text file that contains
the text "xyzabc123".
.*
:p.If the box is checked, comparisons pay attention to upper and
lower-case letters when the search is being made.  Therefore, the
string "ABC" would NOT match on a search of a text file that contains
the text "xyzabc123" but would match if the text were "xyzABC123".
.*
.*------------------------------------*/
.* "Cancel" button                    */
.*------------------------------------*/
:h1 res=3503 name=PANEL_DLG_SEARCH_CANCEL.Cancel
:p.:hp2.Cancel:ehp2.
:p.Exit Search For Text Dialog
.*
.*------------------------------------*/
.* "OK" button                        */
.*------------------------------------*/
:h1 res=3504 name=PANEL_DLG_SEARCH_SEARCH.Search
:p.:hp2.Search:ehp2.
:p.Hit this button to begin search for the text string entered in the
entryfield on this dialog.
:p.If the string is found in the file, the line in the file
containing the string is moved to the top of Font Test's
window.
.*
.*===========================================================================*/
.* "Confirm Print" dialog                                                    */
.*---------------------------------------------------------------------------*/
.*  "Help"                     ==  PANEL_DLG_CONFIRM                         */
.*  "File"                     ==  PANEL_DLG_CONFIRM_FILE                    */
.*  "Queue Description"        ==  PANEL_DLG_CONFIRM_QDESC                   */
.*  "Queue Name"               ==  PANEL_DLG_CONFIRM_QNAME                   */
.*  "Device Driver"            ==  PANEL_DLG_CONFIRM_DRIVER                  */
.*  "Device Name"              ==  PANEL_DLG_CONFIRM_DEVICE                  */
.*  "Font Name"                ==  PANEL_DLG_CONFIRM_FONT                    */
.*  "Point Size"               ==  PANEL_DLG_CONFIRM_PSIZE                   */
.*  "Review Settings..."       ==  PANEL_DLG_CONFIRM_REVIEW                  */
.*  "OK"                       ==  PANEL_DLG_CONFIRM_OK                      */
.*  "Cancel"                   ==  PANEL_DLG_CONFIRM_CANCEL                  */
.*===========================================================================*/
:h1 res=3600 name=PANEL_DLG_CONFIRM.Confirm Print Information
:i1 id=confprint.Confirm Print Information
:p.:hp2.Confirm Print Information:ehp2.
:p.This dialog allows you to review the file name you are going
to print and the details of the output device it will be printed on.
:p.This dialog gives the user one last chance to modify
job properties, text format, and color options that will be applied
to the file when it is printed.
.*
:p.Click on the following items for more information&colon.
:sl compact.
:li.:link reftype=hd res=3601.File:elink. entryfield
:li.:link reftype=hd res=3602.Queue Description:elink. window
:li.:link reftype=hd res=3603.Queue Name:elink. window
:li.:link reftype=hd res=3604.Device Driver:elink. window
:li.:link reftype=hd res=3605.Device Name:elink. window
:li.:link reftype=hd res=3606.Font Name:elink. window
:li.:link reftype=hd res=3607.Point Size:elink. window
:li.:link reftype=hd res=3608.Review Settings:elink. button
:li.:link reftype=hd res=3609.OK:elink. button
:li.:link reftype=hd res=3610.Cancel:elink. button
:esl.
.*
.*------------------------------------*/
.* "File" field                       */
.*------------------------------------*/
:h1 res=3601 name=PANEL_DLG_CONFIRM_FILE.Confirm File
:i1 id=conffile.Confirm File
:p.:hp2.File:ehp2.
:p.Confirm that this is the file that is to be printed.
.*
.*------------------------------------*/
.* "Queue Description" field          */
.*------------------------------------*/
:h1 res=3602 name=PANEL_DLG_CONFIRM_QDESC.Confirm Queue Description
:i1 id=confdesc.Confirm Queue Description
:p.:hp2.Queue Description:ehp2.
:p.Confirm that this is the name of the Print Queue the printout should
go to.
.*
.*------------------------------------*/
.* "Queue Name" field                 */
.*------------------------------------*/
:h1 res=3603 name=PANEL_DLG_CONFIRM_QNAME.Confirm Queue Name
:i1 id=confque.Confirm Queue Name
:p.:hp2.:ehp2.
:p.Confirm that this is the Queue Name the printout should go to.
.*
.*------------------------------------*/
.* "Device Driver" field              */
.*------------------------------------*/
:h1 res=3604 name=PANEL_DLG_CONFIRM_DRIVER.Confirm Device Driver
:i1 id=confdrv.Confirm Device Driver
:p.:hp2.Device Driver:ehp2.
:p.Confirm that this is the printer driver to be used for printing
the file.
.*
.*------------------------------------*/
.* "Device Name" field                */
.*------------------------------------*/
:h1 res=3605 name=PANEL_DLG_CONFIRM_DEVICE.Confirm Device Name
:i1 id=confdev.Confirm Device Name
:p.:hp2.:ehp2.
:p.Confirm that this is the Printer Model that should be used for
formatting the output.
.*
.*------------------------------------*/
.* "Font name" field                  */
.*------------------------------------*/
:h1 res=3606 name=PANEL_DLG_CONFIRM_FONT.Confirm Font Name
:i1 id=conffnt.Confirm Font Name
:p.:hp2.:ehp2.
:p.Confirm that this is the font that should be used for printing the
text file.
.*
.*------------------------------------*/
.* "Point Size" field                 */
.*------------------------------------*/
:h1 res=3607 name=PANEL_DLG_CONFIRM_PSIZE.Confirm Point Size
:i1 id=confsize.Confirm Point Size
:p.:hp2.Point Size:ehp2.
:p.Confirm that this is the correct Point Size for the
Font being used to print the text file.
.*
.*------------------------------------*/
.* "Review Settings" button           */
.*------------------------------------*/
:h1 res=3608 name=PANEL_DLG_CONFIRM_REVIEW.Review Settings...
:i1 id=confrev.Review Settings...
:p.:hp2.Review Settings...:ehp2.
:p.Use this button to display the
:link reftype=hd res=3803.Job Properties:elink. dialog for the printer
model displayed in the :hp2.Device Name:ehp2. field on this dialog.
.*
:p.This Job Properties panel allows you one last chance to change
key job options such as :hp2.Orientation, Resolution, etc.:ehp2.&period.
.*
.*------------------------------------*/
.* "OK" button                        */
.*------------------------------------*/
:h1 res=3609 name=PANEL_DLG_CONFIRM_OK.Confirm OK
:i1 id=confok.Confirm OK
:p.:hp2.OK:ehp2.
:p.Select the :hp2.OK:ehp2. button if all the fields, options, and
settings displayed on this dialog are correct.  The text file will
begin printing immediately after the :hp2.OK:ehp2. button is pressed.
.*
.*------------------------------------*/
.* "Cancel" button                    */
.*------------------------------------*/
:h1 res=3610 name=PANEL_DLG_CONFIRM_CANCEL.Confirm Cancel
:i1 id=confccl.Confirm Cancel
:p.:hp2.Cancel:ehp2.
:p.Select the :hp2.Cancel:ehp2. button if any of the fields, options, or
settings displayed on this dialog are NOT correct.  The text file will
NOT be printed and the dialog will be dismissed.
.*
.*===========================================================================*/
.* "Help" dialogs                                                            */
.*---------------------------------------------------------------------------*/
.*===========================================================================*/
.*
.*--------------------------------------------------------------*/
.*  "Using Help..." help panel                                  */
.*--------------------------------------------------------------*/
:h1 res=3800 name=PANEL_HELP_USING.Using Help in Font Test
:i2 refid=helpuse.Using Help in Font Test
:p.:hp2.Using Help in Font Test:ehp2.
:p.Help for Font Test may be obtained in a few simple ways&colon.
:sl.
:li.Hit the :hp2.F1:ehp2. from almost anywhere in the program.
:li.Select the :hp2.Help:ehp2. button from any panel where it appears.
:esl.

.*--------------------------------------------------------------*/
.*  "Extended Help..." help panel                               */
.*--------------------------------------------------------------*/
:h1 res=3801 name=PANEL_HELP_EXTENDED.Extended Help for Font Test
:i2 refid=helpext.Extended Help for Font Test
:p.:hp2.Extended Help for Font Test:ehp2.
.*
:p.Use :hp2.Font Test:ehp2. to display and print
:link reftype=fn refid=text.text:elink. files using the
OS/2 Presentation Manager (PM).
.*
:p.Using the OS/2 PM printing method allows applications
to interact with the OS/2 presentation driver for your
:link reftype=fn refid=outputdevice.output device:elink.
.*
:p.This interaction let's the application ask the device
about it's capabilities such as font and color support.
.*
:p.By using the OS/2 presentation driver to print a file,
this application is best able to generate output
that takes full advantage of the output device's
capabilities.
.*
:p.:hp7.Step-by-step&colon.:ehp7. :hp3.Printing a File:ehp3.
.*
:ol compact.
:li.Select the :hp2.Open File...:ehp2. menu item option from the :hp2.File:ehp2. menubar.
:li.A dialog will appear, use it to select a file.
Font Test will display the selected file in the main window.
:li.Choose the :hp2.Program Settings...:ehp2. menu item and a notebook
will appear.
:li.Turn to the :hp2.Printer:ehp2. page and select a Print Queue that
is connected to the :link reftype=fn refid=outputdevice.output device:elink. you
wish to print to.
:li.Turn to the :hp2.Font:ehp2. page and select a font for displaying
nd printing the file.
:li.Select the :hp2.OK:ehp2. button to close the Program Settings notebook
saving your changes for this printout.
:li.Select the :hp2.Print File...:ehp2. option from the :hp2.File:ehp2. menubar.
:li.A :hp2.Confirm Print Information:ehp2. dialog will appear.
:li.If satisfied with the Print Information, select the :hp2.OK:ehp2. button
to print the file.
:eol.
.*
:p.Your file should print to the Print Queue you selected, using the the
font you chose.
.*
:note.If you do not have any Print Queues (printer drivers) installed
you will be told that none exist and you should create one under OS/2
before trying again.
:note.If your font appears the wrong size (too small or too large)
make sure that the font you chose is a scalable font or a font whose
resolution matches your printer's.
.*
.*--------------------------------------------------------------*/
.*  "Keys Help..." help panel                                   */
.*--------------------------------------------------------------*/
:h1 res=3802 name=PANEL_HELP_KEYS.Special Key Combinations
:p.:hp2.Font Test's Special Keys:ehp2.
:p.The following keys/key combinations have special meanings when hit
while Font Test is running.
:sl.
:li.:hp2.F1:ehp2.                - Display help topic for selected item.
:li.:hp2.F3:ehp2.                - End Font Test.
:li.:hp2.CTRL-O:ehp2.            - Brings up Open File dialog.
:li.:hp2.CTRL-P:ehp2.            - Print currently opened file.
:li.:hp2.SHIFT-PrintScreen:ehp2. - Print currently opened file.
:li.:hp2.CTRL-S:ehp2.            - Brings up Text Search dialog.
:li.:hp2.CTRL-F:ehp2.            - Repeat search for string.
.* @MAXLINES - new virtual control keys for big files
:li.:hp2.CTRL-HOME:ehp2.         - Jump to Top of file.
:li.:hp2.CTRL-END:ehp2.          - Jump to Bottom of file.
:esl.
.*
.*--------------------------------------------------------------*/
.* "Job Properties" help panel                                  */
.*--------------------------------------------------------------*/
:h1 res=3803 name=PANEL_HELP_JOB_PROPERTIES.What are Job Properties
:p.:hp2.What are Job Properties:ehp2.
:p.Job Properties are the fundamental way a user changes the
appearance of their printouts. These job properties are shown
directly by the printer driver with options specific to your printer.
:p.Examples of things that may be changed using Job Properties are&colon.
:sl compact.
:li.:hp2.Orientation:ehp2. (e.g. Portrait, Landscape)
:li.:hp2.Resolution:ehp2. (e.g. Draft, 600 dpi)
:li.:hp2.Print Mode:ehp2. (e.g. Monochrome, Color)
:li.:hp2.Form:ehp2. (e.g. Letter, Legal, Envelope)
:li.:hp2.Media Types:ehp2. (e.g. Transparency, Glossy)
:li.:hp2.Paper Trays:ehp2. (e.g. Upper Bin, Manual Tray, Envelope feeder)
:esl.
.*
:p.The Job Properties displayed are initially based on the Job
Properties you defined in the "printer driver" page of the
Print Queue's settings notebook of the Print Queue you are
printing to.  If the Print Queue's Job Properties have never
been set by you, defaults for your printer will be used.
.*
:note.The Job Properties panel and options available are different
depending on what printer driver and printer model you are using.
.*
:note.Any changes made to Job Properties in Font Test are not
permanent and do not affect job properties for other applications.
.*
.*===========================================================================*/
.* GLOSSARY OF TERMS                                                         */
.*===========================================================================*/
.* Defined terms: TBD                                                        */
.*===========================================================================*/
.*
.*-------------------------------------*/
.* DRIVE                               */
.*-------------------------------------*/
:fn id=drive.
:dl tsize=4 break=all.
:dt.:hp7.Drive:ehp7.
:p.Any physical or logical storage area you have defined on your
system that can store file information. Usually represented by a
single letter followed by a colon.
:p.Such as&colon.
:sl compact.
:li.Floppy disk drives
:li.Hard disk partition
:li.Network drive
:li.Tape or Optical drive
:li.CD ROM drive
:esl.
:sl compact.
:li.:hp2.Example&colon. :ehp2. from an :color fc=red.OS/2:color fc=default.
command line you may see something like :hp9."c&colon.\":ehp9..
:li.
:li.The :hp9."c&colon.":ehp9. portion is the drive letter
:esl.
:efn.
.*
.*-------------------------------------*/
.* DIRECTORY                           */
.*-------------------------------------*/
:fn id=directory.
:dl tsize=4 break=all.
:dt.:hp7.Directory:ehp7.
:p.
An named storage area that stores files or other directories.
It usually holds a logical grouping of files on a drive.
:sl.
:li.:hp2.Example&colon. :ehp2. from an :color fc=red.OS/2:color fc=default.
command line you may see something like :hp9."c&colon.\os2\dll":ehp9..
:li.The :hp9."\dll":ehp9. protion of this string is a directory containing
files having the extension ".DLL".
:li.
:li.The :hp9."\os2":ehp9. portion of the string is also a directory that
has files, as well as the directory :hp9."\dll":ehp9..
:esl.
:efn.
.*
.*-------------------------------------*/
.* filename                            */
.*-------------------------------------*/
:fn id=file.
:dl tsize=4 break=all.
:dt.:hp7.filename:ehp7.
:p.A name given to a file as it appears on a storage device
(i.e. computer hard drive, floppy disk, CD-ROM, network server, etc.).
:efn.
.*
.*-------------------------------------*/
.* TEXT                                */
.*-------------------------------------*/
:fn id=text.
:dl tsize=4 break=all.
:dt.:hp7.Text:ehp7.
:p.An ASCII text file. Use the OS/2 System Editor to prepare plain ASCII
text files.
:efn.
.*
.*-------------------------------------*/
.* OUTPUT DEVICE                       */
.*-------------------------------------*/
:fn id=outputdevice.
:dl tsize=4 break=all.
:dt.:hp7.Output Device:ehp7.
:p.A device attached to your computer that places output on or into
some medium.  Typically we are speaking of printers or plotters; however,
there are other output devices available that are becoming more common.
:p.Examples of alternative output devices are&colon.
:sl compact.
:li.&sqbul. Fax machine
:li.&sqbul. Film recorder (slides, photos)
:li.&sqbul. Raster file (output is a bitmap).
:li.&sqbul. Laser etching machine
:esl.
:note.The variety and complexity of possible output devices using OS/2
presentation drivers (and they are available from any OS/2 applications!!!).
:efn.
.*
.*-------------------------------------*/
.* Queue                               */
.*-------------------------------------*/
:fn id=queue.
:dl tsize=4 break=all.
:dt.:hp7.Queue:ehp7.
:p.A holding area for files that are ready to be sent to an output
device (e.g. printer, plotter, film recorder, Fax machine etc.).
The output device is not always able to keep up with all the files
you wish to send to it so the queue holds them until the device is ready
for them and sends them in one at a time.
:efn.
.*
.*-------------------------------------*/
.* WYSIWIG                             */
.*-------------------------------------*/
:fn id=wysiwig.
:dl tsize=4 break=all.
:dt.:hp7.WYSIWIG:ehp7.
:dd.:color fc=red.W:color fc=default.hat
:color fc=red.Y:color fc=default.ou
:color fc=red.S:color fc=default.ee
:color fc=red.I:color fc=default.s
:color fc=red.W:color fc=default.hat
:color fc=red.Y:color fc=default.ou
:color fc=red.G:color fc=default.et
:edl.
:p.A term used to mean that exactly what you see on the screen or in an
application, is exactly how it looks when printed.
:p.For example&colon. If you see a Courier 16 point font on the screen,
you will get a Courier 16 point font on your output device.
:efn.
.*
.*-------------------------------------*/
.* Designer Units                      */
.*-------------------------------------*/
:fn id=designunits.
:dl tsize=4 break=all.
:dt.:hp7.Designer Units:ehp7.
:p.Font designers typically create a font for a specific point
size (nominal point size).  Designer units are the values of height
and width for a font if it is realized at it's nominal point size.
:p.Outline fonts can be realized at any point size between their
minimum and maximum point sizes and their heights and widths are
scaled accordingly.
:efn.
.*
.*-------------------------------------*/
.* Nominal Point Size                  */
.*-------------------------------------*/
:fn id=nominal.
:p.:hp7.Nominal Point Size:ehp7.
:p.The font designer's intended point size, the point size for
which the font was designed to be used at.
:efn.
.*
.*-------------------------------------*/
.* Command Line Option: /P             */
.*-------------------------------------*/
:fn id=cmdp.
:p.:hp7.Command Line Option: /P:ehp7.
:p.This command-line option switch causes fontest to print the file
specified on the command line without causing Font Test to start
it's PM window.  This is called :hp2.Command-Line Printing":ehp2.&period.
:p.When printing all Program Settings are applied to the file being printed
as they were last saved when Font Test's PM application window was started.
.*
:note.The following variants of /P also have the same effect&colon.
:p. /p, -P, and -p
:efn.
.*
.*-------------------------------------*/
.* Command Line Option: /?             */
.*-------------------------------------*/
:fn id=cmdh.
:p.:hp7.Command Line Option: /?:ehp7.
:p.This command-line option switch causes correct syntax for
invoking Font Test from a command line.
:efn.
.*
:euserdoc.

