/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1992 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 source code is provided to you solely for       */
/*    the purpose of assisting you in your development of OS/2 device        */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Developer Connection Device Driver       */
/*    Source Kit for OS/2. This Copyright statement may not be removed.      */
/*                                                                           */
/*****************************************************************************/
/**************************************************************************
 *
 * SOURCE FILE NAME = PRDUTILS
 *
 * DESCRIPTIVE NAME =
 *
 *
 * VERSION
 *
 * DATE
 *
 * DESCRIPTION
 *
 * FUNCTIONS   prdu_stroccur
 *             prdu_strcmpN
 *             prdu_strcpyN
 *             prdu_strcmp
 *             prdu_strcpy
 *             prdu_memcpy
 *             prdu_memset
 *             prdu_strupr
 *             prdu_tan
 *             prdu_lrotl
 *
 * ENTRY POINTS:
 *
 * DEPENDENCIES:
 *
 * NOTES
 *
 *
 * STRUCTURES
 *
 * EXTERNAL REFERENCES
 *
 * EXTERNAL FUNCTIONS
 *
*/

/******************************************************************************/
/* CON3201                                                                    */
/* Coversions Notes:                                                          */
/*                                                                            */
/* Changed all functions declarations from K&R to ANSI.                       */
/* Left the double slash comment style although not strictly ANSI compatible  */
/*       must use Ss+ compile switch on the CSet/2 complier.                  */
/*                                                                            */
/******************************************************************************/

#define INCL_32               /* CON3201 */
#define INCL_DOSSEMAPHORES    /* CON3201 */
#define INCL_DOSPROCESS       /* CON3201 */
#define INCL_GPIBITMAPS
#define INCL_GPIPRIMITIVES
#define INCL_WINHEAP
#define INCL_FONTFILEFORMAT
#include <os2.h>
#undef INCL_FONTFILEFORMAT
#undef INCL_WINHEAP
#undef INCL_GPIPRIMITIVES
#undef INCL_GPIBITMAPS
#undef INCL_DOSPROCESS        /* CON3201 */
#undef INCL_DOSSEMAPHORES     /* CON3201 */
#undef INCL_32                /* CON3201 */

#define INCL_DDIMISC
#define INCL_DDIBUNDLES
#include <pmddi.h>
#undef INCL_DDIBUNDLES
#undef INCL_DDIMISC

#include <prdinclt.h>
#include <prduextf.h>
#include <prdbtyp1.h>
#include <prdbextf.h>

/**********************************************************************/
/*                                                                    */
/*   FUNCTION: prdu_stroccur                                          */
/*                                                                    */
/*   PARAMETERS:                                                      */
/*                                                                    */
/*   BYTE               Character;                                    */
/*   PBYTE              String;                                       */
/*                                                                    */
/*   DESCRIPTION:                                                     */
/*                                                                    */
/* This function works out whether Character occurs in String.        */
/* It returns TRUE if yes and FALSE if not. It also returns TRUE if   */
/* Character is null.                                                 */
/**********************************************************************/
BOOL prdu_stroccur (BYTE  Character, PBYTE  String )

{
    if ( !Character )
        return TRUE;

    while (*String)
    {
        if (Character == *String++)
            return TRUE;
    }
    return FALSE;
}


/**********************************************************************/
/* prdu_strcmpN - compare strings up to N chars.                      */
/**********************************************************************/
SHORT prdu_strcmpN( PBYTE  s1, PBYTE  s2, USHORT N)

{
/*    return( strncmp( s1, s2, N ) ); CON3201 */

    USHORT Loop;
    for ( Loop = 0; (*s1 == *s2) && *s1 ; )
    {

        if ( ++Loop == N )
        {
            return( 0 );
        }
        s1++;
        s2++;
    }
    return( (SHORT)(*s2 - *s1) );
}


/**********************************************************************/
/* prdu_strcpyN - copy s2 to s1, for up to N chars (+ a null).        */
/**********************************************************************/
void prdu_strcpyN( PBYTE s1, PBYTE s2, USHORT N )

{
    /******************************************************************/
    /* Note: strncpy does not do the same as this - it does not       */
    /* write the terminating null to s1.                              */
    /******************************************************************/
    USHORT Loop;

    Loop = 0;
    while( *s2 )
    {
        if ( Loop++ == N )
        {
            break;
        }
        *s1++ = *s2++;
    }
    *s1 = '\0';
    return;
}


/**********************************************************************/
/* prdu_strcmp - compare strings                                      */
/**********************************************************************/
SHORT prdu_strcmp( PBYTE s1, PBYTE s2 )

{
/*  return( strcmp( s2, s1 ) ); CON3201 */
    /******************************************************************/
    /* Old code                                                       */
    /******************************************************************/
    /******************************************************************/
    /* CON3201 - It was decided that to facilitate the use of DBCS    */
    /*           that C runtime functions should not be used          */
    /******************************************************************/
    USHORT Loop;
    for ( Loop = 0; (*s1 == *s2) && *s1 ; s1++, s2++);
    return( (SHORT)(*s2 - *s1) );
}

/**********************************************************************/
/* prdu_strupr - capitalize a string                                  */
/**********************************************************************/
VOID prdu_strupr( PBYTE s )


{
    for (; *s ; s++ )
    {
        if ( *s >= 'a' && *s <= 'z' )
        {
            *s = *s + 'A' - 'a';
        }
    }
    return;
}

/**********************************************************************/
/* prdu_strcpy - copy s2 to s1                                        */
/**********************************************************************/
void prdu_strcpy( PBYTE s1, PBYTE s2 )

{
/*  strcpy( s1, s2 ); CON3201 */
/*  return;           CON3201 */

    USHORT Loop;
    for ( Loop = 0; *s2 ; *s1++ = *s2++ );
    *s1 = '\0';
    return;
}


/**********************************************************************/
/* prdu_strcat - add  s2 to s1                                        */
/**********************************************************************/
void prdu_strcat( PBYTE s1, PBYTE s2 )


{
/*  strcat( s1, s2 ); CON3201 */
/*  return;           CON3201 */
    USHORT Loop;
    s1 += prdu_strlen( s1 );
    for ( ; *s2 ; *s1++ = *s2++ );
    *s1 = '\0';
    return;
}


/**********************************************************************/
/* prdu_strlen - string length                                        */
/**********************************************************************/
USHORT prdu_strlen( PBYTE s1 )

{
/*  return( strlen( s1 ) ); CON3201 */
    USHORT Loop = 0;
    while (*s1++) Loop++;
    return( Loop );
}




/**********************************************************************/
/* prdu_memcmp - compare memory.                                      */
/* FIX : AK 04/26/91 - was bugged in case where memory contents match.*/
/**********************************************************************/
#if 0
SHORT prdu_memcmp( PBYTE s1, PBYTE s2, USHORT count)
#endif
LONG prdu_memcmp( PBYTE s1, PBYTE s2, ULONG count)         /* CON3201 */


{
/*  return( memcmp( s2, s1, count ) ); CON3201 */
/*  USHORT Loop;                       CON3201 */
    ULONG Loop;                     /* CON3201 */
    for ( Loop = 0; (*s1 == *s2)  ; )
    {
        if ( ++Loop == count )
        {
            return( 0 );
        }
        s1++;
        s2++;
    }
/*  return( (SHORT)(*s2 - *s1) );      CON3201 */
    return( (LONG)(*s2 - *s1) );    /* CON3201 */
}


/**********************************************************************/
/* prdu_memcpy - copy bytes from s2 to s1, for N bytes.               */
/**********************************************************************/
#if 0
void prdu_memcpy( PBYTE s1, PBYTE s2, USHORT N )
#endif
void prdu_memcpy( PBYTE s1, PBYTE s2, ULONG N )            /* CON3201 */


{
/*  memcpy( s1, s2, N ); CON3201 */
/*  return;              CON3201 */
/*  USHORT Loop;         CON3201 */
    ULONG Loop;       /* CON3201 */
    for ( Loop = 0; Loop< N; Loop++)
    {
        *s1++ = *s2++;
    }
    return;
}

/**********************************************************************/
/* prdu_memset - sets a char into N bytes.                            */
/*                                                                    */
/* CON3201 : changed to handle a LONG rather than a SHORT length      */
/**********************************************************************/
#if 0
void prdu_memset( PBYTE s, BYTE c, USHORT N )
#endif
void prdu_memset( PBYTE s, BYTE c, ULONG N )

{
/*  memset( s, c, N ); CON3201 */
/*  return;            CON3201 */
/*  USHORT Loop;       CON3201 */
    ULONG  Loop;    /* CON3201 */
    for ( Loop = 0; Loop< N; Loop++)
    {
        *s++ = c;
    }
    return;
}

/**********************************************************************/
/* prdu_abs - returns the absolute value of its argument.             */
/**********************************************************************/
ULONG prdu_abs( ULONG val )

{
    return (val > 0) ? val : (-val);
}


/**********************************************************************/
/* PD00172 : added this routine.                                      */
/*                                                                    */
/* prdu_tan - returns the tangent*1000 for the input angle            */
/* The input angle must be >0 and < 90 degrees!                       */
/**********************************************************************/

USHORT prdu_tan( USHORT angle )

{
    /******************************************************************/
    /* Allocate and initialize the tangent table for angles 0 thru 90.*/
    /* This table contains the tangent multiplied by 1000 to yield    */
    /* 3 places to right of decimal accuracy.                         */
    /******************************************************************/

    static USHORT TanTable[] = {   0,   17,    35,    52,    70,
                      /*  5 */    87,   105,   123,   141,   158,
                      /* 10 */   176,   194,   213,   231,   249,
                      /* 15 */   268,   287,   306,   325,   344,
                      /* 20 */   364,   384,   404,   424,   445,
                      /* 25 */   466,   488,   510,   532,   554,
                      /* 30 */   577,   601,   625,   649,   675,
                      /* 35 */   700,   727,   754,   781,   810,
                      /* 40 */   839,   869,   900,   933,   966,
                      /* 45 */   1000,  1035,  1072,  1111,  1150,
                      /* 50 */   1192,  1235,  1280,  1327,  1376,
                      /* 55 */   1428,  1483,  1540,  1600,  1664,
                      /* 60 */   1732,  1804,  1881,  1963,  2050,
                      /* 65 */   2145,  2246,  2356,  2475,  2605,
                      /* 70 */   2747,  2904,  3078,  3271,  3487,
                      /* 75 */   3732,  4011,  4331,  4705,  5145,
                      /* 80 */   5671,  6314,  7115,  8144,  9514,
                      /* 85 */   11430, 14301, 19081, 28636, 57290,
                      /* 90 */   57290 };

    if ( angle > 90 )
       angle = 0;

    return (TanTable[angle] );
}

/**********************************************************************/
/* CON3201 : added this routine C function _lrotl                     */
/* prdu_lrotl - rotates an input value left N positions.              */
/**********************************************************************/
ULONG prdu_lrotl( ULONG  val,
                  USHORT N )
{
    ULONG temp;
    temp = val >> (32-N);         /* get bits which will be shifted out */
    return( (val << N) | temp );  /* shift out hi end, or in lo end     */
}

/* CON32D - Created wrapper function to get around the size parameter being   */
/*          0. When a size of 0 is used with SSAllocSeg a whole segment       */
/*          is created with SSAllocMem an error is returned.                  */
ULONG SafeSSALLOCMEM(PVOID pBaseAddr,
                     ULONG Size,
                     ULONG Flags)
{
    if(Size == 0)
        return(SSAllocMem(pBaseAddr, 65535, Flags));
    else
        return(SSAllocMem(pBaseAddr, Size, Flags));
}
