/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1992 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 source code is provided to you solely for       */
/*    the purpose of assisting you in your development of OS/2 device        */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Developer Connection Device Driver       */
/*    Source Kit for OS/2. This Copyright statement may not be removed.      */
/*                                                                           */
/*****************************************************************************/
/**************************************************************************
 *
 * SOURCE FILE NAME = PRDPRINT
 *
 * DESCRIPTIVE NAME =
 *
 *
 * VERSION
 *
 * DATE
 *
 * DESCRIPTION
 *
 * FUNCTIONS   prdn_ProcessPage
 *             prdn_ProcessLastPage
 *             prdn_SendInitAndPage
 *             prdn_BandingStopJournalling
 *             prdn_BandingDeleteJournal
 *
 * ENTRY POINTS:
 *
 * DEPENDENCIES:
 *
 * NOTES
 *
 *
 * STRUCTURES
 *
 * EXTERNAL REFERENCES
 *
 * EXTERNAL FUNCTIONS
 *
*/

#define INCL_32                        /* CON3201 */
#define INCL_DOSPROCESS                /* CON3201 */
#define INCL_DOSSEMAPHORES
#define INCL_GREALL
#define INCL_GPIPRIMITIVES
#define INCL_WINHEAP
#define INCL_GPIBITMAPS
#define INCL_DOSPROCESS
#define INCL_SPL
#include <os2.h>
#undef INCL_DOSPROCESS                 /* CON3201 */
#undef INCL_DOSSEMAPHORES
#undef INCL_GREALL
#undef INCL_GPIPRIMITIVES
#undef INCL_WINHEAP
#undef INCL_GPIBITMAPS
#undef INCL_DOSPROCESS
#undef INCL_SPL

#define INCL_GRE_JOURNALING
#define INCL_DDIBUNDLES
#define INCL_DDIFONTSTRUCS
#define INCL_DDIDEFS
#define INCL_DDIMISC
#include <pmddi.h>
#undef INCL_GRE_JOURNALING
#undef INCL_DDIBUNDLES
#undef INCL_DDIFONTSTRUCS
#undef INCL_DDIDEFS
#undef INCL_DDIMISC

#define INCL_WINP_SELECTIVE
#define INCL_WINP_SEI
#include <pmwinx.h>
#undef INCL_WINP_SELECTIVE
#undef INCL_WINP_SEI
#undef INCL_32                      /* CON3201 */


#include <prdconse.h>
#include <prddcone.h>
#include <prdpcone.h>

#define PRDMTYPE_INCL
#define PRDFTYPE_INCL
#define NO_CONSTANT_INCL
#include <prdinclt.h>
#undef NO_CONSTANT_INCL
#undef PRDMTYPE_INCL
#undef PRDFTYPE_INCL

#include <prdeextf.h>
#include <prdjextf.h>
#include <prdbtyp1.h>
#include <prdbextf.h>
#include <prdgextf.h>
#include <prdpextf.h>
#include <prdyextf.h>
#include <prdnextf.h>
#include <prdncone.h>
#include <prdfextf.h>
#include <prdztrcf.h>

extern USHORT    DRIVER_TYPE;

/**********************************************************************/
/*                                                                    */
/* FUNCTION     prdn_ProcessPage                                      */
/*                                                                    */
/* PARAMETERS   lpDCI   DCIData                                       */
/*                                                                    */
/* DESCRIPTION                                                        */
/*                                                                    */
/*  Only called from NewFrame - never Q_STD                           */
/*                                                                    */
/* This outputs a page to Prt/Spl, and performs any 1st page actions. */
/*                                                                    */
/* NOTE for direct DC, this will always do a PrtWrite, and thus will  */
/* detect an abort.                                                   */
/**********************************************************************/
SHORT prdn_ProcessPage(lpDCI DCIData )    /* CON3203 */


{

    USHORT      return_value;
    lpPDBI      PDBInstance;       /* Pointer to PDB Instance data        */

    PDBInstance = DCIData->DCIPdbInstance;

#ifdef DDT_BANDING
    /******************************************************************/
    /* Stop journalling if banding is active.                         */
    /******************************************************************/
    if ( prdn_BandingStopJournalling( DCIData ) != OK )
    {
        return( ERROR );
    }
#endif

    if ( DCIData->DCIPageNumber == 1 )
    {
        /**************************************************************/
        /* Do first page processing: open printer or spoolfile, and   */
        /* send any initialisation sequences.                         */
        /**************************************************************/
        if ( ( DCIData->Flags & QUEUED ) && DCIData->State == IMPLICIT )
        {
            /**********************************************************/
            /* Make SplQmOpen call.      PD00227                      */
            /**********************************************************/
            if ( !(DCIData->Flags & QM_OPEN_ISSUED) )
            {
               if (prde_OpenSpooler( PDBInstance) != OK)
               {
                   return ( ERROR_NEG );
               }
               DCIData->Flags |= QM_OPEN_ISSUED;
               DCIData->DCISplHandle = PDBInstance->PDBSplHandle;
            }
            /**********************************************************/
            /* In IMPLICIT document, we only issue SplQmStartDoc when */
            /* we know we are going to output a page. For the explicit*/
            /* case, this is done in PrepareNewDocument.              */
            /*                                                        */
            /* Note: the document name has been set up in CompleteOpen*/
            /**********************************************************/
            if ( SplQmStartDoc( (HSPL)DCIData->DCISplHandle,
                                (PSZ)DCIData->DCIDocName ) != OK )
            {
                return (ERROR_NEG);
            }

            DCIData->Flags |= QM_START_ISSUED;

        }
        /*********************************************************************/
        /* PD00495:                                                          */
        /* Do not open the printer if it is already open.  Attempting this   */
        /* will cause a sharing violation and will cause the user to cancel  */
        /* the job.  Then we leave the port open and the user must either    */
        /* reboot or get the port device driver to reset the port.           */
        /*********************************************************************/
        else if ( (DCIData->Flags & DIRECT) &&
                  (DCIData->State != RAW_IMPLICIT) &&
                  (DCIData->State != RAW_EXPLICIT) &&
                  (!(DCIData->Flags & PRINTER_OPEN)) )
        {
            /**********************************************************/
            /* Direct, first page, no rawdata. Thus we must open      */
            /* the printer.                                           */
            /**********************************************************/
            if ( (return_value = prdn_OpenPrinter(DCIData) ) != OK )
            {
                /* ERR_ABORT or ERR_PURGE */
                return( return_value );
            }
        }
    } /* ...if PageNumber = 1 */

    if ( (DCIData->State != RAW_IMPLICIT) &&
         (DCIData->State != RAW_EXPLICIT)    )
    {
        /**************************************************************/
        /* Call InitialisePrinter and PrintBand - allow for banding   */
        /**************************************************************/
        if ( DCIData->Flags & (QUEUED_RAW | DIRECT) )
        {
            if ( (return_value = prdn_SendInitAndPage(DCIData) ) != OK )
                return( return_value );

            /**********************************************************/
            /* The page has been output: now send a formfeed.         */
            /* Originally SendInitAndPage sent a formfeed.  But       */
            /* special processing is required for the last page.      */
            /* Inter-page SICs (no longer used) would go here.        */
            /**********************************************************/

            /**********************************************************/
            /* PD00139 : Don't output a formfeed if no drawing has    */
            /* been done.  4019 only. (Wrong-O - see 297)             */
            /* PD00297 : 00139 is undone here. Additionally for       */
            /*  the 4029, a REQ'D SPACE (x'FF') is needed to allow    */
            /*  consecutive formfeeds to eject a blank page. Here, the*/
            /*  x'FF' preceeds the formfeeds for all laser printers.  */
            /* PD00453 : 00297 is modified here so that we do not use */
            /*  the REQ'D SPACE in front of the formfeed. Just sending*/
            /*  the fromfeed works just fine and allows the 'print    */
            /*  blank pages' panel setting on the 4029s to function.  */
            /**********************************************************/
            if (DCIData->Flags & DRAWN_INTO )
            {
                if ( (return_value = prdp_PrintSimple( DCIData,
                                                       USE_GLOBAL_TABLE,
                                                       EST_FORM_FEED,
                                                       FNULL) ) != OK )
                {
                    return ( return_value );
                }
            }
        }
    }
    else
    {
        /**************************************************************/
        /* Had RawData call(s), so we ignore the band.  The page has  */
        /* already been written bt the RawData call(s).  Need to do a */
        /* formfeed here though, to prepare for the next page.        */
        /**************************************************************/
        if ( (return_value = prdp_PrintSimple( DCIData,
                                               USE_GLOBAL_TABLE,
                                               EST_FORM_FEED,
                                               FNULL) ) != OK )
        {
            /**********************************************************/
            /* ERR_ABORT, ERR_PURGE.                                  */
            /**********************************************************/
            return ( return_value );
        }
    }

    prdj_FreeBand( DCIData, &DCIData->DCICurrBand );

#ifdef DDT_BANDING
    /******************************************************************/
    /* Delete journal file if banding.                                */
    /******************************************************************/
    prdn_BandingDeleteJournal( DCIData );
#endif

    return( OK );

}


/**********************************************************************/
/*                                                                    */
/* FUNCTION     prdn_ProcessLastPage                                  */
/*                                                                    */
/* PARAMETERS   lpDCI   DCIData                                       */
/*                                                                    */
/* DESCRIPTION                                                        */
/*                                                                    */
/* This outputs a page to the printer or spooler, and performs any    */
/* required open/closing actions for the 1st/last page.               */
/*                                                                    */
/* For the 1st page, the printer is opened, and initialised; or       */
/* SplQmStartDoc issued if IMPLICIT.                                  */
/*                                                                    */
/* If Q_STD, CreateStdSpoolFile outputs the metafile to the spooler   */
/*                                                                    */
/* If in a RAW-xx state, then the band is ignored.                    */
/*                                                                    */
/* For the last page, some formfeed processing is done, and the       */
/* printer is closed or SplQmEndDoc issued.                           */
/*                                                                    */
/* Finally, the band is freed.                                        */
/*                                                                    */
/* NOTE: aborting is not always noticed (Direct), but this does not   */
/* matter. ProcessLastPage called from StartDoc, EndDoc, BeginClose   */
/* only: these ignore ERR_ABORT/ERR_PURGE return codes.               */
/*                                                                    */
/**********************************************************************/

SHORT prdn_ProcessLastPage(lpDCI DCIData ) /* CON3203 */


{

    USHORT      return_value;
    USHORT      usJob;
    lpPDBI      PDBI;

    PDBI = DCIData->DCIPdbInstance;

    if ( DCIData->Flags & QUEUED_STD )
    {
        /**************************************************************/
        /* Note: StartDoc is enforced for Q_STD jobs.                 */
        /**************************************************************/

        /**************************************************************/
        /* Send metafile to spooler.                                  */
        /**************************************************************/
        prdn_CreateSTDSpoolFile( DCIData );

        /**************************************************************/
        /* End the document.                                          */
        /**************************************************************/
        if ( !( usJob = SplQmEndDoc((HSPL)DCIData->DCISplHandle) ) )
        {
            DCIData->JobId = 0;
            return( ERROR_NEG );
        }

        DCIData->JobId = usJob;
        DCIData->Flags &= ~QM_START_ISSUED;

        /**********************************************************************/
        /* PD00760 : Remove the following stmt to prevent multiple calls to   */
        /* SplQmOpen.                                                         */
        /**********************************************************************/
//      DCIData->Flags &= ~QM_OPEN_ISSUED;      /* PD00227      */

NO_STD_DOCUMENT: ; /* just free band and quit */

    }
    else if (DCIData->Flags & (DIRECT | QUEUED_RAW)) /* !Q_STD, !INFO */
    {

#ifdef DDT_BANDING
        /**************************************************************/
        /* Stop journalling if banding.                               */
        /**************************************************************/
        if ( prdn_BandingStopJournalling( DCIData ) != OK )
        {
            return( ERROR );
        }
#endif

        switch( DCIData->State )
        {
            case EXPLICIT:

        /*********************************************************************/
        /* PD00495:                                                          */
        /* Do not open the printer if it is already open.  Attempting this   */
        /* will cause a sharing violation and will cause the user to cancel  */
        /* the job.  Then we leave the port open and the user must either    */
        /* reboot or get the port device driver to reset the port.           */
        /*********************************************************************/

                if ( (DCIData->DCIPageNumber == 1) &&
                     (DCIData->Flags & DIRECT) &&
                     (!(DCIData->Flags & PRINTER_OPEN)) )
                {
                    /**************************************************/
                    /* Open printer                                   */
                    /**************************************************/
                    if ( (return_value = prdn_OpenPrinter(DCIData) )
                                                                 != OK )
                    {
                        /**********************************************/
                        /* Can be ERR_ABORT or ERR_PURGE              */
                        /**********************************************/
                        return( return_value );
                    }
                }

                /******************************************************/
                /* Call InitialisePrinter, and PrintBand - allow for  */
                /* banding here.                                      */
                /******************************************************/
                if ( (return_value = prdn_SendInitAndPage(DCIData) )
                                != OK )
                {
                    /**************************************************/
                    /* ERR_ABORT / ERR_PURGE / ERROR                  */
                    /**************************************************/
                    return( return_value );
                }

                /******************************************************/
                /* Send out end of job formfeed/SIC.                  */
                /******************************************************/
                prdn_JobEndFeedOrSIC( DCIData );

                /******************************************************/
                /* Do PrtClose                                        */
                /******************************************************/
                prdn_CloseDevice( DCIData );

                break;

            case IMPLICIT:
                /******************************************************/
                /* May not output the page if nothing was drawn.  If  */
                /* this is also the first page, then there is no      */
                /* document at all.                                   */
                /******************************************************/
                if ( DCIData->Flags & DRAWN_INTO )
                {
                     /*************************************************/
                     /* Page has been written to.                     */
                     /*************************************************/
                     if ( DCIData->DCIPageNumber == 1)
                     {
                         /*********************************************/
                         /* First page - open device                  */
                         /*********************************************/
                         /*********************************************/
                         /* PD00515                                   */
                         /*********************************************/
                         if ( (DCIData->Flags & DIRECT) &&
                              (!(DCIData->Flags & PRINTER_OPEN)) )
                         {
                             if ( (return_value =
                                   prdn_OpenPrinter(DCIData) )!= OK )
                             {
                                 return( return_value );
                             }
                         }
                         else if ( DCIData->Flags & QUEUED )
                         {
                             /************************************************/
                             /* Make SplQmOpen call.      PD00227            */
                             /************************************************/
                             if ( !(DCIData->Flags & QM_OPEN_ISSUED) )
                             {
                                if (prde_OpenSpooler( PDBI ) != OK)
                                {
                                  return ( ERROR_NEG );
                                }
                                DCIData->Flags |= QM_OPEN_ISSUED;
                                DCIData->DCISplHandle = PDBI->PDBSplHandle;
                             }
                             if ( SplQmStartDoc(
                                      (HSPL)DCIData->DCISplHandle,
                                      (PSZ)DCIData->DCIDocName ) != OK )
                                 return ( ERROR );
                         }

                     } /* ...if 1st page */

                     /*************************************************/
                     /* Call InitialisePrinter and PrintBand - allow  */
                     /* for banding here.                             */
                     /*************************************************/
                     if ( (return_value = prdn_SendInitAndPage(DCIData))
                                                                 != OK )
                     {
                         return( return_value );
                     }

                     /*************************************************/
                     /* Send out end of job formfeed/SIC.             */
                     /*************************************************/
                     prdn_JobEndFeedOrSIC( DCIData );

                     prdn_CloseDevice( DCIData );

                }
                else /* ...!DRAWN_INTO */
                {
                    if ( DCIData->DCIPageNumber == 1 )
                    {
                        /**********************************************/
                        /* Null document: ignore it.                  */
                        /**********************************************/
                    }
                    else
                    {
                        /**********************************************/
                        /* Document opened, but nothing on this final */
                        /* page. Don't output anything, just close.   */
                        /**********************************************/
                        prdn_CloseDevice( DCIData );
                    }

                }  /* ... if drawn */

                break;

            case RAW_IMPLICIT:
            case RAW_EXPLICIT:
                /******************************************************/
                /* Send out end of job formfeed/SIC.  This routine    */
                /* handles conditional processing.                    */
                /******************************************************/
                prdn_JobEndFeedOrSIC( DCIData );

                prdn_CloseDevice( DCIData );

                break;

        } /* ...switch */

    } /* ...if Q_STD */

    prdj_FreeBand( DCIData, &DCIData->DCICurrBand );

#ifdef DDT_BANDING
    /******************************************************************/
    /* Delete journal file if banding.                                */
    /******************************************************************/
    prdn_BandingDeleteJournal( DCIData );
#endif

    return( OK );

}


/**********************************************************************/
/*                                                                    */
/* FUNCTION     prdn_SendInitAndPage                                  */
/*                                                                    */
/* PARAMETERS   lpDCI   DCIData                                       */
/*                                                                    */
/* DESCRIPTION                                                        */
/*                                                                    */
/*    output init codes and then the band(s) to the device.           */
/* Only called if Q_RAW or DIRECT                                     */
/* Called from ProcessPage & ProcessLastPage.                         */
/* Does not output formfeed/SIC.                                      */
/*                                                                    */
/**********************************************************************/
USHORT prdn_SendInitAndPage(lpDCI DCIData )


{

    USHORT       return_value;

    /******************************************************************/
    /* Do initialisation.                                             */
    /******************************************************************/
    if ( (return_value = prdn_InitialisePrinter(DCIData) ) != OK )
    {
        /**************************************************************/
        /* ERR_ABORT, ERR_PURGE.                                      */
        /**************************************************************/
        return( return_value );
    }

    /******************************************************************/
    /* CODE1 : Comment out the ifndef banding so that code coverage   */
    /* works. If the driver does not require banding then re-instate  */
    /* this code.                                                     */
    /******************************************************************/
// #ifndef DDT_BANDING   */
//  /******************************************************************/
//  /* Print the band                                                 */
//  /******************************************************************/
//  if ( (return_value = prdp_PrintBand(DCIData)) != OK )
//  {
//      /**************************************************************/
//      /* May be aborting/purging.                                   */
//      /**************************************************************/
//      return ( return_value );
//  }
// #else ifdef DDT_BANDING

    /******************************************************************/
    /* Set flag to indicate that this is first band to proccess.      */
    /******************************************************************/
    DCIData->FirstBand = TRUE;                /* PD00473              */
    DCIData->BandCount = 0;                   /* PD00520              */

    /******************************************************************/
    /* Common processing for all Bands on Direct DC...  The loop      */
    /* handles each Band (assuming there is at least a first) until   */
    /* BandLowY (which is the lowest point down the page reached so   */
    /* far) is less than or equal to JournLowY(which is the lowest    */
    /* point in the Journal/Page The loop always breaks from the      */
    /* middle.                                                        */
    /******************************************************************/
    do
    {
        /**************************************************************/
        /* Print the current band.                                    */
        /**************************************************************/
        return_value = prdp_PrintBandRaster( DCIData ) ;

        DCIData->FirstBand = FALSE;            /* PD00473            */
        DCIData->BandCount++;                  /* PD00520            */

        if (return_value != OK )
        {
            /**********************************************************/
            /* May be aborting/purging.                               */
            /**********************************************************/
            return ( return_value );
         }

        /**************************************************************/
        /* Update the Band lowest Y coordinate to the lower left Y    */
        /* coordinate of the Band just processed via function         */
        /* prdj_UpdateBandCoordinates.  This returns TRUE if this is  */
        /* the last band, FALSE otherwise.  If this was the last band */
        /* then break from the loop.                                  */
        /**************************************************************/
        if ( prdj_UpdateBandCoordinates( DCIData ) )
            break;

        /**************************************************************/
        /* Still Bands to do, so:                                     */
        /* - free the current band                                    */
        /* - make a new Band                                          */
        /* - reset the DC Instance Data (the DC State)                */
        /* - then replay the Graphics Engine Journal.                 */
        /**************************************************************/

        /**************************************************************/
        /* Free the current band.                                     */
        /**************************************************************/
        (void)prdj_FreeBand( DCIData, &DCIData->DCICurrBand );

        /**************************************************************/
        /* Make a new band                                            */
        /**************************************************************/
        TRACE4(TFUNC, "Make Next Band", FNULL, 0);

        if ( prdj_MakeBand( DCIData,
                            &DCIData->DCICurrBand) != OK )
        {
            TRACE4(TFUNC, "Failed to make band", FNULL, 0);
            return ( ERROR );
        }

        /**************************************************************/
        /* Reset DC Instance                                          */
        /**************************************************************/
        (void)prde_ResetDC( DCIData, FNULL );

        /**************************************************************/
        /* Replay the Journal to construct the next Band.             */
        /**************************************************************/
        if ( GrePlayJournalFile( DCIData->DcH,
                                 DCIData->DCIJournHandle ) != OK )
        {
            TRACE4(TFUNC,"Fail PlayJournal", FNULL, 0);
            return ( ERROR );
        }

    } while (TRUE);

// #endif /* ifdef DDT_BANDING */

    /******************************************************************/
    /* Note: formfeeds/SICs done by ProcessPage/ProcessLastPage.      */
    /******************************************************************/

    return( OK );

}


/**********************************************************************/
/* prdn_JobEndFeedOrSIC                                               */
/*                                                                    */
/* Send out the formfeed or SIC required for the end of a job.        */
/* This routine handles the rawdata conditional processing.           */
/**********************************************************************/
USHORT prdn_JobEndFeedOrSIC(lpDCI DCIData )


{
    /******************************************************************/
    /* Local variables                                                */
    /******************************************************************/
    USHORT               return_value;
    lpPDBI               PDBI;
    lpDDTType            pDDT;
    BYTE                 Byte;

    /******************************************************************/
    /* initialise local pointers                                      */
    /******************************************************************/
    PDBI = DCIData->DCIPdbInstance;
    pDDT = &(DCIData->DCIPdbInstance->DDT);


    if ( (pDDT->DDTFormFlags & DDT_VAR_FORM_FEED_CONTROL) &&
         (DCIData->State == RAW_IMPLICIT ||
          DCIData->State == RAW_EXPLICIT) )
    {
        /**************************************************************/
        /* Do formfeed control processing.                            */
        /* Note: printers with VAR_FORM_FEED_CONTROL set must never   */
        /* require an end of job SIC.                                 */
        /**************************************************************/

        /**************************************************************/
        /* Add a form feed to the data stream if required.            */
        /*                                                            */
        /* A formfeed is NEVER output if the data stream ended in     */
        /* 0x1B6F - this is a special "code" between apps like        */
        /* DisplayWrite and the driver.  If the last byte in the      */
        /* data stream is a formfeed the driver only adds             */
        /* another formfeed if the FFControl state in the PDB is      */
        /* set to compulsory.                                         */
        /*                                                            */
        /* Only use the form feed conditional processing if the last  */
        /* page of the document was raw and this is a Direct DC.  We  */
        /* must avoid adding a formfeed in the Queued Raw case as the */
        /* driver could end up adding two formfeeds when the          */
        /* FFControl is set to compulsory - one going onto the queue  */
        /* and another one coming off it.                             */
        /*                                                            */
        /**************************************************************/
        if ( (DCIData->Flags & DIRECT) &&
             (DCIData->FFstate != prdg_FFx1b6f) )
        {
            if (( PDBI->FFcontrol == prdg_FFcompulsory ) ||
                ( PDBI->FFcontrol == prdg_FFconditional &&
                              DCIData->FFstate == prdg_FFtext) )
            {
                /******************************************************/
                /* Formfeed required so use prdp_PrintSimple to       */
                /* output it.                                         */
                /******************************************************/
                TRACE4(TFUNC, "Issue Formfeed", FNULL, 0);

                if ( (return_value = prdp_PrintSimple(
                                       DCIData,
                                       USE_GLOBAL_TABLE,
                                       EST_FORM_FEED,
                                       FNULL) ) != OK )
                {
                    return ( return_value );
                }
             }
        }
    } /* ...if VAR_FF_CONTROL && State==RAW_xx */
    else
    {
        /**************************************************************/
        /* Issue the end of job command - this may be a SIC or        */
        /* a formfeed, depending on the printer.                      */
        /*                                                            */
        /* Only do this if drawing has taken place on the page. Thus  */
        /* StartDoc-EndDoc will not give a blank page. Also           */
        /* StartDoc (Draw) NewFrame EndDoc will give one page, and no */
        /* final blank page.                                          */
        /*                                                            */
        /* NB this will not work for banding on 42XX due to           */
        /* printer head moving down to top of each band (see          */
        /* PrintBandRaster).                                          */
        /*                                                            */
        /* For 4019 driver, always issue the SIC - as this does not   */
        /* cause a feed if no drawing has occurred, and is required   */
        /* to set the printer back to the correct state after a job.  */
        /* Similarly for 3816 printers.                               */
        /*                                                            */
        /* DIAL/NILE : Nile/Tibers also use SICs.                     */
        /**************************************************************/
        if ( (DCIData->Flags & DRAWN_INTO) ||
             ( (pDDT->DDTDriverType == DDT_IBM42XX_DRV) &&
               ( (PDBI->PrinterType == IBM_NILE_9) ||
                 (PDBI->PrinterType == IBM_TIBER_9 ) ||
                 (PDBI->PrinterType == IBM_NILE_24) ||
                 (PDBI->PrinterType == IBM_TIBER_24 ) ||
                 (PDBI->PrinterType == IBM_4226 ) ||      /* PD00283 */
                 (PDBI->PrinterType == IBM_2390_PS1 )
               )
             )
           )
        {
            /******************************************************************/
            /* PD00314 : Nile/Tiber/4226 should send a SIC only if            */
            /* DIRECT                                                         */
            /******************************************************************/
            if ( (pDDT->DDTDriverType == DDT_IBM42XX_DRV) &&
                 ((DCIData->DCIPdbInstance->PrinterType > IBM_4224_MONO) &&
                  (DCIData->DCIPdbInstance->PrinterType <= IBM_2390_PS1)) &&
                 !(DCIData->Flags & DIRECT) )
                return(0);

            Byte = 0;

            if ( (return_value = prdp_PrintSimple(
                                   DCIData,
                                   USE_PRINTER_TABLE,
                                   DCT_END_OF_JOB,
                                   (PBYTE)&Byte) ) != OK )
            {
                return ( return_value );
            }
        }
    }
}



/**********************************************************************/
/*                                                                    */
/* prdn_BandingStopJournalling                                        */
/*                                                                    */
/*   Stop the journal file when banding. Called form ProcessPage      */
/* and ProcessLastPage.                                               */
/*                                                                    */
/**********************************************************************/

USHORT prdn_BandingStopJournalling(lpDCI DCIData )


{
    /******************************************************************/
    /* Local varaibles                                                */
    /******************************************************************/
    lpDDTType            pDDT;

    /******************************************************************/
    /* Some local pointers                                            */
    /******************************************************************/
    pDDT = &(DCIData->DCIPdbInstance->DDT);

    if ( ( pDDT->DDTBandsPerPage != 1 ) &&
         ( DCIData->Flags & (DIRECT | QUEUED_RAW) ) )
    {
        TRACE4(TFUNC, "Stop Journal", &DCIData->DCIJournHandle, 1);

        /**************************************************************/
        /* Stop the journal file.                                     */
        /**************************************************************/
        if ( GreStopJournalFile( DCIData->DcH,
                                 DCIData->DCIJournHandle) != OK )
        {
            TRACE4(TFUNC, "Stop Journal failed", FNULL, 0);
            return ( ERROR );
        }
    }
    return( OK );
}



/**********************************************************************/
/* Delete journal file (for banding)                                  */
/**********************************************************************/
USHORT prdn_BandingDeleteJournal(lpDCI DCIData )


{
    /******************************************************************/
    /* Some local varaibles                                           */
    /******************************************************************/
    lpDDTType            pDDT;

    /******************************************************************/
    /* Some local variables                                           */
    /******************************************************************/
    pDDT = &(DCIData->DCIPdbInstance->DDT);

    /******************************************************************/
    /* For Direct DCs (where there was more than one Band), and       */
    /* Queued DCs of format IBM_Q_RAW) delete the                     */
    /* Graphics Engine Journal.                                       */
    /******************************************************************/
    if ( ( pDDT->DDTBandsPerPage != 1 ) &&
         ( DCIData->Flags & (DIRECT | QUEUED_RAW) ) )
    {
        TRACE4(TFUNC, "Delete Journal",&DCIData->DCIJournHandle,1);

        if ( GreDeleteJournalFile(DCIData->DCIJournHandle) != OK )
        {
            TRACE4(TFUNC, "Fail DeleteJournal", FNULL, 0);
            return ( ERROR );
        }
    }

    return( OK );
}


