/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1992 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 source code is provided to you solely for       */
/*    the purpose of assisting you in your development of OS/2 device        */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Developer Connection Device Driver       */
/*    Source Kit for OS/2. This Copyright statement may not be removed.      */
/*                                                                           */
/*****************************************************************************/
/**************************************************************************
 *
 * SOURCE FILE NAME = PRDPERR
 *
 * DESCRIPTIVE NAME =
 *
 *
 * VERSION
 *
 * DATE
 *
 * DESCRIPTION
 *
 * FUNCTIONS   prdp_PrintError
 *
 * ENTRY POINTS:
 *
 * DEPENDENCIES:
 *
 * NOTES
 *
 *
 * STRUCTURES
 *
 * EXTERNAL REFERENCES
 *
 * EXTERNAL FUNCTIONS
 *
*/

#define INCL_32                     /* CON3201 */
#define INCL_DOSPROCESS             /* CON3201 */
#define INCL_DOSSEMAPHORES
#define INCL_GREALL
#define INCL_GPIPRIMITIVES
#define INCL_WINHEAP
#define INCL_GPIBITMAPS
#define INCL_GPIERRORS
#define INCL_DOSERRORS
#define INCL_DOSMODULEMGR
#define INCL_SPL
#include <os2.h>
#undef INCL_DOSPROCESS              /* CON3201 */
#undef INCL_DOSSEMAPHORES
#undef INCL_GREALL
#undef INCL_GPIPRIMITIVES
#undef INCL_WINHEAP
#undef INCL_GPIBITMAPS
#undef INCL_GPIERRORS
#undef INCL_DOSERRORS
#undef INCL_DOSMODULEMGR
#undef INCL_SPL

#define INCL_DDIBUNDLES
#define INCL_DDIFONTSTRUCS
#define INCL_DDIDEFS
#include <pmddi.h>
#undef INCL_DDIBUNDLES
#undef INCL_DDIFONTSTRUCS
#undef INCL_DDIDEFS

#define INCL_WINP_SELECTIVE
#define INCL_WINP_SEI
#include <pmwinx.h>
#undef INCL_WINP_SELECTIVE
#undef INCL_WINP_SEI
#undef INCL_32                         /* CON3201 */

#include <prdmcone.h>
#include <prdpcone.h>

#define NO_SYS
#define NO_CONSTANT_INCL
#include <prdinclt.h>
#undef NO_CONSTANT_INCL
#undef NO_SYS

#include <prdgextf.h>
#include <prdpextf.h>
#include <prdyextf.h>

extern HMODULE  prdd_ModHandle;


/**********************************************************************/
/*                                                                    */
/*   FUNCTION: prdp_PrintError                                        */
/*                                                                    */
/*   PARAMETERS:                                                      */
/*                                                                    */
/*   USHORT       ReturnedError;       The error which was returned   */
/*                                     by DOS                         */
/*   lpPDBI       PDBInstance;         Pointer to the PDB Instance    */
/*                                     data                           */
/*   DESCRIPTION:                                                     */
/*                                                                    */
/*   This function responds to printer errors and reports them to the */
/*   the user using a message box (SplMessageBox).  The user can      */
/*   respond to the message with either retry, cancel or error and    */
/*   the function takes the appropriate action for each of these      */
/*   possibilities.                                                   */
/*                                                                    */
/**********************************************************************/
/*CON3201
USHORT  prdp_PrintError( ReturnedError, PDBInstance )

USHORT       ReturnedError;
lpPDBI       PDBInstance;
*/

USHORT  prdp_PrintError(USHORT       ReturnedError,
                        lpPDBI       PDBInstance)

{
#define TFUNC "prdp_PrintError"
    /******************************************************************/
    /* Local variables                                                */
    /******************************************************************/
    char         Caption[CAPTION_LENGTH];  /* The message box caption */
    char         Message[MESSAGE_LENGTH];  /* The message box message */
    HMODULE      ModuleHandle;             /* The handle to the module*/

    TRACE8(TFUNC, "RetError", &ReturnedError, 1);
    TRACE8(TFUNC, "PDBInstance", &PDBInstance, 1);

    /******************************************************************/
    /* Obtain the module handle which will allow us to get the text   */
    /* resources.                                                     */
    /******************************************************************/
    ModuleHandle = prdd_ModHandle;

    /******************************************************************/
    /* Get the message box caption string.                            */
    /******************************************************************/
    if ( WinLoadString(  hab,
                         ModuleHandle, IDS_SMB_CAPTION,
                         CAPTION_LENGTH, (PSZ)Caption) == 0)
        return(PRINT_CANCEL);

    /******************************************************************/
    /* Get the appropriate message string depending on the error:     */
    /*     ERROR_BAD_UNIT - powered off / disconnected                */
    /*     ERROR_WRITE_FAULT - offline                                */
    /*     ERROR_OUT_OF_PAPER - no paper                              */
    /*     other - unexpected error                                   */
    /******************************************************************/
    switch (ReturnedError)
    {
        case ERROR_BAD_UNIT:
            if ( WinLoadMessage(  hab,
                                  ModuleHandle, IDM_NOT_RESPONDING,
                                  MESSAGE_LENGTH, (PSZ)Message) == 0)
                return(PRINT_CANCEL);
            break;

        case ERROR_WRITE_FAULT:
            if ( WinLoadMessage(  hab,
                                  ModuleHandle, IDM_IO_ERROR,
                                  MESSAGE_LENGTH, (PSZ)Message) == 0)
                return(PRINT_CANCEL);
            break;

        case ERROR_OUT_OF_PAPER:
            if ( WinLoadMessage(  hab,
                                  ModuleHandle, IDM_PAPEROUT,
                                  MESSAGE_LENGTH, (PSZ)Message) == 0)
                return(PRINT_CANCEL);
            break;

        default:
            if ( WinLoadMessage(  hab,
                                  ModuleHandle, IDM_DEF_MSG,
                                  MESSAGE_LENGTH, (PSZ)Message) == 0)
                return(PRINT_CANCEL);

    } /* switch (ReturnedError) */

    /******************************************************************/
    /* Prompt User with Message Box and wait for reply.               */
    /* Possible replies are MBID_RETRY, MBID_CANCEL or MBID_ERROR     */
    /******************************************************************/
    TRACE4(TFUNC, "Call Message Box", FNULL, 0);
    TRACE4(TFUNC, "PDBLogAddress",PDBInstance->PDBLogAddress, 4);

    if ( SplMessageBox(PDBInstance->PDBLogAddress,
                       SPLINFO_DDERROR |
                           SPLINFO_ERROR |
                              SPLINFO_USERINTREQD,
                       SPLDATA_PRINTERJAM,
                       (PSZ)Message,
                       (PSZ)Caption,
                       (USHORT)0,
                       MB_RETRYCANCEL | MB_ERROR |
                          MB_SYSTEMMODAL) == MBID_RETRY )
    {
        /**************************************************************/
        /* If response is to retry the operation then return          */
        /* indicating retry operation                                 */
        /**************************************************************/
           return(PRINT_RETRY);
    }

        return(PRINT_CANCEL);

}
#undef TFUNC
