/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1992 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 source code is provided to you solely for       */
/*    the purpose of assisting you in your development of OS/2 device        */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Developer Connection Device Driver       */
/*    Source Kit for OS/2. This Copyright statement may not be removed.      */
/*                                                                           */
/*****************************************************************************/
/**************************************************************************
 *
 * SOURCE FILE NAME = PRDMJOB
 *
 * DESCRIPTIVE NAME =
 *
 *
 * VERSION
 *
 * DATE
 *
 * DESCRIPTION
 *
 * FUNCTIONS   prdm_JobSetUpDlgProc
 *             prdm_EnterJobSetUp
 *             prdm_SetupSingleFormList
 *
 * ENTRY POINTS:
 *
 * DEPENDENCIES:
 *
 * NOTES
 *
 *
 * STRUCTURES
 *
 * EXTERNAL REFERENCES
 *
 * EXTERNAL FUNCTIONS
 *
*/

#define INCL_32                         /* Convert to C/SET2    CON3201       */
#define INCL_DOSPROCESS                 /* Convert to C/SET2    CON3201       */
#define INCL_WINHELP
#define INCL_DOSSEMAPHORES
#define INCL_GPIERRORS
#define INCL_GPIPRIMITIVES
#define INCL_WINHEAP
#define INCL_GPIBITMAPS
#define INCL_DOSMODULEMGR
#define INCL_WINFRAMEMGR
#define INCL_WINLISTBOXES
#define INCL_WINBUTTONS
#define INCL_WINERRORS
#define INCL_WINDIALOGS
#define INCL_WINSHELLDATA
#define INCL_WINSWITCHLIST
#define INCL_WINENTRYFIELDS
#define INCL_WINMESSAGEMGR
#define INCL_WININPUT
#define INCL_WINMENUS
#define INCL_WINWINDOWMGR
#define INCL_WINPOINTERS
#include <os2.h>
#undef INCL_DOSPROCESS                  /* Convert to C/SET2    CON3201       */
#undef INCL_DOSSEMAPHORES
#undef INCL_GPIERRORS
#undef INCL_GPIPRIMITIVES
#undef INCL_WINHEAP
#undef INCL_GPIBITMAPS
#undef INCL_DOSMODULEMGR
#undef INCL_WINFRAMEMGR
#undef INCL_WINLISTBOXES
#undef INCL_WINBUTTONS
#undef INCL_WINERRORS
#undef INCL_WINDIALOGS
#undef INCL_WINSHELLDATA
#undef INCL_WINSWITCHLIST
#undef INCL_WINENTRYFIELDS
#undef INCL_WINMESSAGEMGR
#undef INCL_WININPUT
#undef INCL_WINMENUS
#undef INCL_WINWINDOWMGR
#undef INCL_WINPOINTERS
#undef INCL_WINHELP

#define INCL_DDIBUNDLES
#define INCL_DDIFONTSTRUCS
#define INCL_DDIDEFS
#include <pmddi.h>
#undef INCL_DDIBUNDLES
#undef INCL_DDIFONTSTRUCS
#undef INCL_DDIDEFS

#define INCL_WINP_SELECTIVE
#define INCL_WINP_SEI
#include <pmwinx.h>
#undef INCL_WINP_SELECTIVE
#undef INCL_WINP_SEI

#define INCL_WINSHELLDATA
/* #include <pmshlp.h>                                              DLM01 */
#define INCL_WINSHELLDATA
#undef INCL_32                          /* Convert to C/SET2    CON3201       */

#include <prdconse.h>
#include <prddcone.h>
#include <prdmcone.h>

#define INCL_HELP
#define PRDMTYPE_INCL
#define NO_CONSTANT_INCL
#include <prdinclt.h>
#undef NO_CONSTANT_INCL
#undef INCL_HELP
#undef PRDMTYPE_INCL

#include <prdmextf.h>
#include <prdmhelp.h>
#include <prduextf.h>

extern lpDDTType              DDT [];
extern DModeDataType          DMData;
extern lpDMSettings           pDMSettings;
extern pDMDriverStruc         pDMDrivData;
extern CHAR                   szCaption[40];
extern CHAR                   szMessage[SLEN_BOX_MESSAGE];
extern USHORT                 DRIVER_TYPE;
extern HWND                   PPhwnd;              /* PD00364                 */

/******************************************************************************/
/*  Variables used to store single/dual form job settings across calls to     */
/*  prdm_JobSetUpDlgProc.                                                     */
/******************************************************************************/
USHORT   DMPerJobFormType;
BOOL     DMDualFormSupport;

USHORT   DMNoOfCodePageFonts;  /* Number of code page fonts                   */
                               /* displayed as avail default fonts            */
BOOL     DMCP850Resident;      /* Set on if the code page 850 is              */
                               /* resident - e.g. 4224 and X24E               */





/******************************************************************************/
/*                                                                            */
/*   FUNCTION: prdm_JobSetUpDlgProc                                           */
/*                                                                            */
/*   PARAMETERS:                                                              */
/*                                                                            */
/*   Standard dialog box control procedure parameter block                    */
/*                                                                            */
/*   HWND    hwnd;                                                            */
/*   USHORT  msg;                                                             */
/*   MPARAM  lparam1;                                                         */
/*   MPARAM  lparam2;                                                         */
/*                                                                            */
/*   DESCRIPTION:                                                             */
/*                                                                            */
/*   This function allows the user to specify the printer "set-up"            */
/*   for a single job.                                                        */
/*                                                                            */
/******************************************************************************/
#if 0
MRESULT pascal far _loadds prdm_JobSetUpDlgProc( hwnd,
                                                 msg,
                                                 lparam1,
                                                 lparam2 )

HWND       hwnd;
USHORT     msg;
MPARAM     lparam1;
MPARAM     lparam2;
#endif

MRESULT prdm_JobSetUpDlgProc( HWND   hwnd,                         /* CON3201 */
                              USHORT msg,                          /* CON3201 */
                              MPARAM lparam1,                      /* CON3201 */
                              MPARAM lparam2 )                     /* CON3201 */

{
#define TFUNC "prdm_JobSetUp"

    /**************************************************************************/
    /*  Local Variables                                                       */
    /**************************************************************************/
    MRESULT      DlgResult;    /* Result of a call to Win.. function          */
    USHORT       WndId;        /* ID for selecting items in the               */
                               /* dialog box                                  */
 /* sForm far *  Form; */      /* Pointer to form data structure for          */
                               /* stepping through the forms                  */
 /* char far *   cp;   */      /* Pointer for accessing the text              */
    sForm     *  Form;         /* Pointer to form data structure for  CON3201 */
                               /* stepping through the forms                  */
    char     *   cp;           /* Pointer for accessing the text      CON3201 */
    lpDDTType    pDDT;         /* Pointer to DDT for this printer             */
    USHORT       i;            /* Loop variable                               */
    USHORT       PrinterType;  /* Current printer type                        */
    lpDVTSourceList   pSourceInfo;
                               /* Source configurations list                  */
    PBYTE        pSource;      /* Working pointers                            */
    PBYTE        pDest;        /*               .............                 */
    USHORT       LocForm1;     /* Index of form                               */
    USHORT       LocForm2;     /* Index of form                               */
    USHORT       FormCnt;      /* Count of forms processed in loop            */
    USHORT       PaperCnt;     /* Count of paper forms in loop                */
    BOOL         CheckSwitch;
    CHAR         szTaskTitle[60];
    ULONG        DrvDataFormNo1;     /* return form index from                */
    ULONG        DrvDataFormNo2;     /*   prdm_FindFormNumber                 */
    BOOL         Result;
    SHORT        j;
    USHORT         CheckBoxValue;    /* PD00769                       */
    HWND        hwndResult;    /* CON3201 result from WinWindowFromID, later  */
                               /* later used in WinEnableWindow functions     */

    TRACE8(TFUNC, "Entry", FNULL, 0);

    /**************************************************************************/
    /*  Get the current Printer Type and then the correct DDT.  Note that the */
    /*  user cannot change the current printer type while in the Job Set Up   */
    /*  box.  Hence the printer type held in DMSettings and DMDrivData will   */
    /*  always be the same.  Also DMSettings will contain the default values  */
    /*  for that printer type.                                                */
    /**************************************************************************/
    PrinterType = pDMSettings->PrinterType;
    pDDT = DDT[PrinterType];

    switch ( msg )
    {
        case WM_HELP:
            /******************************************************************/
            /*  PD00199 : The message is always going to go to the default    */
            /*  handler, but give the driver a chance to do a little bit of   */
            /*  processing first.                                             */
            /******************************************************************/
            (VOID) prdm_HelpMessageProcessing ( hwnd, msg, lparam1, lparam2 );

            /******************************************************************/
            /*  Now pass message to the default message handler.              */
            /******************************************************************/
            return(WinDefDlgProc( hwnd, msg, lparam1, lparam2 ));


        case WM_CLOSE:
            /******************************************************************/
            /*  Trap Close from system menu Note: this will fall into         */
            /*  WM_COMMAND with CANCEL set                                    */
            /******************************************************************/
/*          SHORT1FROMMP(lparam1) = DB_PSH_JPCANCEL;         /* CON3201 */
            lparam1 = MPFROM2SHORT( DB_PSH_JPCANCEL,         /*CON3201*/
                                    SHORT2FROMMP(lparam1) ); /*CON3201*/

        case WM_COMMAND:
            /******************************************************************/
            /*  The message is a command (ie a button) so switch depending on */
            /*  which button it was.                                          */
            /******************************************************************/
            Result = FALSE;
            switch ( SHORT1FROMMP(lparam1) )
            {
                case DB_PSH_JPENTER:
                    /**********************************************************/
                    /*  DEBUG_SEGMENTS: Change this to be follow method used  */
                    /*  in prdm_MainDlgProc: fall through to the CANCEL       */
                    /*  processing if EnterJSU successful.                    */
                    /**********************************************************/
                    if ( !(Result = prdm_EnterJobSetUp(hwnd) ) )
                    {
                        break;
                    }
                    /**********************************************************/
                    /*  ...  else fall through to release memory, disable     */
                    /*  help.  End dialog with TRUE..                         */
                    /**********************************************************/

                case DID_CANCEL:
                case DB_PSH_JPCANCEL:
                    /**********************************************************/
                    /*  End the dialog routine with FALSE..                   */
                    /**********************************************************/
                    prdm_DisableHelp();

                    /**********************************************************/
                    /*  DEBUG_SEGMENTS : free up the font table memory here   */
                    /*  (as in prdm_MainDlgProc)                              */
                    /**********************************************************/
                    prdm_ReleaseFontTableMemory();

                    WinDismissDlg( hwnd, Result );
                    break;

                default:
                    break;
            }
            /*.. switch (SHORT1FROMMP(lparam1)) ..............................*/

            break;

        case WM_INITDLG:
            /******************************************************************/
            /*  PD00364 : Setting Global variable to the main job properties  */
            /*  dialog.                                                       */
            /******************************************************************/
            PPhwnd = hwnd;

            /******************************************************************/
            /*  Turn off 'Close' and 'Task Manager' options on the system     */
            /*  menu.                                                         */
            /******************************************************************/
/*          prdm_RemoveMenuOptions( hwnd ); */

            /******************************************************************/
            /*  Build the window title - this consists of: - "Job Set-Up: " ..*/
            /*  picked up from resources - the printer type ..  eg.           */
            /*  ProPrinter II - the printer name ..  eg.  "PRINTER1" (in      */
            /*  brackets) First pick up the "Job Set-Up" string from resources*/
            /*  and move to the end of this string.                           */
            /******************************************************************/
            WinLoadString( hab,
                           DMData.HModule,
                           IDS_JOB_SETUP_CAPTION,
                           SLEN_BOX_MESSAGE,
                           (PSZ)szMessage );

            for ( pDest = szMessage;  *pDest != '\0'; )
                pDest++;

            /******************************************************************/
            /*  Add in the printer type.                                      */
            /******************************************************************/
            WinLoadString( hab,
                           DMData.HModule,
                           IDS_FIRST_PRINTER + PrinterType,
                           SLEN_BOX_MESSAGE,
                           (PSZ)pDest );

#if 0
//          while ( *pDest != '\0' )           /*  PD00284                    */
//             *pDest++;

            /******************************************************************/
            /*  Add in the printer name surrounded by brackets provided the   */
            /*  application gave us a valid name.                             */
            /******************************************************************/
//          if ( DMData.PrinterName[0] != '\0' )
//          {
//              *pDest++ = ' ';
//              *pDest++ = '(';
//              *pDest++ = ' ';

//              pSource = DMData.PrinterName;

//              while ( *pSource != '\0' )
//                 *pDest++ = *pSource++;

//              *pDest++ = ' ';
//              *pDest++ = ')';
//          }

//          *pDest = '\0';                       /*  PD00284                  */
#endif

            /******************************************************************/
            /*  Update Window title                                           */
            /******************************************************************/
            (void) WinSetWindowText( hwnd, szMessage );

            /******************************************************************/
            /*  Load the caption to be used for all message boxes.            */
            /******************************************************************/
            WinLoadString( hab,
                           DMData.HModule,
                           IDS_FIRST_PRINTER + PrinterType,
                           40,
                           (PSZ)szCaption );

            /******************************************************************/
            /*  print the task title- Application Name.                       */
            /******************************************************************/
            WinQuerySessionTitle(hwnd, 0, (PSZ) szTaskTitle, 60);

            WinSetDlgItemText( hwnd, DB_TXT_APP_NAME_CURRENT, (PSZ) szTaskTitle );

            /******************************************************************/
            /*  Fill in the list of supported resolutions if a list box is    */
            /*  used.                                                         */
            /******************************************************************/
            if ( !(pDDT->DDTDialogFlags & DDT_RADIO_RESOLUTION) &&
                  ( WinWindowFromID (hwnd, DB_RAD_JPRES0) == 0) )
            {
                for ( i = 0; i < pDDT->DDTNoOfRasterModes; i++ )
                {
                    DlgResult = WinSendDlgItemMsg(
                                  hwnd,
                                  DB_LST_JPRESOLUTION,
                                  LM_INSERTITEM,
                                  (MPARAM)(ULONG)LIT_END,
                                  MPFROMP(pDDT->
                                      DDTRasterMode[i].Description) );
                }
            }

            /******************************************************************/
            /*  600x600 : Put in some error checking                          */
            /******************************************************************/
            if ( pDMDrivData->Resolution3 >= pDDT->DDTNoOfRasterModes )
                pDMDrivData->Resolution3 = pDDT->DDTNoOfRasterModes-1;

            /******************************************************************/
            /*  Select the current resolution.                                */
            /******************************************************************/
            if ( ( pDDT->DDTDialogFlags & DDT_RADIO_RESOLUTION ) ||
                 ( WinWindowFromID (hwnd, DB_RAD_JPRES0) != 0) )
            {
                /**************************************************************/
                /*  IBM4019 - use radio buttons.                              */
                /**************************************************************/
                for ( i = 0; i < pDDT->DDTNoOfRasterModes; i++ )
                {
                    CheckSwitch = ( pDMDrivData->Resolution3 == i );

                    DlgResult = WinSendDlgItemMsg( hwnd,
                                                   DB_RAD_JPRES0 + i,
                                                   BM_SETCHECK,
                                                   (MPARAM)CheckSwitch,
                                                   FNULL );
                }
            }
            else
            {
                DlgResult = WinSendDlgItemMsg(
                                hwnd,
                                DB_LST_JPRESOLUTION,
                                LM_SELECTITEM,
                                (MPARAM)pDMDrivData->Resolution3,
                                (MPARAM)(ULONG)TRUE );
            }

            /******************************************************************/
            /*  Set the appropriate orientation radio button.                 */
            /******************************************************************/
            if ( pDMDrivData->Orientation == LANDSCAPE )
                WndId = DB_RAD_JPLANDSCAPE;
            else
                WndId = DB_RAD_JPPORTRAIT;

            DlgResult = WinSendDlgItemMsg( hwnd,
                                           WndId,
                                           BM_SETCHECK,
                                           (MPARAM)(ULONG)TRUE,
                                           FNULL );

            /******************************************************************/
            /*  Display list of available fonts - highlight the current       */
            /*  default font if it appears in the list; otherwise inform the  */
            /*  user that he has altered the card(s) selected in the slot(s)  */
            /*  and, if no action is taken, the default font will revert to   */
            /*  the default resident font.                                    */
            /******************************************************************/
            /******************************************************************/
            /*  PD00242 : Default font list box must have a separate ID for   */
            /*  the 4029 than the other printers so that help can call a      */
            /*  separate help panel for the 4019 printer driver.              */
            /******************************************************************/
            prdm_InitDfltFontList( hwnd, DB_LST_JP_DFLTFONTS );

            /******************************************************************/
            /*  Display the list of default fonts.                            */
            /******************************************************************/
            /******************************************************************/
            /*  PD00242 : Default font list box must have a separate ID for   */
            /*  the 4029 than the other printers so that help can call a      */
            /*  separate help panel for the 4019 printer driver.              */
            /*                                                                */
            /******************************************************************/
            prdm_DisplayDefaultFontList( hwnd, DB_LST_JP_DFLTFONTS );

            /******************************************************************/
            /*  Check the DDT to see if the printer supports dual froms jobs  */
            /*  for this source configuration (or at all).                    */
            /******************************************************************/
            DMDualFormSupport = FALSE;

            if ( pDDT->DDTDialogFlags & DDT_DUAL_FORM_JOB_ALL )
            {
                DMDualFormSupport = TRUE;
            }
            else
            {
                if ( pDDT->DDTDialogFlags & DDT_DUAL_FORM_JOB_SOME )
                {
                    /**********************************************************/
                    /*  This flag is only set for the 4224 mono printer.  The */
                    /*  only source configuration which supports dual form    */
                    /*  jobs is F4; we trap this case by checking the number  */
                    /*  of paper sheet feed trays.                            */
                    /**********************************************************/
                    pSourceInfo  = pDDT->DDTSourceList;
                    pSourceInfo += pDMSettings->SourceIndex;

                    if ( pSourceInfo->NoOfPaperTrays > 1 )
                        DMDualFormSupport = TRUE;
                }
                else
                {

                    /**********************************************************/
                    /*  Display the list of forms and find the form index     */
                    /*  which need to be high lighted.                        */
                    /**********************************************************/
                    LocForm1 = prdm_SetupSingleFormList( hwnd );

                    /**********************************************************/
                    /*  Select the default form to avoid the case of no form  */
                    /*  being selected.                                       */
                    /**********************************************************/
                    DlgResult = WinSendDlgItemMsg(
                                      hwnd,
                                      DB_LST_SFORM,
                                      LM_SELECTITEM,
                                      (MPARAM)LocForm1,
                                      (MPARAM)(ULONG)TRUE );

                }
            }

            /******************************************************************/
            /*  Initialise the single/dual form job state and also the        */
            /*  corresponding form lists.  The per job form type is set in a  */
            /*  flipped way to force the form list boxes to be displayed under*/
            /*  the WM_CONTROL handling.                                      */
            /******************************************************************/
            if ( pDMDrivData->NumberOfForms == 2 )
            {
                DMPerJobFormType = DB_RAD_SINGLE_FORM;

                DlgResult = WinSendDlgItemMsg( hwnd,
                                               DB_RAD_DUAL_FORM,
                                               BM_CLICK,
                                               (MPARAM)(ULONG)TRUE,
                                               FNULL );

            }
            else
            {
                DMPerJobFormType = DB_RAD_DUAL_FORM;

                DlgResult = WinSendDlgItemMsg( hwnd,
                                               DB_RAD_SINGLE_FORM,
                                               BM_CLICK,
                                               (MPARAM)(ULONG)TRUE,
                                               FNULL );
            }

            /******************************************************************/
            /*  If dual form jobs are not supported then grey out the         */
            /*  single/dual form radio buttons.                               */
            /******************************************************************/
            if ( !DMDualFormSupport )
            {
/*              DlgResult = WinEnableWindow(                         CON3201 */
                            WinEnableWindow(
                              WinWindowFromID( hwnd, DB_RAD_SINGLE_FORM ),
                              FALSE );

/*              DlgResult = WinEnableWindow(                         CON3201 */
                            WinEnableWindow(
                              WinWindowFromID( hwnd, DB_RAD_DUAL_FORM ),
                              FALSE );
            }

            /******************************************************************/
            /*  Set up or grey out the duplex options.  Long winded but       */
            /*  preferable I think.  PD00157 : Added check in the following if*/
            /*  statement to look at the DDT_DUPLEX_NOTSUPPORT flag in        */
            /*  SourceFlags - currently the Heritage P (4029 5E) is the only  */
            /*  printer that carries this flag in SourceFlags.                */
            /******************************************************************/
            if (((pDDT->DDTSourceFlags & DDT_DUPLEX_OPTIONAL) &&
                 !pDMSettings->DuplexEnabled) ||
                 (pDDT->DDTSourceFlags & DDT_DUPLEX_NOTSUPPORT))
            {

                /**************************************************************/
                /*  Simplex option                                            */
                /**************************************************************/
                DlgResult = WinSendDlgItemMsg( hwnd,
                                               DB_RAD_JPSIMPLEX,
                                               BM_SETCHECK,
                                               (MPARAM)(ULONG)FALSE,
                                               FNULL );
                hwndResult = WinWindowFromID(   hwnd,
                                               DB_RAD_JPSIMPLEX );
/*              DlgResult = WinEnableWindow(   DlgResult,             CON3201 */
                            WinEnableWindow(   hwndResult,
                                               FALSE );

                /**************************************************************/
                /*  Normal duplex option                                      */
                /**************************************************************/
/*              DlgResult = WinSendDlgItemMsg( hwnd,                  CON3201 */
                            WinSendDlgItemMsg( hwnd,
                                               DB_RAD_JPNORMAL,
                                               BM_SETCHECK,
                                               (MPARAM)(ULONG)FALSE,
                                               FNULL );
/*              DlgResult = WinWindowFromID(   hwnd,                  CON3201 */
                hwndResult =  WinWindowFromID(   hwnd,
                                               DB_RAD_JPNORMAL );
/*              DlgResult = WinEnableWindow(   DlgResult,             CON3201 */
                            WinEnableWindow(   hwndResult,
                                               FALSE );

                /**************************************************************/
                /*  Tumble duplex option                                      */
                /**************************************************************/
                DlgResult = WinSendDlgItemMsg( hwnd,
                                               DB_RAD_JPTUMBLE,
                                               BM_SETCHECK,
                                               (MPARAM)(ULONG)FALSE,
                                               FNULL );
/*              DlgResult = WinWindowFromID(   hwnd,                  CON3201 */
                hwndResult =  WinWindowFromID(   hwnd,
                                               DB_RAD_JPTUMBLE );
/*              DlgResult = WinEnableWindow(   DlgResult,             CON3201 */
                            WinEnableWindow(   hwndResult,
                                               FALSE );
            }
            else
            if ( ( (pDDT->DDTSourceFlags & DDT_DUPLEX_OPTIONAL) &&
                    pDMSettings->DuplexEnabled ) ||
                   (pDDT->DDTSourceFlags & DDT_DUPLEX_SUPPORT) )
            {
                /**************************************************************/
                /*  Setup the duplex setting.  (3816, Heritage)               */
                /**************************************************************/
                for ( i = 0; i < 3 ; i++ )
                {
                    DlgResult = WinSendDlgItemMsg(
                        hwnd,
                        DB_RAD_JPSIMPLEX + i,
                        BM_SETCHECK,
                        (MPARAM)((pDMDrivData->SimDup == i)?TRUE:FALSE),
                        FNULL );
                }
            }

            /******************************************************************/
            /*  Reset the cursor shape to its original shape.                 */
            /******************************************************************/
            (void) WinSetPointer( HWND_DESKTOP,
                                  (HPOINTER)DMData.CursorHandle );

            /******************************************************************/
            /*  PD00263 : Remove set active window.  Now window always appears*/
            /*  in the same place.                                            */
            /******************************************************************/
#if 0
//          WinSendMsg( DMData.hwndHelp,
//                      HM_SET_ACTIVE_WINDOW,
//                      hwnd,
//                      hwnd );
#endif

            /******************************************************************/
            /*  Set the focus to the enter button                             */
            /******************************************************************/
/*          DlgResult = WinSetFocus(                                  CON3201 */
                        WinSetFocus(
                                 HWND_DESKTOP,
                                 WinWindowFromID(hwnd, DB_PSH_JPENTER));

            break;

        case WM_CONTROL:
            /******************************************************************/
            /* We need to trap a button being clicked in the Forms            */
            /* Configuration box (ie specifying single or dual form           */
            /* job).                                                          */
            /******************************************************************/
            if ( SHORT2FROMMP(lparam1) == BN_CLICKED )
            {
                /**************************************************************/
                /* Check if single/dual form type has changed.                */
                /**************************************************************/
                /**************************************************************/
                /* PD00430 : If the printer is the 4224 color printer then the*/
                /* form list for the job properties dialog has already been   */
                /* added back under WM_INITDLG so don't do it now.            */
                /**************************************************************/
                if ( SHORT1FROMMP(lparam1) == DB_RAD_SINGLE_FORM &&
                          DMPerJobFormType == DB_RAD_DUAL_FORM &&
                          pDMSettings->PrinterType != IBM_4224_COLOR )
                {
                    /**********************************************************/
                    /*  Single form job chosen...                             */
                    /**********************************************************/
                    DMPerJobFormType = DB_RAD_SINGLE_FORM;

                    /**********************************************************/
                    /*  Make dual form boxes invisible and single form boxes  */
                    /*  visible.  Note that this relies on the box ids for the*/
                    /*  list boxes (and titles) for the dual form lists being */
                    /*  consecutive.                                          */
                    /**********************************************************/
                    for ( i = 0; i < 4; i++ )
                    {
                        WndId = DB_LST_DFORM1_TEXT + i;
/*                      DlgResult = WinShowWindow(                    CON3201 */
                                    WinShowWindow(
                                        WinWindowFromID( hwnd, WndId ),
                                        FALSE );
                    }

                    for ( i = 0; i < 2; i++ )
                    {
                        WndId = DB_LST_SFORM_TEXT + i;
/*                      DlgResult = WinShowWindow(                    CON3201 */
                                    WinShowWindow(
                                        WinWindowFromID( hwnd, WndId ),
                                        TRUE );
                    }

                    /**********************************************************/
                    /*  PD00046 : Set up the form list and select the correct */
                    /*  one by form name.                                     */
                    /**********************************************************/

                    /**********************************************************/
                    /*  Display the list of forms and find the form index     */
                    /*  which need to be high lighted.                        */
                    /**********************************************************/
                    LocForm1 = prdm_SetupSingleFormList( hwnd );

                    /**********************************************************/
                    /*  Select the default form to avoid the case of no form  */
                    /*  being selected.                                       */
                    /**********************************************************/
                    DlgResult = WinSendDlgItemMsg(
                                      hwnd,
                                      DB_LST_SFORM,
                                      LM_SELECTITEM,
                                      (MPARAM)LocForm1,
                                      (MPARAM)(ULONG)TRUE );
                    /**********************************************************/
                    /*  Display the list of forms.                            */
                    /**********************************************************/
#if 0
//                    prdm_InitFormList( hwnd, DB_LST_SFORM );

                    /**********************************************************/
                    /*  Select the default form to avoid the case of no form  */
                    /*  being selected.                                       */
                    /**********************************************************/
//                    DlgResult = WinSendDlgItemMsg(
//                                      hwnd,
//                                      DB_LST_SFORM,
//                                      LM_SELECTITEM,
//                                      (MPARAM)pDMDrivData->FormNumber1,
//                                      (MPARAM)(ULONG)TRUE );
#endif

                    /**********************************************************/
                    /*  Delete the forms from the dual list boxes.            */
                    /**********************************************************/
                    for ( i = 0; i < 2; i++ )
                    {
                        WndId = DB_LST_DFORM1 + 2*i;
                        DlgResult = WinSendDlgItemMsg(
                                    hwnd,
                                    WndId,
                                    LM_DELETEALL,
                                    FNULL,
                                    FNULL );
                    }
                }
                else if ( SHORT1FROMMP(lparam1) == DB_RAD_DUAL_FORM &&
                               DMPerJobFormType == DB_RAD_SINGLE_FORM )
                {
                    /**********************************************************/
                    /*  Dual form job chosen...                               */
                    /**********************************************************/
                    DMPerJobFormType = DB_RAD_DUAL_FORM;
                    TRACE6(TFUNC, "Dual form chosen", FNULL, 0);

                    /**********************************************************/
                    /*  Make single form boxes invisible and dual form boxes  */
                    /*  visible.  Note that this relies on the box ids for the*/
                    /*  list box and title for the single form list being     */
                    /*  consecutive.                                          */
                    /*                                                        */
                    /**********************************************************/
                    for ( i = 0; i < 2; i++ )
                    {
                        WndId = DB_LST_SFORM_TEXT + i;
/*                      DlgResult = WinShowWindow(                    CON3201 */
                                    WinShowWindow(
                                        WinWindowFromID( hwnd, WndId ),
                                        FALSE );
                    }

                    for ( i = 0; i < 4; i++ )
                    {
                        WndId = DB_LST_DFORM1_TEXT + i;
/*                      DlgResult = WinShowWindow(                   CON3201 */
                                    WinShowWindow(
                                        WinWindowFromID( hwnd, WndId ),
                                        TRUE );
                    }

                    /**********************************************************/
                    /*  Display all the available paper forms in the two list */
                    /*  boxes.  Loop through each form..                      */
                    /**********************************************************/
                    LocForm1 = (USHORT)prdm_FindDfltFormNo( );
                    LocForm2 = LocForm1;
                    FormCnt  = 0;
                    PaperCnt = 0;

                    /**********************************************************/
                    /*  Convert the form names into form indices.  These      */
                    /*  functions match names, units and types Function       */
                    /*  returns zero if not found, index+1 if it was found.   */
                    /*                                                        */
                    /**********************************************************/
                    DrvDataFormNo1 =
                         prdm_FindFormNumber( &pDMDrivData->FormInfo1 );

                    DrvDataFormNo2 =
                         prdm_FindFormNumber( &pDMDrivData->FormInfo2 );

                    /**********************************************************/
                    /*  If form two was invalid then just use the first form, */
                    /*  and vis versa.  Note that the case of both being      */
                    /*  invalid then the default forms as defined above will  */
                    /*  be used.                                              */
                    /**********************************************************/
                    if ( DrvDataFormNo1 && !DrvDataFormNo2 )
                    {
                       DrvDataFormNo2 = DrvDataFormNo1;
                    }
                    else if ( !DrvDataFormNo1 && DrvDataFormNo2 )
                    {
                       DrvDataFormNo1 = DrvDataFormNo2;
                    }

                    for ( Form = DMData.Forms;
                          Form;
                          Form = Form->NextForm )
                    {
                        /******************************************************/
                        /*  Only check if the form was valid and remember that*/
                        /*  the form number returned is one greater than it   */
                        /*  actually should be.                               */
                        /******************************************************/
                        if ( DrvDataFormNo1 &&
                             ( ( DrvDataFormNo1 - 1 ) == FormCnt ) &&
                             (Form->FormType == DDT_PAPER_FORM) )
                        {
                           LocForm1 = PaperCnt;
                        }

                        if ( DrvDataFormNo2 &&
                             ( ( DrvDataFormNo2 - 1 ) == FormCnt ) &&
                             (Form->FormType == DDT_PAPER_FORM) )
                        {
                           LocForm2 = PaperCnt;
                        }

                        /******************************************************/
                        /*  If it is a paper form.                            */
                        /******************************************************/
                        if ( Form->FormType == DDT_PAPER_FORM )
                        {
                            /**************************************************/
                            /*  Replace the form name delimiter with a null   */
                            /*  terminator.                                   */
                            /**************************************************/
                         /* for ( cp = (char far *)Form->FormData; */
                            for ( cp = (char *)Form->FormData;     /* CON3201 */
                                  *cp != '\1';
                                  cp++ );

                            *cp = '\0';

                            /**************************************************/
                            /*  Display the form name in both boxes.          */
                            /**************************************************/
                            for ( i = 0; i < 2; i++ )
                            {
                                WndId = DB_LST_DFORM1 + 2*i;
                                DlgResult = WinSendDlgItemMsg(
                                            hwnd,
                                            WndId,
                                            LM_INSERTITEM,
                                            (MPARAM)(ULONG)LIT_END,
                                            MPFROMP(Form->FormData) );
                            }

                            *cp = '\1';
                            PaperCnt++;
                        }

                        FormCnt++;
                    }

                    /**********************************************************/
                    /*  Select the first form in both boxes to avoid the case */
                    /*  of no forms being selected.                           */
                    /**********************************************************/
                    WndId = DB_LST_DFORM1;

                    DlgResult = WinSendDlgItemMsg(
                                        hwnd,
                                        WndId,
                                        LM_SELECTITEM,
                                        (MPARAM)LocForm1,
                                        (MPARAM)(ULONG)TRUE );
                    WndId = DB_LST_DFORM2;

                    DlgResult = WinSendDlgItemMsg(
                                        hwnd,
                                        WndId,
                                        LM_SELECTITEM,
                                        (MPARAM)LocForm2,
                                        (MPARAM)(ULONG)TRUE );


                    /**********************************************************/
                    /*  Delete the forms from the single form list box.       */
                    /*                                                        */
                    /**********************************************************/
                    DlgResult = WinSendDlgItemMsg( hwnd,
                                                   DB_LST_SFORM,
                                                   LM_DELETEALL,
                                                   FNULL,
                                                   FNULL );
                }
                /*..if ( SHORT1FROMMP(lparam1) == DUAL_FORM ).................*/
            }
            /*....if ( SHORT2FROMMP(lparam1) == BN_CLICKED )..................*/

            /******************************************************************/
            /*  Default outline font pointsize selection PD00137              */
            /******************************************************************/
            if( (SHORT1FROMMP(lparam1) == DB_LST_JP_DFLTFONTS_4029)
                  && (SHORT2FROMMP(lparam1) == LN_SELECT) )
            {
               prdm_DfltFontPSzControlProc(hwnd,DB_LST_JP_DFLTFONTS_4029);
            }

            break;

        case HM_QUERY_KEYS_HELP:
            /******************************************************************/
            /*  PD00637 : Return Keys Help panel ID if Keys Help is requested */
            /******************************************************************/
            return (MRESULT) IDH_KEYS;
            break;

        default:
            /******************************************************************/
            /*  Pass any other messages to the default handler.               */
            /******************************************************************/
            return(WinDefDlgProc( hwnd, msg, lparam1, lparam2 ));
            break;

    }
    /*.. switch (msg) ........................................................*/
}
#undef TFUNC


/******************************************************************************/
/*                                                                            */
/*   FUNCTION: prdm_                                       */
/*                                                                            */
/*   PARAMETERS:                                                              */
/*                                                                            */
/*   HWND   hwnd;                                                             */
/*                                                                            */
/*   DESCRIPTION:                                                             */
/*                                                                            */
/*                                                                            */
/******************************************************************************/
#if 0
USHORT pascal prdm_EnterJobSetUp( hwnd )

HWND   hwnd;
#endif

USHORT prdm_EnterJobSetUp( HWND hwnd )                             /* CON3201 */

{
#define TFUNC "prdm_EnterJob"

    /**************************************************************************/
    /*  Local Variables                                                       */
    /**************************************************************************/
    USHORT       ListIndex;      /* index of selected item in listbox         */
    USHORT       FormCnt;        /* Count of forms processed in loop          */
    USHORT       PaperCnt;       /* Count of paper forms in loop              */
 /* sForm far *  Form; */        /* Pointer to form data structure            */
    sForm     *  Form;           /* Pointer to form data structure    CON3201 */
    ULONG        FormNumber1;    /* first form for dual form job              */
    ULONG        FormNumber2;    /* second form for dual form job             */
    BYTE         FormID1;        /* form/paper id for first form              */
    BYTE         FormID2;        /* form/paper id for second form             */
    BOOL         Found1;         /* flag set if form index matched            */
    BOOL         Found2;         /* flag set if form index matched            */
    USHORT       PrinterType;    /* Current printer type                      */
    lpDDTType    pDDT;           /* Pointer to DDT for this printer           */
    USHORT       i;
    pFormInfoStruc     pFormInfo1;
    pFormInfoStruc     pFormInfo2;


    /**************************************************************************/
    /*  Get the current Printer Type and then the correct DDT.  Note that the */
    /*  user cannot change the current printer type while in the Job Set Up   */
    /*  box.  Hence the printer type held in DMSettings and DMDrivData will   */
    /*  always be the same.  Also DMSettings will contain the default values  */
    /*  for that printer type.                                                */
    /**************************************************************************/
    PrinterType = pDMSettings->PrinterType;
    pDDT = DDT[PrinterType];

    /**************************************************************************/
    /*  Check if a font has been selected and store the details of the font in*/
    /*  DMDrivData.                                                           */
    /**************************************************************************/
    /**************************************************************************/
    /*  PD00242 : Default font list box must have a separate ID for the 4029  */
    /*  than the other printers so that help can call a separate help panel   */
    /*  for the 4019 printer driver.                                          */
    /**************************************************************************/
    prdm_EnterFontValue( hwnd, DB_LST_JP_DFLTFONTS );

    /**************************************************************************/
    /*  Depending on the type of job (single or dual form) get the selected   */
    /*  form or forms.                                                        */
    /**************************************************************************/
    if ( (DMDualFormSupport) && (WinSendDlgItemMsg( hwnd,
                                                    DB_RAD_DUAL_FORM,
                                                    BM_QUERYCHECK,
                                                    FNULL,
                                                    FNULL )) )
    {
        /**********************************************************************/
        /*  This is a dual form job..  get the index of the selected form for */
        /*  the first page and the subsequent pages.                          */
        /**********************************************************************/
        FormNumber1 = SHORT1FROMMR( WinSendDlgItemMsg(
                                     hwnd,
                                     DB_LST_DFORM1,
                                     LM_QUERYSELECTION,
                                     MPFROMSHORT(LIT_FIRST),
                                     FNULL ) );

        FormNumber2 = SHORT1FROMMR( WinSendDlgItemMsg(
                                     hwnd,
                                     DB_LST_DFORM2,
                                     LM_QUERYSELECTION,
                                     MPFROMSHORT(LIT_FIRST),
                                     FNULL ) );

        /**********************************************************************/
        /*  The form number gives the index of the form within the list of    */
        /*  paper forms only.  Convert the form number to a true form number. */
        /*  Also pick up the paper id so we can check that the form sizes are */
        /*  the same.                                                         */
        /**********************************************************************/
        FormCnt  = 0;
        PaperCnt = 0;
        Found1 = FALSE;
        Found2 = FALSE;

        /**********************************************************************/
        /*  Loop through each form.                                           */
        /**********************************************************************/
        for ( Form = DMData.Forms; Form; Form = Form->NextForm )
        {
            /******************************************************************/
            /*  See if its a paper form.                                      */
            /******************************************************************/
            if ( Form->FormType == DDT_PAPER_FORM )
            {
                if ( !Found1 && (FormNumber1 == PaperCnt) )
                {
                    FormNumber1 = FormCnt;
                    FormID1 = Form->FormID;
                    Found1 = TRUE;
                }

                if ( !Found2 && (FormNumber2 == PaperCnt) )
                {
                    FormNumber2 = FormCnt;
                    FormID2 = Form->FormID;
                    Found2 = TRUE;
                }

                PaperCnt++;
            }
            FormCnt++;
        }

        /**********************************************************************/
        /*  The form sizes for a dual form job must be the same.  If they are */
        /*  then store the form info; otherwise inform the user and return    */
        /*  FALSE to force the user to re-select the forms or CANCEL.  Note   */
        /*  that we must not have updated DrivData if we are going to return  */
        /*  false here.                                                       */
        /**********************************************************************/
        if ( FormID1 == FormID2 )
        {
            pDMDrivData->NumberOfForms = 2;

            /******************************************************************/
            /*  Update the form indices as before.                            */
            /******************************************************************/
            pDMDrivData->FormNumber1   = FormNumber1;
            pDMDrivData->FormNumber2   = FormNumber2;

            /******************************************************************/
            /*  Also store the form name etc.  for form1 ...                  */
            /******************************************************************/
            pFormInfo1 = prdm_FindFormInfo( FormNumber1 );
            prdu_strcpy ( (PBYTE) pDMDrivData->FormInfo1.FormName,
                          (PBYTE) pFormInfo1->FormName );
            pDMDrivData->FormInfo1.FormType  = pFormInfo1->FormType;
            pDMDrivData->FormInfo1.FormUnits = pFormInfo1->FormUnits;

            /******************************************************************/
            /*  ...  and form two.                                            */
            /******************************************************************/
            pFormInfo2 = prdm_FindFormInfo( FormNumber2 );
            prdu_strcpy ( (PBYTE) pDMDrivData->FormInfo2.FormName,
                          (PBYTE) pFormInfo2->FormName );
            pDMDrivData->FormInfo2.FormType  = pFormInfo2->FormType;
            pDMDrivData->FormInfo2.FormUnits = pFormInfo2->FormUnits;
        }
        else
        {
            (void)prdm_DispMessageBox( hwnd,
                                       IDS_FORM_SIZES,
                                       SLEN_BOX_MESSAGE,
                                       DB_TXT_UNITS,
                                       MB_OK | MB_ICONEXCLAMATION );
            return(FALSE);
        }
    }
    else
    {
        /**********************************************************************/
        /*  This is a single form job..  get the index of the selected form.  */
        /*                                                                    */
        /**********************************************************************/
        ListIndex = SHORT1FROMMR( WinSendDlgItemMsg(
                                     hwnd,
                                     DB_LST_SFORM,
                                     LM_QUERYSELECTION,
                                     MPFROMSHORT(LIT_FIRST),
                                     FNULL ) );

        if ( ListIndex != (USHORT)LIT_NONE )
        {
            /******************************************************************/
            /*  Update driver data.                                           */
            /******************************************************************/
            pDMDrivData->NumberOfForms = 1;

            /******************************************************************/
            /*  First the index as before.                                    */
            /******************************************************************/
            pDMDrivData->FormNumber1   = ListIndex;

            /******************************************************************/
            /*  Now the form name etc.                                        */
            /******************************************************************/
            pFormInfo1 = prdm_FindFormInfo( (ULONG)ListIndex );
            prdu_strcpy ( (PBYTE) pDMDrivData->FormInfo1.FormName,
                          (PBYTE) pFormInfo1->FormName );
            pDMDrivData->FormInfo1.FormType  = pFormInfo1->FormType;
            pDMDrivData->FormInfo1.FormUnits = pFormInfo1->FormUnits;
        }
    }

    /**************************************************************************/
    /*  Read the current resolution.                                          */
    /**************************************************************************/
    if ( pDDT->DDTDialogFlags & DDT_RADIO_RESOLUTION )
    {
        if ( WinSendDlgItemMsg( hwnd,
                                DB_RAD_JPRES0,
                                BM_QUERYCHECK, FNULL, FNULL))
        {
            pDMDrivData->Resolution  = 0;
            pDMDrivData->Resolution2 = 0;                          /* PD00587 */
            pDMDrivData->Resolution3 = 0;                          /* 600DPI  */
        }
        else if ( WinSendDlgItemMsg( hwnd,
                                     DB_RAD_JPRES1,
                                     BM_QUERYCHECK, FNULL, FNULL))
        {
            pDMDrivData->Resolution  = 1;
            pDMDrivData->Resolution2 = 1;                          /* PD00587 */
            pDMDrivData->Resolution3 = 1;                          /* 600DPI  */
        }
        else if ( WinSendDlgItemMsg( hwnd,
                                     DB_RAD_JPRES3,
                                     BM_QUERYCHECK, FNULL, FNULL))
        {
            pDMDrivData->Resolution  = 3;
            pDMDrivData->Resolution2 = 3;                          /* PD00587 */
            pDMDrivData->Resolution3 = 3;                          /* 600DPI  */
        }
        else
        {
            pDMDrivData->Resolution  = 2;
            pDMDrivData->Resolution2 = 2;                          /* PD00587 */
            pDMDrivData->Resolution3 = 2;                          /* 600DPI  */
        }
    }
    else
    {
        /*******************************************************************/
        /* PD00587 : Adding 360x360 to 239X printers causes problems when  */
        /*  we have a driver that supports 360x360 as a requestor and we   */
        /*  have a server that doesn't.  To get around this we are adding  */
        /*  a new resolution field to driver data.  This field will be used*/
        /*  be used by the new driver.  The old resolution field will be   */
        /*  be used by the old driver on the server, so we must insure that*/
        /*  the value in it when we are at 360x360 is 360x180.  This is to */
        /*  avoid possible TRAPs and/or weird results on the server.       */
        /*  Currently 360x360 is only supported on 239X printers.          */
        /*******************************************************************/
        pDMDrivData->Resolution3 = (USHORT)WinSendDlgItemMsg(
                                             hwnd,
                                             DB_LST_JPRESOLUTION,
                                             LM_QUERYSELECTION,
                                             (MPARAM)(ULONG)LIT_FIRST,
                                             FNULL);

        if ( (DRIVER_TYPE == DDT_IBM42XX_DRV) &&
             ( (PrinterType == IBM_NILE_24) ||
               (PrinterType == IBM_TIBER_24) ||
               (PrinterType == IBM_2390_PS1) ) &&
               (pDMDrivData->Resolution3 == 4) )
        {
            pDMDrivData->Resolution2 = 4;
            pDMDrivData->Resolution = 3;
        }
        else
        {
            pDMDrivData->Resolution2 = pDMDrivData->Resolution3;
            pDMDrivData->Resolution = pDMDrivData->Resolution3;
        }

    }

    /**************************************************************************/
    /*  Get the current paper orientation.                                    */
    /**************************************************************************/
    if ( WinSendDlgItemMsg( hwnd,
                            DB_RAD_JPPORTRAIT,
                            BM_QUERYCHECK,
                            FNULL,
                            FNULL) )
    {
        pDMDrivData->Orientation = PORTRAIT;
    }
    else
    {
        pDMDrivData->Orientation = LANDSCAPE;
    }

    /**************************************************************************/
    /*  Get the current selection for the FSF option                          */
    /*  600DPI : moved this to WM_CONTROL                                     */
    /**************************************************************************/

    /**************************************************************************/
    /*  PD00136 : Get the current selection for the disable outline fonts     */
    /*  option.                                                               */
    /*  600DPI : moved this to WM_CONTROL                                     */
    /**************************************************************************/

    /**************************************************************************/
    /*  Read the duplex setting.  Default to zero (simplex).                  */
    /**************************************************************************/

    if ( (pDDT->DDTSourceFlags & DDT_DUPLEX_SUPPORT) ||
         ( (pDDT->DDTSourceFlags & DDT_DUPLEX_OPTIONAL) &&
            pDMSettings->DuplexEnabled ) )
    {
        /**********************************************************************/
        /*  Its 3816, or Heritage with duplex enabled.  Start with simplex    */
        /*  reset.                                                            */
        /**********************************************************************/
        pDMDrivData->SimDup = 0;

        for (i = 0; i < 3; i++ )
        {
            /******************************************************************/
            /*  PD00539 : Incorrect radio button ID was being used.           */
            /******************************************************************/
            if ( WinSendDlgItemMsg( hwnd,
                                    DB_RAD_JPSIMPLEX + i,
                                    BM_QUERYCHECK,
                                    FNULL,
                                    FNULL) )
            {
                pDMDrivData->SimDup = i;
            }
        }
    }


    return(TRUE);
}
#undef TFUNC


/******************************************************************************/
/*                                                                            */
/*   FUNCTION: prdm_SetupSingleFormList                                       */
/*                                                                            */
/*   PARAMETERS:                                                              */
/*                                                                            */
/*   HWND   hwnd;      The handle for the dialog window we are in             */
/*                                                                            */
/*   DESCRIPTION:                                                             */
/*                                                                            */
/*   This function sends messages to the single form list box                 */
/*   to insert all the defined forms and also find out which form             */
/*   need to be high lighted according to the driver data forminfo.           */
/*                                                                            */
/*   By setup the default form, there will always have a form high            */
/*   light.                                                                   */
/******************************************************************************/
#if 0
USHORT pascal prdm_SetupSingleFormList( hwnd )

HWND       hwnd;
#endif

USHORT prdm_SetupSingleFormList( HWND hwnd )                       /* CON3201 */

{
#define TFUNC "prdm_SetupSinFrmLst"

    /**************************************************************************/
    /*  Local Variables                                                       */
    /**************************************************************************/
 /* sForm far * Form; */      /* Pointer to form data structure for           */
                              /* stepping through the forms                   */
 /* char far *  cp;   */      /* Pointer for accessing the form text          */
    sForm     * Form;         /* Pointer to form data structure for   CON3201 */
                              /* stepping through the forms                   */
    char     *  cp;           /* Pointer for accessing the form text  CON3201 */
    MRESULT     DlgResult;    /* The result of a Win.. call                   */
    USHORT      LocForm;      /* Index of form which will returned            */
    USHORT      FormCnt;      /* Count of forms processed in loop             */
    ULONG       DrvDataFormNo;/* return form index from                       */
                              /* prdm_FindFormNumber                          */

    /**************************************************************************/
    /*  Set up the default value and find the high light form number          */
    /**************************************************************************/
    LocForm = (USHORT)prdm_FindDfltFormNo( );
    FormCnt = 0;

    DrvDataFormNo =
         prdm_FindFormNumber( &pDMDrivData->FormInfo1 );

    /**************************************************************************/
    /*  Loop through each form, display all the available forms in the list   */
    /*  box, find out which one should be high lighted.                       */
    /**************************************************************************/
    for ( Form = DMData.Forms; Form; Form = Form->NextForm )
    {
        /**********************************************************************/
        /*  Check the form number.                                            */
        /**********************************************************************/
        if ( DrvDataFormNo && ( ( DrvDataFormNo - 1 ) == FormCnt ) )
        {
           LocForm = FormCnt;
        }

        /**********************************************************************/
        /*  Replace the form name delimiter with a null terminator.           */
        /**********************************************************************/
     /* for ( cp = (char far *)Form->FormData; *cp != '\1'; cp++ ); */
        for ( cp = (char *)Form->FormData; *cp != '\1'; cp++ );    /* CON3201 */

        *cp = '\0';
        /**********************************************************************/
        /*  Display the form name in list box.                                */
        /**********************************************************************/
        DlgResult = WinSendDlgItemMsg(
                    hwnd,
                    DB_LST_SFORM,
                    LM_INSERTITEM,
                    (MPARAM)(ULONG)LIT_END,
                    MPFROMP(Form->FormData) );

        *cp = '\1';

        FormCnt++;
    }

    return( LocForm );
}
#undef TFUNC
