/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1992 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 source code is provided to you solely for       */
/*    the purpose of assisting you in your development of OS/2 device        */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Developer Connection Device Driver       */
/*    Source Kit for OS/2. This Copyright statement may not be removed.      */
/*                                                                           */
/*****************************************************************************/
/**************************************************************************
 *
 * SOURCE FILE NAME = PRDMDFNT
 *
 * DESCRIPTIVE NAME =
 *
 *
 * VERSION
 *
 * DATE
 *
 * DESCRIPTION
 *
 * FUNCTIONS   prdm_DfltFontDlgProc
 *             prdm_InitDfltFontList
 *             prdm_DisplayDefaultFontList
 *             prdm_EnterFontValue
 *             prdm_FontTableMemory
 *             prdm_MoreFontTableMemory
 *             prdm_ReleaseFontTableMemory
 *             prdm_CopyFaceNameAcross
 *
 * ENTRY POINTS:
 *
 * DEPENDENCIES:
 *
 * NOTES
 *
 *
 * STRUCTURES
 *
 * EXTERNAL REFERENCES
 *
 * EXTERNAL FUNCTIONS
 *
*/

#define INCL_32                         /* Convert to C/SET2    CON3201       */
#define INCL_DOSPROCESS                 /* Convert to C/SET2    CON3201       */
#define INCL_WINHELP
#define INCL_DOSRESOURCES
#define INCL_DOSSEMAPHORES
#define INCL_GPIERRORS
#define INCL_SHLERRORS
#define INCL_DOSERRORS
#define INCL_GPIPRIMITIVES
#define INCL_WINHEAP
#define INCL_GPIBITMAPS
#define INCL_DOSMODULEMGR
#define INCL_WINFRAMEMGR
#define INCL_WINLISTBOXES
#define INCL_WINBUTTONS
#define INCL_WINERRORS
#define INCL_WINDIALOGS
#define INCL_WINSHELLDATA
#define INCL_WINENTRYFIELDS
#define INCL_WINMESSAGEMGR
#define INCL_WININPUT
#define INCL_WINMENUS
#define INCL_WINPOINTERS
#include <os2.h>
#undef INCL_DOSPROCESS                  /* Convert to C/SET2    CON3201       */
#undef INCL_DOSRESOURCES
#undef INCL_DOSSEMAPHORES
#undef INCL_GPIERRORS
#undef INCL_DOSERRORS
#undef INCL_SHLERRORS
#undef INCL_GPIPRIMITIVES
#undef INCL_WINHEAP
#undef INCL_GPIBITMAPS
#undef INCL_DOSMODULEMGR
#undef INCL_WINFRAMEMGR
#undef INCL_WINLISTBOXES
#undef INCL_WINBUTTONS
#undef INCL_WINERRORS
#undef INCL_WINDIALOGS
#undef INCL_WINSHELLDATA
#undef INCL_WINENTRYFIELDS
#undef INCL_WINMESSAGEMGR
#undef INCL_WININPUT
#undef INCL_WINMENUS
#undef INCL_WINPOINTERS
#undef INCL_WINHELP

#define INCL_GRE_DCS
#define INCL_DDIBUNDLES
#define INCL_DDIFONTSTRUCS
#define INCL_DDIDEFS
#include <pmddi.h>
#undef INCL_GRE_DCS
#undef INCL_DDIBUNDLES
#undef INCL_DDIFONTSTRUCS
#undef INCL_DDIDEFS

#define INCL_WINP_SELSERVER
#define INCL_WINP_SELECTIVE
#define INCL_WINP_SEI
#include <pmwinx.h>
#undef INCL_WINP_SELSERVER
#undef INCL_WINP_SELECTIVE
#undef INCL_WINP_SEI

#define INCL_WINSHELLDATA
/* #include <pmshlp.h>                                              DLM01 */
#define INCL_WINSHELLDATA
#undef INCL_32                          /* Convert to C/SET2    CON3201       */

#include <prdconse.h>
#include <prddcone.h>
#include <prdecone.h>
#include <prdmcone.h>
#include <prdtcone.h>

#define NO_SYS
#define INCL_HELP
#define PRDMTYPE_INCL
#define NO_CONSTANT_INCL
#include <prdinclt.h>
#undef NO_CONSTANT_INCL
#undef NO_SYS
#undef INCL_HELP
#undef PRDMTYPE_INCL

#include <prdgextf.h>
#include <prdmextf.h>
#include <prduextf.h>
#include <prdyextf.h>
#include <prdmhelp.h>

extern HMODULE              prdd_ModHandle;
extern DModeDataType        DMData;
extern pDMDriverStruc       pDMDrivData;
extern lpDMSettings         pDMSettings;
extern CHAR                 szCaption[40];
extern CHAR                 szMessage[SLEN_BOX_MESSAGE];
extern BYTE                 SrcDirBuffer[80];

extern DMIniEntryType       DMIniEntry[LARGEST_NO_OF_PRINTERS];
extern lplpFontCPListType   DVTFontCPList [];
extern lpDVTCPSource        DVTCodePageCaps [];
extern lpDDTType            DDT [];


/**********************************************************************/
/*                                                                    */
/*   FUNCTION: prdm_DfltFontDlgProc                                   */
/*                                                                    */
/*   PARAMETERS:                                                      */
/*                                                                    */
/*   HWND      hwnd;                                                  */
/*   USHORT    msg;                                                   */
/*   MPARAM    lparam1;                                               */
/*   MPARAM    lparam2;                                               */
/*                                                                    */
/*   DESCRIPTION:                                                     */
/*                                                                    */
/*                                                                    */
/**********************************************************************/
#if 0
MRESULT pascal far _loadds prdm_DfltFontDlgProc( hwnd,
                                                 msg,
                                                 lparam1,
                                                 lparam2 )

HWND      hwnd;
USHORT    msg;
MPARAM    lparam1;
MPARAM    lparam2;
#endif

MRESULT prdm_DfltFontDlgProc( HWND   hwnd,                 /* CON3201 */
                              USHORT msg,                  /* CON3201 */
                              MPARAM lparam1,              /* CON3201 */
                              MPARAM lparam2 )             /* CON3201 */

{
#define TFUNC "prdm_DfltFntDlg"

    /******************************************************************/
    /* Local Variables                                                */
    /******************************************************************/
    USHORT      Result;        /* Function call return values         */
 /* MRESULT     DlgResult; */  /* CON3201                     .....   */
    ULONG       DlgResult;     /* CON3201                     .....   */
    SHORT       SelectIndex;
    lpDDTType   pDDT;          /* Pointer to DDT                      */
    USHORT      PrinterType;   /* Type of the current printer         */
    HPOINTER    HourGlass;     /* Waiting cursor                      */
    BOOL        SecondCodePage;

    /******************************************************************/
    /* First set up some useful variables.                            */
    /******************************************************************/
    PrinterType = pDMSettings->PrinterType;
    pDDT = DDT[PrinterType];

#ifdef OMIT
    /******************************************************************/
    /* Trap help messages                                             */
    /******************************************************************/
    if ( (msg >= HM_MSG_BASE) && (msg <= HM_INFORM))
    {
        if (msg == HM_ERROR)
        {
        }
    }
#endif

    /******************************************************************/
    /* Switch on the message type.                                    */
    /******************************************************************/
    switch ( msg )
    {

        case WM_HELP:
            /**********************************************************/
            /* PD00199 : The message is always going to go to the     */
            /* default handler, but give the driver a chance to do    */
            /* a little bit of processing first.                      */
            /**********************************************************/
            (VOID) prdm_HelpMessageProcessing ( hwnd, msg, lparam1, lparam2 );

            /**********************************************************/
            /* Now pass message to the default message handler.       */
            /**********************************************************/
            return(WinDefDlgProc( hwnd, msg, lparam1, lparam2 ));

        case WM_INITDLG:
            /**********************************************************/
            /* Turn off 'Close' and 'Task Manager' options on the     */
            /* system menu.                                           */
            /**********************************************************/
/*          prdm_RemoveMenuOptions( hwnd ); */

            /**********************************************************/
            /* First set the cursor to the hour glass pointer since   */
            /* displaying all the fonts can take some time.           */
            /**********************************************************/
            HourGlass = WinQuerySysPointer( HWND_DESKTOP,
                                            SPTR_WAIT,
                                            FALSE );

            Result = WinSetPointer( HWND_DESKTOP,
                                    HourGlass );

            TRACE6(TFUNC, "Set pointer result", &Result, 1);

            /**********************************************************/
            /* Initialize the list of default fonts to be displayed   */
            /* if we haven't already done it.                         */
            /**********************************************************/
            if (DMData.DefaultFontList.DefaultFontTable == FNULL)
            {
                 prdm_InitDfltFontList( hwnd, DB_LST_PP_DFLTFONTS );
            }

            /**********************************************************/
            /* Display the list of default fonts.                     */
            /**********************************************************/
            prdm_DisplayDefaultFontList( hwnd, DB_LST_PP_DFLTFONTS );

            /**********************************************************/
            /* Ensure the cursor is reset to its original shape.      */
            /**********************************************************/
            Result = WinSetPointer( HWND_DESKTOP,
                                    (HPOINTER)DMData.CursorHandle );

            /**********************************************************/
            /* Set the initial focus.                                 */
            /**********************************************************/
            DlgResult = WinSetFocus( HWND_DESKTOP,
                                     WinWindowFromID(hwnd, DB_PSH_ENTER));

            /**********************************************************/
            /* Set the active window help table.                      */
            /* PD00263 : Remove set active window. Now window always  */
            /* appears in the same place.                             */
            /**********************************************************/
#if 0
//          WinSendMsg( DMData.hwndHelp,
//                      HM_SET_ACTIVE_WINDOW,
//                      hwnd,
//                      hwnd );
#endif
            break;

        case WM_CLOSE:
            /**********************************************************/
            /* Trap Close from system menu                            */
            /* Note: this will fall into WM_COMMAND with CANCEL set   */
            /**********************************************************/
         /* SHORT1FROMMP(lparam1) = DB_PSH_CANCEL; */
            lparam1 = MPFROM2SHORT( DB_PSH_CANCEL,           /*CON3201*/
                                    SHORT2FROMMP(lparam1) ); /*CON3201*/

        case WM_COMMAND:
            /**********************************************************/
            /* The message is a command (i.e. a button) so switch     */
            /* depending on which button it was.                      */
            /**********************************************************/
            switch ( SHORT1FROMMP(lparam1) )
            {
              case DB_PSH_ENTER:
                /******************************************************/
                /* Process the newly selected font.                   */
                /******************************************************/
                prdm_EnterFontValue( hwnd, DB_LST_PP_DFLTFONTS );

                /******************************************************/
                /* Dismiss the dialog box.                            */
                /******************************************************/
                WinDismissDlg( hwnd, TRUE );
                break;

              case DID_CANCEL:
              case DB_PSH_CANCEL:
                /******************************************************/
                /* Dismiss the dialog box.                            */
                /******************************************************/
                WinDismissDlg( hwnd, FALSE );
                break;

              default:
                break;
            }
            /*.. switch (SHORT1FROMMP(lparam1)) ......................*/

            break;

        case WM_CONTROL:
            /**********************************************************/
            /* Default outline font pointsize selection   PD00137     */
            /**********************************************************/
            if( (SHORT1FROMMP(lparam1) == DB_LST_PP_DFLTFONTS)
                  && (SHORT2FROMMP(lparam1) == LN_SELECT) )
            {
               prdm_DfltFontPSzControlProc(hwnd,DB_LST_PP_DFLTFONTS);
            }
            break;

        default:
            /**********************************************************/
            /* Pass any other messages to the default handler         */
            /**********************************************************/
            return(WinDefDlgProc( hwnd, msg, lparam1, lparam2 ));
            break;
    }
    /*.. switch (msg) ................................................*/

}
#undef TFUNC




/**********************************************************************/
/*                                                                    */
/*   FUNCTION: prdm_InitDfltFontList                                  */
/*                                                                    */
/*   PARAMETERS:                                                      */
/*                                                                    */
/*   HWND    hwnd;                                                    */
/*   USHORT  WindowID;         Output default font list box ID        */
/*                                                                    */
/*   DESCRIPTION:                                                     */
/*                                                                    */
/*   This function allocates memory for the default font list, sets   */
/*   up the system font entry, and then adds each resident, codepage, */
/*   and card font to the list.                                       */
/*                                                                    */
/**********************************************************************/
#if 0
VOID prdm_InitDfltFontList( hwnd,
                            WindowID )

HWND      hwnd;
USHORT    WindowID;
#endif

VOID prdm_InitDfltFontList( HWND   hwnd,                   /* CON3201 */
                            USHORT WindowID )              /* CON3201 */

{
#define TFUNC "prdm_InitDftFnt"

    /******************************************************************/
    /* Local Variables                                                */
    /******************************************************************/
    USHORT              Result;
    lpDfltFontList      DefaultFontList;
    lpFMFFontList       ResFontList;
    lpDDTType           pDDT;
    USHORT              PrinterType;
    lpDVTCPSource       CodePageCaps;   /* Code Page info for printer */
    USHORT              i;
    USHORT              SlotNumber;
    USHORT              CardIndex;
    SHORT               OwnedIndex;     /* CON3203 CHANGED TO SHORT */
    USHORT              NoOfResidentFonts;
    BOOL                CP850Resident;
    BOOL                InitDownloadCP;
    lpFontDescType      pFontDesc;

    /******************************************************************/
    /* Set up local pointers.                                         */
    /******************************************************************/
    PrinterType = pDMSettings->PrinterType;
    pDDT = DDT[PrinterType];
    DefaultFontList = &(DMData.DefaultFontList);


    /******************************************************************/
    /* Initialize the default memory table.                           */
    /******************************************************************/
    prdm_FontTableMemory( );

    if (DefaultFontList->FontError)
    {
        TRACE8(TFUNC, "SSALLOCSEG Error", FNULL, 0);
        return;
    }

    /******************************************************************/
    /* A local pointer to make this code look decent.                 */
    /******************************************************************/
    pFontDesc = &(DefaultFontList->DefaultFontTable[0].FontDescription);

    /******************************************************************/
    /* Set up defaults depending on window. For Printer Properties    */
    /* we get the defaults from DMData.                               */
    /******************************************************************/
    if (WindowID == DB_LST_PP_DFLTFONTS)
    {
        /**************************************************************/
        /* Set up DefaultFontList and DefaultFontTable[0] depending   */
        /* on whether the font is engine or not.                      */
        /**************************************************************/
        if (DMData.DfltFontInfo.Info.Type == FT_ENGINE)
        {
            DefaultFontList->DefaultFontIndex = 0;
            DefaultFontList->DefaultFontFound = TRUE;
        }
        else
        {
            DefaultFontList->DefaultFontIndex = 0;
            DefaultFontList->DefaultFontFound = FALSE;

            pFontDesc->FontType = DMData.DfltFontInfo.Info.Type;

            pFontDesc->FontIndex = DMData.DfltFontInfo.Info.Index;

            pFontDesc->FontCodePage  =
                                   DMData.DfltFontInfo.Info.CodePageNo;

            prdu_strcpy ( (PBYTE)pFontDesc->FontCardName,
                          (PBYTE)DMData.DfltFontInfo.CardName );
        }
    }

    /******************************************************************/
    /* Set up defaults depending on window. For Job Properties we get */
    /* the defaults from DMDrivData.                                  */
    /******************************************************************/
    /******************************************************************/
    /* PD00242 : Default font list box for the 4029 has the           */
    /*           help panel associated with it.  The list box that    */
    /*           goes with the 4029 must have a separate ID number.   */
    /******************************************************************/
    if ((WindowID == DB_LST_JP_DFLTFONTS)
       || (WindowID == DB_LST_JP_DFLTFONTS_4029))
    {
        if (pDMDrivData->Type == FT_ENGINE)
        {
            DefaultFontList->DefaultFontIndex = 0;
            DefaultFontList->DefaultFontFound = TRUE;
        }
        else
        {
            DefaultFontList->DefaultFontIndex = 0;
            DefaultFontList->DefaultFontFound = FALSE;

            pFontDesc->FontType     = pDMDrivData->Type;
            pFontDesc->FontIndex    = pDMDrivData->Index;
            pFontDesc->FontCodePage = pDMDrivData->CodePageNo;

            prdu_strcpy ( (PBYTE)pFontDesc->FontCardName,
                          (PBYTE)pDMDrivData->CardName );
        }
    }
    /******************************************************************/
    /* Make sure all fields are cleared in FontList.                  */
    /******************************************************************/
    DefaultFontList->FontError = 0;
    DefaultFontList->InvalidEntries = 0;
    DefaultFontList->CurrentEntry;

    /******************************************************************/
    /* Add the resident fonts to the table.                           */
    /******************************************************************/
    ResFontList = prdm_ResidentFonts( );

    /******************************************************************/
    /* Could have had a memory allocation error so check it to see    */
    /* if we can continue.                                            */
    /******************************************************************/
    if (DefaultFontList->FontError == FATAL_MEMORY_ALLOCATION_ERROR)
    {
        TRACE8(TFUNC, "SSALLOCSEG Error", FNULL, 0);
        return;
    }

    /******************************************************************/
    /* PD00220 : Get rid of call to prdm_CodePageFonts as we do not   */
    /* display codepages in the list.                                 */
    /******************************************************************/

    /******************************************************************/
    /* Process the card in each slot.                                 */
    /******************************************************************/

    for ( i = 0; i < pDDT->DDTNoOfCardSlots; i++ )
    {
        /**************************************************************/
        /* If no card is installed in this slot then skip out of the  */
        /* loop.                                                      */
        /**************************************************************/
        OwnedIndex = DMData.Slot[i].Index;
        TRACE6(TFUNC, "Owned index", &OwnedIndex, 1);

        if ( OwnedIndex == NO_CARD_IN_SLOT )
        {
            TRACE6(TFUNC, "No card in slot", &i, 1);
            continue;
        }

        /**************************************************************/
        /* Check if the card in the second slot is the same as the    */
        /* one in the first.                                          */
        /**************************************************************/
        if ( (i == 1) && (OwnedIndex == DMData.Slot[0].Index ) )
        {
            TRACE6(TFUNC, "Cards the same", FNULL, 0);
            continue;
        }

        /**************************************************************/
        /* Process the fonts in each card.                            */
        /**************************************************************/
        prdm_CardFonts( i );

    }
    /*.... for ( i = 0; i < Number of Card slots; i++ ) ..............*/


    NoOfResidentFonts = pDDT->DDTNoOfResidentFonts;

    /******************************************************************/
    /* DIAL/NILE : If its a nile/tiber # of resident fonts     */
    /* is not set up in globlal DDTs.             */
    /******************************************************************/
    if (pDDT->DDTFontFlags & DDT_NLS_FONTS_OPTIONAL)
    {
        if ( (PrinterType == IBM_NILE_9) ||
             (PrinterType == IBM_TIBER_9) )
        {
            if (pDMSettings->MachineType == NLS_MACHINE)
                NoOfResidentFonts = NLS_9WIRE;
            else
                NoOfResidentFonts = US_9WIRE;
        }
        else /* its a 24-wire */
        {
            if (pDMSettings->MachineType == NLS_MACHINE)
                NoOfResidentFonts = NLS_24WIRE;
            else
                NoOfResidentFonts = US_24WIRE;

        }
    }

    /******************************************************************/
    /* Now cycle through the local resident font list and             */
    /* deallocate the memory if it is a dummy FMF.                    */
    /******************************************************************/
    for ( i = 0; i < NoOfResidentFonts; i++ )
    {
        /**************************************************************/
        /* DEBUG_SEGMENTS : free segment if it was allocated.         */
        /**************************************************************/
        if ( ResFontList[i].SegmentAllocFlag )
        {
         /* SSFREESEG( SELECTOROF(ResFontList[i].FMFAddress) ); */
            SSFREEMEM( ResFontList[i].FMFAddress );        /* CON3201 */
            ResFontList[i].FMFAddress = FNULL;
            ResFontList[i].SegmentAllocFlag = FALSE;
        }
    }

    /******************************************************************/
    /* Now deallocate memory used by ResFontList.                     */
    /******************************************************************/
 /* SSFREESEG( SELECTOROF(ResFontList) ); */
    SSFREEMEM( ResFontList );                              /* CON3201 */
    ResFontList = FNULL;

    /******************************************************************/
    /* Return                                                         */
    /******************************************************************/
    TRACE8(TFUNC, "Exit OK", FNULL, 0);
    return;

}
#undef TFUNC


/**********************************************************************/
/*                                                                    */
/*   Function        = prdm_DisplayDefaultFontList                    */
/*                                                                    */
/*   PARAMETERS:                                                      */
/*                                                                    */
/*   HWND             hwnd        Window handle                       */
/*   USHORT           WindowID    Output default font list box ID     */
/*                                                                    */
/*   DESCRIPTION:                                                     */
/*                                                                    */
/*   This function displays each font in the default font list,       */
/*   highlighting the default.                                        */
/*                                                                    */
/**********************************************************************/
#if 0
void prdm_DisplayDefaultFontList( hwnd,
                                  WindowID )

HWND              hwnd;
USHORT            WindowID;
#endif

void prdm_DisplayDefaultFontList( HWND   hwnd,             /* CON3201 */
                                  USHORT WindowID )        /* CON3201 */

{
#define TFUNC "prdm_DspDftFntLst"

    /******************************************************************/
    /* Local Variables                                                */
    /******************************************************************/
    USHORT          i,j;               /* Loop variable               */
    PBYTE           pSource, pDest;    /* Working pointers            */
    SHORT           ReqdNo;            /* Variables used to create    */
    SHORT           Divisor;           /*   dialog box entry          */
    MRESULT         DlgResult;
    lpDDTType       pDDT;

    lpDfltFontTable      DefaultFontTable;
    lpDfltFontList       DefaultFontList;
    USHORT               CurrentEntry;
    USHORT               Highlite;
    USHORT               CodePage;
    USHORT               PointSize;
    SHORT                SelectedIndex;

    LONG                 TempEngineVersion;

    /******************************************************************/
    /* First set up some pointers.                                    */
    /******************************************************************/
    pDDT = DDT[pDMSettings->PrinterType];
    DefaultFontList = &(DMData.DefaultFontList);
    DefaultFontTable = DefaultFontList->DefaultFontTable;
    CurrentEntry = DefaultFontList->CurrentEntry;
    Highlite = DefaultFontList->DefaultFontIndex;

    /******************************************************************/
    /* Check for any errors.                                          */
    /******************************************************************/
    if ( DefaultFontList->FontError == FATAL_MEMORY_ALLOCATION_ERROR )
    {
         /*************************************************************/
         /* No memory was allocated so can't display the list.        */
         /*************************************************************/
         WinLoadString( hab,
                        DMData.HModule,
                        IDS_NO_DFLT_FONT_MEM,
                        SLEN_BOX_MESSAGE,
                        (PSZ)szMessage );


         WinMessageBox( HWND_DESKTOP,
                        hwnd,
                        (PSZ)szMessage,
                        (PSZ)szCaption,
                        WindowID,
                        MB_OK );

         return;
    }
    else
    {
        /**************************************************************/
        /* No fatal error so check for a non-fatal one                */
        /**************************************************************/
        if ( DefaultFontList->FontError == SOME_FONTS_NOT_LOCATED )
        {
             /*********************************************************/
             /* One or more fonts could not be located, so inform the */
             /* user, but display the list anyway.                    */
             /*********************************************************/
             WinLoadString( hab,
                            DMData.HModule,
                            IDS_FONTS_NOT_LOCATED,
                            SLEN_BOX_MESSAGE,
                            (PSZ)szMessage );


             WinMessageBox( HWND_DESKTOP,
                            hwnd,
                            (PSZ)szMessage,
                            (PSZ)szCaption,
                            WindowID,
                            MB_OK );

        } /* ... if ( DefaultFontList->FontError == SOME_FONTS_ ... */
    } /* ... else No fatal errors ... */

    /******************************************************************/
    /* Display each valid entry in the default font table.            */
    /******************************************************************/
    for (i = 0; i <= CurrentEntry; i++)
    {
       /***************************************************************/
       /* Initialize buffer.                                          */
       /***************************************************************/
       pDest = szMessage;

       /***************************************************************/
       /* If the entry is invalid, don't display it.  Go on to the    */
       /* next entry.                                                 */
       /***************************************************************/
       if (!DefaultFontTable[i].Valid)
       {
           /***********************************************************/
           /* Need to get the index of the default font in the        */
           /* displayed list. We do this by decrementing the index    */
           /* for invalid entries til we get to the default entry.    */
           /***********************************************************/
       if ( DefaultFontList->DefaultFontIndex > i )
           Highlite--;
           continue;
       }

       /***************************************************************/
       /* Get the codepage and point size.                            */
       /***************************************************************/
       CodePage  = DefaultFontTable[i].FontMatch.CodePage;
       PointSize = DefaultFontTable[i].FontMatch.PointSize;

       /***************************************************************/
       /* Build the entry as follows:                                 */
       /*   Code Page ...  then some space                            */
       /*   Point Size ..  then some space                            */
       /*   Typeface                                                  */
       /*                                                             */
       /* DIAL/NILE : Now we won't mention the code page for the      */
       /* Pro's and Nile/Tiber as they never show up.                 */
       /***************************************************************/

       TempEngineVersion = GreQueryEngineVersion();
       if ( pDDT->DDTDEFNT_DialogId != DB_DEFAULT_FONTS_NO_CP )
       {
           /***********************************************************/
           /* Get the code page as five characters.                   */
           /* Leading zeros are replaced by two spaces (since digits  */
           /* are written to the screen with double the width of a    */
           /* space).                                                 */
           /* Start with some space.                                  */
           /***********************************************************/
           *pDest++ = ' ';
           *pDest++ = ' ';

           TRACE4(TFUNC, "Code page", &CodePage, 1);

           for ( ReqdNo = CodePage, Divisor = 10000;
                  ( ReqdNo < Divisor ) && ( Divisor > 1 );
                  Divisor /= 10 )
           {
               *pDest++ = ' ';
               if (TempEngineVersion<513L)                 /* PD00774 */
                   *pDest++ = ' ';
           }

           for ( ; ( Divisor > 1 ); Divisor /= 10 )
           {
               *pDest++ = (BYTE)( ReqdNo / Divisor ) + '0';
               ReqdNo %= Divisor;
           }

           if (CodePage != 0)
           {
               *pDest++ = (BYTE)ReqdNo + '0';
           }
           else
           {
               *pDest++ = ' ';
               *pDest++ = ' ';
           }


           /**************************************************************/
           /* Pad with some space.                                       */
           /**************************************************************/
           if (TempEngineVersion<513L)                     /* PD00774 */
           {
               for ( j = 0; j < 7; j++ )
                   *pDest++ = ' ';
           }
           else
           {
               for ( j = 0; j < 5; j++ )
                   *pDest++ = ' ';
           }

       } /* ... if (pDDT->DDTFontFlags & DDT_DISPLAY_CODE_PAGE) ...      */

       /******************************************************************/
       /* Get the point size as six characters - allow for factor of 10  */
       /* as metrics files hold point size in 1/720ths not 1/72ths as is */
       /* normal.  Leading zeros are replaced with two spaces.           */
       /******************************************************************/
       if ( pDDT->DDTFontFlags & DDT_DISPLAY_POINT_SIZE )
       {
           TRACE4(TFUNC, "Point size", &PointSize, 1);

           for ( ReqdNo = PointSize, Divisor = 10000;
                  ( ReqdNo < Divisor ) && ( Divisor > 1 );
                  Divisor /= 10 )
           {
               *pDest++ = ' ';
               if (TempEngineVersion<513L)                 /* PD00774 */
                   *pDest++ = ' ';
           }

           for ( ; ( Divisor > 1 ); Divisor /= 10 )
           {
               *pDest++ = (BYTE)( ReqdNo / Divisor ) + '0';
               ReqdNo %= Divisor;
           }
           /**************************************************************/
           /* Use decimal point from PMNational, not just a '.'          */
           /**************************************************************/
           if (PointSize != 0)
           {
               *pDest++ = (BYTE)DMData.DecimalPoint;
               *pDest++ = (BYTE)ReqdNo + '0';

           }
           else
           {
               /*******************************************************/
               /* Don't have a specific point size so put in some     */
               /* spaces.                                             */
               /*******************************************************/
               *pDest++ = ' ';
               *pDest++ = ' ';
               *pDest++ = ' ';
           }

           /**************************************************************/
           /* Pad with some space.                                       */
           /**************************************************************/
           *pDest++ = ' ';
           if (TempEngineVersion<513L)                     /* PD00774 */
               *pDest++ = ' ';
           *pDest++ = ' ';
       }

       /******************************************************************/
       /* Pad with some space.                                           */
       /******************************************************************/
       if (TempEngineVersion<513L)                         /* PD00774 */
       {
           for ( j = 0; j < 8; j++ )
               *pDest++ = ' ';
       }
       else
       {
           for ( j = 0; j < 6; j++ )
               *pDest++ = ' ';
       }

       /******************************************************************/
       /* Copy the typeface across and add a null terminator.            */
       /******************************************************************/
       TRACE4(TFUNC, "Typeface", &(DefaultFontTable[i]->
                                                  FontMatch.Facename), 6);

       /******************************************************************/
       /* Copy face name across, checking for decimal point charcters.   */
       /******************************************************************/
       pSource = (PBYTE) DefaultFontTable[i].FontMatch.Facename;
    /* prdm_CopyFaceNameAcross( (PBYTE far *)&pDest,   */
    /*                          (PBYTE far *)&pSource, */
       prdm_CopyFaceNameAcross( (PBYTE *)&pDest,           /* CON3201 */
                                (PBYTE *)&pSource,         /* CON3201 */
                                &DMData.DecimalPoint );


       *pDest++ = '\0';

       DlgResult = WinSendDlgItemMsg( hwnd,
                                      WindowID,
                                      LM_INSERTITEM,
                                      (MPARAM)(ULONG)LIT_END,
                                      MPFROMP(szMessage) );

       TRACE4(TFUNC, "Display entry result", &DlgResult, 1);

    }  /* ... for (i = 0; i <= CurrentEntry; i++) ...                 */

    /******************************************************************/
    /* Check to see if we've found the default font.  If we haven't   */
    /* set the default font to the default default font (i.e. the     */
    /* first device font in the list box.                             */
    /******************************************************************/
    if ( !DefaultFontList->DefaultFontFound )
    {
        DefaultFontList->DefaultFontIndex = 1;
        DefaultFontList->DefaultFontFound = TRUE;
        Highlite = 1;

    } /* ... if ( !DefaultFontList->DefaultFontFound ) ... */

    /******************************************************************/
    /* Highlight the default font.                                    */
    /******************************************************************/
    DlgResult = WinSendDlgItemMsg( hwnd,
                                   WindowID,
                                   LM_SELECTITEM,
                                   MPFROMSHORT(Highlite),
                                   (MPARAM)(ULONG)TRUE );

    /******************************************************************/
    /* Default outline font selection                    PD00137      */
    /******************************************************************/

    /******************************************************************/
    /* Get the pointsize listbox ID and disable the window.           */
    /******************************************************************/
    SelectedIndex = -1;
    if (WindowID == DB_LST_PP_DFLTFONTS)
       WindowID = DB_LST_PPPOINTSZ;
    else
       WindowID = DB_LST_JPPOINTSZ;


    /******************************************************************/
    /* If default font is resident outline font (pointsize will be 0) */
    /*    Enable the pointsize listbox                                */
    /*    display the pointsizes in the listbox                       */
    /*    Highlite the pointsize from ini or driver data              */
    /******************************************************************/
    /******************************************************************/
    /* PD00341  Pointsize selection for card fonts                    */
    /******************************************************************/
    if ( (Highlite != 0) &&
         (!(DefaultFontTable[Highlite].FontMatch.PointSize)) &&
         ((DefaultFontTable[Highlite].FontDescription.FontType == FT_RESIDENT)
         || (DefaultFontTable[Highlite].FontDescription.FontType == FT_CARD)) )
    {
       prdm_DisplayPointSzList( hwnd, WindowID);
       if (WindowID == DB_LST_PPPOINTSZ)
            SelectedIndex =
                     (SHORT)prdm_GetPointSzIndex(pDMSettings->DfltFontPointSz);
       if (WindowID == DB_LST_JPPOINTSZ)
            SelectedIndex =
                     (SHORT)prdm_GetPointSzIndex(pDMDrivData->DfltFontPointSz);

       if (SelectedIndex != -1)
       {
          DlgResult = WinSendDlgItemMsg(
                                        hwnd,
                                        WindowID,
                                        LM_SELECTITEM,
                                        (MPARAM)(ULONG)SelectedIndex,
                                        (MPARAM)(ULONG)TRUE );
       }
    }


    TRACE6(TFUNC, "Hilite the default ", &DlgResult, 1);

    return;
}
#undef TFUNC


/**********************************************************************/
/*                                                                    */
/*   Function        = prdm_EnterFontValue                            */
/*                                                                    */
/*   PARAMETERS:                                                      */
/*                                                                    */
/*   HWND             hwnd        Window handle                       */
/*   USHORT           WindowID    Window ID of list box               */
/*                                                                    */
/*   DESCRIPTION:                                                     */
/*                                                                    */
/*   This function updates default font info in default font list.    */
/*                                                                    */
/**********************************************************************/
#if 0
VOID prdm_EnterFontValue( hwnd,
                          WindowID)

HWND      hwnd;
USHORT    WindowID;
#endif

VOID prdm_EnterFontValue( HWND   hwnd,                     /* CON3201 */
                          USHORT WindowID)                 /* CON3201 */

{
#define TFUNC "prdm_EnterFontVal"

    /******************************************************************/
    /* Local Variables                                                */
    /******************************************************************/
    lpDfltFontTable      FontTable;
    lpDfltFontList       DefaultFontList;
    USHORT               PrinterType;
    SHORT                SelectIndex;
    USHORT               SelectedPointSz;
    USHORT               i, j;

    /******************************************************************/
    /* Set up local pointers.                                         */
    /******************************************************************/
    DefaultFontList = &(DMData.DefaultFontList);
    FontTable = DefaultFontList->DefaultFontTable;
    PrinterType = pDMSettings->PrinterType;

    /******************************************************************/
    /* Check if a font has been selected.                             */
    /******************************************************************/
    SelectIndex = SHORT1FROMMR( WinSendDlgItemMsg(
                                    hwnd,
                                    WindowID,
                                    LM_QUERYSELECTION,
                                    MPFROMSHORT(LIT_FIRST),
                                    FNULL) );

    TRACE6(TFUNC, "Selected index", &SelectIndex, 1);
    /******************************************************************/
    /* Reset the "position in source" value, depending on the window. */
    /* This is not used for system font or resident                   */
    /* fonts, but it needs to be set to zero.                         */
    /******************************************************************/
    if (WindowID == DB_LST_PP_DFLTFONTS)
    {
        DMData.DfltFontInfo.Info.CodePageNo = 0;
        DMData.DfltFontInfo.IndexInCard     = 0;
    }

    {
        pDMDrivData->CodePageNo = 0;
        pDMDrivData->Index      = 0;
    }

    /******************************************************************/
    /* Initialize j to selected font                                  */
    /******************************************************************/
    j = SelectIndex;

    if ( SelectIndex != LIT_NONE )
    {
        /**************************************************************/
        /* If there are invalid entries in the DefaultFontTable, we   */
        /* have to convert the index of the highlighted font to the   */
        /* correct one in the DefaultFontTable.                       */
        /**************************************************************/
        if (DefaultFontList->InvalidEntries)
        {
            for (i = 0, j = 0; i <= SelectIndex; i++, j++)
            {
                /******************************************************/
                /* increment index to add in the invalid entries.     */
                /******************************************************/
                if (!FontTable[i].Valid)
                    j++;
            }
        }

        /**************************************************************/
        /* Copy highlighted font info into entry 0, clearing index,   */
        /* codepage, and card name for the system font case.          */
        /**************************************************************/
        if (SelectIndex == 0)
        {
            FontTable[0].FontDescription.FontType = FT_ENGINE;
            FontTable[0].FontDescription.FontIndex = 0;
            FontTable[0].FontDescription.FontCodePage = 0;
            for (i = 0; i < 10; i++)
                FontTable[0].FontDescription.FontCardName[i] = '\0';
        }
        else
        {
        FontTable[0].FontDescription.FontType =
                          FontTable[j].FontDescription.FontType;
        FontTable[0].FontDescription.FontIndex =
                         FontTable[j].FontDescription.FontIndex;
        FontTable[0].FontDescription.FontCodePage =
                      FontTable[j].FontDescription.FontCodePage;

        prdu_strcpy ( (PBYTE) FontTable[0].FontDescription.FontCardName,
                      (PBYTE) FontTable[j].FontDescription.FontCardName );
        }

        /**************************************************************/
        /* Save the new index so we can display it next time.         */
        /**************************************************************/
        DefaultFontList->DefaultFontIndex = j;

        /*************************************************************/
        /* Default outline font selection                 PD00137      */
        /***************************************************************/

        /**************************************************************/
        /* If the entered font is a resident outline font, get the    */
        /* pointsize value selected, from the index of the point sizes*/
        /* in the list box                                            */
        /**************************************************************/
        /**************************************************************/
        /* PD00341  Pointsize selection for card fonts                */
        /**************************************************************/
        /**********************************************************************/
        /* PD00492 : Use index of j instead of 0 in FontTable array in        */
        /* the following if statement since FontTable[0].FontMatch.PointSize  */
        /* has not been initialized.                                          */
        /**********************************************************************/
        if ( ((FontTable[j].FontDescription.FontType == FT_RESIDENT)
             || (FontTable[j].FontDescription.FontType == FT_CARD))
              && (FontTable[j].FontMatch.PointSize==0) )
        {
           if (WindowID == DB_LST_PP_DFLTFONTS)
           {
               SelectedPointSz = prdm_EnterFontPointSz(hwnd,DB_LST_PPPOINTSZ);
               pDMSettings->DfltFontPointSz = SelectedPointSz;

           }

           if (WindowID == DB_LST_JP_DFLTFONTS_4029)
           {
               SelectedPointSz = prdm_EnterFontPointSz(hwnd,DB_LST_JPPOINTSZ);
               pDMDrivData->DfltFontPointSz = SelectedPointSz;

           }
       }


        /**************************************************************/
        /* Store the details of the default font in DMData and also   */
        /* set the DfltFontInfoSize field in DMSettings if we're in   */
        /* the Printer Properties default font dialog.                */
        /**************************************************************/
        if (WindowID == DB_LST_PP_DFLTFONTS)
        {
             DMData.DfltFontInfo.Info.Type =
                                  FontTable[0].FontDescription.FontType;

             switch (DMData.DfltFontInfo.Info.Type)
             {
                 case FT_ENGINE:
                     pDMSettings->DfltFontInfoSize =
                                                    DFLTFONT_ENGINE_LEN;
                     break;

                 case FT_RESIDENT:
                     DMData.DfltFontInfo.Info.Index =
                                 FontTable[0].FontDescription.FontIndex;
                     pDMSettings->DfltFontInfoSize =
                                                  DFLTFONT_RESIDENT_LEN;
                     break;

                 case FT_CODE_PAGE:
                     DMData.DfltFontInfo.Info.Index  =
                                 FontTable[0].FontDescription.FontIndex;
                     DMData.DfltFontInfo.Info.CodePageNo =
                              FontTable[0].FontDescription.FontCodePage;
                     pDMSettings->DfltFontInfoSize  =
                                                 DFLTFONT_CODE_PAGE_LEN;
                     break;

                 /*****************************************************/
                 /* Make sure the default font info is changed at the */
                 /* start of the next job.                            */
                 /*****************************************************/
                 DMIniEntry[PrinterType].DataChange |= DFLT_FONT_CHANGE;
             }
        }

        /**************************************************************/
        /* Store the details of the default font in DrivData if we're */
        /* in Job Properties.                                         */
        /**************************************************************/
        /******************************************************************/
        /* PD00242 : Default font list box for the 4029 has the           */
        /*           help panel associated with it.  The list box that    */
        /*           goes with the 4029 must have a separate ID number.   */
        /******************************************************************/
        if ((WindowID == DB_LST_JP_DFLTFONTS)
           || (WindowID == DB_LST_JP_DFLTFONTS_4029))
        {
             pDMDrivData->Type = FontTable[0].FontDescription.FontType;
             /*****************************************************************/
             /*  PD00651 : Store Machine Type when entering out of Job Prop.  */
             /*****************************************************************/
             pDMDrivData->MachineType = pDMSettings->MachineType;

             switch (pDMDrivData->Type)
             {
                 case FT_ENGINE:
                     break;

                 case FT_RESIDENT:
                     pDMDrivData->Index  =
                                 FontTable[0].FontDescription.FontIndex;
                     break;

                 case FT_CODE_PAGE:
                     pDMDrivData->Index  =
                                 FontTable[0].FontDescription.FontIndex;
                     pDMDrivData->CodePageNo =
                              FontTable[0].FontDescription.FontCodePage;
                     break;

                 case FT_CARD:
                     pDMDrivData->Index =
                                 FontTable[0].FontDescription.FontIndex;
                     prdu_strcpy ( (PBYTE) pDMDrivData->CardName,
                                   (PBYTE) FontTable[0].
                                          FontDescription.FontCardName);
                     break;
             }
        }
    }
    /*..if ( SelectIndex != LIT_NONE )....................*/

    return;
}
#undef TFUNC


/**********************************************************************/
/*                                                                    */
/*   Function        = prdm_FontTableMemory                           */
/*                                                                    */
/*   PARAMETERS:                                                      */
/*                                                                    */
/*                                                                    */
/*   DESCRIPTION:                                                     */
/*                                                                    */
/*   This function allocates memory for the default font table        */
/*   and sets up the entry zero to be the system font.                */
/*                                                                    */
/**********************************************************************/

VOID prdm_FontTableMemory( )


{
#define TFUNC "prdm_FontTableMem"

    /******************************************************************/
    /* Local Variables                                                */
    /******************************************************************/
    lpDfltFontTable      DefaultFontTable;
    lpDfltFontList       DefaultFontList;
    USHORT               TableSize;
    USHORT               Result;

    /******************************************************************/
    /* Set up local pointers.                                         */
    /******************************************************************/
    DefaultFontList = &(DMData.DefaultFontList);

    /******************************************************************/
    /* Allocate memory for the DefaultFontTable                       */
    /******************************************************************/
    TableSize = FONT_TABLE_INCREMENT * sizeof(DfltFontTableEntry);
 /* Result = SSALLOCSEG( TableSize,                     */
 /*                      &SELECTOROF(DefaultFontTable), */
 /*                      0 );                           */
    Result = SafeSSALLOCMEM( &DefaultFontTable,                /* CON3201 */
                             TableSize, 0 );                   /* CON3201 */

    if ( Result != DOS_OK )
    {
     /* TRACE8(TFUNC, "SSALLOCSEG Error", FNULL, 0); */
        TRACE8(TFUNC, "SSALLOCMEM Error", FNULL, 0);       /* CON3201 */
        DefaultFontList->FontError = FATAL_MEMORY_ALLOCATION_ERROR;
        return;
    }

/*  OFFSETOF(DefaultFontTable) = 0;                           CON3201 */

    /******************************************************************/
    /* Set the allocated memory to all zeroes                         */
    /******************************************************************/
    prdu_memset( (PBYTE)DefaultFontTable,
                 '\0',
                 TableSize );

    /******************************************************************/
    /* Store the pointer to the font table in DMData                  */
    /******************************************************************/
    DefaultFontList->DefaultFontTable = DefaultFontTable;
    DefaultFontList->FontTableSize    = FONT_TABLE_INCREMENT;

    /******************************************************************/
    /* Store the facename of the system font in entry 0               */
    /******************************************************************/
    WinLoadString( hab,
                   DMData.HModule,
                   IDS_SYS_FONT,
                   32,
                   (PSZ)(DefaultFontTable[0].FontMatch.Facename) );

    /******************************************************************/
    /* Make the entry valid.                                          */
    /******************************************************************/
    DefaultFontTable[0].Valid = TRUE;

    /******************************************************************/
    /* Point to the next entry.                                       */
    /******************************************************************/
    DefaultFontList->CurrentEntry = 1;

    return;
}
#undef TFUNC

/**********************************************************************/
/*                                                                    */
/*   Function        = prdm_MoreFontTableMemory                       */
/*                                                                    */
/*   PARAMETERS:                                                      */
/*                                                                    */
/*                                                                    */
/*   DESCRIPTION:                                                     */
/*                                                                    */
/*   This function allocates more memory for the DefaultFontTable.    */
/*                                                                    */
/**********************************************************************/

VOID prdm_MoreFontTableMemory( )


{
#define TFUNC "prdm_MoreFontTabMem"

    /******************************************************************/
    /* Local Variables                                                */
    /******************************************************************/
    lpDfltFontTable      FontTable;
    lpDfltFontList       DefaultFontList;
    USHORT               TableSize;
    USHORT               Result;

    /******************************************************************/
    /* Set up local pointers.                                         */
    /******************************************************************/
    DefaultFontList = &(DMData.DefaultFontList);
    /******************************************************************/
    /* First we allocate a new table that is of the size of the old   */
    /* table plus the increment value.                                */
    /******************************************************************/
    TableSize = (DefaultFontList->FontTableSize +
                     FONT_TABLE_INCREMENT) * sizeof(DfltFontTableEntry);

 /* Result = SSALLOCSEG( TableSize,              */
 /*                      &SELECTOROF(FontTable), */
 /*                      0 );                    */
    Result = SafeSSALLOCMEM( &FontTable,                       /* CON3201 */
                             TableSize, 0 );                   /* CON3201 */


    if ( Result != DOS_OK )
    {
     /* TRACE8(TFUNC, "SSALLOCSEG Error", FNULL, 0); */
        TRACE8(TFUNC, "SSALLOCMEM Error", FNULL, 0);       /* CON3201 */
        DefaultFontList->FontError = FATAL_MEMORY_ALLOCATION_ERROR;
        return;
    }

/*  OFFSETOF(FontTable) = 0;                                  CON3201 */

    /******************************************************************/
    /* Set the allocated memory to all zeroes                         */
    /******************************************************************/
    prdu_memset( (PBYTE)FontTable,
                 '\0',
                 TableSize );

    /******************************************************************/
    /* Now copy the old table to the new table.                       */
    /******************************************************************/
    prdu_memcpy ( (PBYTE)FontTable,
                  (PBYTE)DefaultFontList->DefaultFontTable,
                  DefaultFontList->FontTableSize * sizeof(DfltFontTableEntry));

    /******************************************************************/
    /* Free the old table's memory                                    */
    /******************************************************************/
 /* SSFREESEG( SELECTOROF(DefaultFontList->DefaultFontTable ) ); */
    SSFREEMEM( DefaultFontList->DefaultFontTable );        /* CON3201 */

    /******************************************************************/
    /* Store the new table pointer and new table size into Default    */
    /* Font List.                                                     */
    /******************************************************************/
    DefaultFontList->DefaultFontTable = FontTable;
    DefaultFontList->FontTableSize   += FONT_TABLE_INCREMENT;

    /******************************************************************/
    /* Update CurrentEntry to point to the next entry                 */
    /******************************************************************/
    DefaultFontList->CurrentEntry++;

    DMData.DefaultFontList = *DefaultFontList;

    return;
}
#undef TFUNC


/**********************************************************************/
/*                                                                    */
/*   Function        = prdm_ReleaseFontTableMemory                    */
/*                                                                    */
/*   PARAMETERS:                                                      */
/*                                                                    */
/*                                                                    */
/*   DESCRIPTION:                                                     */
/*                                                                    */
/*   This function deallocates the memory allocated for the Default   */
/*   Font Table.                                                      */
/*                                                                    */
/**********************************************************************/

VOID prdm_ReleaseFontTableMemory( )


{
#define TFUNC "prdm_RelFtTabMem"

    /******************************************************************/
    /* Local Variables                                                */
    /******************************************************************/
    lpDfltFontList       DefaultFontList;

    /******************************************************************/
    /* Set up local pointers.                                         */
    /******************************************************************/
    DefaultFontList = &(DMData.DefaultFontList);

    /******************************************************************/
    /* If the pointer to the DefaultFontTable is not Null, deallocate */
    /* the memory.                                                    */
    /******************************************************************/
    if (DefaultFontList->DefaultFontTable != NULL)
     /* SSFREESEG( SELECTOROF(DefaultFontList->DefaultFontTable) ); */
        SSFREEMEM( DefaultFontList->DefaultFontTable );    /* CON3201 */

    /******************************************************************/
    /* Reset all other DefaultFontList fields                         */
    /******************************************************************/
    DefaultFontList->DefaultFontTable = FNULL;
    DefaultFontList->FontTableSize    = 0;
    DefaultFontList->CurrentEntry     = 0;
    DefaultFontList->DefaultFontFound = 0;
    DefaultFontList->DefaultFontIndex = 0;
    DefaultFontList->FontError        = 0;
    DefaultFontList->InvalidEntries   = 0;

    return;
}
#undef TFUNC

/**********************************************************************/
/*                                                                    */
/*   FUNCTION: prdm_CopyFaceNameAcross                                */
/*                                                                    */
/*   PARAMETERS:                                                      */
/*                                                                    */
/*                                                                    */
/*   PBYTE      far * ppDest      Destination String                  */
/*   PBYTE      far * ppSource    Source string                       */
/*   PBYTE            pDecimal    Decimal Point character             */
/*                                                                    */
/*   DESCRIPTION:                                                     */
/*                                                                    */
/*   This function parses a facename to change the decimal point      */
/*   character if it is present.                                      */
/*                                                                    */
/**********************************************************************/
#if 0
void prdm_CopyFaceNameAcross( ppDest,
                              ppSource,
                              pDecimal )

PBYTE      far * ppDest;
PBYTE      far * ppSource;
PBYTE            pDecimal;
#endif

void prdm_CopyFaceNameAcross( PBYTE *ppDest,               /* CON3201 */
                              PBYTE *ppSource,             /* CON3201 */
                              PBYTE  pDecimal )            /* CON3201 */

{
    for ( ; *(*ppSource) != '\0' ; (*ppSource)++, (*ppDest)++ )
    {
        if ( *(*ppSource) == '*' )
        {
            *(*ppDest) = *pDecimal;
        }
        else
        {
            *(*ppDest) = *(*ppSource);
        }
    }
    return;
}
