/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1992 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 source code is provided to you solely for       */
/*    the purpose of assisting you in your development of OS/2 device        */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Developer Connection Device Driver       */
/*    Source Kit for OS/2. This Copyright statement may not be removed.      */
/*                                                                           */
/*****************************************************************************/
/**************************************************************************
 *
 * SOURCE FILE NAME = PRDINIT
 *
 * DESCRIPTIVE NAME =
 *
 *
 * VERSION
 *
 * DATE
 *
 * DESCRIPTION
 *
 * FUNCTIONS
 *
 * ENTRY POINTS:
 *
 * DEPENDENCIES:
 *
 * NOTES
 *
 *
 * STRUCTURES
 *
 * EXTERNAL REFERENCES
 *
 * EXTERNAL FUNCTIONS
 *
*/

#define INCL_32                         /* Convert to C/SET2    CON3201       */
#define INCL_DOSPROCESS                 /* Convert to C/SET2    CON3201       */
#define INCL_DOSSEMAPHORES              /* Convert to C/SET2    CON3201       */
#define INCL_GREALL
#define INCL_GPIPRIMITIVES
#define INCL_WINHEAP
#define INCL_GPIBITMAPS
#include <os2.h>
#undef INCL_DOSPROCESS                  /* Convert to C/SET2    CON3201       */
#undef INCL_DOSSEMAPHORES               /* Convert to C/SET2    CON3201       */
#undef INCL_GREALL
#undef INCL_GPIPRIMITIVES
#undef INCL_WINHEAP
#undef INCL_GPIBITMAPS

#define INCL_DDIBUNDLES
#define INCL_DDIFONTSTRUCS
#define INCL_DDIDEFS
#include <pmddi.h>
#undef INCL_DDIBUNDLES
#undef INCL_DDIFONTSTRUCS
#undef INCL_DDIDEFS

#define INCL_WINP_SELECTIVE
#define INCL_WINP_SEI
#include <pmwinx.h>
#undef INCL_WINP_SELECTIVE
#undef INCL_WINP_SEI
#undef INCL_32                          /* Convert to C/SET2    CON3201       */

#include <prdacone.h>
#include <prdconse.h>
#include <prdlcone.h>
#include <prdtcone.h>

#define NO_SYS
#define INCL_HELP
#define NO_CONSTANT_INCL
#include <prdinclt.h>
#undef NO_CONSTANT_INCL
#undef NO_SYS
#undef INCL_HELP

extern void Int3();
extern HMTX  MutexSemTable[MUTEX_SEMAPHORE_TABLE_SIZE];

extern DeviceSemTableEntry DevSemTable[NO_OF_PRINTER_DEVICES];

extern DeviceSemTable lpDevSemTable;

extern HMTX    hmtxCreateHeapSem;
extern HMTX    hmtxGlobalHeapSem;
extern HMTX    hmtxJournalNameSem;  /* CON3201 - This variable is not referenced */
extern HMTX    hmtxBMLockSem;
extern HMTX    hmtxDeviceModeSem;

extern  PBYTE pbGlobalHeap;     /* Global Heap */
extern  HMODULE prdd_ModHandle;





/**********************************************************************/
/*                                                                    */
/*   FUNCTION: prde_InitSemaphores                                    */
/*                                                                    */
/*   PARAMETERS:                                                      */
/*                                                                    */
/*                                                                    */
/*                                                                    */
/*                                                                    */
/*                                                                    */
/*   DESCRIPTION:                                                     */
/*                                                                    */
/*                                                                    */
/*                                                                    */
/*                                                                    */
/**********************************************************************/
ULONG prde_InitSemaphores(VOID)
{
 /********************************************************************/
 /* Local Variables                                                  */
 /********************************************************************/
APIRET DosResult;

      /***************************************************************/
      /* CON3201 - Create the semaphores that are used by the        */
      /* the processes. A call should be made to this function where */
      /* these semaphores are created only if they do not exists.    */
      /* The problem is that the semaphores are removed from the     */
      /* system if there are no process which have access to them    */
      /* through either a DosCreateMutexSem or DosOpenMutexSem.      */
      /* Therefore we need to find a function where each process     */
      /* enters just once.  We should then test the semaphore using  */
      /* DosOpenMutexSemaphore and reinitialize based on those       */
      /* results                                                     */
      /***************************************************************/

/* CON3201 - Create Heap Semaphore */
DosResult = DosCreateMutexSem("\\SEM32\\CHEAP",
                                      &MutexSemTable[0], DC_SEM_SHARED, FALSE);
/* CON3201 - Global Heap Semaphore */
DosResult = DosCreateMutexSem("\\SEM32\\GHEAP",
                                      &MutexSemTable[1], DC_SEM_SHARED, FALSE);

DosResult = DosCreateMutexSem("\\SEM32\\JOURNAL",
                                      &MutexSemTable[2], DC_SEM_SHARED, FALSE);
/* CON3201 - Bitmap Lock semaphore */
DosResult = DosCreateMutexSem("\\SEM32\\BMLOCK",
                                      &MutexSemTable[3], DC_SEM_SHARED, FALSE);

DosResult = DosCreateMutexSem("\\SEM32\\LPT1",
                                      &MutexSemTable[4], DC_SEM_SHARED, FALSE);

DosResult = DosCreateMutexSem("\\SEM32\\LPT2",
                                      &MutexSemTable[5], DC_SEM_SHARED, FALSE);

DosResult = DosCreateMutexSem("\\SEM32\\LPT3",
                                      &MutexSemTable[6], DC_SEM_SHARED, FALSE);

DosResult = DosCreateMutexSem("\\SEM32\\LPT4",
                                      &MutexSemTable[7], DC_SEM_SHARED, FALSE);

DosResult = DosCreateMutexSem("\\SEM32\\LPT5",
                                      &MutexSemTable[8], DC_SEM_SHARED, FALSE);

DosResult = DosCreateMutexSem("\\SEM32\\LPT6",
                                      &MutexSemTable[9], DC_SEM_SHARED, FALSE);

DosResult = DosCreateMutexSem("\\SEM32\\LPT7",
                                     &MutexSemTable[10], DC_SEM_SHARED, FALSE);

DosResult = DosCreateMutexSem("\\SEM32\\LPT8",
                                     &MutexSemTable[11], DC_SEM_SHARED, FALSE);

DosResult = DosCreateMutexSem("\\SEM32\\LPT9",
                                     &MutexSemTable[12], DC_SEM_SHARED, FALSE);

DosResult = DosCreateMutexSem("\\SEM32\\COM1",
                                     &MutexSemTable[13], DC_SEM_SHARED, FALSE);

DosResult = DosCreateMutexSem("\\SEM32\\COM2",
                                     &MutexSemTable[14], DC_SEM_SHARED, FALSE);

DosResult = DosCreateMutexSem("\\SEM32\\COM3",
                                     &MutexSemTable[15], DC_SEM_SHARED, FALSE);

DosResult = DosCreateMutexSem("\\SEM32\\COM4",
                                     &MutexSemTable[16], DC_SEM_SHARED, FALSE);

DosResult = DosCreateMutexSem("\\SEM32\\COM5",
                                     &MutexSemTable[17], DC_SEM_SHARED, FALSE);

DosResult = DosCreateMutexSem("\\SEM32\\COM6",
                                     &MutexSemTable[18], DC_SEM_SHARED, FALSE);

DosResult = DosCreateMutexSem("\\SEM32\\COM7",
                                     &MutexSemTable[19], DC_SEM_SHARED, FALSE);

DosResult = DosCreateMutexSem("\\SEM32\\COM8",
                                     &MutexSemTable[20], DC_SEM_SHARED, FALSE);

DosResult = DosCreateMutexSem("\\SEM32\\COM9",
                                     &MutexSemTable[21], DC_SEM_SHARED, FALSE);

DosResult = DosCreateMutexSem("\\SEM32\\DEVMODE",
                                     &MutexSemTable[22], DC_SEM_SHARED, FALSE);

hmtxCreateHeapSem    = MutexSemTable[0];
hmtxGlobalHeapSem    = MutexSemTable[1];
hmtxJournalNameSem   = MutexSemTable[2];
hmtxBMLockSem        = MutexSemTable[3];
hmtxDeviceModeSem    = MutexSemTable[MUTEX_SEMAPHORE_TABLE_SIZE - 1];


return 0L;

}

ULONG _System _DLL_InitTerm (HMODULE hModule, ULONG ulFlag)
{
   APIRET rc;
/* haltproc();*/
/* int3();    */
   switch( ulFlag )
   {
       case 0:
           prdd_ModHandle = hModule;
           SSAllocMem(&pbGlobalHeap, 65535L, 0L);
           DosSubsetMem(pbGlobalHeap, DOSSUB_INIT, 65535L);
           break;
   case 1:
           DosSubUnset(pbGlobalHeap);
           SSFREEMEM(pbGlobalHeap);
           break;
       default:
           break;

   }
   return 1L;
}


