/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1992 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 source code is provided to you solely for       */
/*    the purpose of assisting you in your development of OS/2 device        */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Developer Connection Device Driver       */
/*    Source Kit for OS/2. This Copyright statement may not be removed.      */
/*                                                                           */
/*****************************************************************************/
/**************************************************************************
 *
 * SOURCE FILE NAME = PRDGADDB
 *
 * DESCRIPTIVE NAME =
 *
 *
 * VERSION
 *
 * DATE
 *
 * DESCRIPTION
 *
 * FUNCTIONS   prdg_AddBounds
 *
 * ENTRY POINTS:
 *
 * DEPENDENCIES:
 *
 * NOTES
 *
 *
 * STRUCTURES
 *
 * EXTERNAL REFERENCES
 *
 * EXTERNAL FUNCTIONS
 *
*/

#define INCL_32                         /* Convert to C/SET2    CON3201       */
#define INCL_DOSPROCESS                 /* Convert to C/SET2    CON3201       */
#define INCL_DOSSEMAPHORES
#define INCL_GPIPRIMITIVES
#define INCL_WINHEAP
#define INCL_GPIBITMAPS
#include <os2.h>
#undef INCL_DOSPROCESS                  /* Convert to C/SET2    CON3201       */
#undef INCL_DOSSEMAPHORES
#undef INCL_GPIPRIMITIVES
#undef INCL_WINHEAP
#undef INCL_GPIBITMAPS

#define INCL_DDIBUNDLES
#define INCL_DDIFONTSTRUCS
#define INCL_DDIDEFS
#define INCL_DDICOMFLAGS
#include <pmddi.h>
#undef INCL_DDIBUNDLES
#undef INCL_DDIFONTSTRUCS
#undef INCL_DDIDEFS
#define INCL_DDICOMFLAGS

#define INCL_WINP_SELECTIVE
#define INCL_WINP_SEI
#include <pmwinx.h>
#undef INCL_WINP_SELECTIVE
#undef INCL_WINP_SEI
#undef INCL_32                          /* Convert to C/SET2    CON3201       */

#include <prdconse.h>

#define NO_SYS
#define NO_CONSTANT_INCL
#include <prdinclt.h>
#undef NO_CONSTANT_INCL
#undef NO_SYS

#include <prdgextf.h>



/**********************************************************************/
/*                                                                    */
/*   FUNCTION: prdg_AddBounds                                         */
/*                                                                    */
/*   PARAMETERS:                                                      */
/*                                                                    */
/*   DevRect  far * BoundsRect;    Pointer to rectangle to be         */
/*                                 included in the bounds             */
/*   lpDCI          DCIData;       Pointer to DC Instance data        */
/*                                                                    */
/*   DESCRIPTION:                                                     */
/*                                                                    */
/*   This function incorporates the given rectangle  (BoundsRect)     */
/*   into the current overall bounds.                                 */
/*                                                                    */
/**********************************************************************/
#if 0
USHORT pascal prdg_AddBounds (BoundsRect, DCIData)

DevRect  far * BoundsRect;
lpDCI          DCIData;
#endif

USHORT prdg_AddBounds ( DevRect *BoundsRect,               /* CON3201 */
                        lpDCI    DCIData )                 /* CON3201 */

{
    WcsRect ModelBounds;

    TRACE4("prdgAddBounds", "New Bounds", BoundsRect, 2);
    TRACE4("prdgAddBounds", "DCI Bounds", DCIData->DCIBounds, 2);

    /******************************************************************/
    /* back transform the coordinates from device to model space and  */
    /* accumulate                                                     */
    /******************************************************************/
    if ( prdg_Convert((PULONG)BoundsRect,
                      (PULONG)ModelBounds,
                      COORD_DEVICE_WORD,
                      COORD_MODEL,
                      2L,
                      DCIData->DcH,
                      COM_TRANSFORM) != OK )
        return(ERROR_ZERO);

    if (DCIData->DCIBounds[0].X > ModelBounds[0].X)
        DCIData->DCIBounds[0].X = ModelBounds[0].X;

    if (DCIData->DCIBounds[0].Y > ModelBounds[0].Y)
        DCIData->DCIBounds[0].Y = ModelBounds[0].Y;

    if (DCIData->DCIBounds[1].X < ModelBounds[1].X)
        DCIData->DCIBounds[1].X = ModelBounds[1].X;

    if (DCIData->DCIBounds[1].Y < ModelBounds[1].Y)
        DCIData->DCIBounds[1].Y = ModelBounds[1].Y;


    TRACE4("prdgAddBounds", "DCI Bounds", DCIData->DCIBounds, 2);
    return(OK);
}

