/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1992 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 source code is provided to you solely for       */
/*    the purpose of assisting you in your development of OS/2 device        */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Developer Connection Device Driver       */
/*    Source Kit for OS/2. This Copyright statement may not be removed.      */
/*                                                                           */
/*****************************************************************************/
/**************************************************************************
 *
 * SOURCE FILE NAME = PRDFDFNT
 *
 * DESCRIPTIVE NAME =
 *
 *
 * VERSION
 *
 * DATE
 *
 * DESCRIPTION
 *
 * FUNCTIONS   EDF_Init
 *             EDF_GetFontHdr
 *             EDF_DLFCommand
 *             EDF_DownloadFont
 *             EDF_PurgeFont
 *             EDF_CreateFont
 *             EDF_DeleteFontHdr
 *             EDF_Terminate
 *             EDF_EndPage
 *
 * ENTRY POINTS:
 *
 * DEPENDENCIES:
 *
 * NOTES
 *
 *
 * STRUCTURES
 *
 * EXTERNAL REFERENCES
 *
 * EXTERNAL FUNCTIONS
 *
*/

#define INCL_32                         /* Convert to C/SET2    CON3201       */
#define INCL_DOSPROCESS                 /* Convert to C/SET2    CON3201       */
#define INCL_DOSSEMAPHORES
#define INCL_GPIPRIMITIVES
#define INCL_WINHEAP
#define INCL_GPIBITMAPS
#define INCL_GPIERRORS
#include <os2.h>
#undef INCL_DOSPROCESS                  /* Convert to C/SET2    CON3201       */
#undef INCL_DOSSEMAPHORES
#undef INCL_GPIPRIMITIVES
#undef INCL_WINHEAP
#undef INCL_GPIBITMAPS
#undef INCL_GPIERRORS

#define INCL_DDICOMFLAGS
#define INCL_DDIBUNDLES
#define INCL_DDIFONTSTRUCS
#define INCL_DDIDEFS
#define INCL_DDIMISC
#define INCL_GRE_XFORMS
#define INCL_GRE_LINES
#include <pmddi.h>
#undef INCL_DDICOMFLAGS
#undef INCL_DDIBUNDLES
#undef INCL_DDIFONTSTRUCS
#undef INCL_DDIDEFS
#undef INCL_DDIMISC
#undef INCL_GRE_XFORMS
#undef INCL_GRE_LINES

#define INCL_WINP_SELSERVER
#define INCL_WINP_SELECTIVE
#define INCL_WINP_SEI
#include <pmwinx.h>
#undef INCL_WINP_SELSERVER
#undef INCL_WINP_SELECTIVE
#undef INCL_WINP_SEI
#undef INCL_32                          /* Convert to C/SET2    CON3201       */

#include <prddcone.h>
#include <prdpcone.h>

#define PRDMTYPE_INCL
#define PRDLTYPE_INCL
#define PRDFTYPE_INCL
#define NO_CONSTANT_INCL
#include <prdinclt.h>
#undef NO_CONSTANT_INCL
#undef PRDMTYPE_INCL
#undef PRDLTYPE_INCL
#undef PRDFTYPE_INCL

#include <prdgextf.h>
#include <prdiextf.h>
#include <prdlextf.h>
#include <prdpextf.h>
#include <prdtextf.h>
#include <prduextf.h>
#include <prdfextf.h>



/**********************************************************************/
/*                                                                    */
/*   Function    :         EDF_Init                                   */
/*                                                                    */
/*                                                                    */
/*   When called :         From prde_EnableDC (prdeedc.c)             */
/*                                                                    */
/*   PARAMETERS  :                                                    */
/*                                                                    */
/*   lpDCI           DCIData       Pointer to DC Instance data        */
/*                                                                    */
/*                                                                    */
/*   DESCRIPTION :                                                    */
/*                                                                    */
/*   This function initializes the pointer to the linked list of      */
/*   downloadable engine font headers to NULL                         */
/*                                                                    */
/**********************************************************************/
#if 0
void EDF_Init( DCIData )
lpDCI   DCIData;
#endif
void EDF_Init( lpDCI DCIData )                             /* CON3201 */
{
   DCIData->DCIEDFList = NULL;
   return;
}


/**********************************************************************/
/*                                                                    */
/*   Function    :   EDF_DLFCommand                                   */
/*                                                                    */
/*   When called :   EDF_DownLoadFont, EDF_PurgeFont                  */
/*                                                                    */
/*   PARAMETERS  :                                                    */
/*                                                                    */
/*   USHORT          usCommand     Command to purge or set            */
/*   USHORT          DFID          Download font ID                   */
/*   lpDCI           DCIData;      Pointer to DC Instance data        */
/*                                                                    */
/*                                                                    */
/*   DESCRIPTION :                                                    */
/*                                                                    */
/*   This function changes the status of the engine font in the       */
/*   printer.                                                         */
/*                                                                    */
/**********************************************************************/
#if 0
BOOL EDF_DLFCommand( usCommand, dfid, DCIData )
USHORT  usCommand;                    /* Command 9 = set, 6 = purge  */
USHORT  dfid;
lpDCI   DCIData;
#endif

BOOL EDF_DLFCommand( USHORT  usCommand,                    /* CON3201 */
                     USHORT  dfid,                         /* CON3201 */
                     lpDCI   DCIData )                     /* CON3201 */

{
#define TFUNC "EDF_DLFCommand"
    /******************************************************************/
    /* Local Variables                                                */
    /******************************************************************/
    DLFType   DLFData;
    USHORT    usRet;

    DLFData.PrinterId  = 0x31;
    DLFData.SubCommand = (BYTE)usCommand;
    DLFData.FontId     = (BYTE)dfid;


    /******************************************************************/
    /* Output DLF command using PrintSimple.                          */
    /******************************************************************/
    usRet = prdp_PrintSimple( DCIData,
                              USE_GLOBAL_TABLE,
                              EST_DLF,
                              (PBYTE)&DLFData );
    return( (BOOL)(usRet == OK) );

}
#undef TFUNC


/**********************************************************************/
/*                                                                    */
/*   Function    :   EDF_PurgeFont                                    */
/*                                                                    */
/*   When called :   EDF_DownloadFont  EDF_EndPage                    */
/*                                                                    */
/*   PARAMETERS  :                                                    */
/*                                                                    */
/*   lpDCI           DCIData       Pointer to DC Instance data        */
/*   PEDFH           pedfh         Pointer to Download engine font    */
/*                                            header                  */
/*                                                                    */
/*   DESCRIPTION :                                                    */
/*                                                                    */
/*   This function sends a purge command to the printer to purge      */
/*   downloaded engine font. Also changes the status of the font      */
/*   in the font header in the linked list hung off the DCI data      */
/*                                                                    */
/**********************************************************************/

BOOL EDF_PurgeFont(lpDCI DCIData,    /* DC instance data              */
                    PEDFH pedfh       /* Device font header           */
                   )
{
#define TFUNC "EDF_PurgeFont"
    /******************************************************************/
    /* Local Variables                                                */
    /******************************************************************/
    USHORT i;

    if (pedfh->fsFontStatus & EDF_FONT_DOWNLOADED)
    {
        pedfh->fsFontStatus &= ~EDF_FONT_DOWNLOADED;

        for  (i = 0; i < 256/16; i++)
        {
            pedfh->usGlyphDownLoaded[i] = 0;
        }

        return ( EDF_DLFCommand(6, pedfh->usDFID, DCIData) );
    }
    return TRUE;
}
#undef TFUNC


/**********************************************************************/
/*                                                                    */
/*   Function    :  EDF_DeleteFontHdr                                 */
/*                                                                    */
/*   When called :  EDF_Terminate  EDF_EndPage                        */
/*                                                                    */
/*   PARAMETERS  :                                                    */
/*                                                                    */
/*   lpDCI           DCIData       Pointer to DC Instance data        */
/*   PEDFH           pedfh         Pointer to the downloaded engine   */
/*                                                           font     */
/*   DESCRIPTION :                                                    */
/*                                                                    */
/*   Delete all the resources belonging to the font.                  */
/*                                                                    */
/**********************************************************************/

VOID EDF_DeleteFontHdr(lpDCI DCIData,  /* Pointer to DC instance data */
                        PEDFH pedfh     /* Pointer to the EDF font    */
                       )
{
#define TFUNC "EDF_DeleteFontHdr"

    /*--------------------------------------------------------*/
    /* Free the segment containing the font data if necessary */
    /*--------------------------------------------------------*/
    if (pedfh->pSaved)
    /* SSFREESEG(SELECTOROF(pedfh->pSaved)); */
       SSFREEMEM(pedfh->pSaved);                   /* CON3201 */

    /*---------------------*/
    /* Free the heap memory*/
    /*---------------------*/
    prdg_FreeHeapItem( DCIData,  sizeof(ENGINEDEVICEFONTHDR),
                       (PUSHORT)pedfh);
}
#undef TFUNC


/**********************************************************************/
/*                                                                    */
/*   Function    :  EDF_Terminate                                     */
/*                                                                    */
/*   When called :  prde_DisableDc                                    */
/*                                                                    */
/*   PARAMETERS  :                                                    */
/*                                                                    */
/*   lpDCI           DCIData       Pointer to DC Instance data        */
/*   PEDFH           pedfh         Pointer to the downloaded engine   */
/*                                                           font     */
/*   DESCRIPTION :                                                    */
/*                                                                    */
/*   Free all the resources used for downloading engine fonts for     */
/*   this DCI.                                                        */
/**********************************************************************/

 VOID EDF_Terminate(lpDCI DCIData /*Pointer to DC instance data       */
                   )
{
#define TFUNC "EDF_Termainate"
   /******************************************************************/
   /* Local Variables                                                */
   /******************************************************************/
    PEDFH pedfh, pedfhCurrent;

    /* Step through all the device fonts freeing them                */
    for (pedfh = DCIData->DCIEDFList; pedfh != NULL;)
    {
      pedfhCurrent = pedfh->pedfhNext; /* Save the pointer to the next */

      /* Get rid of the font */
      EDF_DeleteFontHdr(DCIData, pedfh);

      pedfh = pedfhCurrent; /* Restore the pointer */
    }

    /*--------------------------------------------*/
    /* Leave DC Instance in a clean state         */
    /*--------------------------------------------*/
    DCIData->DCIEDFList = NULL;
}
#undef TFUNC


/**********************************************************************/
/*                                                                    */
/*   Function    :  EDF_EndPage                                       */
/*                                                                    */
/*   When called :  prdn_SendInitAndPage                              */
/*                                                                    */
/*   PARAMETERS  :                                                    */
/*                                                                    */
/*   lpDCI           DCIData       Pointer to DC Instance data        */
/*                                                                    */
/*   DESCRIPTION :                                                    */
/*                                                                    */
/*   Free all the engine fonts marked DELETED. Change the status of   */
/*   all the engine fonts downloaded to NOT_USED_ON_PAGE and          */
/*   NOT_DOWNLOADED_ON_PAGE                                           */
/*                                                                    */
/**********************************************************************/

VOID EDF_EndPage(lpDCI DCIData)
{
#define TFUNC "EDF_EndPage"

 /* PEDFH FAR *ppedfh; */
    PEDFH     *ppedfh;                                     /* CON3201 */
    PEDFH      pedfh;
    USHORT     i;

    // Step through all the device fonts freeing them
 /* for (ppedfh = &DCIData->DCIEDFList; *ppedfh != NULL;) */
    for (ppedfh = (PEDFH *)&DCIData->DCIEDFList; *ppedfh != NULL;) /*CON3201*/
    {
      // Get rid of the font if it's deleted
      pedfh = *ppedfh;

      if (pedfh->fsFontStatus & EDF_FONT_DELETED)
      {
        *ppedfh = pedfh->pedfhNext;

        /*--------------------------------------*/
        /* Free the device font if there is one */
        /*--------------------------------------*/
        if (pedfh->fsFontStatus & EDF_FONT_DOWNLOADED)
          EDF_PurgeFont(DCIData, pedfh);

        /*--------------------------------------*/
        /* Free the control information         */
        /*--------------------------------------*/
        EDF_DeleteFontHdr(DCIData, pedfh);
      }
      else
      {
        /*---------------------*/
        /* Clear status flags  */
        /*---------------------*/
        pedfh->fsFontStatus &= ~EDF_USED_ON_PAGE & ~EDF_FONT_DOWNLOADED_ON_PAGE;
        for  (i = 0; i < 256/16; i++)
          pedfh->usGlyphUsed[i] = 0;
        ppedfh = &pedfh->pedfhNext;
      }
    }
}
#undef TFUNC


