/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1992 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 source code is provided to you solely for       */
/*    the purpose of assisting you in your development of OS/2 device        */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Developer Connection Device Driver       */
/*    Source Kit for OS/2. This Copyright statement may not be removed.      */
/*                                                                           */
/*****************************************************************************/
/**************************************************************************
 *
 * SOURCE FILE NAME = PRDENABL
 *
 * DESCRIPTIVE NAME =
 *
 *
 * VERSION
 *
 * DATE
 *
 * DESCRIPTION
 *
 * FUNCTIONS   OS2_PM_DRV_ENABLE
 *
 * ENTRY POINTS:
 *
 * DEPENDENCIES:
 *
 * NOTES
 *
 *
 * STRUCTURES
 *
 * EXTERNAL REFERENCES
 *
 * EXTERNAL FUNCTIONS
 *
*/

#define INCL_32                         /* Convert to C/SET2    CON3201       */
#define INCL_DOSPROCESS                 /* Convert to C/SET2    CON3201       */
#define INCL_DOSSEMAPHORES
#define INCL_GREALL
#define INCL_GPIPRIMITIVES
#define INCL_WINHEAP
#define INCL_GPIBITMAPS
#include <os2.h>
#undef INCL_DOSPROCESS                  /* Convert to C/SET2    CON3201       */
#undef INCL_DOSSEMAPHORES
#undef INCL_GREALL
#undef INCL_GPIPRIMITIVES
#undef INCL_WINHEAP
#undef INCL_GPIBITMAPS

#define INCL_DDIBUNDLES
#define INCL_DDIFONTSTRUCS
#define INCL_DDIDEFS
#include <pmddi.h>
#undef INCL_DDIBUNDLES
#undef INCL_DDIFONTSTRUCS
#undef INCL_DDIDEFS

#define INCL_WINP_SELECTIVE
#define INCL_WINP_SEI
#include <pmwinx.h>
#undef INCL_WINP_SELECTIVE
#undef INCL_WINP_SEI
#undef INCL_32                          /* Convert to C/SET2    CON3201       */

#include <prdconse.h>
#include <prddcone.h>
#include <prdecone.h>

#define NO_SYS
#define NO_CONSTANT_INCL
#include <prdinclt.h>
#undef NO_CONSTANT_INCL
#undef NO_SYS

#include <prdmtypt.h>

#include <prdeextf.h>
#include <prdnextf.h>



/**********************************************************************/
/*                                                                    */
/*   FUNCTION: OS2_PM_DRV_ENABLE                                      */
/*                                                                    */
/*   PARAMETERS:                                                      */
/*                                                                    */
/*   See "OS/2 Technical Reference: I/O Subsytems and Device Drivers" */
/*                                                                    */
/*   ULONG subfunc;                                                   */
/*   PBYTE param1;                                                    */
/*   PBYTE param2;                                                    */
/*                                                                    */
/*   DESCRIPTION:                                                     */
/*                                                                    */
/*   This function is one of the entry points into the printer driver.*/
/*   It simply switches control to the subfunction specified by       */
/*   subfunc.                                                         */
/*                                                                    */
/**********************************************************************/
#if 0
ULONG EXPENTRY OS2_PM_DRV_ENABLE ( subfunc,
                                   param1,
                                   param2 )

ULONG   subfunc;
PBYTE   param1;
PBYTE   param2;
#endif
ULONG EXPENTRY OS2_PM_DRV_ENABLE ( ULONG subfunc,          /* CON3201 */
                                   PBYTE param1,           /* CON3201 */
                                   PBYTE param2 )          /* CON3201 */

{
#define TFUNC "OS2_PM_DRV_ENABLE"
    /******************************************************************/
    /* Local Variables                                                */
    /******************************************************************/
    SHORT        Result;
/*  USHORT       Result; CON3201  Result of call to one of our        */
                               /* functions which needs to be adjusted*/
                               /* for return to the engine            */

    /******************************************************************/
    /* Switch according to which sub-function we should call.         */
    /******************************************************************/
#ifdef DEBUG_FSM
    OutputPrompt("Enble Function");
#endif

    prde_InitSemaphores(); /* CON3201 - Go ahead and do the semaphore
                               ** initialization here for now.  Perhaps we
                               ** can find a better place to do this latter
                               ** on
                               */
    switch ((USHORT)subfunc)
    {
        case 1:
         /* Result = prde_FillLdb( (FLParamsLst far *)  param1,  */
         /*                        (FLReturnsLst far *) param2); */
            Result = prde_FillLdb( (FLParamsLst *)  param1,  /*CON3201*/
                                   (FLReturnsLst *) param2); /*CON3201*/
            break;

        case 2:
            TRACE4(TFUNC, "FillPdb", FNULL, 0);
         /* return(prde_FillPdb((FPParamsLst far *)param1,(ULONG)param2)); */
            return(prde_FillPdb((FPParamsLst *)param1,(ULONG)param2)); /*CON3201*/

        case 3:
            /**********************************************************/
            /* Subfunction 3 is not supported - return an error.      */
            /**********************************************************/
            Result = ERROR_NEG;
            break;

        case 4:
            TRACE4(TFUNC, "DisablePdb", FNULL, 0);
            Result = prde_DisablePdb((lpPDBI)param1, param2);
            break;

        case 5:
            TRACE4(TFUNC, "EnableDC", FNULL, 0);
         /* return( prde_EnableDC( (EDCParamsLst far *)param1, */
            return( prde_EnableDC( (EDCParamsLst *)param1, /* CON3201 */
                                   (ULONG)param2) );
            break;

        case 6:
            TRACE4(TFUNC, "DisableDC", FNULL, 0);
            Result = prde_DisableDC( (lpDCI)param1 );
            break;

        case 7:
            TRACE4(TFUNC, "SaveDC", FNULL, 0);
            Result = prde_SaveDC((lpDCI) param1, param2);
            break;

        case 8:
            TRACE4(TFUNC, "RestoreDC", FNULL, 0);
            Result = prde_RestoreDC((lpDCI) param1, (LONG) param2);
            break;

        case 9:
            TRACE4(TFUNC, "ResetDC", FNULL, 0);
            Result = prde_ResetDC((lpDCI) param1, (ULONG)param2);
            break;

        case 10:
            TRACE4(TFUNC, "CompleteOpen", FNULL, 0);
            Result = prde_CompleteOpen((hanDC) param1, (lpDCI)param2);
            break;

        case 11:
            TRACE4(TFUNC, "BeginClose", FNULL, 0);
            Result = prde_BeginClose((hanDC)param1, (lpDCI)param2);
            break;

        default:
            TRACE4(TFUNC, "subfunction number", &subfunc, 1);
            Result = ERROR_NEG;
            break;

    }
    /*.. switch (subfunc) ............................................*/

    /******************************************************************/
    /* The Engine requires return 0 (OK) for Enable processing, but 1 */
    /* (OK) for everything else. So translate OK to ENG_OK and not OK */
    /* to minus one.                                                  */
    /******************************************************************/
    TRACE4(TFUNC, "Exit Result", &Result, 1);

    if (Result == OK)
    {
        return(ENG_OK);
#ifdef DEBUG_FSM
        OutputString("Enable Function returns OK");
#endif
    }

#ifdef DEBUG_FSM
    OutputPrompt("Enable Function returns ERROR_NEG");
#endif

    return(ERROR_NEG);
}
#undef TFUNC

