/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1992 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 source code is provided to you solely for       */
/*    the purpose of assisting you in your development of OS/2 device        */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Developer Connection Device Driver       */
/*    Source Kit for OS/2. This Copyright statement may not be removed.      */
/*                                                                           */
/*****************************************************************************/
/**************************************************************************
 *
 * SOURCE FILE NAME = PRDDTAB
 *
 * DESCRIPTIVE NAME =
 *
 *
 * VERSION
 *
 * DATE
 *
 * DESCRIPTION  Printer Device Driver DVT/DDT/GDT Tables
 *
 * FUNCTIONS
 *
 * ENTRY POINTS:
 *
 * DEPENDENCIES:
 *
 * NOTES
 *
 *
 * STRUCTURES
 *
 * EXTERNAL REFERENCES
 *
 * EXTERNAL FUNCTIONS
 *
*/

/******************************************************************************/
/*  Color Tables                                                              */
/*                                                                            */
/*  Index zero represents black, index one represents white.                  */
/******************************************************************************/
ULONG  DVTTwoColors [] =
    {
        { 0x00000000 },
        { 0x00FFFFFF }
    };

DVTColorTableType  DVTTwoColorTable =
    {
        DVTTwoColors,
        2
    };

/******************************************************************************/
/*  This table gives the RGB values of the colour codes that are actually     */
/*  stored in the bitmap                                                      */
/*                                                                            */
/*  IMPORTANT : if any of theses values are changed, the corresponding        */
/*  constants in PRDBCONE.H should also be changed.                           */
/*                                                                            */
/*  Also the CacheTable in prdbexin.c should match this table.                */
/*                                                                            */
/*  MJB 18/10/90: This was changed to make it consistent with VGA color table */
/*  (so that rops work the same as on the screen).  IMPORTANT: if it is       */
/*  changed, change PRD_8_PRINTER_WHITE in prdccone.h.                        */
/******************************************************************************/
ULONG  DVTEightColors [] =
    {
        { 0x00000000 },                /* Black                               */
        { 0x000000FF },                /* Blue                                */
        { 0x00FF0000 },                /* Red                                 */
        { 0x00FF00FF },                /* Magenta                             */
        { 0x0000FF00 },                /* Green                               */
        { 0x0000FFFF },                /* Cyan                                */
        { 0x00FFFF00 },                /* Yellow                              */
        { 0x00FFFFFF }                 /* White                               */
    };

DVTColorTableType  DVTEightColorTable =
    {
        DVTEightColors,
        8
    };

/******************************************************************************/
/*  DVTHardwarePalette : this table is a direct equivalent of DVTEightColors  */
/*  above, but with the RGB values in Presentation Manager RGB format instead */
/*  of in internal DWORD format.                                              */
/******************************************************************************/
/* CON3201 - Must now support RGB2 as a register 2.0 device driver this means */
/* so below array was changed to RGB2 and 0 was added to the end of each      */
/* structure                                                                  */
/******************************************************************************/

RGB2 DVTHardwarePalette[8] = {
         {DVT8Col0Blue, DVT8Col0Green, DVT8Col0Red ,0},
         {DVT8Col1Blue, DVT8Col1Green, DVT8Col1Red ,0},
         {DVT8Col2Blue, DVT8Col2Green, DVT8Col2Red ,0},
         {DVT8Col3Blue, DVT8Col3Green, DVT8Col3Red ,0},
         {DVT8Col4Blue, DVT8Col4Green, DVT8Col4Red ,0},
         {DVT8Col5Blue, DVT8Col5Green, DVT8Col5Red ,0},
         {DVT8Col6Blue, DVT8Col6Green, DVT8Col6Red ,0},
         {DVT8Col7Blue, DVT8Col7Green, DVT8Col7Red ,0}};

/******************************************************************************/
/*  Format tables.                                                            */
/******************************************************************************/
DVTFormatType  DVT11Format =
    {
        1,                             /* BitCount                            */
        1                              /* Planes                              */
    };

DVTFormatType  DVT14Format =
    {
        4,                             /* BitCount                            */
        1                              /* Planes                              */
    };

/******************************************************************************/
/*  Data Types - used in the Device Description Table                         */
/******************************************************************************/
DVTNameType  DVTDataTypes [] =
    {
        "PM_Q_STD",
        "PM_Q_RAW"
    };

/******************************************************************************/
/*  DVT values used in the GDT                                                */
/******************************************************************************/
DVTRetFlagsType  DVTRetFlags =
    {
        TRUE,                          /* PageCorrection                      */
        FALSE                          /* ImplicitReturn                      */
    };

/******************************************************************************/
/*  Global Description Table (GDT)                                            */
/******************************************************************************/
GDTType  GDT =
    {
        &DVTTwoColorTable,             /* GDT11ColorTable;                    */
        &DVTEightColorTable,           /* GDT41ColorTable;                    */
        &DVTEightColorTable,           /* GDT81ColorTable;                    */
        &DVTRetFlags                   /* GDTRetFlags;                        */
    };
