/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1992 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 source code is provided to you solely for       */
/*    the purpose of assisting you in your development of OS/2 device        */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Developer Connection Device Driver       */
/*    Source Kit for OS/2. This Copyright statement may not be removed.      */
/*                                                                           */
/*****************************************************************************/
/**************************************************************************
 *
 * SOURCE FILE NAME = PRDDMODE
 *
 * DESCRIPTIVE NAME =
 *
 *
 * VERSION
 *
 * DATE
 *
 * DESCRIPTION  Printer Device Driver Device Mode Settings
 *
 * FUNCTIONS
 *
 * ENTRY POINTS:
 *
 * DEPENDENCIES:
 *
 * NOTES
 *
 *
 * STRUCTURES
 *
 * EXTERNAL REFERENCES
 *
 * EXTERNAL FUNCTIONS
 *
*/

#ifdef IBM42XX_DRV

/**********************************************************************/
/* DeviceMode default settings.  Note that  the Printer Type is       */
/* overwritten when the default settings are loaded.                  */
/**********************************************************************/
DMSettingsType DVTDfltDMSettingsProI =
    {
        DDT_DUMMY_VALUE,                 /*     PrinterType           */
        0,                               /*     INIEntrySize          */
        PORTRAIT,                        /*     Orientation           */
        RESOLUTION_1,                    /*     Resolution            */
        FF_CONDITIONAL_MODE,             /*     FFSet                 */
        0,                               /*     DefaultSpoolIndex     */
        DEV_FONTS_AVAIL,                 /*     PelAddrFontType       */
        0,                               /*     SourceIndex           */
        FD_NONE,                         /*     AddedFeed             */
        0,                               /*     SelectedForm          */
        13,                              /*     NumberOfForms         */
        0,                               /*     NumberAvailCards      */
        0,                               /*     NumberOwnedCards      */
        0,                               /*     ShippedCardCount      */
        0,                               /*     NumberOfDownFonts     */
        DOWN_CP_MEM_AVAIL,               /*     DownCPMemAvail        */
        0,                               /*     NoOfAddedCPs          */
        NO_INDEX_SELECTED,               /*     InitCodePage          */
        DONT_RELOAD_EACH_JOB,            /*     InitCPReloadType      */
        0,                               /*     Memory option         */
        0,                               /*     ResFont set           */
        0,                               /*     Simplex/duplex        */
        0,                               /*     Duplex Enabled        */
        0,                               /*     Default Source        */
        COMPRESS_NONE,                   /*     BandCompression       */
        NO_DL_SYS_FONTS,                 /*     Down load eng fonts   */
        0,                               /*     Disable outline fonts */
        0,                               /*     Machine type DIAL/NILE*/
        0,                               /*     Defaultfnt PSz PD00137*/
        0,                               /*     Padding               */
        0,                               /*     SourceDataSize        */
        0,                               /*     MetricsPathLength     */
        0,                               /*     CardDataSize          */
        0,                               /*     DownFontDataSize      */
        0,                               /*     CodePageDataSize      */
        0,                               /*     DfltFontInfoSize      */
        0                                /*     PrinterPatterns       PD00769 */
    };

DMSettingsType DVTDfltDMSettingsProIII =
    {
        DDT_DUMMY_VALUE,                 /*     PrinterType           */
        0,                               /*     INIEntrySize          */
        PORTRAIT,                        /*     Orientation           */
        RESOLUTION_1,                    /*     Resolution            */
        FF_CONDITIONAL_MODE,             /*     FFSet                 */
        0,                               /*     DefaultSpoolIndex     */
        DEV_FONTS_AVAIL,                 /*     PelAddrFontType       */
        0,                               /*     SourceIndex           */
        FD_NONE,                         /*     AddedFeed             */
        0,                               /*     SelectedForm          */
        13,                              /*     NumberOfForms         */
        0,                               /*     NumberAvailCards      */
        0,                               /*     NumberOwnedCards      */
        0,                               /*     ShippedCardCount      */
        0,                               /*     NumberOfDownFonts     */
        DOWN_CP_MEM_AVAIL,               /*     DownCPMemAvail        */
        0,                               /*     NoOfAddedCPs          */
        NO_INDEX_SELECTED,               /*     InitCodePage          */
        DONT_RELOAD_EACH_JOB,            /*     InitCPReloadType      */
        0,                               /*     Memory option         */
        0,                               /*     ResFont set           */
        0,                               /*     Simplex/duplex        */
        0,                               /*     Duplex Enabled        */
        0,                               /*     Default source        */
        COMPRESS_NONE,                   /*     BandCompression       */
        NO_DL_SYS_FONTS,                 /*     Down load eng fonts   */
        0,                               /*     Disable outline fonts */
        0,                               /*     Machine type DIAL/NILE*/
        0,                               /*     Defaultfnt PSz PD00137*/
        0,                               /*     Padding               */
        0,                               /*     SourceDataSize        */
        0,                               /*     MetricsPathLength     */
        0,                               /*     CardDataSize          */
        0,                               /*     DownFontDataSize      */
        0,                               /*     CodePageDataSize      */
        0,                               /*     DfltFontInfoSize      */
        0                                /*     PrinterPatterns       PD00769 */
    };

DMSettingsType DVTDfltDMSettingsProX24 =
    {
        DDT_DUMMY_VALUE,                 /*     PrinterType           */
        0,                               /*     INIEntrySize          */
        PORTRAIT,                        /*     Orientation           */
        RESOLUTION_1,                    /*     Resolution            */
        FF_CONDITIONAL_MODE,             /*     FFSet                 */
        0,                               /*     DefaultSpoolIndex     */
        DEV_FONTS_AVAIL,                 /*     PelAddrFontType       */
        0,                               /*     SourceIndex           */
        FD_NONE,                         /*     AddedFeed             */
        0,                               /*     SelectedForm          */
        13,                              /*     NumberOfForms         */
        0,                               /*     NumberAvailCards      */
        0,                               /*     NumberOwnedCards      */
        0,                               /*     ShippedCardCount      */
        0,                               /*     NumberOfDownFonts     */
        DOWN_CP_MEM_AVAIL,               /*     DownCPMemAvail        */
        0,                               /*     NoOfAddedCPs          */
        NO_INDEX_SELECTED,               /*     InitCodePage          */
        DONT_RELOAD_EACH_JOB,            /*     InitCPReloadType      */
        0,                               /*     Memory option         */
        0,                               /*     ResFont set           */
        0,                               /*     Simplex/duplex        */
        0,                               /*     Duplex Enabled        */
        0,                               /*     Default source        */
        COMPRESS_NONE,                   /*     BandCompression       */
        NO_DL_SYS_FONTS,                 /*     Down load eng fonts   */
        0,                               /*     Disable outline fonts */
        0,                               /*     Machine type DIAL/NILE*/
        0,                               /*     Defaultfnt PSz PD00137*/
        0,                               /*     Padding               */
        0,                               /*     SourceDataSize        */
        0,                               /*     MetricsPathLength     */
        0,                               /*     CardDataSize          */
        0,                               /*     DownFontDataSize      */
        0,                               /*     CodePageDataSize      */
        0,                               /*     DfltFontInfoSize      */
        0                                /*     PrinterPatterns       PD00769 */
    };

DMSettingsType DVTDfltDMSettingsProX24E =
    {
        DDT_DUMMY_VALUE,                 /*     PrinterType           */
        0,                               /*     INIEntrySize          */
        PORTRAIT,                        /*     Orientation           */
        RESOLUTION_1,                    /*     Resolution            */
        FF_CONDITIONAL_MODE,             /*     FFSet                 */
        0,                               /*     DefaultSpoolIndex     */
        DEV_FONTS_AVAIL,                 /*     PelAddrFontType       */
        0,                               /*     SourceIndex           */
        FD_NONE,                         /*     AddedFeed             */
        0,                               /*     SelectedForm          */
        13,                              /*     NumberOfForms         */
        0,                               /*     NumberAvailCards      */
        0,                               /*     NumberOwnedCards      */
        0,                               /*     ShippedCardCount      */
        0,                               /*     NumberOfDownFonts     */
        DOWN_CP_MEM_AVAIL,               /*     DownCPMemAvail        */
        0,                               /*     NoOfAddedCPs          */
        NO_INDEX_SELECTED,               /*     InitCodePage          */
        DONT_RELOAD_EACH_JOB,            /*     InitCPReloadType      */
        0,                               /*     Memory option         */
        0,                               /*     ResFont set           */
        0,                               /*     Simplex/duplex        */
        0,                               /*     Duplex Enabled        */
        0,                               /*     Default source        */
        COMPRESS_NONE,                   /*     BandCompression       */
        NO_DL_SYS_FONTS,                 /*     Down load eng fonts   */
        0,                               /*     Disable outline fonts */
        0,                               /*     Machine type DIAL/NILE*/
        0,                               /*     Defaultfnt PSz PD00137*/
        0,                               /*     Padding               */
        0,                               /*     SourceDataSize        */
        0,                               /*     MetricsPathLength     */
        0,                               /*     CardDataSize          */
        0,                               /*     DownFontDataSize      */
        0,                               /*     CodePageDataSize      */
        0,                               /*     DfltFontInfoSize      */
        0                                /*     PrinterPatterns       PD00769 */
    };

DMSettingsType DVTDfltDMSettings4224 =
    {
        DDT_DUMMY_VALUE,                 /*     PrinterType           */
        0,                               /*     INIEntrySize          */
        PORTRAIT,                        /*     Orientation           */
        RESOLUTION_1,                    /*     Resolution            */
        FF_CONDITIONAL_MODE,             /*     FFSet                 */
        0,                               /*     DefaultSpoolIndex     */
        DEV_FONTS_AVAIL,                 /*     PelAddrFontType       */
        0,                               /*     SourceIndex           */
        FD_NONE,                         /*     AddedFeed             */
        0,                               /*     SelectedForm          */
        7,                               /*     NumberOfForms PD00307 */
        0,                               /*     NumberAvailCards      */
        0,                               /*     NumberOwnedCards      */
        0,                               /*     ShippedCardCount      */
        0,                               /*     NumberOfDownFonts     */
        DOWN_CP_MEM_NOT_AVAIL,           /*     DownCPMemAvail        */
        0,                               /*     NoOfAddedCPs          */
        NO_INDEX_SELECTED,               /*     InitCodePage          */
        DDT_DUMMY_VALUE,                 /*     InitCPReloadType      */
        0,                               /*     Memory option         */
        0,                               /*     ResFont set           */
        0,                               /*     Simplex/duplex        */
        0,                               /*     Duplex Enabled        */
        0,                               /*     Default source        */
        COMPRESS_NONE,                   /*     BandCompression       */
        NO_DL_SYS_FONTS,                 /*     Down load eng fonts   */
        0,                               /*     Disable outline fonts */
        0,                               /*     Machine type DIAL/NILE*/
        0,                               /*     Defaultfnt PSz PD00137*/
        0,                               /*     Padding               */
        0,                               /*     SourceDataSize        */
        0,                               /*     MetricsPathLength     */
        0,                               /*     CardDataSize          */
        0,                               /*     DownFontDataSize      */
        0,                               /*     CodePageDataSize      */
        0,                               /*     DfltFontInfoSize      */
        0                                /*     PrinterPatterns       PD00769 */
    };

/**********************************************************************/
/* DIAL/NILE : Add two new entries for Nile/Tiber - one 9 wire, one   */
/*             24 wire.                                               */
/* PD00330 : Need to separate narrow and wide carriage as we have     */
/*           different numbers of forms now.  Also have to add        */
/*           separate settings for 4226 as it has fewer forms         */
/**********************************************************************/
DMSettingsType DVTDfltDMSettings2380 =
    {
        DDT_DUMMY_VALUE,                 /*     PrinterType           */
        0,                               /*     INIEntrySize          */
        PORTRAIT,                        /*     Orientation           */
        RESOLUTION_1,                    /*     Resolution            */
        DDT_DUMMY_VALUE,                 /*     FFSet                 */
        0,                               /*     DefaultSpoolIndex     */
        DEV_FONTS_LIMITED,               /*     PelAddrFontType PD00604 */
        0,                               /*     SourceIndex           */
        FD_NONE,                         /*     AddedFeed             */
        0,                               /*     SelectedForm          */
        13,                              /*     NumberOfForms         */
        0,                               /*     NumberAvailCards      */
        0,                               /*     NumberOwnedCards      */
        0,                               /*     ShippedCardCount      */
        0,                               /*     NumberOfDownFonts     */
        DOWN_CP_MEM_NOT_AVAIL,           /*     DownCPMemAvail        */
        0,                               /*     NoOfAddedCPs          */
        NO_INDEX_SELECTED,               /*     InitCodePage          */
        DONT_RELOAD_EACH_JOB,            /*     InitCPReloadType      */
        0,                               /*     Memory option         */
        0,                               /*     ResFont set           */
        0,                               /*     Simplex/duplex        */
        0,                               /*     Duplex Enabled        */
        0,                               /*     Default source        */
        COMPRESS_NONE,                   /*     BandCompression       */
        NO_DL_SYS_FONTS,                 /*     Down load eng fonts   */
        0,                               /*     Disable outline       */
        US_MACHINE,                      /*     Machine type PD00558  */
        0,                               /*     Defaultfnt PSz PD00137*/
        0,                               /*     Padding               */
        0,                               /*     SourceDataSize        */
        0,                               /*     MetricsPathLength     */
        0,                               /*     CardDataSize          */
        0,                               /*     DownFontDataSize      */
        0,                               /*     CodePageDataSize      */
        0,                               /*     DfltFontInfoSize      */
        0                                /*     PrinterPatterns       PD00769 */
    };

DMSettingsType DVTDfltDMSettings2381 =
    {
        DDT_DUMMY_VALUE,                 /*     PrinterType           */
        0,                               /*     INIEntrySize          */
        PORTRAIT,                        /*     Orientation           */
        RESOLUTION_1,                    /*     Resolution            */
        DDT_DUMMY_VALUE,                 /*     FFSet                 */
        0,                               /*     DefaultSpoolIndex     */
        DEV_FONTS_LIMITED,               /*     PelAddrFontType PD00604 */
        0,                               /*     SourceIndex           */
        FD_NONE,                         /*     AddedFeed             */
        0,                               /*     SelectedForm          */
        16,                              /*     NumberOfForms         */
        0,                               /*     NumberAvailCards      */
        0,                               /*     NumberOwnedCards      */
        0,                               /*     ShippedCardCount      */
        0,                               /*     NumberOfDownFonts     */
        DOWN_CP_MEM_NOT_AVAIL,           /*     DownCPMemAvail        */
        0,                               /*     NoOfAddedCPs          */
        NO_INDEX_SELECTED,               /*     InitCodePage          */
        DONT_RELOAD_EACH_JOB,            /*     InitCPReloadType      */
        0,                               /*     Memory option         */
        0,                               /*     ResFont set           */
        0,                               /*     Simplex/duplex        */
        0,                               /*     Duplex Enabled        */
        0,                               /*     Default source        */
        COMPRESS_NONE,                   /*     BandCompression       */
        NO_DL_SYS_FONTS,                 /*     Down load eng fonts   */
        0,                               /*     Disable outline       */
        US_MACHINE,                      /*     Machine type PD00558  */
        0,                               /*     Defaultfnt PSz PD00137*/
        0,                               /*     Padding               */
        0,                               /*     SourceDataSize        */
        0,                               /*     MetricsPathLength     */
        0,                               /*     CardDataSize          */
        0,                               /*     DownFontDataSize      */
        0,                               /*     CodePageDataSize      */
        0,                               /*     DfltFontInfoSize      */
        0                                /*     PrinterPatterns       PD00769 */
    };

DMSettingsType DVTDfltDMSettings2390 =
    {
        DDT_DUMMY_VALUE,                 /*     PrinterType           */
        0,                               /*     INIEntrySize          */
        PORTRAIT,                        /*     Orientation           */
        RESOLUTION_1,                    /*     Resolution  PD00294   */
        DDT_DUMMY_VALUE,                 /*     FFSet                 */
        0,                               /*     DefaultSpoolIndex     */
        DEV_FONTS_LIMITED,               /*     PelAddrFontType PD00604 */
        0,                               /*     SourceIndex           */
        FD_NONE,                         /*     AddedFeed             */
        0,                               /*     SelectedForm          */
        13,                              /*     NumberOfForms         */
        0,                               /*     NumberAvailCards      */
        0,                               /*     NumberOwnedCards      */
        0,                               /*     ShippedCardCount      */
        0,                               /*     NumberOfDownFonts     */
        DOWN_CP_MEM_NOT_AVAIL,           /*     DownCPMemAvail        */
        0,                               /*     NoOfAddedCPs          */
        NO_INDEX_SELECTED,               /*     InitCodePage          */
        DONT_RELOAD_EACH_JOB,            /*     InitCPReloadType      */
        0,                               /*     Memory option         */
        0,                               /*     ResFont set           */
        0,                               /*     Simplex/duplex        */
        0,                               /*     Duplex Enabled        */
        0,                               /*     Default source        */
        COMPRESS_NONE,                   /*     BandCompression       */
        NO_DL_SYS_FONTS,                 /*     Down load eng fonts   */
        0,                               /*     Disable outline fonts */
        US_MACHINE,                      /*     Machine type PD00558  */
        0,                               /*     Defaultfnt PSz PD00137*/
        0,                               /*     Padding               */
        0,                               /*     SourceDataSize        */
        0,                               /*     MetricsPathLength     */
        0,                               /*     CardDataSize          */
        0,                               /*     DownFontDataSize      */
        0,                               /*     CodePageDataSize      */
        0,                               /*     DfltFontInfoSize      */
        0                                /*     PrinterPatterns       PD00769 */
    };

/******************************************************************************/
/*  INKJET : 2390_PS1 has different defaults than the 2390.                   */
/******************************************************************************/
DMSettingsType DVTDfltDMSettings2390_PS1 =
    {
        DDT_DUMMY_VALUE,                 /*     PrinterType           */
        0,                               /*     INIEntrySize          */
        PORTRAIT,                        /*     Orientation           */
        RESOLUTION_1,                    /*     Resolution  PD00294   */
        DDT_DUMMY_VALUE,                 /*     FFSet                 */
        0,                               /*     DefaultSpoolIndex     */
        DEV_FONTS_LIMITED,               /*     PelAddrFontType PD00604 */
        0,                               /*     SourceIndex           */
        FD_NONE,                         /*     AddedFeed             */
        0,                               /*     SelectedForm          */
        13,                              /*     NumberOfForms         */
        0,                               /*     NumberAvailCards      */
        0,                               /*     NumberOwnedCards      */
        0,                               /*     ShippedCardCount      */
        0,                               /*     NumberOfDownFonts     */
        DOWN_CP_MEM_NOT_AVAIL,           /*     DownCPMemAvail        */
        0,                               /*     NoOfAddedCPs          */
        NO_INDEX_SELECTED,               /*     InitCodePage          */
        DONT_RELOAD_EACH_JOB,            /*     InitCPReloadType      */
        0,                               /*     Memory option         */
        0,                               /*     ResFont set           */
        0,                               /*     Simplex/duplex        */
        0,                               /*     Duplex Enabled        */
        0,                               /*     Default source        */
        COMPRESS_NONE,                   /*     BandCompression       */
        NO_DL_SYS_FONTS,                 /*     Down load eng fonts   */
        0,                               /*     Disable outline fonts */
        US_MACHINE,                      /*     Machine type PD00558  */
        0,                               /*     Defaultfnt PSz PD00137*/
        0,                               /*     Padding               */
        0,                               /*     SourceDataSize        */
        0,                               /*     MetricsPathLength     */
        0,                               /*     CardDataSize          */
        0,                               /*     DownFontDataSize      */
        0,                               /*     CodePageDataSize      */
        0,                               /*     DfltFontInfoSize      */
        0                                /*     PrinterPatterns       PD00769 */
    };

DMSettingsType DVTDfltDMSettings2391 =
    {
        DDT_DUMMY_VALUE,                 /*     PrinterType           */
        0,                               /*     INIEntrySize          */
        PORTRAIT,                        /*     Orientation           */
        RESOLUTION_1,                    /*     Resolution  PD00294   */
        DDT_DUMMY_VALUE,                 /*     FFSet                 */
        0,                               /*     DefaultSpoolIndex     */
        DEV_FONTS_LIMITED,               /*     PelAddrFontType PD00604 */
        0,                               /*     SourceIndex           */
        FD_NONE,                         /*     AddedFeed             */
        0,                               /*     SelectedForm          */
        16,                              /*     NumberOfForms         */
        0,                               /*     NumberAvailCards      */
        0,                               /*     NumberOwnedCards      */
        0,                               /*     ShippedCardCount      */
        0,                               /*     NumberOfDownFonts     */
        DOWN_CP_MEM_NOT_AVAIL,           /*     DownCPMemAvail        */
        0,                               /*     NoOfAddedCPs          */
        NO_INDEX_SELECTED,               /*     InitCodePage          */
        DONT_RELOAD_EACH_JOB,            /*     InitCPReloadType      */
        0,                               /*     Memory option         */
        0,                               /*     ResFont set           */
        0,                               /*     Simplex/duplex        */
        0,                               /*     Duplex Enabled        */
        0,                               /*     Default source        */
        COMPRESS_NONE,                   /*     BandCompression       */
        NO_DL_SYS_FONTS,                 /*     Down load eng fonts   */
        0,                               /*     Disable outline fonts */
        US_MACHINE,                      /*     Machine type PD00558  */
        0,                               /*     Defaultfnt PSz PD00137*/
        0,                               /*     Padding               */
        0,                               /*     SourceDataSize        */
        0,                               /*     MetricsPathLength     */
        0,                               /*     CardDataSize          */
        0,                               /*     DownFontDataSize      */
        0,                               /*     CodePageDataSize      */
        0,                               /*     DfltFontInfoSize      */
        0                                /*     PrinterPatterns       PD00769 */
    };

DMSettingsType DVTDfltDMSettings4226 =
    {
        DDT_DUMMY_VALUE,                 /*     PrinterType           */
        0,                               /*     INIEntrySize          */
        PORTRAIT,                        /*     Orientation           */
        RESOLUTION_1,                    /*     Resolution            */
        DDT_DUMMY_VALUE,                 /*     FFSet                 */
        0,                               /*     DefaultSpoolIndex     */
        DEV_FONTS_LIMITED,               /*     PelAddrFontType PD00604 */
        0,                               /*     SourceIndex           */
        FD_NONE,                         /*     AddedFeed             */
        0,                               /*     SelectedForm          */
        10,                              /*     NumberOfForms         */
        0,                               /*     NumberAvailCards      */
        0,                               /*     NumberOwnedCards      */
        0,                               /*     ShippedCardCount      */
        0,                               /*     NumberOfDownFonts     */
        DOWN_CP_MEM_NOT_AVAIL,           /*     DownCPMemAvail        */
        0,                               /*     NoOfAddedCPs          */
        NO_INDEX_SELECTED,               /*     InitCodePage          */
        DONT_RELOAD_EACH_JOB,            /*     InitCPReloadType      */
        0,                               /*     Memory option         */
        0,                               /*     ResFont set           */
        0,                               /*     Simplex/duplex        */
        0,                               /*     Duplex Enabled        */
        0,                               /*     Default source        */
        COMPRESS_NONE,                   /*     BandCompression       */
        NO_DL_SYS_FONTS,                 /*     Down load eng fonts   */
        0,                               /*     Disable outline       */
        0,                               /*     Machine type DIAL/NILE*/
        0,                               /*     Defaultfnt PSz PD00137*/
        0,                               /*     Padding               */
        0,                               /*     SourceDataSize        */
        0,                               /*     MetricsPathLength     */
        0,                               /*     CardDataSize          */
        0,                               /*     DownFontDataSize      */
        0,                               /*     CodePageDataSize      */
        0,                               /*     DfltFontInfoSize      */
        0                                /*     PrinterPatterns       PD00769 */
    };

/**********************************************************************/
/* DVT Default Device Modes Settings array.                           */
/**********************************************************************/
lpDMSettings  DVTDfltDMSettings [] =
    {
        &DVTDfltDMSettingsProI,       /*  IBM_PRO_PRINTER_I           */
        &DVTDfltDMSettingsProIII,     /*  IBM_PRO_PRINTER_II          */
        &DVTDfltDMSettingsProIII,     /*  IBM_PRO_PRINTER_III         */
        &DVTDfltDMSettingsProIII,     /*  IBM_PRO_PRINTER_XL          */
        &DVTDfltDMSettingsProIII,     /*  IBM_PRO_PRINTER_II_XL       */
        &DVTDfltDMSettingsProIII,     /*  IBM_PRO_PRINTER_III_XL      */
        &DVTDfltDMSettingsProX24,     /*  IBM_PRO_PRINTER_X24         */
        &DVTDfltDMSettingsProX24E,    /*  IBM_PRO_PRINTER_X24E        */
        &DVTDfltDMSettingsProX24,     /*  IBM_PRO_PRINTER_XL24        */
        &DVTDfltDMSettingsProX24E,    /*  IBM_PRO_PRINTER_XL24E       */
        &DVTDfltDMSettings4224,       /*  IBM_4224_COLOUR             */
        &DVTDfltDMSettings4224,       /*  IBM_4224_MONO               */
        &DVTDfltDMSettings2380,       /*  IBM_2380                    */
        &DVTDfltDMSettings2381,       /*  IBM_2381                    */
        &DVTDfltDMSettings2390,       /*  IBM_2390                    */
        &DVTDfltDMSettings2391,       /*  IBM_2391                    */
        &DVTDfltDMSettings4226,       /*  IBM_4226            PD00222 */
        &DVTDfltDMSettings2390_PS1    /*  IBM_2390_PS1                */
    };

#endif /* IBM42XX_DRV */



