/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1992 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 source code is provided to you solely for       */
/*    the purpose of assisting you in your development of OS/2 device        */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Developer Connection Device Driver       */
/*    Source Kit for OS/2. This Copyright statement may not be removed.      */
/*                                                                           */
/*****************************************************************************/
/**************************************************************************
 *                            Lexmark Confidential
 *
 * SOURCE FILE NAME = PRDUPATT
 *
 * DESCRIPTIVE NAME = Printer Device Driver Pattern types and constants
 *
 *
 * VERSION
 *
 * DATE
 *
 * DESCRIPTION
 *
 * FUNCTIONS
 *
 * ENTRY POINTS:
 *
 * DEPENDENCIES:
 *
 * NOTES
 *
 *
 * STRUCTURES
 *
 * EXTERNAL REFERENCES
 *
 * EXTERNAL FUNCTIONS
 *
*/

/**********************************************************************/
/* Type to define a pattern                                           */
/**********************************************************************/
typedef struct
    {
        /**************************************************************/
        /* 1. First 16 bytes                                          */
        /**************************************************************/
        PBYTE      lpPatBM;           /* pattern itself               */
        USHORT     usPatWidth;        /* width in pels of pattern     */
        USHORT     usPatHeight;       /* height in pels of pattern    */
        USHORT     usPatBytesPerRow;  /* increment to the next row    */
        USHORT     usPatMemSize;      /* size of pattern memory       */
        USHORT     usFGMix;           /* eponymous                    */
        USHORT     usBGMix;           /* eponymous                    */

        /**************************************************************/
        /* 2. Next 16 bytes (or so)                                   */
        /**************************************************************/
        USHORT     usTopOffset;       /* offset to the top row        */
        USHORT     usPatMode;         /* pattern copy mode            */
        USHORT     usPatFlags;        /* some useful flags            */
        BYTE       cBitCount;         /* (1,1) or (4,1)               */
        BYTE       cPatType;          /* ours, bitmap, or font        */
        PBYTE      abGreyScale;       /* pointer to a g/s pattern     */
    } PatType;
/*
typedef PatType far * pPatType;
*/
typedef PatType * pPatType;                                /* CON3201 */


/**********************************************************************/
/* Constants for the pattern type field                               */
/**********************************************************************/
#define PAT_IS_DRIVERS        0
#define PAT_IS_FONT           1
#define PAT_IS_BITMAP         2

/**********************************************************************/
/* Constants for the pattern flag field                               */
/**********************************************************************/
#define PAT_MEM_ALLOCATED     0x0001
#define PAT_GREYSCALE         0x0002
#define PAT_BLANK             0x0004
#define PAT_SOLID             0x0008
#define PAT_MIX_OK            0x0010
#define PAT_WIDTH_OK          0x0020




