/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1992 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 source code is provided to you solely for       */
/*    the purpose of assisting you in your development of OS/2 device        */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Developer Connection Device Driver       */
/*    Source Kit for OS/2. This Copyright statement may not be removed.      */
/*                                                                           */
/*****************************************************************************/
/**************************************************************************
 *                            Lexmark Confidential
 *
 * SOURCE FILE NAME = PRDMTYPT
 *
 * DESCRIPTIVE NAME = Printer Device Driver Device Mode type
 *                    definitions
 *
 *
 * VERSION
 *
 * DATE
 *
 * DESCRIPTION
 *
 * FUNCTIONS
 *
 * ENTRY POINTS:
 *
 * DEPENDENCIES:
 *
 * NOTES
 *
 *
 * STRUCTURES
 *
 * EXTERNAL REFERENCES
 *
 * EXTERNAL FUNCTIONS
 *
*/


/**********************************************************************/
/* Types for Form info.                                               */
/**********************************************************************/
typedef BYTE tForm[FORM_DATA_LENGTH];

typedef tForm *lpForm;

typedef struct sform
    {
        struct sform *NextForm;
        BYTE              FormType;
        BYTE              FormID;
        tForm             FormData;
    } sForm;

typedef sForm * psForm;

/**********************************************************************/
/* FormInfo structure in the DRIVDATA GeneralData structure. Note     */
/* that currently only the form name, type and units are used.        */
/**********************************************************************/
typedef struct
    {
        CHAR        FormName[33];      /* Name of the form            */
        CHAR        FormType;          /* Paper or envelope type form */
        CHAR        FormUnits;         /* Inch or mm unit form        */
        ULONG       FormWidth;         /* Form width in units as abv  */
        ULONG       FormDepth;         /* Form depth in units as abv  */
        WcsRect     FormClip;          /* Clip info of the form       */
    } FormInfoStruc;

typedef FormInfoStruc * pFormInfoStruc;

/**********************************************************************/
/* DRIVDATA GeneralData structure for our device drivers              */
/**********************************************************************/
typedef struct
    {
        /**************************************************************/
        /* Start with the old 42XX definitions                        */
        /**************************************************************/
        ULONG            PrinterType;  /* Current printer type        */
        ULONG            Resolution;   /* Current resolution index    */
        ULONG            Orientation;  /* Portrait or landscape       */
        ULONG            NumberOfForms;/* Number of forms to be used  */
        ULONG            FormNumber1;  /* Form number for first page  */
                                       /* or all pages if only 1 form */
        ULONG            FormNumber2;  /* Form number for second page */
        CHAR             PrinterName[35];/* Printer name              */

        /**************************************************************/
        /* Add in new fields for version 200 of the drivers.          */
        /**************************************************************/
        ULONG            DriverType;  /* Driver type                  */
        USHORT           SimDup;      /* Duplex mode (simplex/duplex) */
        USHORT           DuplexEnabled; /* Duplex enabled (Heritage)  */
        USHORT           Type;        /* default font type            */
        USHORT           Index;       /* Index of default font, or =  */
                                      /* IndexInCard if card font     */
        USHORT           CodePageNo;  /* index into DVTCodePageList,  */
                                      /* not the code page # itself   */
        CHAR             CardName[CARD_DATA_LENGTH];
                                      /* name of font card in which   */
                                      /* the default font reside      */
        FormInfoStruc    FormInfo1;   /* Form info for first page     */
                                      /* or all pages if only 1 form  */
        FormInfoStruc    FormInfo2;   /* Form info for second page    */
        USHORT           DLoadSysFonts;
                                      /* Fast system fonts option stat*/
        USHORT           DisableOutlineFonts;/* PD00136...            */
        USHORT           DfltFontPointSz;
                                      /* PD00137 Def outline font PSz */
        ULONG            Resolution2; /* PD00587 : Resolution for     */
                                      /* 2390's as we now support     */
                                      /* 360x360                      */
        USHORT           MachineType; /* PD00651:Has the 23XX printer */
                                      /* changed MachineType - NLS    */
        USHORT           PrinterPatterns; /* PD00769 Flag added       */
        ULONG            Resolution3; /* 600DPI : Resolution for      */
                                      /* 4029's 600x600 resolution    */
    } DMDriverStruc;

typedef DMDriverStruc * pDMDriverStruc;


/**********************************************************************/
/* Device Modes Settings structure                                    */
/* Any changes to this structure, or to the INI file lengths used     */
/* for the members of this structure, must be reflected in the        */
/* value of HEADER_LENGTH and the offset constants in PRDMCONE.H.     */
/**********************************************************************/
typedef struct                         /* Number of digits used in    */
    {                                  /* INI entry:                  */
        USHORT      PrinterType;       /*  0 PRINTER_TYPE_LENGTH  (2) */
        USHORT      INIEntrySize;      /*  1 NO_DATA_SIZE_DIGITS  (5) */
        USHORT      Orientation;       /*  2 ORIENTATION_LENGTH   (1) */
        USHORT      Resolution;        /*  3 RESOLUTION_LENGTH    (1) */
        USHORT      FFSet;             /*  4 FORM_FEED_LENGTH     (1) */
        USHORT      DefaultSpoolIndex; /*  5 SPOOL_INDEX_LENGTH   (1) */
        USHORT      PelAddrFontType;   /*  6                      (1) */
        USHORT      SourceIndex;       /*  7 NO_INFO_SIZE_DIGITS  (2) */
        USHORT      AddedFeed;         /*  8                      (1) */
        USHORT      SelectedForm;      /*  9 NO_FORM_CNT_DIGITS   (3) */
        USHORT      NumberOfForms;     /* 10 NO_FORM_CNT_DIGITS   (3) */
        USHORT      NumberAvailCards;  /* 11 NO_FONT_CNT_DIGITS   (3) */
        USHORT      NumberOwnedCards;  /* 12 NO_FONT_CNT_DIGITS   (3) */
        USHORT      ShippedCardCount;  /* 13 NO_INFO_SIZE_DIGITS  (2) */
        USHORT      NumberOfDownFonts; /* 14 NO_FONT_CNT_DIGITS   (3) */
        USHORT      DownCPMemAvail;    /* 15                      (1) */
        USHORT      NoOfAddedCPs;      /* 16 NO_CODE_PAGE_DIGITS  (2) */
        USHORT      InitCodePage;      /* 17 NO_CODE_PAGE_DIGITS  (2) */
        USHORT      InitCPReloadType;  /* 18                      (1) */

        /**************************************************************/
        /* New fields for merged code 10/90.                          */
        /**************************************************************/
        USHORT      MemoryOption;      /* 19 NO_MEM_OPT_DIGITS    (2) */
        USHORT      ResFontSet;        /* 20                      (1) */
        USHORT      SimDup;            /* 21                      (1) */
        USHORT      DuplexEnabled;     /* 22                      (0) */
        USHORT      DefaultSource;     /* 23 NO_DEF_SOURCE_DIGITS (1) */
        USHORT      BandCompression;   /* 24                      (1) */
        USHORT      DownSysFonts;      /* 25 DownSysFonts         (1) */
        USHORT      DisableOutlineFonts; /* 26 PD00136...         (1) */
        USHORT      MachineType;       /* 27 DIAL/NILE            (1) */
        USHORT      DfltFontPointSz;   /* 28 DEF outline font PSz (2) */
                                       /*    PD00137                  */
        USHORT      NotUsed;           /* 29 PADDING_LENGTH       (4) */
        /**************************************************************/
        /* End of new fields 10/90.                                   */
        /**************************************************************/

        USHORT      SourceDataSize;    /* 28 NO_DATA_SIZE_DIGITS  (2) */
        USHORT      MetricsPathLength; /* 29 PATHNAME_SIZE_LENGTH (2) */
        USHORT      CardDataSize;      /* 30 NO_DATA_SIZE_DIGITS  (5) */
        USHORT      DownFontDataSize;  /* 31 NO_DATA_SIZE_DIGITS  (5) */
        USHORT      CodePageDataSize;  /* 32 NO_DATA_SIZE_DIGITS  (5) */
        USHORT      DfltFontInfoSize;  /* 33 NO_INFO_SIZE_DIGITS  (5) */
        USHORT      PrinterPatterns;   /* 34 PD00769 Printer Patterns flag(2) */
    } DMSettingsType;

typedef DMSettingsType *lpDMSettings;


/**********************************************************************/
/* Structure for converting old INI file to new format.               */
/**********************************************************************/
typedef struct
    {
        BYTE         LPName[32];
        USHORT       SelectedPrinter;
        USHORT       PrinterInfoFlag;
        PBYTE        pLPNInfo;
    } LPNInfoType;

/**********************************************************************/
/* Structure for the download font info needed for the dialogue box.  */
/**********************************************************************/
typedef struct
    {
        PBYTE        DownloadInfo;
        ULONG        DownloadSize;
        BYTE         DownloadType;
    } DownloadStrucType;

typedef DownloadStrucType *lpDownloadStruc;


/**********************************************************************/
/* Structure for the card slot information.                           */
/**********************************************************************/
typedef struct
    {
        USHORT          Index;             /* Index of card into list */
                                           /* of owned cards          */
        USHORT          NoOfFonts;         /* Including different     */
                                           /* quality levels          */
        BYTE            CardName[9];
    } SlotInfoType;


/**********************************************************************/
/* Structures for the code page information.                          */
/**********************************************************************/
typedef struct
    {
        PSZ        PathName;       /* Pathname for this code page -   */
                                   /* this is null if the code page   */
                                   /* page has not been added         */
        USHORT     PathNameSize;   /* Pathname size - no terminator   */
        USHORT     Added;          /* Indices of the added code       */
                                   /* pages (into DVTCodePageList)    */
        USHORT     Alter;          /* Indices of the code pages       */
                                   /* displayed in the add or remove  */
                                   /* boxes (into DVTCodePageList)    */
    } DMCPListType;

typedef DMCPListType *lpDMCPList;

typedef struct
    {
        DMCPListType     CPList[NO_OF_ADDABLE_CPS];
        USHORT           AddCPIndex;    /* Index into DVTCodePageList */
                                        /* of code page to add        */
    } DMCPInfoType;

typedef DMCPInfoType *lpDMCPInfo;

/**********************************************************************/
/* New structures for default font list                               */
/**********************************************************************/
typedef struct
    {
        CHAR          Facename[32];
        ULONG         Fgid;
        USHORT        PointSize;
        USHORT        CodePage;
    } FontMatchType;

typedef FontMatchType *lpFontMatchType;

typedef struct
    {
        USHORT        FontType;
        USHORT        FontIndex;
        USHORT        FontCodePage;
        CHAR          FontCardName [10];
    } FontDescType;

typedef FontDescType *lpFontDescType;

typedef struct
    {
        USHORT        Valid;
        FontMatchType FontMatch;
        FontDescType  FontDescription;
    } DfltFontTableEntry;

typedef DfltFontTableEntry *lpDfltFontTable;

typedef struct
    {
        lpDfltFontTable  DefaultFontTable;
        USHORT           FontTableSize;
        USHORT           CurrentEntry;
        USHORT           DefaultFontFound;
        USHORT           DefaultFontIndex;
        USHORT           FontError;
        USHORT           InvalidEntries;
    } DfltFontListType;

typedef DfltFontListType   *lpDfltFontList;

/**********************************************************************/
/* Structure for source-form connections info.                        */
/*                                                                    */
/* NO_OF_AUTO_TRAYS = MAX_NO_OF_PAPER_TRAYS  (paper sheet feed)       */
/*                    + 1  (then paper tractor feed)                  */
/*                    + 1  (then envelope feed)                       */
/*                                                                    */
/* The selected forms in the array AutoTrayForm are in the above      */
/* order.  The CS_* constants for automatic trays defined in          */
/* PRDMCONE.H must start at 0 and "map onto" the array AutoTrayForm.  */
/**********************************************************************/
typedef struct
    {
        USHORT           AutoTrayForm[NO_OF_AUTO_TRAYS];
        USHORT           NoOfManualPaper;
        PUSHORT          pManualPaper;
        USHORT           NoOfManualEnv;
        PUSHORT          pManualEnvelope;
    } DMConnsInfoType;

typedef DMConnsInfoType *lpDMConnsInfo;


/**********************************************************************/
/* External structure in Device Modes File.                           */
/**********************************************************************/
typedef struct
    {                                      /*   General variables     */
        HWND             hwndMain;         /* Window handle for       */
                                           /* current options box     */
        HWND             hwndOwner;        /* Window handle for       */
                                           /* parent box              */
        HWND             hwndHelp;         /* handle for help         */
                                           /* instance                */
        HWND             hwndFocus;        /* handle for current      */
                                           /* focus point for help    */
        HMODULE          HModule;          /* Module handle reqd.     */
                                           /* by WinLoadString        */
        USHORT           DialogId;         /* DB_ constant for        */
                                           /* current dialog box      */
        BYTE             DecimalPoint;     /* Character used -        */
                                           /* varies with country     */
        PULONG           CursorHandle;     /* Used to store cursor    */
                                           /* shape while hour-       */
                                           /* glass is displayed      */
        BOOL             BodyDataChanged;  /* Flag controlling        */
                                           /* whether body data       */
                                           /* is saved                */
        BYTE             PrinterName[35];  /* Logical printer name    */
                                           /* (eg. PRINTER1) PD00185  */

        DMSettingsType   Settings;
        DMDriverStruc    DriverData;

                                           /*   File handling data    */
        HDIR             SearchDirHandle;
        FILEFINDBUF3     FileInfoBuf;
        HFILE            FileHandle;

                                           /*   Form handling data    */
        USHORT           DefaultForm;      /* Letter or A4 -          */
                                           /* depending on country    */
        USHORT           FormTemplateNum;  /* No of the form being    */
                                           /* used as a template -    */
                                           /* this will be a          */
                                           /* pre-defined form        */
        tForm            FormBuffer;
        psForm           Forms;

                                           /*   Sources data          */
        USHORT           PrevIndex;        /* Of selected form        */
        USHORT           SelectedSource;   /* BoxId of current        */
                                           /* source config.          */
        USHORT           CurrentSource;    /* CS_ constant            */
                                           /* corresponding to        */
                                           /* current source tray     */
        BOOL             SingleSelection;  /* On for automatic,       */
                                           /* off for manual          */
        BYTE             SourceType;       /* Paper/Envelope          */

                                           /*   Connections data      */
        DMConnsInfoType  ConnsInfo;        /* Form associations       */
        DMConnsInfoType  TmpConnsInfo;     /* Temporary copy of       */
                                           /* Form associations       */

                                           /*   Card data             */
        USHORT           CardsToDisplay;   /* The number of cards     */
                                           /* just added              */
        BOOL             Initializing;     /* Flag controlling        */
                                           /* whether card lists are  */
                                           /* redrawn in the boxes    */
        BOOL             OwnedChanged;     /* Flag for whether the    */
                                           /* list of owned cards has */
                                           /* changed                 */
        USHORT           FreeOwnedEntries; /* No. of entries memory   */
                                           /* allocated for but not   */
                                           /* used in OwnedIndexList  */
        lpCard           pShippedCards;    /* Array of card names of  */
                                           /* the shipped cards (each */
                                           /* is 9 chars long)        */
        PBYTE            pCardData;        /* Pathnames of all added  */
                                           /* cards (seperated by     */
                                           /* '\0's)                  */
        PUSHORT          OwnedIndexList;   /* Indices of each owned   */
                                           /* card into list of       */
                                           /* available cards.        */
        SlotInfoType     Slot[MAX_NO_OF_CARD_SLOTS];
                                           /* Info for the cards      */
                                           /* currently in the slots  */

                                           /* Temporary copies of..   */
        USHORT           TmpNumberOwnedCards; /* No. of owned cards   */
                                              /* in DMSettings struct.*/
        PUSHORT          TmpOwnedIndexList;
        USHORT           TmpSlot[MAX_NO_OF_CARD_SLOTS];

                                           /*   CDF data              */
        BYTE             CDFName[FILENAME_SIZE + 1];
                                           /* Name of CDF file (incl. */
                                           /* extension) we are       */
                                           /* currently looking at    */

        PBYTE            pMetricsPath;     /*   Dflt metrics path     */
                                           /* Directory shipped       */
                                           /* metrics are copied to - */
                                           /* then acts as dflt path  */
                                           /* for added cards         */

                                           /*   Download font data    */
        lpDownloadStruc  pDownFontList;
        BYTE             DownFontFileName[9];
        USHORT           DownFontAdded;


        DMCPInfoType     CPInfo;           /*   Code Page data        */

        DfltFontInfoType DfltFontInfo;     /*   Dflt font info        */

        DfltFontListType DefaultFontList;  /* Default font list       */

        USHORT           IniVersionType;   /* says whether .ini entry */
                                           /* is current or old type  */
        USHORT           Reserved;
    } DModeDataType;

typedef DModeDataType *lpDModeData;


/**********************************************************************/
/* Structure for INI entry for each printer type.                     */
/**********************************************************************/
typedef struct
    {
        PBYTE         Data;
        USHORT        EntrySize;
        USHORT        BufferSize;
        USHORT        DataChange;
    } DMIniEntryType;

typedef DMIniEntryType *lpDMIniEntry;

/**********************************************************************/
/* DEBUG_SEGMENTS : SegmentAlloc flag indicates whether a segment     */
/* has been allocated. The old 'RealDummyFlag' was reduntant.         */
/**********************************************************************/
typedef struct
    {
        PBYTE         FMFAddress;
        USHORT        SegmentAllocFlag;
    } FMFFontList;

typedef FMFFontList *lpFMFFontList;

/**********************************************************************/
/* PD00183 : Type for simplified radio button processing - used by    */
/* Prdm_RadioButtonControl                                            */
/**********************************************************************/
typedef struct
    {
        BOOL        RadGreyed;
        USHORT      RadHighlight;
        USHORT      RadNumber;
        USHORT      RadItem[4];
    } RadCtrlType;

typedef RadCtrlType * lpRadCtrlType;


