/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1992 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 source code is provided to you solely for       */
/*    the purpose of assisting you in your development of OS/2 device        */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Developer Connection Device Driver       */
/*    Source Kit for OS/2. This Copyright statement may not be removed.      */
/*                                                                           */
/*****************************************************************************/
/**************************************************************************
 *                            Lexmark Confidential
 *
 * SOURCE FILE NAME =
 *
 * DESCRIPTIVE NAME =
 *
 *
 * VERSION
 *
 * DATE
 *
 * DESCRIPTION
 *
 * FUNCTIONS
 *
 * ENTRY POINTS:
 *
 * DEPENDENCIES:
 *
 * NOTES
 *
 *
 * STRUCTURES
 *
 * EXTERNAL REFERENCES
 *
 * EXTERNAL FUNCTIONS
 *
*/
/**********************************************************************/
/* Debug functions and macros for ring 3 functions.                   */
/**********************************************************************/
/**********************************************************************/
/* LOGERR Macros                                                      */
/**********************************************************************/
#ifdef PRD_DEBUG
        extern void prdz_Ring3LogErr(PBYTE,PBYTE,USHORT);
#define Ring3LOGERR(S,C,P,N,E)                                         \
        prdz_Ring3LogErr(S,C,E)
#else /* ndef PRD_DEBUG */
#define Ring3LOGERR(S,C,P,N,E)                                         \
        WinSetErrorInfo(MAKEERRORID(SEVERITY_SEVERE,E),                \
                        SEI_NOBEEP|SEI_NOPROMPT)
#endif /* ndef PRD_DEBUG */

#define LOGWARNING(S,C,P,N,E)                                          \
        WinSetErrorInfo(MAKEERRORID(SEVERITY_WARNING,E),               \
                        SEI_NOBEEP|SEI_NOPROMPT)

#ifdef PRD_DEBUG
        extern void prdz_Ring3LogDosErr(PBYTE,PBYTE,USHORT);
#define Ring3LOGDOSERR(S,C,P,N,E)                                      \
        prdz_Ring3LogDosErr(S,C,E)
#else /* ndef PRD_DEBUG */
#define Ring3LOGDOSERR(S,C,P,N,E)                                      \
        WinSetErrorInfo(MAKEERRORID(SEVERITY_SEVERE,PMERR_BASE_ERROR), \
                        SEI_NOBEEP|SEI_NOPROMPT|SEI_DOSERROR,          \
                        E)
#endif /* ndef PRD_DEBUG */


#define RIP(S,C,P,N,E)                                                 \
        {DebugOutput(S);                                               \
         DebugOutput(C);                                               \
         WinSetErrorInfo(MAKEERRORID(SEVERITY_SEVERE,1),               \
                         SEI_REGISTERS|SEI_STACKTRACE,                 \
                         C)                                            \
        }


/**********************************************************************/
/* Debug constants...                                                 */
/**********************************************************************/
#define  DECIMAL    0x01
#define  HEX        0x02
#define  BINARY     0x04

#ifdef PRD_DEBUG

VOID Ring3CrLf(VOID);
VOID Ring3OutputValue(ULONG, USHORT);
VOID Ring3OutputPair(PCHAR,ULONG,USHORT);
VOID Ring3OutputString(PCHAR);
VOID Ring3OutputPrompt(PCHAR);

#else

extern VOID   Ring3CrLf();
extern VOID   Ring3OutputValue(ULONG, USHORT);
extern VOID   Ring3OutputPair(CHAR *, ULONG, USHORT);
extern VOID   Ring3OutputString(PCHAR);
extern VOID   Ring3OutputPrompt(PCHAR);

/* CON3201 Already defined in PMWINP.H
#define DebugOutput(X)
*/

#endif

extern BOOL DebugOn;
extern BOOL WaitForKey;

