/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1992 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 source code is provided to you solely for       */
/*    the purpose of assisting you in your development of OS/2 device        */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Developer Connection Device Driver       */
/*    Source Kit for OS/2. This Copyright statement may not be removed.      */
/*                                                                           */
/*****************************************************************************/
/**************************************************************************
 *                            Lexmark Confidential
 *
 * SOURCE FILE NAME = PRDMACRO
 *
 * DESCRIPTIVE NAME = Printer Device Driver Macros
 *
 *
 * VERSION
 *
 * DATE
 *
 * DESCRIPTION
 *
 * FUNCTIONS
 *
 * ENTRY POINTS:
 *
 * DEPENDENCIES:
 *
 * NOTES
 *
 *
 * STRUCTURES
 *
 * EXTERNAL REFERENCES
 *
 * EXTERNAL FUNCTIONS
 *
*/

/**********************************************************************/
/* abs(x) : returns the absolute value of x (x must be signed)        */
/**********************************************************************/
#define abs(x) ((x)<0?(-x):(x))

/**********************************************************************/
/* RotateLeft(x) : returns byte x rotated one bit left                */
/**********************************************************************/
#define RotateLeft(x)                                                  \
        (((x) & 0x80)?((x)<<1)|0x01:(x)<<1)

/**********************************************************************/
/* max(x,y) : returns whichever of x and y has the higher value       */
/**********************************************************************/
#define max(x,y) (((x)>(y))?(x):(y))

/**********************************************************************/
/* min(x,y) : returns whichever of x and y has the lower value        */
/**********************************************************************/
#define min(x,y) (((x)<(y))?(x):(y))

/**********************************************************************/
/* min3(x,y,z) : returns whichever of x, y and z has the lowest value */
/**********************************************************************/
#define min3(x,y,z) min(min(x,y),z)


/**********************************************************************/
/* sgn(x) : returns +1 or -1 or zero depending on sign of value       */
/**********************************************************************/
#define sgn(x) (((x)>0)?1:((x)?-1:0))

/**********************************************************************/
/* hab definition...                                                  */
/**********************************************************************/
#define hab (HAB)0

/**********************************************************************/
/* Macro which will close the trace file                              */
/**********************************************************************/
#ifdef PRD_TRACE
#if PRD_TRACE != 0
#define CloseTraceFile                                                 \
            { extern USHORT prdz_TraceFile;                              \
              (void)DosClose((HFILE)prdz_TraceFile);}
#else /* if PRD_TRACE == 0 */
#define CloseTraceFile
#endif /* if PRD_TRACE == 0 */
#else /* ifndef PRD_TRACE */
#define CloseTraceFile
#endif /* ifndef PRD_TRACE   */

/**********************************************************************/
/* Macro which will clear a fast safe RAM semaphore                   */
/* CON3201: now using Mutex Semaphores to make CSet/2 compliant       */
/**********************************************************************/
#define prdg_ClearSemaphore(x)                                        \
    DosReleaseMutexSem((HMTX)(x))
/*  FSRSemLeave((PFSRSEM)(x))    **   CON3201   **                    */

/* #define ClearSemaphore(x) prdg_ClearSemaphore((PFSRSEM)x);  CON3201 */
#define ClearSemaphore(x) prdg_ClearSemaphore((HMTX)x);

/**********************************************************************/
/* Macro which will request a fast safe RAM semaphore, suspending     */
/* the thread if the request does not succeed                         */
/* CON3201: now using Mutex Semaphores to make CSet/2 compliant       */
/**********************************************************************/
#define prdg_RequestSemaphore(x,y)                                     \
    DosRequestMutexSem((HMTX)(x),SEM_INDEFINITE_WAIT)
/*  FSRSemEnter((PFSRSEM)(x))      **  CON3201  **                    */

/**********************************************************************/
/* Macro which gives a semaphore owner process ID                     */
/* CON3201: now using Mutex Semaphores to make CSet/2 compliant       */
/**********************************************************************/
/* #define SemaphoreOwner(x) ((PFSRSEM)x)->ProcID  ** CON3201 **      */
/* Comment out for now, this macro is not used in 42xx                */

/**********************************************************************/
/* Define macro for incrementing far pointers to huge bitmaps -       */
/* this checks for segment crossing. The first part of the expansion  */
/* is included so that, if desired, expressions like:                 */
/*      *pointer1 = *POSTINC(pointer2); ( pointer1=pointer2++; )      */
/* (i.e. *pointer1 = *pointer2++;) can be used.                       */
/**********************************************************************/
/* CON3201 -  Comment out for now see if this needs to be implemented */
/* #define POSTINC(p) p;if (!++OFFSETOF(p)) SELECTOROF(p) += prdd_HugeInc; */


/**********************************************************************/
/* Bresenham macro to get a byte from the bitmap                      */
/**********************************************************************/
/* CON3201 comment out for now, will probably just add offset to pointer */
/*         to get next byte from bitmap                                  */
/*
** #define prdm_GetByte                                                   \
**{                                                                      \
**    OFFSETOF(BMAddress) = OFFSETOF(ByteOffset);                        \
**    SELECTOROF(BMAddress) = SELECTOROF(BLEBitmap);                     \
**    if ( SELECTOROF(ByteOffset) )                                      \
**    {                                                                  \
**        SELECTOROF(BMAddress) += SELECTOROF(ByteOffset)                \
**        * prdd_HugeInc;                                                \
**    }                                                                  \
**    BMByte = *BMAddress;                                               \
}
 */
/* CON3201 */
#define prdm_GetByte                       \
{                                          \
    BMAddress = BLEBitmap;                 \
    BMByte = *BMAddress;                   \
}

/**********************************************************************/
/* Macro for switching raw data through the escape sequence parser    */
/* in line                                                            */
/**********************************************************************/
#define prdm_Parser(INCHAR)                                            \
{                                                                      \
    unsigned char inch = (unsigned char)INCHAR;                        \
                                                                       \
    if (DCIData->ParserState != prdg_Text)                             \
        prdg_ParseRawData(DCIData,inch);                               \
    else                                                               \
    {                                                                  \
        if (inch >= 0x20)                                              \
            DCIData->FFstate = prdg_FFtext;                            \
        else if (inch == 0x0c)                                         \
            DCIData->FFstate = prdg_FFx0c;                             \
        else if (inch == 0x1b)                                         \
        {                                                              \
            DCIData->ParserState = prdg_ESC_match;                     \
            DCIData->ParserSequence = NULL;                            \
        }                                                              \
    }                                                                  \
}

/**********************************************************************/
/* Macro to put an address in the engine's dispatch table             */
/* parameters:                                                        */
/*            P - printer driver function address                     */
/*            F - function number                                     */
/*            D - dispatch table pointer                              */
/**********************************************************************/
#define SetAdd(P, F, D)                                                \
    *((D) + ((F) & 0xffL)) = (ULONG)(P)

/**********************************************************************/
/* Macro to extract the command bits of a function number and mask    */
/* them with CommandMask from the DCIData.                            */
/* parameters:                                                        */
/*             I - pointer to instance data                           */
/**********************************************************************/
#if 0
#define GetCommand(I)                                                  \
    Command = (((PUSHORT)(&FunN))[1] & (I->CommandMask))
#endif

/**********************************************************************/
/* CON3201 - Changed GetCommand macro, Command is now a ULONG         */
/**********************************************************************/
#define GetCommand(I)                                                  \
    Command = (FunN & (I->CommandMask))



/**********************************************************************/
/* Macros to check if a function has been called while a path or area */
/* is open                                                            */
/**********************************************************************/
#define prdm_ValidatePath                                              \
    if (Command & COM_PATH )                                           \
    {                                                                  \
        LOGERR(TFUNC, "Invalid in path", FNULL, 0,                     \
               PMERR_INV_IN_PATH);                                     \
        return(ERROR_ZERO);                                            \
    }                                                                  \

#define prdm_ValidateArea                                              \
    if (Command & COM_AREA )                                           \
    {                                                                  \
        LOGERR(TFUNC, "Invalid in area", FNULL, 0,                     \
               PMERR_INV_IN_AREA);                                     \
        return(ERROR_ZERO);                                            \
    }

/**********************************************************************/
/* Macro  to lock a dc for exclusive use by the current thread        */
/* the engine guarantees that only the process which opened the DC    */
/* will call the device driver                                        */
/*                                                                    */
/* if tidLock is set then a process is already using the DC           */
/*     if it is the current thread we've screwed up unlocking         */
/*     somewhere so go straight on into the driver                    */
/*                                                                    */
/*     if it's a different thread                                     */
/*         log HDC_BUSY error                                         */
/*                                                                    */
/* if we get this far, the DC is free so                              */
/*     lock the DC                                                    */
/**********************************************************************/
VOID   prdz_LeaveDriver(lpDCI);
USHORT prdz_EnterDriver(lpDCI);
#define prdm_EnterDriver(I)                                            \
    if ( !prdz_EnterDriver(I) )                                        \
        return(ERROR_ZERO);

/**********************************************************************/
/* Macro to unlock the DC prior to exit                               */
/**********************************************************************/
#define prdm_LeaveDriver(I)                                            \
    prdz_LeaveDriver(I)


/**********************************************************************/
/* Macros to write and read to the INI file.                          */
/**********************************************************************/
#define prdm_WriteThreeTextDigits(V, P)                                \
*P++ = (BYTE)(V / 100) + '0';                                          \
MacroTemp = V - (V/100) * 100;                                         \
*P++ = (BYTE)(MacroTemp / 10) + '0';                                   \
MacroTemp = MacroTemp - (MacroTemp /10) * 10;                          \
*P++ = (BYTE)(MacroTemp) + '0'

#define prdm_WriteFiveTextDigits(V, P)                                 \
*P++ = (BYTE)(V / 10000) + '0';                                        \
MacroTemp = V - (V/10000) * 10000;                                     \
*P++ = (BYTE)(MacroTemp / 1000) + '0';                                 \
MacroTemp = MacroTemp - (MacroTemp /1000) * 1000;                      \
*P++ = (BYTE)(MacroTemp / 100) + '0';                                  \
MacroTemp = V - (V/100) * 100;                                         \
*P++ = (BYTE)(MacroTemp / 10) + '0';                                   \
MacroTemp = MacroTemp - (MacroTemp /10) * 10;                          \
*P++ = (BYTE)(MacroTemp) + '0'

#define prdm_ReadWordFromText( V, N, P )                               \
{                                                                      \
    USHORT   iMacro;                                                   \
                                                                       \
    for ( V = 0, iMacro = 0; iMacro < N; iMacro++ )                    \
    {                                                                  \
        V *= 10;                                                       \
        V += *P++ - '0';                                               \
    }                                                                  \
}                                                                      \

#define prdm_WriteTextFromWord( V, N, P )                              \
{                                                                      \
    USHORT   iMacro, FactorMacro, ValueMacro;                          \
                                                                       \
    for ( FactorMacro = 1, iMacro = 0; iMacro < N-1; iMacro++ )        \
        FactorMacro *= 10;                                             \
                                                                       \
    ValueMacro = V;                                                    \
                                                                       \
    while ( FactorMacro != 1 )                                         \
    {                                                                  \
        *P++ = (BYTE)( ValueMacro / FactorMacro ) + '0';               \
        ValueMacro %= FactorMacro;                                     \
        FactorMacro /= 10;                                             \
    }                                                                  \
                                                                       \
    *P++ = (BYTE)ValueMacro + '0';                                     \
}                                                                      \

/**********************************************************************/
/* Macros for manipulating the LCID structure fields (LCIDType).      */
/* Note the parameter types in the comments above the macros - if no  */
/* more than a few bits are required, extraneous bits are masked off  */
/* prior to inclusion in the LCID.  Likewise, only pertinent bits are */
/* returned by the macros, all partial BYTE return values have        */
/* right-justified bits in the BYTE (i.e.  if 2 bits are to be        */
/* returned from the macro, they will appear in the right- most bits  */
/* of the return BYTE - e.g.  0000|00xx).                             */
/**********************************************************************/
#define ULTOLCID( ul )  (*((LCIDType *) &(ul)))
#define LCIDTOUL( lcid )  (*((PULONG) &(lcid)))

/**********************************************************************/
/* This returns the CPIndex with the high bit turned off.  Returns a  */
/* BYTE.                                                              */
/**********************************************************************/
#define prdm_GetLCIDCPIndex(lcid)                                      \
    ((BYTE)( (ULTOLCID(lcid)).CPIndex & 0x007f ))

/**********************************************************************/
/* This returns the EngineAttrs - here for consistency's sake.        */
/* Returns a BYTE.                                                    */
/**********************************************************************/
#define prdm_GetLCIDEngineAttrs(lcid)                                  \
    ((BYTE)( ULTOLCID(lcid).EngineAttrs))

/**********************************************************************/
/* This returns the Font Type - high two bits of MSB of MatchNo.      */
/* Returns a BYTE.                                                    */
/**********************************************************************/
#define prdm_GetLCIDFontType(lcid)                                     \
    ((BYTE)(( (ULTOLCID(lcid).BaseMatchNo & 0xc000) >> 14) + 1) )

/**********************************************************************/
/* This returns the FontIndex - 12 bits between Font Type and Font    */
/* Device Attributes in BaseMatchNo.  Returns a USHORT.               */
/**********************************************************************/
#define prdm_GetLCIDFontIndex(lcid)                                    \
    ((USHORT)(( (ULTOLCID(lcid)).BaseMatchNo & 0x3ffc) >> 2))

/**********************************************************************/
/* This returns the code page font index - first 8 bits of the Font   */
/* Index when the font type is Download Code Page Font.  Returns a    */
/* BYTE.                                                              */
/**********************************************************************/
#define prdm_GetLCIDCPFontIndex(lcid)                                  \
    ((BYTE)((ULTOLCID(lcid).BaseMatchNo & 0x03fc) >> 2))

/**********************************************************************/
/* This returns the global code page index - last 4 bits of the Font  */
/* Index when the font type is a Download Code Page Font.  Returns a  */
/* BYTE.                                                              */
/**********************************************************************/
#define prdm_GetLCIDGCPIndex(lcid)                                     \
    ((BYTE)((ULTOLCID(lcid).BaseMatchNo & 0x3c00) >> 10))

/**********************************************************************/
/* This returns the Font Device Attributes - low two bits of LSB of   */
/* BaseMatchNo.  Returns a BYTE.                                      */
/**********************************************************************/
#define prdm_GetLCIDFontDevAttrs(lcid)                                 \
    ((BYTE)((ULTOLCID(lcid)).BaseMatchNo & 0x0003))

/**********************************************************************/
/* This changes the CPIndex in the lcid.  Args are LCIDTYPE and a     */
/* BYTE.                                                              */
/**********************************************************************/
#define prdm_PutLCIDCPIndex(lcid, Index)                               \
    (ULTOLCID(lcid)).CPIndex = (BYTE)Index | 0x80

/**********************************************************************/
/* This changes the EngineAttrs in the lcid.  Args are LCIDTYPE and a */
/* BYTE.                                                              */
/**********************************************************************/
#define prdm_PutLCIDEngineAttrs(lcid, Attrs)                           \
    (ULTOLCID(lcid)).EngineAttrs = (BYTE)Attrs

/**********************************************************************/
/* This changes the Font Type in the lcid.  Args are LCIDTYPE and a   */
/* BYTE - low 2 bits.                                                 */
/* NB FT_RESIDENT etc are 1,2,3,4 - so subtract 1 here.               */
/**********************************************************************/
#define prdm_PutLCIDFontType(lcid, Type)                               \
    (ULTOLCID(lcid)).BaseMatchNo =                                     \
  (((Type - 1) & 0x03) << 14) | ((ULTOLCID(lcid)).BaseMatchNo & 0x3fff)

/**********************************************************************/
/* This changes the FontIndex in the lcid.  Args are LCIDTYPE and a   */
/* USHORT - low 12 bits.                                              */
/**********************************************************************/
#define prdm_PutLCIDFontIndex(lcid, Index)                             \
    (ULTOLCID(lcid)).BaseMatchNo =                                     \
      ((Index & 0x0fff) << 2) | ((ULTOLCID(lcid)).BaseMatchNo & 0xc003)

/**********************************************************************/
/* This changes the code page font index - low 8 bits of the          */
/* FontIndex when the font type is Download Code Page Font - in the   */
/* lcid.  Args are LCIDTYPE and a BYTE.                               */
/**********************************************************************/
#define prdm_PutLCIDCPFontIndex(lcid, Index)                           \
    (ULTOLCID(lcid)).BaseMatchNo =                                     \
                 (Index << 2) | ((ULTOLCID(lcid)).BaseMatchNo & 0xfc03)

/**********************************************************************/
/* This changes the global code page index - high 4 bits of the       */
/* FontIndex when the font type is Download Code Page Font - in the   */
/* lcid.  Args are LCIDTYPE and a BYTE - low 4 bits.                  */
/**********************************************************************/
#define prdm_PutLCIDGCPIndex(lcid, Index)                              \
    (ULTOLCID(lcid)).BaseMatchNo =                                     \
       ((Index & 0x0f) << 10) | ((ULTOLCID(lcid)).BaseMatchNo & 0xc3ff)

/**********************************************************************/
/* This changes the Font Device Attributes in the lcid.  Args are     */
/* LCIDTYPE and a BYTE - low 2 bits.                                  */
/**********************************************************************/
#define prdm_PutLCIDFontDevAttrs(lcid, Attrs)                          \
    (ULTOLCID(lcid)).BaseMatchNo =                                     \
             (Attrs & 0x03) | ((ULTOLCID(lcid)).BaseMatchNo & 0xfffc)


/**********************************************************************/
/* Macro that strips off flag bit of Type field in FontInfoType       */
/**********************************************************************/
#define TYPEOF(y) y & 0x7FFF

/**********************************************************************/
/* Macro that tests flag bit of Type field in FontInfoType            */
/**********************************************************************/
#define SIMULATED(y) y & 0x8000

/**********************************************************************/
/* This converts the cdef.fFlags format of engine attributes to the   */
/* FATTR format of engine attributes.                                 */
/**********************************************************************/
#define prdm_CdefToFattr(Attrs)                                        \
    ( ((Attrs & CDEF_BOLD)       ? FATTR_SEL_BOLD       : 0) |         \
      ((Attrs & CDEF_ITALIC)     ? FATTR_SEL_ITALIC     : 0) |         \
      ((Attrs & CDEF_UNDERSCORE) ? FATTR_SEL_UNDERSCORE : 0) |         \
      ((Attrs & CDEF_STRIKEOUT)  ? FATTR_SEL_STRIKEOUT  : 0) |         \
      ((Attrs & CDEF_OUTLINE)    ? FATTR_SEL_OUTLINE    : 0) )

/******************************************************************************/
/*  This converts an unsigned long RGB value to the OS/2 RGB type             */
/******************************************************************************/
/* CON3201 - GRE change RGB to RGB2 */
#define ULTORGB(ul)  ((RGB2 *) &(ul))
#define RGBTOUL(rgb) (ULONG)((rgb->bRed << 16) && (rgb->bGreen << 8) &&        \
                             (rgb->bBlue))

/******************************************************************************/
/*  PD00073 : Added this Macro.                                               */
/*  This converts an unsigned short angle in degrees to the format expected   */
/*  by the 4029 laserprinter. IE bits 0-5 are minutes and 6-14 degrees and    */
/*  msb bit 15 = 0.   This is used for shear angle and character angle.       */
/******************************************************************************/
#define prdm_AngleToPrinterFormat( angle ) (USHORT)((angle << 6) & 0x7fc0)

/******************************************************************************/
/*  PD00529 : Moved macro to here from PRDBBLT.C for consistency's sake.      */
/******************************************************************************/
#define  prdm_GetDword(M, D, R)                                                \
{                                                                              \
    switch (M)                                                                 \
    {                                                                          \
        case SRC_ZEROS       :                                                 \
            R = 0x00000000;                                                    \
            break;                                                             \
        case SRC_INVERT_BITS :                                                 \
            R = ~D;                                                            \
            break;                                                             \
        case SRC_COPY_BITS   :                                                 \
            R =  D;                                                            \
            break;                                                             \
        case SRC_ONES        :                                                 \
            R = 0xFFFFFFFF;                                                    \
            break;                                                             \
    }                                                                          \
}

