/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1992 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 source code is provided to you solely for       */
/*    the purpose of assisting you in your development of OS/2 device        */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Developer Connection Device Driver       */
/*    Source Kit for OS/2. This Copyright statement may not be removed.      */
/*                                                                           */
/*****************************************************************************/
/**************************************************************************
 *                            Lexmark Confidential
 *
 * SOURCE FILE NAME = PRDFTAB
 *
 * DESCRIPTIVE NAME = Printer Device Driver DC types
 *
 *
 * VERSION
 *
 * DATE
 *
 * DESCRIPTION
 *
 * FUNCTIONS
 *
 * ENTRY POINTS:
 *
 * DEPENDENCIES:
 *
 * NOTES
 *
 *
 * STRUCTURES
 *
 * EXTERNAL REFERENCES
 *
 * EXTERNAL FUNCTIONS
 *
*/

/**********************************************************************/
/* This module contains look up tables for the character image        */
/* expansion for download engine fonts. Each byte in the image        */
/* data is expanded to a given number of bytes depending on the       */
/* resolution. For 75 res, each byte is expanded to 4x4, for 100      */
/* res, each byte is expanded to 3x3 bytes and for 150 reolution      */
/* each byte is expanded to 2x2 bytes.                                */
/*                                                                    */
/**********************************************************************/

/* 75x75  */
CHAR pel75[256][4] =
                  {  { 0x00,0x00,0x00,0x00 },
                     { 0x00,0x00,0x00,0x0f },
                     { 0x00,0x00,0x00,0xf0 },
                     { 0x00,0x00,0x00,0xff },
                     { 0x00,0x00,0x0f,0x00 },
                     { 0x00,0x00,0x0f,0x0f },
                     { 0x00,0x00,0x0f,0xf0 },
                     { 0x00,0x00,0x0f,0xff },
                     { 0x00,0x00,0xf0,0x00 },
                     { 0x00,0x00,0xf0,0x0f },
                     { 0x00,0x00,0xf0,0xf0 },
                     { 0x00,0x00,0xf0,0xff },
                     { 0x00,0x00,0xff,0x00 },
                     { 0x00,0x00,0xff,0x0f },
                     { 0x00,0x00,0xff,0xf0 },
                     { 0x00,0x00,0xff,0xff },
                     { 0x00,0x0f,0x00,0x00 },
                     { 0x00,0x0f,0x00,0x0f },
                     { 0x00,0x0f,0x00,0xf0 },
                     { 0x00,0x0f,0x00,0xff },
                     { 0x00,0x0f,0x0f,0x00 },
                     { 0x00,0x0f,0x0f,0x0f },
                     { 0x00,0x0f,0x0f,0xf0 },
                     { 0x00,0x0f,0x0f,0xff },
                     { 0x00,0x0f,0xf0,0x00 },
                     { 0x00,0x0f,0xf0,0x0f },
                     { 0x00,0x0f,0xf0,0xf0 },
                     { 0x00,0x0f,0xf0,0xff },
                     { 0x00,0x0f,0xff,0x00 },
                     { 0x00,0x0f,0xff,0x0f },
                     { 0x00,0x0f,0xff,0xf0 },
                     { 0x00,0x0f,0xff,0xff },
                     { 0x00,0xf0,0x00,0x00 },
                     { 0x00,0xf0,0x00,0x0f },
                     { 0x00,0xf0,0x00,0xf0 },
                     { 0x00,0xf0,0x00,0xff },
                     { 0x00,0xf0,0x0f,0x00 },
                     { 0x00,0xf0,0x0f,0x0f },
                     { 0x00,0xf0,0x0f,0xf0 },
                     { 0x00,0xf0,0x0f,0xff },
                     { 0x00,0xf0,0xf0,0x00 },
                     { 0x00,0xf0,0xf0,0x0f },
                     { 0x00,0xf0,0xf0,0xf0 },
                     { 0x00,0xf0,0xf0,0xff },
                     { 0x00,0xf0,0xff,0x00 },
                     { 0x00,0xf0,0xff,0x0f },
                     { 0x00,0xf0,0xff,0xf0 },
                     { 0x00,0xf0,0xff,0xff },
                     { 0x00,0xff,0x00,0x00 },
                     { 0x00,0xff,0x00,0x0f },
                     { 0x00,0xff,0x00,0xf0 },
                     { 0x00,0xff,0x00,0xff },
                     { 0x00,0xff,0x0f,0x00 },
                     { 0x00,0xff,0x0f,0x0f },
                     { 0x00,0xff,0x0f,0xf0 },
                     { 0x00,0xff,0x0f,0xff },
                     { 0x00,0xff,0xf0,0x00 },
                     { 0x00,0xff,0xf0,0x0f },
                     { 0x00,0xff,0xf0,0xf0 },
                     { 0x00,0xff,0xf0,0xff },
                     { 0x00,0xff,0xff,0x00 },
                     { 0x00,0xff,0xff,0x0f },
                     { 0x00,0xff,0xff,0xf0 },
                     { 0x00,0xff,0xff,0xff },
                     { 0x0f,0x00,0x00,0x00 },
                     { 0x0f,0x00,0x00,0x0f },
                     { 0x0f,0x00,0x00,0xf0 },
                     { 0x0f,0x00,0x00,0xff },
                     { 0x0f,0x00,0x0f,0x00 },
                     { 0x0f,0x00,0x0f,0x0f },
                     { 0x0f,0x00,0x0f,0xf0 },
                     { 0x0f,0x00,0x0f,0xff },
                     { 0x0f,0x00,0xf0,0x00 },
                     { 0x0f,0x00,0xf0,0x0f },
                     { 0x0f,0x00,0xf0,0xf0 },
                     { 0x0f,0x00,0xf0,0xff },
                     { 0x0f,0x00,0xff,0x00 },
                     { 0x0f,0x00,0xff,0x0f },
                     { 0x0f,0x00,0xff,0xf0 },
                     { 0x0f,0x00,0xff,0xff },
                     { 0x0f,0x0f,0x00,0x00 },
                     { 0x0f,0x0f,0x00,0x0f },
                     { 0x0f,0x0f,0x00,0xf0 },
                     { 0x0f,0x0f,0x00,0xff },
                     { 0x0f,0x0f,0x0f,0x00 },
                     { 0x0f,0x0f,0x0f,0x0f },
                     { 0x0f,0x0f,0x0f,0xf0 },
                     { 0x0f,0x0f,0x0f,0xff },
                     { 0x0f,0x0f,0xf0,0x00 },
                     { 0x0f,0x0f,0xf0,0x0f },
                     { 0x0f,0x0f,0xf0,0xf0 },
                     { 0x0f,0x0f,0xf0,0xff },
                     { 0x0f,0x0f,0xff,0x00 },
                     { 0x0f,0x0f,0xff,0x0f },
                     { 0x0f,0x0f,0xff,0xf0 },
                     { 0x0f,0x0f,0xff,0xff },
                     { 0x0f,0xf0,0x00,0x00 },
                     { 0x0f,0xf0,0x00,0x0f },
                     { 0x0f,0xf0,0x00,0xf0 },
                     { 0x0f,0xf0,0x00,0xff },
                     { 0x0f,0xf0,0x0f,0x00 },
                     { 0x0f,0xf0,0x0f,0x0f },
                     { 0x0f,0xf0,0x0f,0xf0 },
                     { 0x0f,0xf0,0x0f,0xff },
                     { 0x0f,0xf0,0xf0,0x00 },
                     { 0x0f,0xf0,0xf0,0x0f },
                     { 0x0f,0xf0,0xf0,0xf0 },
                     { 0x0f,0xf0,0xf0,0xff },
                     { 0x0f,0xf0,0xff,0x00 },
                     { 0x0f,0xf0,0xff,0x0f },
                     { 0x0f,0xf0,0xff,0xf0 },
                     { 0x0f,0xf0,0xff,0xff },
                     { 0x0f,0xff,0x00,0x00 },
                     { 0x0f,0xff,0x00,0x0f },
                     { 0x0f,0xff,0x00,0xf0 },
                     { 0x0f,0xff,0x00,0xff },
                     { 0x0f,0xff,0x0f,0x00 },
                     { 0x0f,0xff,0x0f,0x0f },
                     { 0x0f,0xff,0x0f,0xf0 },
                     { 0x0f,0xff,0x0f,0xff },
                     { 0x0f,0xff,0xf0,0x00 },
                     { 0x0f,0xff,0xf0,0x0f },
                     { 0x0f,0xff,0xf0,0xf0 },
                     { 0x0f,0xff,0xf0,0xff },
                     { 0x0f,0xff,0xff,0x00 },
                     { 0x0f,0xff,0xff,0x0f },
                     { 0x0f,0xff,0xff,0xf0 },
                     { 0x0f,0xff,0xff,0xff },
                     { 0xf0,0x00,0x00,0x00 },
                     { 0xf0,0x00,0x00,0x0f },
                     { 0xf0,0x00,0x00,0xf0 },
                     { 0xf0,0x00,0x00,0xff },
                     { 0xf0,0x00,0x0f,0x00 },
                     { 0xf0,0x00,0x0f,0x0f },
                     { 0xf0,0x00,0x0f,0xf0 },
                     { 0xf0,0x00,0x0f,0xff },
                     { 0xf0,0x00,0xf0,0x00 },
                     { 0xf0,0x00,0xf0,0x0f },
                     { 0xf0,0x00,0xf0,0xf0 },
                     { 0xf0,0x00,0xf0,0xff },
                     { 0xf0,0x00,0xff,0x00 },
                     { 0xf0,0x00,0xff,0x0f },
                     { 0xf0,0x00,0xff,0xf0 },
                     { 0xf0,0x00,0xff,0xff },
                     { 0xf0,0x0f,0x00,0x00 },
                     { 0xf0,0x0f,0x00,0x0f },
                     { 0xf0,0x0f,0x00,0xf0 },
                     { 0xf0,0x0f,0x00,0xff },
                     { 0xf0,0x0f,0x0f,0x00 },
                     { 0xf0,0x0f,0x0f,0x0f },
                     { 0xf0,0x0f,0x0f,0xf0 },
                     { 0xf0,0x0f,0x0f,0xff },
                     { 0xf0,0x0f,0xf0,0x00 },
                     { 0xf0,0x0f,0xf0,0x0f },
                     { 0xf0,0x0f,0xf0,0xf0 },
                     { 0xf0,0x0f,0xf0,0xff },
                     { 0xf0,0x0f,0xff,0x00 },
                     { 0xf0,0x0f,0xff,0x0f },
                     { 0xf0,0x0f,0xff,0xf0 },
                     { 0xf0,0x0f,0xff,0xff },
                     { 0xf0,0xf0,0x00,0x00 },
                     { 0xf0,0xf0,0x00,0x0f },
                     { 0xf0,0xf0,0x00,0xf0 },
                     { 0xf0,0xf0,0x00,0xff },
                     { 0xf0,0xf0,0x0f,0x00 },
                     { 0xf0,0xf0,0x0f,0x0f },
                     { 0xf0,0xf0,0x0f,0xf0 },
                     { 0xf0,0xf0,0x0f,0xff },
                     { 0xf0,0xf0,0xf0,0x00 },
                     { 0xf0,0xf0,0xf0,0x0f },
                     { 0xf0,0xf0,0xf0,0xf0 },
                     { 0xf0,0xf0,0xf0,0xff },
                     { 0xf0,0xf0,0xff,0x00 },
                     { 0xf0,0xf0,0xff,0x0f },
                     { 0xf0,0xf0,0xff,0xf0 },
                     { 0xf0,0xf0,0xff,0xff },
                     { 0xf0,0xff,0x00,0x00 },
                     { 0xf0,0xff,0x00,0x0f },
                     { 0xf0,0xff,0x00,0xf0 },
                     { 0xf0,0xff,0x00,0xff },
                     { 0xf0,0xff,0x0f,0x00 },
                     { 0xf0,0xff,0x0f,0x0f },
                     { 0xf0,0xff,0x0f,0xf0 },
                     { 0xf0,0xff,0x0f,0xff },
                     { 0xf0,0xff,0xf0,0x00 },
                     { 0xf0,0xff,0xf0,0x0f },
                     { 0xf0,0xff,0xf0,0xf0 },
                     { 0xf0,0xff,0xf0,0xff },
                     { 0xf0,0xff,0xff,0x00 },
                     { 0xf0,0xff,0xff,0x0f },
                     { 0xf0,0xff,0xff,0xf0 },
                     { 0xf0,0xff,0xff,0xff },
                     { 0xff,0x00,0x00,0x00 },
                     { 0xff,0x00,0x00,0x0f },
                     { 0xff,0x00,0x00,0xf0 },
                     { 0xff,0x00,0x00,0xff },
                     { 0xff,0x00,0x0f,0x00 },
                     { 0xff,0x00,0x0f,0x0f },
                     { 0xff,0x00,0x0f,0xf0 },
                     { 0xff,0x00,0x0f,0xff },
                     { 0xff,0x00,0xf0,0x00 },
                     { 0xff,0x00,0xf0,0x0f },
                     { 0xff,0x00,0xf0,0xf0 },
                     { 0xff,0x00,0xf0,0xff },
                     { 0xff,0x00,0xff,0x00 },
                     { 0xff,0x00,0xff,0x0f },
                     { 0xff,0x00,0xff,0xf0 },
                     { 0xff,0x00,0xff,0xff },
                     { 0xff,0x0f,0x00,0x00 },
                     { 0xff,0x0f,0x00,0x0f },
                     { 0xff,0x0f,0x00,0xf0 },
                     { 0xff,0x0f,0x00,0xff },
                     { 0xff,0x0f,0x0f,0x00 },
                     { 0xff,0x0f,0x0f,0x0f },
                     { 0xff,0x0f,0x0f,0xf0 },
                     { 0xff,0x0f,0x0f,0xff },
                     { 0xff,0x0f,0xf0,0x00 },
                     { 0xff,0x0f,0xf0,0x0f },
                     { 0xff,0x0f,0xf0,0xf0 },
                     { 0xff,0x0f,0xf0,0xff },
                     { 0xff,0x0f,0xff,0x00 },
                     { 0xff,0x0f,0xff,0x0f },
                     { 0xff,0x0f,0xff,0xf0 },
                     { 0xff,0x0f,0xff,0xff },
                     { 0xff,0xf0,0x00,0x00 },
                     { 0xff,0xf0,0x00,0x0f },
                     { 0xff,0xf0,0x00,0xf0 },
                     { 0xff,0xf0,0x00,0xff },
                     { 0xff,0xf0,0x0f,0x00 },
                     { 0xff,0xf0,0x0f,0x0f },
                     { 0xff,0xf0,0x0f,0xf0 },
                     { 0xff,0xf0,0x0f,0xff },
                     { 0xff,0xf0,0xf0,0x00 },
                     { 0xff,0xf0,0xf0,0x0f },
                     { 0xff,0xf0,0xf0,0xf0 },
                     { 0xff,0xf0,0xf0,0xff },
                     { 0xff,0xf0,0xff,0x00 },
                     { 0xff,0xf0,0xff,0x0f },
                     { 0xff,0xf0,0xff,0xf0 },
                     { 0xff,0xf0,0xff,0xff },
                     { 0xff,0xff,0x00,0x00 },
                     { 0xff,0xff,0x00,0x0f },
                     { 0xff,0xff,0x00,0xf0 },
                     { 0xff,0xff,0x00,0xff },
                     { 0xff,0xff,0x0f,0x00 },
                     { 0xff,0xff,0x0f,0x0f },
                     { 0xff,0xff,0x0f,0xf0 },
                     { 0xff,0xff,0x0f,0xff },
                     { 0xff,0xff,0xf0,0x00 },
                     { 0xff,0xff,0xf0,0x0f },
                     { 0xff,0xff,0xf0,0xf0 },
                     { 0xff,0xff,0xf0,0xff },
                     { 0xff,0xff,0xff,0x00 },
                     { 0xff,0xff,0xff,0x0f },
                     { 0xff,0xff,0xff,0xf0 },
                     { 0xff,0xff,0xff,0xff } };



/* 150x150 */

CHAR pel150[256][2] =
                  {  { 0x00,0x00 },
                     { 0x00,0x03 },
                     { 0x00,0x0c },
                     { 0x00,0x0f },
                     { 0x00,0x30 },
                     { 0x00,0x33 },
                     { 0x00,0x3c },
                     { 0x00,0x3f },
                     { 0x00,0xc0 },
                     { 0x00,0xc3 },
                     { 0x00,0xcc },
                     { 0x00,0xcf },
                     { 0x00,0xf0 },
                     { 0x00,0xf3 },
                     { 0x00,0xfc },
                     { 0x00,0xff },
                     { 0x03,0x00 },
                     { 0x03,0x03 },
                     { 0x03,0x0c },
                     { 0x03,0x0f },
                     { 0x03,0x30 },
                     { 0x03,0x33 },
                     { 0x03,0x3c },
                     { 0x03,0x3f },
                     { 0x03,0xc0 },
                     { 0x03,0xc3 },
                     { 0x03,0xcc },
                     { 0x03,0xcf },
                     { 0x03,0xf0 },
                     { 0x03,0xf3 },
                     { 0x03,0xfc },
                     { 0x03,0xff },
                     { 0x0c,0x00 },
                     { 0x0c,0x03 },
                     { 0x0c,0x0c },
                     { 0x0c,0x0f },
                     { 0x0c,0x30 },
                     { 0x0c,0x33 },
                     { 0x0c,0x3c },
                     { 0x0c,0x3f },
                     { 0x0c,0xc0 },
                     { 0x0c,0xc3 },
                     { 0x0c,0xcc },
                     { 0x0c,0xcf },
                     { 0x0c,0xf0 },
                     { 0x0c,0xf3 },
                     { 0x0c,0xfc },
                     { 0x0c,0xff },
                     { 0x0f,0x00 },
                     { 0x0f,0x03 },
                     { 0x0f,0x0c },
                     { 0x0f,0x0f },
                     { 0x0f,0x30 },
                     { 0x0f,0x33 },
                     { 0x0f,0x3c },
                     { 0x0f,0x3f },
                     { 0x0f,0xc0 },
                     { 0x0f,0xc3 },
                     { 0x0f,0xcc },
                     { 0x0f,0xcf },
                     { 0x0f,0xf0 },
                     { 0x0f,0xf3 },
                     { 0x0f,0xfc },
                     { 0x0f,0xff },
                     { 0x30,0x00 },
                     { 0x30,0x03 },
                     { 0x30,0x0c },
                     { 0x30,0x0f },
                     { 0x30,0x30 },
                     { 0x30,0x33 },
                     { 0x30,0x3c },
                     { 0x30,0x3f },
                     { 0x30,0xc0 },
                     { 0x30,0xc3 },
                     { 0x30,0xcc },
                     { 0x30,0xcf },
                     { 0x30,0xf0 },
                     { 0x30,0xf3 },
                     { 0x30,0xfc },
                     { 0x30,0xff },
                     { 0x33,0x00 },
                     { 0x33,0x03 },
                     { 0x33,0x0c },
                     { 0x33,0x0f },
                     { 0x33,0x30 },
                     { 0x33,0x33 },
                     { 0x33,0x3c },
                     { 0x33,0x3f },
                     { 0x33,0xc0 },
                     { 0x33,0xc3 },
                     { 0x33,0xcc },
                     { 0x33,0xcf },
                     { 0x33,0xf0 },
                     { 0x33,0xf3 },
                     { 0x33,0xfc },
                     { 0x33,0xff },
                     { 0x3c,0x00 },
                     { 0x3c,0x03 },
                     { 0x3c,0x0c },
                     { 0x3c,0x0f },
                     { 0x3c,0x30 },
                     { 0x3c,0x33 },
                     { 0x3c,0x3c },
                     { 0x3c,0x3f },
                     { 0x3c,0xc0 },
                     { 0x3c,0xc3 },
                     { 0x3c,0xcc },
                     { 0x3c,0xcf },
                     { 0x3c,0xf0 },
                     { 0x3c,0xf3 },
                     { 0x3c,0xfc },
                     { 0x3c,0xff },
                     { 0x3f,0x00 },
                     { 0x3f,0x03 },
                     { 0x3f,0x0c },
                     { 0x3f,0x0f },
                     { 0x3f,0x30 },
                     { 0x3f,0x33 },
                     { 0x3f,0x3c },
                     { 0x3f,0x3f },
                     { 0x3f,0xc0 },
                     { 0x3f,0xc3 },
                     { 0x3f,0xcc },
                     { 0x3f,0xcf },
                     { 0x3f,0xf0 },
                     { 0x3f,0xf3 },
                     { 0x3f,0xfc },
                     { 0x3f,0xff },
                     { 0xc0,0x00 },
                     { 0xc0,0x03 },
                     { 0xc0,0x0c },
                     { 0xc0,0x0f },
                     { 0xc0,0x30 },
                     { 0xc0,0x33 },
                     { 0xc0,0x3c },
                     { 0xc0,0x3f },
                     { 0xc0,0xc0 },
                     { 0xc0,0xc3 },
                     { 0xc0,0xcc },
                     { 0xc0,0xcf },
                     { 0xc0,0xf0 },
                     { 0xc0,0xf3 },
                     { 0xc0,0xfc },
                     { 0xc0,0xff },
                     { 0xc3,0x00 },
                     { 0xc3,0x03 },
                     { 0xc3,0x0c },
                     { 0xc3,0x0f },
                     { 0xc3,0x30 },
                     { 0xc3,0x33 },
                     { 0xc3,0x3c },
                     { 0xc3,0x3f },
                     { 0xc3,0xc0 },
                     { 0xc3,0xc3 },
                     { 0xc3,0xcc },
                     { 0xc3,0xcf },
                     { 0xc3,0xf0 },
                     { 0xc3,0xf3 },
                     { 0xc3,0xfc },
                     { 0xc3,0xff },
                     { 0xcc,0x00 },
                     { 0x3c,0x03 },
                     { 0xcc,0x0c },
                     { 0xcc,0x0f },
                     { 0xcc,0x30 },
                     { 0xcc,0x33 },
                     { 0xcc,0x3c },
                     { 0xcc,0x3f },
                     { 0xcc,0xc0 },
                     { 0xcc,0xc3 },
                     { 0xcc,0xcc },
                     { 0xcc,0xcf },
                     { 0xcc,0xf0 },
                     { 0xcc,0xf3 },
                     { 0xcc,0xfc },
                     { 0xcc,0xff },
                     { 0xcf,0x00 },
                     { 0xcf,0x03 },
                     { 0xcf,0x0c },
                     { 0xcf,0x0f },
                     { 0xcf,0x30 },
                     { 0xcf,0x33 },
                     { 0xcf,0x3c },
                     { 0xcf,0x3f },
                     { 0xcf,0xc0 },
                     { 0xcf,0xc3 },
                     { 0xcf,0xcc },
                     { 0xcf,0xcf },
                     { 0xcf,0xf0 },
                     { 0xcf,0xf3 },
                     { 0xcf,0xfc },
                     { 0xcf,0xff },
                     { 0xf0,0x00 },
                     { 0xf0,0x03 },
                     { 0xf0,0x0c },
                     { 0xf0,0x0f },
                     { 0xf0,0x30 },
                     { 0xf0,0x33 },
                     { 0xf0,0x3c },
                     { 0xf0,0x3f },
                     { 0xf0,0xc0 },
                     { 0xf0,0xc3 },
                     { 0xf0,0xcc },
                     { 0xf0,0xcf },
                     { 0xf0,0xf0 },
                     { 0xf0,0xf3 },
                     { 0xf0,0xfc },
                     { 0xf0,0xff },
                     { 0xf3,0x00 },
                     { 0xf3,0x03 },
                     { 0xf3,0x0c },
                     { 0xf3,0x0f },
                     { 0xf3,0x30 },
                     { 0xf3,0x33 },
                     { 0xf3,0x3c },
                     { 0xf3,0x3f },
                     { 0xf3,0xc0 },
                     { 0xf3,0xc3 },
                     { 0xf3,0xcc },
                     { 0xf3,0xcf },
                     { 0xf3,0xf0 },
                     { 0xf3,0xf3 },
                     { 0xf3,0xfc },
                     { 0xf3,0xff },
                     { 0xfc,0x00 },
                     { 0xfc,0x03 },
                     { 0xfc,0x0c },
                     { 0xfc,0x0f },
                     { 0xfc,0x30 },
                     { 0xfc,0x33 },
                     { 0xfc,0x3c },
                     { 0xfc,0x3f },
                     { 0xfc,0xc0 },
                     { 0xfc,0xc3 },
                     { 0xfc,0xcc },
                     { 0xfc,0xcf },
                     { 0xfc,0xf0 },
                     { 0xfc,0xf3 },
                     { 0xfc,0xfc },
                     { 0xfc,0xff },
                     { 0xff,0x00 },
                     { 0xff,0x03 },
                     { 0xff,0x0c },
                     { 0xff,0x0f },
                     { 0xff,0x30 },
                     { 0xff,0x33 },
                     { 0xff,0x3c },
                     { 0xff,0x3f },
                     { 0xff,0xc0 },
                     { 0xff,0xc3 },
                     { 0xff,0xcc },
                     { 0xff,0xcf },
                     { 0xff,0xf0 },
                     { 0xff,0xf3 },
                     { 0xff,0xfc },
                     { 0xff,0xff } };


/* 100x100 */
CHAR pel100[256][3] =
                  {  { 0x00,0x00,0x00 },
                     { 0x00,0x00,0x07 },
                     { 0x00,0x00,0x38 },
                     { 0x00,0x00,0x3f },
                     { 0x00,0x01,0xc0 },
                     { 0x00,0x01,0xc7 },
                     { 0x00,0x01,0xf8 },
                     { 0x00,0x01,0xff },
                     { 0x00,0x0e,0x00 },
                     { 0x00,0x0e,0x07 },
                     { 0x00,0x0e,0x38 },
                     { 0x00,0x0e,0x3f },
                     { 0x00,0x0f,0xc0 },
                     { 0x00,0x0f,0xc7 },
                     { 0x00,0x0f,0xf8 },
                     { 0x00,0x0f,0xff },
                     { 0x00,0x70,0x00 },
                     { 0x00,0x70,0x07 },
                     { 0x00,0x70,0x38 },
                     { 0x00,0x70,0x3f },
                     { 0x00,0x71,0xc0 },
                     { 0x00,0x71,0xc7 },
                     { 0x00,0x71,0xf8 },
                     { 0x00,0x71,0xff },
                     { 0x00,0x7e,0x00 },
                     { 0x00,0x7e,0x07 },
                     { 0x00,0x7e,0x38 },
                     { 0x00,0x7e,0x3f },
                     { 0x00,0x7f,0xc0 },
                     { 0x00,0x7f,0xc7 },
                     { 0x00,0x7f,0xf8 },
                     { 0x00,0x7f,0xff },
                     { 0x03,0x80,0x00 },
                     { 0x03,0x80,0x07 },
                     { 0x03,0x80,0x38 },
                     { 0x03,0x80,0x3f },
                     { 0x03,0x81,0xc0 },
                     { 0x03,0x81,0xc7 },
                     { 0x03,0x81,0xf8 },
                     { 0x03,0x81,0xff },
                     { 0x03,0x8e,0x00 },
                     { 0x03,0x8e,0x07 },
                     { 0x03,0x8e,0x38 },
                     { 0x03,0x8e,0x3f },
                     { 0x03,0x8f,0xc0 },
                     { 0x03,0x8f,0xc7 },
                     { 0x03,0x8f,0xf8 },
                     { 0x03,0x8f,0xff },
                     { 0x03,0xf0,0x00 },
                     { 0x03,0xf0,0x07 },
                     { 0x03,0xf0,0x38 },
                     { 0x03,0xf0,0x3f },
                     { 0x03,0xf1,0xc0 },
                     { 0x03,0xf1,0xc7 },
                     { 0x03,0xf1,0xf8 },
                     { 0x03,0xf1,0xff },
                     { 0x03,0xfe,0x00 },
                     { 0x03,0xfe,0x07 },
                     { 0x03,0xfe,0x38 },
                     { 0x03,0xfe,0x3f },
                     { 0x03,0xff,0xc0 },
                     { 0x03,0xff,0xc7 },
                     { 0x03,0xff,0xf8 },
                     { 0x03,0xff,0xff },
                     { 0x1c,0x00,0x00 },
                     { 0x1c,0x00,0x07 },
                     { 0x1c,0x00,0x38 },
                     { 0x1c,0x00,0x3f },
                     { 0x1c,0x01,0xc0 },
                     { 0x1c,0x01,0xc7 },
                     { 0x1c,0x01,0xf8 },
                     { 0x1c,0x01,0xff },
                     { 0x1c,0x0e,0x00 },
                     { 0x1c,0x0e,0x07 },
                     { 0x1c,0x0e,0x38 },
                     { 0x1c,0x0e,0x3f },
                     { 0x1c,0x0f,0xc0 },
                     { 0x1c,0x0f,0xc7 },
                     { 0x1c,0x0f,0xf8 },
                     { 0x1c,0x0f,0xff },
                     { 0x1c,0x70,0x00 },
                     { 0x1c,0x70,0x07 },
                     { 0x1c,0x70,0x38 },
                     { 0x1c,0x70,0x3f },
                     { 0x1c,0x71,0xc0 },
                     { 0x1c,0x71,0xc7 },
                     { 0x1c,0x71,0xf8 },
                     { 0x1c,0x71,0xff },
                     { 0x1c,0x7e,0x00 },
                     { 0x1c,0x7e,0x07 },
                     { 0x1c,0x7e,0x38 },
                     { 0x1c,0x7e,0x3f },
                     { 0x1c,0x7f,0xc0 },
                     { 0x1c,0x7f,0xc7 },
                     { 0x1c,0x7f,0xf8 },
                     { 0x1c,0x7f,0xff },
                     { 0x1f,0x80,0x00 },
                     { 0x1f,0x80,0x07 },
                     { 0x1f,0x80,0x38 },
                     { 0x1f,0x80,0x3f },
                     { 0x1f,0x81,0xc0 },
                     { 0x1f,0x81,0xc7 },
                     { 0x1f,0x81,0xf8 },
                     { 0x1f,0x81,0xff },
                     { 0x1f,0x8e,0x00 },
                     { 0x1f,0x8e,0x07 },
                     { 0x1f,0x8e,0x38 },
                     { 0x1f,0x8e,0x3f },
                     { 0x1f,0x8f,0xc0 },
                     { 0x1f,0x8f,0xc7 },
                     { 0x1f,0x8f,0xf8 },
                     { 0x1f,0x8f,0xff },
                     { 0x1f,0xf0,0x00 },
                     { 0x1f,0xf0,0x07 },
                     { 0x1f,0xf0,0x38 },
                     { 0x1f,0xf0,0x3f },
                     { 0x1f,0xf1,0xc0 },
                     { 0x1f,0xf1,0xc7 },
                     { 0x1f,0xf1,0xf8 },
                     { 0x1f,0xf1,0xff },
                     { 0x1f,0xfe,0x00 },
                     { 0x1f,0xfe,0x07 },
                     { 0x1f,0xfe,0x38 },
                     { 0x1f,0xfe,0x3f },
                     { 0x1f,0xff,0xc0 },
                     { 0x1f,0xff,0xc7 },
                     { 0x1f,0xff,0xf8 },
                     { 0x1f,0xff,0xff },
                     { 0xe0,0x00,0x00 },
                     { 0xe0,0x00,0x07 },
                     { 0xe0,0x00,0x38 },
                     { 0xe0,0x00,0x3f },
                     { 0xe0,0x01,0xc0 },
                     { 0xe0,0x01,0xc7 },
                     { 0xe0,0x01,0xf8 },
                     { 0xe0,0x01,0xff },
                     { 0xe0,0x0e,0x00 },
                     { 0x00,0x0e,0x07 },
                     { 0xe0,0x0e,0x38 },
                     { 0xe0,0x0e,0x3f },
                     { 0xe0,0x0f,0xc0 },
                     { 0xe0,0x0f,0xc7 },
                     { 0xe0,0x0f,0xf8 },
                     { 0xe0,0x0f,0xff },
                     { 0xe0,0x70,0x00 },
                     { 0xe0,0x70,0x07 },
                     { 0xe0,0x70,0x38 },
                     { 0xe0,0x70,0x3f },
                     { 0xe0,0x71,0xc0 },
                     { 0xe0,0x71,0xc7 },
                     { 0xe0,0x71,0xf8 },
                     { 0xe0,0x71,0xff },
                     { 0xe0,0x7e,0x00 },
                     { 0xe0,0x7e,0x07 },
                     { 0xe0,0x7e,0x38 },
                     { 0xe0,0x7e,0x3f },
                     { 0xe0,0x7f,0xc0 },
                     { 0xe0,0x7f,0xc7 },
                     { 0xe0,0x7f,0xf8 },
                     { 0xe0,0x7f,0xff },
                     { 0xe3,0x80,0x00 },
                     { 0xe3,0x80,0x07 },
                     { 0xe3,0x80,0x38 },
                     { 0xe3,0x80,0x3f },
                     { 0xe3,0x81,0xc0 },
                     { 0xe3,0x81,0xc7 },
                     { 0xe3,0x81,0xf8 },
                     { 0xe3,0x81,0xff },
                     { 0xe3,0x8e,0x00 },
                     { 0xe3,0x8e,0x07 },
                     { 0xe3,0x8e,0x38 },
                     { 0xe3,0x8e,0x3f },
                     { 0xe3,0x8f,0xc0 },
                     { 0xe3,0x8f,0xc7 },
                     { 0xe3,0x8f,0xf8 },
                     { 0xe3,0x8f,0xff },
                     { 0xe3,0xf0,0x00 },
                     { 0xe3,0xf0,0x07 },
                     { 0xe3,0xf0,0x38 },
                     { 0xe3,0xf0,0x3f },
                     { 0xe3,0xf1,0xc0 },
                     { 0xe3,0xf1,0xc7 },
                     { 0xe3,0xf1,0xf8 },
                     { 0xe3,0xf1,0xff },
                     { 0xe3,0xfe,0x00 },
                     { 0xe3,0xfe,0x07 },
                     { 0xe3,0xfe,0x38 },
                     { 0xe3,0xfe,0x3f },
                     { 0xe3,0xff,0xc0 },
                     { 0xe3,0xff,0xc7 },
                     { 0xe3,0xff,0xf8 },
                     { 0xe3,0xff,0xff },
                     { 0xfc,0x00,0x00 },
                     { 0xfc,0x00,0x07 },
                     { 0xfc,0x00,0x38 },
                     { 0xfc,0x00,0x3f },
                     { 0xfc,0x01,0xc0 },
                     { 0xfc,0x01,0xc7 },
                     { 0xfc,0x01,0xf8 },
                     { 0xfc,0x01,0xff },
                     { 0xfc,0x0e,0x00 },
                     { 0xfc,0x0e,0x07 },
                     { 0xfc,0x0e,0x38 },
                     { 0xfc,0x0e,0x3f },
                     { 0xfc,0x0f,0xc0 },
                     { 0xfc,0x0f,0xc7 },
                     { 0xfc,0x0f,0xf8 },
                     { 0xfc,0x0f,0xff },
                     { 0xfc,0x70,0x00 },
                     { 0xfc,0x70,0x07 },
                     { 0xfc,0x70,0x38 },
                     { 0xfc,0x70,0x3f },
                     { 0xfc,0x71,0xc0 },
                     { 0xfc,0x71,0xc7 },
                     { 0xfc,0x71,0xf8 },
                     { 0xfc,0x71,0xff },
                     { 0xfc,0x7e,0x00 },
                     { 0xfc,0x7e,0x07 },
                     { 0xfc,0x7e,0x38 },
                     { 0xfc,0x7e,0x3f },
                     { 0xfc,0x7f,0xc0 },
                     { 0xfc,0x7f,0xc7 },
                     { 0xfc,0x7f,0xf8 },
                     { 0xfc,0x7f,0xff },
                     { 0xff,0x80,0x00 },
                     { 0xff,0x80,0x07 },
                     { 0xff,0x80,0x38 },
                     { 0xff,0x80,0x3f },
                     { 0xff,0x81,0xc0 },
                     { 0xff,0x81,0xc7 },
                     { 0xff,0x81,0xf8 },
                     { 0xff,0x81,0xff },
                     { 0xff,0x8e,0x00 },
                     { 0xff,0x8e,0x07 },
                     { 0xff,0x8e,0x38 },
                     { 0xff,0x8e,0x3f },
                     { 0xff,0x8f,0xc0 },
                     { 0xff,0x8f,0xc7 },
                     { 0xff,0x8f,0xf8 },
                     { 0xff,0x8f,0xff },
                     { 0xff,0xf0,0x00 },
                     { 0xff,0xf0,0x07 },
                     { 0xff,0xf0,0x38 },
                     { 0xff,0xf0,0x3f },
                     { 0xff,0xf1,0xc0 },
                     { 0xff,0xf1,0xc7 },
                     { 0xff,0xf1,0xf8 },
                     { 0xff,0xf1,0xff },
                     { 0xff,0xfe,0x00 },
                     { 0xff,0xfe,0x07 },
                     { 0xff,0xfe,0x38 },
                     { 0xff,0xfe,0x3f },
                     { 0xff,0xff,0xc0 },
                     { 0xff,0xff,0xc7 },
                     { 0xff,0xff,0xf8 },
                     { 0xff,0xff,0xff }  };

