/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1992 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 source code is provided to you solely for       */
/*    the purpose of assisting you in your development of OS/2 device        */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Developer Connection Device Driver       */
/*    Source Kit for OS/2. This Copyright statement may not be removed.      */
/*                                                                           */
/*****************************************************************************/
/**************************************************************************
 *                            Lexmark Confidential
 *
 * SOURCE FILE NAME = PRDDCT
 *
 * DESCRIPTIVE NAME = Printer Device Driver DC types
 *
 *
 * VERSION
 *
 * DATE
 *
 * DESCRIPTION
 *
 * FUNCTIONS
 *
 * ENTRY POINTS:
 *
 * DEPENDENCIES:
 *
 * NOTES
 *
 *
 * STRUCTURES
 *
 * EXTERNAL REFERENCES
 *
 * EXTERNAL FUNCTIONS
 *
*/

/******************************************************************************/
/*  Type definitions for the heap list.  The DC starts off with a single heap.*/
/*  If this runs out then a new one is created and then used.  This may       */
/*  continue until a request for a new heap fails.                            */
/*                                                                            */
/*  To save having to scan the heap list every time a new item is required,   */
/*  the heap handle of the latest heap is saved in the instance data          */
/*  (DCICurrHHeap).                                                           */
/******************************************************************************/

typedef struct HeapListEntry
    {
/*      HHEAP                      HeapHandle;   CON3201 */
/*      USHORT                     HeapSel;      CON3201 */
        PBYTE                 pbHLEHeap;
        USHORT                HLEPadding1;
        struct HeapListEntry * Next;
    } HeapListType;

typedef struct dci
    {
        struct dci *DCISelfRef;    /* Self-reference for integrity        */
        struct dci *DCINextEntry;  /* Next instance                       */
        USHORT          DCIDCType;     /* DC type 0 -> 8                      */
        USHORT          DCIPadding1;
        PBYTE           DCISelBitmap;  /* Selected Bitmap                     */
        lpPDBI          DCIPdbInstance;/* PDB Instance Data                   */
        ULONG           DCIStateFlags; /* e.g. mode 2 simulation in force     */

        FontDataType    DCIFontData;   /* Font data for currently selected    */
                                       /* font                                */

        HeapListType    DCIHeapList;   /* the list of DC heaps                */
        PBYTE           DCICurrHeap;   /* the heap currently in use           */
        USHORT          DCIPadding3;   /* pad to account for DCICurrHeapSel   */
// CON3201         HHEAP           DCICurrHHeap;   /* the heap currently in use           */
// CON3201         USHORT          DCICurrHeapSel;/* the heap currently in use           */

        WcsPoint        DCICurrPosWcs; /* current position - World            */
        DevPoint        DCICurrPosDev; /* current position - Device           */
        POINTS          DCICurrPosFont;/* current position - Font             */
        DevPoint        DCIPattOriDev; /* pattern origin - Device             */

        PDCHARBUNDLE    DCICurTxtAts;  /* Current Text Attrs Bundle           */
        PDLINEBUNDLE    DCICurLinAts;  /* Current Line Attrs Bundle           */
        PDAREABUNDLE    DCICurPtnAts;  /* Current Pattern Attrs Bundle        */
        PDIMAGEBUNDLE   DCICurImgAts;  /* Current Image Attrs Bundle          */
        PDMARKERBUNDLE  DCICurMrkAts;  /* Current Marker Attrs Bundle         */
        PDCHARBUNDLE    DCIDefTxtAts;

        enum BandState  DCIBandState;  /* State of Band processing            */
        BandType        DCICurrBand;   /* Current Band                        */
        USHORT          DCIBandLowY;   /* Lowest Y Coord from Bands           */
        USHORT          DCIJournLowY;  /* Lowest Y Coord in Journal           */
        ULONG           DCIJournHandle;/* Handle for Journal                  */
        CHAR            DCIJrnName[12];/* Journal name XXXXXXXX.XXX           */
        USHORT          DCIDosJrnHnd;  /* Jrn handle for Dos writes           */
        ULONG           DCISplHandle;  /* handle to spool file                */

        lpColorTable    DCIColorTable; /* color table                         */
        USHORT          DCIColTabSize; /* color table size                    */
        USHORT          DCIColFormat;  /* format of color table               */
        USHORT          DCILowIndex;   /* lowest index in table               */
        USHORT          DCIHighIndex;  /* highest index in table              */
        ULONG           DCIColOptions; /* Options from GRE call               */
                                       /* PD00769 : Storage for 1 rectangle   */
        FillPathRectangle DCIFillPathRect;
        lpClipRectangle DCIClipRects;  /* Clip Rectangles                     */
        USHORT          DCIClipNum;    /* Number of Clip Rectangles           */
        USHORT          DCIClipSize;   /* Number of Clip Rectangles that      */
                                       /* storage has been allocated for      */
        USHORT          DCIClipIndex;  /* Maintains clip cache starting point */
        BOOL            DCIClipsValid; /* PD00305 : Clip Cache status         */
        USHORT          DCIClipsInCache;

        ULONG           StyleNumber;   /* line style state & mask             */
        USHORT          DCILineTypMask;/* Mask used for line types            */
        USHORT          DCIStyleRatio; /* Style Ratio                         */

        PULONG          DCIDocName;    /* DC document name pointer            */
        USHORT          DCIPrintInfo;  /* printing info for print band        */
        BOOL            DCIStartedDoc; /* TRUE if a doc is started            */
        LONG            DCISaveCount;  /* number of saved DC states           */

        USHORT          DCICodePage;   /* currently selected codepage         */
        USHORT          DCIPadding2;   /* expansion                           */

        WcsRect         DCIBounds;     /* currently accumulated bounds        */

        ULONG           ProcessID;     /* current process ID                  */
/*      USHORT          CommandMask;*/ /* mask to stop drawing on DCs         */
        ULONG           CommandMask;   /* CON3201 - Changed Command mask      */
                                       /* to be compatible with COM_* flags   */
        DevPoint        DCIOrigin;     /* current DC origin                   */

        lpDownFlagType  DCIDownFontFlags; /* download font used flags         */
        USHORT          DCINoOfDownFonts;

        lpDownFlagType  DCIDownCpFlags;/* download Codepage used flags        */

        BandType        NextBand;      /* band used by NextBand               */

        enum ParserStateType    ParserState;
        USHORT                  ParserCount;
        struct EscapeSequence * ParserSequence;
        CHAR *                  ParserString;
        CHAR                    ParserDelimiter;
        enum FFstateType        FFstate;

        hanDC           DcH;

        LockDCInfoStruct  LockDCInfo;  /* pid & tid of thread in DC           */
/* CON3201
**        PLINFOSEG       LIS;              pointer to local info seg
*/
        PTIB            ptibDCI;
        PPIB            ppibDCI;        /* pointer to local info seg           */

        BYTE            TextOnlyDC;    /* flag for text only DC - used to     */
                                       /* optimize printing                   */

        USHORT          DCICardCount;  /* Number of cards used for DC         */
        USHORT          DCICardIndx[MAX_NO_OF_CARD_SLOTS];
                                       /* Indexes of used cards               */

        ULONG           DCIPageNumber; /* starting from 1                     */
        ULONG           Flags;         /* General state flags                 */
        USHORT          State;         /* holds framework FSM state           */
        USHORT          JobId;         /* returned by EndDoc                  */
        PVOID           DCIEDFList;    /* Pointer to linked list of download  */
                                       /* engine fonts                        */
        USHORT          Profile;       /* returned by EndDoc                  */
        XFORM           DCITransform;  /* transform matrix            PD00073 */
        USHORT          DCITransformFlags;  /* transform matrix flags PD00073 */
        BOOL            FirstBand;     /* flag for banding            PD00473 */
        USHORT          BandCount;     /* PD00520: indicates which band is    */
                                       /* being processed                     */
        PBYTE           lpPD;          /* pattern data memory         PD00474 */
        USHORT          usPatValid;    /* pattern data memory valid   PD00474 */
        SHORT           Remainder;     /* error accumulation          PD00547 */
        ULONG           Reserved[3];   /* NB there are two padding words      */
    } DCIType;

typedef DCIType *lpDCI;

typedef struct DcType
    {
        ULONG           DCReserved;    /* Reserved dword                      */
        lpDCI           DCMagicNo;     /* Magic number->instance data         */
        PBYTE           DCldb;         /* Logical device block                */
    } DCType;

typedef DCType *lpDC;
