/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1992 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 source code is provided to you solely for       */
/*    the purpose of assisting you in your development of OS/2 device        */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Developer Connection Device Driver       */
/*    Source Kit for OS/2. This Copyright statement may not be removed.      */
/*                                                                           */
/*****************************************************************************/
/**************************************************************************
 *                            Lexmark Confidential
 *
 * SOURCE FILE NAME = PRDCOMPD
 *
 * DESCRIPTIVE NAME = Printer Device Driver Table Macros and Constants
 *
 *
 * VERSION
 *
 * DATE
 *
 * DESCRIPTION
 *
 * FUNCTIONS
 *
 * ENTRY POINTS:
 *
 * DEPENDENCIES:
 *
 * NOTES
 *
 *
 * STRUCTURES
 *
 * EXTERNAL REFERENCES
 *
 * EXTERNAL FUNCTIONS
 *
*/

/**********************************************************************/
/* List of Macros used in the code:                                   */
/*                                                                    */
/*   MULT_BITMAP_FORMATS    0   Set on this allows color printer      */
/*                              to create (1,1) as well as (4,1)      */
/*                              bitmaps.                              */
/*                                                                    */
/*   OMIT_OLD_CODE          0                                         */
/*                                                                    */
/*   OMIT_FOR_WORK_AROUND   0                                         */
/*                                                                    */
/*   PORT_SEMAPHORE         0   Set on this causes the driver to      */
/*                              use semaphores for accesing ports     */
/*                              LPT1-3 and COM1-3.  Note that there   */
/*                              is no semaphore support for LPT4-9    */
/*                              and COM4-9.                           */
/*                                                                    */
/*   DDT_KERNING_ENABLED    1   Set on this hooks and handles the     */
/*                              GetKerningPairTable function.         */
/*                              PD00075 : enable kerning to prevent   */
/*                              trap in the GRE GetKPTable function.  */
/*                                                                    */
/*   DDT_FORM_TEMPLATES     0   Set on this forces the use of a       */
/*                              pre-defined form as the template in   */
/*                              the Add Form dialog box - i.e added   */
/*                              forms cannot be used as a template.   */
/*                                                                    */
/*   DDT_NO_PRINT_MARGIN    0   Set on this uses the bottom-left      */
/*                              corner of the physical paper as the   */
/*                              origin for SCP commands rather than   */
/*                              the bottom-left corner of the         */
/*                              printable area (applies to 4019       */
/*                              printers only).                       */
/*                                                                    */
/*   DDT_BANDING            1   Set on for code to support            */
/*                              multiple bands per page.              */
/*                                                                    */
/*                                                                    */
/*   PRD_DEBUG              |   Debugging tools .. values set in      */
/*   PRD_TRACE              |   MAK file.                             */
/*   INIT_TEST_TYPE         |                                         */
/*                                                                    */
/*   SHEAR_ADDED            1   Do shearing for 4029 outline fonts    */
/*                                                                    */
/*                                                                    */
/**********************************************************************/
#define DDT_BANDING

#define DDT_KERNING_ENABLED

#define SHEAR_ADDED
