/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1992 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 source code is provided to you solely for       */
/*    the purpose of assisting you in your development of OS/2 device        */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Developer Connection Device Driver       */
/*    Source Kit for OS/2. This Copyright statement may not be removed.      */
/*                                                                           */
/*****************************************************************************/
/**************************************************************************
 *                            Lexmark Confidential
 *
 * SOURCE FILE NAME = PRDAEXTF
 *
 * DESCRIPTIVE NAME = Printer Device Driver external files for
 *                    Attributes routines
 *
 *
 * VERSION
 *
 * DATE
 *
 * DESCRIPTION
 *
 * FUNCTIONS
 *
 * ENTRY POINTS:
 *
 * DEPENDENCIES:
 *
 * NOTES
 *
 *
 * STRUCTURES
 *
 * EXTERNAL REFERENCES
 *
 * EXTERNAL FUNCTIONS
 *
*/

/******************************************************************************/
/*  Hooked functions...                                                       */
/******************************************************************************/

typedef PFONTMETRICS * PPFONTMETRICS;         /* CON3201 */

ULONG EXPENTRY prda_DeviceSetAttributes(
            HDC,
            ULONG,
            ULONG,
            ULONG,
            PBUNDLE,
            lpDCI,
            ULONG);

ULONG EXPENTRY prda_DeviceGetAttributes(
            HDC,
            ULONG,
            ULONG,
            PBUNDLE,
            lpDCI,
            ULONG);

ULONG EXPENTRY prda_DeviceSetGlobalAttribute(
            HDC,
            ULONG,
            ULONG,
            ULONG,
            lpDCI,
            ULONG);

ULONG EXPENTRY prda_DeviceQueryFontAttributes(
            HDC,
            ULONG,
            PFONTMETRICS,
            lpDCI,
            ULONG);

ULONG EXPENTRY prda_DeviceQueryFonts(
            HDC,
            ULONG,
            PSZ,
            PFONTMETRICS,
            ULONG,
            PULONG,
            lpDCI,
            ULONG);

ULONG EXPENTRY prda_RealizeFont(
            HDC,
            ULONG,
            PFATTRS,
            ULONG,
            lpDCI,
            ULONG);

ULONG EXPENTRY prda_SetCodePage(
            HDC,
            ULONG,
            lpDCI,
            ULONG);

ULONG EXPENTRY prda_GetCodePage(
            HDC,
            lpDCI,
            ULONG);

#ifdef DDT_KERNING_ENABLED
ULONG EXPENTRY prda_GetKerningPairTable(
            HDC,
            ULONG,
            lpKerningPair,
            lpDCI,
            ULONG);
#endif

/******************************************************************************/
/*  Internal functions...                                                     */
/******************************************************************************/
USHORT prda_SetTextAttrs(
            HDC,
            USHORT,
            USHORT,
            PDCHARBUNDLE,
            PDCHARBUNDLE,
            lpDCI);

VOID  prda_SetLineAttrs(
            USHORT,
            USHORT,
            PDLINEBUNDLE,
            PDLINEBUNDLE,
            lpDCI);

VOID prda_SetMarkAttrs(
            USHORT,
            USHORT,
            PDMARKERBUNDLE,
            PDMARKERBUNDLE);

VOID prda_SetPtrnAttrs(
            USHORT,
            USHORT,
            PDAREABUNDLE,
            PDAREABUNDLE);

VOID prda_SetImagAttrs(
            USHORT,
            USHORT,
            PDIMAGEBUNDLE,
            PDIMAGEBUNDLE);

BOOL prda_CheckFontValid(
            PCHARDEFS,
            lpDCI);

VOID prda_SetTextSimlFlag(
            lpDCI);

ULONG prda_GetDfltCharBox(
            HDC,
            USHORT,
            USHORT,
            lpDCI);

USHORT prda_CopyMetrics(
            HDC,
            ULONG,
            PFONTMETRICS,
            ULONG,
            lpFMFFileStruc,
            lpDCI,
            LCIDType,
            ULONG);

VOID prda_AdjustFaceName(
            PBYTE,
            LCIDType,
            lpPDBI);

VOID prda_AdjustFaceName2(
            PBYTE,
            FontInfoType,
            lpPDBI);                           /*   PD00465    */

VOID prda_AdjustForCharBox(
            PFONTMETRICS,
            lpDCI,
            USHORT);                           /*   PD00137    */

USHORT xform_metrics(
            HDC,
            PFONTMETRICS,
            PXFORM);

LONG prda_MatchFont(
            PFATTRS,
            lpDCI);

USHORT prda_AlterCodePage(
            USHORT,
            lpDCI);

USHORT prda_MatchExactCodePage(
            USHORT,
            lpDCI,
            lpDfltFontInfoType);

BOOL prda_CheckMetrics(
            PFOCAMETRICS,
            PFOCAMETRICS,
            PBYTE,
            PBYTE,
            USHORT,
            lpPrtDataEntry);                       /* PD00721                 */

USHORT prda_FindDeviceCodePage(
            USHORT,
            lpDCI,
            lpDfltFontInfoType);

BOOL prda_MultiCodePageSupported(
            USHORT,
            lpMultiCpType);

USHORT prda_ProcessAttributes(
            HDC,
            PSZ,
            PPFONTMETRICS,
/*          PVOID,            CON3201  */
            ULONG,
            PULONG,
            lpDCI,
            ULONG,
            lpFMFFileStruc,
            LCIDType,
            USHORT,
            PSHORT,
            PUSHORT,
            PULONG);

BOOL prda_MatchFaceNames(
            lpDCI,
            lpFMFFileStruc,
            PSZ,
            USHORT,
            LCIDType);

VOID prda_ReturnMetrics(
            PFONTMETRICS,
            PPFONTMETRICS,
/*          PVOID,             CON3201   */
            ULONG,
            PULONG);

ULONG prda_RealizeDeviceFont(
            PFATTRS,
            lpDCI);

ULONG prda_MatchBaseFont(
            PFATTRS,
            lpDCI);

ULONG prda_DefaultFontSwitch(
            LCIDType,
            PFATTRS,
            lpDCI);

ULONG prda_MatchFattrStructure(
            PFATTRS,
            lpDCI);

ULONG prda_MatchEngineAttributes(
            lpDCI,
            LCIDType);

USHORT prda_InfoFromMatchNumber(
            LCIDType,
            lpDCI,
            lpFMFFileStruc *,
            lpMultiCpType *,
            PBYTE,
            lpEngAttrsType *);

ULONG prda_ChangeMatchNumber(
            USHORT,
            LCIDType,
            lpFMFFileStruc,
            lpDCI);

ULONG prda_MatchMetrics(
            BYTE,
            PFATTRS,
            LCIDType,
            lpFMFFileStruc,
            lpMultiCpType,
            lpDCI);

USHORT prda_GetCPIndexFromCodePage(
            USHORT);

USHORT prda_CodePageType(
            USHORT);

VOID prda_GetNewMatchNumber (
            USHORT,
            USHORT,
            USHORT,
            PFATTRS,
            USHORT,
            lpDCI);

VOID prda_ConvertOld42XXMatch (
            PFATTRS,
            lpDCI);

VOID prda_ConvertOld52XXMatch (
            PFATTRS,
            lpDCI);

VOID prda_ConvertOld4019Match (
            PFATTRS);
