.****************************************************************************/
.*  Copyright (C) 1993-95 IBM Corporation                                   */
.****************************************************************************/
.****************************************************************************/
.* FILE         : OMNI.IPF                                                  */
.* AUTHOR       : Matt Rutkowski                                            */
.* DATE WRITTEN : 06/29/94                                                  */
.* DESCRIPTION  : Help panels for Omni Printer Driver                       */
.*                                                                          */
.*--------------------------------------------------------------------------*/
.* Modification/Change log                                                  */
.*--------------------------------------------------------------------------*/
.* TAG - DATE - [COMPANY] - AUTHOR - DESCRIPTION                            */
.*--------------------------------------------------------------------------*/
.* 07/05/95 - MFR [IBM] - Revised for new "common" Job and Printer Prop     */
.*                        dialogs our department agreed upon. Also, added   */
.*                        help for new HSV notebook page.                   */
.* @COLLATE- 05/20/99 - Arseny Dorosevich - collate and uncollate printing  */
.*                                          support                         */
.*                                                                          */
.****************************************************************************/
:userdoc.
.*
.*==========================================================================*/
.*==========================================================================*/
.* Omni Printer Property Main Help                                          */
.*==========================================================================*/
.*==========================================================================*/
.*

.im ..\drvmri\omnibook.itl
.im ..\drvmri\gplweb.itl

:h1 res=15010 name=PANEL_PRINTER_PROPERTIES.Printer Properties
:i1 id=PrnProp.Printer Properties
:font facename=Helv size=20x12.
:color fc=black.
:p.:hp2.Printer Properties:ehp2.
:color fc=default.
:font facename=default size=0x0.
.*
:p.The Printer Properties dialog contains a notebook of settings
that describe your printer and its capabilities.
.*
:p.Printer Properties are different
from :link reftype=hd res=16000.Job Properties:elink. which
are more commonly modified for print jobs&per.
.*
:p.Click on one of the following page names to get detailed
information about settings available on that page&colon.
:ul compact.
:li. :link reftype=hd res=15015.Connections:elink.
:li. :link reftype=hd res=15016.Trays:elink.
:li. :link reftype=hd res=15017.Paper Sizes:elink.
:li. :link reftype=hd res=15018.Maintenance:elink.
:li. :link reftype=hd res=34000.Web:elink.
:eul.
.*
:p.The Printer Properties dialog also contains buttons. Click on
the name of a button to find out what it does&per.
:ul compact.
:li. :link reftype=hd res=15011.Save:elink.
:li. :link reftype=hd res=15012.Cancel:elink.
:li. :link reftype=hd res=15013.Default Job Properties:elink.
:li. :link reftype=hd res=15014.Help:elink.
:eul.
.*
:nt.Some notebook pages will not appear on printer models
that do not support any features from that page&per.
.*
:p.All Printer Properties notebook settings are initially set to
show the base characteristics of the printer as shipped from
the manufacturer&per.
.*
:p.Users typically only use Printer Properties when they have
physically added things to their printer (e.g. additional memory,
paper trays, paper sizes, etc&per.)&per.
.*
:p.It is important to keep Printer Property information as
accurate as possible to ensure the printer driver creates the
fastest, highest quality printouts&per.
:ent.
.*
:p.:hp7.Warning!:ehp7. Users should be aware that changing Printer
Properties from one Print Queue (or application) changes them for
all other Print Queues&per.
:p.This is because each physical printer only needs one set of
Printer Properties to describe it&per.  Although, you can access the
same set of Printer Properties for that printer from :hp1.any:ehp1. Print
Queue where you see it&per.
.*
:nt.The Omni Printer Driver is a 32-bit :link reftype=hd res=18000.IBM:elink.
:link reftype=hd res=18000. OS/2:elink. Printer Driver requiring
:color fc=red.OS/2 Warp:color fc=default. or greater to run&per.
:ent.
.*
.*==========================================================================*/
.* Printer Properties "Save" button                                         */
.*==========================================================================*/
:h2 res=15011 name=PANEL_PP_SAVE.Save
:i2 refid=PrnProp.Save button
:font facename=Helv size=16x9.
:color fc=black.
:p.:hp7.Save:ehp7.
:color fc=default.
:font facename=default size=0x0.
.*
:p.Pressing the Save button causes the Printer Properties dialog
to close and all changes made to Printer Properties notebook pages are
saved&per.
.*
:p.The printer driver will now use these newly saved Printer Properties
whenever printing to this particular printer&per.
.*
:p."Saving" changes the Printer Properties for all Print Queues on the
desktop that reference that same printer&per.
.*
:note.If you do not wish to save or alter the current set of Printer Properties,
but just want to close the Printer Properties dialog, simply press
the :link reftype=hd res=15012.Cancel:elink. button instead&per.
.*
.*==========================================================================*/
.* Printer Properties "Cancel" button                                       */
.*==========================================================================*/
:h2 res=15012 name=PANEL_PP_CANCEL.Cancel
:i2 refid=PrnProp.Cancel button
:font facename=Helv size=16x9.
:color fc=black.
:p.:hp7.Cancel:ehp7.
:color fc=default.
:font facename=default size=0x0.
.*
:p.Pressing the Cancel button causes the Printer Properties dialog
to close&per. Any changes made to Printer Properties notebook pages are
ignored by the calling application&per.
.*
:p.The printer driver for that printer will still use the Printer Properties
shown before any changes were made&per.
.*
:nt.If you do want to save or alter the current set of Printer Properties,
simply press the :link reftype=hd res=15011.Save:elink. button instead&per.
:ent.
.*
.*==========================================================================*/
.* Printer Properties "Default Job Properties" button                       */
.*==========================================================================*/
:h2 res=15013 name=PANEL_PP_DEV_DEF.Default Job Properties
:i2 refid=PrnProp.Default Job Properties
:font facename=Helv size=16x9.
:color fc=black.
:p.:hp7.Default Job Properties:ehp7.
:color fc=default.
:font facename=default size=0x0.
.*
:p.Pressing the Default Job Properties button brings up
the :link reftype=hd res=16000.Job Properties:elink. notebook&per.
.*
:p.This is where you can set a unique set of Job Properties to
apply to print jobs submitted that do not have any&per.
.*
:nt.These Job Properties are rarely used since most applications
supply them or the OS/2 spooler supplies them from Job Properties
for the print queue&per.
.*
:p.This button may be phased-out in the future since there are so
few cases where these Job Properties are used&per.
.*
:p.However, if you can not seem to get Job Properties to work
when printing from your application these may be the correct
ones to modify&per.
:ent.
.*
.*==========================================================================*/
.* Printer Properties "Help" button                                         */
.*==========================================================================*/
:h2 res=15014 name=PANEL_PP_HELP.Help
:i2 refid=PrnProp.Help button
:font facename=Helv size=16x9.
:color fc=black.
:p.:hp7.Help:ehp7.
:color fc=default.
:font facename=default size=0x0.
.*
:p.Pressing the Help button brings up this help window and shows the
main help for the Printer Properties dialog&per.
.*
:p.Once in the main help dialog, you can access help topics
for any specific printer property shown anywhere in the Printer
Properties notebook&per.
.*
.*==========================================================================*/
.* Form Connection Notebook Page                                            */
.*==========================================================================*/
.*
:h1 res=15015 name=PANEL_CONNECTIONS.Connections Page
:i1 id=connect.Connections Page
.*
:font facename=Helv size=18x10.
:color fc=black.
:p.:hp7.Connections Page:ehp7.
:color fc=default.
:font facename=default size=0x0.
.*
:p.This page is used to manage Form Connections for your printer&per.
.*
:p.A :hp2.Form Connection:ehp2. is a combination of a Tray, a Paper Size,
and a Media Type&per.
.*
:p.Some devices allow you to add and delete Form Connections&per.
When this feature is available, the "Add" and "Delete" buttons
will be enabled.  See below for instructions&per.
.*
.*
:font facename=Helv size=16x9.
:color fc=black.
:p.:hp2.This page contains the following printer properties&colon.:ehp2.
:color fc=default.
:font facename=default size=0x0.
.*
:ul compact.
:li. :link reftype=hd res=15020.Defined Form Connections:elink.
:li. :link reftype=hd res=15021.Current Attributes:elink.
:ul compact.
:li. :link reftype=hd res=15022.Trays:elink.
:li. :link reftype=hd res=15023.Paper Sizes:elink.
:li. :link reftype=hd res=15024.Media Types:elink.
:eul.
:eul.
.*
:font facename=Helv size=15x8.
:color fc=black.
:p.:hp2.This page contains the following buttons&colon.:ehp2.
:color fc=default.
:font facename=default size=0x0.
.*
:ul compact.
:li. :link reftype=hd res=15025.Add:elink.
:li. :link reftype=hd res=15026.Delete:elink.
:eul.
.*
:note.The Add, Delete, and Modify buttons will be available only if the
printer supports user-defined Form Connections&per.
.*
:font facename=Helv size=16x9.
:color fc=black.
:p.:hp2.Adding a New Form Connection&colon.:ehp2.
:color fc=default.
:font facename=default size=0x0.
.*
:p.Simply select a Tray, Paper Size and Media Type from the lists within the
"Current Attributes" area and press the "Add" button&per.
.*
:p.A new connection with the attributes you selected is added to the
"Defined Form Connections" list and can now be selected from Job Properties&per.
.*
:font facename=Helv size=16x9.
:color fc=black.
:p.:hp2.Deleting a New Form Connection&colon.:ehp2.
:color fc=default.
:font facename=default size=0x0.
.*
:p.Simply select a Form Connection from the "Defined Form Connections"
list and press the "Delete" button&per.
.*
:p.That Form Connection will be removed from the list and no longer
displayed in Job Properties&per.
.*
:font facename=Helv size=15x8.
:color fc=black.
:p.:hp2.Form Connection Usages&colon.:ehp2.
:color fc=default.
:font facename=default size=0x0.
.*
:p.The printer driver uses Form Connection information to determine
whether or not to allow a print job to be printed&per.  If you print
to a paper size that does not have a Form Connection you will get a
"Forms Mismatch" error&per.
.*
:nt.For a more detailed example of a Form Connection's usages
see :link reftype=hd res=16010.Form Connections:elink.&per.
:ent.
.*
.*==========================================================================*/
.* Printer Properties: Connections: Defined Form Connections                */
.*==========================================================================*/
:h2 res=15020 name=PANEL_PP_CONNECT_DEFINED.Defined Form Connections
:i2 refid=connect.Defined Form Connections
:font facename=Helv size=16x9.
.*
:color fc=black.
:p.:hp7.Defined Form Connections:ehp7.
:color fc=default.
:font facename=default size=0x0.
.*
:p.This pulldown list allows you to view and select all Form
Connections currently defined for your printer&per.
.*
:p.When a Form Connection is selected, its component parts (Tray,
Paper Size, and Media Type) are shown in the "Current Attributes"
area&per.
.*
:p.The type of connection, either "built-in" or "user-defined" will
also be displayed&per.
.*
:nt.See :link reftype=hd res=16010.Form Connections:elink. for a detailed
description of what a "Form Connection" is&per.
:ent.
.*
.*==========================================================================*/
.* Printer Properties: Connections: Current Attributes                      */
.*==========================================================================*/
.*
:h2 res=15021 name=PANEL_PP_CONNECT_ATTRS.Current Attributes
:i2 refid=connect.Current Attributes
:font facename=Helv size=16x9.
.*
:color fc=black.
:p.:hp7.Current Attributes:ehp7.
:color fc=default.
:font facename=default size=0x0.
.*
:p.This group contains settings that show the component parts
and attributes of the currently selected "Defined Form Connection"&per.
.*
:ul compact.
:li. :link reftype=hd res=15022.Trays:elink.
:li. :link reftype=hd res=15023.Paper Sizes:elink.
:li. :link reftype=hd res=15024.Media Types:elink.
:eul.
.*
:p.In addition, the type of connection, either "built-in" or
"user-defined" will also be displayed in the attribute area&per.
.*
.*==========================================================================*/
.* Printer Properties: Connections: Trays                                   */
.*==========================================================================*/
.*
:h2 res=15022 name=PANEL_PP_CONNECT_TRAYS.Trays
:i2 refid=connect.Trays
:font facename=Helv size=16x9.
.*
:color fc=black.
:p.:hp7.Trays:ehp7.
:color fc=default.
:font facename=default size=0x0.
.*
:p.This list contains all the trays that have been defined for
your printer&per.
.*
:p.To view detailed information on these trays, or to add,
delete, or modify trays for your printer see
the :link reftype=hd res=15016.Trays:elink. page
in the Printer Properties notebook&per.
.*
.*==========================================================================*/
.* Printer Properties: Connections: Sizes                                   */
.*==========================================================================*/
.*
:h2 res=15023 name=PANEL_PP_CONNECT_SIZES.Paper Sizes
:i2 refid=connect.Paper Sizes
:font facename=Helv size=16x9.
.*
:color fc=black.
:p.:hp7.Paper Sizes:ehp7.
:color fc=default.
:font facename=default size=0x0.
.*
:p.This list contains all the Paper Sizes that have been defined for
your printer&per.
.*
:p.To view detailed information on these paper sizes, or to add,
delete, or modify paper sizes for your printer see
the :link reftype=hd res=15017.Paper Sizes:elink. page
in the Printer Properties notebook&per.
.*
.*==========================================================================*/
.* Printer Properties: Connections: Medias                                  */
.*==========================================================================*/
.*
:h2 res=15024 name=PANEL_PP_CONNECT_MEDIAS.Media Types
:i2 refid=connect.Media Types
:font facename=Helv size=16x9.
.*
:color fc=black.
:p.:hp7.Media Types:ehp7.
:color fc=default.
:font facename=default size=0x0.
.*
:p.This list contains all the Media types that have been defined for
your printer&per.
.*
:p.Selecting the correct media type is important to ensure the
correct amount of ink is used on your printouts&per.
.*
:p.Typical media types include&colon.
.*
:ul compact.
:li. :hp7.Plain:ehp7. - regular, copier-quality paper
:li. :hp7.Transparency:ehp7. - transparent paper for projectors
:li. :hp7.Special:ehp7. - Specially made, ink-absorbing paper
:li. :hp7.Glossy:ehp7. - rough, photograph-quality paper
:li. :hp7.Coated:ehp7. - smooth, photograph-quality paper
:li. :hp7.Cloth:ehp7. - clothing or towel-like (e.g. T-shirts)
:eul.
.*
.*==========================================================================*/
.* Printer Properties: Connections : Add                                    */
.*==========================================================================*/
.*
:h2 res=15025 name=PANEL_PP_CONNECT_ADD.Add
:i2 refid=connect.Add
:font facename=Helv size=16x9.
.*
:color fc=black.
:p.:hp7.Add:ehp7.
:color fc=default.
:font facename=default size=0x0.
.*
:p.Used to create new user-defined Connections from information
currently displayed in the Current Attributes area of this page&per.
.*
:p.Once a new Connection is added it is displayed in the "Defined
Form Connections" list for selection&per.
.*
.*==========================================================================*/
.* Printer Properties: Connections : Delete                                 */
.*==========================================================================*/
.*
:h2 res=15026 name=PANEL_PP_CONNECT_DELETE.Delete
:i2 refid=connect.Delete
:font facename=Helv size=16x9.
.*
:color fc=black.
:p.:hp7.Delete:ehp7.
:color fc=default.
:font facename=default size=0x0.
.*
:p.Used to delete the currently selected user-defined
Connections from the "Defined Form Connections" list&per.
.*
.*==========================================================================*/
.* Printer Properties: Trays Page                                           */
.*==========================================================================*/
.*
:h1 res=15016 name=PANEL_TRAYS.Trays Page
:i1 id=trays.Trays Page
.*
:font facename=Helv size=16x9.
:color fc=black.
:p.:hp7.Trays Page:ehp7.
:color fc=default.
:font facename=default size=0x0.
.*
:p.This page is where you can view defined Paper Trays for your
printer and their attributes&per.
.*
:p.Some printers will also let you define new trays that than can
be selected when
defining :link reftype=hd res=16010.Form Connections:elink. to
print to&per.
.*
:font facename=Helv size=16x9.
:color fc=black.
:p.:hp2.This page contains the following printer properties&colon.:ehp2.
:color fc=default.
:font facename=default size=0x0.
.*
:ul compact.
:li. :link reftype=hd res=15030.Defined Trays:elink.
:li. :link reftype=hd res=15031.Current Attributes:elink.
:li. :link reftype=hd res=15032.Name:elink.
:li. :link reftype=hd res=15033.Command:elink.
:li. :link reftype=hd res=15034.Feed Type:elink.
:ul compact.
:li. :link reftype=hd res=15035.Automatic:elink.
:li. :link reftype=hd res=15036.Manual:elink.
:eul.
:eul.
.*
:font facename=Helv size=15x8.
:color fc=black.
:p.:hp2.This page contains the following buttons&colon.:ehp2.
:color fc=default.
:font facename=default size=0x0.
.*
:ul compact.
:li. :link reftype=hd res=15037.Add:elink.
:li. :link reftype=hd res=15038.Delete:elink.
:li. :link reftype=hd res=15039.Modify:elink.
:eul.
.*
:note.The Add, Delete, and Modify buttons will be available only if the
printer supports user-defined Trays&per.
.*
.*==========================================================================*/
.* Printer Properties: Trays : Defined Trays                                */
.*==========================================================================*/
:h2 res=15030 name=PANEL_PP_TRAY_DEFINED.Defined Trays
:i2 refid=trays.Defined Trays
:font facename=Helv size=16x9.
.*
:color fc=black.
:p.:hp7.Defined Trays:ehp7.
:color fc=default.
:font facename=default size=0x0.
.*
:p.This pulldown list allows you to view and select all paper Trays
currently defined for your printer&per.
.*
:p.When a Tray is selected from this list, its attributes are displayed
below it in the :link reftype=hd res=15031.Current Attribites:elink. area&per.
.*
:p.The type of tray definition, either "built-in" or "user-defined" will
also be displayed in that attribute area&per.
.*
.*==========================================================================*/
.* Printer Properties: Trays : Current Attributes                           */
.*==========================================================================*/
.*
:h2 res=15031 name=PANEL_PP_TRAY_ATTRS.Current Attributes
:i2 refid=trays.Current Attributes
:font facename=Helv size=16x9.
.*
:color fc=black.
:p.:hp7.Current Attributes:ehp7.
:color fc=default.
:font facename=default size=0x0.
.*
:p.This group contains settings that show the attributes of the
currently selected tray in the "Defined Trays" list on the
same page&per.
.*
:font facename=Helv size=15x8.
:color fc=black.
:p.:hp2.The following attributes are shown.:ehp2.
:color fc=default.
:font facename=default size=0x0.
.*
:ul compact.
:li. :link reftype=hd res=15032.Name:elink.
:li. :link reftype=hd res=15033.Command:elink.
:li. :link reftype=hd res=15034.Feed Type:elink.
:eul.
.*
:p.The type of tray definition, either "built-in" or "user-defined" will
also be displayed in that attribute area&per.
.*
.*==========================================================================*/
.* Printer Properties: Trays : Name                                         */
.*==========================================================================*/
.*
:h2 res=15032 name=PANEL_PP_TRAY_NAME.Name
:i2 refid=trays.Name
:font facename=Helv size=16x9.
.*
:color fc=black.
:p.:hp7.Name:ehp7.
:color fc=default.
:font facename=default size=0x0.
.*
:p.Displays the name of tray currently selected in the
"Defined Trays" list&per.
.*
:p.For printers that allow you to add new trays to the
"Defined Trays" list, this is where you would enter
the new name of the tray you wish to add&per.
.*
.*==========================================================================*/
.* Printer Properties: Trays : Command                                      */
.*==========================================================================*/
.*
:h2 res=15033 name=PANEL_PP_TRAY_COMMAND.Command
:i2 refid=trays.Command
:font facename=Helv size=16x9.
.*
:color fc=black.
:p.:hp7.Command:ehp7.
:color fc=default.
:font facename=default size=0x0.
.*
:p.This field shows the hex command that will be
sent to the printer to select the tray highlighted in the
"Defined Trays" list&per.
.*
:nt.Any control character can be typed in as part of the command
that needs to be sent to the printer&per.  Simply enter all control
or character codes in their Hex equivalent form&per.
.*
:p. :hp7.For example&colon.:ehp7. The ASCII letter 'A' would be entered as
its hex equivalent '41' and the ASCII number '5' would be entered as
its hex equivalent '35'&per.
.*
:p.This allows you to enter printer commands that contain control characters
that do not always have an ASCII character that can be typed in from a
keyboard&per.
.*
:ent.
.*
.*==========================================================================*/
.* Printer Properties: Trays : Feed Type                                    */
.*==========================================================================*/
.*
:h2 res=15034 name=PANEL_PP_TRAY_FEEDTYPE.Feed Type
:i2 refid=trays.Feed Type
:font facename=Helv size=16x9.
.*
:color fc=black.
:p.:hp7.Feed Type:ehp7.
:color fc=default.
:font facename=default size=0x0.
.*
:p.This group contains all the methods by which paper
can be fed from a paper tray to the printer&per.
.*
:p.Only one of the feed types can be checked for any
one paper tray&per.
.*
:font facename=Helv size=15x8.
:color fc=black.
:p.:hp2.The following feed types are available.:ehp2.
:color fc=default.
:font facename=default size=0x0.
.*
:ul compact.
:li. :link reftype=hd res=15035.Automatic:elink.
:li. :link reftype=hd res=15036.Manual:elink.
:eul.
.*
.*==========================================================================*/
.* Printer Properties: Trays : Manual                                       */
.*==========================================================================*/
.*
:h2 res=15036 name=PANEL_PP_TRAY_MANUAL.Manual
:i2 refid=trays.Manual
:font facename=Helv size=16x9.
.*
:color fc=black.
:p.:hp7.Manual:ehp7.
:color fc=default.
:font facename=default size=0x0.
.*
:p.This option is checked when the current tray requires some manual
intervention to feed the paper into the printer&per.
.*
:p.When printing to a "Manual Feed" tray the user will be prompted with
a dialog before each print job to insert a piece of paper&per.
.*
.*==========================================================================*/
.* Printer Properties: Trays : Automatic                                    */
.*==========================================================================*/
.*
:h2 res=15035 name=PANEL_PP_TRAY_AUTOMATIC.Automatic
:i2 refid=trays.Automatic
:font facename=Helv size=16x9.
.*
:color fc=black.
:p.:hp7.Automatic:ehp7.
:color fc=default.
:font facename=default size=0x0.
.*
:p.This option is checked when the selected paper tray
needs no manual intervention to feed paper&per.
.*
:p.This means that the tray can feed individual sheets
from a large stack of sheets in the tray without any
help&per.
.*
:p.No dialog is displayed before print jobs to ask
you to load paper&per.
.*
.*==========================================================================*/
.* Printer Properties: Trays : Add                                          */
.*==========================================================================*/
.*
:h2 res=15037 name=PANEL_PP_TRAY_ADD.Add
:i2 refid=trays.Add
:font facename=Helv size=16x9.
.*
:color fc=black.
:p.:hp7.Add:ehp7.
:color fc=default.
:font facename=default size=0x0.
.*
:p.Used to create user-defined Tray from information
currently displayed in the Current Attributes area of
this page&per.
.*
:p.Once a new tray is added it is displayed in the "Defined
Trays" list for selection&per.
.*
.*==========================================================================*/
.* Printer Properties: Trays : Delete                                       */
.*==========================================================================*/
.*
:h2 res=15038 name=PANEL_PP_TRAY_DELETE.Delete
:i2 refid=trays.Delete
:font facename=Helv size=16x9.
.*
:color fc=black.
:p.:hp7.Delete:ehp7.
:color fc=default.
:font facename=default size=0x0.
.*
:p.Used to delete the currently selected user-defined
Tray from the "Defined Trays" list&per.
.*
.*==========================================================================*/
.* Printer Properties: Trays : Modify                                       */
.*==========================================================================*/
.*
:h2 res=15039 name=PANEL_PP_TRAY_MODIFY.Modify
:i2 refid=trays.Modify
:font facename=Helv size=16x9.
.*
:color fc=black.
:p.:hp7.Modify:ehp7.
:color fc=default.
:font facename=default size=0x0.
.*
:p.Used to modify the currently selected user-defined
Tray from information currently displayed in the Current
Attributes area of this page&per.
.*
.*==========================================================================*/
.* Paper Size Notebook Page                                                 */
.*==========================================================================*/
.*
:h1 res=15017 name=PANEL_PAPER_SIZES.Paper Sizes Page
:i1 id=sizes.Paper Sizes Page
.*
:font facename=Helv size=18x10.
:color fc=black.
:p.:hp2.Paper Sizes Page:ehp2.
:font facename=default size=0x0.
:color fc=default.
.*
:p.This page is where you can view defined Paper Sizes for your
printer and their attributes&per.
.*
:p.Some printers will also let you define new Paper Sizes that than can
be selected when
defining :link reftype=hd res=16010.Form Connections:elink. to
print to&per.
.*
:font facename=Helv size=16x9.
:color fc=black.
:p.:hp2.This page contains the following printer properties&colon.:ehp2.
:color fc=default.
:font facename=default size=0x0.
.*
:ul compact.
:li. :link reftype=hd res=15040.Defined Paper Sizes:elink.
:li. :link reftype=hd res=15041.Current Attributes:elink.
:li. :link reftype=hd res=15042.Name:elink.
:li. :link reftype=hd res=15043.Class:elink.
:li. :link reftype=hd res=15044.Command:elink.
:li. :link reftype=hd res=15045.Width:elink.
:li. :link reftype=hd res=15046.Height:elink.
:li. :link reftype=hd res=15047.Left Margin:elink.
:li. :link reftype=hd res=15048.Right Margin:elink.
:li. :link reftype=hd res=15049.Top Margin:elink.
:li. :link reftype=hd res=15050.Bottom Margin:elink.
:li. :link reftype=hd res=15051.Units-of-Measure:elink.
:ul compact.
:li. :link reftype=hd res=15052.Centimeters:elink.
:li. :link reftype=hd res=15053.Inches:elink.
:eul.
:eul.
.*
:font facename=Helv size=15x8.
:color fc=black.
:p.:hp2.This page contains the following buttons&colon.:ehp2.
:color fc=default.
:font facename=default size=0x0.
.*
:ul compact.
:li. :link reftype=hd res=15054.Add:elink.
:li. :link reftype=hd res=15055.Delete:elink.
:li. :link reftype=hd res=15056.Modify:elink.
:eul.
.*
:note.The Add, Delete, and Modify buttons will be available only if the
printer supports user-defined Paper Sizes&per.
.*
.*==========================================================================*/
.* Printer Properties: Paper Sizes : Defined Paper Sizes                    */
.*==========================================================================*/
.*
:h2 res=15040 name=PANEL_PP_SIZE_DEFINED.Defined Paper Sizes
:i2 refid=sizes.Defined Paper Sizes
:font facename=Helv size=16x9.
.*
:color fc=black.
:p.:hp7.Defined Paper Sizes:ehp7.
:color fc=default.
:font facename=default size=0x0.
.*
:p.This list displays all paper sizes currently defined for this printer&per.
.*
:p.The type of Paper Size, either "built-in" or "user-defined" will
also be displayed in the Current Attributes area&per.
.*
.*==========================================================================*/
.* Printer Properties: Paper Sizes : Current Attributes                     */
.*==========================================================================*/
.*
:h2 res=15041 name=PANEL_PP_SIZE_ATTRS.Current Attributes
:i2 refid=sizes.Current Attributes
:font facename=Helv size=16x9.
.*
:color fc=black.
:p.:hp7.Current Attributes:ehp7.
:color fc=default.
:font facename=default size=0x0.
.*
.*==========================================================================*/
.* Printer Properties: Paper Sizes : Name                                   */
.*==========================================================================*/
.*
:h2 res=15042 name=PANEL_PP_SIZE_NAME.Name
:i2 refid=sizes.Name
:font facename=Helv size=16x9.
.*
:color fc=black.
:p.:hp7.Name:ehp7.
:color fc=default.
:font facename=default size=0x0.
.*
:p.Displays the name of paper size currently selected in the
"Defined Paper Sizes" list&per.
.*
:p.For printers that allow you to add new paper sizes to the
"Defined Paper Sizes" list, this is where you would enter
the new name of the paper size you wish to add&per.
.*
.*==========================================================================*/
.* Printer Properties: Paper Sizes : Class                                  */
.*==========================================================================*/
.*
:h2 res=15043 name=PANEL_PP_SIZE_CLASS.Class
:i2 refid=sizes.Class
:font facename=Helv size=16x9.
.*
:color fc=black.
:p.:hp7.Class:ehp7.
:color fc=default.
:font facename=default size=0x0.
.*
:p.This list displays one of the following classes&colon.
:ul compact.
:li. :hp2.Sheet Paper:ehp2.
:li. :hp2.Continuous Paper:ehp2. (tractor feed)
:li. :hp2.Envelope:ehp2.
:li. :hp2.Postcard:ehp2.
:li. :hp2.Label:ehp2.
:li. :hp2.Other:ehp2.
:eul.
.*
.*==========================================================================*/
.* Printer Properties: Paper Sizes : Command                                */
.*==========================================================================*/
.*
:h2 res=15044 name=PANEL_PP_SIZE_COMMAND.Command
:i2 refid=sizes.Command
:font facename=Helv size=16x9.
.*
:color fc=black.
:p.:hp7.Command:ehp7.
:color fc=default.
:font facename=default size=0x0.
.*
:p.This field shows the hex command that will be
sent to the printer to select the paper size highlited in the
"Defined Paper Sizes" list&per.
.*
:nt.Any control character can be typed in as part of the command
that needs to be sent to the printer&per.  Simply enter all control
or character codes in their Hex equivalent form&per.
.*
:p. :hp7.For example&colon.:ehp7.  The ASCII letter 'A' would be entered as
its hex equivalent '41' and the ASCII number '5' would be entered as
its hex equivalent '35' in the entryfield&per.
.*
:p.This allows you to enter printer commands that contain control characters
that do not always have an ASCII character that can be typed in from a
keyboard&per.
.*
:ent.
.*
.*==========================================================================*/
.* Printer Properties: Paper Sizes : Width                                  */
.*==========================================================================*/
.*
:h2 res=15045 name=PANEL_PP_SIZE_WIDTH.Width
:i2 refid=sizes.Width
:font facename=Helv size=16x9.
.*
:color fc=black.
:p.:hp7.Width:ehp7.
:color fc=default.
:font facename=default size=0x0.
.*
:p.Shows the currently selected paper size's width in the
unit-of-measure selected&per.
.*
:nt.The width should never be set to a value larger than the largest
form the printer is able to print to&per.
:ent.
.*
.*==========================================================================*/
.* Printer Properties: Paper Sizes : Height                                 */
.*==========================================================================*/
.*
:h2 res=15046 name=PANEL_PP_SIZE_HEIGHT.Height
:i2 refid=sizes.Height
:font facename=Helv size=16x9.
.*
:color fc=black.
:p.:hp7.Height:ehp7.
:color fc=default.
:font facename=default size=0x0.
.*
:p.Shows the currently selected paper size's height in the
unit-of-measure selected&per.
.*
:nt.The height should never be set to a value larger than the largest
form the printer is able to print to&per.
:ent.
.*
.*==========================================================================*/
.* Printer Properties: Paper Sizes : Left Clip                            */
.*==========================================================================*/
.*
:h2 res=15047 name=PANEL_PP_SIZE_LM.Left Clip
:i2 refid=sizes.Left Clip
:font facename=Helv size=16x9.
.*
:color fc=black.
:p.:hp7.Left Clip:ehp7.
:color fc=default.
:font facename=default size=0x0.
.*
:p.Shows the currently selected paper size's left clip margin in the
unit-of-measure selected&per.
.*
:nt.This margin should never be set to a value smaller than the printer
is physically able to print to&per.
:ent.
.*
.*==========================================================================*/
.* Printer Properties: Paper Sizes : Right Clip                           */
.*==========================================================================*/
.*
:h2 res=15048 name=PANEL_PP_SIZE_RM.Right Clip
:i2 refid=sizes.Right Clip
:font facename=Helv size=16x9.
.*
:color fc=black.
:p.:hp7.Right Clip:ehp7.
:color fc=default.
:font facename=default size=0x0.
.*
:p.Shows currently selected paper size's right clip margin in the
unit-of-measure selected&per.
.*
:nt.This margin should never be set smaller than to what the printer
is physically able to print to&per.
:ent.
.*
.*==========================================================================*/
.* Printer Properties: Paper Sizes : Top Clip                             */
.*==========================================================================*/
.*
:h2 res=15049 name=PANEL_PP_SIZE_TM.Top Clip
:i2 refid=sizes.Top Clip
:font facename=Helv size=16x9.
.*
:color fc=black.
:p.:hp7.Top Clip:ehp7.
:color fc=default.
:font facename=default size=0x0.
.*
:p.Shows the currently selected paper size's top clip margin in the
unit-of-measure selected&per.
.*
:nt.This margin should never be set to a value smaller than the printer
is physically able to print to&per.
:ent.
.*
.*==========================================================================*/
.* Printer Properties: Paper Sizes : Bottom Clip                          */
.*==========================================================================*/
.*
:h2 res=15050 name=PANEL_PP_SIZE_BM.Bottom Clip
:i2 refid=sizes.Bottom Clip
:font facename=Helv size=16x9.
.*
:color fc=black.
:p.:hp7.Bottom Clip:ehp7.
:color fc=default.
:font facename=default size=0x0.
.*
:p.Shows the currently selected paper size's bottom clip margin in the
unit-of-measure selected&per.
.*
:nt.This margin should never be set to a value smaller than the printer
is physically able to print to&per.
:ent.
.*
.*==========================================================================*/
.* Printer Properties: Paper Sizes : Units-of-Measure                       */
.*==========================================================================*/
.*
:h2 res=15051 name=PANEL_PP_SIZE_UNITS.Units-of-Measure
:i2 refid=sizes.Units-of-Measure
:font facename=Helv size=16x9.
.*
:color fc=black.
:p.:hp7.Units-of-Measure:ehp7.
:color fc=default.
:font facename=default size=0x0.
.*
:p.This group provides buttons to change all paper dimensions
to use one of the following units-of-measurement&colon.
.*
:ul compact.
:li. :link reftype=hd res=15052.Centimeters:elink.
:li. :link reftype=hd res=15053.Inches:elink.
:eul.
.*
.*==========================================================================*/
.* Printer Properties: Paper Sizes : Centimeters                            */
.*==========================================================================*/
.*
:h2 res=15052 name=PANEL_PP_SIZE_CM.Centimeters
:i2 refid=sizes.Centimeters
:font facename=Helv size=16x9.
.*
:color fc=black.
:p.:hp7.Centimeters:ehp7.
:color fc=default.
:font facename=default size=0x0.
.*
:p.The Metric system of measurement will be used to display all
paper dimensions on this page&per.
.*
.*==========================================================================*/
.* Printer Properties: Paper Sizes : Inches                                 */
.*==========================================================================*/
.*
:h2 res=15053 name=PANEL_PP_SIZE_INCH.Inches
:i2 refid=sizes.Inches
:font facename=Helv size=16x9.
.*
:color fc=black.
:p.:hp7.Inches:ehp7.
:color fc=default.
:font facename=default size=0x0.
.*
:p.The English system of measurement will be used to display all
paper dimensions on this page&per.
.*
.*==========================================================================*/
.* Printer Properties: Paper Sizes : Add                                    */
.*==========================================================================*/
.*
:h2 res=15054 name=PANEL_PP_SIZE_ADD.Add
:i2 refid=sizes.Add
:font facename=Helv size=16x9.
.*
:color fc=black.
:p.:hp7.Add:ehp7.
:color fc=default.
:font facename=default size=0x0.
.*
:p.Used to create user-defined Paper Sizes from information
currently displayed in the Current Attributes area of this page&per.
.*
:p.Once a new paper size is added it is displayed in the "Defined
Paper Sizes" list for selection&per.
.*
.*==========================================================================*/
.* Printer Properties: Paper Sizes : Delete                                 */
.*==========================================================================*/
.*
:h2 res=15055 name=PANEL_PP_SIZE_DELETE.Delete
:i2 refid=sizes.Delete
:font facename=Helv size=16x9.
.*
:color fc=black.
:p.:hp7.Delete:ehp7.
:color fc=default.
:font facename=default size=0x0.
.*
:p.Used to delete the currently selected user-defined
Paper Sizes from the "Defined Paper Sizes" list&per.
.*
.*==========================================================================*/
.* Printer Properties: Paper Sizes : Modify                                 */
.*==========================================================================*/
.*
:h2 res=15056 name=PANEL_PP_SIZE_MODIFY.Modify
:i2 refid=sizes.Modify
:font facename=Helv size=16x9.
.*
:color fc=black.
:p.:hp7.Modify:ehp7.
:color fc=default.
:font facename=default size=0x0.
.*
:p.Used to modify the currently selected user-defined
Paper Size from information currently displayed in the
Current Attributes area of this page&per.
.*
.*==========================================================================*/
.* Maintenance Notebook Page                                                */
.*==========================================================================*/
.*
:h1 res=15018 name=PANEL_MAINTENANCE.Maintenance Page
:i1 id=maint.Maintenance Page
.*
:font facename=Helv size=18x10.
:color fc=black.
:p.:hp2.Maintenance Page:ehp2.
:font facename=default size=0x0.
:color fc=default.
.*
:p.Maintenance service for devices performs the following printer
control and diagnostic functions.
:font facename=default size=0x0.
.*
:ul compact.
:li. :link reftype=hd res=15060.Tests:elink.
:li. :link reftype=hd res=15061.Print head cleaning:elink.
:li. :link reftype=hd res=15062.Change BJ cartridge:elink.
:li. :link reftype=hd res=15063.Print head alignment:elink.
:li. :link reftype=hd res=15064.Power control:elink.
:eul.
.*
.*==========================================================================*/
.* Printer Properties: Maintenance : Tests                                  */
.*==========================================================================*/
.*
:h2 res=15060 name=PANEL_MN_TESTS.Tests
:i2 refid=maint.Tests
:font facename=Helv size=16x9.
.*
:color fc=black.
:p.:hp7.Tests:ehp7.
:color fc=default.
:font facename=default size=0x0.
.*
:p.After connecting your printer, or if you are having problems printing
clearly, use the Tests feature to check your printer&per.
.*
:p.This section of the Maintenance tab generates printed test patterns
on your printer. The following test patterns are available:
:color fc=default.
:font facename=default size=0x0.
.*
:ul compact.
:li. :link reftype=hd res=15067.Nozzle Test:elink.
:li. :link reftype=hd res=15065.Test:elink.
:li. :link reftype=hd res=15066.Demonstration:elink.
:eul.
.*
:nt.Some printers may not provide this function, or
may show different buttons with different devices&per.
:ent.
.*
.*==========================================================================*/
.* Printer Properties: Maintenance : Tests : Test                           */
.*==========================================================================*/
.*
:h2 res=15065 name=PANEL_MN_TEST.Test
:i2 refid=maint.Test
:font facename=Helv size=16x9.
.*
:color fc=black.
:p.:hp7.Test:ehp7.
:color fc=default.
:font facename=default size=0x0.
.*
:p.This test pattern can be used to verify the correct operation of your
printer. To print a Test pattern, click on this item&per.
.*
:nt.Some printers may not provide this function&per.:ent.
.*
.*==========================================================================*/
.* Printer Properties: Maintenance : Tests : Demonstration                  */
.*==========================================================================*/
.*
:h2 res=15066 name=PANEL_MN_DEMONSTRATION.Demonstration
:i2 refid=maint.Demonstration
:font facename=Helv size=16x9.
.*
:color fc=black.
:p.:hp7.Demonstration:ehp7.
:color fc=default.
:font facename=default size=0x0.
.*
:p.This test pattern can be used to print a sample document on your
printer. To print a Demonstration test pattern, click on this item&per.
.*
:nt.Some printers may not provide this function&per.:ent.
.*
.*==========================================================================*/
.* Printer Properties: Maintenance : Tests : Nozzle Test                    */
.*==========================================================================*/
.*
:h2 res=15067 name=PANEL_MN_NOZZLE_TEST.Nozzle Test
:i2 refid=maint.Nozzle Test
:font facename=Helv size=16x9.
.*
:color fc=black.
:p.:hp7.Nozzle Test:ehp7.
:color fc=default.
:font facename=default size=0x0.
.*
:p.This test pattern can be used to test the operation of the ink head
nozzles. To print a Nozzle Test pattern, click on this item&per.
.*
:nt.Some printers may not provide this function&per.:ent.
.*
.*==========================================================================*/
.* Printer Properties: Maintenance : Print Head Cleaning                    */
.*==========================================================================*/
.*
:h2 res=15061 name=PANEL_MN_CLEAN.Print Head Cleaning
:i2 refid=maint.Cleaning
:font facename=Helv size=16x9.
.*
:color fc=black.
:p.:hp7.Print Head Cleaning:ehp7.
:color fc=default.
:font facename=default size=0x0.
.*
:p.When your printer is not printing clearly, try cleaning the print head&per.
.*
:p.If your printer does not print clearly after several cleanings,
the ink tank or BJ cartridges may be out of ink, or the BJ cartridge
print head may be worn out. If this is the case, you will need to 
:link reftype=hd res=15062.change the BJ cartridge:elink. or ink tank
&per.
:p.When you select Print Head Cleaning for a 
printer that has multiple print heads, a print head selection window opens. Select the
print head you want to clean:
:color fc=default.
:font facename=default size=0x0.
.*
:ul compact.
:li. :link reftype=hd res=15073.All Colors:elink.
:li. :link reftype=hd res=15074.Black:elink.
:li. :link reftype=hd res=15075.Color:elink.
:li. :link reftype=hd res=15076.Print head deep cleaning:elink.
:eul.
.*
:p.The printer then performs the full head refreshing cycle.
.*
.*
:nt.Cleaning the print heads frequently will rapidly deplete your
printer's ink supply.:ent.
.*
:p.Some printers may not provide this function, or may show different
buttons with different devices&per.
.*
.*==========================================================================*/
.* Printer Properties: Maintenance : Print Head Cleaning : All Colors       */
.*==========================================================================*/
.*
:h2 res=15073 name=PANEL_MN_CLEAN_ALL.All Colors Print Head Cleaning
:i2 refid=maint.Clean All Print Heads
:font facename=Helv size=16x9.
.*
:color fc=black.
:p.:hp7.All Colors Print Head Cleaning:ehp7.
:color fc=default.
:font facename=default size=0x0.
.*
:p.This control function executes All Colors Print Head Cleaning.
.*
.*==========================================================================*/
.* Printer Properties: Maintenance : Print Head Cleaning : Black            */
.*==========================================================================*/
.*
:h2 res=15074 name=PANEL_MN_CLEAN_B.Black Color Print Head Cleaning
:i2 refid=maint.Clean Black Color Print Heads
:font facename=Helv size=16x9.
.*
:color fc=black.
:p.:hp7.Black Color Print Head Cleaning:ehp7.
:color fc=default.
:font facename=default size=0x0.
.*
:p.This control function executes Black Color Print Head Cleaning.
.*
.*==========================================================================*/
.* Printer Properties: Maintenance : Print Head Cleaning : Colors           */
.*==========================================================================*/
.*
:h2 res=15075 name=PANEL_MN_CLEAN_C.Colors Print Head Cleaning
:i2 refid=maint.Clean Color Print Heads
:font facename=Helv size=16x9.
.*
:color fc=black.
:p.:hp7.Colors Print Head Cleaning:ehp7.
:color fc=default.
:font facename=default size=0x0.
.*
:p.This control function executes Colors Print Head Cleaning.
.*
.*==========================================================================*/
.* Printer Properties: Maintenance : Print Head Cleaning : Deep Cleaning    */
.*==========================================================================*/
.*
:h2 res=15076 name=PANEL_MN_CLEAN_DC.Print Head Deep Cleaning
:i2 refid=maint.Clean Print Heads - Deep Clean
:font facename=Helv size=16x9.
.*
:color fc=black.
:p.:hp7.Print Head Deep Cleaning:ehp7.
:color fc=default.
:font facename=default size=0x0.
.*
:p.This control function executes Print Head Deep Cleaning.
.*
.*==========================================================================*/
.* Printer Properties: Maintenance : Change the BJ Cartridge                */
.*==========================================================================*/
.*
:h2 res=15062 name=PANEL_MN_CHANGE.Change the BJ Cartridge
:i2 refid=maint.Change BJ Cartridge
:font facename=Helv size=16x9.
.*
:color fc=black.
:p.:hp7.Change the BJ Cartridge:ehp7.
:color fc=default.
:font facename=default size=0x0.
.*
:p.You will need to change BJ cartridges when you switch between Color
and Black BJ cartridges, or when the print head wears out&per.
:p.Click this button to move the ink cartridge to the load/unload
position, so you can change or replace the ink cartridge or ink head&per.
.*
:p.The printer driver provides the necessary auxiliary operations for
changing the BJ cartridge. When the ink supply runs out, you can replace
the ink tank without replacing the BJ cartridge.
.*
:p.After changing the BJ Cartridge, the:link reftype=hd res=15063. Print Head
Alignment:elink. procedure is automatically started&per.
.*
:nt.Some printers may not provide this function, or may show different
buttons with different devices&per.:ent.
.*
.*==========================================================================*/
.* Printer Properties: Maintenance : Print Head Alignment                   */
.*==========================================================================*/
.*
:h2 res=15063 name=PANEL_MN_ALIGNMENT.Print Head Alignment
:i2 refid=maint.Alignment
:font facename=Helv size=16x9.
.*
:color fc=black.
:p.:hp7.Alignment:ehp7.
:color fc=default.
:font facename=default size=0x0.
.*
:p.When your printer is not printing clearly, try aligning the print heads.  The
method used to align the print heads depends on the model of your printer&per.
.*
:p.Some printers use two BJ cartridges.  After you change a BJ cartridge, you
need to align the two print heads so they provide clear, attractive printing.
Aligning the print heads ensures that the print heads are aligned for accurate
printing.
:p.For those printers that use BJ cartridges, once the print head alignment
operation is started, it cannot be canceled.
:p.  During the print head alignment operation, you will be prompted to proceed
through the operation.  The printer will print out alignment patterns and high
resolution alignment patterns.  After each set of patterns is printed, you will
be asked to check whether the pattern printed satisfactorily.  If the pattern
printed satisfactorily, click the Yes button to continue the operation.  If the
pattern did not print satisfactorily, click the No button and follow the
instructions to repeat the alignment process.
:p.You will need to look at the printed patterns and enter the appropriate
number for the identified alignment patterns.
:p.For the BJC-6000, BJC-7100, and BJC-8000 printers, you should select each
pattern in which the two lines seem to become one.
:p.For the BJC-7000 and BJC-8500 printers, you should note the number of the
line for (A), (B), (C), or (D) where the lines overlap perfectly.
.*
:p.The alignment adjustments can be verified by selecting the Nozzle Test button
in the Maintenance tab's Test feature.
.*
.*==========================================================================*/
.* Printer Properties: Maintenance : Power Control                          */
.*==========================================================================*/
.*
:h2 res=15064 name=PANEL_MN_POWER.Power Control
:i2 refid=maint.Power
:font facename=Helv size=16x9.
.*
:color fc=black.
:p.:hp7.Power:ehp7.
:color fc=default.
:font facename=default size=0x0.
.*
:p.This section of the Maintenance tab performs the following printer
control functions&per.
.*
:color fc=default.
:font facename=default size=0x0.
.*
:ul compact.
:li. :link reftype=hd res=15077.Auto Power Off:elink.
:li. :link reftype=hd res=15078.Auto Power On:elink.
:li. :link reftype=hd res=15079.Power Off:elink.
:eul.
.*
:nt.Some printers may not provide this function, or
may show different buttons with different devices&per.:ent.
.*
.*==========================================================================*/
.* Printer Properties: Maintenance : Power Control : Auto Power Off         */
.*==========================================================================*/
.*
:h2 res=15077 name=PANEL_MN_POWER_OFF.Auto Power Off
:i2 refid=maint.Power Off
:font facename=Helv size=16x9.
.*
:color fc=black.
:p.:hp7.Auto Power Off:ehp7.
:color fc=default.
:font facename=default size=0x0.
.*
:p.The Auto Power Off feature of your printer is used for improved energy
efficiency&per.  By enabling this feature, your printer can automatically turn its power off, based
on your level of activity. Use this section to control whether this
feature is to be used, and if so, how long the idle period should be
before the printer turns itself off. You can select the idle time
in minutes, or you can disable this feature.
To use these features, select the desired settings and then click
the Set button&per.
.*
.*==========================================================================*/
.* Printer Properties: Maintenance : Power Control : Auto Power On          */
.*==========================================================================*/
.*
:h2 res=15078 name=PANEL_MN_POWER_ON.Auto Power On
:i2 refid=maint.Power On
:font facename=Helv size=16x9.
.*
:color fc=black.
:p.:hp7.Auto Power On:ehp7.
:color fc=default.
:font facename=default size=0x0.
.*
:p.Auto Power On: To control your printer's Auto Power On feature,
click the arrow button and select Enabled or Disabled from the
drop-down box. Select Enabled to allow Auto Power On to operate.
Select Disabled to prevent it from operating&per.
.*
.*==========================================================================*/
.* Printer Properties: Maintenance : Power Control :  Power Off             */
.*==========================================================================*/
.*
:h2 res=15079 name=PANEL_MN_POWER_ON.Power Off
:font facename=Helv size=16x9.
.*
:color fc=black.
:p.:hp7.Power Off:ehp7.
:color fc=default.
:font facename=default size=0x0.
.*
:p.Power Off: Click this button to turn off the printer's power from
within the printer driver&per.
.*
.*==========================================================================*/
.*==========================================================================*/
.* Omni Job Property Main Help                                              */
.*==========================================================================*/
.*==========================================================================*/
.*
:h1 res=16000 name=PANEL_JOB_PROPERTIES.Job Properties
:i1 id=JobProp.Job Properties
:font facename=Helv size=20x12.
:color fc=black.
:p.:hp2.Job Properties:ehp2.
:color fc=default.
:font facename=default size=0x0.
.*
:p.The Job Properties dialog contains a notebook of settings
that control how your printouts are formatted.
.*
:p.Click on one of the following page names to get detailed
information about settings available on that page&colon.
:ul compact.
:li. :link reftype=hd res=16004.Common:elink.
:li. :link reftype=hd res=16005.Monochrome:elink.
:li. :link reftype=hd res=16006.Color:elink.
:li. :link reftype=hd res=16007.HSV:elink.
:li. :link reftype=hd res=7000.Layout:elink.
:eul.
.*
:p.The Job Properties dialog also contains buttons. Click on
the name of a button to find out what it does&per.
:ul compact.
:li. :link reftype=hd res=16001.Save:elink.
:li. :link reftype=hd res=16002.Cancel:elink.
:li. :link reftype=hd res=16003.Help:elink.
:eul.
.*
:nt.Some notebook pages will not appear on printer models
that do not support any features from that page&per.
.*
:p.e.g. The :hp7."Color":ehp7. page will only appear for
color-capable printers&per.
:ent.
.*
:font facename=Helv size=16x9.
:color fc=black.
:p.:hp7.Photo-Quality Printing:ehp7.
:color fc=default.
:font facename=default size=0x0.
.*
:p.All Job Properties notebook settings are initially set for
the optimal balance between quality and performance for each printer model&per.
.*
:p.For printing photo-quality images and graphics you may wish to
change the following job properties to achieve the best results&colon.
.*
:ul compact.
:li. :link reftype=hd res=16011.Print Quality:elink.
:li. :link reftype=hd res=16012.Print Mode:elink.
:li. :link reftype=hd res=16030.Color Dither:elink.
:eul.
.*
.*==========================================================================*/
.* Job Properties "Save" button                                             */
.*==========================================================================*/
:h2 res=16001 name=PANEL_JP_SAVE.Save
:i2 refid=JobProp.Save button
:font facename=Helv size=16x9.
:color fc=black.
:p.:hp7.Save:ehp7.
:color fc=default.
:font facename=default size=0x0.
.*
:p.Pressing the Save button causes the Job Properties dialog
to close and all changes made to Job Properties notebook pages are
saved for the calling application&per.
:p.Printouts from that application will now use the newly saved
set of Job Properties&per.
.*
:note.If you do not wish to save or alter the current set of Job Properties,
but just want to close the Job Properties dialog, simply press
the :link reftype=hd res=16002.Cancel:elink. button instead&per.
.*
.*==========================================================================*/
.* Job Properties "Cancel" button                                           */
.*==========================================================================*/
:h2 res=16002 name=PANEL_JP_CANCEL.Cancel
:i2 refid=JobProp.Cancel button
:font facename=Helv size=16x9.
:color fc=black.
:p.:hp7.Cancel:ehp7.
:color fc=default.
:font facename=default size=0x0.
.*
:p.Pressing the Cancel button causes the Job Properties dialog
to close&per. Any changes made to Job Properties notebook pages are
ignored by the calling application&per.
.*
:p.Printouts from that application will still use the Job Properties
shown before any changes were made&per.
.*
:nt.If you do want to save or alter the current set of Job Properties,
simply press the :link reftype=hd res=16001.Save:elink. button instead&per.
:ent.
.*
.*==========================================================================*/
.* Job Properties "Help" button                                             */
.*==========================================================================*/
:h2 res=16003 name=PANEL_JP_HELP.Help
:i2 refid=JobProp.Help button
:font facename=Helv size=16x9.
:color fc=black.
:p.:hp7.Help:ehp7.
:color fc=default.
:font facename=default size=0x0.
.*
:p.Pressing the Help button brings up this help window and shows the
main help for the Job Properties dialog&per.
.*
:p.Once in the main help dialog, you can access help topics
for any specific job property shown anywhere in the Job
Properties notebook&per.
.*
.*==========================================================================*/
.* Job Properties: Common Page                                              */
.*==========================================================================*/
.*
:h1 res=16004 name=PANEL_COMMON.Common Page
:i1 id=common.Common Page
.*
:font facename=Helv size=16x9.
:color fc=black.
:p.:hp7.Common Page:ehp7.
:color fc=default.
:font facename=default size=0x0.
.*
:p.This page is used to set and view the most "common" job property
options users apply to printouts&per.
.*
:font facename=Helv size=16x9.
:color fc=black.
:p.:hp2.This page contains the following job properties&colon.:ehp2.
:color fc=default.
:font facename=default size=0x0.
.*
:p.Click on the name of a job property to see what it does&per.
.*
:ul compact.
:li. :link reftype=hd res=16010.Form Connection:elink.
:li. :link reftype=hd res=16011.Print Quality:elink.
:li. :link reftype=hd res=16012.Print Mode:elink.
:li. :link reftype=hd res=16013.Orientation:elink.
:li. :link reftype=hd res=16014.Duplex Options:elink.
:li. :link reftype=hd res=16015.Default Font:elink.
:li. :link reftype=hd res=16018.Copies:elink.
:li. :link reftype=hd res=16032.Color Dither:elink.
:li. :link reftype=hd res=16016.Effects:elink.
:li. :link reftype=hd res=16017.Form Feed Control:elink.
:eul.
.*
.*==========================================================================*/
.* Job Properties: Common: Form Connection                                  */
.*==========================================================================*/
:h2 res=16010 name=PANEL_JP_COMMON_FORM.Form Connection
:i2 refid=common.Form Connection
:font facename=Helv size=16x9.
:color fc=black.
:p.:hp7.Form Connection:ehp7.
:color fc=default.
:font facename=default size=0x0.
.*
:p.This pulldown list allows you to select the correct Form
Connection to print to&per.
.*
:p.A Form Connection represents the combination of a paper tray, size
and media type as a single selectable item&per.
:p.This representation closely reflects a real printer's setup
(i.e. you place a paper size of a certain media type in a
certain paper tray)&per.
.*
:p.Linking these properties as a single Form Connection allows
the application to know if a desired paper size is installed in
a paper tray or not&per.  If it is not, the user will be told to change
the paper size to the correct one for that printout&per.
.*
:p.Form connections can also let applications make sure the correct
media type is installed in a paper tray before printing&per.
.*
:nt.New Form Connections can be added to this list from
the driver's :link reftype=hd res=15010.Printer Properties:elink. dialog&per.
.*
:p.Simply follow the instructions on the :hp1."Connection":ehp1. page in the
Printer Properties notebook&per.
:ent.
.*
.*==========================================================================*/
.* Job Properties: Common: Print Quality                                    */
.*==========================================================================*/
:h2 res=16011 name=PANEL_JP_COMMON_PQ.Print Quality
:i2 refid=common.Print Quality
:font facename=Helv size=16x9.
:color fc=black.
:p.:hp7.Print Quality:ehp7.
:color fc=default.
:font facename=default size=0x0.
.*
:p.This pulldown list allows you to select the quality of printouts
based upon the capabilities of your printer&per.
:p.Some printers choose to list print quality by resolution or
dots-per-inch (DPI). In this case, a higher DPI typically means
a higher print quality (also called higher resolution)&per.
.*
:p.Other printers use regular terms to describe the quality of
the image&per. This still usually implies the resolution of
the printouts are changing to achieve a selected print quality&per.
.*
:p. Examples of common Print Qualities&colon.
:ul compact.
:li. Draft, Presentation
:li. 300 dpi, 600 dpi
:li. Low, Average, High
:eul.
.*
:nt.The higher the print quality the longer it will take for
printouts to finish printing&per.
:ent.
.*
:font facename=Helv size=16x9.
:color fc=black.
:p.:hp7.Photo-Quality Printing:ehp7.
:color fc=default.
:font facename=default size=0x0.
.*
:p.For best output results printing "photo-quality" graphics please select
the highest available print quality listed&per.
.*
.*
.*==========================================================================*/
.* Job Properties: Common: Print Mode                                       */
.*==========================================================================*/
:h2 res=16012 name=PANEL_JP_COMMON_PM.Print Mode
:i2 refid=common.Print Mode
:font facename=Helv size=16x9.
:color fc=black.
:p.:hp7.Print Mode:ehp7.
:color fc=default.
:font facename=default size=0x0.
.*
:p.This pulldown list allows you to select whether your printouts
are monochrome or color (if supported by your printer)&per.
.*
:p.If the printer allows multiple levels of grayscale or more than one color
format those selections will appear in this list as well&per.
.*
:p.This number is sometimes represented as "bits-per-pel" (bpp)&colon.
.*
:ul compact.
:li. 24-bit = 16.7 million colors/grayscales
:li. 8-bit  = 256 colors/grayscales
:li. 4-bit  = 16 colors/grayscales
:eul.
.*
:font facename=Helv size=16x9.
:color fc=black.
:p.:hp7.Photo-Quality Printing:ehp7.
:color fc=default.
:font facename=default size=0x0.
.*
:p.For best output results printing "photo-quality" graphics please select
the print mode that uses the most colors/grayscales or highest
"bits-per-pel"&per.
.*
:nt.This driver's monochrome printouts, by default, use 256 grayscales
and color printouts use 256 colors (if none are listed)&per.
.*
:p.Selecting color print modes will cause printouts to take longer
to finish than selecting monochrome print modes for the same document&per.
.*
:p.The more colors/grayscales used on a printout (more "bits-per-pel")
the longer the printout will take to finish&per.
.*
:ent.
.*
.*==========================================================================*/
.* Job Properties: Common: Orientation                                      */
.*==========================================================================*/
:h2 res=16013 name=PANEL_JP_COMMON_ORIENT.Orientation
:i2 refid=common.Orientation
:font facename=Helv size=16x9.
:color fc=black.
:p.:hp7.Orientation:ehp7.
:color fc=default.
:font facename=default size=0x0.
.*
:p.This group contains buttons to select how a form is oriented
when printing&per.
:p.The selection determines which dimension
of a paper is to be considered the width and which the height&per.
.*
:font facename=Helv size=15x8.
:color fc=black.
:p.:hp2.One of the following buttons can be selected&colon.:ehp2.
:color fc=default.
:font facename=default size=0x0.
.*
:p.:color fc=black.:hp7.Portrait:ehp7.:color fc=default. orientation
typically means that printed output occurs so that the form :hp1.width is
the smaller:ehp1. of the two possible form dimensions&per.
.*
:p.:color fc=black.:hp7.Landscape:ehp7.:color fc=default. orientation
typically means that printed output occurs so that the form :hp1.width is
the larger:ehp1. of the two possible form dimensions&per.
.*
.*==========================================================================*/
.* Job Properties: Common: Duplex                                           */
.*==========================================================================*/
:h2 res=16014 name=PANEL_JP_COMMON_DUPLEX.Duplex Options
:i2 refid=common.Duplex Options
:font facename=Helv size=16x9.
:color fc=black.
:p.:hp7.Duplex Options:ehp7.
:color fc=default.
:font facename=default size=0x0.
.*
:p.This group contains buttons that select how duplexing is performed on
those printers that support this option&per.
.*
:font facename=Helv size=15x8.
:color fc=black.
:p.:hp2.One of the following buttons can be selected&colon.:ehp2.
:color fc=default.
:font facename=default size=0x0.
.*
:p.:color fc=black.:hp7.1-Sided:ehp7.:color fc=default. means printing
only occurs on one side of each piece of paper&per.  This is the only option
available for printers that do not support duplexing&per.
.*
:p.:color fc=black.:hp7.2-Sided Book:ehp7.:color fc=default. means
printing occurs on both sides of each piece of paper&per. In addition,
duplexing occurs so that you continue reading from the front side of
a paper to the back side by flipping it over left-to-right like a
:hp1."book's":ehp1. page&per.
.*
:p.:color fc=black.:hp7.2-Sided Flip:ehp7.:color fc=default. means
printing occurs on both sides of each piece of paper&per. In addition,
duplexing occurs so that you continue reading from the front side of
a paper to the back side by flipping it over top-to-bottom
&per.
.*
.*==========================================================================*/
.* Job Properties: Common: Default Font                                     */
.*==========================================================================*/
:h2 res=16015 name=PANEL_JP_COMMON_FONT.Default Font
:i2 refid=common.Default Font
:font facename=Helv size=16x9.
:color fc=black.
:p.:hp7.Default Font:ehp7.
:color fc=default.
:font facename=default size=0x0.
.*
:p.This pulldown list allows you to select what device font is to be used
as the default font for simple text printouts&per.
.*
:p.This setting (when available) usually only effects text printouts
from applications that do not explicitly choose a font&per.
.*
:nt.Many printer models do not have device font support enabled&per.
:ent.
.*
.*==========================================================================*/
.* Job Properties: Common: Copies  @COLLATE                                 */
.*==========================================================================*/
:h2 res=16018 name=PANEL_JP_COMMON_COPIES.Copies
:i2 refid=common.Copies
:font facename=Helv size=16x9.
:color fc=black.
:p.:hp7.Copies:ehp7.
:color fc=default.
:font facename=default size=0x0.
.*
:p.:hp2.Number of copies: :ehp2. enter the number of copies to print.
:p.:hp2.Collate: :ehp2. provides the collated output.
Collating is defined as follows: for three copies of a three-page document,
collated pages are produced in the order 1-2-3-1-2-3-1-2-3, while uncollated
pages are produced in the order 1-1-1-2-2-2-3-3-3.
.*
.*==========================================================================*/
.* Job Properties: Common: Effects                                          */
.*==========================================================================*/
:h2 res=16016 name=PANEL_JP_COMMON_EFFECT.Effects
:i2 refid=common.Effects
:font facename=Helv size=16x9.
:color fc=black.
:p.:hp7.Effects:ehp7.
:color fc=default.
:font facename=default size=0x0.
.*
:p.This group contains check boxes of options to apply to printouts&per.
.*
:font facename=Helv size=15x8.
:color fc=black.
:p.:hp2.Any of the following can be checked&colon.:ehp2.
:color fc=default.
:font facename=default size=0x0.
.*
:p.:color fc=black.:hp7.Mirror Image:ehp7.:color fc=default. When
selected all printouts come out as if viewed in the face of a mirror&per.
.*
:p.One practical use for this option is to create iron-on transfers&per.
.*
:nt.This option is only available
in :link reftype=hd res=16013.Portrait:elink. orientation&per.
:ent.
.*
.*==========================================================================*/
.* Job Properties: Common: Form Feed Control                                */
.*==========================================================================*/
:h2 res=16017 name=PANEL_JP_COMMON_FF.Form Feed Control
:i2 refid=common.Form Feed Control
:font facename=Helv size=16x9.
:color fc=black.
:p.:hp7.Form Feed Control:ehp7.
:color fc=default.
:font facename=default size=0x0.
.*
:p.This group contains buttons that select how Form Feeds should be handled
at the end of non-OS/2 print jobs&per.
.*
:font facename=Helv size=15x8.
:color fc=black.
:p.:hp2.One of the following buttons can be selected&colon.:ehp2.
:color fc=default.
:font facename=default size=0x0.
.*
:p.:color fc=black.:hp7.Conditional:ehp7.:color fc=default. Ensures a Form Feed is present at
the end of every print job
:p.:color fc=black.:hp7.None:ehp7.:color fc=default. Preserves any Form Feed commands found at
the end of each print job
:p.:color fc=black.:hp7.Compulsory:ehp7.:color fc=default. Always adds a Form Feed command at
the end of each print job
.*
:nt. When :hp1."Conditional":ehp1. is selected, it is
possible that some imbedded Form Feeds characters will
not be detected and additional Form Feeds can still occur&per.
:ent.
.*
.*==========================================================================*/
.* Job Properties: Mononchrome Page                                         */
.*==========================================================================*/
.*
:h1 res=16005 name=PANEL_MONO.Monochrome Page
:i1 id=mono.Monochrome Page
.*
:font facename=Helv size=16x9.
:color fc=black.
:p.:hp7.Monochrome Page:ehp7.
:color fc=default.
:font facename=default size=0x0.
.*
:p.This page contains job properties that affect
the appearance of monochrome printouts&per.
.*
:font facename=Helv size=16x9.
:color fc=black.
:p.:hp2.This page contains the following job properties&colon.:ehp2.
:color fc=default.
:font facename=default size=0x0.
.*
:p.Click on the name of a job property to see what it does&per.
.*
:ul compact.
:li. :link reftype=hd res=16021.Monochrome Adjustments:elink.
:ul compact.
:li. :link reftype=hd res=16024.Darkness:elink.
:eul.
:li. :link reftype=hd res=16020.Monochrome Colors:elink.
:ul compact.
:li. :link reftype=hd res=16022.Foreground:elink.
:li. :link reftype=hd res=16023.Background:elink.
:eul.
:eul.
.*
:nt.
This driver supports 256 levels of grayscale when printing monochrome&per.
:ent.
.*
.*==========================================================================*/
.* Job Properties: Monochrome: Monochrome Colors                            */
.*==========================================================================*/
:h2 res=16020 name=PANEL_JP_MONO_COLORS.Monochrome Colors
:i2 refid=mono.Monochrome Colors
:font facename=Helv size=16x9.
:color fc=black.
:p.:hp7.Monochrome Colors:ehp7.
:color fc=default.
:font facename=default size=0x0.
.*
:p.This group contains two lists that allow you to select what color
is considered the :hp3."foreground":ehp3. and :hp3."background":ehp3. colors
for a monochrome printout&per.
.*
:font facename=Helv size=15x8.
:color fc=black.
:p.:hp2.Click on the name of a list for more information&colon.:ehp2.
:color fc=default.
:font facename=default size=0x0.
.*
:ul compact.
:li. :link reftype=hd res=16022.Foreground:elink.
:li. :link reftype=hd res=16023.Background:elink.
:eul.
.*
:font facename=Helv size=15x8.
:color fc=black.
:p.:hp2.These lists contains the following colors&colon.:ehp2.
:color fc=default.
:font facename=default size=0x0.
:ul compact.
:li.Black (default foreground)
:li.White (default background)
:li.Blue
:li.Green
:li.Cyan
:li.Red
:li.Pink
:li.Yellow
:eul.
.*
:nt.This option is only available on some color-capable printers when in
a monochrome :link reftype=hd res=16012.Print Mode:elink.&per.
.*
:p.For non-color printers, the foreground color is
always :hp1."black":ehp1. and the background color is :hp1."white":ehp1.&per.
:ent.
.*
.*==========================================================================*/
.* Job Properties: Monochrome: Foreground                                   */
.*==========================================================================*/
:h2 res=16022 name=PANEL_JP_MONO_FG.Foreground
:i2 refid=mono.Foreground
:font facename=Helv size=16x9.
:color fc=black.
:p.:hp7.Foreground:ehp7.
:color fc=default.
:font facename=default size=0x0.
.*
:p.This list allows you to change the foreground ink color used for
monochrome printouts to one of the colors in the list&per.
.*
:p.By default, black ink is used for the foreground color on monochrome
printouts&per.
.*
:nt.This option is only available on some color-capable printers when in a
monochrome print mode&per.
:ent.
.*
.*==========================================================================*/
.* Job Properties: Monochrome: Background                                   */
.*==========================================================================*/
:h2 res=16023 name=PANEL_JP_MONO_BG.Background
:i2 refid=mono.Background
:font facename=Helv size=16x9.
:color fc=black.
:p.:hp7.Background:ehp7.
:color fc=default.
:font facename=default size=0x0.
.*
:p.This list allows you to change the background ink color used for
monochrome printouts to one of the colors in the list&per.
.*
:p.By default, the color white is used for the background color on monochrome
printouts&per.  Since most printers do not have white ink, the paper's color
is assumed to be white and no ink is used&per.
.*
:p.Once the background color is changed from white (default) to
any other color, the background color will be generated from
mixing the printer's available inks&per.
.*
:nt.This option is only available on some color-capable printers when in a
monochrome print mode&per.
.*
:p.Only change the background color if really needed since it increases
print times and wastes ink&per.
:ent.
.*
.*==========================================================================*/
.* Job Properties: Monochrome: Darkness                                     */
.*==========================================================================*/
:h2 res=16024 name=PANEL_JP_MONO_DARKNESS.Darkness (Monochrome)
:i2 refid=mono.Darkness (Monochrome)
:font facename=Helv size=16x9.
:color fc=black.
:p.:hp7.Darkness (Monochrome):ehp7.
:color fc=default.
:font facename=default size=0x0.
.*
:p.This slider adjusts the darkness of monochrome printouts&per.
.*
:p.The control adjusts from a value of 0 (default darkness);
where positive values make printouts increasingly darker and
negative increasingly lighter&per.
.*
.*==========================================================================*/
.* Job Properties: Monochrome: Monochrome Adjustments                       */
.*==========================================================================*/
:h2 res=16021 name=PANEL_JP_MONO_ADJUST.Monochrome Adjustments
:i2 refid=mono.Monochrome Adjustments
:font facename=Helv size=16x9.
:color fc=black.
:p.:hp7.Monochrome Adjustments:ehp7.
:color fc=default.
:font facename=default size=0x0.
.*
:p.This group contains the job properties that can be used to adjust
the appearance of monochrome output&per.
.*
:font facename=Helv size=15x8.
:color fc=black.
:p.:hp2.The following adjustments are available&colon.:ehp2.
:color fc=default.
:font facename=default size=0x0.
.*
:ul compact.
:li. :link reftype=hd res=16024.Darkness:elink.
:eul.
.*
.*==========================================================================*/
.* Job Properties: Color Page                                               */
.*==========================================================================*/
.*
:h1 res=16006 name=PANEL_COLOR.Color Page
:i1 id=color.Color Page
.*
:font facename=Helv size=16x9.
:color fc=black.
:p.:hp7.Color Page:ehp7.
:color fc=default.
:font facename=default size=0x0.
.*
:p.This page contains job properties that adjust the appearance
of color printouts&per.
.*
:font facename=Helv size=16x9.
:color fc=black.
:p.:hp2.This page contains the following job properties&colon.:ehp2.
:color fc=default.
:font facename=default size=0x0.
.*
:p.Click on the name of a job property to see what it does&per.
.*
:ul compact.
:li. :link reftype=hd res=16031.Color Adjustments:elink.
:li. :link reftype=hd res=16035.Tone:elink.
:eul.
.*
.*==========================================================================*/
.* Job Properties: Color: Color Dithering                                   */
.*==========================================================================*/
:h2 res=16030 name=PANEL_JP_COLOR_DITHER.Color Dithering
:i2 refid=color.Color Dithering
:font facename=Helv size=16x9.
:color fc=black.
:p.:hp7.Color Dithering:ehp7.
:color fc=default.
:font facename=default size=0x0.
.*
:p.This group contains the dithering algorithms and settings that effect
certain dithering algorithms&per.
.*
:p.Color dithering is the process of mixing a small set of colors
to produce (simulate) many other colors (e.g. Mixing cyan, magenta, and
yellow in a printer to produce up to 16.7 million colors)&per.
:p.
.*
:font facename=Helv size=15x8.
:color fc=black.
:p.:hp2.The following adjustments are available&colon.:ehp2.
:color fc=default.
:font facename=default size=0x0.
.*
:ul compact.
:li. :link reftype=hd res=16032.Color Dither:elink.
:eul.
.*
:font facename=Helv size=16x9.
:color fc=black.
:p.:hp7.Photo-Quality Printing:ehp7.
:color fc=default.
:font facename=default size=0x0.
.*
:p.For best output results printing "photo-quality" graphics please select
either :link reftype=hd res=16044.:hp1.Steinberg Diffusion:ehp1.:elink.
or :link reftype=hd res=16045.:hp1.Stucki Diffusion:ehp1.:elink. dither
algorithms from the list&per.
.*
:p.See :link reftype=hd res=16032.Color Dither:elink. for more information
about specific algorithms and their effects&per.
.*
.*==========================================================================*/
.* Job Properties: Color: Color Dither                                      */
.*==========================================================================*/
:h2 res=16032 name=PANEL_JP_COLOR_ALGO.Color Dither
:i2 refid=color.Color Dither
:font facename=Helv size=16x9.
:color fc=black.
:p.:hp7.Color Dither:ehp7.
:color fc=default.
:font facename=default size=0x0.
.*
:p.Allows selection of a color dithering algorithm supported by this printer
driver to apply to color printouts&per.
.*
:p.Information about a specific color dither algorithm's relative strengths,
weaknesses, and performance considerations is provided by clicking below on
its name&per.
.*
:font facename=Helv size=16x9.
:color fc=black.
:p.:hp2.Click on any color dither algorithm name for more information&colon.:ehp2.
:color fc=default.
:font facename=default size=0x0.
.*
:ul compact.
:li. :link reftype=hd res=16040.Magic Square:elink.
:li. :link reftype=hd res=16042.4x4 Color Dither:elink.
:li. :link reftype=hd res=16043.8x8 Color Dither:elink.
:li. :link reftype=hd res=16045.Stucki Diffusion:elink.
:li. :link reftype=hd res=16044.Steinberg Diffusion:elink.
:li. :link reftype=hd res=16046.Ordered Squares:elink.
:li. :link reftype=hd res=16048.Void Cluster Diffusion:elink.
.*:li. :link reftype=hd res=16047.Fast Diffusion:elink.
.*:li. :link reftype=hd res=16055.HSV Diffusion:elink.
.*:li. :link reftype=hd res=16055.HSV Bidiffusion:elink.
.*:li. :link reftype=hd res=16056.CMYK Diffusion:elink.
:eul.
.*
:font facename=Helv size=16x9.
:color fc=black.
:p.:hp7.Photo-Quality Printing:ehp7.
:color fc=default.
:font facename=default size=0x0.
.*
:p.For best output results printing "photo-quality" graphics please select
either :link reftype=hd res=16044.:hp1.Steinberg Diffusion:ehp1.:elink. or
:link reftype=hd res=16045.:hp1.Stucki Diffusion:ehp1.:elink. dither
algorithms from the list&per.
.*
.*==========================================================================*/
.* Job Properties: Dither Algorithm : Magic Squares                         */
.*==========================================================================*/
:h2 res=16040 name=PANEL_JP_DITHER_MAGIC.Magic Square
:i2 refid=color.Magic Square
:font facename=Helv size=16x9.
:color fc=black.
:p.:hp7.Magic Square:ehp7.
:color fc=default.
:font facename=default size=0x0.
.*
:p.This is the default color dithering algorithm for this printer driver&per.
.*
:p.The algorithm is based on a tessalation dither that creates a 16x16 square
of randomized values that are used to generate dithered colors&per.
.*
:p.This algorithm accepts adjustments from
the :link reftype=hd res=16007.HSV Page:elink.&per.
.*
:font facename=Helv size=16x9.
:color fc=black.
:p.:hp2.Output Quality&colon.:ehp2.
:color fc=default.
:font facename=default size=0x0.
.*
:p.For most color printouts which contain 256 colors or less, this algorithm
provides very nice output containing barely perceivable patterns&per.
.*
:font facename=Helv size=16x9.
:color fc=black.
:p.:hp2.Performance&colon.:ehp2.
:color fc=default.
:font facename=default size=0x0.
.*
:p.For the output quality, this is by far the fastest algorithm you can choose&per.
.*
:p.Choosing a simpler dithering algorithm will not really produce noticeable
performance increases&per.
.*
:font facename=Helv size=16x9.
:color fc=black.
:p.:hp2.Recommendations&colon.:ehp2.
:color fc=default.
:font facename=default size=0x0.
.*
:p.:hp1.For better performance&colon.:ehp1. try the 4x4 Color Dither or the 8x8 Color Dither&per.
:p.:hp1.For better quality&colon.:ehp1. try the Void Cluster Diffusion algorithm&per.
:p.:hp1.For photo-quality&colon.:ehp1. try Steinberg or Stucki Diffusion&per.
.*
:nt.The Ordered Square algorithm provides similar performance with
slightly different results&per.
:ent.
.*
.*==========================================================================*/
.* Job Properties: Dither Algorithm : 4x4 Color Dither                      */
.*==========================================================================*/
:h2 res=16042 name=PANEL_JP_DITHER_4X4.4x4
:i2 refid=color.4x4 Color Dither
:font facename=Helv size=16x9.
:color fc=black.
:p.:hp7.4x4 Color Dither:ehp7.
:color fc=default.
:font facename=default size=0x0.
.*
:p.This dither uses a set of four-by-four grids for mixing colors
to make other colors&per.
.*
:font facename=Helv size=16x9.
:color fc=black.
:p.:hp2.Output Quality&colon.:ehp2.
:color fc=default.
:font facename=default size=0x0.
.*
:p.Quality is poor for color printouts and the 4-by-4 pattern
can be seen easily&per.
.*
:font facename=Helv size=16x9.
:color fc=black.
:p.:hp2.Performance&colon.:ehp2.
:color fc=default.
:font facename=default size=0x0.
.*
:p.Performance is very good&per.
.*
:font facename=Helv size=16x9.
:color fc=black.
:p.:hp2.Recommendations&colon.:ehp2.
:color fc=default.
:font facename=default size=0x0.
.*
:p.This algorithm is good for printouts with low and normal print quality
and when smooth graphics are not required&per.
:p.For better quality, try 8x8 Color Dither or Magic Square algorithms&per.
.*
.*==========================================================================*/
.* Job Properties: Dither Algorithm : 8x8 Color Dither                      */
.*==========================================================================*/
:h2 res=16043 name=PANEL_JP_DITHER_8X8.8x8 Color Dither
:i2 refid=color.8x8 Color Dither
:font facename=Helv size=16x9.
:color fc=black.
:p.:hp7.8x8 Color Dither:ehp7.
:color fc=default.
:font facename=default size=0x0.
.*
:p.This dither uses a set of eight-by-eight grids for mixing colors
to make other colors&per.
.*
:font facename=Helv size=16x9.
:color fc=black.
:p.:hp2.Output Quality&colon.:ehp2.
:color fc=default.
:font facename=default size=0x0.
.*
:p.Quality is better than the 4x4 Color Dither on color printouts&per.
The 8-by-8 pattern can be seen on printouts, but not as easily as the
4x4 Color Dither's&per.
.*
:font facename=Helv size=16x9.
:color fc=black.
:p.:hp2.Performance&colon.:ehp2.
:color fc=default.
:font facename=default size=0x0.
.*
:p.Performance is very good&per.
.*
:font facename=Helv size=16x9.
:color fc=black.
:p.:hp2.Recommendations&colon.:ehp2.
:color fc=default.
:font facename=default size=0x0.
.*
:p.This algorithm is good for printouts with low and normal print quality
and when smooth graphics are not required&per.
:p.For better quality, try Magic Square or Ordered Square algorithms&per.
.*
.*==========================================================================*/
.* Job Properties: Dither Algorithm : Steinberg Diffusion                   */
.*==========================================================================*/
:h2 res=16044 name=PANEL_JP_DITHER_STEINBERG.Steinberg Diffusion
:i2 refid=color.Steinberg Diffusion
:font facename=Helv size=16x9.
:color fc=black.
:p.:hp7.Steinberg Diffusion:ehp7.
:color fc=default.
:font facename=default size=0x0.
.*
:p.This algorithm is one of the fastest diffusion algorithms around
that produces nice output with printouts containing 16.7 million colors
or less&per.
.*
:font facename=Helv size=16x9.
:color fc=black.
:p.:hp2.Output Quality&colon.:ehp2.
:color fc=default.
:font facename=default size=0x0.
.*
:p.Photo-quality output&per.  However, "snakelike" patterns can be
found through extremely close inspection&per.  For most printouts, this is
not a very important problem&per.
.*
:font facename=Helv size=16x9.
:color fc=black.
:p.:hp2.Performance&colon.:ehp2.
:color fc=default.
:font facename=default size=0x0.
.*
:p.Performance is much slower then Magic Squares and slightly
slower than Void Cluster Diffusion&per.
.*
:font facename=Helv size=16x9.
:color fc=black.
:p.:hp2.Recommendations&colon.:ehp2.
:color fc=default.
:font facename=default size=0x0.
.*
:p.For better quality, try the Stucki Diffusion algorithm&per.
For faster output, try the Void Cluster Diffusion Algorithm&per.
.*
.*==========================================================================*/
.* Job Properties: Dither Algorithm : Stucki Diffusion                      */
.*==========================================================================*/
:h2 res=16045 name=PANEL_JP_DITHER_STUCKI.Stucki Diffusion
:i2 refid=color.Stucki Diffusion
:font facename=Helv size=16x9.
:color fc=black.
:p.:hp7.Stucki Diffusion:ehp7.
:color fc=default.
:font facename=default size=0x0.
.*
:p.This algorithm is one of the fastest diffusion algorithms around
that produces nice output with printouts containing 16.7 million colors
or less&per.
.*
:font facename=Helv size=16x9.
:color fc=black.
:p.:hp2.Output Quality&colon.:ehp2.
:color fc=default.
:font facename=default size=0x0.
.*
:p.Photo-quality output with no discernable patterns&per.
.*
:font facename=Helv size=16x9.
:color fc=black.
:p.:hp2.Performance&colon.:ehp2.
:color fc=default.
:font facename=default size=0x0.
.*
:p.Performance is slower than Void Cluster Diffusion or Steinberg Diffusion&per.
.*
:font facename=Helv size=16x9.
:color fc=black.
:p.:hp2.Recommendations&colon.:ehp2.
:color fc=default.
:font facename=default size=0x0.
.*
:p.For better performance, try Void Cluster Diffusion or Steinberg Diffusion&per.
.*
.*==========================================================================*/
.* Job Properties: Dither Algorithm : Ordered Square                        */
.*==========================================================================*/
:h2 res=16046 name=PANEL_JP_DITHER_ORDERED.Ordered Square
:i2 refid=color.Ordered Square
:font facename=Helv size=16x9.
:color fc=black.
:p.:hp7.Ordered Square:ehp7.
:color fc=default.
:font facename=default size=0x0.
.*
:p.A tessalation dither similar to Magic Square, but the 16x16 square is filled
with random numbers based on a different method&per.
.*
:p.This algorithm accepts adjustments from
the :link reftype=hd res=16007.HSV Page:elink.&per.
.*
:font facename=Helv size=16x9.
:color fc=black.
:p.:hp2.Output Quality&colon.:ehp2.
:color fc=default.
:font facename=default size=0x0.
.*
:p.For most color printouts which contain 256 colors or less, this algorithm
provides very nice output containing barely perceivable patterns&per.
:p.These patterns are slightly different then those seen
with Magic Square and may or may not be more visually appealing&per.
.*
:font facename=Helv size=16x9.
:color fc=black.
:p.:hp2.Performance&colon.:ehp2.
:color fc=default.
:font facename=default size=0x0.
.*
:p.For the output quality, this is by far the fastest algorithm you can choose&per.
.*
:p.Choosing a simpler dithering algorithm will not really produce noticeable
performance increases&per.
.*
:font facename=Helv size=16x9.
:color fc=black.
:p.:hp2.Recommendations&colon.:ehp2.
:color fc=default.
:font facename=default size=0x0.
.*
:p.For printing "photo-quality" images (or images with more than 256 colors),
you should use a diffusion dither algorithm for best results&per. Please
see :link reftype=hd res=16044.:hp1.Steinberg Diffusion:ehp1.:elink. or
 :link reftype=hd res=16045.:hp1.Stucki Diffusion:ehp1.:elink. dither
algorithms&per.
.*
.*==========================================================================*/
.* Job Properties: Dither Algorithm : Void Cluster Diffusion                */
.*==========================================================================*/
:h2 res=16048 name=PANEL_JP_DITHER_CLUSTER.Void Cluster Diffusion
:i2 refid=color.Void Cluster Diffusion
:font facename=Helv size=16x9.
:color fc=black.
:p.:hp7.Void Cluster Diffusion:ehp7.
:color fc=default.
:font facename=default size=0x0.
.*
:p.This is an ordered dither method based on matrix 64X64 of uniformly
distributed random threshold values&per.
.*
:font facename=Helv size=16x9.
:color fc=black.
:p.:hp2.Output Quality&colon.:ehp2.
:color fc=default.
:font facename=default size=0x0.
.*
:p.High quality output with excellent vividness of colours.
Good compromise between quality and performance.
Printouts are a little bit mat&per.
.*
:font facename=Helv size=16x9.
:color fc=black.
:p.:hp2.Performance&colon.:ehp2.
:color fc=default.
:font facename=default size=0x0.
.*
:p.Faster than Stucki and Steinberg methods, slightly slower than others&per.
.*
:font facename=Helv size=16x9.
:color fc=black.
:p.:hp2.Recommendations&colon.:ehp2.
:color fc=default.
:font facename=default size=0x0.
.*
:p.Can be used as draft printouts for photo-style images before
printing the final version with Stucki method&per.
.*==========================================================================*/
.* Job Properties: Dither Algorithm : Fast Diffusion                        */
.*==========================================================================*/
:h2 res=16047 name=PANEL_JP_DITHER_FAST.Fast Diffusion
:i2 refid=color.Fast Diffusion
:font facename=Helv size=16x9.
:color fc=black.
:p.:hp7.Fast Diffusion:ehp7.
:color fc=default.
:font facename=default size=0x0.
.*
:p.This is the fastest diffusion-based dithering algorithm for printouts
containing 16.7 million colors or less&per.
.*
:font facename=Helv size=16x9.
:color fc=black.
:p.:hp2.Output Quality&colon.:ehp2.
:color fc=default.
:font facename=default size=0x0.
.*
:p.Very good, noticeably better than Magic Square&per.
.*
:font facename=Helv size=16x9.
:color fc=black.
:p.:hp2.Performance&colon.:ehp2.
:color fc=default.
:font facename=default size=0x0.
.*
:p.Noticeably slower than Magic Square&per.
.*
:font facename=Helv size=16x9.
:color fc=black.
:p.:hp2.Recommendations&colon.:ehp2.
:color fc=default.
:font facename=default size=0x0.
.*
:p.For better performance, try Magic Square or Ordered Square algorithms&per.
:p.For photo-quality, try Steinberg or Stucki Diffusion algorithms&per.
.*==========================================================================*/
.* Job Properties: Dither Algorithm : HSV Diffusion                         */
.*==========================================================================*/
:h2 res=16055 name=PANEL_JP_DITHER_HSV.HSV Diffusion
:i2 refid=color.HSV Diffusion
:font facename=Helv size=16x9.
:color fc=black.
:p.:hp7.HSV Diffusion:ehp7.
:color fc=default.
:font facename=default size=0x0.
.*
:p.  HSV stands for Hue Saturation and Value.  It is one color system
(another is Red Blue Green).  Dithering algorithms will dither the RGB color
image into many monochrome bitmap.  Dithering algorithms like Stucki and
Steinberg will take the RGB value and snap it into 4 separate Cyan, Magenta,
Yellow, and Black monochrome values (0 or 1).  The difference between what it
actually was and the 0/1 value is the error and that is accumulated and
spread across the monochrome bitmap.  The HSV dithering algorithm will
convert the RGB value into an HSV value and spread only 1 error instead of 4
errors.

:p.HSV diffusion and HSV Bidiffusion differ in which direction the error
is accumulated.  HSV diffusion always travels from right to left.  HSV
bidiffusion travels from right to left on even scan lines and from left
to right on odd scan lines.  This affects how dithering artifacts will
appear on the printed output.

.*==========================================================================*/
.* Job Properties: Dither Algorithm : CMYK Diffusion                        */
.*==========================================================================*/
:h2 res=16056 name=PANEL_JP_DITHER_CMYK.CMYK Diffusion
:i2 refid=color.CMYK Diffusion
:font facename=Helv size=16x9.
:color fc=black.
:p.:hp7.CMYK Diffusion:ehp7.
:color fc=default.
:font facename=default size=0x0.
.*
:p.  CMYK stands for Cyan, Magenta, Yellow, and Black.  It is one color
system (another is Red Blue Green).  Dithering algorithms will dither the RGB
color image into many monochrome bitmap.  Dithering algorithms like Stucki
and Steinberg will take the RGB value and snap it into 4 separate Cyan,
Magenta, Yellow, and Black monochrome values (0 or 1).  The difference
between what it actually was and the 0/1 value is the error and that is
accumulated and spread across the monochrome bitmap.  The CMYK dithering
algorithm will convert the RGB value into a CMYK value and spread only 1
error instead of 4 errors.

.*
.*==========================================================================*/
.* Job Properties: Color: Color Adjustments                                 */
.*==========================================================================*/
:h2 res=16031 name=PANEL_JP_COLOR_ADJUST.Color Adjustments
:i2 refid=color.Color Adjustments
:font facename=Helv size=16x9.
:color fc=black.
:p.:hp7.Color Adjustments:ehp7.
:color fc=default.
:font facename=default size=0x0.
.*
:p.Color adjustments modify the amount of ink the printer driver
tells the printer to apply to the paper&per.
.*
:p.Increasing the Red, Green, Blue, or Black sliders from
zero (the default adjustment) will increase the amount of
that color ink used on color printouts&per.
.*
:p.Decreasing the Red, Green, Blue or Black sliders from
zero (the default adjustment) will decrease the amount of
that color ink used on color printouts&per.
.*
:nt.The default Red, Green, Blue, and Black Slider value is zero (0)&per.
This value was found, on average, to result in the best
color printouts using the currently selected resolution and media type&per.
:ent.
.*
:font facename=Helv size=16x9.
:color fc=black.
:p.:hp2.The following Color Adjustments are available&colon.:ehp2.
:color fc=default.
:font facename=default size=0x0.
.*
:ul compact.
:li.:color fc=red.:color fc=default. :link reftype=hd res=16036.Red Color Adjustment:elink.
:li.:color fc=green.:color fc=default. :link reftype=hd res=16037.Green Color Adjustment:elink.
:li.:color fc=blue.:color fc=default. :link reftype=hd res=16038.Blue Color Adjustment:elink.
:li.:color fc=black.:color fc=default. :link reftype=hd res=16039.Black Color Adjustment:elink.
:eul.
.*
:font facename=Helv size=16x9.
:color fc=black.
:p.:hp2.Background&colon.:ehp2.
:color fc=default.
:font facename=default size=0x0.
.*
:p.Most color printers have been tested at different resolutions on different
media types&per.  Based on these results, the printer driver will automatically
adjust ink values so that ink does not "bleed" (too much ink) and is dark enough
for crisp color output&per.
:p.If your printed output is not satisfactory, these
slider controls are available&per.
.*
.*==========================================================================*/
.* Job Properties: Color: Red Color Adjustment                              */
.*==========================================================================*/
:h2 res=16036 name=PANEL_JP_COLOR_RED.Red Color Adjustments
:i2 refid=color.Red Color Adjustment
:font facename=Helv size=16x9.
.*
:color fc=black.
:p.:hp7.Red Color Adjustment:ehp7.
:color fc=default.
:font facename=default size=0x0.
.*
:p.This slider increases or decreases the amount of inks that make up the
color :color fc=red."red":color fc=default. used on color printouts&per.
.*
.*==========================================================================*/
.* Job Properties: Color: Green Color Adjustment                            */
.*==========================================================================*/
:h2 res=16037 name=PANEL_JP_COLOR_GREEN.Green Color Adjustments
:i2 refid=color.Green Color Adjustment
:font facename=Helv size=16x9.
.*
:color fc=black.
:p.:hp7.Green Color Adjustment:ehp7.
:color fc=default.
:font facename=default size=0x0.
.*
:p.This slider increases or decreases the amount of inks that make up the
color :color fc=green."green":color fc=default. used on color printouts&per.
.*
.*==========================================================================*/
.* Job Properties: Color: Blue Color Adjustment                             */
.*==========================================================================*/
:h2 res=16038 name=PANEL_JP_COLOR_BLUE.Blue Color Adjustments
:i2 refid=color.Blue Color Adjustment
:font facename=Helv size=16x9.
.*
:color fc=black.
:p.:hp7.Blue Color Adjustment:ehp7.
:color fc=default.
:font facename=default size=0x0.
.*
:p.This slider increases or decreases the amount of inks that make up the
color :color fc=blue."blue":color fc=default. used on color printouts&per.
.*
.*==========================================================================*/
.* Job Properties: Color: Black Color Adjustment                             */
.*==========================================================================*/
:h2 res=16039 name=PANEL_JP_COLOR_BLACK.Black Color Adjustments
:i2 refid=color.Black Color Adjustment
:font facename=Helv size=16x9.
.*
:color fc=black.
:p.:hp7.Black Color Adjustment:ehp7.
:color fc=default.
:font facename=default size=0x0.
.*
:p.This slider increases or decreases the amount of inks that make up the
color :color fc=black."black":color fc=default. used on color printouts&per.
.*
.*==========================================================================*/
.* Job Properties: Color: Tone (Red,Green,Blue)                             */
.*==========================================================================*/
:h2 res=16035 name=PANEL_JP_COLOR_TONE.Tone
:i2 refid=color.Tone
:font facename=Helv size=16x9.
.*
:color fc=black.
:p.:hp7.Tone:ehp7.
:color fc=default.
:font facename=default size=0x0.
.*
:p.Increasing the Red, Green or Blue Tone values from
zero causes the respective color's maximum intensity to decrease&per.
.*
:p.Decreasing the Red, Green or Blue Tone increases the
intensity of that color ink on printouts&per.
.*
:nt.The default Red, Green and Blue Tone value is 0&per.
This value was found, on average, to result in the best
color printouts&per.
:ent.
.*
.*==========================================================================*/
.* Job Properties: HSV Page                                                 */
.*==========================================================================*/
.*
:h1 res=16007 name=PANEL_HSV.HSV Page
:i1 id=hsv.HSV Page
.*
:font facename=Helv size=16x9.
:color fc=black.
:p.:hp7.HSV Page:ehp7.
:color fc=default.
:font facename=default size=0x0.
.*
:p.This page is used to adjust Hue, Saturation and Darkness (Vividness)
of color printouts&per.  This page only affects
certain :link reftype=hd res=16032.Color Dither:elink. algorithms
that use an HSV color model&per.
.*
:font facename=Helv size=15x8.
:color fc=black.
:p.:hp2.The following color dither algorithms use HSV Adjustments&colon.:ehp2.
:color fc=default.
:font facename=default size=0x0.
.*
:ul compact.
:li. :link reftype=hd res=16040.Magic Square:elink.
:li. :link reftype=hd res=16046.Ordered Square:elink.
:eul.
.*
:p.Other color dithers currently ignore these settings&per.
.*
:font facename=Helv size=15x8.
:color fc=black.
:p.:hp2.This page contains the following job properties&colon.:ehp2.
:color fc=default.
:font facename=default size=0x0.
.*
:ul compact.
:li. :link reftype=hd res=16050.HSV Adjustments:elink.
:ul compact.
:li. :link reftype=hd res=16051.Hue:elink.
:li. :link reftype=hd res=16052.Saturation:elink.
:li. :link reftype=hd res=16053.Darkness:elink.
:eul.
:eul.
.*
.*==========================================================================*/
.* Job Properties: HSV : HSV Adjustments                                    */
.*==========================================================================*/
.*
:h1 res=16050 name=PANEL_JP_HSV_ADJUST.HSV Adjustments
:i2 refid=hsv.HSV Adjustments
.*
:font facename=Helv size=16x9.
:color fc=black.
:p.:hp7.HSV Adjustments:ehp7.
:color fc=default.
:font facename=default size=0x0.
.*
:p.Contains sliders that affect a color printout's Hue,
Saturation and Darkness (Vividness)&per.
.*
:font facename=Helv size=15x8.
:color fc=black.
:p.:hp2.This group contains the following adjustments&colon.:ehp2.
:color fc=default.
:font facename=default size=0x0.
.*
:ul compact.
:li. :link reftype=hd res=16051.Hue:elink.
:li. :link reftype=hd res=16052.Saturation:elink.
:li. :link reftype=hd res=16053.Darkness:elink.
:eul.
.*
.*==========================================================================*/
.* Job Properties: HSV : Hue                                                */
.*==========================================================================*/
.*
:h1 res=16051 name=PANEL_JP_HSV_HUE.Hue
:i2 refid=hsv.Hue
.*
:font facename=Helv size=16x9.
:color fc=black.
:p.:hp7.Hue:ehp7.
:color fc=default.
:font facename=default size=0x0.
.*
:p.This slider adjusts the hue of color printouts&per.
.*
:p.The default value of 0 degrees preserves the meaning of RGB
colors for printouts&per.  The hue value can be increased or
decreased from 0 degrees causing an RGB color shift
for all colors in a printout&per.
.*
:nt text='Example'. A color which started out red would be
shifted so that it may come out green&per.
:ent.
.*
.*==========================================================================*/
.* Job Properties: HSV : Saturation                                         */
.*==========================================================================*/
.*
:h1 res=16052 name=PANEL_JP_HSV_SATURATION.Saturation
:i2 refid=hsv.Saturation
.*
:font facename=Helv size=16x9.
:color fc=black.
:p.:hp7.Saturation:ehp7.
:color fc=default.
:font facename=default size=0x0.
.*
:p.This slider controls the amount of color ink used on color
printouts&per.
.*
:p.This control adjusts from 0% (default saturation) where
positive adjustments increase the amount of color and negative
adjustments decrease the amount of color&per.
.*
.*==========================================================================*/
.* Job Properties: HSV : Darkness                                           */
.*==========================================================================*/
.*
:h1 res=16053 name=PANEL_JP_HSV_DARKNESS.Darkness (HSV)
:i2 refid=hsv.Darkness (HSV)
.*
:font facename=Helv size=16x9.
:color fc=black.
:p.:hp7.Darkness (HSV):ehp7.
:color fc=default.
:font facename=default size=0x0.
.*
:p.This slider controls the amount of black ink (or ink mixes
that simulate the color black) used on color printouts&per.
.*
:p.This control adjusts from 0% (default Darkness)
where positive adjustments increase the amount of black
and negative adjustments decrease amount of black&per.
.*
:nt.Be careful when increasing saturation or increasing darkness
as more ink will be applied to your paper and may cause paper to
become over-saturated&per.
:ent.
.*
.*==========================================================================*/
.* TRADEMARKS                                                               */
.*==========================================================================*/
.* !!!! NLS - Do not translate - SEE WPINDEX.HLP !!!!                       */
.* LIST BELOW FOLLOWS STYLE IN EXCEPTIONS LETTER FOR ONLINE DOCUMENTATION.  */
.*==========================================================================*/
.*
:h1 res=18000 id=ibmtm.IBM Trademarks
:i1.IBM Trademarks
:p.The following are trademarks of the IBM Corporation&colon.
:sl compact.
:li.IBM
:li.OS/2
:li.OS/2 Warp
:li.PowerPC
:li.IBM OS/2 Omni Printer Driver
:esl.
.*
:h1 res=18010 id=othertm.Non-IBM Trademarks
:p.The following terms, denoted by a double asterisk (**) in this information,
are trademarks of other companies as follows&colon.
:sl compact.
:li.AST is a trademark of AST Research, Incorporated&per.
:li.Adobe is a trademark of Adobe Systems Incorporated&per.
:li.Adobe Type Manager is a trademark of Adobe Systems Incorporated&per.
:li.Digital Research is a trademark of Digital Research, Inc&per.
:li.Epson is a trademark of Seiko Epson Kabushiki Kaisha&per.
:li.Excel is a trademark of Microsoft Corporation&per.
:li.Helvetica is a trademark of the Linotype Company&per.
:li.HP and Hewlett-Packard are trademarks of Hewlett-Packard Company&per.
:li.Intel is a trademark of Intel Corporation&per.
:li.LaserJet is a trademark of Hewlett-Packard Company&per.
:li.Lotus is a trademark of Lotus Development Corporation&per.
:li.Microsoft is a trademark of Microsoft Corporation&per.
:li.PostScript is a trademark of Adobe Systems Incorporated&per.
:li.Times New Roman is a trademark of the Monotype Corporation, Ltd&per.
:li.Windows is a trademark of Microsoft Corporation&per.
:esl.
.* !!!!NLS - Do not translate - SEE WPINDEX.HLP!!!!
.*
:euserdoc.
