/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1992 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 source code is provided to you solely for       */
/*    the purpose of assisting you in your development of OS/2 device        */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Developer Connection Device Driver       */
/*    Source Kit for OS/2. This Copyright statement may not be removed.      */
/*                                                                           */
/*****************************************************************************/
/**************************************************************************
 *
 * SOURCE FILE NAME = VFVDDREQ.C
 *
 * DESCRIPTIVE NAME = Virtual Floppy Device Driver VDD Request Handlers
 *
 *
 *
 * VERSION = V2.0
 *
 * DATE
 *
 * DESCRIPTION  This module contains the VFD's VDD request handlers.
 *
 *
 * FUNCTIONS    SuspendRestartPdd
 *              VFVDDReqProc
 *              VFVDDMotorOff
 *              VFVDDResume
 *              VFVDDReqNoSupport
 *
 *
 * ENTRY POINTS:
 *
 * DEPENDENCIES:
 *
 * NOTES
 *
 *
 * STRUCTURES
 *
 * EXTERNAL REFERENCES
 *
 * EXTERNAL FUNCTIONS
 *
*/

#include "vfdp.h"

#ifdef   VDDSTRICT
MODNAME = __FILE__;
#endif
#pragma  BEGIN_GLOBAL_DATA
extern HVDM hvdmFloppyOwner;                            /* VDM handle of
                                                           floppy owner     */
extern ULONG motor_timeout;                             /* floppy motor
                                                           timeout value    */
                                                        /* @V0024           */
extern FLAGS flFloppy;                                  /* floppy flags     */
extern HVDD hVDDVPIC;                                   /* VDDtoVDD comm to
                                                           VPIC             */
                                                        /* @VD1535          */
extern HVDHSEM hsemFloppyOwnership;                     /* Block simultaneous
                                                           VDMs             */
                                                        /* @VD1535          */
extern VDHSEMSTATE semStateOwned;                       /* Data area fro
                                                           sem info
                                                           deadlock         */
                                                         /* @V9819          */

extern CHAR VfSetIOHookVar;                             /* norton           */
#pragma  END_GLOBAL_DATA
#pragma  BEGIN_SWAP_DATA
extern HHOOK hhooktimerInUseTimeout;                    /* timer hook
                                                           handle for inuse
                                                           timeout          */
extern HIRQ hirq;                                       /* floppy IRQ
                                                           handle           */
extern HHOOK hhookDsktMotorTmr;                         /* Dskt Motor
                                                           TimeOut timer    */
                                                        /* @V0855           */
                                                        /* @V1809           */
#pragma  END_SWAP_DATA
#pragma  BEGIN_INSTANCE_DATA
extern HFILE DeviceHandle,Device_Handle;                /* Handle to
                                                           DevIOCTL calls   */
/* DevIOCTL parms */

extern SUSPENDRESTARTPARM SuspendRestartParmPacket;     /* @VD1535           */
extern ULONG LengthParm,LengthData;                     /* @VD1535           */
extern ULONG ActionTaken;                               /* @VD1535           */
extern CHAR FileName[],File_Name[];                     /* @VD1535           */
                                                        /* @VD1535           */
extern HFILE hRedetermineMedia;                         /* @V3026            */
extern REDETERMINEMEDIAPARM RedetermineMediaParmPacket, /* @VD1535           */

/* SUSPEND/RESTART */

                                                        /* @V3026           */
RedetermineMediaDataPacket;                             /* IOCTL call parm
                                                           packet           */
extern ULONG RedetermineMediaLengthData;                /* @V3026           */

extern HHOOK hhookctxtMotorResume;                      /* hook to call     */
                                                        /* @VD1535          */
                                                        /* Resume from      */
                                                        /* Task time        */
                                                        /* @V3516           */
CHAR AFileName[];                                       /* @V3026           */
#pragma  END_INSTANCE_DATA
#pragma  BEGIN_SWAP_INSTANCE
#pragma  END_SWAP_INSTANCE
#pragma  BEGIN_SWAP_CODE

/****************************************************************************
 *
 * FUNCTION NAME = SuspendRestartPdd
 *
 * DESCRIPTION   =
 *
 *  EP  SuspendRestartPdd() -                              @V1797
 *
 *  This subroutine sends requests to the PDD, directly, w/o going thru the FS
 *
 *  ENTRY
 *      i
 *         0 - Restart the PDD
 *         1 - Suspend the PDD
 *
 *  EXIT-SUCCESS
 *  EXIT-FAILURE
 *  USES
 *
 *  CONTEXT
 *      Task-time
 *
 *  PCODE
 *
 * INPUT         = (UCHAR i)
 *
 * OUTPUT        = NONE
 *
 * RETURN-NORMAL = NONE
 *
 * RETURN-ERROR  = NONE
 *
 ****************************************************************************/

VOID PRIVENTRY SuspendRestartPdd(UCHAR i)
{
  _asm pusha
  _asm pushf
  _asm push ds
  _asm push es
  _asm mov  ch, 08h           ; Cat
  _asm mov  cl, 05Dh          ; Function
  _asm mov  dl, i             ; Suspend/Restart
  _asm xor  al, al            ; Unit number
  DevWOHandle();
  _asm pop  es
  _asm pop  ds
  _asm popf
  _asm popa

}

/****************************************************************************
 *
 * FUNCTION NAME = VFVDDReqProc
 *
 * DESCRIPTION   =
 *
 *  EP  VFVDDReqProc() - VDD Request Handler
 *
 *  This registered subroutine is called by the VTimer to turn off
 *  the floppy motor.
 *
 *  ENTRY
 *      hvdm -> VDM
 *      ulCmd = request command
 *
 *  EXIT-SUCCESS
 *      returns TRUE
 *  EXIT-FAILURE
 *      returns FALSE - VDM is not the owner
 *  USES
 *      32-bit small-model PASCAL calling/register conventions
 *
 *  CONTEXT
 *      VDM Task-time
 *
 *  PCODE
 *      if command is to turn off floppy motor
 *          if requesting VDM is the floppy owner
 *              close the floppy ownership;
 *              turn off the floppy motor;
 *              return TRUE;
 *          else
 *              return FALSE;
 *          endif
 *      endif
 *
 * INPUT         = (HVDM hvdm,ULONG ulCmd,PVOID p1,PVOID p2)
 *
 * OUTPUT        = NONE
 *
 * RETURN-NORMAL = NONE
 *
 * RETURN-ERROR  = NONE
 *
 ****************************************************************************/

LONG EXPENTRY VFVDDReqProc(HVDM hvdm,ULONG ulCmd,PVOID p1,PVOID p2)
{

  switch (ulCmd)
  {
    case  START_BIOS_REQS :                             /* We trust BIOS to   */
                                                        /*   behave so norton */
      VfSetIOHookVar = FALSE;                           /* no need to trap all*/
      break;                                            /* hardware accesses. */

    case  END_BIOS_REQS :                               /* Don't trust apps   */
      VfSetIOHookVar = TRUE;                            /* programming controller. */
      break;                                            /* They might do      */
                                                        /* "strange" things.  */
                                                        /* See VFDATA.C       */
  }                                                     /* endswitch          */
  return  FALSE;
}                                                       /* VFVDDReqProc       */

                                                        /* @V0855             */
/****************************************************************************
 *
 * FUNCTION NAME = VFVDDMotorOff
 *
 * DESCRIPTION   =
 *
 *  EP  VFVDDMotorOff() - VDD Dskt motor Timeout
 *
 *  This subroutine is called in the task context to turn off
 *  the floppy motor after a 2 second timeout.
 *
 *  ENTRY
 *
 *  EXIT-FAILURE
 *
 *  USES
 *      32-bit small-model PASCAL calling/register conventions
 *
 *  CONTEXT
 *      VDM Task-time
 *
 *  PCODE
 *      return FALSE;
 *
 * INPUT         = (PVOID p,PCRF pcrf)
 *
 * OUTPUT        = NONE
 *
 * RETURN-NORMAL = NONE
 *
 * RETURN-ERROR  = NONE
 *
 ****************************************************************************/

VOID HOOKENTRY VFVDDMotorOff(PVOID p,PCRF pcrf)
{
  PRINTTRACE("VFVDDReqProc: motor timeout.\n");

  if (hvdmFloppyOwner != NO_VDM)
  {                                                     /* If someone owns it */
    vfSetIOHookState(hvdmFloppyOwner, TRUE);            /* Start port access traps */

    if (flFloppy&F_PFDWAITING)
    {                                                   /* Physical waiting ? */
      flFloppy &= ~F_PFDWAITING;                        /* not anymore!       */
      PRINTTRACE("VFClearInUse: free floppy ownership to PFD.\n");
    }
    *(PHVDM)VDHQueryHookData(REFHVDM(hvdmFloppyOwner,
                                     HHOOK,
                                     hhookctxtMotorResume)) = hvdmFloppyOwner;

                                                         /* @V3516          */

    VDHArmContextHook(REFHVDM(hvdmFloppyOwner,
                              HHOOK,
                              hhookctxtMotorResume),
                      hvdmFloppyOwner);                  /* @V3516          */
  }                                                      /* @V1797          */

  if (flFloppy&F_TIMEOUTSET)
  {
    flFloppy &= ~F_TIMEOUTSET;                          /* Already timed-out*/
    VDHDisarmTimerHook(hhooktimerInUseTimeout);
  }                                                     /* Clear            */
  flFloppy &= ~(F_FLOPPYINUSE+F_TIMEOUTSETMOTOROFF);    /* We don't own it
                                                           anymore          */

  outp(PORT_DIGITALOUT,
       DO_INTENABLE+DO_NOTFDCRESET);                    /* Motor Off        */
  motor_timeout = MOTOR_TIMEOUT;                        /* Back to standard
                                                           2 sec timeout    */
                                                        /* @V0024           */
  SuspendRestartPdd(0);                                 /* @V1797           */
}                                                       /* VFVDDMotorOff    */

/****************************************************************************
 *
 * FUNCTION NAME = VFVDDResume
 *
 * DESCRIPTION   =
 *
 *    VFVDDResume() -
 *
 *  This subroutine is called in the task context when the Motor goes off.
 *  A Restart IOCTL is issued to give control back to the PDD.
 *
 *  ENTRY
 *      phvdm -> VDM handle
 *  EXIT
 *      None
 *  USES
 *      32-bit small-model PASCAL calling/register conventions
 *
 *  CONTEXT
 *      Task-time
 *
 *
 *
 * INPUT         = (PHVDM phvdm,PCRF pcrf)
 *
 * OUTPUT        = NONE
 *
 * RETURN-NORMAL = NONE
 *
 * RETURN-ERROR  = NONE
 *
 ****************************************************************************/

VOID HOOKENTRY VFVDDResume(PHVDM phvdm,PCRF pcrf)
{
/*  REDETERMINE_MEDIA      @V74056             */      /* Tell FS that
                                                           media needs to
                                                           be redetermined  */
                                                        /* @V8245           */
                                                        /* @V3026           */

     RESTART_PDD(hvdmFloppyOwner)                       /* VDHDevIOCTL
                                                           (restart);       */
        hvdmFloppyOwner = NO_VDM;

  if (flFloppy&F_TIMEOUTSET)
  {
    flFloppy &= ~F_TIMEOUTSET;                          /* Already
                                                           timed-out        */
    VDHDisarmTimerHook(hhooktimerInUseTimeout);
  }                                                     /* Clear            */
}

/****************************************************************************
 *
 * FUNCTION NAME = VFVDDReqNoSupport
 *
 * DESCRIPTION   =
 *
 *  EP  VFVDDReqNoSupport() - VDD Request Handler for no PFD support
 *
 *  This registered subroutine is called by the VTimer to turn off
 *  the floppy motor when there is no VFD support.
 *
 *  ENTRY
 *      hvdm -> VDM
 *      ulCmd = request command
 *
 *  EXIT-FAILURE
 *      returns FALSE - VDM is not the owner
 *  USES
 *      32-bit small-model PASCAL calling/register conventions
 *
 *  CONTEXT
 *      VDM Task-time
 *
 *  PCODE
 *      return FALSE;
 *
 * INPUT         = (HVDM hvdm,ULONG ulCmd,PVOID p1,PVOID p2)
 *
 * OUTPUT        = NONE
 *
 * RETURN-NORMAL = NONE
 *
 * RETURN-ERROR  = NONE
 *
 ****************************************************************************/

LONG EXPENTRY VFVDDReqNoSupport(HVDM hvdm,ULONG ulCmd,PVOID p1,PVOID p2)
{
  AssertTRUE(ulCmd == VFVDDREQ_MOTOROFF);
  return  FALSE;
}                                                       /* VFVDDReqProc     */
#pragma  END_SWAP_CODE

