/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1992 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 source code is provided to you solely for       */
/*    the purpose of assisting you in your development of OS/2 device        */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Developer Connection Device Driver       */
/*    Source Kit for OS/2. This Copyright statement may not be removed.      */
/*                                                                           */
/*****************************************************************************/
/**************************************************************************
 *
 * SOURCE FILE NAME = VFDP.H
 *
 * DESCRIPTIVE NAME = Virtual Floppy Private Definitions
 *
 *
 *
 * VERSION = V2.0
 *
 * DATE
 *
 * DESCRIPTION VFD private constants, types, and function prototypes
 *
 *
 * FUNCTIONS
 *
 * ENTRY POINTS:
 *
 * DEPENDENCIES:
 *
 * NOTES
 *
 *
 * STRUCTURES
 *
 * EXTERNAL REFERENCES
 *
 * EXTERNAL FUNCTIONS
 *
*/

#include <mvdm.h>
#include <floppy.h>
#include <vfdpfd.h>
#include <vfdvdd.h>

/* Interrupt manager function prototypes*/

extern VOID PASCAL INTSetVDMIRQ(IRQN);
                                                       /*                   */
extern VOID PASCAL INTUnsetVDMIRQ(IRQN);               /*                   */
extern VOID far PASCAL DevWOHandle();                  /* @V1797            */

/*
** Private constants
*/

#define  NO_VDM        (HVDM)(-1)
#define  TIMEOUT_INUSE 1000                /* floppy inuse timeout in msec  */

#define  MOTOR_TIMEOUT 2000                /* floppy inuse timeout in msec  */
                                                       /* @V0855            */

#define  LONG_MOTOR_TIMEOUT 6000    /* floppy inuse timeout in msec nbackup */
                                                       /* @V0024            */
#define  UNDEF_BYTE    0xff
#define  DSKT_RESTART  0                               /* @VD1535 IOCTL     */
#define  DSKT_SUSPEND  1                               /* @VD1535 IOCTL     */
#define  DSKT_IODC_QD  0X005d                          /* @VD1535 IOCTL     */
#define  DSKT_REDETERMINE_MEDIA 2                      /* @V3026            */
#define  DSKT_LOCK     0                               /* @V3026            */
#define  DSKT_UNLOCK   1                               /* @V3026            */
#define  IOCTL_DISK    0x0008                          /* @VD1535 IOCTL     */
#define  VFLPY_INVALID_FUNCTION 1                      /* @VD1535 IOCTL     */
#define  VPIC_NAME     "VPIC"                          /* @VD1535 IOCTL     */

/* Flags for flFloppy */

#define  F_FLOPPYINUSE 0x01
#define  F_PFDWAITING  0x02
#define  F_WAITINGPFD  0x04
#define  F_TIMEOUTSET  0x08
#define  F_TIMEOUTSETMOTOROFF 0x10                     /* @V0855            */

/*
** Private function prototypes
*/

/* vfinit.c */

BOOL EXPENTRY VDDInit(PSZ);

/* vfuser.c */

BOOL HOOKENTRY VFExit(VOID);
BOOL HOOKENTRY VFCreate(HVDM);
BOOL HOOKENTRY VFCreateNoSupport(HVDM);
BOOL HOOKENTRY VFTerminate(HVDM);

/* vfevent.c */

SBOOL VDDENTRY VFPFDEventProc(ULONG,F16PVOID,F16PVOID);
VOID HOOKENTRY VFInterruptEvent(PHVDM,PCRF);
ULONG HOOKENTRY VFDMAMaskEvent(HVDM,ULONG);
VOID HOOKENTRY VFEOIProc(PCRF);

/* vfio.c */

BYTE HOOKENTRY VFPortInput(ULONG,PCRF);
VOID HOOKENTRY VFPortOutput(BYTE,ULONG,PCRF);

#ifndef  NOMOTORTRAP
VOID HOOKENTRY VFPortDO(BYTE,ULONG,PCRF);
#endif
BYTE HOOKENTRY VFNoSupportIn(ULONG,PCRF);
VOID HOOKENTRY VFNoSupportOut(BYTE,ULONG,PCRF);
VOID PRIVENTRY vfOpenFloppy(HVDM);
VOID PRIVENTRY vfCloseFloppy(HVDM);
VOID HOOKENTRY VFClearInUse(PVOID,PCRF);
VOID HOOKENTRY VFWaitInUse(PHVDM,PCRF);
VOID HOOKENTRY VFWaitPFD(PHVDM,PCRF);
VOID PRIVENTRY vfSetIOHookState(HVDM,BOOL);

/*
** @VD1535 BOOL    HOOKENTRY VFVDMsWaiting( HVDM hvdm, ULONG ulData);
** vfvddreq.c
*/

LONG EXPENTRY VFVDDReqProc(HVDM,ULONG,PVOID,PVOID);
VOID HOOKENTRY VFVDDMotorOff();                        /* @V0855            */
LONG EXPENTRY VFVDDReqNoSupport(HVDM,ULONG,PVOID,PVOID);
VOID HOOKENTRY VFVDDResume(PHVDM,PCRF);/* @VD1535 Call IOCTL Resume at task */
                                                        /* time             */

/*
** Random macro support
**
**   If VDDSTRICT is defined, the Assert macros generate appropriate code.
**
**   If VDDSTRICT is not defined, the Assert macros are NO-OPs (with the
**   exception of AssertRC, in which case the function is still called, but
**   the return code is not checked).
**
**   If VDDDEBUG is defined, debug printfs (PRINTDEBUGs) are generated, and
**   failed assertions (assuming VDDSTRICT is defined) break at the assertion
**   rather than in the kernel's "panic" service.  VDDDEBUG requires the
**   kernel debugger, in other words.
**
**   If VDDDEBUG is not defined, debug printfs (PRINTDEBUGs) are NOT
**   generated, and failed assertions (assuming VDDSTRICT is defined) simply
**   panics.
*/

#define  PRINTTRACE                                    /*                   */

#ifdef   VDDSTRICT

/* c-begin */

extern CHAR szAssertMsg[];
  #define  MODNAME       static CHAR szFile[]

#ifdef VDDDEBUG

#define Assert(t) { \
                    if (!(t)) { \
                      PRINTDEBUG(szAssertMsg, szFile, __LINE__); \
                      INT3(); \
                    } \
                  }
#else
#define Assert(t) { \
                    if (!(t)) { \
                      PANIC(szAssertMsg, szFile, __LINE__); \
                    } \
                  }
#endif

  #define  AssertTRUE(t) Assert(t)
  #define  AssertFALSE(t) Assert(!(t))
  #define  AssertZERO(t) Assert(!(t))
  #define  AssertNONZERO(t)Assert(t)
 #define  AssertRC(t)   Assert(t)    /* verify function return code good   */

/* c-end */

#else

/* c-begin */

#define    Assert(t)
 #define  AssertTRUE(t)
 #define  AssertFALSE(t)
 #define  AssertZERO(t)
 #define  AssertNONZERO(t)
 #define  AssertRC(t)   (t)        /* perform function, but don't verify   */

/* c-end */

#endif

/*
** Random debugging support
*/

#ifdef   VDDDEBUG

/* c-begin */

extern CHAR szModule[];
  #undef   PRINTDEBUG
  #define  PRINTDEBUG    printf(szModule);                                 \
                         printf
/* c-end */

#ifdef     VDDTRACE
    #undef   PRINTTRACE
    #define  PRINTTRACE    printf(szModule);                               \
                           printf
  #endif
#endif

/* @VD1535 */

/*
**  IOCTL structures used when there is no PDD support
**
**    These structures define Parameter and Data packet formats
**    used in IOCTL calls.
**
*/

/* @VD1535 */

typedef struct SuspendRestartParm_s
{
  UCHAR Command,  DriveNum;
} SUSPENDRESTARTPARM;

typedef SUSPENDRESTARTPARM *PSUSPENDRESTARTPARM;
typedef struct RedetermineMediaParm_s
{                                                      /* @V3026            */
  UCHAR Command;                                       /* @V3026            */
} REDETERMINEMEDIAPARM;
                                                       /* @V3026            */
typedef REDETERMINEMEDIAPARM *PREDETERMINEMEDIAPARM;   /* @V3026            */


#define RESTART_PDD( hvdm) { \
     INTUnsetVDMIRQ( FLPY_IRQ);                                 \
     VDHRequestVDD(hVDDVPIC,hvdm,2,NULL,NULL);                  \
     SuspendRestartParmPacket.Command = DSKT_RESTART;           \
     LengthParm = sizeof(SuspendRestartParmPacket);             \
     SuspendRestartParmPacket.DriveNum=0;                       \
     VDHDevIOCtl ( DeviceHandle, IOCTL_DISK, DSKT_IODC_QD, &SuspendRestartParmPacket, LengthParm, &LengthParm, NULL, NULL, NULL);   \
     VDHClose( DeviceHandle);                                   \
     VDHQuerySem(hsemFloppyOwnership, &semStateOwned);          \
     if ( semStateOwned.vss_fOwned ) VDHReleaseMutexSem( hsemFloppyOwnership);                  \
   }


#define SUSPEND_PDD( hvdm) { \
     SuspendRestartParmPacket.Command = DSKT_SUSPEND;      \
     VDHRequestVDD(hVDDVPIC,hvdm,1,NULL,NULL);             \
     LengthParm = sizeof(SuspendRestartParmPacket);        \
     SuspendRestartParmPacket.DriveNum=0;                  \
     VDHOpen( FileName, &DeviceHandle, &ActionTaken, 0L, 0L, VDHOPEN_ACTION_OPEN_IF_EXISTS,            \
              VDHOPEN_FLAGS_FAIL_ON_ERROR+VDHOPEN_FLAGS_DASD+ VDHOPEN_SHARE_DENYNONE+VDHOPEN_ACCESS_READWRITE, NULL);                                             \
     VDHDevIOCtl ( DeviceHandle, IOCTL_DISK, DSKT_IODC_QD, &SuspendRestartParmPacket, LengthParm, &LengthParm, NULL, NULL, NULL);  \
     INTSetVDMIRQ( FLPY_IRQ);                              \
  }
 /* @V3026  */

#define REDETERMINE_MEDIA {                                                                                                                          \
     RedetermineMediaParmPacket.Command = NULL;                                                                                                      \
     RedetermineMediaDataPacket.Command = NULL;                                                                                                      \
     RedetermineMediaLengthData = sizeof(RedetermineMediaParmPacket);                                                                                \
     for ( AFileName[0]='A'; (AFileName[0]-'A') <= ((VDMBase.rb_fsEquip & 0xC0)>>6); AFileName[0]++) {                                               \
         if (VDHOpen( AFileName, &hRedetermineMedia, &ActionTaken, 0L, 0L, VDHOPEN_ACTION_OPEN_IF_EXISTS,                                            \
                      VDHOPEN_FLAGS_DASD+VDHOPEN_SHARE_DENYREADWRITE+VDHOPEN_FLAGS_FAIL_ON_ERROR, NULL) )                                            \
            {                                                                                                                                        \
              if (VDHDevIOCtl ( hRedetermineMedia, IOCTL_DISK, DSKT_LOCK, &RedetermineMediaParmPacket, RedetermineMediaLengthData,                   \
                               &RedetermineMediaLengthData, &RedetermineMediaDataPacket, RedetermineMediaLengthData, &RedetermineMediaLengthData) )  \
                  {                                                                                                                                  \
                     VDHDevIOCtl( hRedetermineMedia, IOCTL_DISK, DSKT_REDETERMINE_MEDIA, &RedetermineMediaParmPacket, RedetermineMediaLengthData,    \
                                 &RedetermineMediaLengthData, &RedetermineMediaDataPacket, RedetermineMediaLengthData, &RedetermineMediaLengthData); \
                     VDHDevIOCtl( hRedetermineMedia, IOCTL_DISK, DSKT_UNLOCK, &RedetermineMediaParmPacket, RedetermineMediaLengthData,               \
                                 &RedetermineMediaLengthData, &RedetermineMediaDataPacket, RedetermineMediaLengthData, &RedetermineMediaLengthData); \
                  }                                                                                                                                  \
              VDHClose( hRedetermineMedia);                                                                                                          \
            }                                                                                                                                        \
     }                                                                                                                                               \
}/* @VD1535 */
