/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1992 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 source code is provided to you solely for       */
/*    the purpose of assisting you in your development of OS/2 device        */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Developer Connection Device Driver       */
/*    Source Kit for OS/2. This Copyright statement may not be removed.      */
/*                                                                           */
/*****************************************************************************/
/**************************************************************************
 *
 * SOURCE FILE NAME = VDSKIO.C
 *
 * DESCRIPTIVE NAME = VDSK I/O hooks
 *
 *
 *
 * VERSION = V2.0
 *
 * DATE
 *
 * DESCRIPTION
 *
 *          This module contains all the VDSK's I/O port handlers.
 *
 *          In this version, direct disk port accesses by VDMs
 *          are not supported.  All such accesses are trapped
 *          and the offended VDM is terminated.
 *
 *
 * FUNCTIONS         VDSKReadPort
 *                   VDSKWritePort
 *
 *
 * ENTRY POINTS:
 *
 * DEPENDENCIES:
 *
 * NOTES
 *
 *
 * STRUCTURES
 *
 * EXTERNAL REFERENCES
 *
 * EXTERNAL FUNCTIONS
 *
*/

#include <mvdm.h>
#include "vdskp.h"

#ifdef   VDDSTRICT
MODNAME = __FILE__;
#endif
#pragma  BEGIN_SWAP_CODE


/****************************************************************************
 *
 * FUNCTION NAME = VDSKReadPort
 *
 * DESCRIPTION   =
 *
 *  LP  VDSKReadPort - Byte input handler
 *
 *      Byte input handler for VDSK ports.
 *      See 8086 Emulation for complete semantics.
 *
 *      This registered subroutine is called whenever byte input
 *      is performed on any disk ports.
 *
 *      ENTRY
 *          ulPort - port address
 *          pcrf   - pointer to client register frame
 *
 *      EXIT
 *          return data read
 *
 *      CONTEXT
 *          VDM Task-time
 *
 *      PSEUDOCODE
 *          call VDHPopup to display unsupport I/O message;
 *          call VDHKillVDM to terminate VDM;
 *          return UNDEF_BYTE;
 *
 * INPUT         = (ULONG ulPort,PCRF pcrf)
 *
 * OUTPUT        = NONE
 *
 * RETURN-NORMAL = NONE
 *
 * RETURN-ERROR  = NONE
 *
 ****************************************************************************/


BYTE HOOKENTRY VDSKReadPort(ULONG ulPort,PCRF pcrf)
{
  PRINTDEBUG("VDSK: unsupported port read at 0x%04lx\n",
             ulPort);
  return  UNDEF_BYTE;
}                                      /* VDSKReadPort                       */


/****************************************************************************
 *
 * FUNCTION NAME = VDSKWritePort
 *
 * DESCRIPTION   =
 *
 *  LP  VDSKWritePort - Byte output handler
 *
 *      Byte output handler for VDSK ports.
 *      See 8086 Emulation for complete semantics.
 *
 *      This registered subroutine is called whenever byte output
 *      is performed on any disk ports.
 *
 *      ENTRY
 *          bOutData - data to be written to I/O port
 *          ulPort   - port address
 *          pcrf     - pointer to client register frame
 *
 *      EXIT
 *          None
 *
 *      CONTEXT
 *          VDM Task-time
 *
 *      PSEUDOCODE
 *          call VDHPopup to display unsupport I/O message;
 *          call VDHKillVDM to terminate VDM;
 *
 * INPUT         = (BYTE bOutData,ULONG ulPort,PCRF pcrf)
 *
 * OUTPUT        = NONE
 *
 * RETURN-NORMAL = NONE
 *
 * RETURN-ERROR  = NONE
 *
 ****************************************************************************/


VOID HOOKENTRY VDSKWritePort(BYTE bOutData,ULONG ulPort,PCRF pcrf)
{
  PRINTDEBUG("VDSK: unsupported port write at 0x%04lx (0x%02x)\n",
             ulPort,
             bOutData);
}                                      /* VDSKWritePort                      */
#pragma  END_SWAP_CODE
